/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.web.anole.image;

import com.kingdee.bos.web.anole.image.Encoder;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class PNGEncoder
extends Encoder {
    public PNGEncoder(Image image) {
        super(image);
    }

    public boolean encode(OutputStream os) {
        boolean flags = false;
        try {
            BufferedImage bImage = null;
            bImage = this.image instanceof BufferedImage ? (BufferedImage)this.image : this.toBufferedImage(this.image);
            flags = ImageIO.write((RenderedImage)bImage, "png", os);
            os.flush();
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return flags;
    }

    private BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        int type = this.hasAlpha(image) ? 1 : 2;
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        Graphics2D g = bufferedImage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bufferedImage;
    }

    private boolean hasAlpha(Image image) {
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return pg.getColorModel().hasAlpha();
    }
}

