/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.web.anole.image;

import com.kingdee.bos.web.anole.image.Encoder;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.OutputStream;

public class WBMPEncoder
extends Encoder {
    private int width;
    private int height;
    private int[] buffer;
    private static int DIFFUSE_FACTOR = 30;

    public WBMPEncoder(Image image) {
        super(image);
    }

    public boolean encode(OutputStream os) {
        this.width = this.image.getWidth(null);
        this.height = this.image.getHeight(null);
        this.buffer = new int[this.width * this.height];
        try {
            PixelGrabber pixelgrabber = new PixelGrabber(this.image.getScaledInstance(this.width, this.height, 1), 0, 0, this.width, this.height, this.buffer, 0, this.width);
            pixelgrabber.grabPixels();
            this.makeDiff(this.buffer, this.width, this.height, DIFFUSE_FACTOR, Color.WHITE, false);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return this.save(this.buffer, this.width, this.height, DIFFUSE_FACTOR, os);
    }

    private void makeDiff(int[] ai, int i, int j, int k, Color color, boolean flag) {
        double[] ad = new double[i * j];
        int l = 0;
        while (l < i * j) {
            ad[l] = this.greypixel(ai[l]);
            ++l;
        }
        double d = 42.0;
        int i1 = 0;
        while (i1 < j) {
            int j1 = 0;
            while (j1 < i) {
                double d1 = ad[i1 * i + j1];
                ad[i1 * i + j1] = ad[i1 * i + j1] > (double)k ? 255.0 : 0.0;
                double d2 = d1 - ad[i1 * i + j1];
                if (j1 < i - 1) {
                    ad[i1 * i + j1 + 1] = ad[i1 * i + j1 + 1] + 8.0 / d * d2;
                }
                if (j1 < i - 2) {
                    ad[i1 * i + j1 + 2] = ad[i1 * i + j1 + 2] + 4.0 / d * d2;
                }
                if (i1 < j - 1 && j1 > 1) {
                    ad[(i1 + 1) * i + j1 - 2] = ad[(i1 + 1) * i + j1 - 2] + 2.0 / d * d2;
                }
                if (i1 < j - 1 && j1 > 0) {
                    ad[(i1 + 1) * i + j1 - 1] = ad[(i1 + 1) * i + j1 - 1] + 4.0 / d * d2;
                }
                if (i1 < j - 1) {
                    ad[(i1 + 1) * i + j1] = ad[(i1 + 1) * i + j1] + 8.0 / d * d2;
                }
                if (i1 < j - 1 && j1 < i - 1) {
                    ad[(i1 + 1) * i + j1 + 1] = ad[(i1 + 1) * i + j1 + 1] + 4.0 / d * d2;
                }
                if (i1 < j - 1 && j1 < i - 2) {
                    ad[(i1 + 1) * i + j1 + 2] = ad[(i1 + 1) * i + j1 + 2] + 2.0 / d * d2;
                }
                if (i1 < j - 2 && j1 > 1) {
                    ad[(i1 + 2) * i + j1 - 2] = ad[(i1 + 2) * i + j1 - 2] + 1.0 / d * d2;
                }
                if (i1 < j - 2 && j1 > 0) {
                    ad[(i1 + 2) * i + j1 - 1] = ad[(i1 + 2) * i + j1 - 1] + 2.0 / d * d2;
                }
                if (i1 < j - 2) {
                    ad[(i1 + 2) * i + j1] = ad[(i1 + 2) * i + j1] + 4.0 / d * d2;
                }
                if (i1 < j - 2 && j1 < i - 1) {
                    ad[(i1 + 2) * i + j1 + 1] = ad[(i1 + 2) * i + j1 + 1] + 2.0 / d * d2;
                }
                if (i1 < j - 2 && j1 < i - 2) {
                    ad[(i1 + 2) * i + j1 + 2] = ad[(i1 + 2) * i + j1 + 2] + 1.0 / d * d2;
                }
                ++j1;
            }
            ++i1;
        }
        int k1 = 0;
        while (k1 < i * j) {
            int l1 = (int)ad[k1];
            ai[k1] = !flag ? ("1".equals(this.handlesinglepixel(l1, k)) ? color.getRGB() : Color.black.getRGB()) : ("1".equals(this.handlesinglepixel(l1, k)) ? Color.black.getRGB() : color.getRGB());
            ++k1;
        }
    }

    private int greypixel(int i) {
        int j = i >> 24 & 0xFF;
        int k = i >> 16 & 0xFF;
        int l = i >> 8 & 0xFF;
        int i1 = i & 0xFF;
        return (k + l + i1) / 3;
    }

    private String handlesinglepixel(int i, int j) {
        int k = i >> 24 & 0xFF;
        int l = i >> 16 & 0xFF;
        int i1 = i >> 8 & 0xFF;
        int j1 = i & 0xFF;
        if ((l + i1 + j1) / 3 > j) {
            return "1";
        }
        return "0";
    }

    private boolean save(int[] ai, int width, int height, int factor, OutputStream outputstream) {
        try {
            outputstream.write(0);
            outputstream.write(0);
            this.writeMultiByteInteger(outputstream, width);
            this.writeMultiByteInteger(outputstream, height);
            String s = "";
            int l = 0;
            while (l < height) {
                int i1 = 0;
                while (i1 < width) {
                    if ((s = String.valueOf(s) + this.handlesinglepixel(ai[l * width + i1], factor)).length() == 8) {
                        outputstream.write(Integer.parseInt(s, 2));
                        s = "";
                    }
                    ++i1;
                }
                if (s.length() > 0) {
                    int j1 = 8 - s.length();
                    int k1 = 0;
                    while (k1 < j1) {
                        s = String.valueOf(s) + "0";
                        ++k1;
                    }
                    outputstream.write(Integer.parseInt(s, 2));
                    s = "";
                }
                ++l;
            }
            outputstream.close();
        }
        catch (NumberFormatException _ex) {
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    private void writeMultiByteInteger(OutputStream outputstream, int i) throws IOException {
        String s = Integer.toBinaryString(i);
        int j = s.length();
        int k = j / 7;
        if (j % 7 != 0) {
            ++k;
        }
        int[] ai = new int[k];
        int l = j;
        int i1 = k - 1;
        while (i1 >= 0) {
            StringBuffer stringbuffer = new StringBuffer("");
            int k1 = 0;
            while (k1 < 7) {
                if (--l < 0) {
                    stringbuffer.insert(0, '0');
                } else {
                    stringbuffer.insert(0, s.charAt(l));
                }
                ++k1;
            }
            if (i1 == k - 1) {
                stringbuffer.insert(0, '0');
            } else {
                stringbuffer.insert(0, '1');
            }
            ai[i1] = Integer.parseInt(stringbuffer.toString(), 2);
            --i1;
        }
        int j1 = 0;
        while (j1 < ai.length) {
            outputstream.write(ai[j1]);
            ++j1;
        }
    }
}

