/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.web.anole.plaf.html;

import com.kingdee.bos.web.anole.controls.KDComponent;
import com.kingdee.bos.web.anole.controls.KDFrame;
import com.kingdee.bos.web.anole.controls.KDRootPane;
import com.kingdee.bos.web.anole.image.ImageManager;
import com.kingdee.bos.web.anole.output.OutputElement;
import com.kingdee.bos.web.anole.plaf.RootPaneUI;

public class HtmlRootPaneUI
extends RootPaneUI {
    public void paint(KDComponent c) {
        super.paint(c);
        KDRootPane rootPane = (KDRootPane)c;
        KDFrame frame = (KDFrame)rootPane.getParent();
        OutputElement element = this.createRootPane(frame);
        element.add(this.createContentPane(frame));
        this.parentElement.add(element);
    }

    protected OutputElement createRootPane(KDFrame frame) {
        KDComponent contentPane = (KDComponent)frame.getRootPane().getContentPane();
        OutputElement element = new OutputElement("body");
        if (contentPane.getBackground() != null) {
            element.addAttribute("bgcolor", contentPane.getBackground().toHexString());
        }
        if (contentPane.getBackgroundImage() != null) {
            String fileName = ImageManager.putImageURL(contentPane.getBackgroundImage());
            element.addAttribute("background", String.valueOf(fileName) + "." + "kdpng");
        }
        return element;
    }

    protected OutputElement createContentPane(KDFrame frame) {
        KDComponent contentPane = (KDComponent)frame.getRootPane().getContentPane();
        OutputElement contentE = new OutputElement("form");
        contentE.addAttribute("id", contentPane.getIdentifier());
        contentE.addAttribute("name", contentPane.getIdentifier());
        contentE.addAttribute("method", "POST");
        contentE.addAttribute("action", frame.getAppInstance().getName());
        this.addEventElement(frame, contentE);
        if (contentPane.getLayout() != null) {
            contentPane.getLayout().layoutContainer(contentPane);
        }
        this.renderChildren(contentPane, contentE);
        return contentE;
    }

    protected void addEventElement(KDFrame frame, OutputElement contentE) {
        OutputElement eEventTarget = this.getHiddenInput("__EVENTTARGET", "");
        OutputElement eEventType = this.getHiddenInput("__EVENTTYPE", "");
        OutputElement eEventArgument = this.getHiddenInput("__EVENTARGUMENT", "");
        OutputElement eEventCurWin = this.getHiddenInput("__EVENTCURWIN", frame.getIdentifier());
        contentE.add(eEventTarget);
        contentE.add(eEventType);
        contentE.add(eEventArgument);
        contentE.add(eEventCurWin);
    }

    protected OutputElement getHiddenInput(String strName, String strValue) {
        OutputElement ele = new OutputElement("input", 0);
        ele.addAttribute("type", "hidden");
        ele.addAttribute("name", strName);
        ele.addAttribute("id", strName);
        ele.addAttribute("value", strValue);
        return ele;
    }
}

