/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.web.anole.plaf.wml;

import com.kingdee.bos.web.anole.controls.KDComponent;
import com.kingdee.bos.web.anole.controls.KDDial;
import com.kingdee.bos.web.anole.output.OutputElement;
import com.kingdee.bos.web.anole.plaf.ChartUI;
import com.kingdee.bos.web.anole.runtime.ChartTaker;
import com.kingdee.bos.web.anole.runtime.MobileCapabilities;
import java.util.Locale;
import java.util.ResourceBundle;

public class WmlDialUI
extends ChartUI {
    public void paint(KDComponent c) {
        super.paint(c);
        KDDial dial = (KDDial)c;
        ChartTaker.getInstance().add(dial);
        OutputElement element = new OutputElement();
        MobileCapabilities mobileCaps = (MobileCapabilities)dial.getAppInstance().getBrowserCaps();
        if (mobileCaps.getPreferredImageMime().equals("image/vnd.wap.wbmp")) {
            this.createTextDisplay(dial, element);
        } else if (mobileCaps.getPreferredImageMime().equals("image/png")) {
            this.createPngDisplay(dial, element);
        }
        this.parentElement.add(element);
    }

    private void createPngDisplay(KDDial dial, OutputElement element) {
        element.setName("img");
        element.setClosingTagRequired(2);
        element.addAttribute("id", dial.getIdentifier());
        element.addAttribute("width", dial.getWidth());
        element.addAttribute("height", dial.getHeight());
        element.addAttribute("alt", dial.getTitle());
        String src = String.valueOf(dial.getIdentifier()) + "." + "kddial" + "?" + "imagetype" + "=" + "png";
        element.addAttribute("src", src);
    }

    private void createTextDisplay(KDDial dial, OutputElement element) {
        Locale currentLocale = dial.getAppInstance().getLocaleInfo().getLocale();
        ResourceBundle myResources = ResourceBundle.getBundle("com.kingdee.bos.web.anole.resource.AnoleFrameworkBundle", currentLocale);
        OutputElement eleTitle = new OutputElement();
        eleTitle.setText(String.valueOf(dial.getTitle()) + myResources.getString("dial") + " <br/>");
        OutputElement eleCur = new OutputElement();
        eleCur.setText(String.valueOf(myResources.getString("currentvalue")) + " " + dial.getValue() + " /" + dial.getRange().getUpperBound() + "<br/> ");
        element.add(eleTitle);
        element.add(eleCur);
    }
}

