/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.web.anole.runtime;

import com.kingdee.bos.web.anole.runtime.HttpBrowserCapabilities;
import com.kingdee.bos.web.anole.utils.RegEx;
import com.kingdee.bos.web.anole.xmlparser.TreeNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class FrameworkConfig {
    private TreeNode rootNode = null;
    private Map baseUIMap = null;
    private HttpBrowserCapabilities browserCaps = null;

    public FrameworkConfig(TreeNode root) {
        this.rootNode = root;
        this.loadUIConfig();
    }

    public String findUIClassName(String key, String version, String perfect) {
        String strUIName = null;
        TreeNode deviceNode = this.findDeviceNode(key);
        TreeNode uiVerNode = this.findVersionNode(deviceNode, version);
        if (uiVerNode != null) {
            strUIName = uiVerNode.getBody();
        }
        if (strUIName == null || strUIName.equals("")) {
            strUIName = (String)this.baseUIMap.get(perfect);
        }
        if (strUIName == null) {
            strUIName = "com.kingdee.bos.web.anole.plaf.html.HtmlLookAndFeel";
        }
        return strUIName;
    }

    private void preLoadConfig() {
        this.loadUIConfig();
    }

    private void loadUIConfig() {
        this.baseUIMap = new HashMap();
        TreeNode baseUIRoot = this.rootNode.findChildByName("baseLook");
        Iterator items = baseUIRoot.findChildren();
        while (items.hasNext()) {
            TreeNode item = (TreeNode)items.next();
            String strKey = item.findAttribute("key");
            String strValue = item.getBody();
            this.baseUIMap.put(strKey, strValue);
        }
    }

    private TreeNode findUIRootNode() {
        TreeNode node = this.rootNode.findChildByName("customLook");
        return node;
    }

    private TreeNode findDeviceNode(String key) {
        TreeNode deviceNode = this.findUIRootNode().findChildByKey(key);
        return deviceNode;
    }

    private TreeNode findVersionNode(TreeNode deviceNode, String version) {
        if (deviceNode == null) {
            return null;
        }
        Iterator items = deviceNode.findChildrenByName("version");
        while (items.hasNext()) {
            TreeNode item = (TreeNode)items.next();
            if (!RegEx.match(item.findAttribute("match"), version)) continue;
            return item;
        }
        return null;
    }
}

