/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.web.anole.runtime;

import com.kingdee.bos.web.anole.runtime.Application;
import com.kingdee.bos.web.anole.runtime.ApplicationFactory;
import com.kingdee.bos.web.anole.runtime.DeviceCapsConfig;
import com.kingdee.bos.web.anole.runtime.FrameworkConfig;
import com.kingdee.bos.web.anole.utils.AnoleResourceBundle;
import com.kingdee.bos.web.anole.utils.Log4j;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class SessionApplicationFactory
extends ApplicationFactory {
    private static Object objLock = new Object();
    private Logger logger = Log4j.getInstance();
    private ResourceBundle myResources = AnoleResourceBundle.getInstance();

    public SessionApplicationFactory(ServletContext servletContext, DeviceCapsConfig deviceCapsConfig, FrameworkConfig jspxConfig) {
        super(servletContext, deviceCapsConfig, jspxConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Application findApplication(HttpServletRequest request) {
        String appName = String.valueOf(request.getContextPath()) + request.getServletPath();
        this.logger.debug((Object)(String.valueOf(request.getRemoteAddr()) + this.myResources.getString("requestapp") + appName));
        Application app = null;
        HttpSession session = request.getSession(true);
        if (session.isNew() || session.getAttribute(appName) == null) {
            this.logger.debug((Object)(String.valueOf(request.getRemoteAddr()) + this.myResources.getString("createnewapp") + appName));
            Object object = objLock;
            synchronized (object) {
                if (app == null) {
                    app = this.createNewApplication(request);
                }
            }
        } else {
            this.logger.debug((Object)(String.valueOf(request.getRemoteAddr()) + this.myResources.getString("appfound") + appName));
            app = (Application)session.getAttribute(appName);
        }
        return app;
    }

    public void saveApplication(HttpServletRequest request, Application app) {
        String appName = app.getName();
        HttpSession session = request.getSession(true);
        session.setAttribute(appName, (Object)app);
    }
}

