/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.web.anole.servlet;

import com.kingdee.bos.ctrl.chart.AxisGroup;
import com.kingdee.bos.ctrl.chart.AxisType;
import com.kingdee.bos.web.anole.config.Configurator;
import com.kingdee.bos.web.anole.controls.IChart;
import com.kingdee.bos.web.anole.controls.KDChart;
import com.kingdee.bos.web.anole.controls.KDDial;
import com.kingdee.bos.web.anole.image.Encoder;
import com.kingdee.bos.web.anole.image.PNGEncoder;
import com.kingdee.bos.web.anole.image.WBMPEncoder;
import com.kingdee.bos.web.anole.runtime.ChartTaker;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ImageServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String PNG_SUFFIX = "kdpng";
    public static final String WBMP_SUFFIX = "kdwbmp";
    public static final String DIAL_SUFFIX = "kddial";
    public static final String CHART_SUFFIX = "kdchart";
    public static final String IMAGE_TYPE = "imagetype";
    public static final String WBMP_TYPE = "wbmp";
    public static final String PNG_TYPE = "png";
    private static final int DEFAULT_MOBILE_WIDTH = 150;
    private static final int DEFAULT_MOBILE_HEIGHT = 100;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String strImageName = request.getServletPath();
        int indexofLast = strImageName.lastIndexOf("/");
        strImageName = strImageName.substring(indexofLast + 1, strImageName.length());
        int spos = strImageName.lastIndexOf(".");
        String strFilePrefix = strImageName.substring(0, spos);
        String strFileSuffix = strImageName.substring(spos + 1, strImageName.length());
        InputStream stream = null;
        if (strFileSuffix.equals(PNG_SUFFIX)) {
            stream = this.createPNGFileStream(response, strFilePrefix);
        } else if (strFileSuffix.equals(WBMP_SUFFIX)) {
            stream = this.createWBMPFileStream(response, strFilePrefix);
        } else if (strFileSuffix.equals(DIAL_SUFFIX)) {
            this.responseDial(request, response, strFilePrefix);
        } else if (strFileSuffix.equals(CHART_SUFFIX)) {
            this.responseChart(request, response, strFilePrefix);
        }
        if (stream != null) {
            this.writeToOutputStream(response, stream);
        }
    }

    private String getImageType(HttpServletRequest request) {
        String strImageType = request.getParameter(IMAGE_TYPE);
        if (strImageType == null) {
            strImageType = PNG_TYPE;
        }
        return strImageType;
    }

    private void responseChart(HttpServletRequest request, HttpServletResponse response, String strFilePrefix) throws IOException {
        IChart chart = ChartTaker.getInstance().remove(strFilePrefix);
        if (chart != null) {
            KDChart kdchart = (KDChart)chart;
            com.kingdee.bos.ctrl.swing.KDChart schart = new com.kingdee.bos.ctrl.swing.KDChart();
            schart.setDisplayLegend(kdchart.getDisplayLegend());
            if (kdchart.getChartType() != null) {
                schart.setChartType(kdchart.getChartType());
            }
            if (kdchart.getChartTitle().getText() != null) {
                schart.getChartTitle().setText(kdchart.getChartTitle().getText());
            }
            if (kdchart.getValues() != null) {
                schart.setChartData(kdchart.getSeriesKeys(), kdchart.getGroupKeys(), kdchart.getValues());
            }
            if (kdchart.isShowMoible()) {
                schart.getAxis(AxisType.CATEGORY, AxisGroup.PRIMARY).getTitle().setText("");
                schart.getAxis(AxisType.CATEGORY, AxisGroup.PRIMARY).setDisplayTickLabel(false);
                schart.getAxis(AxisType.VALUE, AxisGroup.PRIMARY).getTitle().setText("");
                schart.getAxis(AxisType.VALUE, AxisGroup.PRIMARY).setDisplayTickLabel(false);
                schart.getChartTitle().setText("");
            }
            String strWidth = request.getParameter("width");
            String strHeight = request.getParameter("height");
            int width = strWidth != null ? Integer.valueOf(strWidth) : 150;
            int height = strHeight != null ? Integer.valueOf(strHeight) : 100;
            BufferedImage image = schart.createBufferedImage(width, height);
            this.responseStream(request, response, image);
        }
    }

    private void responseDial(HttpServletRequest request, HttpServletResponse response, String strFilePrefix) throws IOException {
        IChart chart = ChartTaker.getInstance().remove(strFilePrefix);
        if (chart != null) {
            KDDial kdial = (KDDial)chart;
            com.kingdee.bos.ctrl.swing.KDDial dial = new com.kingdee.bos.ctrl.swing.KDDial(kdial.getRange(), null, null, null, kdial.getTitle());
            dial.getTitle().setFont(kdial.getTitleFont());
            dial.setSize(131, 70);
            dial.setValue(new Double(kdial.getValue()));
            dial.getScale(0).setTickLabelFormat(new DecimalFormat("#"));
            BufferedImage image = dial.createBufferedImage();
            this.responseStream(request, response, image);
        }
    }

    private void responseStream(HttpServletRequest request, HttpServletResponse response, BufferedImage image) throws IOException {
        String imageType = this.getImageType(request);
        Encoder encoder = null;
        if (imageType.equals(PNG_TYPE)) {
            response.setContentType("image/png");
            encoder = new PNGEncoder(image);
        } else {
            response.setContentType("image/vnd.wap.wbmp");
            encoder = new WBMPEncoder(image);
        }
        encoder.encode((OutputStream)response.getOutputStream());
    }

    private InputStream createWBMPFileStream(HttpServletResponse response, String strFilePrefix) {
        String strFileName = String.valueOf(strFilePrefix) + ".wbmp";
        strFileName = String.valueOf(Configurator.getTempPath()) + strFileName;
        InputStream stream = this.getImageStream(strFileName);
        response.setContentType("image/vnd.wap.wbmp");
        return stream;
    }

    private InputStream createPNGFileStream(HttpServletResponse response, String strFilePrefix) {
        String strFileName = String.valueOf(strFilePrefix) + ".png";
        strFileName = String.valueOf(Configurator.getTempPath()) + strFileName;
        InputStream stream = this.getImageStream(strFileName);
        response.setContentType("image/png");
        return stream;
    }

    private InputStream getImageStream(String strFileName) {
        FileInputStream is = null;
        try {
            File file = new File(strFileName);
            is = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return is;
    }

    private void writeToOutputStream(HttpServletResponse response, InputStream stream) {
        try {
            ServletOutputStream os = response.getOutputStream();
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = stream.read(buf)) != -1) {
                os.write(buf, 0, len);
            }
            os.flush();
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }
}

