If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='V_AR_INITIAL')
Drop view V_AR_INITIAL;

CREATE VIEW V_AR_INITIAL
AS
SELECT T_AR_InitDataInput.FCompanyID, T_AR_InitDataInput.FCurrencyID,
      T_AR_InitDataInput.FExchangeRate, T_AR_InitDataInput.FStartPeriodID,
      T_AR_InitDataInputEntry.FAcctCussType,
      T_AR_InitDataInputEntry.FAcctCussID, T_AR_InitDataInputEntry.FInitYearAmt,
      T_AR_InitDataInputEntry.FInitYearAmtLocal,
      T_AR_InitDataInputEntry.FYearTotalDebitAmt,
      T_AR_InitDataInputEntry.FYearTotalDebitAmtLocal,
      T_AR_InitDataInputEntry.FYearTotalCreditAmt,
      T_AR_InitDataInputEntry.FYearTotalCreditAmtLocal,
      T_AR_InitDataInputEntry.FInitPeriodAmt,
      T_AR_InitDataInputEntry.FInitPeriodAmtLocal,
      T_AR_InitDataInputEntry.FInitYearDirection,
      T_AR_InitDataInputEntry.FInitPeriodDirection, T_AR_InitDataInput.FID,
      T_AR_InitDataInputEntry.FID AS FSubID,
      T_AR_InitDataInputEntry.FAdminOrgUnitID,
      T_AR_InitDataInputEntry.FPersonID
FROM T_AR_InitDataInput INNER JOIN
      T_AR_InitDataInputEntry ON
      T_AR_InitDataInput.FID = T_AR_InitDataInputEntry.FParentID;

If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='V_AP_INITIAL')
Drop view V_AP_INITIAL;
CREATE VIEW V_AP_INITIAL
AS
SELECT T_AP_InitDataInput.FCompanyID, T_AP_InitDataInput.FCurrencyID,
      T_AP_InitDataInput.FExchangeRate, T_AP_InitDataInput.FStartPeriodID,
      T_AP_InitDataInputEntry.FAcctCussType,
      T_AP_InitDataInputEntry.FAcctCussID, T_AP_InitDataInputEntry.FInitYearAmt,
      T_AP_InitDataInputEntry.FInitYearAmtLocal,
      T_AP_InitDataInputEntry.FYearTotalDebitAmt,
      T_AP_InitDataInputEntry.FYearTotalDebitAmtLocal,
      T_AP_InitDataInputEntry.FYearTotalCreditAmt,
      T_AP_InitDataInputEntry.FYearTotalCreditAmtLocal,
      T_AP_InitDataInputEntry.FInitPeriodAmt,
      T_AP_InitDataInputEntry.FInitPeriodAmtLocal,
      T_AP_InitDataInputEntry.FInitYearDirection,
      T_AP_InitDataInputEntry.FInitPeriodDirection, T_AP_InitDataInput.FID,
      T_AP_InitDataInputEntry.FID AS FSubID,
      T_AP_InitDataInputEntry.FAdminOrgUnitID,
      T_AP_InitDataInputEntry.FPersonID
FROM T_AP_InitDataInput INNER JOIN
      T_AP_InitDataInputEntry ON
      T_AP_InitDataInput.FID = T_AP_InitDataInputEntry.FParentID;


If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='V_AR_BADACCTTAKEBACK')
Drop view V_AR_BADACCTTAKEBACK;
CREATE VIEW V_AR_BADACCTTAKEBACK
AS
SELECT VERIFICATIONBILL.FID FID,
	   VERIFICATIONBILL.FControlUnitID FCUID,
	   VERIFICATIONBILL.FCompanyID FCOMPANYID,
	   COMPANY.FName_L1 FCompanyName_L1,
	   COMPANY.FName_L2 FCompanyName_L2,
	   COMPANY.FName_L3 FCompanyName_L3,
	   VERIFICATIONBILL.FNumber FNUMBER,
	   VERIFICATIONBILL.FBizDate FBIZDATE,
	   ENTRYS.FBillDate FBILLDATE,
	   ENTRYS.FBillNumber FBILLNUMBER,
	   2 FBADACCTTYPE,
	   NULL FBADACCTTYPEDES,
	   ACCTCUSSTYPE.FID FACCTCUSSTYPEID,
	   ACCTCUSSTYPE.FName_L1 FAcctCussTypeName_L1,
	   ACCTCUSSTYPE.FName_L2 FAcctCussTypeName_L2,
	   ACCTCUSSTYPE.FName_L3 FAcctCussTypeName_L3,
	   ENTRYS.FACCTCUSSID FACCTCUSSID,
	   ENTRYS.FACCTCUSSNAME_L1 FACCTCUSSNAME_L1,
	   ENTRYS.FACCTCUSSNAME_L2 FACCTCUSSNAME_L2,
	   ENTRYS.FACCTCUSSNAME_L3 FACCTCUSSNAME_L3,
	   CURRENCY.FID FCURRENCYID,
	   CURRENCY.FName_L1 FCurrencyName_L1,
	   CURRENCY.FName_L2 FCurrencyName_L2,
	   CURRENCY.FName_L3 FCurrencyName_L3,
	   ENTRYS.FPersonID as FPersonID,
	   Person.FName_L1 FPersonName_L1,
	   Person.FName_L2 FPersonName_L2,
	   Person.FName_L3 FPersonName_L3,
	   ENTRYS.FAdminOrgUnitID as FAdminOrgUnitID,
	   AdminOrgUnit.FName_L1 FAdminOrgUnitName_L1,
	   AdminOrgUnit.FName_L2 FAdminOrgUnitName_L2,
	   AdminOrgUnit.FName_L3 FAdminOrgUnitName_L3,
	   BADACCT.FBadAmounts FBADAMOUNTS,
	   BADACCT.FBadAmountsLocal FBADAMOUNTSLOCAL,
	   BADACCT.FTakeBackAmounts FTAKEBACKAMOUNTS,
	   BADACCT.FTakeBackAmountsLocal FTAKEBACKAMOUNTSLOCAL,
	   ENTRYS.FTHISVERIFICATEAMT FTHISVERIFICATEAMT,
	   ENTRYS.FTHISVERIFICATEAMTLOC FTHISVERIFICATEAMTLOC,
	   ENTRYS.FGainAndLoss FGainAndLoss,
	   CREATOR.FName_L1 FCreatorName_L1,
	   CREATOR.FName_L2 FCreatorName_L2,
	   CREATOR.FName_L3 FCreatorName_L3,
	   VERIFICATIONBILL.FVerificationType FVERIFICATIONTYPE,
	   VERIFICATIONBILL.FFiVouchered FIVOUCHERED,
	   ENTRYS.FBillType FBILLTYPE,
	   VERIFICATIONBILL.FCreatorID,
	   VERIFICATIONBILL.FCreateTime,
	   VERIFICATIONBILL.FLastUpdateUserID,
	   VERIFICATIONBILL.FLastUpdateTime,
	   VERIFICATIONBILL.FControlUnitID
FROM T_AR_VerificationBill VERIFICATIONBILL
	   INNER JOIN T_AR_VerificationBillentry ENTRYS
	   ON VERIFICATIONBILL.FID = ENTRYS.FParentID
	   LEFT OUTER JOIN T_ORG_Company COMPANY
	   ON VERIFICATIONBILL.FCompanyID = COMPANY.FID
	   LEFT OUTER JOIN T_ORG_CtrlUnit CU
	   ON VERIFICATIONBILL.FControlUnitID = CU.FID
	   INNER JOIN T_PM_User CREATOR
	   ON VERIFICATIONBILL.FCreatorID = CREATOR.FID
	   INNER JOIN T_BD_AsstActType ACCTCUSSTYPE
	   ON ENTRYS.FAcctCussTypeID = ACCTCUSSTYPE.FID
	   INNER JOIN T_AR_BadAcct BADACCT
	   ON BADACCT.FID = ENTRYS.FBillID
	   LEFT OUTER JOIN T_BD_Currency CURRENCY ON
	   ENTRYS.FCurrencyID = CURRENCY.FID
	   LEFT OUTER JOIN T_BD_Person Person
	   ON	ENTRYS.FPersonID = Person.FID
	   LEFT OUTER JOIN T_ORG_Admin	AdminOrgUnit
	   ON  ENTRYS.FAdminOrgUnitID = AdminOrgUnit.FID
	   WHERE (ENTRYS.FBillType = 15)
UNION ALL
SELECT VERIFICATIONBILL.FID FID, VERIFICATIONBILL.FControlUnitID FCUID,
      VERIFICATIONBILL.FCompanyID FCOMPANYID,
      COMPANY.FName_L1 FCompanyName_L1,
      COMPANY.FName_L2 FCompanyName_L2,
      COMPANY.FName_L3 FCompanyName_L3, VERIFICATIONBILL.FNumber FNUMBER,
      VERIFICATIONBILL.FBizDate FBIZDATE, ENTRYS.FBillDate FBILLDATE,
      ENTRYS.FBillNumber FBILLNUMBER, 1 FBADACCTTYPE, NULL FBADACCTTYPEDES,
      ACCTCUSSTYPE.FID FACCTCUSSTYPEID,
      ACCTCUSSTYPE.FName_L1 FAcctCussTypeName_L1,
      ACCTCUSSTYPE.FName_L2 FAcctCussTypeName_L2,
      ACCTCUSSTYPE.FName_L3 FAcctCussTypeName_L3,
      ENTRYS.FACCTCUSSID FACCTCUSSID,
      ENTRYS.FACCTCUSSNAME_L1 FACCTCUSSNAME_L1,
	  ENTRYS.FACCTCUSSNAME_L2 FACCTCUSSNAME_L2,
      ENTRYS.FACCTCUSSNAME_L3 FACCTCUSSNAME_L3,
      CURRENCY.FID FCURRENCYID,
      CURRENCY.FName_L1 FCurrencyName_L1,
      CURRENCY.FName_L2 FCurrencyName_L2,
      CURRENCY.FName_L3 FCurrencyName_L3,
      ENTRYS.FPersonID as FPersonID,
      Person.FName_L1 FPersonName_L1,
	  Person.FName_L2 FPersonName_L2,
	  Person.FName_L3 FPersonName_L3,
	  ENTRYS.FAdminOrgUnitID as FAdminOrgUnitID,
	  AdminOrgUnit.FName_L1 FAdminOrgUnitName_L1,
	  AdminOrgUnit.FName_L2 FAdminOrgUnitName_L2,
	  AdminOrgUnit.FName_L3 FAdminOrgUnitName_L3,
      BADACCT.FAmounts FBADAMOUNTS,
      BADACCT.FAmountsLocal FBADAMOUNTSLOCAL,
      BADACCT.FTakeBackAmounts FTAKEBACKAMOUNTS,
      BADACCT.FTakeBackAmountsLocal FTAKEBACKAMOUNTSLOCAL,
      ENTRYS.FTHISVERIFICATEAMT FTHISVERIFICATEAMT,
      ENTRYS.FTHISVERIFICATEAMTLOC FTHISVERIFICATEAMTLOC,
      ENTRYS.FGainAndLoss FGainAndLoss,
      CREATOR.FName_L1 FCreatorName_L1, CREATOR.FName_L2 FCreatorName_L2,
      CREATOR.FName_L3 FCreatorName_L3,
      VERIFICATIONBILL.FVerificationType FVERIFICATIONTYPE,
      VERIFICATIONBILL.FFiVouchered FIVOUCHERED, ENTRYS.FBillType FBILLTYPE,
      VERIFICATIONBILL.FCreatorID, VERIFICATIONBILL.FCreateTime,
      VERIFICATIONBILL.FLastUpdateUserID, VERIFICATIONBILL.FLastUpdateTime,
      VERIFICATIONBILL.FControlUnitID
FROM T_AR_VerificationBill VERIFICATIONBILL
      INNER JOIN  T_AR_VerificationBillentry ENTRYS
      ON VERIFICATIONBILL.FID = ENTRYS.FParentID
      LEFT OUTER JOIN  T_ORG_Company COMPANY
      ON VERIFICATIONBILL.FCompanyID = COMPANY.FID
      LEFT OUTER JOIN T_PM_User CREATOR
      ON VERIFICATIONBILL.FCreatorID = CREATOR.FID
      LEFT OUTER JOIN T_ORG_CtrlUnit CU
      ON VERIFICATIONBILL.FControlUnitID = CU.FID
      INNER JOIN T_BD_AsstActType ACCTCUSSTYPE
      ON ENTRYS.FAcctCussTypeID = ACCTCUSSTYPE.FID
      INNER JOIN T_BD_Currency CURRENCY
      ON ENTRYS.FCurrencyID = CURRENCY.FID
      INNER JOIN  T_AR_InitBadAccount BADACCT
      ON ENTRYS.FBillID = BADACCT.FID
      LEFT OUTER JOIN T_BD_Person Person
	  ON	ENTRYS.FPersonID = Person.FID
      LEFT OUTER JOIN T_ORG_Admin	AdminOrgUnit
      ON  ENTRYS.FAdminOrgUnitID = AdminOrgUnit.FID
WHERE (ENTRYS.FBillType = 16);

If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='V_AR_AccountBadDebtAll')
Drop view V_AR_AccountBadDebtAll;
CREATE VIEW V_AR_AccountBadDebtAll AS SELECT ACCOUNTBADDEBT.FID AS FID,
     ACCOUNTBADDEBT.FNumber AS FNumber,
      ACCOUNTBADDEBT.FCreatorID FCreatorID,
      ACCOUNTBADDEBT.FCreateTime FCreateTime,
      ACCOUNTBADDEBT.FLastUpdateUserID FLastUpdateUserID,
      ACCOUNTBADDEBT.FLastUpdateTime FLastUpdateTime,
      ACCOUNTBADDEBT.FControlUnitID FControlUnitID,
      COMPANY.FName_L1 AS FCompanyName_L1,
      COMPANY.FName_L2 AS FCompanyName_L2,
      COMPANY.FName_L3 AS FCompanyName_L3,
      COMPANY.FID AS FCompanyID,
     ACCOUNTBADDEBT.FAccountYear AS FAccountYear,
      ACCOUNTBADDEBT.FAccountDate AS FAccountDate,
      ACCOUNTBADDEBT.FAccountType AS FAccountType,
      NULL AS FAccountTypeDes,
     ACCOUNTBADDEBT.FPrepareAmount AS FPrepareAmount,
      ACCOUNTBADDEBT.FThisPrepareAmount AS
      FThisPrepareAmount,
     ACCOUNTBADDEBT.FPatch AS FPatch,
     ACCOUNTBADDEBT.FRush AS FRush,
     CURRENCY.FName_L1 AS FCurrencyName_L1,
      CURRENCY.FName_L2 AS FCurrencyName_L2,
      CURRENCY.FName_L3 AS FCurrencyName_L3,
      NULL AS FAccountName_L1, NULL
     AS FAccountName_L2, NULL
     AS FAccountName_L3, 1 AS FDirection,
     0.0 AS FBalance, 0.0 AS FAccountPercent,
     0.0 AS FAccountBalance,
     ENTRY.FSeq AS FSeq,
     ENTRY.FAccountAge AS FAccountAge,
     ENTRY.FAccrualRate AS FAccrualRate,
     ENTRY.FReceiveBalance AS FReceiveBalance,
      ENTRY.FOtherReceiveRate AS FOtherReceiveRate,
      ENTRY.FOtherReceiveBalance AS FOtherReceiveBalance,
      ENTRY.FEstimateLossSum AS FEstimateLossSum,
      NULL AS FSaleAccountName_L1, NULL
     AS FSaleAccountName_L2, NULL
     AS FSaleAccountName_l3,
     0.0 AS FAccuralRate,
     0.0 AS FSaleTotalAmounts,
     0.0 AS FAccuralAmounts
FROM T_AR_AccountBadDebt ACCOUNTBADDEBT
      INNER JOIN
     T_AR_AccountBadDebtAnalysEntry ENTRY ON
      ACCOUNTBADDEBT.FID = ENTRY.FAccountBadDebtID
      INNER JOIN
     T_ORG_Company COMPANY ON
     ACCOUNTBADDEBT.FCompanyID = COMPANY.FID
      INNER JOIN
     T_BD_Currency CURRENCY ON
     ACCOUNTBADDEBT.FCurrencyID = CURRENCY.FID
UNION ALL
SELECT ACCOUNTBADDEBT.FID AS FID, ACCOUNTBADDEBT.FNumber AS FNumber,
      ACCOUNTBADDEBT.FCreatorID FCreatorID,
      ACCOUNTBADDEBT.FCreateTime FCreateTime,
      ACCOUNTBADDEBT.FLastUpdateUserID FLastUpdateUserID,
      ACCOUNTBADDEBT.FLastUpdateTime FLastUpdateTime,
      ACCOUNTBADDEBT.FControlUnitID FControlUnitID,
      COMPANY.FName_L1 AS FCompanyName_L1,
      COMPANY.FName_L2 AS FCompanyName_L2,
      COMPANY.FName_L3 AS FCompanyName_L3, COMPANY.FID AS FCompanyID,
      ACCOUNTBADDEBT.FAccountYear AS FAccountYear,
      ACCOUNTBADDEBT.FAccountDate AS FAccountDate,
      ACCOUNTBADDEBT.FAccountType AS FAccountType, NULL AS FAccountTypeDes,
      ACCOUNTBADDEBT.FPrepareAmount AS FPrepareAmount,
      ACCOUNTBADDEBT.FThisPrepareAmount AS FThisPrepareAmount,
      ACCOUNTBADDEBT.FPatch AS FPatch, ACCOUNTBADDEBT.FRush AS FRush,
      CURRENCY.FName_L1 AS FCurrencyName_L1,
      CURRENCY.FName_L2 AS FCurrencyName_L2,
      CURRENCY.FName_L3 AS FCurrencyName_L3,
      ACCOUNT.FName_L1 AS FAccountName_L1,
      ACCOUNT.FName_L2 AS FAccountName_L2,
      ACCOUNT.FName_L3 AS FAccountName_L3, ENTRYS.FDirection AS FDirection,
      ENTRYS.FBalance AS FBalance, ENTRYS.FAccountPercent AS FAccountPercent,
      ENTRYS.FAccountBalance AS FAccountBalance, 0 AS FSeq, NULL AS FAccountAge,
      0.0 AS FAccrualRate, 0.0 AS FReceiveBalance, 0.0 AS FOtherReceiveRate,
      0.0 AS FOtherReceiveBalance, 0.0 AS FEstimateLossSum, NULL
      AS FSaleAccountName_L1, NULL AS FSaleAccountName_L2, NULL
      AS FSaleAccountName_l3, 0.0 AS FAccuralRate, 0.0 AS FSaleTotalAmounts,
      0.0 AS FAccuralAmounts
FROM T_AR_AccountBadDebt ACCOUNTBADDEBT INNER JOIN
      T_AR_AccountBadDebtEntry ENTRYS ON
      ACCOUNTBADDEBT.FID = ENTRYS.FParent INNER JOIN
      T_ORG_Company COMPANY ON
      ACCOUNTBADDEBT.FCompanyID = COMPANY.FID INNER JOIN
      T_BD_Currency CURRENCY ON
      ACCOUNTBADDEBT.FCurrencyID = CURRENCY.FID INNER JOIN
      T_BD_AccountView ACCOUNT ON ENTRYS.FAccountID = ACCOUNT.FID
UNION ALL
SELECT ACCOUNTBADDEBT.FID AS FID, ACCOUNTBADDEBT.FNumber AS FNumber,
      ACCOUNTBADDEBT.FCreatorID FCreatorID,
      ACCOUNTBADDEBT.FCreateTime FCreateTime,
      ACCOUNTBADDEBT.FLastUpdateUserID FLastUpdateUserID,
      ACCOUNTBADDEBT.FLastUpdateTime FLastUpdateTime,
      ACCOUNTBADDEBT.FControlUnitID FControlUnitID,
      COMPANY.FName_L1 AS FCompanyName_L1,
      COMPANY.FName_L2 AS FCompanyName_L2,
      COMPANY.FName_L3 AS FCompanyName_L3, COMPANY.FID AS FCompanyID,
      ACCOUNTBADDEBT.FAccountYear AS FAccountYear,
      ACCOUNTBADDEBT.FAccountDate AS FAccountDate,
      ACCOUNTBADDEBT.FAccountType AS FAccountType, NULL AS FAccountTypeDes,
      ACCOUNTBADDEBT.FPrepareAmount AS FPrepareAmount,
      ACCOUNTBADDEBT.FThisPrepareAmount AS FThisPrepareAmount,
      ACCOUNTBADDEBT.FPatch AS FPatch, ACCOUNTBADDEBT.FRush AS FRush,
      CURRENCY.FName_L1 AS FCurrencyName_L1,
      CURRENCY.FName_L2 AS FCurrencyName_L2,
      CURRENCY.FName_L3 AS FCurrencyName_L3, NULL AS FAccountName_L1, NULL
      AS FAccountName_L2, NULL AS FAccountName_L3, 1 AS FDirection,
      0.0 AS FBalance, 0.0 AS FAccountPercent, 0.0 AS FAccountBalance, 0 AS FSeq,
      NULL AS FAccountAge, 0.0 AS FAccrualRate, 0.0 AS FReceiveBalance,
      0.0 AS FOtherReceiveRate, 0.0 AS FOtherReceiveBalance,
      0.0 AS FEstimateLossSum, SALEACCOUNT.FName_L1 AS FSaleAccountName_L1,
      SALEACCOUNT.FName_L2 AS FSaleAccountName_L2,
      SALEACCOUNT.FName_L3 AS FSaleAccountName_l3,
      ENTRIES.FAccuralRate AS FAccuralRate,
      ENTRIES.FSaleTotalAmounts AS FSaleTotalAmounts,
      ENTRIES.FAccuralAmounts AS FAccuralAmounts
FROM T_AR_AccountBadDebt ACCOUNTBADDEBT INNER JOIN
      T_ORG_Company COMPANY ON
      ACCOUNTBADDEBT.FCompanyID = COMPANY.FID INNER JOIN
      T_AR_AccountBadDebtSaleIncome ENTRIES ON
      ACCOUNTBADDEBT.FID = ENTRIES.FAccountBadDebtID INNER JOIN
      T_BD_Currency CURRENCY ON
      ACCOUNTBADDEBT.FCurrencyID = CURRENCY.FID INNER JOIN
      T_BD_AccountView SALEACCOUNT ON ENTRIES.FAccountID = SALEACCOUNT.FID;


If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='v_ar_accountviewunion')
Drop view v_ar_accountviewunion;
CREATE VIEW v_ar_accountviewunion
AS
  SELECT DISTINCT contrastaccountview.fid AS fid,
                  accountview.fid AS faccountid,
                  contrastaccountview.fcreatorid AS fcreatorid,
                  contrastaccountview.fcreatetime AS fcreatetime,
                  contrastaccountview.flastupdateuserid AS flastupdateuserid,
                  contrastaccountview.flastupdatetime AS flastupdatetime,
                  contrastaccountview.fcontrolunitid AS fcontrolunitid,
                  accountview.fnumber AS fnumber,
                  accountview.fname_l2 AS fname,
                  accountview.flongname_l2 AS flongname,
                  accountview.flongnumber AS flongnumber,
                  accounttableid.fid AS faccounttableid,
                  accounttableid.fnumber AS faccounttableidnumber,
                  accounttableid.fname_l2 AS faccounttableidname,
                  contrastaccountview.fcompanyid AS fcompanyid,
                  contrastaccountview.fsystem AS fsystem,
                  contrastaccountview.Fdatadirection as Fdatadirection,
                  accountview.FDC as FDC,
                  contrastaccountview.fperiodyear as fperiodyear,
                  contrastaccountview.fperiodnumber as fperiodnumber
  FROM   t_bd_accountview AS accountview
         INNER JOIN t_ar_contrastaccountview contrastaccountview
                 ON accountview.fid = contrastaccountview.faccountid
         INNER JOIN t_bd_accounttable AS accounttableid
                 ON accountview.faccounttableid = accounttableid.fid;


If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='V_AR_VoucherAccount') 
Drop view V_AR_VoucherAccount;

CREATE  VIEW V_AR_VoucherAccount AS 
SELECT relationEntry.FSrcEntryID FSRCENTRYID, 
voucherEntry.FEntryDC FDC, 
voucherEntry.FAccountID FACCOUNTID,
voucher.FBookedDate FVOUCHERDATE, 
accountUnion.FSystem FCONTROL,
voucher.FBizStatus as voucherBizStatus,
accountUnion.FCompanyID as FAccountCompanyID,
accountUnion.FControlUnitID as FControlUnitID,
accountUnion.FAccountTableID as FAccountTableID,
accountUnion.Fdatadirection as Fdatadirection,
accountUnion.fperiodyear as fperiodyear,
accountUnion.fperiodnumber as fperiodnumber
FROM T_BOT_Relation relation 
INNER JOIN T_BOT_RelationEntry relationEntry 
ON relation.FID = relationEntry.FKeyID 
INNER JOIN T_GL_Voucher voucher 
ON relation.FDestObjectID = voucher.FID 
INNER JOIN T_GL_VoucherEntry voucherEntry 
ON relationEntry.FDestEntryID = voucherEntry.FID 
INNER JOIN V_AR_AccountViewUnion accountUnion
ON voucherEntry.FAccountID = accountUnion.FAccountID    
WHERE relation.FDestEntityID = '2652E01E'  AND relation.FSrcEntityID != '9E1B9DB7'
and  relationEntry.FDestPropertyName='id'
UNION ALL
SELECT relation.FSrcObjectID FSRCENTRYID, 
voucherEntry.FEntryDC FDC, 
voucherEntry.FAccountID FACCOUNTID,
voucher.FBookedDate FVOUCHERDATE, 
accountUnion.FSystem FCONTROL,
voucher.FBizStatus as voucherBizStatus,
accountUnion.FCompanyID as FAccountCompanyID,
accountUnion.FControlUnitID as FControlUnitID,
accountUnion.FAccountTableID as FAccountTableID,
accountUnion.Fdatadirection as Fdatadirection,
accountUnion.fperiodyear as fperiodyear,
accountUnion.fperiodnumber as fperiodnumber
FROM T_BOT_Relation relation 
INNER JOIN T_GL_Voucher voucher 
ON relation.FDestObjectID = voucher.FID 
INNER JOIN T_GL_VoucherEntry voucherEntry 
ON voucher.FID = voucherEntry.FBillID 
INNER JOIN V_AR_AccountViewUnion accountUnion
ON voucherEntry.FAccountID = accountUnion.FAccountID    
WHERE relation.FDestEntityID = '2652E01E' AND relation.FSrcEntityID = '9E1B9DB7';


If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='v_ar_checkaccountbill')
Drop view v_ar_checkaccountbill;

CREATE VIEW v_ar_checkaccountbill
AS
  SELECT bill.fbilldate fbilldate,  		 
         bill.fcompanyid fcompanyid,
         bill.fasstacttypeid fasstacttypeid,
         bill.fasstactid fasstactid,
         bill.fcurrencyid fcurrencyid,        
         bill.fpersonid FPersonID,
         bill.fadminorgunitid FAdminOrgUnitID,      
         billentry.fid as fentryid,
         1 as fdirection,
	     billentry.FRecievePayAmount AS fdamount,
		 billentry.FRecievePayAmountLocal AS fdamountlocal,
		 billentry.FRecievePayAmount AS fcamount,
		 billentry.FRecievePayAmountLocal AS fcamountlocal
  FROM   t_ar_otherbill bill
         INNER JOIN t_ar_otherbillentry billentry  ON bill.fid = billentry.fparentid
  WHERE  bill.ffivouchered = 1 AND bill.fistransbill = 0  
  UNION ALL  
  SELECT bill.fbilldate fbilldate,
         bill.FCompanyOrgUnitID fcompanyid,
         bill.FRecAsstActTypeID fasstacttypeid,
         TO_CHAR(bill.FRecAsstActId) as fasstactid,
         bill.FRecCurrencyID fcurrencyid,
         bill.FBusinessorID fpersonid,
         bill.FAdminOrgUnitID fadminorgunitid,
         billentry.fid fentryid,
         1 as fdirection,
         billentry.FReceivableAmt fdamount,
         billentry.FReceivableAmtLo fdamountlocal,
         billentry.FReceivableAmt fcamount,
         billentry.FReceivableAmtLo fcamountlocal
  FROM   T_ARP_ProxyBill bill
         INNER JOIN T_ARP_ProxyBillEntry billentry
                 ON bill.fid = billentry.FParentID
  WHERE  bill.FFiVouchered = 1
  UNION ALL 
    SELECT fbadacctdate AS fbilldate,
         fcompanyid,
         fcussenttypeid AS fasstacttypeid,
         facctcussentid AS fasstactid,
         fcurrencyid,
         fpersonid,
         fadminorgunitid,
         fid AS fentryid,
         1 as fdirection,
         fbadamounts AS fdamount,
         fbadamountslocal AS fdamountlocal,
         fbadamounts AS fcamount,
         fbadamountslocal AS fcamountlocal
  FROM   t_ar_badacct
  WHERE  ffivouchered = 1
  UNION ALL
  SELECT exgbill.fexgratedate as fbilldate,
         exgbill.fcompanyid fcompanyid,
         exgbillentry.fasstacttypeid fasstacttypeid,
         exgbillentry.fasstactid fasstactid,
         exgbill.fcurrencyid as fcurrencyid,
         exgbillentry.fpersonid as fpersonid,
         exgbillentry.fadminorgunitid as fadminorgunitid,
         exgbillentry.fid fentryid,
         1 as fdirection,
         0.0 fdamount,
         exgbillentry.fafterunverifyamtloc fdamountlocal,
         0.0 fcamount,
         exgbillentry.fafterunverifyamtloc fcamountlocal
  FROM   T_AR_ArExgRateBill exgbill
         INNER JOIN T_AR_ArExgRateBillEntry exgbillentry
                 ON exgbill.fid = exgbillentry.fparentid
  WHERE  exgbill.ffivouchered = 1;
  
If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='v_ar_checkaccountbill1')
Drop view v_ar_checkaccountbill1;

CREATE VIEW v_ar_checkaccountbill1
AS
  SELECT bill.fbizdate fbilldate,
         bill.fcompanyid fcompanyid,
         bill.fpayertypeid fasstacttypeid,
         bill.fpayerid fasstactid,
         bill.fcurrencyid fcurrencyid,
         bill.fpersonid fpersonid,
         bill.fadminorgunitid fadminorgunitid,
         billentry.fid fentryid,
         1 as fdirection,
         billentry.famount fdamount,
         billentry.flocalamount fdamountlocal,
         billentry.famount fcamount,
         billentry.flocalamount fcamountlocal
  FROM   t_cas_receivingbill bill
         INNER JOIN t_cas_receivingbillentry billentry
                 ON bill.fid = billentry.freceivingbillid
  WHERE  (bill.fsourcetype = 100
          AND bill.ffivouchered = 1 and FIsTransBill = 0)
            and  (bill.FPayerTypeID is not null or  ltrim(rtrim(bill.FPayerTypeID)) != '' or bill.FPayerID is not null or  ltrim(rtrim(bill.FPayerID)) != '');


If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='v_ar_checkaccountbill2')
Drop view v_ar_checkaccountbill2;

CREATE VIEW v_ar_checkaccountbill2
AS
  SELECT bill.fbizdate fbilldate,
         bill.fcompanyid fcompanyid,
         billentry.facctcusstypeid fasstacttypeid,
         billentry.facctcussid fasstactid,
         billentry.fcurrencyid fcurrencyid,
         billentry.fpersonid AS fpersonid,
         billentry.fadminorgunitid AS fadminorgunitid,
         billentry.fid fentryid,
         1 as fdirection,
         billentry.fthisverificateamt fdamount,
         billentry.fthisverificateamtloc fdamountlocal,
         billentry.fthisverificateamt fcamount,
         billentry.fthisverificateamtloc fcamountlocal
  FROM   t_ap_verificationbill bill
         INNER JOIN t_ap_verificationbillentry billentry
                      ON bill.fid = billentry.fparentid
  WHERE  (bill.ffivouchered = 1
          AND ((((bill.fverificationtype = 203
                   OR bill.fverificationtype = 209)
                 AND billentry.fbilltype = 8)
                 OR ((bill.fverificationtype = 204
                       OR bill.fverificationtype = 210)
                     AND billentry.fbilltype = 6))
                OR ((bill.fverificationtype = 211
                      OR bill.fverificationtype = 212)
                    AND billentry.fbilltype = 6)));
  
  
If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='v_ar_checkaccountbill3')
Drop view v_ar_checkaccountbill3;

CREATE VIEW v_ar_checkaccountbill3
AS  
  SELECT bill.fbizdate fbilldate,
         bill.fcompanyid fcompanyid,
         billentry.facctcusstypeid fasstacttypeid,
         billentry.facctcussid fasstactid,
         billentry.fcurrencyid fcurrencyid,
         billentry.fpersonid AS fpersonid,
         billentry.fadminorgunitid AS fadminorgunitid,
         billentry.fid fentryid,
         CASE billentry.FBillSubType
         WHEN 100 THEN -1
         WHEN 102 THEN -1
         ELSE 1 END AS fdirection,
         billentry.fthisverificateamt fdamount,
         billentry.fthisverificateamtloc fdamountlocal,
         billentry.fthisverificateamt fcamount,
         billentry.fthisverificateamtloc fcamountlocal
  FROM   t_ar_verificationbill bill
         INNER JOIN t_ar_verificationbillentry billentry
                      ON bill.fid = billentry.fparentid
  WHERE  bill.ffivouchered = 1 AND (bill.fverificationtype = 101 OR (bill.fverificationtype = 107 AND bill.FIsSameCode = 1));
  
If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='v_ar_checkaccountbill4')
Drop view v_ar_checkaccountbill4;

CREATE VIEW v_ar_checkaccountbill4
AS
  SELECT bill.fbizdate fbilldate,
         bill.fcompanyid fcompanyid,
         billentry.facctcusstypeid fasstacttypeid,
         billentry.facctcussid fasstactid,
         billentry.fcurrencyid fcurrencyid,
         billentry.fpersonid AS fpersonid,
         billentry.fadminorgunitid AS fadminorgunitid,
         billentry.fid fentryid,
         1 as fdirection,
         billentry.fthisverificateamt fdamount,
         billentry.fthisverificateamtloc fdamountlocal,
         billentry.fthisverificateamt fcamount,
         billentry.fthisverificateamtloc fcamountlocal
  FROM   t_ar_verificationbill bill
         INNER JOIN t_ar_verificationbillentry billentry
                      ON bill.fid = billentry.fparentid
  WHERE  (bill.ffivouchered = 1
          AND ((bill.fverificationtype = 107 AND FIsSameCode = 0)
                OR ((bill.fverificationtype = 103
                      OR bill.fverificationtype = 109)
                    AND billentry.fbilltype = 8)
                OR ((bill.fverificationtype = 104
                      OR bill.fverificationtype = 110)
                    AND billentry.fbilltype = 6)
                OR ((bill.fverificationtype = 113
                      OR bill.fverificationtype = 114)
                    AND billentry.fbilltype = 6))
           OR (bill.fverificationtype = 111
                OR bill.fverificationtype = 112));

If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='v_ap_checkaccountbill')
Drop view v_ap_checkaccountbill;

CREATE  VIEW v_ap_checkaccountbill
AS
   SELECT bill.fbilldate fbilldate,  		 
         bill.fcompanyid fcompanyid,
         bill.fasstacttypeid fasstacttypeid,
         bill.fasstactid fasstactid,
         bill.fcurrencyid fcurrencyid,        
         bill.fpersonid FPersonID,
         bill.fadminorgunitid FAdminOrgUnitID,      
         billentry.fid as fentryid,
         1 as fdirection,
	     billentry.FRecievePayAmount AS fdamount,
		 billentry.FRecievePayAmountLocal AS fdamountlocal,
		 billentry.FRecievePayAmount AS fcamount,
		 billentry.FRecievePayAmountLocal AS fcamountlocal
  FROM   t_ap_otherbill bill
         INNER JOIN t_ap_otherbillentry billentry  ON bill.fid = billentry.fparentid
  WHERE  bill.ffivouchered = 1 AND bill.fistransbill = 0
  UNION ALL
  SELECT bill.fbilldate fbilldate,
         bill.FCompanyOrgUnitID fcompanyid,
         billentry.FPayAsstActTypeID fasstacttypeid,
         billentry.FPayAsstActId as fasstactid,
         billentry.FPayCurrencyID fcurrencyid,
         bill.FBusinessorID fpersonid,
         bill.FAdminOrgUnitID fadminorgunitid,
         billentry.fid fentryid,
         1 as fdirection,
         billentry.FPayableAmt fdamount,
         billentry.FPayableAmtLocal fdamountlocal,
         billentry.FPayableAmt fcamount,
         billentry.FPayableAmtLocal fcamountlocal
  FROM   T_ARP_ProxyBill bill
         INNER JOIN T_ARP_ProxyBillEntry billentry
                 ON bill.fid = billentry.FParentID
  WHERE  bill.FFiVouchered = 1
  UNION ALL
    SELECT exgbill.fexgratedate as fbilldate,
         exgbill.fcompanyid fcompanyid,
         exgbillentry.fasstacttypeid fasstacttypeid,
         exgbillentry.fasstactid fasstactid,
         exgbill.fcurrencyid as fcurrencyid,
         exgbillentry.fpersonid as FPersonID,
         exgbillentry.fadminorgunitid as FAdminOrgUnitID,
         exgbillentry.fid fentryid,
         1 as fdirection,
         0.0 fdamount,
         exgbillentry.fafterunverifyamtloc fdamountlocal,
         0.0 fcamount,
         exgbillentry.fafterunverifyamtloc fcamountlocal
  FROM   T_AP_ApExgRateBill exgbill
         INNER JOIN T_AP_ApExgRateBillEntry exgbillentry
                 ON exgbill.fid = exgbillentry.fparentid
  WHERE  exgbill.ffivouchered = 1;

If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='v_ap_checkaccountbill1')
Drop view v_ap_checkaccountbill1;

CREATE  VIEW v_ap_checkaccountbill1
AS
  SELECT bill.fbizdate fbilldate,
         bill.fcompanyid fcompanyid,
         bill.fpayeetypeid fasstacttypeid,
         bill.fpayeeid fasstactid,
         bill.fcurrencyid fcurrencyid,
         bill.FPersonID FPersonID,
         bill.FAdminOrgUnitID FAdminOrgUnitID,
         billentry.fid fentryid,
         1 as fdirection,
         billentry.famount fdamount,
         billentry.flocalamount fdamountlocal,
         billentry.famount fcamount,
         billentry.flocalamount fcamountlocal
  FROM   t_cas_paymentbill bill
         INNER JOIN t_cas_paymentbillentry billentry
                 ON bill.fid = billentry.fpaymentbillid
  WHERE  (bill.fsourcetype = 101
          AND bill.ffivouchered = 1 and FIsTransBill = 0);


If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='v_ap_checkaccountbill2')
Drop view v_ap_checkaccountbill2;

CREATE  VIEW v_ap_checkaccountbill2
AS
  SELECT bill.fbizdate fbilldate,
         bill.fcompanyid fcompanyid,
         billentry.facctcusstypeid fasstacttypeid,
         billentry.facctcussid fasstactid,
         billentry.fcurrencyid fcurrencyid,
         billentry.FPersonID as FPersonID,
         billentry.FAdminOrgUnitID as FAdminOrgUnitID,
         billentry.fid fentryid,
         CASE billentry.FBillSubType
         WHEN 201 THEN -1
         WHEN 203 THEN -1
         ELSE 1 END AS fdirection,
         billentry.fthisverificateamt fdamount,
         billentry.fthisverificateamtloc fdamountlocal,
         billentry.fthisverificateamt fcamount,
         billentry.fthisverificateamtloc fcamountlocal
  FROM   t_ap_verificationbill bill
         INNER JOIN t_ap_verificationbillentry billentry
                      ON bill.fid = billentry.fparentid
  WHERE  bill.ffivouchered = 1  AND (bill.fverificationtype = 201 OR (bill.fverificationtype = 207 AND bill.FIsSameCode = 1));

If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='v_ap_checkaccountbill3')
Drop view v_ap_checkaccountbill3;

CREATE  VIEW v_ap_checkaccountbill3
AS
  SELECT bill.fbizdate fbilldate,
         bill.fcompanyid fcompanyid,
         billentry.facctcusstypeid fasstacttypeid,
         billentry.facctcussid fasstactid,
         billentry.fcurrencyid fcurrencyid,
         billentry.FPersonID as FPersonID,
         billentry.FAdminOrgUnitID as FAdminOrgUnitID,
         billentry.fid fentryid,
         1 as fdirection,
         billentry.fthisverificateamt fdamount,
         billentry.fthisverificateamtloc fdamountlocal,
         billentry.fthisverificateamt fcamount,
         billentry.fthisverificateamtloc fcamountlocal
  FROM   t_ap_verificationbill bill
         INNER JOIN t_ap_verificationbillentry billentry
                      ON bill.fid = billentry.fparentid
  WHERE  bill.ffivouchered = 1
          AND ((bill.fverificationtype = 207 AND bill.FIsSameCode = 0)
                  OR ((bill.fverificationtype = 203 OR bill.fverificationtype = 209) AND billentry.fbilltype = 9)
                  OR ((bill.fverificationtype = 204 OR bill.fverificationtype = 210) AND billentry.fbilltype = 4)
                  OR ((bill.fverificationtype = 211 OR bill.fverificationtype = 212) AND billentry.fbilltype = 4));
                  
If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='v_ap_checkaccountbill4')
Drop view v_ap_checkaccountbill4;

CREATE  VIEW v_ap_checkaccountbill4
AS
  SELECT bill.fbizdate fbilldate,
         bill.fcompanyid fcompanyid,
         billentry.facctcusstypeid fasstacttypeid,
         billentry.facctcussid fasstactid,
         billentry.fcurrencyid fcurrencyid,
         billentry.FPersonID as FPersonID,
         billentry.FAdminOrgUnitID as FAdminOrgUnitID,
         billentry.fid fentryid,
         1 as fdirection,
         billentry.fthisverificateamt fdamount,
         billentry.fthisverificateamtloc fdamountlocal,
         billentry.fthisverificateamt fcamount,
         billentry.fthisverificateamtloc fcamountlocal
  FROM   t_ar_verificationbill bill
         INNER JOIN t_ar_verificationbillentry billentry
                      ON bill.fid = billentry.fparentid
  WHERE  (bill.ffivouchered = 1
          AND ((((bill.fverificationtype = 103
                   OR bill.fverificationtype = 109
                  AND billentry.fbilltype = 9)
                  OR (bill.fverificationtype = 104
                       OR bill.fverificationtype = 110
                      AND billentry.fbilltype = 4))
                 OR (bill.fverificationtype = 113
                      OR bill.fverificationtype = 114
                     AND billentry.fbilltype = 4))));


If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='v_ar_checkaccount')
Drop view v_ar_checkaccount;

CREATE  VIEW v_ar_checkaccount
AS
SELECT bill.fbilldate fbilldate,
         voucheraccount.fvoucherdate AS fvoucherdate,
         bill.fcompanyid fcompanyid,
         bill.fasstacttypeid fasstacttypeid,
         bill.fasstactid fasstactid,
         bill.fcurrencyid fcurrencyid,
         voucheraccount.FAccountCompanyID FAccountCompanyID,
         voucheraccount.FControlUnitID as FControlUnitID,
         voucheraccount.FAccountTableID as FAccountTableID,
         bill.FPersonID FPersonID,
         bill.FAdminOrgUnitID FAdminOrgUnitID,
         voucheraccount.faccountid faccountid,
         bill.fdirection as fdirection,   
         voucheraccount.voucherBizStatus as voucherBizStatus,  
         voucheraccount.fperiodyear as fperiodyear,
         voucheraccount.fperiodnumber as fperiodnumber,
         case when bill.fdamount < 0 then  voucheraccount.fdatadirection * voucheraccount.fdc * bill.fdamount else voucheraccount.fdc * bill.fdamount end as fdebitamount,
         case when bill.fdamount < 0 then  voucheraccount.fdatadirection * voucheraccount.fdc * bill.fdamountlocal else voucheraccount.fdc * bill.fdamountlocal end as fdebitamountlocal,         
         case when bill.fcamount < 0 then  voucheraccount.fdatadirection * ((1 - voucheraccount.fdc) * bill.fcamount) else (1 - voucheraccount.fdc) * bill.fcamount end as fcreditamount,
         case when bill.fcamount < 0 then  voucheraccount.fdatadirection * ((1 - voucheraccount.fdc) * bill.fcamountlocal) else (1 - voucheraccount.fdc) * bill.fcamountlocal end as fcreditdebitamountlocal     
  FROM   v_ar_checkaccountbill bill
         INNER JOIN v_ar_voucheraccount voucheraccount
                 ON bill.fentryid = voucheraccount.fsrcentryid
  WHERE  voucheraccount.fcontrol = 1;
  
      
If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='v_ar_checkaccount1')
Drop view v_ar_checkaccount1;

CREATE  VIEW v_ar_checkaccount1
AS
SELECT bill.fbilldate fbilldate,
         voucheraccount.fvoucherdate AS fvoucherdate,
         bill.fcompanyid fcompanyid,
         bill.fasstacttypeid fasstacttypeid,
         bill.fasstactid fasstactid,
         bill.fcurrencyid fcurrencyid,
         voucheraccount.FAccountCompanyID FAccountCompanyID,
         voucheraccount.FControlUnitID as FControlUnitID,
         voucheraccount.FAccountTableID as FAccountTableID,
         bill.FPersonID FPersonID,
         bill.FAdminOrgUnitID FAdminOrgUnitID,
         voucheraccount.faccountid faccountid,
         bill.fdirection as fdirection,   
         voucheraccount.voucherBizStatus as voucherBizStatus,       
         voucheraccount.fperiodyear as fperiodyear,
         voucheraccount.fperiodnumber as fperiodnumber,
         case when bill.fdamount < 0 then  voucheraccount.fdatadirection * voucheraccount.fdc * bill.fdamount else voucheraccount.fdc * bill.fdamount end as fdebitamount,
         case when bill.fdamount < 0 then  voucheraccount.fdatadirection * voucheraccount.fdc * bill.fdamountlocal else voucheraccount.fdc * bill.fdamountlocal end as fdebitamountlocal,         
         case when bill.fcamount < 0 then  voucheraccount.fdatadirection * ((1 - voucheraccount.fdc) * bill.fcamount) else (1 - voucheraccount.fdc) * bill.fcamount end as fcreditamount,
         case when bill.fcamount < 0 then  voucheraccount.fdatadirection * ((1 - voucheraccount.fdc) * bill.fcamountlocal) else (1 - voucheraccount.fdc) * bill.fcamountlocal end as fcreditdebitamountlocal     
  FROM   v_ar_checkaccountbill1 bill
         INNER JOIN v_ar_voucheraccount voucheraccount
                 ON bill.fentryid = voucheraccount.fsrcentryid
  WHERE  voucheraccount.fcontrol = 1;

If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='v_ar_checkaccount2')
Drop view v_ar_checkaccount2;

CREATE  VIEW v_ar_checkaccount2
AS
SELECT bill.fbilldate fbilldate,
         voucheraccount.fvoucherdate AS fvoucherdate,
         bill.fcompanyid fcompanyid,
         bill.fasstacttypeid fasstacttypeid,
         bill.fasstactid fasstactid,
         bill.fcurrencyid fcurrencyid,
         voucheraccount.FAccountCompanyID FAccountCompanyID,
         voucheraccount.FControlUnitID as FControlUnitID,
         voucheraccount.FAccountTableID as FAccountTableID,
         bill.FPersonID FPersonID,
         bill.FAdminOrgUnitID FAdminOrgUnitID,
         voucheraccount.faccountid faccountid,
         bill.fdirection as fdirection,   
         voucheraccount.voucherBizStatus as voucherBizStatus,    
         voucheraccount.fperiodyear as fperiodyear,
         voucheraccount.fperiodnumber as fperiodnumber,                             
         case when bill.fdamount < 0 then  voucheraccount.fdatadirection * voucheraccount.fdc * bill.fdamount else voucheraccount.fdc * bill.fdamount end as fdebitamount,
         case when bill.fdamount < 0 then  voucheraccount.fdatadirection * voucheraccount.fdc * bill.fdamountlocal else voucheraccount.fdc * bill.fdamountlocal end as fdebitamountlocal,         
         case when bill.fcamount < 0 then  voucheraccount.fdatadirection * ((1 - voucheraccount.fdc) * bill.fcamount) else (1 - voucheraccount.fdc) * bill.fcamount end as fcreditamount,
         case when bill.fcamount < 0 then  voucheraccount.fdatadirection * ((1 - voucheraccount.fdc) * bill.fcamountlocal) else (1 - voucheraccount.fdc) * bill.fcamountlocal end as fcreditdebitamountlocal     
  FROM   v_ar_checkaccountbill2 bill
         INNER JOIN v_ar_voucheraccount voucheraccount
                 ON bill.fentryid = voucheraccount.fsrcentryid
  WHERE  voucheraccount.fcontrol = 1;

If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='v_ar_checkaccount3')
Drop view v_ar_checkaccount3;

CREATE  VIEW v_ar_checkaccount3
AS
SELECT bill.fbilldate fbilldate,
         voucheraccount.fvoucherdate AS fvoucherdate,
         bill.fcompanyid fcompanyid,
         bill.fasstacttypeid fasstacttypeid,
         bill.fasstactid fasstactid,
         bill.fcurrencyid fcurrencyid,
         voucheraccount.FAccountCompanyID FAccountCompanyID,
         voucheraccount.FControlUnitID as FControlUnitID,
         voucheraccount.FAccountTableID as FAccountTableID,
         bill.FPersonID FPersonID,
         bill.FAdminOrgUnitID FAdminOrgUnitID,
         voucheraccount.faccountid faccountid,
         bill.fdirection as fdirection,   
         voucheraccount.voucherBizStatus as voucherBizStatus,       
         voucheraccount.fperiodyear as fperiodyear,
         voucheraccount.fperiodnumber as fperiodnumber,                          
         case when bill.fdamount < 0 then  voucheraccount.fdatadirection * voucheraccount.fdc * bill.fdamount else voucheraccount.fdc * bill.fdamount end as fdebitamount,
         case when bill.fdamount < 0 then  voucheraccount.fdatadirection * voucheraccount.fdc * bill.fdamountlocal else voucheraccount.fdc * bill.fdamountlocal end as fdebitamountlocal,         
         case when bill.fcamount < 0 then  voucheraccount.fdatadirection * ((1 - voucheraccount.fdc) * bill.fcamount) else (1 - voucheraccount.fdc) * bill.fcamount end as fcreditamount,
         case when bill.fcamount < 0 then  voucheraccount.fdatadirection * ((1 - voucheraccount.fdc) * bill.fcamountlocal) else (1 - voucheraccount.fdc) * bill.fcamountlocal end as fcreditdebitamountlocal     
  FROM   v_ar_checkaccountbill3 bill
         INNER JOIN v_ar_voucheraccount voucheraccount
                 ON bill.fentryid = voucheraccount.fsrcentryid
  WHERE  voucheraccount.fcontrol = 1;

If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='v_ar_checkaccount4')
Drop view v_ar_checkaccount4;

CREATE  VIEW v_ar_checkaccount4
AS
SELECT bill.fbilldate fbilldate,
         voucheraccount.fvoucherdate AS fvoucherdate,
         bill.fcompanyid fcompanyid,
         bill.fasstacttypeid fasstacttypeid,
         bill.fasstactid fasstactid,
         bill.fcurrencyid fcurrencyid,
         voucheraccount.FAccountCompanyID FAccountCompanyID,
         voucheraccount.FControlUnitID as FControlUnitID,
         voucheraccount.FAccountTableID as FAccountTableID,
         bill.FPersonID FPersonID,
         bill.FAdminOrgUnitID FAdminOrgUnitID,
         voucheraccount.faccountid faccountid,
         bill.fdirection as fdirection,   
         voucheraccount.voucherBizStatus as voucherBizStatus,       
         voucheraccount.fperiodyear as fperiodyear,
         voucheraccount.fperiodnumber as fperiodnumber,                          
         case when bill.fdamount < 0 then  voucheraccount.fdatadirection * voucheraccount.fdc * bill.fdamount else voucheraccount.fdc * bill.fdamount end as fdebitamount,
         case when bill.fdamount < 0 then  voucheraccount.fdatadirection * voucheraccount.fdc * bill.fdamountlocal else voucheraccount.fdc * bill.fdamountlocal end as fdebitamountlocal,         
         case when bill.fcamount < 0 then  voucheraccount.fdatadirection * ((1 - voucheraccount.fdc) * bill.fcamount) else (1 - voucheraccount.fdc) * bill.fcamount end as fcreditamount,
         case when bill.fcamount < 0 then  voucheraccount.fdatadirection * ((1 - voucheraccount.fdc) * bill.fcamountlocal) else (1 - voucheraccount.fdc) * bill.fcamountlocal end as fcreditdebitamountlocal     
  FROM   v_ar_checkaccountbill4 bill
         INNER JOIN v_ar_voucheraccount voucheraccount
                 ON bill.fentryid = voucheraccount.fsrcentryid
  WHERE  voucheraccount.fcontrol = 1;

If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='v_ar_checkaccount5')
Drop view v_ar_checkaccount5;

CREATE  VIEW v_ar_checkaccount5
AS
SELECT bill.fbilldate as fbilldate,
    voucheraccount.fvoucherdate AS fvoucherdate,
    bill.FCompanyID as fcompanyid,
    sourceBill.FAsstActTypeID AS fasstacttypeid,
    sourceBill.FAsstActID as fasstactid,
    bill.FCurrencyID as fcurrencyid,
    voucheraccount.FAccountCompanyID FAccountCompanyID,
    voucheraccount.FControlUnitID as FControlUnitID,
    voucheraccount.FAccountTableID as FAccountTableID,    
    sourceBill.FPersonID FPersonID,
    sourceBill.FAdminOrgUnitID FAdminOrgUnitID,
    voucherAccount.FAccountID AS faccountid,
    1 as fdirection,    
    voucheraccount.voucherBizStatus as voucherBizStatus,     
    voucheraccount.fperiodyear as fperiodyear,
    voucheraccount.fperiodnumber as fperiodnumber,        
    (voucherAccount.FDC * otherbillentry.FRecievePayAmount) AS fdebitamount,
    (voucherAccount.FDC * otherbillentry.FRecievePayAmountLocal) AS fdebitamountlocal,
    ((1 - voucherAccount.FDC) * otherbillentry.FRecievePayAmount) AS fcreditamount,
    ((1 - voucherAccount.FDC) * otherbillentry.FRecievePayAmountLocal) AS fcreditdebitamountlocal
FROM T_AR_OtherBill bill 
INNER JOIN T_AR_OtherBillEntry otherbillentry ON bill.FID = otherbillentry.FParentID
INNER JOIN T_AR_OtherBill sourceBill ON otherbillentry.FSourceBillID = sourceBill.FID
INNER JOIN V_AR_VoucherAccount voucherAccount ON otherbillentry.FID = voucherAccount.FSrcEntryID
WHERE bill.FFivouchered=1 AND (bill.FIsTransBill = 1) and voucheraccount.fdc = 0 and voucheraccount.fcontrol = 1;

If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='v_ar_checkaccount6')
Drop view v_ar_checkaccount6;

CREATE  VIEW v_ar_checkaccount6
AS
SELECT bill.fbilldate fbilldate,
    voucheraccount.fvoucherdate AS fvoucherdate,
    bill.FCompanyID as fcompanyid,
    bill.FAsstActTypeID AS fasstacttypeid,
    bill.FAsstActID as fasstactid,
    bill.FCurrencyID as fcurrencyid,
    voucheraccount.FAccountCompanyID FAccountCompanyID,
    voucheraccount.FControlUnitID as FControlUnitID,
    voucheraccount.FAccountTableID as FAccountTableID,        
    bill.FPersonID FPersonID,
    bill.FAdminOrgUnitID FAdminOrgUnitID,
    voucherAccount.FAccountID AS faccountid,
    1 as fdirection,
    voucheraccount.voucherBizStatus as voucherBizStatus,    
    voucheraccount.fperiodyear as fperiodyear,
    voucheraccount.fperiodnumber as fperiodnumber,         
    (voucherAccount.FDC * otherBillEntry.FRecievePayAmount) AS fdebitamount,
    (voucherAccount.FDC * otherBillEntry.FRecievePayAmountLocal) AS fdebitamountlocal,
    ((1 - voucherAccount.FDC) * otherBillEntry.FRecievePayAmount) AS fcreditamount,
    ((1 - voucherAccount.FDC) * otherBillEntry.FRecievePayAmountLocal) AS fcreditdebitamountlocal
FROM T_AR_OtherBill bill 
     INNER JOIN T_AR_OtherBillEntry otherBillEntry ON bill.FID = otherBillEntry.FParentID
     INNER JOIN V_AR_VoucherAccount voucherAccount ON otherBillEntry.FID = voucherAccount.FSrcEntryID
WHERE bill.FFivouchered=1 AND (bill.FIsTransBill = 1) and voucheraccount.fdc = 1 and voucheraccount.fcontrol = 1;

If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='v_ar_checkaccount7')
Drop view v_ar_checkaccount7;

CREATE  VIEW v_ar_checkaccount7
AS
SELECT bill.fbizdate fbilldate,
         voucheraccount.fvoucherdate AS fvoucherdate,
       bill.fcompanyid fcompanyid,
       sourcebill.fpayertypeid fasstacttypeid,
       sourcebill.fpayerid fasstactid,
       bill.fcurrencyid fcurrencyid,
       voucheraccount.FAccountCompanyID FAccountCompanyID,
       voucheraccount.FControlUnitID as FControlUnitID,
       voucheraccount.FAccountTableID as FAccountTableID,    
       sourcebill.fpersonid fpersonid,
       sourcebill.fadminorgunitid fadminorgunitid,
       voucherAccount.FAccountID AS faccountid,
       1 as fdirection,         
       voucheraccount.voucherBizStatus as voucherBizStatus,   
       voucheraccount.fperiodyear as fperiodyear,
       voucheraccount.fperiodnumber as fperiodnumber,                         
       (voucherAccount.FDC * billentry.famount) AS fdebitamount,
       (voucherAccount.FDC * billentry.flocalamount) AS fdebitamountlocal,
       ((1 - voucherAccount.FDC) * billentry.famount) AS fcreditamount,
       ((1 - voucherAccount.FDC) * billentry.flocalamount) AS fcreditdebitamountlocal    
  FROM   t_cas_receivingbill bill
         INNER JOIN t_cas_receivingbillentry billentry
               ON bill.fid = billentry.freceivingbillid                
         INNER JOIN t_cas_receivingbill sourcebill    
               ON   billentry.fsourcebillid = sourcebill.fid 
         INNER JOIN V_AR_VoucherAccount voucherAccount 
               ON billentry.FID = voucherAccount.FSrcEntryID          
  WHERE  (bill.fsourcetype = 100 AND bill.ffivouchered = 1 and bill.FIsTransBill = 1 )  and 
          --收款转移单,取源单的借方数据
         (bill.FIsTransOtherBill = 0 and voucheraccount.fdc = 1 and voucheraccount.fcontrol = 1) 
         and  (sourcebill.FPayerTypeID is not null or  ltrim(rtrim(sourcebill.FPayerTypeID)) != '' or sourcebill.FPayerID is not null or  ltrim(rtrim(sourcebill.FPayerID)) != '') ;

If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='v_ar_checkaccount8')
Drop view v_ar_checkaccount8;

CREATE  VIEW v_ar_checkaccount8
AS
SELECT bill.fbizdate fbilldate,
  	   voucheraccount.fvoucherdate AS fvoucherdate,
       bill.fcompanyid fcompanyid,
       sourcebill.fasstacttypeid fasstacttypeid,
       sourcebill.fasstactid fasstactid,
       bill.fcurrencyid fcurrencyid,
       voucheraccount.FAccountCompanyID FAccountCompanyID,
       voucheraccount.FControlUnitID as FControlUnitID,
       voucheraccount.FAccountTableID as FAccountTableID,    
       sourcebill.fpersonid fpersonid,
       sourcebill.fadminorgunitid fadminorgunitid,
       voucherAccount.FAccountID AS faccountid,
       1 as fdirection,  
       voucheraccount.voucherBizStatus as voucherBizStatus,    
       voucheraccount.fperiodyear as fperiodyear,
       voucheraccount.fperiodnumber as fperiodnumber,                               
       (voucherAccount.FDC * billentry.famount) AS fdebitamount,
       (voucherAccount.FDC * billentry.flocalamount) AS fdebitamountlocal,
       ((1 - voucherAccount.FDC) * billentry.famount) AS fcreditamount,
       ((1 - voucherAccount.FDC) * billentry.flocalamount) AS fcreditdebitamountlocal    
  FROM   t_cas_paymentbill bill
         INNER JOIN t_cas_paymentbillentry billentry
               ON bill.fid = billentry.fpaymentbillid
		 INNER JOIN t_ar_otherbill sourcebill    
		       ON   billentry.fsourcebillid = sourcebill.fid 
		 INNER JOIN V_AR_VoucherAccount voucherAccount 
		       ON billentry.FID = voucherAccount.FSrcEntryID          
  WHERE  (bill.fsourcetype = 101 AND bill.ffivouchered = 1 and bill.FIsTransBill = 1 )  and          
          --应付转预收,取源单的贷方数据
           (bill.FIsTransOtherBill = 1 and voucheraccount.fdc = 0 and voucheraccount.fcontrol = 1);       
 
If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='v_ar_checkaccount9')
Drop view v_ar_checkaccount9;

CREATE  VIEW v_ar_checkaccount9
AS
 SELECT bill.fbizdate fbilldate,
         voucheraccount.fvoucherdate AS fvoucherdate,
       bill.fcompanyid fcompanyid,
       bill.fpayertypeid fasstacttypeid,
       bill.fpayerid fasstactid,
       bill.fcurrencyid fcurrencyid,
       voucheraccount.FAccountCompanyID FAccountCompanyID,
       voucheraccount.FControlUnitID as FControlUnitID,
       voucheraccount.FAccountTableID as FAccountTableID,    
       bill.fpersonid fpersonid,
       bill.fadminorgunitid fadminorgunitid,
       voucherAccount.FAccountID AS faccountid,
       1 as fdirection,    
       voucheraccount.voucherBizStatus as voucherBizStatus,   
       voucheraccount.fperiodyear as fperiodyear,
       voucheraccount.fperiodnumber as fperiodnumber,                      
       (voucherAccount.FDC * billentry.famount) AS fdebitamount,
       (voucherAccount.FDC * billentry.flocalamount) AS fdebitamountlocal,
       ((1 - voucherAccount.FDC) * billentry.famount) AS fcreditamount,
       ((1 - voucherAccount.FDC) * billentry.flocalamount) AS fcreditdebitamountlocal    
  FROM   t_cas_receivingbill bill
         INNER JOIN t_cas_receivingbillentry billentry
               ON bill.fid = billentry.freceivingbillid    
         INNER JOIN V_AR_VoucherAccount voucherAccount 
               ON billentry.FID = voucherAccount.FSrcEntryID          
  WHERE  bill.fsourcetype = 100  AND bill.ffivouchered = 1 and bill.FIsTransBill = 1 
          --收款转移单,取目标单贷方数据--应付转预收,取源单的贷方数据
           and voucheraccount.fdc = 0 and voucheraccount.fcontrol = 1
           and  (bill.FPayerTypeID is not null or  ltrim(rtrim(bill.FPayerTypeID)) != '' or bill.FPayerID is not null or  ltrim(rtrim(bill.FPayerID)) != '');


If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='v_ap_checkaccount')
Drop view v_ap_checkaccount;

CREATE  VIEW v_ap_checkaccount
AS
  SELECT bill.fbilldate as fbilldate,
         voucheraccount.fvoucherdate as fvoucherdate,
         bill.fcompanyid as fcompanyid,
         bill.fasstacttypeid as fasstacttypeid,
         bill.fasstactid as fasstactid,
         bill.fcurrencyid as fcurrencyid,
         voucheraccount.FAccountCompanyID FAccountCompanyID,
    	 voucheraccount.FControlUnitID as FControlUnitID,
	     voucheraccount.FAccountTableID as FAccountTableID,	         
         bill.fpersonid  as fpersonid,
         bill.fadminorgunitid  as fadminorgunitid,
         voucheraccount.faccountid as faccountid,
         bill.fdirection as fdirection,    
	     voucheraccount.voucherBizStatus as voucherBizStatus,    
         voucheraccount.fperiodyear as fperiodyear,
         voucheraccount.fperiodnumber as fperiodnumber,         	   
         case when bill.fdamount < 0 then  voucheraccount.fdatadirection * voucheraccount.fdc * bill.fdamount else voucheraccount.fdc * bill.fdamount end as fdebitamount,
         case when bill.fdamount < 0 then  voucheraccount.fdatadirection * voucheraccount.fdc * bill.fdamountlocal else voucheraccount.fdc * bill.fdamountlocal end as fdebitamountlocal,         
         case when bill.fcamount < 0 then  voucheraccount.fdatadirection * ((1 - voucheraccount.fdc) * bill.fcamount) else (1 - voucheraccount.fdc) * bill.fcamount end as fcreditamount,
         case when bill.fcamount < 0 then  voucheraccount.fdatadirection * ((1 - voucheraccount.fdc) * bill.fcamountlocal) else (1 - voucheraccount.fdc) * bill.fcamountlocal end as fcreditdebitamountlocal     
  FROM   v_ap_checkaccountbill bill
         INNER JOIN v_ar_voucheraccount voucheraccount
                 ON bill.fentryid = voucheraccount.fsrcentryid
  WHERE  voucheraccount.fcontrol = 2;
  
     
If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='v_ap_checkaccount1')
Drop view v_ap_checkaccount1;
     
CREATE  VIEW v_ap_checkaccount1
AS
  SELECT bill.fbilldate as fbilldate,
         voucheraccount.fvoucherdate as fvoucherdate,
         bill.fcompanyid as fcompanyid,
         bill.fasstacttypeid as fasstacttypeid,
         bill.fasstactid as fasstactid,
         bill.fcurrencyid as fcurrencyid,
         voucheraccount.FAccountCompanyID FAccountCompanyID,
    	 voucheraccount.FControlUnitID as FControlUnitID,
	     voucheraccount.FAccountTableID as FAccountTableID,	         
         bill.fpersonid  as fpersonid,
         bill.fadminorgunitid  as fadminorgunitid,
         voucheraccount.faccountid as faccountid,
         bill.fdirection as fdirection,    
	     voucheraccount.voucherBizStatus as voucherBizStatus,  
         voucheraccount.fperiodyear as fperiodyear,
         voucheraccount.fperiodnumber as fperiodnumber,         	     
         case when bill.fdamount < 0 then  voucheraccount.fdatadirection * voucheraccount.fdc * bill.fdamount else voucheraccount.fdc * bill.fdamount end as fdebitamount,
         case when bill.fdamount < 0 then  voucheraccount.fdatadirection * voucheraccount.fdc * bill.fdamountlocal else voucheraccount.fdc * bill.fdamountlocal end as fdebitamountlocal,         
         case when bill.fcamount < 0 then  voucheraccount.fdatadirection * ((1 - voucheraccount.fdc) * bill.fcamount) else (1 - voucheraccount.fdc) * bill.fcamount end as fcreditamount,
         case when bill.fcamount < 0 then  voucheraccount.fdatadirection * ((1 - voucheraccount.fdc) * bill.fcamountlocal) else (1 - voucheraccount.fdc) * bill.fcamountlocal end as fcreditdebitamountlocal     
  FROM   v_ap_checkaccountbill1 bill
         INNER JOIN v_ar_voucheraccount voucheraccount
                 ON bill.fentryid = voucheraccount.fsrcentryid
  WHERE  voucheraccount.fcontrol = 2;

If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='v_ap_checkaccount2')
Drop view v_ap_checkaccount2;
     
CREATE  VIEW v_ap_checkaccount2
AS
  SELECT bill.fbilldate as fbilldate,
         voucheraccount.fvoucherdate as fvoucherdate,
         bill.fcompanyid as fcompanyid,
         bill.fasstacttypeid as fasstacttypeid,
         bill.fasstactid as fasstactid,
         bill.fcurrencyid as fcurrencyid,
         voucheraccount.FAccountCompanyID FAccountCompanyID,
    	 voucheraccount.FControlUnitID as FControlUnitID,
	     voucheraccount.FAccountTableID as FAccountTableID,	         
         bill.fpersonid  as fpersonid,
         bill.fadminorgunitid  as fadminorgunitid,
         voucheraccount.faccountid as faccountid,
         bill.fdirection as fdirection,    
	     voucheraccount.voucherBizStatus as voucherBizStatus,      
         voucheraccount.fperiodyear as fperiodyear,
         voucheraccount.fperiodnumber as fperiodnumber,         	 
         case when bill.fdamount < 0 then  voucheraccount.fdatadirection * voucheraccount.fdc * bill.fdamount else voucheraccount.fdc * bill.fdamount end as fdebitamount,
         case when bill.fdamount < 0 then  voucheraccount.fdatadirection * voucheraccount.fdc * bill.fdamountlocal else voucheraccount.fdc * bill.fdamountlocal end as fdebitamountlocal,         
         case when bill.fcamount < 0 then  voucheraccount.fdatadirection * ((1 - voucheraccount.fdc) * bill.fcamount) else (1 - voucheraccount.fdc) * bill.fcamount end as fcreditamount,
         case when bill.fcamount < 0 then  voucheraccount.fdatadirection * ((1 - voucheraccount.fdc) * bill.fcamountlocal) else (1 - voucheraccount.fdc) * bill.fcamountlocal end as fcreditdebitamountlocal     
  FROM   v_ap_checkaccountbill2 bill
         INNER JOIN v_ar_voucheraccount voucheraccount
                 ON bill.fentryid = voucheraccount.fsrcentryid
  WHERE  voucheraccount.fcontrol = 2;
     

If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='v_ap_checkaccount3')
Drop view v_ap_checkaccount3;
     
CREATE  VIEW v_ap_checkaccount3
AS
  SELECT bill.fbilldate as fbilldate,
         voucheraccount.fvoucherdate as fvoucherdate,
         bill.fcompanyid as fcompanyid,
         bill.fasstacttypeid as fasstacttypeid,
         bill.fasstactid as fasstactid,
         bill.fcurrencyid as fcurrencyid,
         voucheraccount.FAccountCompanyID FAccountCompanyID,
    	 voucheraccount.FControlUnitID as FControlUnitID,
	     voucheraccount.FAccountTableID as FAccountTableID,	         
         bill.fpersonid  as fpersonid,
         bill.fadminorgunitid  as fadminorgunitid,
         voucheraccount.faccountid as faccountid,
         bill.fdirection as fdirection,    
	     voucheraccount.voucherBizStatus as voucherBizStatus,     
         voucheraccount.fperiodyear as fperiodyear,
         voucheraccount.fperiodnumber as fperiodnumber,         	  
         case when bill.fdamount < 0 then  voucheraccount.fdatadirection * voucheraccount.fdc * bill.fdamount else voucheraccount.fdc * bill.fdamount end as fdebitamount,
         case when bill.fdamount < 0 then  voucheraccount.fdatadirection * voucheraccount.fdc * bill.fdamountlocal else voucheraccount.fdc * bill.fdamountlocal end as fdebitamountlocal,         
         case when bill.fcamount < 0 then  voucheraccount.fdatadirection * ((1 - voucheraccount.fdc) * bill.fcamount) else (1 - voucheraccount.fdc) * bill.fcamount end as fcreditamount,
         case when bill.fcamount < 0 then  voucheraccount.fdatadirection * ((1 - voucheraccount.fdc) * bill.fcamountlocal) else (1 - voucheraccount.fdc) * bill.fcamountlocal end as fcreditdebitamountlocal     
  FROM   v_ap_checkaccountbill3 bill
         INNER JOIN v_ar_voucheraccount voucheraccount
                 ON bill.fentryid = voucheraccount.fsrcentryid
  WHERE  voucheraccount.fcontrol = 2;
       

If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='v_ap_checkaccount4')
Drop view v_ap_checkaccount4;
     
CREATE  VIEW v_ap_checkaccount4
AS
  SELECT bill.fbilldate as fbilldate,
         voucheraccount.fvoucherdate as fvoucherdate,
         bill.fcompanyid as fcompanyid,
         bill.fasstacttypeid as fasstacttypeid,
         bill.fasstactid as fasstactid,
         bill.fcurrencyid as fcurrencyid,
         voucheraccount.FAccountCompanyID FAccountCompanyID,
    	 voucheraccount.FControlUnitID as FControlUnitID,
	     voucheraccount.FAccountTableID as FAccountTableID,	         
         bill.fpersonid  as fpersonid,
         bill.fadminorgunitid  as fadminorgunitid,
         voucheraccount.faccountid as faccountid,
         bill.fdirection as fdirection,    
	     voucheraccount.voucherBizStatus as voucherBizStatus,     
         voucheraccount.fperiodyear as fperiodyear,
         voucheraccount.fperiodnumber as fperiodnumber,         	  
         case when bill.fdamount < 0 then  voucheraccount.fdatadirection * voucheraccount.fdc * bill.fdamount else voucheraccount.fdc * bill.fdamount end as fdebitamount,
         case when bill.fdamount < 0 then  voucheraccount.fdatadirection * voucheraccount.fdc * bill.fdamountlocal else voucheraccount.fdc * bill.fdamountlocal end as fdebitamountlocal,         
         case when bill.fcamount < 0 then  voucheraccount.fdatadirection * ((1 - voucheraccount.fdc) * bill.fcamount) else (1 - voucheraccount.fdc) * bill.fcamount end as fcreditamount,
         case when bill.fcamount < 0 then  voucheraccount.fdatadirection * ((1 - voucheraccount.fdc) * bill.fcamountlocal) else (1 - voucheraccount.fdc) * bill.fcamountlocal end as fcreditdebitamountlocal     
  FROM   v_ap_checkaccountbill4 bill
         INNER JOIN v_ar_voucheraccount voucheraccount
                 ON bill.fentryid = voucheraccount.fsrcentryid
  WHERE  voucheraccount.fcontrol = 2;
         
If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='v_ap_checkaccount5')
Drop view v_ap_checkaccount5;
     
CREATE  VIEW v_ap_checkaccount5
AS
  SELECT bill.fbilldate as fbilldate,
         voucheraccount.fvoucherdate as fvoucherdate,
         bill.fcompanyid as fcompanyid,
         sourcebill.fasstacttypeid as fasstacttypeid,
         sourcebill.fasstactid as fasstactid,
         bill.fcurrencyid as fcurrencyid,
         voucheraccount.FAccountCompanyID FAccountCompanyID,
    	 voucheraccount.FControlUnitID as FControlUnitID,
	     voucheraccount.FAccountTableID as FAccountTableID,	                  
         sourcebill.fpersonid as fpersonid,
         sourcebill.fadminorgunitid as fadminorgunitid,
         voucheraccount.faccountid as faccountid,
         1 as fdirection,
         voucheraccount.voucherBizStatus as voucherBizStatus,
         voucheraccount.fperiodyear as fperiodyear,
         voucheraccount.fperiodnumber as fperiodnumber,                  
         (voucheraccount.fdc * otherbillentry.frecievepayamount) as fdebitamount,
         (voucheraccount.fdc * otherbillentry.frecievepayamountlocal) as fdebitamountlocal,
         ((1 - voucheraccount.fdc) * otherbillentry.frecievepayamount) as fcreditamount,
         ((1 - voucheraccount.fdc) * otherbillentry.frecievepayamountlocal) as fcreditdebitamountlocal         
   FROM  t_ap_otherbill bill
         INNER JOIN t_ap_otherbillentry otherbillentry
                 ON bill.fid = otherbillentry.fparentid
		 INNER JOIN t_ap_otherbill sourcebill       
		         ON  otherbillentry.fsourcebillid = sourcebill.fid		          
         INNER JOIN v_ar_voucheraccount voucheraccount
                 ON otherbillentry.fid = voucheraccount.fsrcentryid
  WHERE  bill.ffivouchered = 1
         AND (bill.fistransbill = 1)
         AND voucheraccount.fdc = 1
         AND voucheraccount.fcontrol = 2;
         
  If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='v_ap_checkaccount6')
Drop view v_ap_checkaccount6;
     
CREATE  VIEW v_ap_checkaccount6
AS
  SELECT bill.fbilldate as fbilldate,
         voucheraccount.fvoucherdate AS fvoucherdate,
         bill.fcompanyid AS fcompanyid,
         bill.fasstacttypeid AS fasstacttypeid,
         bill.fasstactid AS fasstactid,
         bill.fcurrencyid AS fcurrencyid,
         voucheraccount.FAccountCompanyID FAccountCompanyID,
    	 voucheraccount.FControlUnitID as FControlUnitID,
	     voucheraccount.FAccountTableID as FAccountTableID,	                  
         bill.fpersonid as fpersonid,
         bill.fadminorgunitid as fadminorgunitid,
         voucheraccount.faccountid AS faccountid,
         1 as fdirection,
         voucheraccount.voucherBizStatus as voucherBizStatus,
         voucheraccount.fperiodyear as fperiodyear,
         voucheraccount.fperiodnumber as fperiodnumber,                  
         (voucheraccount.fdc * otherBillEntry.frecievepayamount) AS fdebitamount,
         (voucheraccount.fdc * otherBillEntry.frecievepayamountlocal) AS fdebitamountlocal,
         ((1 - voucheraccount.fdc) * otherBillEntry.frecievepayamount) AS fcreditamount,
         ((1 - voucheraccount.fdc) * otherBillEntry.frecievepayamountlocal) AS fcreditdebitamountlocal         
  FROM   t_ap_otherbill bill
         INNER JOIN t_ap_otherbillentry otherBillEntry
                 ON bill.fid = otherBillEntry.fparentid
         INNER JOIN v_ar_voucheraccount voucheraccount
                 ON otherBillEntry.fid = voucheraccount.fsrcentryid
  WHERE  bill.ffivouchered = 1
         AND (bill.fistransbill = 1)
         AND voucheraccount.fdc = 0
         AND voucheraccount.fcontrol = 2;
         

--核销记录做凭证，反写应付单，来源单据类型非代理业务单，这种类型的应付单按科目参与对账
If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='v_ap_checkaccount7')
Drop view v_ap_checkaccount7;
     
CREATE  VIEW v_ap_checkaccount7
AS
  SELECT bill.fbilldate as fbilldate,
         voucher.FBookedDate as fvoucherdate,
         bill.fcompanyid as fcompanyid,
         bill.fasstacttypeid as fasstacttypeid,
         bill.fasstactid as fasstactid,
         bill.fcurrencyid as fcurrencyid,
         voucheraccount.fcompanyid FAccountCompanyID,
    	 voucheraccount.FControlUnitID as FControlUnitID,
	     voucheraccount.FAccountTableID as FAccountTableID,	                  
         bill.fpersonid as fpersonid,
         bill.fadminorgunitid as fadminorgunitid,
         voucheraccount.faccountid as faccountid,
         1 as fdirection,
         -1 as voucherBizStatus,
         voucheraccount.fperiodyear as fperiodyear,
         voucheraccount.fperiodnumber as fperiodnumber,                  
         0 as fdebitamount,
         0 as fdebitamountlocal,
         otherbillentry.frecievepayamount as fcreditamount,
         otherbillentry.frecievepayamountlocal as fcreditdebitamountlocal         
   FROM  t_ap_otherbill bill
         INNER JOIN t_ap_otherbillentry otherbillentry
                 ON bill.fid = otherbillentry.fparentid	
         INNER JOIN t_gl_voucher voucher
                 ON bill.FVoucherID = voucher.FID
         INNER JOIN v_ar_accountviewunion voucheraccount
                 ON otherbillentry.faccountid = voucheraccount.faccountid
  WHERE  bill.ffivouchered = 1 AND voucheraccount.fsystem = 2  AND bill.FSourceBillType != 14  and bill.FIsNeedVoucher = 1
  and bill.FID not in (select fsrcobjectid  from t_bot_relation where FDestEntityID = '2652E01E');
  

If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='v_ap_checkaccount8')
Drop view v_ap_checkaccount8;
     
CREATE  VIEW v_ap_checkaccount8
AS
SELECT bill.fbizdate fbilldate,
  	   voucheraccount.fvoucherdate AS fvoucherdate,
       bill.fcompanyid fcompanyid,
       sourcebill.fpayeetypeid fasstacttypeid,
       sourcebill.fpayeeid fasstactid,
       bill.fcurrencyid fcurrencyid,
       voucheraccount.FAccountCompanyID FAccountCompanyID,
       voucheraccount.FControlUnitID as FControlUnitID,
       voucheraccount.FAccountTableID as FAccountTableID,    
       sourcebill.fpersonid fpersonid,
       sourcebill.fadminorgunitid fadminorgunitid,
       voucherAccount.FAccountID AS faccountid,
       1 as fdirection,            
       voucheraccount.voucherBizStatus as voucherBizStatus, 
       voucheraccount.fperiodyear as fperiodyear,
       voucheraccount.fperiodnumber as fperiodnumber,                
       (voucherAccount.FDC * billentry.famount) AS fdebitamount,
       (voucherAccount.FDC * billentry.flocalamount) AS fdebitamountlocal,
       ((1 - voucherAccount.FDC) * billentry.famount) AS fcreditamount,
       ((1 - voucherAccount.FDC) * billentry.flocalamount) AS fcreditdebitamountlocal    
  FROM   t_cas_paymentbill bill
         INNER JOIN t_cas_paymentbillentry billentry
               ON bill.fid = billentry.fpaymentbillid
		 INNER JOIN t_cas_paymentbill sourcebill    
		       ON   billentry.fsourcebillid = sourcebill.fid 
		 INNER JOIN V_AR_VoucherAccount voucherAccount 
		       ON billentry.FID = voucherAccount.FSrcEntryID          
  WHERE  (bill.fsourcetype = 101 AND bill.ffivouchered = 1 and bill.FIsTransBill = 1 )  and 
          --付款转移单,取源单的贷方数据
         (bill.FIsTransOtherBill = 0 and voucheraccount.fdc = 0 and voucheraccount.fcontrol = 2);

If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='v_ap_checkaccount9')
Drop view v_ap_checkaccount9;
     
CREATE  VIEW v_ap_checkaccount9
AS
SELECT bill.fbizdate fbilldate,
         voucheraccount.fvoucherdate AS fvoucherdate,
       bill.fcompanyid fcompanyid,
       sourcebill.fasstacttypeid fasstacttypeid,
       sourcebill.fasstactid fasstactid,
       bill.fcurrencyid fcurrencyid,
       voucheraccount.FAccountCompanyID FAccountCompanyID,
       voucheraccount.FControlUnitID as FControlUnitID,
       voucheraccount.FAccountTableID as FAccountTableID,    
       sourcebill.fpersonid fpersonid,
       sourcebill.fadminorgunitid fadminorgunitid,
       voucherAccount.FAccountID AS faccountid,
       1 as fdirection,      
       voucheraccount.voucherBizStatus as voucherBizStatus,  
       voucheraccount.fperiodyear as fperiodyear,
       voucheraccount.fperiodnumber as fperiodnumber,                    
       (voucherAccount.FDC * billentry.famount) AS fdebitamount,
       (voucherAccount.FDC * billentry.flocalamount) AS fdebitamountlocal,
       ((1 - voucherAccount.FDC) * billentry.famount) AS fcreditamount,
       ((1 - voucherAccount.FDC) * billentry.flocalamount) AS fcreditdebitamountlocal    
  FROM   t_cas_receivingbill bill
         INNER JOIN t_cas_receivingbillentry billentry
               ON bill.fid = billentry.freceivingbillid
         INNER JOIN t_ap_otherbill sourcebill    
               ON   billentry.fsourcebillid = sourcebill.fid 
         INNER JOIN V_AR_VoucherAccount voucherAccount 
               ON billentry.FID = voucherAccount.FSrcEntryID          
  WHERE  (bill.fsourcetype = 100 AND bill.ffivouchered = 1 and bill.FIsTransBill = 1 )  and         
          --应付转预收,取源单的借方数据
           (bill.FIsTransOtherBill = 1 and voucheraccount.fdc = 1 and voucheraccount.fcontrol = 2);
            
If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='v_ap_checkaccount10')
Drop view v_ap_checkaccount10;
     
CREATE  VIEW v_ap_checkaccount10
AS
 SELECT bill.fbizdate fbilldate,
  	   voucheraccount.fvoucherdate AS fvoucherdate,
       bill.fcompanyid fcompanyid,
       bill.fpayeetypeid fasstacttypeid,
       bill.fpayeeid fasstactid,
       bill.fcurrencyid fcurrencyid,
       voucheraccount.FAccountCompanyID FAccountCompanyID,
       voucheraccount.FControlUnitID as FControlUnitID,
       voucheraccount.FAccountTableID as FAccountTableID,    
       bill.fpersonid fpersonid,
       bill.fadminorgunitid fadminorgunitid,
       voucherAccount.FAccountID AS faccountid,
       1 as fdirection,      
       voucheraccount.voucherBizStatus as voucherBizStatus,     
       voucheraccount.fperiodyear as fperiodyear,
       voucheraccount.fperiodnumber as fperiodnumber,                  
       (voucherAccount.FDC * billentry.famount) AS fdebitamount,
       (voucherAccount.FDC * billentry.flocalamount) AS fdebitamountlocal,
       ((1 - voucherAccount.FDC) * billentry.famount) AS fcreditamount,
       ((1 - voucherAccount.FDC) * billentry.flocalamount) AS fcreditdebitamountlocal    
  FROM   t_cas_paymentbill bill
         INNER JOIN t_cas_paymentbillentry billentry
               ON bill.fid = billentry.fpaymentbillid	
		 INNER JOIN V_AR_VoucherAccount voucherAccount 
		       ON billentry.FID = voucherAccount.FSrcEntryID          
  WHERE  bill.fsourcetype = 101 AND bill.ffivouchered = 1 and bill.FIsTransBill = 1 and
          --付款转移单,取目标单借方数据,--应收转预付,取目标单借方数据
          voucheraccount.fdc = 1 and voucheraccount.fcontrol = 2;  
          
          
If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='v_ar_checkauditedorvouchered')
Drop view v_ar_checkauditedorvouchered;

CREATE VIEW v_ar_checkauditedorvouchered
AS
  SELECT fid,
         'otherbill' fbilltypedes,
         -1 as fbilltype,
         -1 as fveriType,
         fnumber,
         fcompanyid,
         fbilldate,
         fcreatorid,
         fcreatetime,
         flastupdateuserid,
         flastupdatetime,
         fcontrolunitid,
         CASE fbillstatus
           WHEN 3 THEN 1
           ELSE 0
         END fisaudited,
         CASE FIsNeedVoucher*fsourcebilltype when 0 then 1 when 17 then 1 else ISNULL(FFiVouchered,0) end as ffivouchered
  FROM   t_ar_otherbill
  UNION ALL
  SELECT distinct bill.fid as fid,
         'receivingbill' fbilltypedes,
	 case rtrim(billType.fnumber)
	 when '100' then TO_INTEGER(rtrim(billType.fnumber))
	 when '101' then TO_INTEGER(rtrim(billType.fnumber))
	 when '102' then TO_INTEGER(rtrim(billType.fnumber))
	 when '103' then TO_INTEGER(rtrim(billType.fnumber))
     when '104' then TO_INTEGER(rtrim(billType.fnumber))
 	 when '105' then TO_INTEGER(rtrim(billType.fnumber))
	 when '121' then TO_INTEGER(rtrim(billType.fnumber))
	 when '999' then TO_INTEGER(rtrim(billType.fnumber))
	 else 100 end fbilltype,
         1 as fveriType,
         bill.fnumber as fnumber,
         bill.fcompanyid as fcompanyid,
         bill.fbizdate as  fbilldate,
         bill.fcreatorid as fcreatorid,
         bill.fcreatetime as fcreatetime,
         bill.flastupdateuserid as flastupdateuserid,
         bill.flastupdatetime as flastupdatetime,
         bill.fcontrolunitid as fcontrolunitid,
         CASE bill.fbillstatus
           WHEN 10 THEN 0
           WHEN 11 THEN 0
           WHEN 12 THEN 0
           ELSE 1
         END fisaudited,
         CASE bill.FIsNeedVoucher when 1 then ISNULL(bill.FFiVouchered,0) else 1 end as ffivouchered
  FROM   t_cas_receivingbill bill inner join t_cas_receivingbillEntry billEntry on bill.fid = billEntry.freceivingbillid  inner join  T_CAS_ReceivingBillType  billType on billEntry.FRecBillTypeID = billType.FID  WHERE bill.fsourcetype = 100
  UNION ALL
    SELECT bill.fid as fid,
         'receivingbill' fbilltypedes,
	 case rtrim(billType.fnumber)
	 when '100' then TO_INTEGER(rtrim(billType.fnumber))
	 when '101' then TO_INTEGER(rtrim(billType.fnumber))
	 when '102' then TO_INTEGER(rtrim(billType.fnumber))
	 when '103' then TO_INTEGER(rtrim(billType.fnumber))
     when '104' then TO_INTEGER(rtrim(billType.fnumber))
 	 when '105' then TO_INTEGER(rtrim(billType.fnumber))
	 when '121' then TO_INTEGER(rtrim(billType.fnumber))
	 when '999' then TO_INTEGER(rtrim(billType.fnumber))
	 else 100 end fbilltype,
         1 as fveriType,
         bill.fnumber as fnumber,
         bill.fcompanyid as fcompanyid,
         bill.fbizdate as  fbilldate,
         bill.fcreatorid as fcreatorid,
         bill.fcreatetime as fcreatetime,
         bill.flastupdateuserid as flastupdateuserid,
         bill.flastupdatetime as flastupdatetime,
         bill.fcontrolunitid as fcontrolunitid,
         0 as fisaudited,
         1 as ffivouchered
  FROM   t_cas_receivingbill bill inner join  T_CAS_ReceivingBillType  billType on bill.FRecBillTypeID = billType.FID  WHERE bill.fsourcetype = 100 and bill.fbillstatus >= 12
  and  (bill.FPayerTypeID is null or  ltrim(rtrim(bill.FPayerTypeID)) = '' or bill.FPayerID is null or  ltrim(rtrim(bill.FPayerID)) = '') 
  UNION ALL
  SELECT fid,
         'badacct' fbilltypedes,
         -1 as fbilltype,
         -1 as fveriType,
         fnumber,
         fcompanyid,
         fbadacctdate fbilldate,
         fcreatorid,
         fcreatetime,
         flastupdateuserid,
         flastupdatetime,
         fcontrolunitid,
         CASE Isnull(Year(fauditdate),0)
           WHEN 0 THEN 0
           ELSE 1
         END fisaudited,
         CASE Isnull(ffivouchered,0)
           WHEN 1 THEN 1
           ELSE 0
         END ffivouchered
  FROM   t_ar_badacct
  UNION ALL
  SELECT fid,
         'badacctaccurral' fbilltypedes,
         -1 as fbilltype,
         -1 as fveriType,
         fnumber,
         fcompanyid,
         faccountdate fbilldate,
         fcreatorid,
         fcreatetime,
         flastupdateuserid,
         flastupdatetime,
         fcontrolunitid,
         CASE Isnull(Year(fauditdate),0)
           WHEN 0 THEN 0
           ELSE 1
         END fisaudited,
         CASE Isnull(ffivouchered,0)
           WHEN 1 THEN 1
           ELSE 0
         END ffivouchered
  FROM   t_ar_accountbaddebt
  UNION ALL
  SELECT bill.fid as fid,
         'verifyBill' fbilltypedes,
         -1 as fbilltype,
         -1 as fveriType,
         bill.fnumber as fnumber,
         bill.fcompanyid as fcompanyid,
         bill.fbizdate as fbilldate,
         bill.fcreatorid as fcreatorid,
         bill.fcreatetime as fcreatetime,
         bill.flastupdateuserid as flastupdateuserid,
         bill.flastupdatetime as flastupdatetime,
         bill.fcontrolunitid as fcontrolunitid,
         1 fisaudited,
         CASE Isnull(bill.ffivouchered,0)
           WHEN 1 THEN 1
           ELSE 0
         END ffivouchered
  FROM   t_ar_verificationbill bill
  INNER JOIN t_ar_verificationbillentry billEntry
  ON bill.FID = billEntry.FParentID
  where bill.FVerificationType != 101
  UNION ALL
   --含有销售回款
    SELECT bill.fid as fid,
         'verifyBill' fbilltypedes,
         -1 as fbilltype,
         -100 as fveriType,
         bill.fnumber as fnumber,
         bill.fcompanyid as fcompanyid,
         bill.fbizdate as fbilldate,
         bill.fcreatorid as fcreatorid,
         bill.fcreatetime as fcreatetime,
         bill.flastupdateuserid as flastupdateuserid,
         bill.flastupdatetime as flastupdatetime,
         bill.fcontrolunitid as fcontrolunitid,
         1 fisaudited,
         CASE Isnull(bill.ffivouchered,0)
           WHEN 1 THEN 1
           ELSE 0
         END ffivouchered
  FROM   t_ar_verificationbill bill
  INNER JOIN t_ar_verificationbillentry billEntry
  ON bill.FID = billEntry.FParentID
  where bill.FVerificationType = 101 and  (billEntry.fbillsubtype = 100 or billEntry.fbillsubtype = 102)
  UNION ALL
  --预收款单边对等结算不需要做凭证,只有预收款。
      SELECT bill.fid as fid,
         'verifyBill' fbilltypedes,
         -1 as fbilltype,
         -200 as fveriType,
         bill.fnumber as fnumber,
         bill.fcompanyid as fcompanyid,
         bill.fbizdate as fbilldate,
         bill.fcreatorid as fcreatorid,
         bill.fcreatetime as fcreatetime,
         bill.flastupdateuserid as flastupdateuserid,
         bill.flastupdatetime as flastupdatetime,
         bill.fcontrolunitid as fcontrolunitid,
         1 fisaudited,
         1 ffivouchered
  FROM   t_ar_verificationbill bill
  INNER JOIN t_ar_verificationbillentry billEntry
  ON bill.FID = billEntry.FParentID
  where bill.FVerificationType = 101 and bill.FBillType_Main = 6 and bill.FBillType_second = 6 and (billEntry.fbillsubtype = 101 or billEntry.fbillsubtype = 103)
    UNION ALL
    --含有预收款或退预收款的结算记录
      SELECT bill.fid as fid,
         'verifyBill' fbilltypedes,
         -1 as fbilltype,
         -200 as fveriType,
         bill.fnumber as fnumber,
         bill.fcompanyid as fcompanyid,
         bill.fbizdate as fbilldate,
         bill.fcreatorid as fcreatorid,
         bill.fcreatetime as fcreatetime,
         bill.flastupdateuserid as flastupdateuserid,
         bill.flastupdatetime as flastupdatetime,
         bill.fcontrolunitid as fcontrolunitid,
         1 fisaudited,
         CASE Isnull(bill.ffivouchered,0)
           WHEN 1 THEN 1
           ELSE 0
         END ffivouchered
  FROM   t_ar_verificationbill bill
  INNER JOIN t_ar_verificationbillentry billEntry
  ON bill.FID = billEntry.FParentID
  where bill.FVerificationType = 101 and bill.FBillType_Main != bill.FBillType_second and  (billEntry.fbillsubtype = 101 or billEntry.fbillsubtype = 103)
   UNION ALL
  SELECT fid,
         'proxybill' fbilltypedes,
         -1 as fbilltype,
         -1 as fveriType,
         fnumber,
         fcompanyorgunitid fcompanyid,
         fbilldate fbilldate,
         fcreatorid,
         fcreatetime,
         flastupdateuserid,
         flastupdatetime,
         fcontrolunitid,
         CASE fcheckedstatus
           WHEN 1 THEN 0
           ELSE 1
         END fisaudited,
         CASE FIsNeedVoucher when 1 then ISNULL(FFiVouchered,0) else 1 end as ffivouchered
  FROM   t_arp_proxybill bill
  UNION ALL
  SELECT fid,
         'exgRateBill' fbilltypedes,
         -1 as fbilltype,
         -1 as fveriType,
         fnumber,
         fcompanyid,
         FExgRateDate fbilldate,
         fcreatorid,
         fcreatetime,
         flastupdateuserid,
         flastupdatetime,
         fcontrolunitid,
         CASE fbillstatus
           WHEN 3 THEN 1
           ELSE 0
         END fisaudited,
        CASE Isnull(ffivouchered,0)
           WHEN 1 THEN 1
           ELSE 0
         END ffivouchered
      FROM   T_AR_ArExgRateBill ;



If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='v_ap_checkauditedorvouchered')
Drop view v_ap_checkauditedorvouchered;

CREATE VIEW v_ap_checkauditedorvouchered
AS
  SELECT fid,
         'otherbill' fbilltypedes,
         -1 as fbilltype,
         -1 as fveriType,
         fnumber,
         fcompanyid,
         fbilldate,
         fcreatorid,
         fcreatetime,
         flastupdateuserid,
         flastupdatetime,
         fcontrolunitid,
         CASE fbillstatus
           WHEN 3 THEN 1
           ELSE 0
         END fisaudited,
         CASE FIsNeedVoucher*fsourcebilltype when 0 then 1 when 14 then 1 else ISNULL(FFiVouchered,0) end as ffivouchered
  FROM   t_ap_otherbill
  UNION ALL
  SELECT bill.fid as fid,
         'paymentBill' fbilltypedes,
         case rtrim(billType.fnumber)
	 	 when '201' then TO_INTEGER(rtrim(billType.fnumber))
	 	 when '202' then TO_INTEGER(rtrim(billType.fnumber))
	 	 when '203' then TO_INTEGER(rtrim(billType.fnumber))
	 	 when '204' then TO_INTEGER(rtrim(billType.fnumber))
	 	 when '205' then TO_INTEGER(rtrim(billType.fnumber))
	 	 when '206' then TO_INTEGER(rtrim(billType.fnumber))
	 	 when '210' then TO_INTEGER(rtrim(billType.fnumber))
	 	 when '211' then TO_INTEGER(rtrim(billType.fnumber))
	 	 when '221' then TO_INTEGER(rtrim(billType.fnumber))
	 	 when '999' then TO_INTEGER(rtrim(billType.fnumber))
	 	 else 201 end fbilltype,
         1 as fveriType,
         bill.fnumber as fnumber,
         bill.fcompanyid as fcompanyid,
         bill.fbizdate as fbilldate,
         bill.fcreatorid as fcreatorid,
         bill.fcreatetime as fcreatetime,
         bill.flastupdateuserid as flastupdateuserid,
         bill.flastupdatetime as flastupdatetime,
         bill.fcontrolunitid as fcontrolunitid,
         CASE bill.fbillstatus
           WHEN 10 THEN 0
           WHEN 11 THEN 0
           WHEN 12 THEN 0
           ELSE 1
         END fisaudited,
         CASE bill.FIsNeedVoucher when 1 then ISNULL(bill.FFiVouchered,0) else 1 end as ffivouchered
  FROM   t_cas_paymentbill bill inner join T_CAS_PaymentBillType billType on bill.FPayBillTypeID = billType.FID
  WHERE  fsourcetype = 101
  UNION ALL
  SELECT bill.fid as fid,
         'verifyBill' fbilltypedes,
         -1 as fbilltype,
         -1 as fveriType,
         bill.fnumber as fnumber,
         bill.fcompanyid as fcompanyid,
         bill.fbizdate as fbilldate,
         bill.fcreatorid as fcreatorid,
         bill.fcreatetime as fcreatetime,
         bill.flastupdateuserid as flastupdateuserid,
         bill.flastupdatetime as flastupdatetime,
         bill.fcontrolunitid as fcontrolunitid,
         1 fisaudited,
         CASE Isnull(bill.ffivouchered,0)
           WHEN 1 THEN 1
           ELSE 0
         END ffivouchered
  FROM   t_ap_verificationbill bill
  INNER JOIN t_ap_verificationbillentry billEntry
  ON bill.FID = billEntry.FParentID
  where bill.FVerificationType != 201
    UNION ALL
  SELECT bill.fid as fid,
         'verifyBill' fbilltypedes,
         -1 as fbilltype,
         -100 as fveriType,
         bill.fnumber as fnumber,
         bill.fcompanyid as fcompanyid,
         bill.fbizdate as fbilldate,
         bill.fcreatorid as fcreatorid,
         bill.fcreatetime as fcreatetime,
         bill.flastupdateuserid as flastupdateuserid,
         bill.flastupdatetime as flastupdatetime,
         bill.fcontrolunitid as fcontrolunitid,
         1 fisaudited,
         CASE Isnull(bill.ffivouchered,0)
           WHEN 1 THEN 1
           ELSE 0
         END ffivouchered
  FROM   t_ap_verificationbill bill
  INNER JOIN t_ap_verificationbillentry billEntry
  ON bill.FID = billEntry.FParentID
  where bill.FVerificationType = 201 and (billEntry.fbillsubtype = 201 or billEntry.fbillsubtype = 203)
  UNION ALL
    SELECT bill.fid as fid,
         'verifyBill' fbilltypedes,
         -1 as fbilltype,
         -200 as fveriType,
         bill.fnumber as fnumber,
         bill.fcompanyid as fcompanyid,
         bill.fbizdate as fbilldate,
         bill.fcreatorid as fcreatorid,
         bill.fcreatetime as fcreatetime,
         bill.flastupdateuserid as flastupdateuserid,
         bill.flastupdatetime as flastupdatetime,
         bill.fcontrolunitid as fcontrolunitid,
         1 fisaudited,
         1 ffivouchered
  FROM   t_ap_verificationbill bill
  INNER JOIN t_ap_verificationbillentry billEntry
  ON bill.FID = billEntry.FParentID
  where bill.FVerificationType = 201 and bill.FBillType_Main = 4 and bill.FBillType_second = 4 and (billEntry.fbillsubtype = 202 or billEntry.fbillsubtype = 204)
  UNION ALL
    SELECT bill.fid as fid,
         'verifyBill' fbilltypedes,
         -1 as fbilltype,
         -200 as fveriType,
         bill.fnumber as fnumber,
         bill.fcompanyid as fcompanyid,
         bill.fbizdate as fbilldate,
         bill.fcreatorid as fcreatorid,
         bill.fcreatetime as fcreatetime,
         bill.flastupdateuserid as flastupdateuserid,
         bill.flastupdatetime as flastupdatetime,
         bill.fcontrolunitid as fcontrolunitid,
         1 fisaudited,
         CASE Isnull(bill.ffivouchered,0)
           WHEN 1 THEN 1
           ELSE 0
         END ffivouchered
  FROM   t_ap_verificationbill bill
  INNER JOIN t_ap_verificationbillentry billEntry
  ON bill.FID = billEntry.FParentID
  where bill.FVerificationType = 201 and bill.FBillType_Main != bill.FBillType_second and (billEntry.fbillsubtype = 202 or billEntry.fbillsubtype = 204)
  UNION ALL
  SELECT fid,
         'proxybill' fbilltypedes,
         -1 as fbilltype,
         -1 as fveriType,
         fnumber,
         fcompanyorgunitid fcompanyid,
         fbilldate fbilldate,
         fcreatorid,
         fcreatetime,
         flastupdateuserid,
         flastupdatetime,
         fcontrolunitid,
         CASE fcheckedstatus
           WHEN 1 THEN 0
           ELSE 1
         END fisaudited,
         CASE FIsNeedVoucher when 1 then ISNULL(FFiVouchered,0) else 1 end as ffivouchered
  FROM   t_arp_proxybill bill
  UNION ALL
  SELECT fid,
         'exgRateBill' fbilltypedes,
         -1 as fbilltype,
         -1 as fveriType,
         fnumber,
         fcompanyid,
         FExgRateDate fbilldate,
         fcreatorid,
         fcreatetime,
         flastupdateuserid,
         flastupdatetime,
         fcontrolunitid,
         CASE fbillstatus
           WHEN 3 THEN 1
           ELSE 0
         END fisaudited,
         CASE Isnull(ffivouchered,0)
           WHEN 1 THEN 1
           ELSE 0
         END ffivouchered
  FROM   T_AP_ApExgRateBill;


If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='v_arap_receive')
Drop view v_arap_receive;
CREATE VIEW v_arap_receive AS SELECT FID , FNumber , FSourceType, FRecType, fcompanyid, FPayerID  , FPayerTypeID, FCurrencyID ,FAuditorID ,FAmount FEntryAmount, FLocalAmount FAmtLocal, FBizDate FEntryDate  FROM T_CAS_ReceivingBill  WHERE (FBillStatus >=12 AND FBillStatus < 17) and FSourceType = 100;

If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='v_arap_payment')
Drop view v_arap_payment;
CREATE VIEW v_arap_payment AS  SELECT FID, FNumber,  FSourceType, FPayType, fcompanyid , FPayeeID , FPayeeTypeID , FCurrencyID ,FAuditorID, FAmount FENTRYAMOUNT, FLocalAmount FAmtLocal, FBizDate FENTRYDATE  FROM T_CAS_PaymentBill   WHERE (FBillStatus >=12 AND FBillStatus < 17) and FSourceType = 101;

If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='v_ar_computbalance')
Drop view v_ar_computbalance;
CREATE VIEW v_ar_computbalance AS
SELECT fcompanyid FCOMPANYID, FPayerID FCUSTOMERID, FCurrencyID, FEntryDate FBILLDATE, 0 FRECEIVING, FEntryAmount FACTUAL, 0 FReceivingLoc, FAmtLocal FActualLoc, FAuditorID, FPayerTypeID FASSTACTTYPEID FROM V_ARAP_RECEIVE
UNION ALL SELECT fcompanyid FCOMPANYID, FAsstActID FCUSTOMERID, FCurrencyID, FBillDate, FAmount FRECEIVING, 0 FACTUAL, FAmountLocal FReceivingLoc, 0 FActualLoc, FAuditorID, FAsstActTypeID FROM T_AR_OTHERBILL  where FBillStatus=3
UNION ALL SELECT FCompanyID, FAcctCussentID FCUSTOMERID, FCurrencyID, FBadAcctDate FBILLDATE, (-1 * FBadAmounts) FRECEIVING, 0 FACTUAL, 0 FReceivingLoc, FBadAmountsLocal FActualLoc, FAuditorID, FCussentTypeID FASSTACTTYPEID FROM T_AR_BadAcct
UNION ALL SELECT FCompanyID, FAcctCussID_Main   FCUSTOMERID, FCurrencyID_Main   FCurrencyID, FBizDate FBILLDATE, 0 FRECEIVING, FThisVerificateAmt_Main   FACTUAL, 0 FReceivingLoc, FThisVerificateAmtLoc_Main FActualLoc, '1'  FAUDITORID, FAcctCussTypeID_Main FASSTACTTYPEID FROM T_AR_VerificationBill where  FVerificationType=103  or   FVerificationType=109
UNION ALL SELECT FCompanyID, FAcctCussID_Second FCUSTOMERID, FCurrencyID_Second FCURRENCYID, FBizDate FBILLDATE, 0 FRECEIVING, FThisVerificateAmt_Second FACTUAL, 0 FReceivingLoc, FThisVerificateAmtLoc_Second FActualLoc, '1'  FAUDITORID, FAcctCussTypeID_Main FASSTACTTYPEID FROM T_AP_VerificationBill where  FVerificationType=203  or   FVerificationType=209
UNION ALL SELECT FCompanyID, FAcctCussID_Main   FCUSTOMERID, FCurrencyID_Main   FCurrencyID, FBizDate FBILLDATE, FThisVerificateAmt_Main   FRECEIVING, 0 FACTUAL, FThisVerificateAmtLoc_Main FReceivingLoc, 0 FActualLoc, '1'  FAUDITORID, FAcctCussTypeID_Main FASSTACTTYPEID FROM T_AR_VerificationBill where  FVerificationType=104  or   FVerificationType=110
UNION ALL SELECT FCompanyID, FAcctCussID_Second FCUSTOMERID, FCurrencyID_Second FCURRENCYID, FBizDate FBILLDATE, FThisVerificateAmt_Second FRECEIVING, 0 FACTUAL, FThisVerificateAmtLoc_Second FReceivingLoc, 0 FActualLoc, '1'  FAUDITORID, FAcctCussTypeID_Main FASSTACTTYPEID FROM T_AP_VerificationBill WHERE  FVerificationType=204  or   FVerificationType=210
UNION ALL SELECT FCompanyID, FAcctCussID_Main   FCUSTOMERID, FCurrencyID_Main   FCurrencyID, FBizDate FBILLDATE, 0 FRECEIVING, FThisVerificateAmt_Main FACTUAL, 0 FReceivingLoc, FThisVerificateAmtLoc_Main FActualLoc, '1'  FAUDITORID, FAcctCussTypeID_Main FASSTACTTYPEID FROM T_AR_VerificationBill WHERE  FVerificationType=107  or   (FVerificationType=101 AND FIsSameCurrency = 0)
UNION ALL SELECT FCompanyID, FAcctCussID_Second FCUSTOMERID, FCurrencyID_Second FCURRENCYID, FBizDate FBILLDATE, FThisVerificateAmt_Second FRECEIVING, 0 FACTUAL, FThisVerificateAmtLoc_Second FReceivingLoc, 0 FActualLoc, '1'  FAUDITORID, FAcctCussTypeID_Main FASSTACTTYPEID FROM T_AR_VerificationBill WHERE  FVerificationType=107  or   (FVerificationType=101 AND FIsSameCurrency = 0)
UNION ALL SELECT FCompanyID, FAcctCussID_Main   FCUSTOMERID, FCurrencyID_Main   FCurrencyID, FBizDate FBILLDATE, FThisVerificateAmt_Main FRECEIVING,   0 FACTUAL, FThisVerificateAmtLoc_Main FReceivingLoc, 0 FActualLoc, '1'  FAUDITORID, FAcctCussTypeID_Main FASSTACTTYPEID FROM T_AR_VerificationBill WHERE  FVerificationType=113  or   FVerificationType=114
UNION ALL SELECT FCompanyID, FAcctCussID_Second FCUSTOMERID, FCurrencyID_Second FCURRENCYID, FBizDate FBILLDATE, FThisVerificateAmt_Second FRECEIVING, 0 FACTUAL, FThisVerificateAmtLoc_Second FReceivingLoc, 0 FActualLoc, '1'  FAUDITORID, FAcctCussTypeID_Main FASSTACTTYPEID FROM T_AP_VerificationBill WHERE  FVerificationType=211  or   FVerificationType=212
UNION ALL SELECT FCompanyID, FAcctCussID_Main   FCUSTOMERID, FCurrencyID_Main   FCurrencyID, FBizDate FBILLDATE, FThisVerificateAmt_Main FRECEIVING, FThisVerificateAmt_Main FACTUAL, FThisVerificateAmtLoc_Main FReceivingLoc, FThisVerificateAmtLoc_Main FActualLoc, '1'  FAUDITORID, FAcctCussTypeID_Main FASSTACTTYPEID FROM T_AR_VerificationBill WHERE (FVerificationType=112)  or (FVerificationType=111  AND FIsSameCurrency = 0)
UNION ALL SELECT FCompanyID, FAcctCussID_Main   FCUSTOMERID, FCurrencyID_Main   FCurrencyID, FBizDate FBILLDATE, FThisVerificateAmt_Main FRECEIVING, 0 FACTUAL, FThisVerificateAmtLoc_Main FReceivingLoc, 0 FActualLoc, '1'  FAUDITORID, FAcctCussTypeID_Main FASSTACTTYPEID                   FROM T_AR_VerificationBill WHERE (FVerificationType=111  AND FIsSameCurrency = 1)
UNION ALL SELECT FCompanyID, FAcctCussID_Second FCUSTOMERID, FCurrencyID_Second FCURRENCYID, FBizDate FBILLDATE, FThisVerificateAmt_Second FRECEIVING, 0 FACTUAL, FThisVerificateAmtLoc_Second FReceivingLoc, 0 FActualLoc, '1'  FAUDITORID, FAcctCussTypeID_Main FASSTACTTYPEID                   FROM T_AR_VerificationBill WHERE (FVerificationType=112)  or (FVerificationType=111 AND FIsSameCurrency = 0);

If  exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='v_ap_computbalance')
Drop view v_ap_computbalance;
CREATE VIEW v_ap_computbalance AS
SELECT fcompanyid FCOMPANYID, FPayeeID FSUPPLIERID, FCurrencyID, FEntryDate FBILLDATE, 0 FPAYMENT, FEntryAmount FACTUAL, 0 FPaymentLoc, FAmtLocal FActualLoc, FAuditorID, FPayeeTypeID FASSTACTTYPEID FROM V_ARAP_PAYMENT
UNION ALL SELECT fcompanyid FCOMPANYID, FAsstActID FSUPPLIERID, FCurrencyID, FBillDate, FAmount FPAYMENT, 0 FACTUAL, FAmountLocal FPaymentLoc, 0 FActualLoc, FAuditorID, FAsstActTypeID FROM T_AP_OTHERBILL  where FBillStatus=3
UNION ALL SELECT FCompanyID, FAcctCussID_Main   FSUPPLIERID, FCurrencyID_Main   FCurrencyID, FBizDate FBILLDATE, 0 FPAYMENT, FThisVerificateAmt_Main   FACTUAL, 0 FPaymentLoc, FThisVerificateAmtLoc_Main FActualLoc, '1'  FAUDITORID, FAcctCussTypeID_Main FASSTACTTYPEID FROM T_AP_VerificationBill where FVerificationType=203  or  FVerificationType=209
UNION ALL SELECT FCompanyID, FAcctCussID_Second FSUPPLIERID, FCurrencyID_Second FCURRENCYID, FBizDate FBILLDATE, 0 FPAYMENT, FThisVerificateAmt_Second FACTUAL, 0 FPaymentLoc, FThisVerificateAmtLoc_Second FActualLoc, '1'  FAUDITORID, FAcctCussTypeID_Main FASSTACTTYPEID FROM T_AR_VerificationBill WHERE FVerificationType=103  or   FVerificationType=109
UNION ALL SELECT FCompanyID, FAcctCussID_Main   FSUPPLIERID, FCurrencyID_Main   FCurrencyID, FBizDate FBILLDATE, FThisVerificateAmt_Main   FPAYMENT, 0 FACTUAL, FThisVerificateAmtLoc_Main FPaymentLoc, 0 FActualLoc, '1'  FAUDITORID, FAcctCussTypeID_Main FASSTACTTYPEID FROM T_AP_VerificationBill where FVerificationType=204  or   FVerificationType=210
UNION ALL SELECT FCompanyID, FAcctCussID_Second FSUPPLIERID, FCurrencyID_Second FCURRENCYID, FBizDate FBILLDATE, FThisVerificateAmt_Second FPAYMENT, 0 FACTUAL, FThisVerificateAmtLoc_Second FPaymentLoc, 0 FActualLoc, '1'  FAUDITORID, FAcctCussTypeID_Main FASSTACTTYPEID FROM T_AR_VerificationBill WHERE FVerificationType=104  or   FVerificationType=110
UNION ALL SELECT FCompanyID, FAcctCussID_Main   FSUPPLIERID, FCurrencyID_Main   FCurrencyID, FBizDate FBILLDATE, 0 FPAYMENT, FThisVerificateAmt_Main FACTUAL,   0 FPaymentLoc, FThisVerificateAmtLoc_Main FActualLoc, '1'  FAUDITORID, FAcctCussTypeID_Main FASSTACTTYPEID FROM T_AP_VerificationBill WHERE (FVerificationType=207) or (FVerificationType=201 AND FIsSameCurrency = 0)
UNION ALL SELECT FCompanyID, FAcctCussID_Second FSUPPLIERID, FCurrencyID_Second FCURRENCYID, FBizDate FBILLDATE, FThisVerificateAmt_Second FPAYMENT, 0 FACTUAL, FThisVerificateAmtLoc_Second FPaymentLoc, FThisVerificateAmtLoc_Second FActualLoc, '1'  FAUDITORID, FAcctCussTypeID_Main FASSTACTTYPEID FROM T_AP_VerificationBill WHERE (FVerificationType=207) or (FVerificationType=201  AND FIsSameCurrency = 0)
UNION ALL SELECT FCompanyID, FAcctCussID_Main   FSUPPLIERID, FCurrencyID_Main   FCurrencyID, FBizDate FBILLDATE, FThisVerificateAmt_Main   FPAYMENT, 0 FACTUAL, FThisVerificateAmtLoc_Main FPaymentLoc, 0 FActualLoc, '1'  FAUDITORID, FAcctCussTypeID_Main FASSTACTTYPEID FROM T_AP_VerificationBill where FVerificationType=211  or   FVerificationType=212
UNION ALL SELECT FCompanyID, FAcctCussID_Second FSUPPLIERID, FCurrencyID_Second FCURRENCYID, FBizDate FBILLDATE, FThisVerificateAmt_Second FPAYMENT, 0 FACTUAL, FThisVerificateAmtLoc_Second FPaymentLoc, 0 FActualLoc, '1'  FAUDITORID, FAcctCussTypeID_Main FASSTACTTYPEID FROM T_AR_VerificationBill where FVerificationType=113  or   FVerificationType=114;
