﻿IF EXISTS(SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME='T_FS_InnerAccount')
drop table T_FS_InnerAccount;
IF EXISTS(SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME='T_FS_OpeningDeposit')
drop table T_FS_OpeningDeposit;
IF EXISTS(SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME='T_FS_SettBizType')
drop table T_FS_SettBizType;
IF EXISTS(SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME='T_FS_SettlementBill')
drop table T_FS_SettlementBill;
IF EXISTS(SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME='T_FS_SubsidiaryBalanceEntry')
drop table T_FS_SubsidiaryBalanceEntry;
IF EXISTS(SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME='T_FS_SubsidiaryLedger')
drop table T_FS_SubsidiaryLedger;
IF EXISTS(SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME='T_FS_SummaryLedger')
drop table T_FS_SummaryLedger;
IF EXISTS(SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME='T_FS_TransDownBill')
drop table T_FS_TransDownBill;
IF EXISTS(SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME='T_FS_TransDownBillEntry')
drop table T_FS_TransDownBillEntry;
IF EXISTS(SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME='T_FS_TransUpBill')
drop table T_FS_TransUpBill;
IF EXISTS(SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME='T_FS_TransUpBillEntry')
drop table T_FS_TransUpBillEntry;

Create Table T_FS_InnerAccount ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FNumber NVARCHAR(80),FBizDate DateTime,FHandlerID VARCHAR(44),FDescription_L1 NVARCHAR(80),FDescription_L2 NVARCHAR(80),FDescription_L3 NVARCHAR(80),FHasEffected INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCompanyID VARCHAR(44),FClosed INT,FShutterID VARCHAR(44),FClosingDate DateTime,FClhClassificationID VARCHAR(44),FOpenDepositDate DateTime,FIsUsed INT,FSetUsedDate DateTime,FClearingHouseID VARCHAR(44),FTypeId VARCHAR(44),FCreditLevel INT,FLinkIntObject INT DEFAULT 0,FName_L1 NVARCHAR(255),FName_L2 NVARCHAR(255),FName_L3 NVARCHAR(255),FSimpleName NVARCHAR(80),FCtrlParamId VARCHAR(44),FApplyUnitID VARCHAR(44),FAcctNumber NVARCHAR(80),FAcctViewId VARCHAR(44),CONSTRAINT PK_InnerAccount PRIMARY KEY (FID));

Create Table T_FS_OpeningDeposit ( FID VARCHAR(44) NOT NULL ,FAccountID VARCHAR(44) NOT NULL ,FCurrencyID VARCHAR(44),FCapitalType INT,FOpeningBalance NUMERIC(19,4),FComment NVARCHAR(80),CONSTRAINT PK_FS_OpeningD PRIMARY KEY (FID));

Create Table T_FS_SettBizType ( FID VARCHAR(44) NOT NULL ,FName_L1 NVARCHAR(255),FName_L2 NVARCHAR(255),FName_L3 NVARCHAR(255),FNumber NVARCHAR(80),FType INT,FDescription_L1 NVARCHAR(255),FDescription_L2 NVARCHAR(255),FDescription_L3 NVARCHAR(255),FSimpleName NVARCHAR(80),FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4',CONSTRAINT PK_FS_SettBizTypeI PRIMARY KEY (FID));

Create Table T_FS_SettlementBill ( FID VARCHAR(44) NOT NULL ,FNumber NVARCHAR(80) NOT NULL ,FBizDate DateTime,FType INT NOT NULL ,FPayeeBankAcctNum NVARCHAR(80),FPayerBankAcctNum NVARCHAR(80),FCreatorID VARCHAR(44) NOT NULL ,FCreateTime DateTime NOT NULL ,FLastUpdateUserID VARCHAR(44) NOT NULL ,FLastUpdateTime DateTime NOT NULL ,FControlUnitID VARCHAR(44) NOT NULL ,FHandlerID VARCHAR(44),FDescription NVARCHAR(80),FHasEffected INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCompanyID VARCHAR(44) NOT NULL ,FPayeePlanItemID VARCHAR(44),FPayerPlanItemID VARCHAR(44),FPayeeCurrencyID VARCHAR(44),FPayerCurrencyID VARCHAR(44),FPayeeAmount NUMERIC(19,4) DEFAULT 0 NOT NULL ,FExchange NUMERIC(28,16) DEFAULT 0 NOT NULL ,FPayerAmount NUMERIC(19,4) DEFAULT 0 NOT NULL ,FIsAccepted INT DEFAULT 0 NOT NULL ,FAcceptedDate DateTime,FAcceptorID VARCHAR(44),FPayeeBankAcctID VARCHAR(44),FPayerBankAcctID VARCHAR(44),FPayeeInnerAcctID VARCHAR(44),FPayerInnerAcctID VARCHAR(44),FCashierID VARCHAR(44),FSettleDate DateTime,FIsTransfer INT DEFAULT 0,FFIVouchered INT DEFAULT 0 NOT NULL ,FApplyUnit VARCHAR(44) NOT NULL ,FPayeeFullName NVARCHAR(80),FPayerFullName NVARCHAR(80),FIsGenPaymentBill INT DEFAULT 0 NOT NULL ,FIsGenReceivingBill INT DEFAULT 0 NOT NULL ,FPayeeInnerSettleNumber NVARCHAR(80),FPayeeOuterSettleNumber NVARCHAR(80),FPayeeInnerSettleTypeID VARCHAR(44),FPayeeOuterSettleTypeID VARCHAR(44),FPayerInnerSettleNumber NVARCHAR(80),FPayerOuterSettleNumber NVARCHAR(80),FPayerInnerSettleTypeID VARCHAR(44),FPayerOuterSettleTypeID VARCHAR(44),FIsRelateNT INT DEFAULT 0 NOT NULL ,FAppendix INT DEFAULT 0 NOT NULL ,FChequeID VARCHAR(44),FBizTypeID VARCHAR(44),FPayeeBank NVARCHAR(80),FPayerBank NVARCHAR(80),FCurrencyID VARCHAR(44),FAmount NUMERIC(19,4) DEFAULT 0,FLocalAmt NUMERIC(19,4) DEFAULT 0,FSettleTypeID VARCHAR(44),FOuterSettleNumber NVARCHAR(80),FInnerSettleNumber NVARCHAR(80),FIsUrgent INT DEFAULT 0 NOT NULL ,FPayeeAreaID VARCHAR(44),FPayeeBankAcctName NVARCHAR(80),CONSTRAINT PK_FS_SBill PRIMARY KEY (FID));

Create Table T_FS_SubsidiaryLedger ( FID VARCHAR(44) NOT NULL ,FInnerAccountID VARCHAR(44),FCurrencyID VARCHAR(44) NOT NULL ,FDate DateTime NOT NULL ,FBizType INT,FBillNumber NVARCHAR(80),FPayeeBankAcct NVARCHAR(80),FPayerBankAcct NVARCHAR(80),FCpInnerAccountID VARCHAR(44),FCPCurrencyID VARCHAR(44),FDescription NVARCHAR(80),FDebitAmount NUMERIC(19,4) NOT NULL ,FCreditAmount NUMERIC(19,4) NOT NULL ,FExchangeRate NUMERIC(19,4) NOT NULL ,FLocalAmount NUMERIC(19,4) NOT NULL ,FBookkeeperID VARCHAR(44),FCompanyID VARCHAR(44) NOT NULL ,FBillId VARCHAR(44),FPayeeBankAcctID VARCHAR(44),FPayerBankAcctID VARCHAR(44),FIsDownLoad INT DEFAULT 0 NOT NULL ,FSettleTypeID VARCHAR(44),FSettleNumber NVARCHAR(80),FApplyUnitID VARCHAR(44) NOT NULL ,FFPItemID VARCHAR(44),CONSTRAINT PK_FS_SSL PRIMARY KEY (FID));

Create Table T_FS_SummaryLedger ( FID VARCHAR(44) NOT NULL ,FCurrencyID VARCHAR(44) NOT NULL ,FInnerAccountID VARCHAR(44),FBizDate DateTime,FDebitTotal NUMERIC(19,4) NOT NULL ,FLocalDebitTotal NUMERIC(19,4) NOT NULL ,FCreditTotal NUMERIC(19,4) NOT NULL ,FLocalCreditTotal NUMERIC(19,4) NOT NULL ,FEndBalanceDC INT NOT NULL ,FEndBalance NUMERIC(19,4) NOT NULL ,FLocalEndBalance NUMERIC(19,4) NOT NULL ,FCompanyID VARCHAR(44) NOT NULL ,FBeginBalance NUMERIC(19,4) NOT NULL ,FBeginBalanceDC INT NOT NULL ,FLocalBeginBalance NUMERIC(19,4) NOT NULL ,FDebitCounts INT NOT NULL ,FCreditCounts INT NOT NULL ,FBankAcctID VARCHAR(44),FApplyUnitID VARCHAR(44) NOT NULL ,CONSTRAINT PK_FS_SMM PRIMARY KEY (FID));

--增加"清算户"表
IF NOT EXISTS (SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME ='T_FS_ReckoningAccount')
Create Table T_FS_ReckoningAccount ( FID VARCHAR(44) NOT NULL, FName_L1 NVARCHAR(255),FName_L2 NVARCHAR(255),FName_L3 NVARCHAR(255),FNumber NVARCHAR(80),FDescription_L1 NVARCHAR(255),FDescription_L2 NVARCHAR(255),FDescription_L3 NVARCHAR(255),FSimpleName NVARCHAR(80),FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4',FCompanyID VARCHAR(44),FAcctNumber NVARCHAR(50),FClearingHouseID VARCHAR(44),FAcctViewID VARCHAR(44),CONSTRAINT PK_FS_RcnngAID PRIMARY KEY (FID));

--增加"往账"表
IF NOT EXISTS (SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME ='T_FS_SendAccount')
Create Table T_FS_SendAccount ( FID VARCHAR(44) NOT NULL ,FNumber NVARCHAR(80),FBizDate DateTime,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(80),FHasEffected INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCompanyID VARCHAR(44),FControlUnitID VARCHAR(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4',FFiVouchered INT,FSubmitDate DateTime,FIsBackBill INT DEFAULT 0,FSource VARCHAR(20),FType VARCHAR(20),FDoForRecPay VARCHAR(20),FReckoningAcctID VARCHAR(44),FCurrencyID VARCHAR(44),FAmount NUMERIC(28,10) DEFAULT 0,FSettleAcceptCHID VARCHAR(44),FSubmitCHID VARCHAR(44),FReceiveCHID VARCHAR(44),FSettleConfirmCHID VARCHAR(44),FCheckerID VARCHAR(44),FResult NVARCHAR(100),FStatus VARCHAR(20),FUpBillId VARCHAR(44),FDownBillId VARCHAR(44),FSrcSettlementBillId VARCHAR(44),FLastHandlerId VARCHAR(44),CONSTRAINT PK_FS_SendAID PRIMARY KEY (FID));

--增加"来账"表
IF NOT EXISTS (SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME ='T_FS_ReceiveAccount')
Create Table T_FS_ReceiveAccount ( FID VARCHAR(44) NOT NULL ,FNumber NVARCHAR(80),FBizDate DateTime,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(80),FHasEffected INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCompanyID VARCHAR(44),FControlUnitID VARCHAR(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4',FFivouchered INT DEFAULT 0,FSource VARCHAR(20),FSubmitDate DateTime,FCheckerID VARCHAR(44),FBackerID VARCHAR(44),FCashierID VARCHAR(44),FAccountantID VARCHAR(44),FSettleAcceptCHID VARCHAR(44),FSettleConfirmCHID VARCHAR(44),FSubmitCHID VARCHAR(44),FUpReckoningAcctID VARCHAR(44),FDownReckoningAcctID VARCHAR(44),FCurrencyID VARCHAR(44),FAmount NUMERIC(28,10) DEFAULT 0,FIsBackBill INT DEFAULT 0 NOT NULL,FType VARCHAR(20),FDoForRecPay VARCHAR(20),FAccountBankID VARCHAR(44),FSettlementTypeID VARCHAR(44),FSettleNumber NVARCHAR(50),FResult NVARCHAR(100),FStatus VARCHAR(20),FUpBillId VARCHAR(44),FDownBillId VARCHAR(44),FSrcSettlementBillId VARCHAR(44),FLastHandlerId VARCHAR(44),FVoucherEnum INT DEFAULT 0 NOT NULL ,CONSTRAINT PK_FS_ReceiveAID PRIMARY KEY (FID));

--结算单增加以下字段
--提交中心
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FSettleAcceptCHId' AND KSQL_COL_TABNAME='T_FS_SettlementBill') 
ALTER TABLE T_FS_SettlementBill ADD FSettleAcceptCHId VARCHAR(44);
--确认中心
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FSettleConfirmCHId' AND KSQL_COL_TABNAME='T_FS_SettlementBill') 
ALTER TABLE T_FS_SettlementBill ADD FSettleConfirmCHId VARCHAR(44);
--清算户
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FReckoningAcctId' AND KSQL_COL_TABNAME='T_FS_SettlementBill') 
ALTER TABLE T_FS_SettlementBill ADD FReckoningAcctId VARCHAR(44);
--来源
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FSource' AND KSQL_COL_TABNAME='T_FS_SettlementBill') 
ALTER TABLE T_FS_SettlementBill ADD FSource VARCHAR(20);
--源结算单
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FSrcSettlementBillId' AND KSQL_COL_TABNAME='T_FS_SettlementBill') 
ALTER TABLE T_FS_SettlementBill ADD FSrcSettlementBillId VARCHAR(44);
--是否可被收款单关联生成
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FIsDlByRec' AND KSQL_COL_TABNAME='T_FS_SettlementBill') 
ALTER TABLE T_FS_SettlementBill ADD FIsDlByRec INT DEFAULT 0;
--是否可被付款单关联生成
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FIsDlByPay' AND KSQL_COL_TABNAME='T_FS_SettlementBill') 
ALTER TABLE T_FS_SettlementBill ADD FIsDlByPay INT DEFAULT 0;



--begin fengrenfei
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FAmountCap' 
AND KSQL_COL_TABNAME='T_FS_SettlementBill') 
ALTER TABLE T_FS_SettlementBill ADD FAmountCap NVARCHAR(200);
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FEnCreatorID' 
AND KSQL_COL_TABNAME='T_FS_SettlementBill') 
ALTER TABLE T_FS_SettlementBill ADD FEnCreatorID VARCHAR(44);
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FEnAuditorID' 
AND KSQL_COL_TABNAME='T_FS_SettlementBill') 
ALTER TABLE T_FS_SettlementBill ADD FEnAuditorID VARCHAR(44);
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FSourceBillNumber' 
AND KSQL_COL_TABNAME='T_FS_SettlementBill') 
ALTER TABLE T_FS_SettlementBill ADD FSourceBillNumber NVARCHAR(80);
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FAppendixSRC' 
AND KSQL_COL_TABNAME='T_FS_SettlementBill') 
ALTER TABLE T_FS_SettlementBill ADD FAppendixSRC INT;
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FAppendixCOPY' 
AND KSQL_COL_TABNAME='T_FS_SettlementBill') 
ALTER TABLE T_FS_SettlementBill ADD FAppendixCOPY INT;
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FFeeTypeID' 
AND KSQL_COL_TABNAME='T_FS_SettlementBill') 
ALTER TABLE T_FS_SettlementBill ADD FFeeTypeID VARCHAR(44);
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FProjectID' 
AND KSQL_COL_TABNAME='T_FS_SettlementBill') 
ALTER TABLE T_FS_SettlementBill ADD FProjectID VARCHAR(44);
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FPayeeAcctID' 
AND KSQL_COL_TABNAME='T_FS_SettlementBill') 
ALTER TABLE T_FS_SettlementBill ADD FPayeeAcctID VARCHAR(44);
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FPayerAcctID' 
AND KSQL_COL_TABNAME='T_FS_SettlementBill') 
ALTER TABLE T_FS_SettlementBill ADD FPayerAcctID VARCHAR(44);


IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FInnerSetteTypeID' AND KSQL_COL_TABNAME='T_FS_SettlementBill') 
ALTER TABLE T_FS_SettlementBill ADD FInnerSetteTypeID varchar(44);

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FSettBatchID' 
AND KSQL_COL_TABNAME='T_FS_SettlementBill') 
ALTER TABLE T_FS_SettlementBill ADD FSettBatchID VARCHAR(44);


--end fengrenfei


Create Table T_FS_TransDownBill ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FNumber NVARCHAR(80),FBizDate DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(80),FHasEffected INT DEFAULT 0,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCompanyID VARCHAR(44),FLaunchMode INT DEFAULT 0,FAccessories INT DEFAULT 0,FMotherAcctBankID VARCHAR(44),FCurrencyID VARCHAR(44),FUsage NVARCHAR(80),FExchangeRate NUMERIC(28,10) DEFAULT 0,FSettleTypeID VARCHAR(44),FSettleNumber NVARCHAR(80),FTotalCounts INT DEFAULT 0,FTotalAmt NUMERIC(28,10) DEFAULT 0,FTotalLocalAmt NUMERIC(28,10) DEFAULT 0,FConfirmedCounts INT DEFAULT 0,FConfirmedAmt NUMERIC(28,10) DEFAULT 0,FConfirmedLocalAmt NUMERIC(28,10) DEFAULT 0,FIsUrgent INT DEFAULT 0,FFivouchered INT DEFAULT 0,FCashierID VARCHAR(44),FAccountantID VARCHAR(44),FState INT DEFAULT 1,FIsSendReceipt INT DEFAULT 0,CONSTRAINT PK_TransDownBill PRIMARY KEY (FID));

Create Table T_FS_TransDownBillEntry ( FID VARCHAR(44) NOT NULL ,FSeq INT DEFAULT 0,FUnitAcctBankID VARCHAR(44),FSubAcctId VARCHAR(44),FUnitId VARCHAR(44),FAmount NUMERIC(28,10) DEFAULT 0,FLocalAmt NUMERIC(28,10) DEFAULT 0,FIsSuccessed INT DEFAULT 0,FDescription NVARCHAR(80),FIsSendReceipt INT DEFAULT 0,FReceiptBillId VARCHAR(44),FParentID VARCHAR(44),CONSTRAINT PK_TransDownBillEn PRIMARY KEY (FID));

Create Table T_FS_TransUpBill ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FNumber NVARCHAR(80),FBizDate DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(80),FHasEffected INT DEFAULT 0,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCompanyID VARCHAR(44),FLaunchMode INT DEFAULT 0,FAccessories INT DEFAULT 0,FMotherAcctBankID VARCHAR(44),FCurrencyID VARCHAR(44),FUsage NVARCHAR(80),FExchangeRate NUMERIC(28,10) DEFAULT 0,FSettleTypeID VARCHAR(44),FSettleNumber NVARCHAR(80),FTotalCounts INT DEFAULT 0,FTotalAmt NUMERIC(28,10) DEFAULT 0,FTotalLocalAmt NUMERIC(28,10) DEFAULT 0,FConfirmedCounts INT DEFAULT 0,FConfirmedAmt NUMERIC(28,10) DEFAULT 0,FConfirmedLocalAmt NUMERIC(28,10) DEFAULT 0,FIsUrgent INT DEFAULT 0,FFivouchered INT DEFAULT 0,FCashierID VARCHAR(44),FAccountantID VARCHAR(44),FState INT DEFAULT 1,FIsSendReceipt INT DEFAULT 0,CONSTRAINT PK_TransUpBill PRIMARY KEY (FID));

Create Table T_FS_TransUpBillEntry ( FID VARCHAR(44) NOT NULL ,FSeq INT DEFAULT 0,FUnitAcctBankID VARCHAR(44),FSubAcctId VARCHAR(44),FUnitId VARCHAR(44),FAmount NUMERIC(28,10) DEFAULT 0,FLocalAmt NUMERIC(28,10) DEFAULT 0,FIsSuccessed INT DEFAULT 0,FDescription NVARCHAR(80),FIsSendReceipt INT DEFAULT 0,FReceiptBillId VARCHAR(44),FParentID VARCHAR(44),CONSTRAINT PK_TransUpBillEntr PRIMARY KEY (FID));

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME = 'FRecAccountNum' AND KSQL_COL_TABNAME = 'T_FS_InnerAccount')
alter table T_FS_InnerAccount add FRecAccountNum NVARCHAR(80);

--5.4 begin by junli_qu

--结算单增加付款方项目和付款方费用类别
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FPayerFeeTypeID' 
	and KSQL_COL_TABNAME='T_FS_SettlementBill')
ALTER TABLE T_FS_SettlementBill ADD FPayerFeeTypeID VARCHAR(44);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FPayerProjectID' 
	and KSQL_COL_TABNAME='T_FS_SettlementBill')
ALTER TABLE T_FS_SettlementBill ADD FPayerProjectID VARCHAR(44);
--结算单增加防篡改列
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FEditFlag' 
	and KSQL_COL_TABNAME='T_FS_SettlementBill')
ALTER TABLE T_FS_SettlementBill ADD FEditFlag VARCHAR(80);
--增加内部冻结存款表
IF NOT EXISTS (SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME ='T_FS_InnerFrozenDeposit')
Create Table T_FS_InnerFrozenDeposit ( FNumber NVARCHAR(80),FBizDate DateTime,FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(250),FHasEffected INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCompanyID VARCHAR(44),FControlUnitID VARCHAR(44),FFivouchered INT,FFrozenNumber INT DEFAULT 0,FCurCompanyID VARCHAR(44),FType VARCHAR(100),FInnerAccountID VARCHAR(44),FCurrencyID VARCHAR(44),FFrozenAmt NUMERIC(19,4),FCurBalance NUMERIC(19,4),FUseBalance NUMERIC(19,4),FTotalFrozenAmt NUMERIC(19,4),CONSTRAINT PK_FS_InnFrozFDID PRIMARY KEY (FID));


--升级账户类型
 
 
--结算单增加打印次数
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FPrintCount' 
	and KSQL_COL_TABNAME='T_FS_SettlementBill')
ALTER TABLE T_FS_SettlementBill ADD FPrintCount int  default 0;
--结算单增加是否异地
If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FIsDifferPlace' 
    and KSQL_COL_TABNAME = 'T_FS_SettlementBill' )
ALTER TABLE T_FS_SettlementBill ADD FIsDifferPlace int default 0;
--下拨单增加是否提交银企互联
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FisCommittoBe' AND KSQL_COL_TABNAME='T_FS_TransUpBill') 
ALTER TABLE T_FS_TransUpBill ADD FisCommittoBe INT DEFAULT 0;
--上划单增加是否提交银企互联
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FisCommittoBe' AND KSQL_COL_TABNAME='T_FS_TransDownBill') 
ALTER TABLE T_FS_TransDownBill ADD FisCommittoBe INT DEFAULT 0;
--下拨单分录增加单位账户开户地区
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FPayeeAreaID' 
	and KSQL_COL_TABNAME='T_FS_TransDownBillEntry')
ALTER TABLE T_FS_TransDownBillEntry ADD FPayeeAreaID VARCHAR(44);
--上划单增加账户开户地区
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FPayeeAreaID' 
	and KSQL_COL_TABNAME='T_FS_TransUpBill')
ALTER TABLE T_FS_TransUpBill ADD FPayeeAreaID VARCHAR(44);
--5.4 end
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME = 'FCreateTime' AND KSQL_COL_TABNAME = 'T_FS_SubsidiaryLedger')
alter table T_FS_SubsidiaryLedger add FCreateTime DateTime;

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME = 'FSeq' AND KSQL_COL_TABNAME = 'T_FS_SubsidiaryLedger')
alter table T_FS_SubsidiaryLedger add FSeq INT;


IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME = 'FCheckerID' AND KSQL_COL_TABNAME = 'T_FS_SettlementBill')
alter table T_FS_SettlementBill add FCheckerID  VARCHAR(44);

--此列实际没用，但是升级库中有数据又需要支持重复升级，为了没有差异，所以加上
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FType' 
	and KSQL_COL_TABNAME='T_FS_SummaryLedger')
ALTER TABLE T_FS_SummaryLedger ADD FType  int default 1 not null;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FType' 
	and KSQL_COL_TABNAME='T_FS_SubsidiaryLedger')
ALTER TABLE T_FS_SubsidiaryLedger ADD FType int default 1 not null;

--结算单增加是否提交银企互联
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FisCommittoBe' AND KSQL_COL_TABNAME='T_FS_SettlementBill') 
ALTER TABLE T_FS_SettlementBill ADD FisCommittoBe INT DEFAULT 0;
--结算单增加审核日期和审核人
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FApproverID' 
	and KSQL_COL_TABNAME='T_FS_SettlementBill')
ALTER TABLE T_FS_SettlementBill ADD FApproverID VARCHAR(44);
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FApproveDate' 
	and KSQL_COL_TABNAME='T_FS_SettlementBill')
ALTER TABLE T_FS_SettlementBill ADD FApproveDate DateTime;
--结算单增加企业审核日期和企业审核人
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FCompanyApproverID' 
	and KSQL_COL_TABNAME='T_FS_SettlementBill')
ALTER TABLE T_FS_SettlementBill ADD FCompanyApproverID VARCHAR(44);
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FCompanyApproveDate' 
	and KSQL_COL_TABNAME='T_FS_SettlementBill')
ALTER TABLE T_FS_SettlementBill ADD FCompanyApproveDate DateTime;
--结算单增加审批日期
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FAuditDate' 
	and KSQL_COL_TABNAME='T_FS_SettlementBill')
ALTER TABLE T_FS_SettlementBill ADD FAuditDate DateTime;

--fs
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FUsage' 
	and KSQL_COL_TABNAME='T_FS_SettlementBill')
ALTER TABLE T_FS_SettlementBill ADD FUsage NVARCHAR(100);

--内部账户增加是否清算户字段
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FIsReckoning' AND KSQL_COL_TABNAME='T_FS_InnerAccount') 
ALTER TABLE T_FS_InnerAccount ADD FIsReckoning INT DEFAULT 0;
--结算单新增字段
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FFinPayeeInAcctID' 
	and KSQL_COL_TABNAME='T_FS_SettlementBill')
ALTER TABLE T_FS_SettlementBill ADD FFinPayeeInAcctID VARCHAR(44);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FFinPayerInAcctID' 
	and KSQL_COL_TABNAME='T_FS_SettlementBill')
ALTER TABLE T_FS_SettlementBill ADD FFinPayerInAcctID VARCHAR(44);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FFinPayeeBankActID' 
	and KSQL_COL_TABNAME='T_FS_SettlementBill')
ALTER TABLE T_FS_SettlementBill ADD FFinPayeeBankActID VARCHAR(44);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FFinPayerBankActID' 
	and KSQL_COL_TABNAME='T_FS_SettlementBill')
ALTER TABLE T_FS_SettlementBill ADD FFinPayerBankActID VARCHAR(44);

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FIsReckOrBitBack' 
AND KSQL_COL_TABNAME='T_FS_SettlementBill') 
ALTER TABLE T_FS_SettlementBill ADD FIsReckOrBitBack INT DEFAULT 0;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FBitBackAdvice' 
	and KSQL_COL_TABNAME='T_FS_SettlementBill')
ALTER TABLE T_FS_SettlementBill ADD FBitBackAdvice NVARCHAR(250);

IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FUpReckoningType' 
AND KSQL_COL_TABNAME='T_FS_SettlementBill') 
ALTER TABLE T_FS_SettlementBill ADD FUpReckoningType INT;


--从5.3回迁来的字段
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FMutilType' 
AND KSQL_COL_TABNAME='T_FS_SettlementBill') 
ALTER TABLE T_FS_SettlementBill ADD FMutilType INT;
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FSimpleCode' 
	and KSQL_COL_TABNAME='T_FS_InnerAccount')
ALTER TABLE T_FS_InnerAccount ADD FSimpleCode NVARCHAR(100);
--增加是否托收
If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FIsCollect'
 and KSQL_COL_TABNAME = 'T_FS_InnerAccount' )
ALTER TABLE T_FS_InnerAccount ADD FIsCollect int default 0;
--结算单增加收款方省，市县
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FRecProvinceStr' 
	and KSQL_COL_TABNAME='T_FS_SettlementBill')
ALTER TABLE T_FS_SettlementBill ADD FRecProvinceStr NVARCHAR(100);
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FRecCityStr' 
	and KSQL_COL_TABNAME='T_FS_SettlementBill')
ALTER TABLE T_FS_SettlementBill ADD FRecCityStr NVARCHAR(100);
--升级结算单数据
update T_BD_SettlementType set FPayThroughBE=0 where FPayThroughBE is null;

--从5.3第2次迁移来的
--结算单增加银行付款单状态，返回信息
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FBankPayState' 
	and KSQL_COL_TABNAME='T_FS_SettlementBill')
ALTER TABLE T_FS_SettlementBill ADD FBankPayState INT;
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FBankReturnInfo' 
	and KSQL_COL_TABNAME='T_FS_SettlementBill')
ALTER TABLE T_FS_SettlementBill ADD FBankReturnInfo NVARCHAR(80);
--业务种类增加属性
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FIsSendDownUnit' 
AND KSQL_COL_TABNAME='T_FS_SettBizType') 
ALTER TABLE T_FS_SettBizType ADD FIsSendDownUnit INT DEFAULT 1;
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FIsOnlyClHouse' 
AND KSQL_COL_TABNAME='T_FS_SettBizType') 
ALTER TABLE T_FS_SettBizType ADD FIsOnlyClHouse INT DEFAULT 0;


--5.4补丁begin
--结算单增加凭证号，凭证字
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FVoucheerID' 
	and KSQL_COL_TABNAME='T_FS_SettlementBill')
ALTER TABLE T_FS_SettlementBill ADD FVoucheerID VARCHAR(44);
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FVoucherTypeID' 
	and KSQL_COL_TABNAME='T_FS_SettlementBill')
ALTER TABLE T_FS_SettlementBill ADD FVoucherTypeID VARCHAR(44);

--增加结算单分录表
If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME='T_FS_SettlementEntry')
Create Table T_FS_SettlementEntry ( FID VARCHAR(44) NOT NULL ,FSeq INT,FSettlementBillID VARCHAR(44),FAmount NUMERIC(28,10),FLocalAmount NUMERIC(28,10),FRemark NVARCHAR(80),CONSTRAINT PK_SettlementEntry PRIMARY KEY (FID));
--结算单增加内部付款科目，内部收款科目
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FInnerPayerAcctID' 
	and KSQL_COL_TABNAME='T_FS_SettlementBill')
ALTER TABLE T_FS_SettlementBill ADD FInnerPayerAcctID VARCHAR(44);
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FInnerPayeeAcctID' 
	and KSQL_COL_TABNAME='T_FS_SettlementBill')
ALTER TABLE T_FS_SettlementBill ADD FInnerPayeeAcctID VARCHAR(44);

--结算单增加是否有分录附件
If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FIsHaveEntrys'
 and KSQL_COL_TABNAME = 'T_FS_SettlementBill' )
ALTER TABLE T_FS_SettlementBill ADD FIsHaveEntrys int default 0;

--内部账户增加是否默认清算户字段
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FIsDefaultReck' AND KSQL_COL_TABNAME='T_FS_InnerAccount') 
ALTER TABLE T_FS_InnerAccount ADD FIsDefaultReck INT DEFAULT 0;
--结算单增加付款方省,付款方市县
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FPayProvinceStr' 
	and KSQL_COL_TABNAME='T_FS_SettlementBill')
ALTER TABLE T_FS_SettlementBill ADD FPayProvinceStr NVARCHAR(100);
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FPayCityStr' 
	and KSQL_COL_TABNAME='T_FS_SettlementBill')
ALTER TABLE T_FS_SettlementBill ADD FPayCityStr NVARCHAR(100);

--内部账户组
If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_FS_InnerAcctGroup')
Create Table T_FS_InnerAcctGroup ( FNumber NVARCHAR(80),FBizDate DateTime,FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(80),FHasEffected INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCompanyID VARCHAR(44),FControlUnitID VARCHAR(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4',FCtrlParamID VARCHAR(44),FName NVARCHAR(100),CONSTRAINT PK_FS_InnerAGID PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_FS_InnerAcctGroupEntry')
Create Table T_FS_InnerAcctGroupEntry ( FSeq INT,FID VARCHAR(44) NOT NULL ,FParentID VARCHAR(44) NOT NULL ,FInnerAcctID VARCHAR(44),CONSTRAINT PK_FS_InnerAGEID PRIMARY KEY (FID));

--增加计划项目
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FFpItemID' 
	and KSQL_COL_TABNAME='T_FS_TransUpBill')
ALTER TABLE T_FS_TransUpBill ADD FFpItemID VARCHAR(44);
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FFpItemID' 
	and KSQL_COL_TABNAME='T_FS_TransDownBill')
ALTER TABLE T_FS_TransDownBill ADD FFpItemID VARCHAR(44);
--6.0sp1
--结算单增加“是否从银行交易明细下载”字段
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FIsDlFromBe' AND KSQL_COL_TABNAME='T_FS_SettlementBill')
alter table T_FS_SettlementBill add FIsDlFromBe INT DEFAULT 0;
--结算单增加“是否复制新增”字段
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FIsCopyAdd' AND KSQL_COL_TABNAME='T_FS_SettlementBill')
alter table T_FS_SettlementBill add FIsCopyAdd INT DEFAULT 0;
--收款方国家
If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FFRecCountryID' and KSQL_COL_TABNAME = 'T_FS_SettlementBill' )
ALTER TABLE T_FS_SettlementBill ADD FFRecCountryID VARCHAR(44);
--结算类型增加字段"是否不需要提交结算中心"
If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FNotSubmitHouse' and KSQL_COL_TABNAME = 'T_FS_SettBizType' )
ALTER TABLE T_FS_SettBizType ADD FNotSubmitHouse int default 0;
--内部账户增加字段"默认中心账号"
If not exists ( select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FDeFaultAcctBankID' and KSQL_COL_TABNAME = 'T_FS_InnerAccount' )
ALTER TABLE T_FS_InnerAccount ADD FDeFaultAcctBankID varchar(44);
--下拨单分录增加省市
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FRecProvince' 
	and KSQL_COL_TABNAME='T_FS_TransDownBillEntry')
ALTER TABLE T_FS_TransDownBillEntry ADD FRecProvince NVARCHAR(100);
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FRecCity' 
	and KSQL_COL_TABNAME='T_FS_TransDownBillEntry')
ALTER TABLE T_FS_TransDownBillEntry ADD FRecCity NVARCHAR(100);
--上划单增加省市
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FRecProvince' 
	and KSQL_COL_TABNAME='T_FS_TransUpBill')
ALTER TABLE T_FS_TransUpBill ADD FRecProvince NVARCHAR(100);
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FRecCity' 
	and KSQL_COL_TABNAME='T_FS_TransUpBill')
ALTER TABLE T_FS_TransUpBill ADD FRecCity NVARCHAR(100);
--增加默认值
IF  EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME = 'FPayeeAmount'
                        AND KSQL_COL_TABNAME = 'T_FS_SettlementBill'
                       AND KSQL_COL_DEFAULT IS NULL)
ALTER TABLE T_FS_SettlementBill add default  0  for FPayeeAmount; 
IF  EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME = 'FPayerAmount'
                        AND KSQL_COL_TABNAME = 'T_FS_SettlementBill'
                       AND KSQL_COL_DEFAULT IS NULL)
ALTER TABLE T_FS_SettlementBill add default  0  for FPayerAmount; 

--705增加预置业务种类，由于705没有独立的建库脚本，所以只能在这里增加
if not exists (select * from T_FS_SettBizType where fid in('DawAAAAHjvhHhokP'))
insert into t_fs_settbiztype(FID, FName_L1, FName_L2, FName_L3, FNumber, FType, FDescription_L1, FDescription_L2, FDescription_L3, FSimpleName, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FIsSendDownUnit, FIsOnlyClHouse, FNotSubmitHouse)
 values 
(N'DawAAAAHjvhHhokP', null, N'对外收款', N'對外收款', N'01', 1, null, null, null, null, '00000000-0000-0000-0000-00000000000013B7DE7F', {ts'2011-10-25 13:35:55'}, '00000000-0000-0000-0000-00000000000013B7DE7F', {ts'2011-10-25 13:35:55'}, '00000000-0000-0000-0000-000000000000CCE7AED4', 0, 0, 0);

if not exists (select * from T_FS_SettBizType where fid in('DawAAAAHjvlHhokP'))
insert into t_fs_settbiztype(FID, FName_L1, FName_L2, FName_L3, FNumber, FType, FDescription_L1, FDescription_L2, FDescription_L3, FSimpleName, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FIsSendDownUnit, FIsOnlyClHouse, FNotSubmitHouse)
 values 
(N'DawAAAAHjvlHhokP', null, N'对外付款', N'對外付款', N'02', 2, null, null, null, null, '00000000-0000-0000-0000-00000000000013B7DE7F', {ts'2011-10-25 13:36:04'}, '00000000-0000-0000-0000-00000000000013B7DE7F', {ts'2011-10-25 13:36:04'}, '00000000-0000-0000-0000-000000000000CCE7AED4', 0, 0, 0);

if not exists (select * from T_FS_SettBizType where fid in('DawAAAAHkOdHhokP'))
insert into t_fs_settbiztype(FID, FName_L1, FName_L2, FName_L3, FNumber, FType, FDescription_L1, FDescription_L2, FDescription_L3, FSimpleName, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FIsSendDownUnit, FIsOnlyClHouse, FNotSubmitHouse)
 values 
(N'DawAAAAHkOdHhokP', null, N'联动支付', N'聯動支付', N'08', 10, null, null, null, null, '00000000-0000-0000-0000-00000000000013B7DE7F', {ts'2011-10-25 13:37:57'}, '00000000-0000-0000-0000-00000000000013B7DE7F', {ts'2011-10-25 13:37:57'}, '00000000-0000-0000-0000-000000000000CCE7AED4', 0, 0, 0);

if not exists (select * from T_FS_SettBizType where fid in('DawAAAAHkOhHhokP'))
insert into t_fs_settbiztype(FID, FName_L1, FName_L2, FName_L3, FNumber, FType, FDescription_L1, FDescription_L2, FDescription_L3, FSimpleName, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FIsSendDownUnit, FIsOnlyClHouse, FNotSubmitHouse)
 values 
(N'DawAAAAHkOhHhokP', null, N'不同币别对外付款', N'不同幣別對外付款', N'07', 100, null, null, null, null, '00000000-0000-0000-0000-00000000000013B7DE7F', {ts'2011-10-25 13:38:09'}, '00000000-0000-0000-0000-00000000000013B7DE7F', {ts'2011-10-25 13:38:09'}, '00000000-0000-0000-0000-000000000000CCE7AED4', 0, 0, 0);

if not exists (select * from T_FS_SettBizType where fid in('DawAAAAHkOVHhokP'))
insert into t_fs_settbiztype(FID, FName_L1, FName_L2, FName_L3, FNumber, FType, FDescription_L1, FDescription_L2, FDescription_L3, FSimpleName, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FIsSendDownUnit, FIsOnlyClHouse, FNotSubmitHouse)
 values 
(N'DawAAAAHkOVHhokP', null, N'对内收款', N'對內收款', N'03', 3, null, null, null, null, '00000000-0000-0000-0000-00000000000013B7DE7F', {ts'2011-10-25 13:37:32'}, '00000000-0000-0000-0000-00000000000013B7DE7F', {ts'2011-10-25 13:37:32'}, '00000000-0000-0000-0000-000000000000CCE7AED4', 0, 0, 0);

if not exists (select * from T_FS_SettBizType where fid in('DawAAAAHkOZHhokP'))
insert into t_fs_settbiztype(FID, FName_L1, FName_L2, FName_L3, FNumber, FType, FDescription_L1, FDescription_L2, FDescription_L3, FSimpleName, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FIsSendDownUnit, FIsOnlyClHouse, FNotSubmitHouse)
 values 
(N'DawAAAAHkOZHhokP', null, N'对内付款', N'對內付款', N'04', 4, null, null, null, null, '00000000-0000-0000-0000-00000000000013B7DE7F', {ts'2011-10-25 13:37:40'}, '00000000-0000-0000-0000-00000000000013B7DE7F', {ts'2011-10-25 13:37:40'}, '00000000-0000-0000-0000-000000000000CCE7AED4', 0, 0, 0);

--业务种类将之前预置的从前面删掉，重新预置，因为后3个字段的默认值不对
if not exists (select * from T_FS_SettBizType where fid in('KAlH3gEWEADgAIikwKg9BkeGiQ8='))
insert into t_fs_settbiztype(FID, FNAME_L1, FNAME_L2, FNAME_L3, FNUMBER, FTYPE, FDESCRIPTION_L1, FDESCRIPTION_L2, FDESCRIPTION_L3, FSIMPLENAME, FCREATORID, FCREATETIME, FLASTUPDATEUSERID, FLASTUPDATETIME, FCONTROLUNITID, FIsSendDownUnit, FIsOnlyClHouse, FNotSubmitHouse)
 values 
('KAlH3gEWEADgAIikwKg9BkeGiQ8=', null, N'对内收款（跨行）', N'對內收款（跨行）', N'05', 51, null, null, null, null, '00000000-0000-0000-0000-00000000000013B7DE7F', {ts'2007-11-10 14:25:27'}, '00000000-0000-0000-0000-00000000000013B7DE7F', {ts'2007-11-10 14:25:27'}, '00000000-0000-0000-0000-000000000000CCE7AED4',0, 0, 0);

if not exists (select * from T_FS_SettBizType where fid in('KAlH3gEWEADgAIjVwKg9BkeGiQ8='))
insert into t_fs_settbiztype(FID, FNAME_L1, FNAME_L2, FNAME_L3, FNUMBER, FTYPE, FDESCRIPTION_L1, FDESCRIPTION_L2, FDESCRIPTION_L3, FSIMPLENAME, FCREATORID, FCREATETIME, FLASTUPDATEUSERID, FLASTUPDATETIME, FCONTROLUNITID, FIsSendDownUnit, FIsOnlyClHouse, FNotSubmitHouse)
 values 
('KAlH3gEWEADgAIjVwKg9BkeGiQ8=', null, N'对内付款（跨行）', N'對內付款（跨行）', N'06', 52, null, null, null, null, '00000000-0000-0000-0000-00000000000013B7DE7F', {ts'2007-11-10 14:25:47'}, '00000000-0000-0000-0000-00000000000013B7DE7F', {ts'2007-11-10 14:25:47'}, '00000000-0000-0000-0000-000000000000CCE7AED4',0, 0, 0);
