
--ALTER TABLE T_SD_SaleInvoice ADD CONSTRAINT UX_SD_Inv_Num UNIQUE(FNumber );

--ALTER TABLE T_SD_SaleReturns ADD CONSTRAINT UX_SD_Ret_Num UNIQUE(FNumber );

--ALTER TABLE T_SD_SalesExpenseInvoice ADD CONSTRAINT UX_SD_Sei_Num UNIQUE(FNumber );

CREATE CLUSTERED INDEX IX_SD_SO_Num ON T_SD_SaleOrder(FNumber DESC);
CREATE CLUSTERED INDEX IX_SD_SOEParent ON T_SD_SaleOrderEntry(FParentID ,FID,FSeq ASC);
CREATE CLUSTERED INDEX IX_SD_Pos_Num ON T_SD_PostRequisition(FNumber DESC);
CREATE CLUSTERED INDEX IX_SD_PREParent ON T_SD_PostRequisitionEntry(FParentID ,FID,FSeq ASC);
--CREATE CLUSTERED INDEX IX_SD_Inv_Num ON T_SD_SaleInvoice(FNumber DESC);
--CREATE CLUSTERED INDEX IX_SD_SIEParent ON T_SD_SaleInvoiceEntry(FParentID ,FSeq ASC);
CREATE CLUSTERED INDEX IX_SD_Ret_Num ON T_SD_SaleReturns(FNumber ASC);
CREATE CLUSTERED INDEX IX_SD_SREParent ON T_SD_SaleReturnsEntry(FParentID ,FID,FSeq ASC);
--CREATE CLUSTERED INDEX IX_SD_Sei_Num ON T_SD_SalesExpenseInvoice(FNumber ASC);
--CREATE CLUSTERED INDEX IX_SD_SEIEParent ON T_SD_SaleExpenseInvEntry(FParentID ,FSeq ASC);

--增加业务日期索引
If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_SD_SOBizDate')
CREATE  INDEX IX_SD_SOBizDate ON T_SD_SaleOrder(FBizDate DESC);

If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_SD_PORBizDate')
CREATE  INDEX IX_SD_PORBizDate ON T_SD_PostRequisition(FBizDate DESC);

If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_SD_SRETBizDate')
CREATE  INDEX IX_SD_SRETBizDate ON T_SD_SaleReturns(FBizDate DESC);

If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_SCM_Con_Num')
CREATE CLUSTERED INDEX IX_SCM_Con_Num ON T_SCM_Contrace(FNumber ASC);

If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_SCM_ConTLum')
CREATE CLUSTERED INDEX IX_SCM_ConTLum ON T_SCM_ContraceTREE(FLongNumber);

If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_SD_Con_Num')
CREATE CLUSTERED INDEX IX_SD_Con_Num ON T_SD_SaleContract(FNumber ASC);

If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_SD_ConEParent')
CREATE CLUSTERED INDEX IX_SD_ConEParent ON T_SD_SaleContractEntry(FParentID ,FID,FSeq ASC);

If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_SD_ConTParent')
CREATE INDEX IX_SD_ConTParent ON T_SD_SaleContractTerm(FParentID);

--销售合同进度跟踪报表优化 paul
If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_SD_SOESRC')
CREATE INDEX IX_SD_SOESRC ON T_SD_SaleOrderEntry(FSourceBillID, FSourceBillEntryID);

--防止全表扫描
If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_SD_SOEOLDID')
CREATE INDEX IX_SD_SOEOLDID ON T_SD_SaleOrderEntry(FOldID);

-- 描述：存货收发存明细账报表性能分析优化
-- 日期：2008-11-10
-- 编写: 董洪兵

IF EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_PurInW_B_BateIdB')
drop index T_IM_PurInWarehsBill.IX_PurInW_B_BateIdB;
IF EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_PurIn_B_BateIdB')
drop index T_IM_PurInWarehsBill.IX_PurIn_B_BateIdB;

IF EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_PurInW_E_CPM')
drop index T_IM_PurInWarehsEntry.IX_PurInW_E_CPM;

IF EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_MafRec_B_BateIdB')
drop index T_IM_ManufactureRecBill.IX_MafRec_B_BateIdB;
IF EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_MafR_B_BateIdB')
drop index T_IM_ManufactureRecBill.IX_MafR_B_BateIdB;

IF EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_MafRec_E_CPM')
drop index T_IM_ManufactureRecBillEntry.IX_MafRec_E_CPM;

IF EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_MoveInW_B_BateIdB')
drop index T_IM_MoveInWarehsBill.IX_MoveInW_B_BateIdB;
IF EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_MovIn_B_BateIdB')
drop index T_IM_MoveInWarehsBill.IX_MovIn_B_BateIdB;

IF EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_MoveInW_E_CPM')
drop index T_IM_MoveInWarehsBillEntry.IX_MoveInW_E_CPM;

IF EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_OtherInW_B_BateIdB')
drop index T_IM_OtherInWarehsBill.IX_OtherInW_B_BateIdB;
IF EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_OthIn_B_BateIdB')
drop index T_IM_OtherInWarehsBill.IX_OthIn_B_BateIdB;

IF EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_OtherInW_E_CPM')
drop index T_IM_OtherInWarehsBillEntry.IX_OtherInW_E_CPM;

IF EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_SALEISSUE_B_BateIdB')
drop index T_IM_SaleIssueBill.IX_SALEISSUE_B_BateIdB;
IF EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_SALIS_B_BateIdB')
drop index T_IM_SaleIssueBill.IX_SALIS_B_BateIdB;

IF EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_SALEISSUE_E_CPM')
drop index T_IM_SALEISSUEENTRY.IX_SALEISSUE_E_CPM;

IF EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_MatReq_B_BateIdB')
drop index T_IM_MaterialReqBill.IX_MatReq_B_BateIdB;
IF EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_MatR_B_BateIdB')
drop index T_IM_MaterialReqBill.IX_MatR_B_BateIdB;

IF EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_MatReq_E_CPM')
drop index T_IM_MaterialReqBillEntry.IX_MatReq_E_CPM;

IF EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_MoveIssue_B_BateIdB')
drop index T_IM_MoveIssueBill.IX_MoveIssue_B_BateIdB;
IF EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_MovIs_B_BateIdB')
drop index T_IM_MoveIssueBill.IX_MovIs_B_BateIdB;

IF EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_MoveIssue_E_CPM')
drop index T_IM_MoveIssueBillEntry.IX_MoveIssue_E_CPM;

IF EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_OthIssue_B_BateIdB')
drop index T_IM_OtherIssueBill.IX_OthIssue_B_BateIdB;
IF EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_OthIs_B_BateIdB')
drop index T_IM_OtherIssueBill.IX_OthIs_B_BateIdB;

IF EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_OthIssue_E_CPM')
drop index T_IM_OtherIssueBillEntry.IX_OthIssue_E_CPM;

IF EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_CostAdjust_B_BateIdB')
drop index T_CL_CostAdjustBill.IX_CostAdjust_B_BateIdB;
IF EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_CostA_B_BateIdB')
drop index T_CL_CostAdjustBill.IX_CostA_B_BateIdB;

IF EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_CostAdjust_E_CPM')
drop index T_CL_CostAdjustBillEntry.IX_CostAdjust_E_CPM;
IF EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_CstAdjust_E_CPM')
drop index T_CL_CostAdjustBillEntry.IX_CstAdjust_E_CPM;

IF EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_StdCost_B_BateIdB')
drop index T_CL_StandardCostAdjBill.IX_StdCost_B_BateIdB;
IF EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_SCost_B_BateIdB')
drop index T_CL_StandardCostAdjBill.IX_SCost_B_BateIdB;

IF EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_InvBlnce_B_CYPM')
drop index t_im_inventorybalance.IX_InvBlnce_B_CYPM;


IF NOT EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_PurIn_B_BateIdB')
CREATE INDEX IX_PurIn_B_BateIdB
          ON T_IM_PurInWarehsBill(FBIZDATE ASC, FID ASC, FBASESTATUS ASC);  

IF NOT EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_PurInW_E_CPM')
CREATE INDEX IX_PurInW_E_CPM
          ON T_IM_PurInWarehsEntry(FCOMPANYORGUNITID ASC, FPARENTID ASC, FMATERIALID ASC);          

IF NOT EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_MafR_B_BateIdB')
CREATE INDEX IX_MafR_B_BateIdB
          ON T_IM_ManufactureRecBill(FBIZDATE ASC, FID ASC, FBASESTATUS ASC);            

IF NOT EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_MafRec_E_CPM')
CREATE INDEX IX_MafRec_E_CPM
          ON T_IM_ManufactureRecBillEntry(FCOMPANYORGUNITID ASC, FPARENTID ASC, FMATERIALID ASC);            

IF NOT EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_MovIn_B_BateIdB')
CREATE INDEX IX_MovIn_B_BateIdB
          ON T_IM_MoveInWarehsBill(FBIZDATE ASC, FID ASC, FBASESTATUS ASC);

IF NOT EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_MoveInW_E_CPM')
CREATE INDEX IX_MoveInW_E_CPM
          ON T_IM_MoveInWarehsBillEntry(FCOMPANYORGUNITID ASC, FPARENTID ASC, FMATERIALID ASC);

IF NOT EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_OthIn_B_BateIdB')
CREATE INDEX IX_OthIn_B_BateIdB
          ON T_IM_OtherInWarehsBill(FBIZDATE ASC, FID ASC, FBASESTATUS ASC);

IF NOT EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_OtherInW_E_CPM')
CREATE INDEX IX_OtherInW_E_CPM
          ON T_IM_OtherInWarehsBillEntry(FCOMPANYORGUNITID ASC, FPARENTID ASC, FMATERIALID ASC);
          
IF NOT EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_SALIS_B_BateIdB')
CREATE INDEX IX_SALIS_B_BateIdB
          ON T_IM_SaleIssueBill(FBIZDATE ASC, FID ASC, FBASESTATUS ASC);

IF NOT EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_SALEISSUE_E_CPM')
CREATE INDEX IX_SALEISSUE_E_CPM
          ON T_IM_SALEISSUEENTRY(FCOMPANYORGUNITID ASC, FPARENTID ASC, FMATERIALID ASC);

IF NOT EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_MatR_B_BateIdB')
CREATE INDEX IX_MatR_B_BateIdB
          ON T_IM_MaterialReqBill(FBIZDATE ASC, FID ASC, FBASESTATUS ASC);

IF NOT EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_MatReq_E_CPM')
CREATE INDEX IX_MatReq_E_CPM
          ON T_IM_MaterialReqBillEntry(FCOMPANYORGUNITID ASC, FPARENTID ASC, FMATERIALID ASC);

IF NOT EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_MovIs_B_BateIdB')
CREATE INDEX IX_MovIs_B_BateIdB
          ON T_IM_MoveIssueBill(FBIZDATE ASC, FID ASC, FBASESTATUS ASC);

IF NOT EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_MoveIssue_E_CPM')
CREATE INDEX IX_MoveIssue_E_CPM
          ON T_IM_MoveIssueBillEntry(FCOMPANYORGUNITID ASC, FPARENTID ASC, FMATERIALID ASC);          
          
IF NOT EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_OthIs_B_BateIdB')
CREATE INDEX IX_OthIs_B_BateIdB
          ON T_IM_OtherIssueBill(FBIZDATE ASC, FID ASC, FBASESTATUS ASC);          

IF NOT EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_OthIssue_E_CPM')
CREATE INDEX IX_OthIssue_E_CPM
          ON T_IM_OtherIssueBillEntry(FCOMPANYORGUNITID ASC, FPARENTID ASC, FMATERIALID ASC);            

IF NOT EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_CostA_B_BateIdB')
CREATE INDEX IX_CostA_B_BateIdB
          ON T_CL_CostAdjustBill(FBIZDATE ASC, FID ASC, FBASESTATUS ASC);

IF NOT EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_CstAdjust_E_CPM')
CREATE INDEX IX_CstAdjust_E_CPM
          ON T_CL_CostAdjustBillEntry(FCOMPANYORGUNITID ASC, FPARENTID ASC, FMATERIALID ASC);

IF NOT EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_SCost_B_BateIdB')
CREATE INDEX IX_SCost_B_BateIdB
          ON T_CL_StandardCostAdjBill(FBIZDATE ASC, FID ASC, FBASESTATUS ASC);
          
IF NOT EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_InvBlnce_B_CYPM')
CREATE INDEX IX_InvBlnce_B_CYPM
          ON t_im_inventorybalance(FCOMPANYORGUNITID ASC, FYEAR ASC, FPERIOD ASC, FMATERIALID ASC);
