/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.kingdee.shr.api.OSFResponse;
import com.kingdee.shr.secrity.AESUtils;
import com.kingdee.shr.util.DateTypeAdapter;
import com.kingdee.shr.util.IntegerAdapter;
import com.kingdee.shr.util.LongAdapter;
import com.kingdee.shr.util.StringTypeAdapter;
import java.sql.Timestamp;
import java.util.Date;

public class DataHandlerUtil {
    public static String formatResponseDataHandle(String result, boolean errorTrowExc) throws Exception {
        String _result_ = result;
        if (DataHandlerUtil.isFormatResponse(result)) {
            Gson gson = DataHandlerUtil.getGson();
            OSFResponse ors = (OSFResponse)gson.fromJson(result, OSFResponse.class);
            if (ors.getErrCode() == 0) {
                if (null != ors.get_e_x_t_d_() && !DataHandlerUtil.isEmpty(ors.get_e_x_t_d_().get_d_k_()) && !DataHandlerUtil.isEmpty(ors.get_e_x_t_d_().get_e_s_k_())) {
                    String _key_ = AESUtils.cbcDecrypt(ors.get_e_x_t_d_().get_e_s_k_(), ors.get_e_x_t_d_().get_d_k_());
                    _result_ = AESUtils.cbcDecrypt((String)ors.getData(), _key_);
                } else {
                    JsonElement data = JsonParser.parseString((String)result).getAsJsonObject().get("data");
                    _result_ = data.isJsonNull() ? null : (data.isJsonArray() ? data.getAsJsonArray().toString() : (data.isJsonObject() ? data.getAsJsonObject().toString() : (data.isJsonPrimitive() ? data.getAsJsonPrimitive().toString() : data.toString())));
                }
            } else {
                if (errorTrowExc) {
                    throw new Exception("Call OSF errCode:" + ors.getErrCode() + ",bizCode:" + ors.getBizCode() + ",errMsg: " + ors.getErrMsg());
                }
                _result_ = "{ \"error\": \"Call OSF errCode:" + ors.getErrCode() + ",bizCode:" + ors.getBizCode() + ",errMsg: " + ors.getErrMsg() + "!\"}";
            }
        }
        return _result_;
    }

    private static boolean isFormatResponse(String result) {
        return !DataHandlerUtil.isEmpty(result) && result.contains("errCode") && result.contains("bizCode") && result.contains("errMsg") && result.contains("data") && result.contains("_e_x_t_d_");
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    private static Gson getGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.serializeNulls();
        builder.disableHtmlEscaping();
        builder.serializeSpecialFloatingPointValues();
        builder.registerTypeAdapter(Integer.class, (Object)new IntegerAdapter());
        builder.registerTypeAdapter(Long.class, (Object)new LongAdapter());
        builder.registerTypeHierarchyAdapter(Date.class, (Object)new DateTypeAdapter());
        builder.registerTypeHierarchyAdapter(Timestamp.class, (Object)new DateTypeAdapter());
        builder.registerTypeHierarchyAdapter(String.class, (Object)new StringTypeAdapter());
        return builder.create();
    }
}

