/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.handler;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.rabbitmq.guava.Lists;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.custom.performanceScoring.handler.EvaResultSummaryManagerListHandlerEx;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.perf.PerformProTeamCollection;
import com.kingdee.eas.hr.perf.PerformProTeamFactory;
import com.kingdee.eas.hr.perf.PersonPerformProCollection;
import com.kingdee.eas.hr.perf.PersonPerformProFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.MSFServiceFacadeFactory;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsBody;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsHeader;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSumLogSourceEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.EvalplanCycleTypeEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.IEvaResultSummary;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfEvaObject;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectFactory;
import com.kingdee.shr.perfweb.app.exception.SHRPerfWebBizException;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.util.EvaResultSumRevisionLogService;
import com.kingdee.shr.perfweb.util.EvaResultSummaryBillUtil;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.Month;
import java.time.Year;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;

public class EvaResultSummaryManagerListHandlerExEx
extends EvaResultSummaryManagerListHandlerEx {
    private static final Logger logger = LoggerFactory.getLogger(EvaResultSummaryManagerListHandlerExEx.class);

    public void batchSaveReviseDataAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, BatchMessageTipsHeader batchMessageTipsHeader) throws SHRWebException {
        List unValidIds;
        Context ctx = SHRContext.getInstance().getContext();
        try {
            unValidIds = EvaResultSummaryBillUtil.validEvaResultSummaryBill((Context)ctx, (String)null, (String)request.getParameter("billId"), (String)"10");
            if (unValidIds.size() > 0) {
                EvaResultSummaryManagerListHandlerExEx.addBatchMessageTips((Collection)unValidIds, (String)SHRPerfWebResourceUtil.getRes((SHRPerfWebResource)SHRPerfWebResource.CANNOTENTRYREVISEBYBILLSTATE, (Context)ctx), (BatchMessageTipsHeader)batchMessageTipsHeader);
            }
        }
        catch (BOSException var12) {
            logger.error("\u3010PERFWEB--batchSaveReviseDataAction\u3011-it is failed to get state of summary bill,e=", (Throwable)var12);
            throw new ShrWebBizException(SHRPerfWebResourceUtil.getRes((SHRPerfWebResource)SHRPerfWebResource.CANNOTENTRYREVISEBYBILLSTATE, (Context)ctx));
        }
        try {
            String datas = request.getParameter("datas");
            if (!StringUtils.isEmpty((String)datas)) {
                if (!CollectionUtils.isEmpty((Collection)unValidIds)) {
                    List reviseDataList = JSONArray.parseArray((String)datas, HashMap.class);
                    ArrayList<HashMap> rightDatas = new ArrayList<HashMap>(reviseDataList.size());
                    for (HashMap map : reviseDataList) {
                        if (unValidIds.contains(map.get("id"))) continue;
                        rightDatas.add(map);
                    }
                    datas = JSONArray.toJSONString(rightDatas);
                }
                this._batchSaveReviseData(ctx, datas, batchMessageTipsHeader);
            }
        }
        catch (Exception var13) {
            logger.error("batchSaveReviseDataAction is error: ", (Throwable)var13);
        }
    }

    protected void _batchSaveReviseData(Context ctx, String reviseDataJson, BatchMessageTipsHeader batchMessageTipsHeader) throws BOSException, EASBizException {
        List reviseDataList = JSONArray.parseArray((String)reviseDataJson, HashMap.class);
        CoreBaseCollection evaResultSummaryCollection = new CoreBaseCollection();
        if (!CollectionUtils.isEmpty((Collection)reviseDataList)) {
            HashSet<String> summaryIds = new HashSet<String>(reviseDataList.size());
            HashSet<String> summaryErrIds = new HashSet<String>(reviseDataList.size());
            for (HashMap reviseData : reviseDataList) {
                EvaResultSummaryInfo evaResultSummaryInfo = new EvaResultSummaryInfo();
                summaryIds.add((String)reviseData.get("id"));
                evaResultSummaryInfo.put("id", reviseData.get("id"));
                if (reviseData.get("reviseSumScore") != null && org.apache.commons.lang.StringUtils.isNotBlank((String)String.valueOf(reviseData.get("reviseSumScore")))) {
                    evaResultSummaryInfo.put("reviseSumScore", reviseData.get("reviseSumScore"));
                }
                evaResultSummaryInfo.put("reviseGradeLevel", reviseData.get("reviseGradeLevel"));
                evaResultSummaryInfo.put("reviseReason", reviseData.get("reviseReason"));
                Object perCoefficientObj = reviseData.get("perCoefficient");
                Object perMaxCoefficientObj = reviseData.get("perMaxCoefficient");
                Object perMinCoefficientObj = reviseData.get("perMinCoefficient");
                if (null == perCoefficientObj || null == perMaxCoefficientObj || null == perMinCoefficientObj) {
                    evaResultSummaryCollection.add((CoreBaseInfo)evaResultSummaryInfo);
                    continue;
                }
                evaResultSummaryInfo.put("perCoefficient", perCoefficientObj);
                evaResultSummaryInfo.put("perMaxCoefficient", perMaxCoefficientObj);
                evaResultSummaryInfo.put("perMinCoefficient", perMinCoefficientObj);
                BigDecimal perMaxCoefficient = new BigDecimal(perMaxCoefficientObj.toString());
                BigDecimal perMinCoefficient = new BigDecimal(perMinCoefficientObj.toString());
                BigDecimal perCoefficient = new BigDecimal(perCoefficientObj.toString());
                if (perCoefficient.compareTo(perMaxCoefficient) > 0 || perCoefficient.compareTo(perMinCoefficient) < 0) {
                    summaryErrIds.add((String)reviseData.get("id"));
                    EvaResultSummaryManagerListHandlerExEx.addBatchMessageTip((String)((String)reviseData.get("id")), (String)"\u6240\u4fee\u6539\u7684\u7ee9\u6548\u7cfb\u6570\uff0c\u5927\u4e8e\u6700\u5927\u7ee9\u6548\u7cfb\u6570\u6216\u8005\u5c0f\u4e8e\u6700\u5c0f\u7ee9\u6548\u7cfb\u6570\uff01", (BatchMessageTipsHeader)batchMessageTipsHeader);
                    continue;
                }
                evaResultSummaryCollection.add((CoreBaseInfo)evaResultSummaryInfo);
            }
            Object periodId = ((HashMap)reviseDataList.get(0)).get("periodId");
            List unValidIds = periodId != null ? EvaResultSummaryBillUtil.batchCheckScore((Context)ctx, (CoreBaseCollection)evaResultSummaryCollection, (String)((String)periodId), (BatchMessageTipsHeader)batchMessageTipsHeader) : EvaResultSummaryBillUtil.batchCheckScoreBySummary((Context)ctx, (CoreBaseCollection)evaResultSummaryCollection, (String)((String)((HashMap)reviseDataList.get(0)).get("perfSummarySchemeBaseId")), (BatchMessageTipsHeader)batchMessageTipsHeader);
            if (!CollectionUtils.isEmpty((Collection)unValidIds)) {
                summaryIds.removeAll(unValidIds);
            }
            if (!CollectionUtils.isEmpty(summaryErrIds)) {
                summaryIds.removeAll(summaryErrIds);
            }
            if (CollectionUtils.isEmpty(summaryIds)) {
                return;
            }
            IEvaResultSummary resultSummary = EvaResultSummaryFactory.getLocalInstance((Context)ctx);
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", summaryIds, CompareType.INCLUDE));
            entityViewInfo.setFilter(filterInfo);
            EvaResultSummaryCollection summaryCollection = resultSummary.getEvaResultSummaryCollection(entityViewInfo);
            CoreBaseCollection oldSummaryCollection = new CoreBaseCollection();
            if (summaryCollection != null && summaryCollection.size() > 0) {
                for (int i = 0; i < summaryCollection.size(); ++i) {
                    oldSummaryCollection.add((CoreBaseInfo)summaryCollection.get(i));
                }
            }
            EvaResultSumRevisionLogService evaResultSumRevisionLogService = new EvaResultSumRevisionLogService();
            CoreBaseCollection evaResultSumRevisionLogCollection = evaResultSumRevisionLogService.packageResultSumRevisionLog(EvaResultSumLogSourceEnum.ENTRYREVISE, oldSummaryCollection, evaResultSummaryCollection, false);
            System.out.println("evaResultSummaryCollection:" + evaResultSummaryCollection);
            resultSummary.save(evaResultSummaryCollection);
            evaResultSumRevisionLogService.generatedEvaResultSumRevisionLog(ctx, evaResultSumRevisionLogCollection);
        }
    }

    public void tempAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        ArrayList idList = Lists.newArrayList();
        String ids = this.getBillId(request);
        for (String id : ids.split(",")) {
            idList.add(id);
        }
        StringBuilder selParamId = new StringBuilder("''");
        for (int i = 0; i < idList.size(); ++i) {
            selParamId.append(",?");
        }
        StringBuilder sql = new StringBuilder();
        sql.append(" select ers.fid,pp.FPSTARTDATE,ers.FADMINORGUNITID,ers.FADMINORGNAME,pp.FYEAR,pp.FTIMEPERIOD, ");
        sql.append(" pp.FCYCLETYPE,pp.FPENDDATE,pp.FPSTARTDATE,ppn.CFPEROBJECTIDID,ppm.CFPROJECTNAME,pmm.CFEMPLOYEEID ");
        sql.append(" from T_EVA_EvaResultSummary ers ");
        sql.append(" left join T_EVA_PerfPlan ppn on ers.FEVAPLANID=ppn.fid ");
        sql.append(" left join T_EVA_PerfPeriod pp on ers.FPERIODID=pp.fid ");
        sql.append(" left join CT_PRO_ProjectManagement ppm on ppn.CFPEROBJECTIDID=ppm.fid ");
        sql.append(" left join CT_PRO_MemberManagement pmm on ppm.fid=pmm.CFPROJECTMANAGEMENID and pmm.CFSTATE=1 ");
        sql.append(" and pmm.CFPTYPEID in( ");
        sql.append(" select fid from CT_PRO_ProjectType where FNUMBER='ProjectManager') ");
        sql.append(" and pmm.CFPROJECTROLEID in( ");
        sql.append(" select fid from CT_PRO_ProjectRole where FNUMBER ='HTY110') ");
        sql.append(" where ers.fid in (");
        sql.append((CharSequence)selParamId);
        sql.append(") ");
        sql.append(" and pmm.CFEMPLOYEEID=ers.fpersonid ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])idList.toArray());
        HashMap map = Maps.newHashMap();
        map.put("ProjectManager", rs.size() > 0 ? "1" : "0");
        this.writeSuccessData(map);
    }

    private static PerfEvaObjectCollection getPerfEvaObjectCollectionByIds(Set<String> billIds) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", billIds, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        IPerfEvaObject iPerfEvaObject = PerfEvaObjectFactory.getRemoteInstance();
        return iPerfEvaObject.getPerfEvaObjectCollection(evi);
    }

    public BatchMessageTipsHeader verifyToDep(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String ids = (String)request.getAttribute("billId");
        String period = request.getParameter("period");
        String planId = request.getParameter("planId");
        ArrayList idList = Lists.newArrayList();
        for (String id : ids.split(",")) {
            idList.add(id);
        }
        BatchMessageTipsHeader header = new BatchMessageTipsHeader();
        StringBuilder selParamId = new StringBuilder("''");
        for (int i = 0; i < idList.size(); ++i) {
            selParamId.append(",?");
        }
        boolean isExists = true;
        StringBuilder idss = new StringBuilder();
        ArrayList<String> allIdList = new ArrayList<String>();
        int success = 0;
        int fail = 0;
        try {
            Context ctx = SHRContext.getInstance().getContext();
            StringBuilder sel = new StringBuilder();
            sel.append(" select ers.fid,ers.FADMINORGNAME,ers.FPNUMBER,ers.FPNAME,ers.FPOSITIONNAME, ");
            sel.append(" ers.FPERIODID, ers.FEVAPLANID,isnull(ers.FREVISEGRADELEVEL, ers.FGRADELEVEL) revLevel,ers.CFOrgLevel,ers.CFdepGradeLevel  ");
            sel.append(" from T_EVA_EvaResultSummary ers where ers.fid in (");
            sel.append((CharSequence)selParamId);
            sel.append(") ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sel.toString(), (Object[])idList.toArray());
            BigDecimal big100 = new BigDecimal(100);
            while (rs.next()) {
                BatchMessageTipsBody body = new BatchMessageTipsBody();
                String id = rs.getString("fid");
                boolean isSuccess = false;
                String msg = "";
                String pnumber = rs.getString("FPNUMBER");
                String pname = rs.getString("FPNAME");
                String positionName = rs.getString("FPOSITIONNAME");
                String auditGradeLevel = rs.getString("revLevel");
                body.setId(id);
                idss.append(id).append(",");
                allIdList.add(id);
                String depgradelevel = rs.getString("CFdepGradeLevel");
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)depgradelevel)) {
                    switch (depgradelevel) {
                        case "S": 
                        case "A": 
                        case "B": {
                            isSuccess = true;
                            msg = "\u6821\u9a8c\u901a\u8fc7";
                            ++success;
                            break;
                        }
                        case "C": 
                        case "D": {
                            if ("S".equals(auditGradeLevel) || "A".equals(auditGradeLevel)) {
                                isSuccess = false;
                                msg = "\u5f53\u8de8\u90e8\u95e8\u534f\u4f5c\u7ee9\u6548\u7b49\u7ea7\u4e3aC\u3001D\u7b49\u7ea7\u7684\uff0c\u5f53\u671f\u5458\u5de5\u7ee9\u6548\u4e0d\u5f97\u4e3a\u9ad8\u7ee9\u6548\uff08S\u3001A\u7b49\u7ea7\uff09";
                                ++fail;
                                break;
                            }
                            isSuccess = true;
                            msg = "\u6821\u9a8c\u901a\u8fc7";
                            ++success;
                        }
                    }
                } else {
                    msg = "\u6ca1\u6709\u5f53\u8de8\u90e8\u95e8\u534f\u4f5c\u7ee9\u6548\u7b49\u7ea7\uff0c\u8bf7\u5148\u68c0\u67e5\u8de8\u90e8\u95e8\u534f\u4f5c\u7ee9\u6548\u7b49\u7ea7";
                    isSuccess = true;
                    ++success;
                }
                body.setMuitTipsState(isSuccess);
                body.setMuitTipsMessage(msg);
                ArrayList<String> messageListExt = new ArrayList<String>();
                messageListExt.add(pnumber);
                messageListExt.add(pname);
                messageListExt.add(positionName);
                body.addMessageListExt(messageListExt);
                header.addResult(body);
            }
        }
        catch (BOSException | SQLException var7) {
            var7.printStackTrace();
        }
        idss.delete(ids.length() - 1, ids.length());
        header.setBillId(ids.toString());
        header.setFailureCount(fail);
        header.setSuccessCount(success);
        return header;
    }

    public void batchAssignGroupAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, BatchMessageTipsHeader batchMessageTipsHeader) throws SHRWebException, BOSException {
        String group = request.getParameter("group");
        String billIds = this.getBillId(request);
        Context ctx = SHRContext.getInstance().getContext();
        if (StringUtils.isEmpty((String)billIds) && StringUtils.isEmpty((String)group)) {
            throw new ShrWebBizException(new SHRPerfWebBizException(SHRPerfWebBizException.INDECATORNOTSAVEDINSELECTGROUP).getMessage());
        }
        try {
            String[] ids;
            HashSet fails = new HashSet();
            ArrayList idList = Lists.newArrayList();
            ArrayList idsessList = Lists.newArrayList();
            for (String id : ids = billIds.split(",")) {
                idList.add(id);
            }
            StringBuilder selParamId = new StringBuilder("''");
            for (int i = 0; i < idList.size(); ++i) {
                selParamId.append(",?");
            }
            StringBuilder sql = new StringBuilder();
            sql.append(" select FEVAOBJID,fid from T_EVA_EvaResultSummary where FBILLSTATE!=3 and fid in ( ");
            sql.append((CharSequence)selParamId);
            sql.append(" ) ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])idList.toArray());
            while (rowSet.next()) {
                String fid = rowSet.getString("fid");
                String upd = "update T_EVA_EvaResultSummary set cfgroup=? where fid=?";
                DbUtil.execute((Context)ctx, (String)upd, (Object[])new String[]{group, fid});
                idsessList.add(fid);
            }
            idList.removeAll(idsessList);
            fails.addAll(idList);
            if (fails.size() > 0) {
                EvaResultSummaryManagerListHandlerExEx.addBatchMessageTips(fails, (String)"\u53ea\u6709\u672a\u5ba1\u6838\u7684\u6570\u636e\u624d\u80fd\u6307\u5b9a\u5206\u7ec4\u3002", (BatchMessageTipsHeader)batchMessageTipsHeader);
            }
        }
        catch (BOSException var22) {
            logger.error("", (Throwable)var22);
            throw new ShrWebBizException(new SHRPerfWebBizException(SHRPerfWebBizException.SYSTEMERR).getMessage());
        }
        catch (SQLException var24) {
            logger.error("", (Throwable)var24);
            throw new ShrWebBizException(new SHRPerfWebBizException(SHRPerfWebBizException.SYSTEMERR).getMessage());
        }
    }

    public void clearBelongGroupAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, BatchMessageTipsHeader batchMessageTipsHeader) throws SHRWebException, BOSException {
        String billId = this.getBillId(request);
        if (!StringUtils.isEmpty((String)billId)) {
            try {
                String[] ids;
                Context ctx = SHRContext.getInstance().getContext();
                ArrayList idList = Lists.newArrayList();
                ArrayList idsessList = Lists.newArrayList();
                for (String id : ids = billId.split(",")) {
                    idList.add(id);
                }
                StringBuilder selParamId = new StringBuilder("''");
                for (int i = 0; i < idList.size(); ++i) {
                    selParamId.append(",?");
                }
                StringBuilder sql = new StringBuilder();
                sql.append(" select FEVAOBJID,fid from T_EVA_EvaResultSummary where FBILLSTATE!=3 and fid in ( ");
                sql.append((CharSequence)selParamId);
                sql.append(" ) ");
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])idList.toArray());
                while (rowSet.next()) {
                    String fid = rowSet.getString("fid");
                    String upd = "update T_EVA_EvaResultSummary set cfgroup=? where fid=?";
                    DbUtil.execute((Context)ctx, (String)upd, (Object[])new String[]{"", fid});
                    idsessList.add(fid);
                }
                idList.removeAll(idsessList);
                if (idList.size() > 0) {
                    EvaResultSummaryManagerListHandlerExEx.addBatchMessageTips((Collection)idList, (String)"\u53ea\u6709\u672a\u5ba1\u6838\u7684\u6570\u636e\u624d\u80fd\u6e05\u9664\u5206\u7ec4\u3002", (BatchMessageTipsHeader)batchMessageTipsHeader);
                }
            }
            catch (BOSException var22) {
                logger.error("", (Throwable)var22);
                throw new ShrWebBizException(new SHRPerfWebBizException(SHRPerfWebBizException.SYSTEMERR).getMessage());
            }
            catch (SQLException var24) {
                logger.error("", (Throwable)var24);
                throw new ShrWebBizException(new SHRPerfWebBizException(SHRPerfWebBizException.SYSTEMERR).getMessage());
            }
        }
    }

    public Map<String, Map<String, Object>> getPerformanceLevelByLevelAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws ShrWebBizException {
        HashMap result = Maps.newHashMap();
        try {
            Context ctx = SHRContext.getInstance().getContext();
            String sql = "select CFLEVEL,CFCOEFFICIENT,CFMAXCOEFFICIENT,CFMINCOEFFICIENT from CT_PER_PerformanceLevel ";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                HashMap map = Maps.newHashMap();
                String CFLEVEL = rs.getString("CFLEVEL");
                BigDecimal CFCOEFFICIENT = rs.getBigDecimal("CFCOEFFICIENT");
                BigDecimal CFMAXCOEFFICIENT = rs.getBigDecimal("CFMAXCOEFFICIENT");
                BigDecimal CFMINCOEFFICIENT = rs.getBigDecimal("CFMINCOEFFICIENT");
                map.put("level", CFLEVEL);
                map.put("coefficient", CFCOEFFICIENT);
                map.put("maxcoefficient", CFMAXCOEFFICIENT);
                map.put("mincoefficient", CFMINCOEFFICIENT);
                result.put(CFLEVEL, map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ShrWebBizException(e.getMessage());
        }
        return result;
    }

    public void performanceLevelAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, BatchMessageTipsHeader batchMessageTipsHeader) throws BOSException, SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        ArrayList idList = Lists.newArrayList();
        String ids = this.getBillId(request);
        String period = request.getParameter("period");
        String planId = request.getParameter("planId");
        ArrayList idsessList = Lists.newArrayList();
        for (String id : ids.split(",")) {
            idList.add(id);
        }
        StringBuilder selParamId = new StringBuilder("''");
        for (int i = 0; i < idList.size(); ++i) {
            selParamId.append(",?");
        }
        try {
            StringBuilder sqlsel = new StringBuilder();
            sqlsel.append(" select fid from T_EVA_EvaResultSummary where FBILLSTATE !=3 and fid in ( ");
            sqlsel.append((CharSequence)selParamId);
            sqlsel.append(" ) ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlsel.toString(), (Object[])idList.toArray());
            while (rs.next()) {
                idsessList.add(rs.getString("fid"));
            }
            StringBuilder selsessParamId = new StringBuilder("''");
            for (int i = 0; i < idsessList.size(); ++i) {
                selsessParamId.append(",?");
            }
            StringBuilder sqlpl = new StringBuilder();
            sqlpl.append(" update T_EVA_EvaResultSummary set CFPERCOEFFICIENT=(select CFCOEFFICIENT from CT_PER_PerformanceLevel where CFLEVEL=isnull(FREVISEGRADELEVEL,FGRADELEVEL)), ");
            sqlpl.append(" CFPERMAXCOEFFICIENT=(select CFMAXCOEFFICIENT from CT_PER_PerformanceLevel where CFLEVEL=isnull(FREVISEGRADELEVEL,FGRADELEVEL)), ");
            sqlpl.append(" CFPERMINCOEFFICIENT=(select CFMINCOEFFICIENT from CT_PER_PerformanceLevel where CFLEVEL=isnull(FREVISEGRADELEVEL,FGRADELEVEL)) ");
            sqlpl.append(" where FEVAPLANID =? and FPERIODID =? and fid in ( ");
            sqlpl.append((CharSequence)selsessParamId);
            sqlpl.append(" ) ");
            idsessList.add(0, planId);
            idsessList.add(1, period);
            DbUtil.execute((Context)ctx, (String)sqlpl.toString(), (Object[])idsessList.toArray());
            idList.removeAll(idsessList);
            if (idList.size() > 0) {
                EvaResultSummaryManagerListHandlerExEx.addBatchMessageTips((Collection)idList, (String)"\u5f53\u524d\u5df2\u7ecf\u5ba1\u6838\u901a\u8fc7\u83b7\u53d6\u66f4\u65b0\u5931\u8d25", (BatchMessageTipsHeader)batchMessageTipsHeader);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            EvaResultSummaryManagerListHandlerExEx.addBatchMessageTips((Collection)idList, (String)e.getMessage(), (BatchMessageTipsHeader)batchMessageTipsHeader);
        }
    }

    protected void setInitData(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, Map<String, Object> initData) throws SHRWebException {
        super.setInitData(request, response, modelMap, initData);
        Context ctx = SHRContext.getInstance().getContext();
        try {
            Map custom_params = (Map)initData.get("custom_params");
            String perfPlanId = (String)custom_params.get("perfPlanId");
            StringBuilder planSql = new StringBuilder();
            planSql.append(" select pp.fid,pp.CFPerobjectIdId,ppm.CFPROJECTNAME from T_EVA_PerfPlan pp  ");
            planSql.append(" left join CT_PRO_ProjectManagement ppm on ppm.fid = pp.CFPerobjectIdId where pp.fid=? and pp.CFPerobjectIdId is not null");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)planSql.toString(), (Object[])new Object[]{perfPlanId});
            if (rs.next()) {
                String perobjectId = rs.getString("CFPerobjectIdId");
                String projectName = rs.getString("CFPROJECTNAME");
                custom_params.put("projectName", projectName);
                custom_params.put("perobjectId", perobjectId);
                initData.put("perobjectId", perobjectId);
                initData.put("projectName", projectName);
            } else {
                custom_params.put("perobjectId", "");
                custom_params.put("projectName", "");
                initData.put("perobjectId", "");
                initData.put("projectName", "");
            }
            initData.put("performanceLevel", this.getPerformanceLevelByLevelAction(request, response, modelMap));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Map<String, Map<String, BigDecimal>> getProjectPerformPro(Context ctx, List<String> idList, Map<String, String> batchMessage) throws BOSException, SQLException {
        HashMap orgLevelMap;
        block5: {
            block6: {
                PerformProTeamCollection proCollection;
                block4: {
                    orgLevelMap = Maps.newHashMap();
                    proCollection = PerformProTeamFactory.getLocalInstance((Context)ctx).getPerformProTeamCollection(" where status=1 ");
                    if (proCollection.size() != 1) break block4;
                    StringBuilder orgPerSql = new StringBuilder();
                    orgPerSql.append(" select fp.fid,fpe.CFS,fpe.CFA,fpe.CFB,fpe.CFC,fpe.CFD,fpe.CFORGPERFORMTYPE ");
                    orgPerSql.append(" from CT_PF_PerformProTeam fp ");
                    orgPerSql.append(" left join CT_PF_PerformProTeamEntry fpe on fp.fid=fpe.FPARENTID ");
                    orgPerSql.append(" where fp.CFSTATUS = 1 ");
                    orgPerSql.append(" order by fp.FCREATETIME ");
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)orgPerSql.toString());
                    while (rs.next()) {
                        HashMap objectMap = Maps.newHashMap();
                        String type = rs.getString("CFORGPERFORMTYPE");
                        objectMap.put("S", rs.getBigDecimal("CFS"));
                        objectMap.put("A", rs.getBigDecimal("CFA"));
                        objectMap.put("B", rs.getBigDecimal("CFB"));
                        objectMap.put("C", rs.getBigDecimal("CFC"));
                        objectMap.put("D", rs.getBigDecimal("CFD"));
                        orgLevelMap.put(type, objectMap);
                    }
                    break block5;
                }
                if (proCollection.size() <= 1) break block6;
                if (null == batchMessage || null == idList) break block5;
                for (String key : idList) {
                    batchMessage.put(key, "\u5b58\u5728\u591a\u4e2a\u6b63\u6001\u5206\u5e03\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
                break block5;
            }
            if (null != batchMessage && null != idList) {
                for (String key : idList) {
                    batchMessage.put(key, "\u4e0d\u5b58\u5728\u6b63\u6001\u5206\u5e03\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
            }
        }
        return orgLevelMap;
    }

    public Map<String, Map<String, String>> getProjectLevelCountMap(Context ctx, String period, String planId, StringBuilder selParamId) throws BOSException, SQLException {
        StringBuilder orgSql = new StringBuilder();
        orgSql.append(" select pp.CFPerobjectIdId, ers.FPERIODID,ers.FEVAPLANID,count(*) alls from T_EVA_EvaResultSummary ers ");
        orgSql.append(" left join T_EVA_PerfPlan pp on pp.fid=ers.FEVAPLANID ");
        orgSql.append(" where FPERIODID=? and FEVAPLANID=? ");
        orgSql.append(" group by pp.CFPerobjectIdId, ers.FPERIODID, ers.FEVAPLANID ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)orgSql.toString(), (Object[])new String[]{period, planId});
        HashMap orgLevelMap = Maps.newHashMap();
        while (rs.next()) {
            HashMap map = Maps.newHashMap();
            String CFPerobjectIdId = rs.getString("CFPerobjectIdId");
            String FPERIODID = rs.getString("FPERIODID");
            String FEVAPLANID = rs.getString("FEVAPLANID");
            String key = CFPerobjectIdId + FPERIODID + FEVAPLANID;
            map.put("CFPerobjectIdId", CFPerobjectIdId);
            map.put("FPERIODID", FPERIODID);
            map.put("FEVAPLANID", FEVAPLANID);
            map.put("alls", rs.getString("alls"));
            orgLevelMap.put(key, map);
        }
        return orgLevelMap;
    }

    public Map<String, Map<String, String>> getPersonProjectLevelLensMap(Context ctx, String period, String planId, StringBuilder selParamId, List<String> idList) throws BOSException, SQLException {
        HashMap personLevelMap = Maps.newHashMap();
        StringBuilder orgLevelSql = new StringBuilder();
        orgLevelSql.append(" select count(*) lens,FPERIODID,FEVAPLANID,revLevel from ( ");
        orgLevelSql.append(" select pp.CFPerobjectIdId,s1.FPERIODID,s1.FEVAPLANID,isnull(s1.FREVISEGRADELEVEL,s1.FGRADELEVEL) revLevel ");
        orgLevelSql.append(" from T_EVA_EvaResultSummary s1 ");
        orgLevelSql.append(" left join T_EVA_PerfPlan pp on pp.fid=s1.FEVAPLANID ");
        orgLevelSql.append(" where s1.FPERIODID=? and s1.FEVAPLANID=?  and s1.fid in (");
        orgLevelSql.append((CharSequence)selParamId);
        orgLevelSql.append(") ");
        orgLevelSql.append(" ) t ");
        orgLevelSql.append(" group by  FPERIODID,FEVAPLANID,revLevel ");
        ArrayList pam = Lists.newArrayList();
        pam.add(period);
        pam.add(planId);
        pam.addAll(idList);
        IRowSet orgLevelRs = DbUtil.executeQuery((Context)ctx, (String)orgLevelSql.toString(), (Object[])pam.toArray());
        while (orgLevelRs.next()) {
            HashMap map = Maps.newHashMap();
            String FPERIODID = orgLevelRs.getString("FPERIODID");
            String FEVAPLANID = orgLevelRs.getString("FEVAPLANID");
            String revLevel = orgLevelRs.getString("revLevel");
            String key = FPERIODID + FEVAPLANID + revLevel;
            map.put("lens", orgLevelRs.getString("lens"));
            map.put("FPERIODID", FPERIODID);
            map.put("FEVAPLANID", FEVAPLANID);
            map.put("revLevel", orgLevelRs.getString("revLevel"));
            personLevelMap.put(key, map);
        }
        return personLevelMap;
    }

    public Map<String, String> beforeAuditProjectEvaResut(Context ctx, String period, String planId, List<String> idList) throws BOSException, SQLException {
        HashMap batchMessage = Maps.newHashMap();
        StringBuilder selParamId = new StringBuilder("''");
        for (int i = 0; i < idList.size(); ++i) {
            selParamId.append(",?");
        }
        Map<String, Map<String, BigDecimal>> personPerformMap = this.getProjectPerformPro(ctx, idList, batchMessage);
        if (null != personPerformMap && personPerformMap.size() > 0) {
            Map<String, Map<String, String>> personLevelMap = this.getPersonProjectLevelLensMap(ctx, period, planId, selParamId, idList);
            StringBuilder sel = new StringBuilder();
            sel.append(" select s1.fid,ppm.CFPROJECTNAME, pp.CFPerobjectIdId, s1.FPERIODID, s1.FEVAPLANID,");
            sel.append(" isnull(s1.FREVISEGRADELEVEL,s1.FGRADELEVEL) revLevel,s1.CFProjectLevel ");
            sel.append(" from T_EVA_EvaResultSummary s1 ");
            sel.append(" left join T_EVA_PerfPlan pp on pp.fid = s1.FEVAPLANID ");
            sel.append(" left join CT_PRO_ProjectManagement ppm on ppm.fid = pp.CFPerobjectIdId ");
            sel.append(" where s1.fid in (");
            sel.append((CharSequence)selParamId);
            sel.append(") ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sel.toString(), (Object[])idList.toArray());
            BigDecimal big100 = new BigDecimal(100);
            while (rs.next()) {
                String fid = rs.getString("fid");
                String CFPROJECTNAME = rs.getString("CFPROJECTNAME");
                String CFPerobjectIdId = rs.getString("CFPerobjectIdId");
                String FPERIODID = rs.getString("FPERIODID");
                String FEVAPLANID = rs.getString("FEVAPLANID");
                String revLevel = rs.getString("revLevel");
                if (StrUtil.isBlank((CharSequence)revLevel)) {
                    batchMessage.put(fid, "\u7ee9\u6548\u7b49\u7ea7\u4e3a\u7a7a,\u8bf7\u7ef4\u62a4\u540e\u518d\u5ba1\u6279");
                    continue;
                }
                String projectLevel = rs.getString("CFProjectLevel");
                if (StrUtil.isBlank((CharSequence)projectLevel)) {
                    String msg = String.format("%s\u9879\u76ee\u7ee9\u6548\u7b49\u7ea7\u4e3a\u7a7a", CFPROJECTNAME);
                    batchMessage.put(fid, msg);
                    continue;
                }
                Map<String, BigDecimal> personPerform = personPerformMap.get(projectLevel);
                if (null == personPerform) {
                    String msg = String.format("\u6ca1\u6709\u627e\u5230%s\u9879\u76ee\u7ee9\u6548\u7b49\u7ea7%s\u7684\u6b63\u6001\u5206\u5e03\u89c4\u5219", CFPROJECTNAME, projectLevel);
                    batchMessage.put(fid, msg);
                    continue;
                }
                HashMap leveList = Maps.newHashMap();
                String keyRevLevelD = FPERIODID + FEVAPLANID + "D";
                Map<String, String> personMapD = personLevelMap.get(keyRevLevelD);
                BigDecimal dLens = BigDecimal.ZERO;
                if (null != personMapD) {
                    dLens = new BigDecimal(personMapD.get("lens"));
                    leveList.put("D", dLens);
                }
                String keyRevLevelC = FPERIODID + FEVAPLANID + "C";
                Map<String, String> personMapC = personLevelMap.get(keyRevLevelC);
                BigDecimal cLens = BigDecimal.ZERO;
                if (null != personMapC) {
                    cLens = new BigDecimal(personMapC.get("lens"));
                    leveList.put("C", cLens);
                }
                String keyRevLevelB = FPERIODID + FEVAPLANID + "B";
                Map<String, String> personMapB = personLevelMap.get(keyRevLevelB);
                BigDecimal bLens = BigDecimal.ZERO;
                if (null != personMapB) {
                    bLens = new BigDecimal(personMapB.get("lens"));
                    leveList.put("B", bLens);
                }
                String keyRevLevelA = FPERIODID + FEVAPLANID + "A";
                Map<String, String> personMapA = personLevelMap.get(keyRevLevelA);
                BigDecimal aLens = BigDecimal.ZERO;
                if (null != personMapA) {
                    aLens = new BigDecimal(personMapA.get("lens"));
                    leveList.put("A", aLens);
                }
                String keyRevLevelS = FPERIODID + FEVAPLANID + "S";
                Map<String, String> personMapS = personLevelMap.get(keyRevLevelS);
                BigDecimal sLens = BigDecimal.ZERO;
                if (null != personMapS) {
                    sLens = new BigDecimal(personMapS.get("lens"));
                    leveList.put("S", sLens);
                }
                BigDecimal alls = new BigDecimal(idList.size());
                BigDecimal scale = personPerform.get(revLevel);
                HashMap bigsList = Maps.newHashMap();
                BigDecimal bigS = personPerform.get("S").divide(big100, 4, 4).multiply(alls).setScale(0, 4);
                bigsList.put("S", bigS);
                BigDecimal bigA = personPerform.get("A").divide(big100, 4, 4).multiply(alls).setScale(0, 4);
                bigsList.put("A", bigA);
                BigDecimal bigB = personPerform.get("B").divide(big100, 4, 4).multiply(alls).setScale(0, 4);
                bigsList.put("B", bigB);
                BigDecimal bigC = personPerform.get("C").divide(big100, 4, 4).multiply(alls).setScale(0, 4);
                bigsList.put("C", bigC);
                BigDecimal bigD = personPerform.get("D").divide(big100, 4, 4).multiply(alls).setScale(0, 4);
                bigsList.put("D", bigD);
                BigDecimal lens = BigDecimal.ZERO;
                BigDecimal personSize = BigDecimal.ZERO;
                BigDecimal personMaxSize = BigDecimal.ZERO;
                BigDecimal personMinSize = BigDecimal.ZERO;
                BigDecimal personMaxASize = BigDecimal.ZERO;
                BigDecimal personMaxSSize = BigDecimal.ZERO;
                BigDecimal personMinCSize = BigDecimal.ZERO;
                BigDecimal personMinDSize = BigDecimal.ZERO;
                BigDecimal personMinVSize = BigDecimal.ZERO;
                ArrayList ldrs = Lists.newArrayList();
                HashMap ldrcd = Maps.newHashMap();
                switch (revLevel) {
                    case "A": {
                        personSize = personSize.add(bigA).subtract(aLens);
                        lens = lens.add(aLens);
                        personMaxSize = "A".equals(revLevel) ? personMaxSize.add(bigA) : personMaxSize.add(bigA.subtract(aLens));
                        personMaxASize = new BigDecimal(personMaxSize.toPlainString());
                        ldrs.add("A\u6700\u591a" + personMaxASize.toPlainString() + "\u4eba\uff0c");
                    }
                    case "S": {
                        personSize = personSize.add(bigS).subtract(sLens);
                        lens = lens.add(sLens);
                        personMaxSize = "S".equals(revLevel) ? personMaxSize.add(bigS) : personMaxSize.add(bigS.subtract(sLens));
                        personMaxSSize = new BigDecimal(personMaxSize.toPlainString());
                        ldrs.add("S\u6700\u591a" + personMaxSSize.toPlainString() + "\u4eba\uff0c");
                    }
                    case "B": 
                    case "C": {
                        personMinVSize = personMinVSize.add(bigC).subtract(cLens);
                        personMinSize = "C".equals(revLevel) ? personMinSize.add(bigC) : personMinSize.add(bigC.subtract(cLens));
                        personMinCSize = new BigDecimal(bigC.toPlainString());
                    }
                    case "D": {
                        personMinVSize = personMinVSize.add(bigD).subtract(dLens);
                        personMinSize = "D".equals(revLevel) ? personMinSize.add(bigD) : personMinSize.add(bigD.subtract(dLens));
                        personMinDSize = new BigDecimal(bigD.add(bigC).toPlainString());
                    }
                }
                switch (revLevel) {
                    case "A": 
                    case "S": 
                    case "B": {
                        ldrcd.put("C", "C\u6700\u5c11" + (personMinCSize.compareTo(BigDecimal.ZERO) > 0 ? personMinCSize.toPlainString() : Character.valueOf('0')) + "\u4eba\u6216\u8005D\u6700\u5c11" + (personMinDSize.compareTo(BigDecimal.ZERO) > 0 ? personMinDSize.toPlainString() : "0") + "\u4eba\uff0c");
                        break;
                    }
                    case "C": {
                        ldrcd.put("C", "C\u6700\u5c11" + (bigC.compareTo(BigDecimal.ZERO) > 0 ? bigC.toPlainString() : Character.valueOf('0')) + "\u4eba\u6216\u8005D\u6700\u5c11" + (personMinDSize.compareTo(BigDecimal.ZERO) > 0 ? personMinDSize.toPlainString() : "0") + "\u4eba\uff0c");
                        break;
                    }
                    case "D": {
                        ldrcd.put("D", "D\u6700\u5c11" + bigD + "\u4eba\uff0c");
                    }
                }
                String ld = "\u5f53\u524d\u5468\u671f\u7ee9\u6548\u7b49\u7ea7\u4e3a%l\u7684\u4eba\u6570\u4e3a%maxs\u4eba,";
                if (personMinVSize.compareTo(BigDecimal.ZERO) <= 0 && personSize.compareTo(BigDecimal.ZERO) >= 0) continue;
                if (ldrs.size() > 0) {
                    String ldrstr = (String)ldrs.get(0);
                    ld = ld + ldrstr;
                    ld = ld.replace("%" + revLevel, (personMaxSize.compareTo(BigDecimal.ZERO) > 0 ? personMaxSize : BigDecimal.ZERO).toPlainString());
                }
                ld = ld.replace("%l", revLevel);
                ld = ld.replace("%maxs", (leveList.get(revLevel) == null ? BigDecimal.ZERO : (BigDecimal)leveList.get(revLevel)).toPlainString());
                for (Map.Entry entry : ldrcd.entrySet()) {
                    String eKey = (String)entry.getKey();
                    String ldr = (String)entry.getValue();
                    ld = ld + ldr;
                }
                ld = ld + "\u8bf7\u4fee\u6b63\u540e\u91cd\u65b0\u5ba1\u6838.";
                batchMessage.put(fid, ld);
            }
        }
        return batchMessage;
    }

    public Map<String, Map<String, BigDecimal>> getPersonPerformPro(Context ctx, List<String> idList, Map<String, String> batchMessage) throws BOSException, SQLException {
        HashMap orgLevelMap;
        block5: {
            block6: {
                PersonPerformProCollection proCollection;
                block4: {
                    orgLevelMap = Maps.newHashMap();
                    proCollection = PersonPerformProFactory.getLocalInstance((Context)ctx).getPersonPerformProCollection(" where state=1 ");
                    if (proCollection.size() != 1) break block4;
                    StringBuilder orgPerSql = new StringBuilder();
                    orgPerSql.append(" select fp.fid,fpe.CFS,fpe.CFA,fpe.CFB,fpe.CFC,fpe.CFD,fpe.CFORGPERFORMTYPE ");
                    orgPerSql.append(" from CT_PF_PersonPerformPro fp ");
                    orgPerSql.append(" left join CT_PF_PersonPerformProEntry fpe on fp.fid=fpe.FPARENTID ");
                    orgPerSql.append(" where fp.CFSTATE = 1 ");
                    orgPerSql.append(" order by fp.FCREATETIME ");
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)orgPerSql.toString());
                    while (rs.next()) {
                        HashMap objectMap = Maps.newHashMap();
                        String type = rs.getString("CFORGPERFORMTYPE");
                        objectMap.put("S", rs.getBigDecimal("CFS"));
                        objectMap.put("A", rs.getBigDecimal("CFA"));
                        objectMap.put("B", rs.getBigDecimal("CFB"));
                        objectMap.put("C", rs.getBigDecimal("CFC"));
                        objectMap.put("D", rs.getBigDecimal("CFD"));
                        orgLevelMap.put(type, objectMap);
                    }
                    break block5;
                }
                if (proCollection.size() <= 1) break block6;
                if (null == batchMessage || null == idList) break block5;
                for (String key : idList) {
                    batchMessage.put(key, "\u5b58\u5728\u591a\u4e2a\u6b63\u6001\u5206\u5e03\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
                break block5;
            }
            if (null != batchMessage && null != idList) {
                for (String key : idList) {
                    batchMessage.put(key, "\u4e0d\u5b58\u5728\u6b63\u6001\u5206\u5e03\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
            }
        }
        return orgLevelMap;
    }

    public Map<String, Map<String, String>> getOrgLevelCountMap(Context ctx, String period, String planId) throws BOSException, SQLException {
        StringBuilder orgSql = new StringBuilder();
        orgSql.append(" select  FADMINORGUNITID, FPERIODID, FEVAPLANID,count( *) alls from ( ");
        orgSql.append("  select  ( ");
        orgSql.append("     select top 1 adcount.fid from T_ORG_Admin child ");
        orgSql.append("     left join T_ORG_Admin adcount on (charindex(concat(adcount.flongnumber,'!'),child.flongnumber) = 1 or adcount.flongnumber = child.flongnumber) ");
        orgSql.append("     where child.fid=ers.FADMINORGUNITID ");
        orgSql.append("     and adcount.FLAYERTYPEID='00000000-0000-0000-0000-00000000000362824988' ");
        orgSql.append("     order by adcount.fsortcode) FADMINORGUNITID, ");
        orgSql.append("  ers.FPERIODID,ers.FEVAPLANID from T_EVA_EvaResultSummary ers ");
        orgSql.append(" where ers.FPERIODID=? and ers.FEVAPLANID=? ");
        orgSql.append(" ) t ");
        orgSql.append(" group by FADMINORGUNITID, FPERIODID, FEVAPLANID ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)orgSql.toString(), (Object[])new String[]{period, planId});
        HashMap orgLevelMap = Maps.newHashMap();
        while (rs.next()) {
            HashMap map = Maps.newHashMap();
            String FADMINORGUNITID = rs.getString("FADMINORGUNITID");
            String FPERIODID = rs.getString("FPERIODID");
            String FEVAPLANID = rs.getString("FEVAPLANID");
            String key = FADMINORGUNITID + FPERIODID + FEVAPLANID;
            map.put("FADMINORGUNITID", FADMINORGUNITID);
            map.put("FPERIODID", FPERIODID);
            map.put("FEVAPLANID", FEVAPLANID);
            map.put("alls", rs.getString("alls"));
            orgLevelMap.put(key, map);
        }
        return orgLevelMap;
    }

    public Map<String, Map<String, String>> getPersonLevelLensMap(Context ctx, String period, String planId, StringBuilder selParamId, List<String> idList) throws BOSException, SQLException {
        HashMap personLevelMap = Maps.newHashMap();
        StringBuilder orgLevelSql = new StringBuilder();
        orgLevelSql.append(" select count(*) lens, ");
        orgLevelSql.append(" FPERIODID,FEVAPLANID,revLevel from ( ");
        orgLevelSql.append("     select ");
        orgLevelSql.append("       s1.FPERIODID,s1.FEVAPLANID,isnull(s1.FREVISEGRADELEVEL,s1.FGRADELEVEL) revLevel  ");
        orgLevelSql.append("     from T_EVA_EvaResultSummary s1 ");
        orgLevelSql.append("  where  s1.FPERIODID=? and s1.FEVAPLANID=? and s1.fid in (");
        orgLevelSql.append((CharSequence)selParamId);
        orgLevelSql.append(") ");
        orgLevelSql.append(" ) t ");
        orgLevelSql.append(" group by  ");
        orgLevelSql.append(" FPERIODID,FEVAPLANID,revLevel ");
        ArrayList pam = Lists.newArrayList();
        pam.add(period);
        pam.add(planId);
        pam.addAll(idList);
        IRowSet orgLevelRs = DbUtil.executeQuery((Context)ctx, (String)orgLevelSql.toString(), (Object[])pam.toArray());
        while (orgLevelRs.next()) {
            HashMap map = Maps.newHashMap();
            String FPERIODID = orgLevelRs.getString("FPERIODID");
            String FEVAPLANID = orgLevelRs.getString("FEVAPLANID");
            String revLevel = orgLevelRs.getString("revLevel");
            String key = FPERIODID + FEVAPLANID + revLevel;
            map.put("lens", orgLevelRs.getString("lens"));
            map.put("FPERIODID", FPERIODID);
            map.put("FEVAPLANID", FEVAPLANID);
            map.put("revLevel", orgLevelRs.getString("revLevel"));
            personLevelMap.put(key, map);
        }
        return personLevelMap;
    }

    public void beforeAuditEvaResutAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, BatchMessageTipsHeader batchMessageTipsHeader) throws SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        String ids = (String)request.getAttribute("billId");
        String period = request.getParameter("period");
        String planId = request.getParameter("planId");
        if (ids == null) {
            throw new ShrWebBizException((Throwable)new SHRPerfWebBizException(SHRPerfWebBizException.SYSTEMERR));
        }
        BatchMessageTipsHeader batch = this.verifyToDep(request, response, modelMap);
        if (batch.getFailureCount() <= 0 && batch.getSuccessCount() > 0) {
            try {
                ArrayList idList = Lists.newArrayList();
                HashSet idSet = Sets.newHashSet((Iterable)idList);
                for (String id : ids.split(",")) {
                    idList.add(id);
                }
                StringBuilder planSql = new StringBuilder();
                planSql.append("select fid,CFPerobjectIdId from T_EVA_PerfPlan where fid=? and CFPerobjectIdId is not null ");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)planSql.toString(), (Object[])new Object[]{planId});
                if (rs.next()) {
                    String CFPerobjectIdId = rs.getString("CFPerobjectIdId");
                    Map<String, String> batchMessage = this.beforeAuditProjectEvaResut(ctx, period, planId, idList);
                    if (null != batchMessage && batchMessage.size() > 0) {
                        for (Map.Entry<String, String> entry : batchMessage.entrySet()) {
                            EvaResultSummaryManagerListHandlerExEx.addBatchMessageTip((String)entry.getKey(), (String)entry.getValue(), (BatchMessageTipsHeader)batchMessageTipsHeader);
                            idSet.remove(entry.getKey());
                        }
                    }
                } else {
                    Map<String, String> batchMessage = this.beforeAuditEvaResut(ctx, period, planId, idList);
                    if (null != batchMessage && batchMessage.size() > 0) {
                        for (Map.Entry<String, String> entry : batchMessage.entrySet()) {
                            EvaResultSummaryManagerListHandlerExEx.addBatchMessageTip((String)entry.getKey(), (String)entry.getValue(), (BatchMessageTipsHeader)batchMessageTipsHeader);
                            idSet.remove(entry.getKey());
                        }
                    }
                }
                this.setSuccessMessage("\u9a8c\u8bc1\u6210\u529f");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ShrWebBizException((Throwable)e);
            }
        }
        batchMessageTipsHeader.setBillId(batch.getBillId());
        batchMessageTipsHeader.setFailureCount(batch.getFailureCount());
        batchMessageTipsHeader.setSuccessCount(batch.getSuccessCount());
        batchMessageTipsHeader.setResult(batch.getResult());
    }

    public Map<String, String> beforeAuditEvaResut(Context ctx, String period, String planId, List<String> idList) throws BOSException, SQLException {
        HashMap batchMessage = Maps.newHashMap();
        StringBuilder selParamId = new StringBuilder("''");
        for (int i = 0; i < idList.size(); ++i) {
            selParamId.append(",?");
        }
        Map<String, Map<String, BigDecimal>> personPerformMap = this.getPersonPerformPro(ctx, idList, batchMessage);
        if (null != personPerformMap && personPerformMap.size() > 0) {
            Map<String, Map<String, String>> personLevelMap = this.getPersonLevelLensMap(ctx, period, planId, selParamId, idList);
            StringBuilder sel = new StringBuilder();
            sel.append(" select ers.fid,ers.FADMINORGNAME,  ");
            sel.append("  ers.FPERIODID, ers.FEVAPLANID,isnull(ers.FREVISEGRADELEVEL, ers.FGRADELEVEL) revLevel,ers.CFOrgLevel  ");
            sel.append(" from T_EVA_EvaResultSummary ers where ers.fid in (");
            sel.append((CharSequence)selParamId);
            sel.append(") ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sel.toString(), (Object[])idList.toArray());
            BigDecimal big100 = new BigDecimal(100);
            while (rs.next()) {
                String fid = rs.getString("fid");
                String FADMINORGNAME = rs.getString("FADMINORGNAME");
                String FPERIODID = rs.getString("FPERIODID");
                String FEVAPLANID = rs.getString("FEVAPLANID");
                String revLevel = rs.getString("revLevel");
                if (StrUtil.isBlank((CharSequence)revLevel)) {
                    batchMessage.put(fid, "\u7ee9\u6548\u7b49\u7ea7\u4e3a\u7a7a,\u8bf7\u7ef4\u62a4\u540e\u518d\u5ba1\u6279");
                    continue;
                }
                String orgLevel = rs.getString("CFOrgLevel");
                if (null == orgLevel) {
                    String msg = String.format("%s\u4e0a\u5b63\u5ea6\u7ec4\u7ec7\u7ee9\u6548\u7b49\u7ea7\u4e3a\u7a7a", FADMINORGNAME);
                    batchMessage.put(fid, msg);
                    continue;
                }
                Map<String, BigDecimal> personPerform = personPerformMap.get(orgLevel);
                if (null == personPerform) {
                    String msg = String.format("\u6ca1\u6709\u627e\u5230%s\u4e0a\u5b63\u5ea6\u7ec4\u7ec7\u7ee9\u6548\u7b49\u7ea7%s\u7684\u6b63\u6001\u5206\u5e03\u89c4\u5219", FADMINORGNAME, orgLevel);
                    batchMessage.put(fid, msg);
                    continue;
                }
                HashMap leveList = Maps.newHashMap();
                String keyRevLevelD = FPERIODID + FEVAPLANID + "D";
                Map<String, String> personMapD = personLevelMap.get(keyRevLevelD);
                BigDecimal dLens = BigDecimal.ZERO;
                if (null != personMapD) {
                    dLens = new BigDecimal(personMapD.get("lens"));
                    leveList.put("D", dLens);
                }
                String keyRevLevelC = FPERIODID + FEVAPLANID + "C";
                Map<String, String> personMapC = personLevelMap.get(keyRevLevelC);
                BigDecimal cLens = BigDecimal.ZERO;
                if (null != personMapC) {
                    cLens = new BigDecimal(personMapC.get("lens"));
                    leveList.put("C", cLens);
                }
                String keyRevLevelB = FPERIODID + FEVAPLANID + "B";
                Map<String, String> personMapB = personLevelMap.get(keyRevLevelB);
                BigDecimal bLens = BigDecimal.ZERO;
                if (null != personMapB) {
                    bLens = new BigDecimal(personMapB.get("lens"));
                    leveList.put("B", bLens);
                }
                String keyRevLevelA = FPERIODID + FEVAPLANID + "A";
                Map<String, String> personMapA = personLevelMap.get(keyRevLevelA);
                BigDecimal aLens = BigDecimal.ZERO;
                if (null != personMapA) {
                    aLens = new BigDecimal(personMapA.get("lens"));
                    leveList.put("A", aLens);
                }
                String keyRevLevelS = FPERIODID + FEVAPLANID + "S";
                Map<String, String> personMapS = personLevelMap.get(keyRevLevelS);
                BigDecimal sLens = BigDecimal.ZERO;
                if (null != personMapS) {
                    sLens = new BigDecimal(personMapS.get("lens"));
                    leveList.put("S", sLens);
                }
                BigDecimal alls = new BigDecimal(idList.size());
                BigDecimal scale = personPerform.get(revLevel);
                HashMap bigsList = Maps.newHashMap();
                BigDecimal bigS = personPerform.get("S").divide(big100, 4, 4).multiply(alls).setScale(0, 4);
                bigsList.put("S", bigS);
                BigDecimal bigA = personPerform.get("A").divide(big100, 4, 4).multiply(alls).setScale(0, 4);
                bigsList.put("A", bigA);
                BigDecimal bigB = personPerform.get("B").divide(big100, 4, 4).multiply(alls).setScale(0, 4);
                bigsList.put("B", bigB);
                BigDecimal bigC = personPerform.get("C").divide(big100, 4, 4).multiply(alls).setScale(0, 4);
                bigsList.put("C", bigC);
                BigDecimal bigD = personPerform.get("D").divide(big100, 4, 4).multiply(alls).setScale(0, 4);
                bigsList.put("D", bigD);
                BigDecimal lens = BigDecimal.ZERO;
                BigDecimal personSize = BigDecimal.ZERO;
                BigDecimal personMaxSize = BigDecimal.ZERO;
                BigDecimal personMinSize = BigDecimal.ZERO;
                BigDecimal personMaxASize = BigDecimal.ZERO;
                BigDecimal personMaxSSize = BigDecimal.ZERO;
                BigDecimal personMinCSize = BigDecimal.ZERO;
                BigDecimal personMinDSize = BigDecimal.ZERO;
                BigDecimal personMinVSize = BigDecimal.ZERO;
                ArrayList ldrs = Lists.newArrayList();
                HashMap ldrcd = Maps.newHashMap();
                switch (revLevel) {
                    case "A": {
                        personSize = personSize.add(bigA).subtract(aLens);
                        lens = lens.add(aLens);
                        personMaxSize = "A".equals(revLevel) ? personMaxSize.add(bigA) : personMaxSize.add(bigA.subtract(aLens));
                        personMaxASize = new BigDecimal(personMaxSize.toPlainString());
                        ldrs.add("A\u6700\u591a" + personMaxASize.toPlainString() + "\u4eba\uff0c");
                    }
                    case "S": {
                        personSize = personSize.add(bigS).subtract(sLens);
                        lens = lens.add(sLens);
                        personMaxSize = "S".equals(revLevel) ? personMaxSize.add(bigS) : personMaxSize.add(bigS.subtract(sLens));
                        personMaxSSize = new BigDecimal(personMaxSize.toPlainString());
                        ldrs.add("S\u6700\u591a" + personMaxSSize.toPlainString() + "\u4eba\uff0c");
                    }
                    case "B": 
                    case "C": {
                        personMinVSize = personMinVSize.add(bigC).subtract(cLens);
                        personMinSize = "C".equals(revLevel) ? personMinSize.add(bigC) : personMinSize.add(bigC.subtract(cLens));
                        personMinCSize = new BigDecimal(bigC.toPlainString());
                    }
                    case "D": {
                        personMinVSize = personMinVSize.add(bigD).subtract(dLens);
                        personMinSize = "D".equals(revLevel) ? personMinSize.add(bigD) : personMinSize.add(bigD.subtract(dLens));
                        personMinDSize = new BigDecimal(bigD.add(bigC).toPlainString());
                    }
                }
                switch (revLevel) {
                    case "A": 
                    case "S": 
                    case "B": {
                        ldrcd.put("C", "C\u6700\u5c11" + (personMinCSize.compareTo(BigDecimal.ZERO) > 0 ? personMinCSize.toPlainString() : Character.valueOf('0')) + "\u4eba\u6216\u8005D\u6700\u5c11" + (personMinDSize.compareTo(BigDecimal.ZERO) > 0 ? personMinDSize.toPlainString() : "0") + "\u4eba\uff0c");
                        break;
                    }
                    case "C": {
                        ldrcd.put("C", "C\u6700\u5c11" + (bigC.compareTo(BigDecimal.ZERO) > 0 ? bigC.toPlainString() : Character.valueOf('0')) + "\u4eba\u6216\u8005D\u6700\u5c11" + (personMinDSize.compareTo(BigDecimal.ZERO) > 0 ? personMinDSize.toPlainString() : "0") + "\u4eba\uff0c");
                        break;
                    }
                    case "D": {
                        ldrcd.put("D", "D\u6700\u5c11" + bigD + "\u4eba\uff0c");
                    }
                }
                String ld = "\u5f53\u524d\u5468\u671f\u7ee9\u6548\u7b49\u7ea7\u4e3a%l\u7684\u4eba\u6570\u4e3a%maxs\u4eba,";
                if (personMinVSize.compareTo(BigDecimal.ZERO) <= 0 && personSize.compareTo(BigDecimal.ZERO) >= 0) continue;
                if (ldrs.size() > 0) {
                    String ldrstr = (String)ldrs.get(0);
                    ld = ld + ldrstr;
                    ld = ld.replace("%" + revLevel, (personMaxSize.compareTo(BigDecimal.ZERO) > 0 ? personMaxSize : BigDecimal.ZERO).toPlainString());
                }
                ld = ld.replace("%l", revLevel);
                ld = ld.replace("%maxs", (leveList.get(revLevel) == null ? BigDecimal.ZERO : (BigDecimal)leveList.get(revLevel)).toPlainString());
                for (Map.Entry entry : ldrcd.entrySet()) {
                    String eKey = (String)entry.getKey();
                    String ldr = (String)entry.getValue();
                    ld = ld + ldr;
                }
                ld = ld + "\u8bf7\u4fee\u6b63\u540e\u91cd\u65b0\u5ba1\u6838.";
                batchMessage.put(fid, ld);
            }
        }
        return batchMessage;
    }

    public void auditEvaResutAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, BatchMessageTipsHeader batchMessageTipsHeader) throws SHRWebException {
        super.auditEvaResutAction(request, response, modelMap, batchMessageTipsHeader);
    }

    public void bindDep_OR_ProjectBatchAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, BatchMessageTipsHeader batchMessageTipsHeader) throws SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        String ids = (String)request.getAttribute("billId");
        String period = request.getParameter("period");
        String planId = request.getParameter("planId");
        if (ids == null) {
            throw new ShrWebBizException((Throwable)new SHRPerfWebBizException(SHRPerfWebBizException.SYSTEMERR));
        }
        try {
            StringBuilder planSql = new StringBuilder();
            planSql.append("select fid,CFPerobjectIdId from T_EVA_PerfPlan where fid=? and CFPerobjectIdId is not null ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)planSql.toString(), (Object[])new Object[]{planId});
            if (rs.next()) {
                this.bindProjectBatchAction(request, response, modelMap, batchMessageTipsHeader);
            } else {
                this.bindDepBatchAction(request, response, modelMap, batchMessageTipsHeader);
            }
            this.setSuccessMessage("\u9a8c\u8bc1\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ShrWebBizException((Throwable)e);
        }
    }

    public void bindWholeCommentAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        try {
            Object obj = MSFServiceFacadeFactory.getLocalInstance((Context)ctx).processService("wholeComment", new HashMap());
            this.setSuccessMessage("\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ShrWebBizException((Throwable)e);
        }
    }

    public void bindProjectBatchAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, BatchMessageTipsHeader batchMessageTipsHeader) throws SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        String ids = (String)request.getAttribute("billId");
        if (ids == null) {
            throw new ShrWebBizException((Throwable)new SHRPerfWebBizException(SHRPerfWebBizException.SYSTEMERR));
        }
        try {
            ArrayList idList = Lists.newArrayList();
            for (String id : ids.split(",")) {
                idList.add(id);
            }
            HashSet idSet = Sets.newHashSet((Iterable)idList);
            Map<String, String> map = this.bindProject(ctx, ids);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                EvaResultSummaryManagerListHandlerExEx.addBatchMessageTip((String)entry.getKey(), (String)entry.getValue(), (BatchMessageTipsHeader)batchMessageTipsHeader);
                idSet.remove(entry.getKey());
            }
            this.setSuccessMessage("\u9a8c\u8bc1\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ShrWebBizException((Throwable)e);
        }
    }

    public Map<String, String> bindProject(Context ctx, String ids) throws Exception {
        HashMap batchMessage = Maps.newHashMap();
        ArrayList idList = Lists.newArrayList();
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        if (ids == null) {
            throw new Exception((Throwable)new SHRPerfWebBizException(SHRPerfWebBizException.SYSTEMERR));
        }
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" select ers.fid,pp.FPSTARTDATE,ers.FBILLSTATE,ers.FADMINORGUNITID,ers.FADMINORGNAME,pp.FYEAR,pp.FTIMEPERIOD, ");
            sql.append(" pp.FCYCLETYPE,pp.FPENDDATE,pp.FPSTARTDATE,ppn.CFPEROBJECTIDID,ppm.CFPROJECTNAME,pmm.CFEMPLOYEEID ");
            sql.append(" from T_EVA_EvaResultSummary ers ");
            sql.append(" left join T_EVA_PerfPlan ppn on ers.FEVAPLANID=ppn.fid ");
            sql.append(" left join T_EVA_PerfPeriod pp on ers.FPERIODID=pp.fid ");
            sql.append(" left join CT_PRO_ProjectManagement ppm on ppn.CFPEROBJECTIDID=ppm.fid ");
            sql.append(" left join CT_PRO_MemberManagement pmm on ppm.fid=pmm.CFPROJECTMANAGEMENID and pmm.CFSTATE=1 ");
            sql.append(" and pmm.CFPTYPEID in( ");
            sql.append(" select fid from CT_PRO_ProjectType where FNUMBER='ProjectManager') ");
            sql.append(" and pmm.CFPROJECTROLEID in( ");
            sql.append(" select fid from CT_PRO_ProjectRole where FNUMBER ='HTY110') ");
            sql.append(" where pmm.CFEMPLOYEEID is not null and ers.fid in(''");
            for (String id : ids.split(",")) {
                idList.add(id);
                sql.append(",'").append(id).append("'");
            }
            sql.append(" ) ");
            IRowSet rsSql = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            ArrayList sess = Lists.newArrayList();
            while (rsSql.next()) {
                String id = rsSql.getString("fid");
                String personid = rsSql.getString("CFEMPLOYEEID");
                String CFPROJECTNAME = rsSql.getString("CFPROJECTNAME");
                String perobjectid = rsSql.getString("CFPEROBJECTIDID");
                String FBILLSTATE = rsSql.getString("FBILLSTATE");
                if (!"3".equals(FBILLSTATE)) {
                    StringBuffer sqlPro = new StringBuffer();
                    sqlPro.append(" select isnull(ers.FREVISEGRADELEVEL,ers.FGRADELEVEL) FGRADELEVEL,ers.fid from ");
                    sqlPro.append(" T_EVA_EvaResultSummary ers ");
                    sqlPro.append(" left join T_EVA_PerfPlan ppn on ers.FEVAPLANID=ppn.fid ");
                    sqlPro.append(" left join T_EVA_PerfPeriod pp on ers.FPERIODID=pp.fid ");
                    sqlPro.append(" where ers.FBILLSTATE='3' and ers.FPERSONID=? and ppn.CFPEROBJECTIDID=? ");
                    sqlPro.append(" order by pp.FPENDDATE desc ");
                    IRowSet rsPro = DbUtil.executeQuery((Context)ctx, (String)sqlPro.toString(), (Object[])new String[]{personid, perobjectid});
                    String FGRADELEVEL = "";
                    if (rsPro.next()) {
                        FGRADELEVEL = rsPro.getString("FGRADELEVEL");
                    }
                    if (StringUtils.isEmpty((String)FGRADELEVEL)) {
                        batchMessage.put(id, "\u672a\u627e\u5230\u5f53\u524d" + CFPROJECTNAME + "\u9879\u76ee\u5339\u914d\u7684\u7ee9\u6548\u7b49\u7ea7");
                        continue;
                    }
                    StringBuilder upd = new StringBuilder();
                    upd.append("update T_EVA_EvaResultSummary set CFPROJECTLEVEL=? where fid=? ");
                    DbUtil.execute((Context)ctx, (String)upd.toString(), (Object[])new String[]{FGRADELEVEL, id});
                    sess.add(id);
                    continue;
                }
                batchMessage.put(id, "\u5f53\u524d\u5df2\u7ecf\u5ba1\u6838\u901a\u8fc7\u83b7\u53d6\u66f4\u65b0\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e);
        }
        return batchMessage;
    }

    public void bindDepBatchAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, BatchMessageTipsHeader batchMessageTipsHeader) throws SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        String ids = (String)request.getAttribute("billId");
        if (ids == null) {
            throw new ShrWebBizException((Throwable)new SHRPerfWebBizException(SHRPerfWebBizException.SYSTEMERR));
        }
        try {
            ArrayList idList = Lists.newArrayList();
            for (String id : ids.split(",")) {
                idList.add(id);
            }
            HashSet idSet = Sets.newHashSet((Iterable)idList);
            Map<String, String> map = this.bindDep(ctx, ids);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                EvaResultSummaryManagerListHandlerExEx.addBatchMessageTip((String)entry.getKey(), (String)entry.getValue(), (BatchMessageTipsHeader)batchMessageTipsHeader);
                idSet.remove(entry.getKey());
            }
            this.setSuccessMessage("\u9a8c\u8bc1\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ShrWebBizException((Throwable)e);
        }
    }

    public Map<String, String> bindDep(Context ctx, String ids) throws Exception {
        HashMap batchMessage = Maps.newHashMap();
        ArrayList idList = Lists.newArrayList();
        HashMap id_orgIdMap = Maps.newHashMap();
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        if (ids == null) {
            throw new Exception((Throwable)new SHRPerfWebBizException(SHRPerfWebBizException.SYSTEMERR));
        }
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" select ers.fid,pp.FPSTARTDATE, ers.FBILLSTATE, ");
            sql.append(" (select top 1 adcount.fid from T_ORG_Admin child   ");
            sql.append(" left join T_ORG_Admin adcount on (charindex(concat(adcount.flongnumber,'!'),child.flongnumber) = 1 or adcount.flongnumber = child.flongnumber) ");
            sql.append(" where child.fid=ers.FADMINORGUNITID  ");
            sql.append(" and adcount.FLAYERTYPEID='00000000-0000-0000-0000-00000000000362824988' ");
            sql.append(" order by adcount.fsortcode)  FADMINORGUNITID ");
            sql.append(" ,ers.FADMINORGNAME,pp.FYEAR,pp.FTIMEPERIOD, ");
            sql.append(" pp.FCYCLETYPE,pp.FPENDDATE,pp.FPSTARTDATE from ");
            sql.append(" T_EVA_EvaResultSummary ers ");
            sql.append(" left join T_EVA_PerfPeriod pp on ers.FPERIODID=pp.fid ");
            sql.append(" where ers.fid in(''");
            for (String id : ids.split(",")) {
                idList.add(id);
                sql.append(",'").append(id).append("'");
            }
            sql.append(" ) ");
            IRowSet rsSql = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            boolean faist = true;
            Map<String, Object> cycleMap = null;
            Map<String, Object> cycleMap2 = null;
            while (rsSql.next()) {
                String orgName;
                String id = rsSql.getString("fid");
                String orgId = rsSql.getString("FADMINORGUNITID");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select fname_l2 from t_org_admin where fid='" + orgId + "'"));
                String orgName_l2 = orgName = rsSql.getString("FADMINORGNAME");
                if (rs.next()) {
                    orgName_l2 = rs.getString("fname_l2");
                }
                String FBILLSTATE = rsSql.getString("FBILLSTATE");
                if (faist) {
                    faist = false;
                    int FCYCLETYPE = rsSql.getInt("FCYCLETYPE");
                    Date FPENDDATE = rsSql.getDate("FPENDDATE");
                    Date FPSTARTDATE = rsSql.getDate("FPSTARTDATE");
                    cycleMap = EvaResultSummaryManagerListHandlerExEx.getCycletype(sf.format(FPSTARTDATE), sf.format(FPENDDATE), 300);
                    cycleMap2 = EvaResultSummaryManagerListHandlerExEx.getCycletype(sf.format(FPSTARTDATE), sf.format(FPENDDATE), 100);
                }
                id_orgIdMap.put(id, orgId + "!" + orgName_l2 + "!" + FBILLSTATE);
            }
            ArrayList sess = Lists.newArrayList();
            EvalplanCycleTypeEnum cycleTypeEnum = (EvalplanCycleTypeEnum)cycleMap.get("cycleType");
            LocalDate endDate = (LocalDate)cycleMap.get("endDate");
            LocalDate startDate = (LocalDate)cycleMap.get("startDate");
            int year = (Integer)cycleMap.get("year");
            int quarter = (Integer)cycleMap.get("quarter");
            EvalplanCycleTypeEnum cycleTypeEnum2 = (EvalplanCycleTypeEnum)cycleMap2.get("cycleType");
            LocalDate endDate2 = (LocalDate)cycleMap2.get("endDate");
            LocalDate startDate2 = (LocalDate)cycleMap2.get("startDate");
            int year2 = (Integer)cycleMap2.get("year");
            int quarter2 = (Integer)cycleMap2.get("quarter");
            Map<String, Map<String, String>> mapMap = this.getOrgEvaResultLevel(ctx, startDate, endDate, cycleTypeEnum, year, quarter);
            Map<String, Map<String, String>> mapMap2 = this.getOrgEvaResultLevel(ctx, startDate2, endDate2, cycleTypeEnum2, year2, quarter2);
            for (Map.Entry ee : id_orgIdMap.entrySet()) {
                String[] orgs = ((String)ee.getValue()).split("!");
                String orgId = orgs[0];
                String orgName = orgs[1];
                String FBILLSTATE = orgs[2];
                String id = (String)ee.getKey();
                if (!"3".equals(FBILLSTATE)) {
                    Map<String, String> orgLevelMap = mapMap.get(orgId);
                    if (null == orgLevelMap) {
                        orgLevelMap = mapMap2.get(orgId);
                    }
                    if (null == orgLevelMap) {
                        batchMessage.put(id, "\u672a\u627e\u5230\u5f53\u524d" + orgName + "\u90e8\u95e8\u5339\u914d\u7684\u7ec4\u7ec7\u7ee9\u6548\u7b49\u7ea7");
                        continue;
                    }
                    String orgLevel = orgLevelMap.get("lastgradeLevel");
                    StringBuilder upd = new StringBuilder();
                    upd.append("update T_EVA_EvaResultSummary set CFOrgLevel=?,CFOrgLevelEveID=? where fid=? ");
                    DbUtil.execute((Context)ctx, (String)upd.toString(), (Object[])new String[]{orgLevel, orgId, id});
                    sess.add(id);
                    continue;
                }
                batchMessage.put(id, "\u5f53\u524d\u5df2\u7ecf\u5ba1\u6838\u901a\u8fc7\u83b7\u53d6\u66f4\u65b0\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e);
        }
        return batchMessage;
    }

    public static Map<String, Object> getCycletype(String pstartdate, String penddate, int cycletype) {
        HashMap map = Maps.newHashMap();
        LocalDate startDate = LocalDate.parse(pstartdate, DateTimeFormatter.ISO_LOCAL_DATE);
        LocalDate endDate = LocalDate.parse(penddate, DateTimeFormatter.ISO_LOCAL_DATE);
        EvalplanCycleTypeEnum cycleTypeEnum = EvalplanCycleTypeEnum.getEnum((int)cycletype);
        if (100 == cycletype) {
            endDate = endDate.plusYears(-1L);
            startDate = startDate.plusYears(-1L);
            cycleTypeEnum = EvalplanCycleTypeEnum.FULL_YEAR;
            int month = startDate.getMonthValue();
            int quarter = (month - 1) / 3;
            int year = endDate.getYear();
            map.put("year", year);
            map.put("quarter", 1);
        } else if (200 == cycletype) {
            endDate = endDate.plusMonths(-6L);
            startDate = startDate.plusMonths(-6L);
            cycleTypeEnum = EvalplanCycleTypeEnum.HALF_YEAR;
            int month = startDate.getMonthValue();
            int quarter = (month - 1) / 3;
            int year = endDate.getYear();
            if (0 == quarter) {
                --year;
                quarter = 4;
            }
            map.put("year", year);
            map.put("quarter", month < 7 ? 1 : 2);
        } else if (300 == cycletype) {
            int month = startDate.getMonthValue();
            int quarter = (month - 1) / 3;
            int year = endDate.getYear();
            if (0 == quarter) {
                --year;
                quarter = 4;
            }
            Month endMonth = Month.of(quarter * 3);
            endDate = LocalDate.of(year, endMonth, endMonth.length(endDate.isLeapYear()));
            Month startMonth = Month.of(endMonth.getValue() - 2);
            startDate = LocalDate.of(year, startMonth, 1);
            cycleTypeEnum = EvalplanCycleTypeEnum.QUARTER;
            map.put("year", year);
            map.put("quarter", quarter);
        } else if (400 == cycletype) {
            endDate = endDate.plusMonths(-1L);
            startDate = startDate.plusMonths(-1L);
            cycleTypeEnum = EvalplanCycleTypeEnum.MONTHLY;
            int month = startDate.getMonthValue();
            int quarter = (month - 1) / 3;
            int year = endDate.getYear();
            if (0 == quarter) {
                --year;
                quarter = 4;
            }
            map.put("year", year);
            map.put("quarter", quarter);
        }
        map.put("cycleType", cycleTypeEnum);
        map.put("endDate", endDate);
        map.put("startDate", startDate);
        return map;
    }

    public void bindDepAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        String ids = this.getBillId(request);
        if (ids == null) {
            throw new ShrWebBizException((Throwable)new SHRPerfWebBizException(SHRPerfWebBizException.SYSTEMERR));
        }
        try {
            Map<String, String> map = this.bindDep(ctx, ids);
            this.writeSuccessData(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ShrWebBizException((Throwable)e);
        }
    }

    protected Map<String, Map<String, String>> getOrgEvaResultLevel(Context ctx, LocalDate startDate, LocalDate endDate, EvalplanCycleTypeEnum cycletype, int year, int quarter) throws BOSException, SQLException {
        String FPERIODNAME = "";
        if (EvalplanCycleTypeEnum.FULL_YEAR == cycletype) {
            FPERIODNAME = year + "M";
        } else if (EvalplanCycleTypeEnum.HALF_YEAR == cycletype) {
            FPERIODNAME = year + "0" + quarter + "H";
        } else if (EvalplanCycleTypeEnum.QUARTER == cycletype) {
            FPERIODNAME = year + "0" + quarter + "J";
        } else if (EvalplanCycleTypeEnum.MONTHLY == cycletype) {
            FPERIODNAME = year + (quarter > 9 ? "" + quarter : "0" + quarter) + "M";
        }
        return this.getOrgEvaResultLevel(ctx, startDate, endDate, cycletype, FPERIODNAME, year, quarter);
    }

    protected Map<String, Map<String, String>> getOrgEvaResultLevel(Context ctx, LocalDate startDate, LocalDate endDate) throws BOSException, SQLException {
        return this.getOrgEvaResultLevel(ctx, startDate, endDate, EvalplanCycleTypeEnum.QUARTER, "", 2000, 1);
    }

    protected Map<String, Map<String, String>> getOrgEvaResultLevel(Context ctx, LocalDate startDate, LocalDate endDate, EvalplanCycleTypeEnum cycletype, String FPERIODNAME, int year, int quarter) throws BOSException, SQLException {
        HashMap mapMap = Maps.newHashMap();
        StringBuffer selSql = new StringBuffer();
        selSql.append(" select oers.fid oersId, ");
        selSql.append(" oers.FADMINORGUNITID FADMINORGUNITID, ");
        selSql.append(" oers.FLASTGRADELEVEL,(case when ppd.fid is null ");
        selSql.append(" then (oers.FPERIODYEAR||'-01-'||'01')||'T'|| (oers.FPERIODYEAR||'-01-'||'01')  ");
        selSql.append(" else (to_char(ppd.FPSTARTDATE,'yyyy-MM-dd')||'T'||to_char(ppd.FPENDDATE,'yyyy-MM-dd')) end) PERIOD ");
        selSql.append(" from T_EVA_OrgEvaResultSummary oers ");
        selSql.append(" left join T_EVA_PerfPeriod ppd on ppd.fid = oers.FPERIODID ");
        selSql.append(" where to_char(ppd.FPSTARTDATE,'yyyy-MM-dd') >=  ?  and to_char(ppd.FPENDDATE,'yyyy-MM-dd') <=  ?  ");
        selSql.append(" and ppd.FCYCLETYPE = ? and ppd.FREFSTATUS = 100 and oers.FBILLSTATE='3' ");
        selSql.append(" and oers.FADMINORGUNITID in( ");
        selSql.append(" select adcount.fid from T_ORG_Admin child ");
        selSql.append(" left join T_ORG_Admin adcount on (charindex(concat(adcount.flongnumber,'!'),child.flongnumber) = 1 or adcount.flongnumber = child.flongnumber) ");
        selSql.append(" where child.fid=oers.FADMINORGUNITID   and adcount.FLAYERTYPEID='00000000-0000-0000-0000-00000000000362824988' ");
        selSql.append(" ) ");
        selSql.append(" UNION all ");
        selSql.append(" select fid oersId, ");
        selSql.append("         FADMINORGUNITID , ");
        selSql.append("         FLASTGRADELEVEL,(FPERIODYEAR||'-'||(FPERIODTIME*3-2)||'-'||'01')||'T'|| (FPERIODYEAR||'-'||(FPERIODTIME*3)||'-'||?)  PERIOD ");
        selSql.append(" from T_EVA_OrgEvaResultSummary where FEVAPLANNAME='\u624b\u5de5\u5f55\u5165' ");
        selSql.append(" and FADMINORGUNITID  in( ");
        selSql.append("         select adcount.fid from T_ORG_Admin child ");
        selSql.append("         left join T_ORG_Admin adcount on (charindex(concat(adcount.flongnumber,'!'),child.flongnumber) = 1 or adcount.flongnumber = child.flongnumber) ");
        selSql.append("         where child.fid=FADMINORGUNITID   and adcount.FLAYERTYPEID='00000000-0000-0000-0000-00000000000362824988' ");
        selSql.append(" ) ");
        selSql.append(" and FPERIODTIMENUMBER like ? ");
        Month endMonth = Month.of(quarter * 3);
        Year year1 = Year.of(year);
        int days = endMonth.length(year1.isLeap());
        Object[] param = new String[]{startDate.format(DateTimeFormatter.ISO_LOCAL_DATE), endDate.format(DateTimeFormatter.ISO_LOCAL_DATE), String.valueOf(cycletype.getValue()), days > 9 ? String.valueOf(days) : "0" + String.valueOf(days), FPERIODNAME + "%"};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selSql.toString(), (Object[])param);
        int i = selSql.indexOf("?");
        selSql.replace(i, i + 1, (String)param[0]);
        i = selSql.indexOf("?");
        selSql.replace(i, i + 1, (String)param[1]);
        i = selSql.indexOf("?");
        selSql.replace(i, i + 1, (String)param[2]);
        i = selSql.indexOf("?");
        selSql.replace(i, i + 1, (String)param[3]);
        i = selSql.indexOf("?");
        selSql.replace(i, i + 1, (String)param[4]);
        System.out.println(selSql);
        while (rs.next()) {
            HashMap stringMap = Maps.newHashMap();
            String orgId = rs.getString("FADMINORGUNITID");
            String lastgradeLevel = rs.getString("FLASTGRADELEVEL");
            String period = rs.getString("PERIOD");
            stringMap.put("orgId", orgId);
            stringMap.put("lastgradeLevel", lastgradeLevel);
            stringMap.put("period", period);
            mapMap.put(orgId, stringMap);
        }
        return mapMap;
    }

    public static void main(String[] args) {
        ArrayList<String> idList = new ArrayList<String>();
        idList.add("W");
        idList.add("A");
        idList.add("C");
        idList.add("B");
        idList.add("D");
        idList.add("S");
        System.out.println(idList);
        Collections.sort(idList);
        System.out.println(idList);
        BigDecimal personSize = BigDecimal.ZERO;
        ArrayList bigsList = Lists.newArrayList();
        BigDecimal bigD = BigDecimal.valueOf(1L);
        bigsList.add(bigD);
        BigDecimal bigC = BigDecimal.valueOf(1L);
        bigsList.add(bigC);
        BigDecimal bigB = BigDecimal.valueOf(1L);
        bigsList.add(bigB);
        BigDecimal bigA = BigDecimal.valueOf(1L);
        bigsList.add(bigA);
        BigDecimal bigS = BigDecimal.valueOf(1L);
        bigsList.add(bigS);
        String ld = "S\u6700\u591a%s\u4eba\uff0cA\u6700\u591a%s\u4eba\uff0cB\u6700\u591a%s\u4eba\uff0cC\u6700\u591a%s\u4eba\uff0cD\u6700\u591a%s\u4eba\uff0c";
        ArrayList ldrs = Lists.newArrayList();
        ArrayList bigs = Lists.newArrayList();
        switch ("B") {
            case "D": {
                personSize = personSize.add(bigD);
                ldrs.add("D\u6700\u591a%s\u4eba\uff0c");
                bigsList.remove(bigD);
            }
            case "C": {
                personSize = personSize.add(bigC);
                ldrs.add("C\u6700\u591a%s\u4eba\uff0c");
                bigsList.remove(bigC);
            }
            case "B": {
                personSize = personSize.add(bigB);
                ldrs.add("B\u6700\u591a%s\u4eba\uff0c");
                bigsList.remove(bigB);
            }
            case "A": {
                personSize = personSize.add(bigA);
                ldrs.add("A\u6700\u591a%s\u4eba\uff0c");
                bigsList.remove(bigA);
            }
            case "S": {
                personSize = personSize.add(bigS);
                ldrs.add("S\u6700\u591a%s\u4eba\uff0c");
                bigsList.remove(bigS);
            }
        }
        System.out.println(personSize);
        System.out.println(ldrs);
        ldrs.remove(0);
        for (String ldr : ldrs) {
            ld = ld.replace(ldr, "");
        }
        System.out.println(ld);
        System.out.println(bigs);
        System.out.println(bigsList);
        HashMap map = Maps.newHashMap();
        String pstartdate = "2024-10-01";
        String penddate = "2024-10-31";
        int cycletype = 300;
        System.out.println(EvaResultSummaryManagerListHandlerExEx.getCycletype(pstartdate, penddate, cycletype));
        String strs = "[{\"evaResult.pnumber\":\"0000381\",\"evaResult.pname\":\"\u8c2d\u6893\u50b2\",\"evaResult.positionName\":\"\u7269\u8d44\u5c97\",\"evaResult.evaObj.perfFile.adminOrgUnit.company.name\":\"\u6e56\u5357\u7ea2\u592a\u9633\u5149\u7535\u79d1\u6280\u6709\u9650\u516c\u53f8\",\"evaResult.evaObj.perfFile.adminOrgUnit.department.name\":\"\u7efc\u5408\u7ba1\u7406\",\"evaResult.sumScore\":\"<span></span>\",\"evaResult.gradeLevel\":\"\",\"evaResult.auditSumScore\":\"<span value=\\\\\"86\\\\\">86.00</span>\",\"evaResult.auditGradeLevel\":\"C\",\"evaResult.auditReason\":\"<div class=\\\\\"cell-height scrollbarthin\\\\\">\u6b63\u6001\u5206\u5e03\u66f4\u65b0\u7ed3\u679c</div>\",\"evaResult.reviseSumScore\":\"<span value=\\\\\"86\\\\\">86.00</span>\", \"evaResult.reviseGradeLevel\":\"C\",\"evaResult.reviseReason\":\"\u6b63\u6001\u5206\u5e03\u66f4\u65b0\u7ed3\u679c\", \"id\":\"KQukJy27Skiy1rPPghjkJBdK16Q=\",\"evaResult.id\":\"Ka7FkRQuTAaPlTaLvJSD3IESG3Q=\",\"bill.id\":\"m85zTeeDSmaAU2QLbYWMUoZLdW4=\",\"evaResult.evaObj.id\":\"gjX3giS2RKurkJVjPhnwa4GI54s=\",\"reviseGradeLevelSelect\":\"[{\\\\\"value\\\\\":\\\\\"S\\\\\",\\\\\"alias\\\\\":\\\\\"S\\\\\"},{\\\\\"value\\\\\":\\\\\"A\\\\\",\\\\\"alias\\\\\":\\\\\"A\\\\\"},{\\\\\"value\\\\\":\\\\\"B\\\\\",\\\\\"alias\\\\\":\\\\\"B\\\\\"},{\\\\\"value\\\\\":\\\\\"C\\\\\",\\\\\"alias\\\\\":\\\\\"C\\\\\"},{\\\\\"value\\\\\":\\\\\"D\\\\\",\\\\\"alias\\\\\":\\\\\"D\\\\\"}]\",\"levelScoreKVInfo\":\"{\\\\n  \\\\\"90.00~100.00\\\\\": \\\\\"S\\\\\",\\\\n  \\\\\"80.00~90.00\\\\\": \\\\\"A\\\\\",\\\\n  \\\\\"70.00~80.00\\\\\": \\\\\"B\\\\\",\\\\n  \\\\\"60.00~70.00\\\\\": \\\\\"C\\\\\",\\\\n  \\\\\"0.00~60.00\\\\\": \\\\\"D\\\\\"\\\\n}\",\"scoreLowLimit\":\"0\",\"scoreUpLimit\":\"100\",\"evaResult.period.id\":\"q6myAjHaQLK+wnczfdLCJEUaiOU=\",\"evaResult.reviseFlag\":\"\u662f\",\"evaResult.auditFlag\":\"\u5426\"},{\"evaResult.pnumber\":\"0000355\",\"evaResult.pname\":\"\u7f57\u5efa\u8363\",\"evaResult.positionName\":\"\u53c9\u8f66\u5c97\",\"evaResult.evaObj.perfFile.adminOrgUnit.company.name\":\"\u6e56\u5357\u7ea2\u592a\u9633\u5149\u7535\u79d1\u6280\u6709\u9650\u516c\u53f8\",\"evaResult.evaObj.perfFile.adminOrgUnit.department.name\":\"\u8bbe\u5907\u603b\u88c5\",\"evaResult.sumScore\":\"<span></span>\",\"evaResult.gradeLevel\":\"\",\"evaResult.auditSumScore\":\"<span value=\\\\\"87\\\\\">87.00</span>\",\"evaResult.auditGradeLevel\":\"<div class=\\\\\"ui-select-frame\\\\\" style=\\\\\"width: 99%;\\\\\"><div class=\\\\\"ui-select-layout\\\\\"><div class=\\\\\"ui-select-inputframe\\\\\"><input type=\\\\\"hidden\\\\\" id=\\\\\"2_evaResult.auditGradeLevel_el\\\\\" name=\\\\\"undefined_el\\\\\" value=\\\\\"A\\\\\" autocomplete=\\\\\"off\\\\\" data-value=\\\\\"A\\\\\"><input id=\\\\\"2_evaResult.auditGradeLevel\\\\\" type=\\\\\"text\\\\\" maxlength=\\\\\"200\\\\\" class=\\\\\"block-father input-height cursor-pointer\\\\\" ctrlrole=\\\\\"select\\\\\" readonly=\\\\\"readonly\\\\\" style=\\\\\"width: 100%;\\\\\" title=\\\\\"A\\\\\"></div><div class=\\\\\"ui-select-icon\\\\\"><i class=\\\\\"icon-remove\\\\\" style=\\\\\"color: rgb(156, 178, 188); font-size: 16px; padding: 0px; vertical-align: middle; display: none;\\\\\"></i><i class=\\\\\"icon-chevron-down\\\\\" style=\\\\\"color: rgb(121, 144, 155);\\\\\"></i></div></div></div>\",\"evaResult.auditReason\":\"<div class=\\\\\"cell-height scrollbarthin\\\\\">\u6b63\u6001\u5206\u5e03\u66f4\u65b0\u7ed3\u679c</div>\",\"evaResult.reviseSumScore\":\"<span value=\\\\\"87\\\\\">87.00</span>\", \"evaResult.reviseGradeLevel\":\"C\",\"evaResult.reviseReason\":\"\u6b63\u6001\u5206\u5e03\u66f4\u65b0\u7ed3\u679c\", \"id\":\"MBMgAczuRfeGJ0APPqoJTxdK16Q=\",\"evaResult.id\":\"3USiI6FbQ5mtaXC9qUk3NIESG3Q=\",\"bill.id\":\"m85zTeeDSmaAU2QLbYWMUoZLdW4=\",\"evaResult.evaObj.id\":\"gEO59hOoSlaBEVulLZaDOoGI54s=\",\"reviseGradeLevelSelect\":\"[{\\\\\"value\\\\\":\\\\\"S\\\\\",\\\\\"alias\\\\\":\\\\\"S\\\\\"},{\\\\\"value\\\\\":\\\\\"A\\\\\",\\\\\"alias\\\\\":\\\\\"A\\\\\"},{\\\\\"value\\\\\":\\\\\"B\\\\\",\\\\\"alias\\\\\":\\\\\"B\\\\\"},{\\\\\"value\\\\\":\\\\\"C\\\\\",\\\\\"alias\\\\\":\\\\\"C\\\\\"},{\\\\\"value\\\\\":\\\\\"D\\\\\",\\\\\"alias\\\\\":\\\\\"D\\\\\"}]\",\"levelScoreKVInfo\":\"{\\\\n  \\\\\"90.00~100.00\\\\\": \\\\\"S\\\\\",\\\\n  \\\\\"80.00~90.00\\\\\": \\\\\"A\\\\\",\\\\n  \\\\\"70.00~80.00\\\\\": \\\\\"B\\\\\",\\\\n  \\\\\"60.00~70.00\\\\\": \\\\\"C\\\\\",\\\\n  \\\\\"0.00~60.00\\\\\": \\\\\"D\\\\\"\\\\n}\",\"scoreLowLimit\":\"0\",\"scoreUpLimit\":\"100\",\"evaResult.period.id\":\"q6myAjHaQLK+wnczfdLCJEUaiOU=\",\"evaResult.reviseFlag\":\"\u662f\",\"evaResult.auditFlag\":\"\u5426\"}]";
        JSONArray entryList = JSON.parseArray((String)strs);
        System.out.println();
    }
}

