/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sql.parser;

import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.dom.SqlAlterTableAddDefaultItem;
import com.kingdee.bos.sql.dom.SqlAlterTableAddItem;
import com.kingdee.bos.sql.dom.SqlAlterTableAlterColumnItem;
import com.kingdee.bos.sql.dom.SqlAlterTableDropDefaultItem;
import com.kingdee.bos.sql.dom.SqlAlterTableDropItem;
import com.kingdee.bos.sql.dom.SqlAlterTableItem;
import com.kingdee.bos.sql.dom.SqlColumnDef;
import com.kingdee.bos.sql.dom.SqlTableConstraint;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.dom.stmt.SqlAlterTableStmt;
import com.kingdee.bos.sql.exception.NotSupportedException;
import com.kingdee.bos.sql.parser.Lexer;
import com.kingdee.bos.sql.parser.SqlCreateTableParser;
import com.kingdee.bos.sql.parser.SqlExprParser;
import com.kingdee.bos.sql.parser.SqlParserBase;
import com.kingdee.bos.sql.parser.Token;
import com.kingdee.bos.sql.parser.TokenList;
import java.util.HashMap;
import java.util.Map;

public class AlterTableParser
extends SqlParserBase {
    private final TokenList _tokenList;
    private static final String TABLENAME = "TABLENAME";
    private Map parserContext = new HashMap(10);

    public AlterTableParser(String sql) throws ParserException {
        Lexer lexer = new Lexer(sql);
        this._tokenList = new TokenList(lexer);
    }

    public AlterTableParser(TokenList tokenList) {
        this._tokenList = tokenList;
    }

    public final SqlAlterTableStmt parse() throws ParserException {
        String alterWord = this._tokenList.lookup(0).getOrgValue();
        this._tokenList.match(Token.AlterToken);
        alterWord = alterWord + " " + this._tokenList.lookup(0).getOrgValue();
        this._tokenList.match(Token.TableToken);
        String tableName = this._tokenList.lookup((int)0).value;
        SqlAlterTableStmt stmt = new SqlAlterTableStmt(tableName);
        stmt.setAlterWord(alterWord);
        this._tokenList.match(1);
        this.parserContext.put(TABLENAME, tableName);
        this.parse_itemList(stmt);
        return stmt;
    }

    private final void parse_itemList(SqlAlterTableStmt stmt) throws ParserException {
        boolean isMany = false;
        do {
            if (isMany) {
                this._tokenList.match();
            }
            isMany = true;
            if (this._tokenList.lookup(0).equals(Token.AddToken)) {
                this.parseAddTokenItemList(stmt);
                continue;
            }
            if (this._tokenList.lookup(0).equals(Token.AlterToken)) {
                this.parseAlterTokenItemList(stmt);
                continue;
            }
            if (this._tokenList.lookup(0).equals(Token.DropToken)) {
                this.parseDropTokenItemList(stmt);
                continue;
            }
            if (this._tokenList.lookup(0).equals(Token.WithToken)) {
                throw new ParserException("not support token:" + this._tokenList.lookup(0));
            }
            throw new NotSupportedException("unexpect token:" + this._tokenList.lookup(0));
        } while (this._tokenList.lookup(0).equals(Token.CommaToken));
        if (stmt.items.size() > 0) {
            stmt.item = (SqlAlterTableItem)stmt.items.get(0);
        }
    }

    private void parseAlterTokenItemList(SqlAlterTableStmt stmt) throws ParserException {
        String alterWord = this._tokenList.lookup(0).getOrgValue();
        this._tokenList.match();
        if (this._tokenList.lookup(0).equals(Token.ColumnToken)) {
            alterWord = alterWord + " " + this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
        }
        SqlCreateTableParser createTableParser = new SqlCreateTableParser(this._tokenList);
        SqlColumnDef columnDef = createTableParser.parseColumnDef();
        SqlAlterTableAlterColumnItem alterTableItem = new SqlAlterTableAlterColumnItem(columnDef);
        alterTableItem.setItemWord(alterWord);
        stmt.items.add(alterTableItem);
    }

    private final void parseAddTokenItemList(SqlAlterTableStmt stmt) throws ParserException {
        String addWord = this._tokenList.lookup(0).getOrgValue();
        this._tokenList.match(Token.AddToken);
        boolean isOpenBrace = false;
        if (this._tokenList.lookup(0).equals(Token.OpenBraceToken)) {
            isOpenBrace = true;
            this._tokenList.match();
        }
        if (this._tokenList.lookup((int)0).type == 1) {
            SqlCreateTableParser tableParser = new SqlCreateTableParser(this._tokenList);
            SqlAlterTableAddItem addColumnDefItem = new SqlAlterTableAddItem();
            addColumnDefItem.setItemWord(addWord);
            addColumnDefItem.setOpenBrace(isOpenBrace);
            addColumnDefItem.columnDefItemList.add(tableParser.parseColumnDef());
            if (isOpenBrace) {
                while (this._tokenList.lookup(0).equals(Token.CommaToken)) {
                    this._tokenList.match();
                    addColumnDefItem.columnDefItemList.add(tableParser.parseColumnDef());
                }
            } else {
                while (this._tokenList.lookup(0).equals(Token.CommaToken) && this._tokenList.lookup((int)1).type == 1) {
                    this._tokenList.match();
                    addColumnDefItem.columnDefItemList.add(tableParser.parseColumnDef());
                }
            }
            stmt.items.add(addColumnDefItem);
        } else if (this._tokenList.lookup((int)0).value.equalsIgnoreCase("DEFAULT")) {
            String defaultWord = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
            SqlExpr defaultValue = null;
            SqlExprParser parser = new SqlExprParser(this._tokenList);
            defaultValue = parser.expr();
            String forWord = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match(3);
            String columnName = this._tokenList.lookup((int)0).value;
            this._tokenList.match(1);
            SqlAlterTableAddDefaultItem addDefaultItem = new SqlAlterTableAddDefaultItem(defaultValue, columnName);
            addDefaultItem.setItemWord(addWord);
            addDefaultItem.setDefaultWord(defaultWord);
            addDefaultItem.setOpenBrace(isOpenBrace);
            addDefaultItem.setForWord(forWord);
            stmt.items.add(addDefaultItem);
            if (isOpenBrace) {
                while (this._tokenList.lookup(0).equals(Token.CommaToken)) {
                    this._tokenList.match();
                    defaultValue = null;
                    parser = new SqlExprParser(this._tokenList);
                    defaultValue = parser.expr();
                    forWord = this._tokenList.lookup(0).getOrgValue();
                    this._tokenList.match(3);
                    columnName = this._tokenList.lookup((int)0).value;
                    this._tokenList.match(1);
                    addDefaultItem = new SqlAlterTableAddDefaultItem(defaultValue, columnName);
                    addDefaultItem.setOpenBrace(isOpenBrace);
                    addDefaultItem.setForWord(forWord);
                    stmt.items.add(addDefaultItem);
                }
            }
            addDefaultItem.setOpenBrace(false);
        } else {
            if (this._tokenList.lookup(0).equals(Token.WithToken)) {
                throw new ParserException("not support token:" + this._tokenList.lookup(0));
            }
            SqlAlterTableAddItem addColumnDefItem = new SqlAlterTableAddItem();
            SqlCreateTableParser tableParser = new SqlCreateTableParser(this._tokenList);
            SqlTableConstraint constraint = tableParser.tableConstraint();
            addColumnDefItem.constraintItemList.add(constraint);
            addColumnDefItem.setItemWord(addWord);
            addColumnDefItem.setOpenBrace(isOpenBrace);
            if (isOpenBrace) {
                while (this._tokenList.lookup(0).equals(Token.CommaToken)) {
                    tableParser = new SqlCreateTableParser(this._tokenList);
                    constraint = tableParser.tableConstraint();
                    addColumnDefItem.constraintItemList.add(constraint);
                }
            }
            stmt.items.add(addColumnDefItem);
        }
        if (isOpenBrace) {
            this._tokenList.match(Token.CloseBraceToken);
        }
    }

    private final void parseDropTokenItemList(SqlAlterTableStmt stmt) throws ParserException {
        String dropWord = this._tokenList.lookup(0).getOrgValue();
        this._tokenList.match(Token.DropToken);
        SqlAlterTableDropItem dropItem = new SqlAlterTableDropItem();
        if (this._tokenList.lookup(0).equals(Token.ColumnToken)) {
            dropWord = dropWord + " " + this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
            dropItem.setItemWord(dropWord);
            boolean isOpenBrace = false;
            if (this._tokenList.lookup(0).equals(Token.OpenBraceToken)) {
                isOpenBrace = true;
                this._tokenList.match();
            }
            dropItem.setOpenBrace(isOpenBrace);
            String columnName = this._tokenList.lookup((int)0).value;
            this._tokenList.match(1);
            dropItem.columnDefItemList.add(columnName);
            if (isOpenBrace) {
                while (this._tokenList.lookup(0).equals(Token.CommaToken)) {
                    this._tokenList.match();
                    columnName = this._tokenList.lookup((int)0).value;
                    this._tokenList.match(1);
                    dropItem.columnDefItemList.add(columnName);
                }
                this._tokenList.match(Token.CloseBraceToken);
            } else {
                while (this._tokenList.lookup(0).equals(Token.CommaToken) && this._tokenList.lookup((int)1).type == 1) {
                    this._tokenList.match();
                    columnName = this._tokenList.lookup((int)0).value;
                    this._tokenList.match(1);
                    dropItem.columnDefItemList.add(columnName);
                }
            }
            stmt.items.add(dropItem);
        } else if (this._tokenList.lookup(0).equals(Token.ConstraintToken)) {
            dropWord = dropWord + " " + this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
            dropItem.setItemWord(dropWord);
            boolean isOpenBrace = false;
            if (this._tokenList.lookup(0).equals(Token.OpenBraceToken)) {
                isOpenBrace = true;
                this._tokenList.match();
            }
            dropItem.setOpenBrace(isOpenBrace);
            String constraintName = "";
            if (this._tokenList.lookup(0).equals(Token.PrimaryToken)) {
                constraintName = "PRIMARYKEY";
                this._tokenList.match(Token.PrimaryToken);
                if (this._tokenList.lookup(0).equals(Token.KeyToken)) {
                    this._tokenList.match(Token.KeyToken);
                }
                if (this._tokenList.lookup((int)0).type == 1) {
                    constraintName = this._tokenList.lookup((int)0).value;
                    this._tokenList.match(1);
                }
            } else {
                constraintName = this._tokenList.lookup((int)0).value;
                this._tokenList.match(1);
            }
            dropItem.constraintItemList.add(constraintName);
            if (isOpenBrace) {
                while (this._tokenList.lookup(0).equals(Token.CommaToken)) {
                    this._tokenList.match();
                    constraintName = this._tokenList.lookup((int)0).value;
                    this._tokenList.match(1);
                    dropItem.constraintItemList.add(constraintName);
                }
                this._tokenList.match(Token.CloseBraceToken);
            } else {
                while (this._tokenList.lookup(0).equals(Token.CommaToken) && this._tokenList.lookup((int)1).type == 1) {
                    this._tokenList.match();
                    constraintName = this._tokenList.lookup((int)0).value;
                    this._tokenList.match(1);
                    dropItem.constraintItemList.add(constraintName);
                }
            }
            stmt.items.add(dropItem);
        } else if (this._tokenList.lookup((int)0).value.equalsIgnoreCase("DEFAULT")) {
            dropWord = dropWord + " " + this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
            boolean isOpenBrace = false;
            if (this._tokenList.lookup(0).equals(Token.OpenBraceToken)) {
                isOpenBrace = true;
                this._tokenList.match();
            }
            String forWord = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match(3);
            String columnName = this._tokenList.lookup((int)0).value;
            this._tokenList.match(1);
            SqlAlterTableDropDefaultItem addDefaultItem = new SqlAlterTableDropDefaultItem(columnName);
            addDefaultItem.setItemWord(dropWord);
            addDefaultItem.setForWord(forWord);
            addDefaultItem.setOpenBrace(isOpenBrace);
            stmt.items.add(addDefaultItem);
            if (isOpenBrace) {
                while (this._tokenList.lookup(0).equals(Token.CommaToken)) {
                    this._tokenList.match();
                    forWord = this._tokenList.lookup(0).getOrgValue();
                    this._tokenList.match(3);
                    columnName = this._tokenList.lookup((int)0).value;
                    this._tokenList.match(1);
                    addDefaultItem = new SqlAlterTableDropDefaultItem(columnName);
                    addDefaultItem.setForWord(forWord);
                    addDefaultItem.setOpenBrace(isOpenBrace);
                    stmt.items.add(addDefaultItem);
                }
                addDefaultItem.setOpenBrace(false);
                this._tokenList.match(Token.CloseBraceToken);
            }
        } else {
            throw new ParserException("not support token:" + this._tokenList.lookup(0));
        }
    }
}

