/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sql.parser;

import java.util.Locale;

public class KeyWord {
    private static final String[] KSQL_KEYWORDS = new String[]{"ADD", "ALL", "ALTER", "AND", "ANY", "AS", "ASC", "AUTHORIZATION", "BACKUP", "BEGIN", "BETWEEN", "BREAK", "BROWSE", "BULK", "BY", "CALL", "CASCADE", "CASE", "CHECK", "CHECKPOINT", "CLOSE", "CLUSTERED", "COALESCE", "COLLATE", "COLUMN", "COMMIT", "COMPUTE", "CONNECT", "CONSTRAINT", "CONTAINS", "CONTAINSTABLE", "CONTINUE", "CONVERT", "CREATE", "CROSS", "CURRENT", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "CURSOR_LOOP", "DATABASE", "DATE", "DBCC", "DEALLOCATE", "DECLARE", "DEFAULT", "DELETE", "DENY", "DESC", "DISK", "DISTINCT", "DISTRIBUTED", "DO", "DOUBLE", "DROP", "DUMMY", "DUMP", "ELSE", "EMPTY", "END", "ERRLVL", "ESCAPE", "EXCEPT", "EXEC", "EXECUTE", "EXISTS", "EXIT", "FALSE", "FAST", "FETCH", "FILE", "FILLFACTOR", "FOR", "FOREIGN", "FREETEXT", "FREETEXTTABLE", "FROM", "FULL", "FUNCTION", "GOTO", "GRANT", "GROUP", "HAVING", "HOLDLOCK", "IDENTITY", "IDENTITYCOL", "IDENTITY_INSERT", "IF", "IN", "INDEX", "INNER", "INSERT", "INTERSECT", "INTO", "IS", "JOIN", "KEY", "KILL", "KSQL_BLOCK", "KSQL_COLNAME", "KSQL_CONSTNAME", "KSQL_CONSTRAINTS", "KSQL_CURSOR_LOOP", "KSQL_DEFAULT", "KSQL_FETCH", "KSQL_INDEXES", "KSQL_INDNAME", "KSQL_NULLABLE", "KSQL_TABNAME", "KSQL_USERCOLUMNS", "KSQL_USERTABLES", "LABEL", "LEFT", "LIKE", "LIMIT", "LINENO", "LOAD", "LOOP", "NATIONAL", "NEW", "NOCHECK", "NONCLUSTERED", "NOT", "NULL", "NULLIF", "OF", "OFF", "OFFSETS", "ON", "OPEN", "OPENDATASOURCE", "OPENQUERY", "OPENROWSET", "OPENXML", "OPTION", "OR", "ORDER", "OUTER", "OVER", "PERCENT", "PLAN", "PRECISION", "PRIMARY", "PRINT", "PRIOR", "PROC", "PROCEDURE", "PUBLIC", "RAISERROR", "READ", "READPAST", "READTEXT", "RECONFIGURE", "REFERENCES", "REPLICATION", "RESTORE", "RETURN", "REVOKE", "RIGHT", "ROLLBACK", "ROLLUP", "ROWCOUNT", "ROWGUIDCOL", "RULE", "SAVE", "SCHEMA", "SCHINESE_PINYIN", "SCHINESE_RADICAL", "SCHINESE_STROKE", "SELECT", "SESSION_USER", "SET", "SETUSER", "SHUTDOWN", "SOME", "START", "STATISTICS", "SYSTEM_USER", "TABLE", "TEXTSIZE", "THEN", "TIME", "TIMESTAMP", "TO", "TOP", "TRAN", "TRANSACTION", "TRIGGER", "TRUE", "TRUNCATE", "TSEQUAL", "UNION", "UNIQUE", "UPDATE", "UPDATETEXT", "USE", "USER", "VALUES", "VARYING", "VIEW", "WAITFOR", "WHEN", "WHERE", "WHILE", "WITH", "WRITETEXT"};
    public static final KeyWord instance = new KeyWord();
    private final String[] _keywords;
    private final String[] _aggregateFunctions = new String[]{"AVG", "COUNT", "MAX", "MIN", "SUM", "STDDEV", "GROUPING"};

    public final boolean isAggreateFunction(String word) {
        for (int i = 0; i < this._aggregateFunctions.length; ++i) {
            if (this._aggregateFunctions[i].compareToIgnoreCase(word) != 0) continue;
            return true;
        }
        return false;
    }

    public KeyWord() {
        this._keywords = KSQL_KEYWORDS;
    }

    public KeyWord(String[] keywords) {
        this._keywords = keywords;
    }

    public boolean isKeyWord(String word) {
        word = word.toUpperCase(Locale.ENGLISH);
        int low = 0;
        int high = this._keywords.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            String midVal = this._keywords[mid];
            int cmp = midVal.compareTo(word);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return true;
        }
        return false;
    }
}

