/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sql.schema;

import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.dom.SqlAlterTableAddItem;
import com.kingdee.bos.sql.dom.SqlColumnDef;
import com.kingdee.bos.sql.dom.SqlOrderByItem;
import com.kingdee.bos.sql.dom.SqlTableForeignKey;
import com.kingdee.bos.sql.dom.SqlTablePrimaryKey;
import com.kingdee.bos.sql.dom.SqlTableUnique;
import com.kingdee.bos.sql.dom.expr.SqlIdentifierExpr;
import com.kingdee.bos.sql.dom.stmt.SqlAlterTableStmt;
import com.kingdee.bos.sql.dom.stmt.SqlCreateIndexStmt;
import com.kingdee.bos.sql.dom.stmt.SqlCreateTableStmt;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.bos.sql.formater.SQLFormater;
import com.kingdee.bos.sql.schema.SqlColumn;
import com.kingdee.bos.sql.schema.SqlTable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;

public class Oralce8iUtil {
    public static String generateSchemaSql(Connection conn, SQLFormater formater) throws SQLException, FormaterException, ParserException {
        StringBuffer buffer = new StringBuffer();
        formater.setBuffer(buffer);
        buffer.append("\n\n\n\n/* create talbe */\n\n");
        Collection stmt = Oralce8iUtil.generateCreateTableSqlDom(conn);
        formater.format(stmt);
        buffer.append("\n\n\n\n/* create primary key */\n\n");
        stmt = Oralce8iUtil.generatePkSqlDom(conn);
        formater.format(stmt);
        buffer.append("\n\n\n\n/* create unique */\n\n");
        stmt = Oralce8iUtil.generateUniqueSqlDom(conn);
        formater.format(stmt);
        buffer.append("\n\n\n\n/* create foreign key */\n\n");
        stmt = Oralce8iUtil.generateFkSqlDom(conn);
        formater.format(stmt);
        buffer.append("\n\n\n\n/* create index */\n\n");
        stmt = Oralce8iUtil.generateCreateIndexSqlDom(conn);
        formater.format(stmt);
        return buffer.toString();
    }

    public static Collection generateCreateIndexSqlDom(Connection conn) throws SQLException {
        ArrayList pkStmtList = new ArrayList();
        ArrayList tableList = Oralce8iUtil.getUserTables(conn);
        for (SqlTable table : tableList) {
            Collection list = Oralce8iUtil.buildCreateIndexStmt(conn, table);
            pkStmtList.addAll(list);
        }
        return pkStmtList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection buildCreateIndexStmt(Connection conn, SqlTable table) throws SQLException {
        ArrayList<SqlCreateIndexStmt> createIndexStmtList = new ArrayList<SqlCreateIndexStmt>();
        String sql = "SELECT * FROM USER_INDEXES WHERE TABLE_NAME ='" + table.name + "'";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                SqlCreateIndexStmt createIndexStmt = new SqlCreateIndexStmt();
                createIndexStmt.tableName = table.name;
                createIndexStmt.indexName = rs.getString(1);
                createIndexStmt.addExtAttr("INDEX_TYPE", rs.getString(2));
                createIndexStmt.addExtAttr("TABLE_OWNER", rs.getString(3));
                createIndexStmt.addExtAttr("TABLE_NAME", rs.getString(4));
                createIndexStmt.addExtAttr("TABLE_TYPE", rs.getString(5));
                String uniqueStr = rs.getString(6);
                createIndexStmt.addExtAttr("COMPRESSION", rs.getString(7));
                createIndexStmt.addExtAttr("PREFIX_LENGTH", rs.getString(8));
                createIndexStmt.addExtAttr("TABLESPACE_NAME", rs.getString(9));
                createIndexStmt.addExtAttr("INI_TRANS", rs.getString(10));
                createIndexStmt.addExtAttr("MAX_TRANS", rs.getString(11));
                createIndexStmt.addExtAttr("INITIAL_EXTENT", rs.getString(12));
                if (uniqueStr.equalsIgnoreCase("UNIQUE")) {
                    createIndexStmt.isUnique = true;
                }
                Oralce8iUtil.buildCreateIndexStmt_buildColumns(conn, createIndexStmt);
                createIndexStmtList.add(createIndexStmt);
            }
        }
        catch (Throwable throwable) {
            KSqlUtil.cleanUp(stmt, rs);
            throw throwable;
        }
        KSqlUtil.cleanUp(stmt, rs);
        return createIndexStmtList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void buildCreateIndexStmt_buildColumns(Connection conn, SqlCreateIndexStmt createIndexStmt) throws SQLException {
        String sql = "SELECT * FROM USER_IND_COLUMNS WHERE INDEX_NAME = '" + createIndexStmt.indexName + "'";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                int orderByMode;
                String colName = rs.getString(3);
                String descStr = rs.getString(7);
                int chineseOrderByMode = -1;
                if (colName.substring(0, 6).compareToIgnoreCase("SYS_NC") == 0 && colName.indexOf("$") == colName.length() - 1) {
                    String content;
                    String sql1 = "SELECT COLUMN_EXPRESSION FROM USER_IND_EXPRESSIONS WHERE INDEX_NAME='" + createIndexStmt.indexName + "'";
                    Statement stmt1 = conn.createStatement();
                    ResultSet rs1 = stmt.executeQuery(sql1);
                    if (rs1.next() && (content = rs1.getString(1)).indexOf("NLSSORT") == 0) {
                        chineseOrderByMode = content.indexOf("SCHINESE_PINYIN_M") != -1 ? 2 : (content.indexOf("SCHINESE_RADICAL_M") != -1 ? 4 : (content.indexOf("SCHINESE_STROKE_M") != -1 ? 3 : -1));
                        colName = content.substring(9, content.indexOf("\",'"));
                    }
                    KSqlUtil.cleanUp(stmt1, rs1);
                }
                if (descStr.equalsIgnoreCase("ASC")) {
                    orderByMode = 0;
                } else if (descStr.equalsIgnoreCase("DESC")) {
                    orderByMode = 1;
                } else {
                    throw new SQLException("unkown descending.");
                }
                SqlOrderByItem orderItem = new SqlOrderByItem(new SqlIdentifierExpr(colName), orderByMode, chineseOrderByMode);
                createIndexStmt.itemList.add(orderItem);
            }
        }
        catch (Throwable throwable) {
            KSqlUtil.cleanUp(stmt, rs);
            throw throwable;
        }
        KSqlUtil.cleanUp(stmt, rs);
    }

    public static Collection generateFkSqlDom(Connection conn) throws SQLException {
        ArrayList pkStmtList = new ArrayList();
        ArrayList tableList = Oralce8iUtil.getUserTables(conn);
        for (SqlTable table : tableList) {
            Collection list = Oralce8iUtil.buildFkStmt(conn, table);
            pkStmtList.addAll(list);
        }
        return pkStmtList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection buildFkStmt(Connection conn, SqlTable table) throws SQLException {
        ArrayList<SqlAlterTableStmt> fkStmtList = new ArrayList<SqlAlterTableStmt>();
        String sql = "SELECT * FROM USER_CONSTRAINTS WHERE CONSTRAINT_TYPE = 'R' AND TABLE_NAME ='" + table.name + "'";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                SqlTableForeignKey fk = new SqlTableForeignKey();
                fk.extendedAttributes().put("OWNER", rs.getString(1));
                fk.name = rs.getString(2);
                fk.extendedAttributes().put("TABLE_NAME", rs.getString(4));
                fk.extendedAttributes().put("SEARCH_CONDITION", rs.getString(5));
                fk.extendedAttributes().put("R_OWNER", rs.getString(6));
                String r_constraint_name = rs.getString(7);
                fk.extendedAttributes().put("R_CONSTRAINT_NAME", r_constraint_name);
                fk.extendedAttributes().put("DELETE_RULE", rs.getString(8));
                fk.extendedAttributes().put("STATUS", rs.getString(9));
                fk.extendedAttributes().put("DEFERRABLE", rs.getString(10));
                fk.extendedAttributes().put("DEFERRED", rs.getString(11));
                fk.extendedAttributes().put("VALIDATED", rs.getString(12));
                fk.extendedAttributes().put("GENERATED", rs.getString(13));
                fk.extendedAttributes().put("BAD", rs.getString(14));
                fk.extendedAttributes().put("RELY", rs.getString(15));
                fk.extendedAttributes().put("LAST_CHANGE", rs.getString(16));
                Oralce8iUtil.buildFkStmt_buildColumns(conn, fk);
                Oralce8iUtil.buildFkStmt_buildRefInfo(conn, fk, r_constraint_name);
                SqlAlterTableStmt alterTableStmt = new SqlAlterTableStmt(table.name);
                alterTableStmt.item = new SqlAlterTableAddItem(fk);
                fkStmtList.add(alterTableStmt);
            }
        }
        catch (Throwable throwable) {
            KSqlUtil.cleanUp(stmt, rs);
            throw throwable;
        }
        KSqlUtil.cleanUp(stmt, rs);
        return fkStmtList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void buildFkStmt_buildRefInfo(Connection conn, SqlTableForeignKey fk, String r_constraint_name) throws SQLException {
        String sql = "SELECT * FROM USER_CONSTRAINTS WHERE CONSTRAINT_NAME ='" + r_constraint_name + "'";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            if (!rs.next()) {
                throw new SQLException("ref constraint not found. ref constraint name is '" + r_constraint_name + "'");
            }
            fk.refTableName = rs.getString(4);
        }
        catch (Throwable throwable) {
            KSqlUtil.cleanUp(stmt, rs);
            throw throwable;
        }
        KSqlUtil.cleanUp(stmt, rs);
        stmt = null;
        rs = null;
        sql = "SELECT * FROM USER_CONS_COLUMNS WHERE CONSTRAINT_NAME = '" + r_constraint_name + "'";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String colName = rs.getString(4);
                fk.refColumnList.add(colName);
            }
        }
        finally {
            KSqlUtil.cleanUp(stmt, rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void buildFkStmt_buildColumns(Connection conn, SqlTableForeignKey fk) throws SQLException {
        String sql = "SELECT * FROM USER_CONS_COLUMNS WHERE CONSTRAINT_NAME = '" + fk.name + "'";
        Statement stmt = conn.createStatement();
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String colName = rs.getString(4);
                fk.columnList.add(colName);
            }
        }
        finally {
            KSqlUtil.cleanUp(stmt, rs);
        }
    }

    public static Collection generateUniqueSqlDom(Connection conn) throws SQLException {
        ArrayList pkStmtList = new ArrayList();
        ArrayList tableList = Oralce8iUtil.getUserTables(conn);
        for (SqlTable table : tableList) {
            Collection list = Oralce8iUtil.buildUniqueStmt(conn, table);
            pkStmtList.addAll(list);
        }
        return pkStmtList;
    }

    public static Collection buildUniqueStmt(Connection conn, SqlTable table) throws SQLException {
        ArrayList<SqlAlterTableStmt> uniqueStmtList = new ArrayList<SqlAlterTableStmt>();
        String sql = "SELECT * FROM USER_CONSTRAINTS WHERE CONSTRAINT_TYPE = 'U' AND TABLE_NAME ='" + table.name + "'";
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
            SqlTableUnique unique = new SqlTableUnique();
            unique.extendedAttributes().put("OWNER", rs.getString(1));
            unique.name = rs.getString(2);
            unique.extendedAttributes().put("TABLE_NAME", rs.getString(4));
            unique.extendedAttributes().put("SEARCH_CONDITION", rs.getString(5));
            unique.extendedAttributes().put("R_OWNER", rs.getString(6));
            unique.extendedAttributes().put("R_CONSTRAINT_NAME", rs.getString(7));
            unique.extendedAttributes().put("DELETE_RULE", rs.getString(8));
            unique.extendedAttributes().put("STATUS", rs.getString(9));
            unique.extendedAttributes().put("DEFERRABLE", rs.getString(10));
            unique.extendedAttributes().put("DEFERRED", rs.getString(11));
            unique.extendedAttributes().put("VALIDATED", rs.getString(12));
            unique.extendedAttributes().put("GENERATED", rs.getString(13));
            unique.extendedAttributes().put("BAD", rs.getString(14));
            unique.extendedAttributes().put("RELY", rs.getString(15));
            unique.extendedAttributes().put("LAST_CHANGE", rs.getString(16));
            Oralce8iUtil.buildUniqueStmt_buildColumns(conn, unique);
            SqlAlterTableStmt alterTableStmt = new SqlAlterTableStmt(table.name);
            alterTableStmt.item = new SqlAlterTableAddItem(unique);
            uniqueStmtList.add(alterTableStmt);
        }
        return uniqueStmtList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void buildUniqueStmt_buildColumns(Connection conn, SqlTableUnique unique) throws SQLException {
        String sql = "SELECT * FROM USER_CONS_COLUMNS WHERE CONSTRAINT_NAME = '" + unique.name + "'";
        Statement stmt = conn.createStatement();
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String colName = rs.getString(4);
                unique.columnList.add(colName);
            }
        }
        finally {
            KSqlUtil.cleanUp(stmt, rs);
        }
    }

    public static Collection generatePkSqlDom(Connection conn) throws SQLException {
        ArrayList pkStmtList = new ArrayList();
        ArrayList tableList = Oralce8iUtil.getUserTables(conn);
        for (SqlTable table : tableList) {
            Collection list = Oralce8iUtil.buildPkStmt(conn, table);
            pkStmtList.addAll(list);
        }
        return pkStmtList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection buildPkStmt(Connection conn, SqlTable table) throws SQLException {
        ArrayList<SqlAlterTableStmt> pkStmtList = new ArrayList<SqlAlterTableStmt>();
        String sql = "SELECT * FROM USER_CONSTRAINTS WHERE CONSTRAINT_TYPE = 'P' AND TABLE_NAME ='" + table.name + "'";
        Statement stmt = conn.createStatement();
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                SqlTablePrimaryKey pk = new SqlTablePrimaryKey();
                pk.extendedAttributes().put("OWNER", rs.getString(1));
                pk.name = rs.getString(2);
                pk.extendedAttributes().put("TABLE_NAME", rs.getString(4));
                pk.extendedAttributes().put("SEARCH_CONDITION", rs.getString(5));
                pk.extendedAttributes().put("R_OWNER", rs.getString(6));
                pk.extendedAttributes().put("R_CONSTRAINT_NAME", rs.getString(7));
                pk.extendedAttributes().put("DELETE_RULE", rs.getString(8));
                pk.extendedAttributes().put("STATUS", rs.getString(9));
                pk.extendedAttributes().put("DEFERRABLE", rs.getString(10));
                pk.extendedAttributes().put("DEFERRED", rs.getString(11));
                pk.extendedAttributes().put("VALIDATED", rs.getString(12));
                pk.extendedAttributes().put("GENERATED", rs.getString(13));
                pk.extendedAttributes().put("BAD", rs.getString(14));
                pk.extendedAttributes().put("RELY", rs.getString(15));
                pk.extendedAttributes().put("LAST_CHANGE", rs.getString(16));
                Oralce8iUtil.buildPkStmt_buildColumns(conn, pk);
                SqlAlterTableStmt alterTableStmt = new SqlAlterTableStmt(table.name);
                alterTableStmt.item = new SqlAlterTableAddItem(pk);
                pkStmtList.add(alterTableStmt);
            }
        }
        finally {
            KSqlUtil.cleanUp(stmt, rs);
        }
        return pkStmtList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void buildPkStmt_buildColumns(Connection conn, SqlTablePrimaryKey pk) throws SQLException {
        String sql = "SELECT * FROM USER_CONS_COLUMNS WHERE CONSTRAINT_NAME = '" + pk.name + "'";
        Statement stmt = conn.createStatement();
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String colName = rs.getString(4);
                pk.columnList.add(colName);
            }
        }
        finally {
            KSqlUtil.cleanUp(stmt, rs);
        }
    }

    public static Collection generateCreateTableSqlDom(Connection conn) throws SQLException {
        ArrayList<SqlCreateTableStmt> stmtList = new ArrayList<SqlCreateTableStmt>();
        ArrayList tableList = Oralce8iUtil.getUserTables(conn);
        for (SqlTable table : tableList) {
            SqlCreateTableStmt stmt = Oralce8iUtil.buildCreateTableStmt(table);
            stmtList.add(stmt);
        }
        return stmtList;
    }

    public static SqlCreateTableStmt buildCreateTableStmt(SqlTable table) throws SQLException {
        SqlCreateTableStmt stmt = new SqlCreateTableStmt(table.name);
        for (SqlColumn col : table.columns) {
            SqlColumnDef colDef = new SqlColumnDef();
            colDef.name = col.name;
            colDef.dataType = col.dataType.toUpperCase();
            colDef.length = col.length;
            colDef.precision = col.precision;
            colDef.scale = col.scale;
            colDef.allowNull = col.isNullable;
            Oralce8iUtil.convertColumnDataType(colDef);
            stmt.columnList.add(colDef);
        }
        return stmt;
    }

    public static void convertColumnDataType(SqlColumnDef column) throws SQLException {
        String dataType = column.dataType;
        if (!column.dataType.equalsIgnoreCase("CHAR")) {
            if (column.dataType.equalsIgnoreCase("VARCHAR") || column.dataType.equalsIgnoreCase("VARCHAR2")) {
                column.dataType = "VARCHAR";
            } else if (!column.dataType.equalsIgnoreCase("NCHAR")) {
                if (column.dataType.equalsIgnoreCase("NVARCHAR") || column.dataType.equalsIgnoreCase("NVARCHAR2")) {
                    column.dataType = "NVARCHAR";
                } else if (column.dataType.equalsIgnoreCase("NUMBER") || column.dataType.equalsIgnoreCase("DECIMAL")) {
                    column.dataType = "NUMERIC";
                } else if (column.dataType.equalsIgnoreCase("INT") || column.dataType.equalsIgnoreCase("INTEGER")) {
                    column.dataType = "INT";
                } else if (!column.dataType.equalsIgnoreCase("SMALLINT")) {
                    if (column.dataType.equalsIgnoreCase("DATETIME") || column.dataType.equalsIgnoreCase("DATE")) {
                        column.dataType = "DATETIME";
                    } else if (!column.dataType.equalsIgnoreCase("LONG")) {
                        if (column.dataType.equalsIgnoreCase("RAW") || column.dataType.equalsIgnoreCase("BINARY")) {
                            column.dataType = "BINARY";
                        } else if (column.dataType.equalsIgnoreCase("LONG RAW") || column.dataType.equalsIgnoreCase("VARBINARY")) {
                            column.dataType = "VARBINARY";
                        } else if (!(column.dataType.equalsIgnoreCase("ROWID") || column.dataType.equalsIgnoreCase("BLOB") || column.dataType.equalsIgnoreCase("CLOB") || column.dataType.equalsIgnoreCase("NCLOB") || column.dataType.equalsIgnoreCase("BFILE") || column.dataType.equalsIgnoreCase("UROWID") || column.dataType.equalsIgnoreCase("FLOAT"))) {
                            throw new SQLException("incompatible datatype : '" + dataType + "'");
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getUserTables(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        ArrayList<SqlTable> list = new ArrayList<SqlTable>();
        String sql = "select * from USER_TABLES";
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                SqlTable table = new SqlTable();
                table.name = rs.getString(1);
                if (!table.name.equals("T_T1")) continue;
                table.extendedAttributes.put("TABLESPACE_NAME", rs.getString(2));
                table.extendedAttributes.put("CLUSTER_NAME", rs.getString(3));
                table.extendedAttributes.put("IOT_NAME", rs.getString(4));
                table.extendedAttributes.put("PCT_FREE", rs.getString(5));
                table.extendedAttributes.put("PCT_USED", rs.getString(6));
                table.extendedAttributes.put("INI_TRANS", rs.getString(7));
                table.extendedAttributes.put("MAX_TRANS", rs.getString(8));
                table.extendedAttributes.put("INITIAL_EXTENT", rs.getString(9));
                table.extendedAttributes.put("NEXT_EXTENT", rs.getString(10));
                table.extendedAttributes.put("MIN_EXTENTS", rs.getString(11));
                table.extendedAttributes.put("MAX_EXTENTS", rs.getString(12));
                table.extendedAttributes.put("PCT_INCREASE", rs.getString(13));
                Oralce8iUtil.getTableDetail(conn, table);
                list.add(table);
            }
        }
        finally {
            KSqlUtil.cleanUp(stmt, rs);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getTableDetail(Connection conn, SqlTable table) throws SQLException {
        String sql = "select * from ALL_TAB_COLUMNS where table_name = '" + table.name + "' ORDER BY COLUMN_ID";
        Statement stmt = conn.createStatement();
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                SqlColumn column = new SqlColumn();
                column.extendedAttributes.put("OWNER", rs.getString(1));
                column.extendedAttributes.put("TABLE_NAME", rs.getString(2));
                column.name = rs.getString(3);
                column.dataType = rs.getString(4);
                column.extendedAttributes.put("DATA_TYPE_MOD", rs.getString(5));
                column.extendedAttributes.put("DATA_TYPE_OWNER", rs.getString(6));
                column.length = rs.getInt(7);
                column.precision = rs.getInt(8);
                if (rs.wasNull()) {
                    column.precision = -1;
                }
                column.scale = rs.getInt(9);
                if (rs.wasNull()) {
                    column.scale = -1;
                }
                column.isNullable = rs.getString(10).equalsIgnoreCase("Y");
                column.extendedAttributes.put("COLUMN_ID", rs.getString(11));
                column.extendedAttributes.put("DEFAULT_LENGTH", rs.getString(12));
                table.columns.add(column);
            }
        }
        finally {
            KSqlUtil.cleanUp(stmt, rs);
        }
    }

    public static void executeImmediate(Statement stmt, String sql) throws SQLException {
        String dialectSql = "/*dialect*/BEGIN EXECUTE IMMEDIATE '" + sql + "'; END;";
        stmt.execute(dialectSql);
    }
}

