/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sql.formater;

import com.kingdee.bos.sql.dom.SqlAlterTableAddItem;
import com.kingdee.bos.sql.dom.SqlAlterTableAlterColumnItem;
import com.kingdee.bos.sql.dom.SqlAlterTableDropItem;
import com.kingdee.bos.sql.dom.SqlBlockStmt;
import com.kingdee.bos.sql.dom.SqlColumnDef;
import com.kingdee.bos.sql.dom.SqlJoinedTableSource;
import com.kingdee.bos.sql.dom.SqlOrderByItem;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.SqlSelectItem;
import com.kingdee.bos.sql.dom.SqlSubQueryTableSource;
import com.kingdee.bos.sql.dom.SqlTableCheck;
import com.kingdee.bos.sql.dom.SqlTableConstraint;
import com.kingdee.bos.sql.dom.SqlTableForeignKey;
import com.kingdee.bos.sql.dom.SqlTablePrimaryKey;
import com.kingdee.bos.sql.dom.SqlTableSource;
import com.kingdee.bos.sql.dom.SqlTableSourceBase;
import com.kingdee.bos.sql.dom.SqlTableUnique;
import com.kingdee.bos.sql.dom.expr.SqlBinaryOpExpr;
import com.kingdee.bos.sql.dom.expr.SqlDateTimeExpr;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.dom.expr.SqlIdentifierExpr;
import com.kingdee.bos.sql.dom.expr.SqlMethodInvokeExpr;
import com.kingdee.bos.sql.dom.expr.SqlPriorIdentifierExpr;
import com.kingdee.bos.sql.dom.stmt.SqlAlterTableStmt;
import com.kingdee.bos.sql.dom.stmt.SqlBreakStmt;
import com.kingdee.bos.sql.dom.stmt.SqlCloseStmt;
import com.kingdee.bos.sql.dom.stmt.SqlContinueStmt;
import com.kingdee.bos.sql.dom.stmt.SqlCreateTableStmt;
import com.kingdee.bos.sql.dom.stmt.SqlCursorLoopStmt;
import com.kingdee.bos.sql.dom.stmt.SqlDeallocateStmt;
import com.kingdee.bos.sql.dom.stmt.SqlExecStmt;
import com.kingdee.bos.sql.dom.stmt.SqlFetchStmt;
import com.kingdee.bos.sql.dom.stmt.SqlGotoStmt;
import com.kingdee.bos.sql.dom.stmt.SqlIfStmt;
import com.kingdee.bos.sql.dom.stmt.SqlLabelStmt;
import com.kingdee.bos.sql.dom.stmt.SqlOpenStmt;
import com.kingdee.bos.sql.dom.stmt.SqlSetLocalVariantStmt;
import com.kingdee.bos.sql.dom.stmt.SqlShowColumnsStmt;
import com.kingdee.bos.sql.dom.stmt.SqlShowTablesStmt;
import com.kingdee.bos.sql.dom.stmt.SqlWhileStmt;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.bos.sql.formater.SQLFormater;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class InformixSQLFormater
extends SQLFormater {
    public InformixSQLFormater(StringBuffer sb) {
        super(sb);
    }

    public InformixSQLFormater() {
        super(null);
    }

    @Override
    protected void formatCreateTableStmt(SqlCreateTableStmt stmt) throws FormaterException {
        this.validateCreateTableStmt(stmt);
        this.buffer.append("CREATE TABLE ");
        this.buffer.append(stmt.name);
        this.buffer.append(" (");
        boolean flag = false;
        Iterator iterator = stmt.columnList.iterator();
        while (iterator.hasNext()) {
            if (flag) {
                this.buffer.append(", ");
            }
            SqlColumnDef column = (SqlColumnDef)iterator.next();
            this.formatColumnDef(column);
            flag = true;
        }
        this.formatTableConstraintList(stmt.constraintList);
        this.buffer.append(")");
    }

    @Override
    protected void formatAlterTableStmt(SqlAlterTableStmt stmt) throws FormaterException {
        this.buffer.append("ALTER TABLE ");
        this.buffer.append(stmt.tableName);
        if (stmt.item instanceof SqlAlterTableAddItem) {
            SqlAlterTableAddItem addColumnDefItem = (SqlAlterTableAddItem)stmt.item;
            this.buffer.append(" ADD ");
            Iterator iterator = addColumnDefItem.columnDefItemList.iterator();
            boolean flag = false;
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlColumnDef columnDef = (SqlColumnDef)iterator.next();
                this.formatColumnDef(columnDef);
                flag = true;
            }
            iterator = addColumnDefItem.constraintItemList.iterator();
            flag = false;
            while (iterator.hasNext()) {
                SqlTableConstraint constraint = (SqlTableConstraint)iterator.next();
                this.formatTableConstraint(constraint);
            }
        } else if (stmt.item instanceof SqlAlterTableDropItem) {
            String columnDef;
            SqlAlterTableDropItem dropColumnDefItem = (SqlAlterTableDropItem)stmt.item;
            this.buffer.append(" DROP ");
            Iterator iterator = dropColumnDefItem.columnDefItemList.iterator();
            boolean flag = false;
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                } else {
                    this.buffer.append("COLUMN ");
                }
                columnDef = (String)iterator.next();
                this.buffer.append(columnDef);
                flag = true;
            }
            iterator = dropColumnDefItem.constraintItemList.iterator();
            flag = false;
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                } else {
                    this.buffer.append("CONSTRAINT ");
                }
                columnDef = (String)iterator.next();
                this.buffer.append(columnDef);
                flag = true;
            }
        } else if (stmt.item instanceof SqlAlterTableAlterColumnItem) {
            SqlAlterTableAlterColumnItem alterColumnDefItem = (SqlAlterTableAlterColumnItem)stmt.item;
            this.buffer.append(" ALTER COLUMN ");
            this.formatColumnDef(alterColumnDefItem.columnDef);
        } else {
            throw new FormaterException("TODO");
        }
    }

    @Override
    protected void formatExecStmt(SqlExecStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatShowTablesStmt(SqlShowTablesStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatShowColumnsStmt(SqlShowColumnsStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatSelect(SqlSelect select) throws FormaterException {
        Map optionMap;
        if (select.hierarchicalQueryClause != null) {
            throw new FormaterException("TODO");
        }
        this.buffer.append("SELECT ");
        if (select.distinct == 1) {
            this.buffer.append("DISTINCT ");
        } else if (select.distinct != 0) {
            throw new FormaterException("distinct option not support.");
        }
        Iterator iterator = select.selectList.iterator();
        boolean flag = false;
        while (iterator.hasNext()) {
            if (flag) {
                this.buffer.append(", ");
            }
            SqlSelectItem item = (SqlSelectItem)iterator.next();
            if (item.alias != null && item.alias.length() != 0) {
                this.formatExpr(item.expr);
                this.buffer.append(" ");
                this.buffer.append(item.alias.toUpperCase(Locale.ENGLISH));
            } else {
                this.formatExpr(item.expr, false);
            }
            flag = true;
        }
        if (select.tableSource != null) {
            this.buffer.append(" FROM ");
            this.formatTableSource(select.tableSource);
        } else {
            this.buffer.append(" FROM SYSIBM.SYSDUMMY1");
        }
        if (select.condition != null) {
            this.buffer.append(" WHERE ");
            this.formatExpr(select.condition);
        }
        if (select.groupBy.size() != 0) {
            this.buffer.append(" GROUP BY ");
            flag = false;
            iterator = select.groupBy.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlExpr expr = (SqlExpr)iterator.next();
                this.formatExpr(expr);
                flag = true;
            }
        }
        if (select.having != null) {
            this.buffer.append(" HAVING ");
            this.formatExpr(select.having);
        }
        if (select.orderBy.size() != 0) {
            this.buffer.append(" ORDER BY ");
            flag = false;
            iterator = select.orderBy.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlOrderByItem orderByIterm = (SqlOrderByItem)iterator.next();
                this.formatExpr(orderByIterm.expr);
                if (orderByIterm.mode == 0) {
                    this.buffer.append(" ASC");
                } else {
                    this.buffer.append(" DESC");
                }
                flag = true;
            }
        }
        if (select.limit != null) {
            if (select.limit.value == 1) {
                this.buffer.append(" FETCH FIRST 1 ROW ONLY");
            } else {
                this.buffer.append(" FETCH FIRST ");
                this.buffer.append(select.limit.value);
                this.buffer.append(" ROWS ONLY");
            }
        }
        if ((optionMap = select.getOptionMapDirect()) != null) {
            if (optionMap.containsKey("FOR UPDATE")) {
                this.buffer.append(" FOR UPDATE");
            }
            if (optionMap.containsKey("FAST")) {
                Integer val = (Integer)optionMap.get("FAST");
                if (val == null) {
                    this.buffer.append(" OPTIMIZE FOR 1 ROW");
                } else {
                    this.buffer.append(" OPTIMIZE FOR ");
                    if (val == 1) {
                        this.buffer.append("1 ROW");
                    } else {
                        this.buffer.append(val);
                        this.buffer.append(" ROWS");
                    }
                }
            }
        }
    }

    @Override
    protected void formatTableSource(SqlTableSourceBase tableSource) throws FormaterException {
        if (tableSource instanceof SqlTableSource) {
            SqlTableSource simpleTableSource = (SqlTableSource)tableSource;
            this.buffer.append(simpleTableSource.name);
            if (simpleTableSource.alias != null && simpleTableSource.alias.length() != 0) {
                this.buffer.append(" ");
                this.buffer.append(simpleTableSource.alias.toUpperCase(Locale.ENGLISH));
            }
        } else if (tableSource instanceof SqlJoinedTableSource) {
            SqlJoinedTableSource joinedTable = (SqlJoinedTableSource)tableSource;
            if (joinedTable.joinType == 4) {
                // empty if block
            }
            this.formatTableSource(joinedTable.left);
            switch (joinedTable.joinType) {
                case 4: {
                    this.buffer.append(", ");
                    break;
                }
                case 3: {
                    this.buffer.append(" FULL OUTER JOIN ");
                    break;
                }
                case 0: {
                    this.buffer.append(" INNER JOIN ");
                    break;
                }
                case 1: {
                    this.buffer.append(" LEFT OUTER JOIN ");
                    break;
                }
                case 2: {
                    this.buffer.append(" RIGHT OUTER JOIN ");
                    break;
                }
                default: {
                    throw new FormaterException("error");
                }
            }
            this.formatTableSource(joinedTable.right);
            if (joinedTable.condition != null) {
                this.buffer.append(" ON ");
                this.formatExpr(joinedTable.condition);
            }
        } else if (tableSource instanceof SqlSubQueryTableSource) {
            SqlSubQueryTableSource subQueryTableSource = (SqlSubQueryTableSource)tableSource;
            this.buffer.append("(");
            this.formatSelectBase(subQueryTableSource.subQuery);
            this.buffer.append(")");
            if (tableSource.alias != null) {
                this.buffer.append(" ");
                this.buffer.append(tableSource.alias.toUpperCase(Locale.ENGLISH));
            }
        } else {
            throw new FormaterException("TODO");
        }
    }

    @Override
    protected void formatDateTimeExpr(SqlDateTimeExpr expr) throws FormaterException {
        if (expr.getYear() < 10) {
            this.buffer.append("'0");
        } else {
            this.buffer.append("'");
        }
        this.buffer.append(expr.getYear());
        if (expr.getMonth() < 10) {
            this.buffer.append("-0");
        } else {
            this.buffer.append("-");
        }
        this.buffer.append(expr.getMonth());
        if (expr.getDate() < 10) {
            this.buffer.append("-0");
        } else {
            this.buffer.append("-");
        }
        this.buffer.append(expr.getDate());
        if (expr.getHour() < 10) {
            this.buffer.append(" 0");
        } else {
            this.buffer.append(" ");
        }
        this.buffer.append(expr.getHour());
        if (expr.getMinute() < 10) {
            this.buffer.append(":0");
        } else {
            this.buffer.append(":");
        }
        this.buffer.append(expr.getMinute());
        if (expr.getSecond() < 10) {
            this.buffer.append(":0");
        } else {
            this.buffer.append(":");
        }
        this.buffer.append(expr.getSecond());
        this.buffer.append("'");
    }

    @Override
    protected void formatColumnDef(SqlColumnDef column) throws FormaterException {
        this.buffer.append(column.name);
        this.buffer.append(" ");
        if (column.dataType.equalsIgnoreCase("DECIMAL")) {
            this.buffer.append("DECIMAL (");
            this.buffer.append(column.precision);
            this.buffer.append(", ");
            this.buffer.append(column.scale);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("TINYINT")) {
            this.buffer.append("SMALLINT");
        } else if (column.dataType.equalsIgnoreCase("INT") || column.dataType.equalsIgnoreCase("INTEGER")) {
            this.buffer.append("INTEGER");
        } else if (column.dataType.equalsIgnoreCase("DATETIME")) {
            this.buffer.append("TIMESTAMP");
        } else if (column.dataType.equalsIgnoreCase("VARCHAR")) {
            this.buffer.append("CHARACTER VARYING (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("NVARCHAR")) {
            this.buffer.append("NVARCHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("CHAR")) {
            this.buffer.append("CHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("NCHAR")) {
            this.buffer.append("NCHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("CLOB")) {
            this.buffer.append("CLOB (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("NCLOB")) {
            this.buffer.append("CLOB (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("BINARY")) {
            this.buffer.append("BYTE (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("BLOB")) {
            this.buffer.append("BLOB (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("VARBINARY")) {
            this.buffer.append("VARCHAR (");
            this.buffer.append(column.length);
            this.buffer.append(") FOR BIT DATA");
        } else {
            this.buffer.append(column.dataType);
        }
        if (column.allowNull != null && column.allowNull == Boolean.TRUE) {
            if (!column.isPrimaryKey) {
                // empty if block
            }
        } else if (column.allowNull != null && column.allowNull == Boolean.FALSE) {
            this.buffer.append(" NOT NULL");
        }
        if (column.defaultValueExpr != null) {
            this.buffer.append(" DEFAULT ");
            this.formatExpr(column.defaultValueExpr);
        }
        if (column.containtName != null && column.containtName.length() != 0) {
            this.validConstraintName(column.containtName);
            this.buffer.append(" CONSTRAINT ");
            this.buffer.append(column.containtName);
        }
        if (column.isPrimaryKey) {
            this.buffer.append(" PRIMARY KEY");
        }
        if (column.isUnique) {
            this.buffer.append(" UNIQUE");
        }
        if (column.checkExpr != null) {
            this.buffer.append(" CHECK (");
            this.formatExpr(column.checkExpr);
            this.buffer.append(")");
        }
    }

    @Override
    protected void formatPriorIdentifierExpr(SqlPriorIdentifierExpr expr) throws FormaterException {
        this.buffer.append("KSQL_SUB_TABLE.");
        this.buffer.append(expr.value);
    }

    @Override
    protected void formatBinaryOpExpr(SqlBinaryOpExpr expr, boolean appendBrace) throws FormaterException {
        if (expr.operator == 21) {
            this.buffer.append("MOD (");
            this.formatExpr(expr.left);
            this.buffer.append(", ");
            this.formatExpr(expr.right);
            this.buffer.append(")");
            return;
        }
        if (expr.operator == 13) {
            this.buffer.append("(");
            this.formatExpr(expr.left);
            this.buffer.append(" IS NULL)");
            return;
        }
        if (expr.operator == 41) {
            this.buffer.append("(");
            this.formatExpr(expr.left);
            this.buffer.append(" IS NOT NULL)");
            return;
        }
        if (expr.operator == 20) {
            this.formatExpr(expr.left);
            this.buffer.append(".");
            this.formatExpr(expr.right);
            return;
        }
        if (expr.operator == 43) {
            this.formatExpr(expr.left, false);
            this.buffer.append(" ESCAPE ");
            this.formatExpr(expr.right, false);
            return;
        }
        if (expr.operator == 0) {
            if (appendBrace) {
                this.buffer.append("(");
            }
            if (expr.left instanceof SqlBinaryOpExpr) {
                SqlBinaryOpExpr binaryOpLeft = (SqlBinaryOpExpr)expr.left;
                if (binaryOpLeft.operator == 0) {
                    this.formatExpr(binaryOpLeft, false);
                } else {
                    this.formatExpr(binaryOpLeft);
                }
            } else {
                this.formatExpr(expr.left);
            }
            this.buffer.append(" + ");
            if (expr.right instanceof SqlBinaryOpExpr) {
                SqlBinaryOpExpr binaryOpRight = (SqlBinaryOpExpr)expr.right;
                if (binaryOpRight.operator == 0) {
                    this.formatExpr(binaryOpRight, false);
                } else {
                    this.formatExpr(binaryOpRight);
                }
            } else {
                this.formatExpr(expr.right);
            }
            if (appendBrace) {
                this.buffer.append(")");
            }
            return;
        }
        if (expr.operator == 8) {
            if (appendBrace) {
                this.buffer.append("(");
            }
            ArrayList<SqlExpr> list = new ArrayList<SqlExpr>();
            SqlExpr sqlExpr = expr;
            while (sqlExpr != null || !list.isEmpty()) {
                while (sqlExpr != null) {
                    if (!(sqlExpr instanceof SqlBinaryOpExpr)) {
                        this.formatExpr(sqlExpr);
                        sqlExpr = null;
                        continue;
                    }
                    SqlBinaryOpExpr sqlBExpr = sqlExpr;
                    if (sqlBExpr.operator == 8) {
                        if (sqlBExpr.left instanceof SqlBinaryOpExpr) {
                            SqlBinaryOpExpr binaryOpLeft = (SqlBinaryOpExpr)sqlBExpr.left;
                            if (binaryOpLeft.operator == 8) {
                                list.add(sqlBExpr.right);
                                sqlExpr = binaryOpLeft;
                                continue;
                            }
                            this.formatExpr(binaryOpLeft);
                            this.buffer.append(" OR ");
                            sqlExpr = sqlBExpr.right;
                            continue;
                        }
                        this.formatExpr(sqlBExpr.left);
                        this.buffer.append(" OR ");
                        sqlExpr = sqlBExpr.right;
                        continue;
                    }
                    this.formatExpr(sqlExpr);
                    sqlExpr = null;
                }
                if (list.isEmpty()) continue;
                this.buffer.append(" OR ");
                sqlExpr = (SqlExpr)list.remove(list.size() - 1);
            }
            if (appendBrace) {
                this.buffer.append(")");
            }
            return;
        }
        if (expr.operator == 42) {
            this.buffer.append("CONCAT(");
            this.formatExpr(expr.left);
            this.buffer.append(", ");
            this.formatExpr(expr.right);
            this.buffer.append(")");
            return;
        }
        if (expr.operator == 10) {
            this.formatExpr(expr.left);
            this.buffer.append(" = ");
            this.formatExpr(expr.right);
            return;
        }
        if (appendBrace) {
            this.buffer.append("(");
        }
        this.formatExpr(expr.left);
        switch (expr.operator) {
            case 0: {
                this.buffer.append(" + ");
                break;
            }
            case 1: {
                this.buffer.append(" AS ");
                break;
            }
            case 2: {
                this.buffer.append(" = ");
                break;
            }
            case 3: {
                throw new FormaterException("not support");
            }
            case 4: {
                throw new FormaterException("not support");
            }
            case 5: {
                throw new FormaterException("not support");
            }
            case 7: {
                this.buffer.append(" AND ");
                break;
            }
            case 8: {
                this.buffer.append(" OR ");
                break;
            }
            case 9: {
                this.buffer.append(" / ");
                break;
            }
            case 10: {
                this.buffer.append(" = ");
                break;
            }
            case 11: {
                this.buffer.append(" > ");
                break;
            }
            case 12: {
                this.buffer.append(" >= ");
                break;
            }
            case 17: {
                throw new FormaterException("not support");
            }
            case 14: {
                this.buffer.append(" < ");
                break;
            }
            case 15: {
                this.buffer.append(" <= ");
                break;
            }
            case 16: {
                this.buffer.append(" <> ");
                break;
            }
            case 18: {
                this.buffer.append(" LIKE ");
                break;
            }
            case 20: {
                this.buffer.append(".");
                break;
            }
            case 21: {
                this.buffer.append(" % ");
                break;
            }
            case 22: {
                this.buffer.append(" * ");
                break;
            }
            case 23: {
                this.buffer.append(" != ");
                break;
            }
            case 25: {
                this.buffer.append(" !> ");
                break;
            }
            case 24: {
                this.buffer.append(" !< ");
                break;
            }
            case 40: {
                this.buffer.append(" NOT LIKE ");
                break;
            }
            case 19: {
                this.buffer.append(" >> ");
                break;
            }
            case 26: {
                this.buffer.append(" - ");
                break;
            }
            case 27: {
                this.buffer.append(" UNION ");
                break;
            }
            default: {
                throw new FormaterException("not support");
            }
        }
        this.formatExpr(expr.right);
        if (appendBrace) {
            this.buffer.append(")");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void formatMethodInvokeExpr(SqlMethodInvokeExpr expr) throws FormaterException {
        String methodNameI;
        if (expr.owner != null) {
            this.formatExpr(expr.owner);
            this.buffer.append('.');
        }
        if ((methodNameI = expr.methodName.toUpperCase(Locale.ENGLISH)).compareTo("ABS") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("ABS(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ACOS") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("ACOS(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ASIN") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("ASIN(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ATAN") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("ATAN(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ATN2") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("ATAN2(");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        } else {
            if (methodNameI.compareTo("CEILING") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("CEILING(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("COS") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("COS(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("EXP") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("EXP(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("FLOOR") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("FLOOR(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("MOD") == 0) {
                if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                this.buffer.append("MOD(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("LOG") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("LOG(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("POWER") == 0) {
                if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                this.buffer.append("POWER(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("ROUND") == 0) {
                if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                this.buffer.append("ROUND(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("SIGN") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("SIGN(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("SIN") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("SIN(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("SQRT") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("SQRT(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("TAN") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("TAN(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("ASCII") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("ASCII(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("CHAR") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("CHR(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("CHARINDEX") == 0) {
                if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                this.buffer.append("LOCATE(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("CONCAT") == 0) {
                if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                this.buffer.append("CONCAT(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("LEFT") == 0) {
                if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                this.buffer.append("LEFT(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("LEN") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("LENGTH(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("LENGTH") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("LENGTH(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("LOWER") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("LCASE(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("LCASE") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("LCASE(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("LTRIM") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("LTRIM(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("REPLACE") == 0) {
                if (expr.parameters.size() != 3) throw new FormaterException("ERROR");
                this.buffer.append("REPLACE(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(2));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("RIGHT") == 0) {
                if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                this.buffer.append("RIGHT(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("RTRIM") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("RTRIM(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("SOUNDEX") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("SOUNDEX(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("SUBSTRING") == 0) {
                if (expr.parameters.size() != 3) throw new FormaterException("ERROR");
                this.buffer.append("SUBSTR(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(2));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("TRIM") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("LTRIM(RTRIM(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append("))");
                return;
            }
            if (methodNameI.compareTo("UCASE") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("UCASE(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("UPPER") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("UCASE(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("CONVERT") == 0) {
                if (!(expr.parameters.get(0) instanceof SqlIdentifierExpr)) return;
                String targetTypeName = ((SqlIdentifierExpr)expr.parameters.get((int)0)).value;
                if (targetTypeName.compareToIgnoreCase("DATETIME") == 0) {
                    this.buffer.append("TIMESTAMP(");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(")");
                    return;
                }
                if (targetTypeName.compareToIgnoreCase("VARCHAR") != 0) throw new FormaterException("TODO");
                this.buffer.append("CHAR(");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("CURDATE") == 0) {
                if (expr.parameters.size() != 0) throw new FormaterException("ERROR");
                this.buffer.append("CURRENT DATE");
                return;
            }
            if (methodNameI.compareTo("CURTIME") == 0) {
                if (expr.parameters.size() != 0) throw new FormaterException("ERROR");
                this.buffer.append("CHAR(CURRENT TIME)");
                return;
            }
            if (methodNameI.compareTo("DATEADD") == 0) {
                if (expr.parameters.size() == 2) {
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(" + ");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(" SECOND");
                    return;
                }
                if (expr.parameters.size() != 3) throw new FormaterException("ERROR");
                SqlExpr datepartExpr = (SqlExpr)expr.parameters.get(0);
                if (!(datepartExpr instanceof SqlIdentifierExpr)) return;
                String datepart = ((SqlIdentifierExpr)datepartExpr).value;
                if (datepart == null || datepart.length() == 0) {
                    throw new FormaterException("illegal datepart.");
                }
                if ("YEAR".equals(datepart = datepart.toUpperCase(Locale.ENGLISH)) || "YY".equals(datepart) || "YYYY".equals(datepart)) {
                    this.formatExpr((SqlExpr)expr.parameters.get(2));
                    this.buffer.append(" + ");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(" YEAR");
                    return;
                }
                if ("MONTH".equals(datepart) || "MM".equals(datepart) || "M".equals(datepart)) {
                    this.formatExpr((SqlExpr)expr.parameters.get(2));
                    this.buffer.append(" + ");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(" MONTH");
                    return;
                }
                if ("DAY".equals(datepart) || "DD".equals(datepart) || "D".equals(datepart)) {
                    this.formatExpr((SqlExpr)expr.parameters.get(2));
                    this.buffer.append(" + ");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(" DAY");
                    return;
                } else if ("HOUR".equals(datepart) || "HH".equals(datepart)) {
                    this.formatExpr((SqlExpr)expr.parameters.get(2));
                    this.buffer.append(" + ");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(" HOUR");
                    return;
                } else if ("MINUTE".equals(datepart) || "MI".equals(datepart) || "N".equals(datepart)) {
                    this.formatExpr((SqlExpr)expr.parameters.get(2));
                    this.buffer.append(" + ");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(" MINUTE");
                    return;
                } else {
                    if (!"SECOND".equals(datepart) && !"SS".equals(datepart) && !"S".equals(datepart)) throw new FormaterException("TODO");
                    this.formatExpr((SqlExpr)expr.parameters.get(2));
                    this.buffer.append(" + ");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(" SECOND");
                }
                return;
            } else {
                if (methodNameI.compareTo("DATEDIFF") == 0) {
                    if (expr.parameters.size() == 2) {
                        this.buffer.append("DAYS(");
                        this.formatExpr((SqlExpr)expr.parameters.get(1));
                        this.buffer.append(") - DAYS(");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(") * 60 * 60 * 24 + MIDNIGHT_SECONDS(");
                        this.formatExpr((SqlExpr)expr.parameters.get(1));
                        this.buffer.append(") - MIDNIGHT_SECONDS(");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(")");
                        return;
                    }
                    if (expr.parameters.size() != 3) return;
                    if (expr.parameters.size() != 3) throw new FormaterException("ERROR");
                    SqlExpr datepartExpr = (SqlExpr)expr.parameters.get(0);
                    if (!(datepartExpr instanceof SqlIdentifierExpr)) throw new FormaterException("illegal datepart.");
                    String datepart = ((SqlIdentifierExpr)datepartExpr).value;
                    if (datepart == null || datepart.length() == 0) {
                        throw new FormaterException("illegal datepart.");
                    }
                    if ("YEAR".equals(datepart = datepart.toUpperCase(Locale.ENGLISH)) || "YY".equals(datepart) || "YYYY".equals(datepart)) {
                        this.buffer.append("(YEAR(");
                        this.formatExpr((SqlExpr)expr.parameters.get(2));
                        this.buffer.append(") - YEAR(");
                        this.formatExpr((SqlExpr)expr.parameters.get(1));
                        this.buffer.append("))");
                        return;
                    }
                    if ("MONTH".equals(datepart) || "MM".equals(datepart) || "M".equals(datepart)) {
                        this.buffer.append("((YEAR(");
                        this.formatExpr((SqlExpr)expr.parameters.get(2));
                        this.buffer.append(") - YEAR(");
                        this.formatExpr((SqlExpr)expr.parameters.get(1));
                        this.buffer.append(")) * 12 + MONTH(");
                        this.formatExpr((SqlExpr)expr.parameters.get(2));
                        this.buffer.append(") - MONTH(");
                        this.formatExpr((SqlExpr)expr.parameters.get(1));
                        this.buffer.append("))");
                        return;
                    }
                    if ("DAY".equals(datepart) || "DD".equals(datepart) || "D".equals(datepart)) {
                        this.buffer.append("(DAYS (");
                        this.formatExpr((SqlExpr)expr.parameters.get(2));
                        this.buffer.append(") - DAYS (");
                        this.formatExpr((SqlExpr)expr.parameters.get(1));
                        this.buffer.append("))");
                        return;
                    }
                    if ("HOUR".equals(datepart) || "HH".equals(datepart)) {
                        this.buffer.append("((DAYS (");
                        this.formatExpr((SqlExpr)expr.parameters.get(2));
                        this.buffer.append(") - DAYS (");
                        this.formatExpr((SqlExpr)expr.parameters.get(1));
                        this.buffer.append(")) * 24)");
                        return;
                    }
                    if ("MINUTE".equals(datepart) || "MI".equals(datepart) || "N".equals(datepart)) {
                        this.buffer.append("((DAYS (");
                        this.formatExpr((SqlExpr)expr.parameters.get(2));
                        this.buffer.append(") - DAYS (");
                        this.formatExpr((SqlExpr)expr.parameters.get(1));
                        this.buffer.append(")) * 24 * 60)");
                        return;
                    }
                    if (!"SECOND".equals(datepart) && !"SS".equals(datepart) && !"S".equals(datepart)) throw new FormaterException("TODO");
                    this.buffer.append("((DAYS (");
                    this.formatExpr((SqlExpr)expr.parameters.get(2));
                    this.buffer.append(") - DAYS (");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(")) * 24 * 60 * 60)");
                    return;
                }
                if (methodNameI.compareTo("DAYNAME") == 0) {
                    if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                    this.buffer.append("DAYNAME(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(")");
                    return;
                }
                if (methodNameI.compareTo("DAYOFMONTH") == 0) {
                    if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                    this.buffer.append("DAY(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(")");
                    return;
                }
                if (methodNameI.compareTo("DAYOFWEEK") == 0) {
                    if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                    this.buffer.append("DAYOFWEEK(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(")");
                    return;
                }
                if (methodNameI.compareTo("DAYOFYEAR") == 0) {
                    if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                    this.buffer.append("DAYOFYEAR(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(")");
                    return;
                }
                if (methodNameI.compareTo("GETDATE") == 0) {
                    if (expr.parameters.size() != 0) throw new FormaterException("ERROR");
                    this.buffer.append("CURRENT TIMESTAMP");
                    return;
                }
                if (methodNameI.compareTo("HOUR") == 0) {
                    if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                    this.buffer.append("HOUR(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(")");
                    return;
                }
                if (methodNameI.compareTo("MINUTE") == 0) {
                    if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                    this.buffer.append("MINUTE(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(")");
                    return;
                }
                if (methodNameI.compareTo("MONTH") == 0) {
                    if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                    this.buffer.append("MONTH(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(")");
                    return;
                }
                if (methodNameI.compareTo("MONTHNAME") == 0) {
                    if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                    this.buffer.append("MONTHNAME(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(")");
                    return;
                }
                if (methodNameI.compareTo("NOW") == 0) {
                    if (expr.parameters.size() != 0) throw new FormaterException("ERROR");
                    this.buffer.append("CURRENT TIMESTAMP");
                    return;
                }
                if (methodNameI.compareTo("QUARTER") == 0) {
                    if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                    this.buffer.append("QUARTER(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(")");
                    return;
                }
                if (methodNameI.compareTo("SECOND") == 0) {
                    if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                    this.buffer.append("SECOND(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(")");
                    return;
                }
                if (methodNameI.compareTo("WEEK") == 0) {
                    if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                    this.buffer.append("WEEK(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(")");
                    return;
                }
                if (methodNameI.compareTo("YEAR") == 0) {
                    if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                    this.buffer.append("YEAR(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(")");
                    return;
                }
                if (methodNameI.compareTo("TO_DATE") == 0) {
                    if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                    this.buffer.append("DATE(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(")");
                    return;
                }
                if (methodNameI.compareTo("MONTHS_BETWEEN") == 0) {
                    if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                    this.buffer.append("((YEAR(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(") - YEAR(");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(")) * 12 +");
                    this.buffer.append("MONTH(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(") - MONTH(");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append("))");
                    return;
                }
                if (methodNameI.compareTo("ADD_MONTHS") == 0) {
                    if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                    this.buffer.append("(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(" + ");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(" MONTH)");
                    return;
                }
                if (methodNameI.compareTo("ADD_YEARS") == 0) {
                    if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                    this.buffer.append("(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(" + ");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(" YEAR)");
                    return;
                }
                if (methodNameI.compareTo("ADD_DAYS") == 0) {
                    if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                    this.buffer.append("(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(" + ");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(" DAY)");
                    return;
                }
                if (methodNameI.compareTo("ADD_HOURS") == 0) {
                    if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                    this.buffer.append("(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(" + ");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(" HOUR)");
                    return;
                }
                if (methodNameI.compareTo("ADD_MINUTES") == 0) {
                    if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                    this.buffer.append("(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(" + ");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(" MINUTE)");
                    return;
                }
                if (methodNameI.compareTo("ADD_SECONDS") == 0) {
                    if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                    this.buffer.append("(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(" + ");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(" SECOND)");
                    return;
                }
                if (methodNameI.compareTo("ASCII") == 0) {
                    if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                    this.buffer.append("ASCII(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(")");
                    return;
                }
                if (methodNameI.compareTo("CHAR") == 0) {
                    if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                    this.buffer.append("CHAR(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(")");
                    return;
                }
                if (methodNameI.compareTo("CHARINDEX") == 0) {
                    if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                    this.buffer.append("LOCATE(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(", ");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(")");
                    return;
                }
                if (methodNameI.compareTo("CONCAT") == 0) {
                    if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                    this.buffer.append("CONCAT(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(", ");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(")");
                    return;
                }
                if (methodNameI.compareTo("LEFT") == 0) {
                    if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                    this.buffer.append("LEFT(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(")");
                    return;
                }
                if (methodNameI.compareTo("LEN") == 0) {
                    if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                    this.buffer.append("LENGTH(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(")");
                    return;
                }
                if (methodNameI.compareTo("LENGTH") == 0) {
                    if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                    this.buffer.append("LENGTH(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(")");
                    return;
                }
                if (methodNameI.compareTo("LOWER") == 0) {
                    if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                    this.buffer.append("LCASE(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(")");
                    return;
                }
                if (methodNameI.compareTo("LCASE") == 0) {
                    if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                    this.buffer.append("LCASE(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(")");
                    return;
                }
                if (methodNameI.compareTo("LTRIM") == 0) {
                    if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                    this.buffer.append("LTRIM(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(")");
                    return;
                }
                if (methodNameI.compareTo("REPLACE") == 0) {
                    if (expr.parameters.size() != 3) throw new FormaterException("ERROR");
                    this.buffer.append("REPLACE(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(", ");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(", ");
                    this.formatExpr((SqlExpr)expr.parameters.get(2));
                    this.buffer.append(")");
                    return;
                }
                if (methodNameI.compareTo("RIGHT") == 0) {
                    if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                    this.buffer.append("RIGHT(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(")");
                    return;
                }
                if (methodNameI.compareTo("RTRIM") == 0) {
                    if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                    this.buffer.append("RTRIM(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(")");
                    return;
                }
                if (methodNameI.compareTo("SOUNDEX") == 0) {
                    if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                    this.buffer.append("SOUNDEX(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(")");
                    return;
                }
                if (methodNameI.compareTo("SUBSTRING") == 0) {
                    if (expr.parameters.size() != 3) throw new FormaterException("ERROR");
                    this.buffer.append("SUBSTRING(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(", ");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(", ");
                    this.formatExpr((SqlExpr)expr.parameters.get(2));
                    this.buffer.append(")");
                    return;
                }
                if (methodNameI.compareTo("TRIM") == 0) {
                    if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                    this.buffer.append("LTRIM(RTRIM(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append("))");
                    return;
                }
                if (methodNameI.compareTo("UCASE") == 0) {
                    if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                    this.buffer.append("UCASE(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(")");
                    return;
                }
                if (methodNameI.compareTo("UPPER") == 0) {
                    if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                    this.buffer.append("UCASE(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(")");
                    return;
                }
                if (methodNameI.compareTo("ISNULL") == 0) {
                    if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                    this.buffer.append("COALESCE(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(", ");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(")");
                    return;
                }
                if (methodNameI.compareTo("NULLIF") == 0) {
                    if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                    this.buffer.append("NULLIF(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(", ");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(")");
                    return;
                }
                if (methodNameI.compareTo("TOCHAR") == 0 || methodNameI.compareTo("TO_CHAR") == 0) {
                    if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                    this.buffer.append("LTRIM(RTRIM(CHAR(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(")))");
                    return;
                }
                if (methodNameI.compareTo("TO_NUMBER") == 0 || methodNameI.compareTo("DOUBLE") == 0) {
                    if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                    this.buffer.append("DOUBLE(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(")");
                    return;
                }
                if (methodNameI.compareTo("TO_INTEGER") == 0 || methodNameI.compareTo("INT") == 0 || methodNameI.compareTo("INTEGER") == 0) {
                    if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                    this.buffer.append("FLOOR(DOUBLE(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append("))");
                    return;
                }
                if (methodNameI.compareTo("NEWID") == 0) {
                    if (expr.parameters.size() != 0) throw new FormaterException("ERROR");
                    throw new FormaterException("TODO");
                }
                this.formeatUnkownMethodInvokeExpr(expr);
            }
        }
    }

    @Override
    protected void formatBlockStmt(SqlBlockStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatSetLocalVariantStmt(SqlSetLocalVariantStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatIfStmt(SqlIfStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatWhileStmt(SqlWhileStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatDeallocateStmt(SqlDeallocateStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatCloseStmt(SqlCloseStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatOpenStmt(SqlOpenStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatCursorLoopStmt(SqlCursorLoopStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatFetchStmt(SqlFetchStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatBreakStmt(SqlBreakStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatContinueStmt(SqlContinueStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatGotoStmt(SqlGotoStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatLabelStmt(SqlLabelStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    protected final void formatTableConstraintList(Collection constraintList) throws FormaterException {
        for (SqlTableConstraint constraint : constraintList) {
            this.buffer.append(", ");
            this.formatTableConstraint(constraint);
        }
    }

    protected void formatTableConstraint(SqlTableConstraint constraint) throws FormaterException {
        this.validConstraintName(constraint.name);
        if (constraint.name != null && constraint.name.length() != 0) {
            this.buffer.append("CONSTRAINT ");
            this.buffer.append(constraint.name);
        }
        if (constraint instanceof SqlTablePrimaryKey) {
            SqlTablePrimaryKey primaryKey = (SqlTablePrimaryKey)constraint;
            if (primaryKey.clustered) {
                this.buffer.append(" PRIMARY KEY (");
            } else {
                this.buffer.append(" PRIMARY KEY (");
            }
            boolean flag = false;
            Iterator iterator = primaryKey.columnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                String columnName = (String)iterator.next();
                this.buffer.append(columnName);
                flag = true;
            }
            this.buffer.append(")");
        } else if (constraint instanceof SqlTableUnique) {
            SqlTableUnique unique = (SqlTableUnique)constraint;
            if (unique.clustered) {
                this.buffer.append(" UNIQUE CLUSTERED (");
            } else {
                this.buffer.append(" UNIQUE (");
            }
            boolean flag = false;
            Iterator iterator = unique.columnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                String columnName = (String)iterator.next();
                this.buffer.append(columnName);
                flag = true;
            }
            this.buffer.append(")");
        } else if (constraint instanceof SqlTableUnique) {
            SqlTableUnique unique = (SqlTableUnique)constraint;
            this.buffer.append(" UNIQUE (");
            boolean flag = false;
            Iterator iterator = unique.columnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                String columnName = (String)iterator.next();
                this.buffer.append(columnName);
                flag = true;
            }
            this.buffer.append(")");
        } else if (constraint instanceof SqlTableForeignKey) {
            SqlTableForeignKey foreignKey = (SqlTableForeignKey)constraint;
            this.buffer.append(" FOREIGN KEY (");
            boolean flag = false;
            Iterator iterator = foreignKey.columnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                String columnName = (String)iterator.next();
                this.buffer.append(columnName);
                flag = true;
            }
            this.buffer.append(")");
            this.buffer.append(" REFERENCES ");
            this.buffer.append(foreignKey.refTableName);
            this.buffer.append(" (");
            flag = false;
            iterator = foreignKey.refColumnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                String refColumnName = (String)iterator.next();
                this.buffer.append(refColumnName);
                flag = true;
            }
            this.buffer.append(")");
        } else if (constraint instanceof SqlTableCheck) {
            SqlTableCheck check = (SqlTableCheck)constraint;
            this.buffer.append(" CHECK (");
            this.formatExpr(check.expr, false);
            this.buffer.append(")");
        } else {
            throw new FormaterException("TODO");
        }
    }
}

