/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sql.formater;

import com.kingdee.bos.sql.DbType;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.sql.formater.DB2AS400SQLFormater;
import com.kingdee.bos.sql.formater.DB2SQLFormater;
import com.kingdee.bos.sql.formater.DMSQLFormater;
import com.kingdee.bos.sql.formater.DerbySQLFormater;
import com.kingdee.bos.sql.formater.GaussDBSQLFormater;
import com.kingdee.bos.sql.formater.KingbaseSQLFormater;
import com.kingdee.bos.sql.formater.MSTransactSQLFormater;
import com.kingdee.bos.sql.formater.MySQLFormater;
import com.kingdee.bos.sql.formater.Oracle10SQLFormater;
import com.kingdee.bos.sql.formater.Oracle9SQLFormater;
import com.kingdee.bos.sql.formater.OracleSQLFormater;
import com.kingdee.bos.sql.formater.PostgresSQLFormater;
import com.kingdee.bos.sql.formater.SQLFormater;
import com.kingdee.bos.sql.formater.SybaseTransactSQLFormater;

public abstract class FormaterFactory {
    public static SQLFormater getFormater(int dbType) throws SqlTranslateException {
        switch (dbType) {
            case 9: {
                return new DB2AS400SQLFormater();
            }
            case 1: {
                return new DB2SQLFormater();
            }
            case 6: {
                return new MySQLFormater();
            }
            case 3: {
                return new MSTransactSQLFormater();
            }
            case 2: {
                return new OracleSQLFormater();
            }
            case 8: {
                return new Oracle10SQLFormater();
            }
            case 7: {
                return new Oracle9SQLFormater();
            }
            case 5: {
                return new PostgresSQLFormater();
            }
            case 4: {
                return new SybaseTransactSQLFormater();
            }
            case 10: {
                return new DerbySQLFormater();
            }
            case 11: {
                return new DMSQLFormater();
            }
            case 12: {
                return new KingbaseSQLFormater();
            }
            case 13: {
                return new GaussDBSQLFormater();
            }
        }
        throw new SqlTranslateException("DbType is not supported." + DbType.getName(dbType));
    }
}

