/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sql.formater;

import com.kingdee.bos.sql.dom.KHint;
import com.kingdee.bos.sql.dom.SqlObject;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.bos.sql.formater.Hints;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class OracleHints
implements Hints {
    protected Map hints = new HashMap();

    protected void newHint(String name) {
        this.newHint(name, name, 1, 0, 0);
    }

    protected void newHint(String name, int minParamSize, int maxParamSize) {
        this.newHint(name, name, 1, minParamSize, maxParamSize);
    }

    protected void newHint(String name, int type, int minParamSize, int maxParamSize) {
        OraHint hint = new OraHint(name, name, type, minParamSize, maxParamSize);
        this.hints.put(name, hint);
    }

    protected void newHint(String name, String value, int type, int minParamSize, int maxParamSize) {
        OraHint hint = new OraHint(name, value, type, minParamSize, maxParamSize);
        this.hints.put(name, hint);
    }

    protected OracleHints() {
        this.newHint("ALL_ROWS");
        this.newHint("APPEND", 8, 0, 0);
        this.newHint("BYPASS_UJVC");
        this.newHint("CACHE", 1, -1);
        this.newHint("CLUSTER", 1, -1);
        this.newHint("CURSOR_SHARING_EXACT");
        this.newHint("DRIVING_SITE", 1, -1);
        this.newHint("DYNAMIC_SAMPLING", 1, -1);
        this.newHint("FACT", 1, -1);
        this.newHint("FIRST_ROWS", 1, 1);
        this.newHint("FULL", 1, -1);
        this.newHint("HASH", 1, -1);
        this.newHint("INDEX", 1, -1);
        this.newHint("INDEX_ASC", 1, -1);
        this.newHint("INDEX_COMBINE", 1, -1);
        this.newHint("INDEX_DESC", 1, -1);
        this.newHint("INDEX_FFS", 1, -1);
        this.newHint("INDEX_JOIN", 1, -1);
        this.newHint("INDEX_SS", 1, -1);
        this.newHint("INDEX_SS_ASC", 1, -1);
        this.newHint("INDEX_SS_DESC", 1, -1);
        this.newHint("LEADING", 1, -1);
        this.newHint("MERGE", 17, 0, -1);
        this.newHint("MODEL_MIN_ANALYSIS");
        this.newHint("NOAPPEND");
        this.newHint("NOCACHE", 1, -1);
        this.newHint("NO_EXPAND", 0, 1);
        this.newHint("NO_FACT", 1, -1);
        this.newHint("NO_INDEX", 1, -1);
        this.newHint("NO_INDEX_FFS", 1, -1);
        this.newHint("NO_INDEX_SS", 1, -1);
        this.newHint("NO_MERGE", 0, -1);
        this.newHint("NO_PARALLEL_INDEX", 1, -1);
        this.newHint("NO_PUSH_PRED", 0, -1);
        this.newHint("NO_PUSH_SUBQ", 0, 1);
        this.newHint("NO_PX_JOIN_FILTER", 1, -1);
        this.newHint("NO_REWRITE", 0, 1);
        this.newHint("NO_QUERY_TRANSFORMATION");
        this.newHint("NO_STAR_TRANSFORMATION", 0, 1);
        this.newHint("NO_UNNEST", 0, 1);
        this.newHint("NO_USE_HASH", 1, -1);
        this.newHint("NO_USE_MERGE", 1, -1);
        this.newHint("NO_USE_NL", 1, -1);
        this.newHint("NO_XML_QUERY_REWRITE");
        this.newHint("ORDERED");
        this.newHint("PARALLEL", 31, 1, -1);
        this.newHint("PARALLEL_INDEX", 1, -1);
        this.newHint("PUSH_PRED", 1, -1);
        this.newHint("PX_JOIN_FILTER", 1, -1);
        this.newHint("QB_NAME", 1, 1);
        this.newHint("REWRITE", 0, -1);
        this.newHint("STAR_TRANSFORMATION", 0, 1);
        this.newHint("UNNEST", 0, 1);
        this.newHint("USE_CONCAT", 0, 1);
        this.newHint("USE_HASH", 1, -1);
        this.newHint("USE_MERGE", 1, -1);
        this.newHint("USE_NL", 1, -1);
        this.newHint("USE_NL_WITH_INDEX");
    }

    @Override
    public String formatHints(List hints, SqlObject sql) throws FormaterException {
        if (hints == null || hints.isEmpty()) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("/*+ ");
        StringBuffer msg = new StringBuffer();
        for (int i = 0; i < hints.size(); ++i) {
            KHint hint = (KHint)hints.get(i);
            if (!this.checkHint(hint, msg)) {
                throw new FormaterException(msg.toString());
            }
            this.output(hint, buffer);
            buffer.append(" ");
        }
        buffer.deleteCharAt(buffer.length() - 1);
        buffer.append("*/ ");
        return buffer.toString();
    }

    @Override
    public void formatHints(List hints, SqlObject sql, StringBuffer buffer) throws FormaterException {
        buffer.append(this.formatHints(hints, sql));
    }

    public boolean checkHint(KHint hint, StringBuffer sb) {
        if (hint == null) {
            sb.append("Hint is null");
            return false;
        }
        String name = hint.getName().toUpperCase();
        OraHint oraHint = (OraHint)this.hints.get(name);
        if (oraHint == null) {
            sb.append("Not supported oracle hint : " + hint.getName());
            return false;
        }
        int pSize = hint.getParameters().size();
        if (pSize > oraHint.maxParamSize && oraHint.maxParamSize >= 0) {
            sb.append("Parameter size Eorror for hint:" + hint.getName() + " Expect max parameters size is: " + oraHint.maxParamSize + ", but found " + pSize + " parameters");
            return false;
        }
        if (pSize < oraHint.minParamSize) {
            sb.append("Parameter size Eorror for hint:" + hint.getName() + ".Expect min parameters size is: " + oraHint.minParamSize + ", but found " + pSize + " parameters");
            return false;
        }
        return true;
    }

    public void output(KHint hint, StringBuffer buffer) {
        this.output(hint, buffer, true);
    }

    public void output(KHint hint, StringBuffer buffer, boolean flag) {
        OraHint oraHint = (OraHint)this.hints.get(hint.getName().toUpperCase());
        if (flag) {
            buffer.append(oraHint.value);
        } else {
            buffer.append(hint.getOrgName());
        }
        if (!hint.getParameters().isEmpty()) {
            buffer.append("(");
            for (int i = 0; i < hint.getParameters().size(); ++i) {
                if (i > 0) {
                    buffer.append(" ");
                }
                buffer.append(hint.getParameters().get(i).toString().trim());
            }
            buffer.append(")");
        }
    }

    private static class OraHint {
        public String name;
        public String value;
        public int maxParamSize = -1;
        public int minParamSize = 0;
        public int type = 1;

        public OraHint(String name, String value, int type, int minParamSize, int maxParamSize) {
            this.name = name.toUpperCase();
            this.value = value.toUpperCase();
            this.type = type;
            this.minParamSize = minParamSize;
            this.maxParamSize = maxParamSize;
        }
    }
}

