/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util;

import com.kingdee.bos.invokecounter.SQLPlanCounter;
import com.kingdee.bos.sql.shell.trace.LogItem;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class WriteSQLPlanThread {
    private static BlockingQueue blockingQueue = new LinkedBlockingQueue();
    private static ExecutorService executorService = Executors.newFixedThreadPool(2);
    private static volatile boolean run = true;
    private static final Logger logger = Logger.getLogger(WriteSQLPlanThread.class);

    private static void start() {
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                while (run) {
                    logger.info((Object)("size------------" + blockingQueue.size()));
                    try {
                        LogItem logItem = WriteSQLPlanThread.takeLogItem();
                        if (logItem == null) continue;
                        WriteSQLPlanThread.saveSqlPlan(logItem, "sqlplan" + logItem.sqlplan_id + ".log");
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                }
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                WriteSQLPlanThread.stop();
            }
        }));
    }

    private static void stop() {
        run = false;
        executorService.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveSqlPlan(LogItem logItem, String fileName) throws Exception {
        if (logItem == null) {
            return;
        }
        String logPlan = SQLPlanCounter.getLogPlan((LogItem)logItem);
        if (logPlan != null) {
            File file = null;
            try (OutputStreamWriter fileWriter = null;){
                file = new File(System.getProperty("EAS_SERVERWORKSPACE") + File.separator + "tmp-sqlplan-files" + File.separator + fileName);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                fileWriter = new FileWriter(file, true);
                fileWriter.write(logPlan);
                fileWriter.flush();
            }
        }
    }

    public static LogItem takeLogItem() {
        try {
            return (LogItem)blockingQueue.take();
        }
        catch (InterruptedException e) {
            logger.error((Object)e);
            return null;
        }
    }

    public static void putLogItem(LogItem logItem) {
        try {
            blockingQueue.put(logItem);
        }
        catch (InterruptedException e) {
            logger.error((Object)e);
        }
    }

    static {
        WriteSQLPlanThread.start();
    }
}

