/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sql;

import java.util.Locale;

public final class DbType {
    public static final int KSQL = 0;
    public static final int DB2_UDB = 1;
    public static final int Oracle = 2;
    public static final int MS_SQL_Server = 3;
    public static final int Sybase = 4;
    public static final int PostgresSQL = 5;
    public static final int MySQL = 6;
    public static final int Oracle9 = 7;
    public static final int Oracle10 = 8;
    public static final int AS400 = 9;
    public static final int Derby = 10;
    public static final int DM = 11;
    public static final int Kingbase = 12;
    public static final int GaussDB = 13;

    private DbType() {
    }

    public static int[] getAllTypes() {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 11, 12, 13};
    }

    public static String getName(int dbType) {
        switch (dbType) {
            case 0: {
                return "KSQL";
            }
            case 1: {
                return "DB2 UDB";
            }
            case 2: {
                return "Oracle";
            }
            case 7: {
                return "Oracle9";
            }
            case 4: {
                return "Sybase";
            }
            case 5: {
                return "PostgresSQL";
            }
            case 6: {
                return "MySQL";
            }
            case 3: {
                return "MS SQL Server";
            }
            case 8: {
                return "Oracle10";
            }
            case 9: {
                return "AS400";
            }
            case 10: {
                return "Derby";
            }
            case 11: {
                return "DM";
            }
            case 12: {
                return "Kingbase";
            }
            case 13: {
                return "GaussDB";
            }
        }
        throw new IllegalArgumentException("dbType, value is " + dbType);
    }

    public static boolean isOracle(int type) {
        return type == 8 || type == 7 || type == 2;
    }

    public static int getValue(String oName) {
        assert (oName != null);
        String name = oName.toLowerCase(Locale.ENGLISH);
        if ("ksql".equals(name)) {
            return 0;
        }
        if (name.indexOf("as400") != -1) {
            return 9;
        }
        if (name.startsWith("db2")) {
            return 1;
        }
        if (name.startsWith("oracle")) {
            if (name.indexOf(57) != -1) {
                return 7;
            }
            if (name.indexOf("10") != -1) {
                return 8;
            }
            return 2;
        }
        if (name.indexOf("sybase") != -1) {
            return 4;
        }
        if (name.indexOf("derby") != -1) {
            return 10;
        }
        if (name.indexOf("dm") != -1 || name.indexOf("DM") != -1) {
            return 11;
        }
        if ((name.indexOf("ms") != -1 || name.indexOf("microsoft") != -1 || name.indexOf("sqlserver") != -1) && name.indexOf("DM") == -1 && name.indexOf("dm") == -1) {
            return 3;
        }
        if (name.indexOf("postgressql") != -1 || name.indexOf("postgresql") != -1) {
            return 5;
        }
        if (name.indexOf("mysql") != -1) {
            return 6;
        }
        if (name.indexOf("kingbase") != -1) {
            return 12;
        }
        if (name.indexOf("gaussdb") != -1) {
            return 13;
        }
        throw new IllegalArgumentException("name:" + oName);
    }
}

