/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sql.formater;

import com.kingdee.bos.sql.datatype.DataType;
import com.kingdee.bos.sql.dom.SqlColumnDef;
import com.kingdee.bos.sql.dom.SqlInsert;
import com.kingdee.bos.sql.dom.SqlJoinedTableSource;
import com.kingdee.bos.sql.dom.SqlOrderByItem;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.SqlSelectItem;
import com.kingdee.bos.sql.dom.SqlTableSource;
import com.kingdee.bos.sql.dom.SqlTableSourceBase;
import com.kingdee.bos.sql.dom.expr.QueryExpr;
import com.kingdee.bos.sql.dom.expr.SqlAggregateExpr;
import com.kingdee.bos.sql.dom.expr.SqlAllColumnExpr;
import com.kingdee.bos.sql.dom.expr.SqlAllExpr;
import com.kingdee.bos.sql.dom.expr.SqlAnyExpr;
import com.kingdee.bos.sql.dom.expr.SqlBetweenExpr;
import com.kingdee.bos.sql.dom.expr.SqlBinaryOpExpr;
import com.kingdee.bos.sql.dom.expr.SqlCaseExpr;
import com.kingdee.bos.sql.dom.expr.SqlCharExpr;
import com.kingdee.bos.sql.dom.expr.SqlDateTimeExpr;
import com.kingdee.bos.sql.dom.expr.SqlDoubleExpr;
import com.kingdee.bos.sql.dom.expr.SqlExistsExpr;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.dom.expr.SqlIdentifierExpr;
import com.kingdee.bos.sql.dom.expr.SqlInListExpr;
import com.kingdee.bos.sql.dom.expr.SqlInSubQueryExpr;
import com.kingdee.bos.sql.dom.expr.SqlIntExpr;
import com.kingdee.bos.sql.dom.expr.SqlLongExpr;
import com.kingdee.bos.sql.dom.expr.SqlMethodInvokeExpr;
import com.kingdee.bos.sql.dom.expr.SqlNCharExpr;
import com.kingdee.bos.sql.dom.expr.SqlNotExpr;
import com.kingdee.bos.sql.dom.expr.SqlNullExpr;
import com.kingdee.bos.sql.dom.expr.SqlPriorIdentifierExpr;
import com.kingdee.bos.sql.dom.expr.SqlSomeExpr;
import com.kingdee.bos.sql.dom.expr.SqlVarRefExpr;
import com.kingdee.bos.sql.dom.stmt.SqlCreateIndexStmt;
import com.kingdee.bos.sql.dom.stmt.SqlInsertStmt;
import com.kingdee.bos.sql.dom.stmt.SqlShowColumnsStmt;
import com.kingdee.bos.sql.dom.stmt.SqlShowTablesStmt;
import com.kingdee.bos.sql.dom.stmt.SqlStmt;
import com.kingdee.bos.sql.formater.DB2SQLFormater;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.bos.sql.parser.Token;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DB2AS400SQLFormater
extends DB2SQLFormater {
    @Override
    public String format(Collection stmtList) throws FormaterException {
        super.format(stmtList);
        StringBuffer subQueriesBuffer = new StringBuffer();
        if (stmtList != null && stmtList.size() > 0) {
            for (SqlStmt stmt : stmtList) {
                List subQueries = (List)stmt.extendedAttributes().get("SubQuery");
                if (subQueries == null || subQueries.size() <= 0) continue;
                for (int i = 0; i < subQueries.size(); ++i) {
                    if (i > 0) {
                        subQueriesBuffer.append(" ,");
                    }
                    subQueriesBuffer.append(subQueries.get(i));
                }
            }
        }
        if (subQueriesBuffer.toString() != null && subQueriesBuffer.toString().length() > 0) {
            return "WITH " + subQueriesBuffer.toString() + " " + this.buffer.toString();
        }
        return this.buffer.toString();
    }

    @Override
    protected void formatShowColumnsStmt(SqlShowColumnsStmt stmt) {
        this.buffer.append("SELECT NAME AS COLUMN_NAME, TYPENAME AS DATA_TYPE, LENGTH AS DEFAULT_LENGTH, -1 DATA_PRECISION, SCALE DATA_SCALE, NULLS, TBNAME TABLE_NAME");
        this.buffer.append(" FROM " + this.sysSchema() + ".SYSCOLUMNS ");
        if (stmt.tableName != null && stmt.tableName.length() != 0) {
            this.buffer.append(" WHERE TBNAME = UCASE('" + stmt.tableName + "')");
            if (this.options.getTableSchema() != null) {
                this.buffer.append(" AND TABLE_SCHEMA = '" + this.options.getTableSchema() + "'");
            }
        } else if (this.options.getTableSchema() != null) {
            this.buffer.append(" WHERE TABLE_SCHEMA = '" + this.options.getTableSchema() + "'");
        }
        this.buffer.append(" ORDER BY COLNO");
    }

    @Override
    protected void formatShowTablesStmt(SqlShowTablesStmt stmt) {
        this.buffer.append("SELECT NAME, CREATOR, CTIME, REMARKS, PACKED_DESC, COLCOUNT FROM " + this.sysSchema() + ".SYSTABLES");
        this.buffer.append(" WHERE TYPE = 'T' AND CREATOR != '" + this.sysSchema() + "'");
        if (this.options.getTableSchema() != null) {
            this.buffer.append(" AND TABLE_SCHEMA='" + this.options.getTableSchema() + "'");
        }
        this.buffer.append(" ORDER BY NAME");
    }

    @Override
    protected void formatAlterColumnType(SqlColumnDef column) throws FormaterException {
        if (column.dataType.equalsIgnoreCase("DECIMAL")) {
            this.buffer.append("DECIMAL (");
            this.buffer.append(column.precision);
            this.buffer.append(", ");
            this.buffer.append(column.scale);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("TINYINT")) {
            this.buffer.append("SMALLINT");
        } else if (column.dataType.equalsIgnoreCase("DATETIME")) {
            this.buffer.append("TIMESTAMP");
        } else if (column.dataType.equalsIgnoreCase("VARCHAR")) {
            this.buffer.append("VARCHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
            this.buffer.append(" CCSID 1208");
        } else if (column.dataType.equalsIgnoreCase("NVARCHAR")) {
            this.buffer.append("VARGRAPHIC (");
            this.buffer.append(column.length);
            this.buffer.append(")");
            this.buffer.append(" CCSID 1200");
        } else if (column.dataType.equalsIgnoreCase("CHAR")) {
            this.buffer.append("CHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("NCHAR")) {
            this.buffer.append("GRAPHIC (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("CLOB")) {
            this.buffer.append("CLOB (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("NCLOB")) {
            this.buffer.append("CLOB (");
            this.buffer.append(column.length);
            this.buffer.append(")");
            this.buffer.append(" CCSID 1208");
        } else if (column.dataType.equalsIgnoreCase("BINARY")) {
            this.buffer.append("VARCHAR (");
            this.buffer.append(column.length);
            this.buffer.append(") FOR BIT DATA");
        } else if (column.dataType.equalsIgnoreCase("BLOB")) {
            this.buffer.append("BLOB (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("VARBINARY")) {
            this.buffer.append("VARCHAR (");
            this.buffer.append(column.length);
            this.buffer.append(") FOR BIT DATA");
        } else if (column.dataType.equalsIgnoreCase("INT") && column.autoIncrement) {
            this.buffer.append("INTEGER GENERATED ALWAYS AS IDENTITY");
            this.context.put("Identity", column.name);
        } else {
            this.buffer.append(column.dataType);
        }
        if (column.allowNull != null && column.allowNull == Boolean.TRUE) {
            if (!column.isPrimaryKey) {
                // empty if block
            }
        } else if (column.allowNull != null && column.allowNull == Boolean.FALSE) {
            this.buffer.append(" NOT NULL");
        }
        if (column.defaultValueExpr != null) {
            this.buffer.append(" DEFAULT ");
            this.formatExpr(column.defaultValueExpr);
        }
        if (column.containtName != null && column.containtName.length() != 0) {
            this.validConstraintName(column.containtName);
            this.buffer.append(" CONSTRAINT ");
            this.buffer.append(column.containtName);
        }
        if (column.isPrimaryKey) {
            this.buffer.append(" PRIMARY KEY");
        }
        if (column.isUnique) {
            this.buffer.append(" UNIQUE");
        }
        if (column.checkExpr != null) {
            this.buffer.append(" CHECK (");
            this.formatExpr(column.checkExpr);
            this.buffer.append(")");
        }
    }

    @Override
    protected void formatColumnDef(SqlColumnDef column) throws FormaterException {
        this.buffer.append(column.name);
        this.buffer.append(" ");
        if (column.dataType.equalsIgnoreCase("DECIMAL")) {
            this.buffer.append("DECIMAL (");
            this.buffer.append(column.precision);
            this.buffer.append(", ");
            this.buffer.append(column.scale);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("TINYINT")) {
            this.buffer.append("SMALLINT");
        } else if (column.dataType.equalsIgnoreCase("DATETIME")) {
            this.buffer.append("TIMESTAMP");
        } else if (column.dataType.equalsIgnoreCase("VARCHAR")) {
            this.buffer.append("VARCHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
            this.buffer.append(" CCSID 1208");
        } else if (column.dataType.equalsIgnoreCase("NVARCHAR")) {
            this.buffer.append("VARGRAPHIC (");
            this.buffer.append(column.length);
            this.buffer.append(")");
            this.buffer.append(" CCSID 1200");
        } else if (column.dataType.equalsIgnoreCase("CHAR")) {
            this.buffer.append("CHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("NCHAR")) {
            this.buffer.append("GRAPHIC (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("CLOB")) {
            this.buffer.append("CLOB (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("NCLOB")) {
            this.buffer.append("CLOB (");
            this.buffer.append(column.length);
            this.buffer.append(")");
            this.buffer.append(" CCSID 1208");
        } else if (column.dataType.equalsIgnoreCase("BINARY")) {
            this.buffer.append("VARCHAR (");
            this.buffer.append(column.length);
            this.buffer.append(") FOR BIT DATA");
        } else if (column.dataType.equalsIgnoreCase("BLOB")) {
            this.buffer.append("BLOB (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("VARBINARY")) {
            this.buffer.append("VARCHAR (");
            this.buffer.append(column.length);
            this.buffer.append(") FOR BIT DATA");
        } else if (column.dataType.equalsIgnoreCase("INT") && column.autoIncrement) {
            this.buffer.append("INTEGER GENERATED ALWAYS AS IDENTITY");
            this.context.put("Identity", column.name);
        } else {
            this.buffer.append(column.dataType);
        }
        if (column.allowNull != null && column.allowNull == Boolean.TRUE) {
            if (!column.isPrimaryKey) {
                // empty if block
            }
        } else if (column.allowNull != null && column.allowNull == Boolean.FALSE) {
            this.buffer.append(" NOT NULL");
        }
        if (column.defaultValueExpr != null) {
            this.buffer.append(" DEFAULT ");
            this.formatExpr(column.defaultValueExpr);
        }
        if (column.containtName != null && column.containtName.length() != 0) {
            this.validConstraintName(column.containtName);
            this.buffer.append(" CONSTRAINT ");
            this.buffer.append(column.containtName);
        }
        if (column.isPrimaryKey) {
            this.buffer.append(" PRIMARY KEY");
        }
        if (column.isUnique) {
            this.buffer.append(" UNIQUE");
        }
        if (column.checkExpr != null) {
            this.buffer.append(" CHECK (");
            this.formatExpr(column.checkExpr);
            this.buffer.append(")");
        }
    }

    @Override
    protected void formatNChar(SqlNCharExpr expr) throws FormaterException {
        this.buffer.append("'");
        this.buffer.append(expr.text);
        this.buffer.append("'");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void formatMethodInvokeExpr(SqlMethodInvokeExpr expr) throws FormaterException {
        String methodNameI;
        if (expr.owner != null) {
            this.formatExpr(expr.owner);
            this.buffer.append('.');
        }
        if ((methodNameI = expr.methodName.toUpperCase(Locale.ENGLISH)).compareTo("ABS") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("ABS(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ACOS") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("ACOS(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ASIN") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("ASIN(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ATAN") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("ATAN(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ATN2") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("ATAN2(");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("CEILING") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("CEILING(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("COS") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("COS(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("EXP") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("EXP(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("FLOOR") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("FLOOR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("MOD") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("MOD(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LOG") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("LOG(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("POWER") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("POWER(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ROUND") == 0) {
            if (expr.parameters.size() == 2) {
                this.buffer.append("ROUND(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            if (expr.parameters.size() != 3) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            SqlExpr thirdExpr = (SqlExpr)expr.parameters.get(2);
            if (!(thirdExpr instanceof SqlIntExpr)) {
                throw new FormaterException("ERROR");
            }
            int val = Integer.parseInt(((SqlIntExpr)thirdExpr).text);
            if (val == 0) {
                this.buffer.append("ROUND(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            this.buffer.append("TRUNC(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("SIGN") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("SIGN(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("SIN") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("SIN(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("SQRT") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("SQRT(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("TAN") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("TAN(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ASCII") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("ASCII(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("CHAR") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("CHR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("CHARINDEX") == 0) {
            if (expr.parameters.size() == 2) {
                this.buffer.append("LOCATE(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            if (expr.parameters.size() != 3) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("LOCATE(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("CONCAT") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("CONCAT(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LEFT") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("LEFT(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LEN") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("LENGTH(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LENGTH") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("LENGTH(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LOWER") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("LCASE(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LCASE") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("LCASE(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LTRIM") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("LTRIM(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("REPLACE") == 0) {
            if (expr.parameters.size() != 3) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("REPLACE(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("RIGHT") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("RIGHT(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("RTRIM") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("RTRIM(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("SOUNDEX") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("SOUNDEX(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("SUBSTRING") == 0) {
            int startIndex;
            if (expr.parameters.size() != 3) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("SUBSTR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            if (expr.parameters.get(1) instanceof SqlIntExpr && (startIndex = ((SqlIntExpr)expr.parameters.get((int)1)).value) < 1) {
                if (startIndex == 0) {
                    expr.parameters.set(1, new SqlIntExpr(1));
                }
                if (startIndex < 0) {
                    throw new FormaterException("SUBSTRING parameter2 cannot not smaller then 0.");
                }
            }
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("TRIM") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("LTRIM(RTRIM(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append("))");
            return;
        }
        if (methodNameI.compareTo("UCASE") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("UCASE(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("UPPER") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("UCASE(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("CONVERT") == 0) {
            if (!(expr.parameters.get(0) instanceof SqlIdentifierExpr)) return;
            String targetTypeName = ((SqlIdentifierExpr)expr.parameters.get((int)0)).value;
            if (targetTypeName.compareToIgnoreCase("DATETIME") == 0) {
                this.buffer.append("TIMESTAMP(");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            if (targetTypeName.compareToIgnoreCase("VARCHAR") != 0) throw new FormaterException("not support Type: " + targetTypeName);
            this.buffer.append("CHAR(");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("CURDATE") == 0) {
            if (expr.parameters.size() != 0) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("CURRENT DATE");
            return;
        }
        if (methodNameI.compareTo("CURTIME") == 0) {
            if (expr.parameters.size() != 0) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("CHAR(CURRENT TIME)");
            return;
        }
        if (methodNameI.compareTo("DATEADD") == 0) {
            if (expr.parameters.size() == 2) {
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(" + ");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(" SECOND");
                return;
            }
            if (expr.parameters.size() != 3) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            SqlExpr datepartExpr = (SqlExpr)expr.parameters.get(0);
            if (!(datepartExpr instanceof SqlIdentifierExpr)) return;
            String datepart = ((SqlIdentifierExpr)datepartExpr).value;
            if (datepart == null) throw new FormaterException("illegal datepart.");
            if (datepart.length() == 0) {
                throw new FormaterException("illegal datepart.");
            }
            if ("YEAR".equals(datepart = datepart.toUpperCase(Locale.ENGLISH)) || "YY".equals(datepart) || "YYYY".equals(datepart)) {
                this.formatExpr((SqlExpr)expr.parameters.get(2));
                this.buffer.append(" + ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(" YEAR");
                return;
            }
            if ("MONTH".equals(datepart) || "MM".equals(datepart) || "M".equals(datepart)) {
                this.formatExpr((SqlExpr)expr.parameters.get(2));
                this.buffer.append(" + ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(" MONTH");
                return;
            }
            if ("DAY".equals(datepart) || "DD".equals(datepart) || "D".equals(datepart)) {
                this.formatExpr((SqlExpr)expr.parameters.get(2));
                this.buffer.append(" + ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(" DAY");
                return;
            }
            if ("HOUR".equals(datepart) || "HH".equals(datepart)) {
                this.formatExpr((SqlExpr)expr.parameters.get(2));
                this.buffer.append(" + ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(" HOUR");
                return;
            }
            if ("MINUTE".equals(datepart) || "MI".equals(datepart) || "N".equals(datepart)) {
                this.formatExpr((SqlExpr)expr.parameters.get(2));
                this.buffer.append(" + ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(" MINUTE");
                return;
            }
            if (!"SECOND".equals(datepart) && !"SS".equals(datepart)) {
                if (!"S".equals(datepart)) throw new FormaterException("not support datepart:" + datepart);
            }
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append(" + ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(" SECOND");
            return;
        }
        if (methodNameI.compareTo("DATEDIFF") == 0) {
            if (expr.parameters.size() == 2) {
                this.buffer.append("(DAYS(");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(") - DAYS(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")) * 60 * 60 * 24 + MIDNIGHT_SECONDS(");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(") - MIDNIGHT_SECONDS(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (expr.parameters.size() != 3) return;
            if (expr.parameters.size() != 3) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            SqlExpr datepartExpr = (SqlExpr)expr.parameters.get(0);
            if (!(datepartExpr instanceof SqlIdentifierExpr)) throw new FormaterException("illegal datepart.");
            String datepart = ((SqlIdentifierExpr)datepartExpr).value;
            if (datepart == null) throw new FormaterException("illegal datepart.");
            if (datepart.length() == 0) {
                throw new FormaterException("illegal datepart.");
            }
            if ("YEAR".equals(datepart = datepart.toUpperCase(Locale.ENGLISH)) || "YY".equals(datepart) || "YYYY".equals(datepart)) {
                this.buffer.append("(YEAR(");
                this.formatExpr((SqlExpr)expr.parameters.get(2));
                this.buffer.append(") - YEAR(");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append("))");
                return;
            }
            if ("MONTH".equals(datepart) || "MM".equals(datepart) || "M".equals(datepart)) {
                this.buffer.append("((YEAR(");
                this.formatExpr((SqlExpr)expr.parameters.get(2));
                this.buffer.append(") - YEAR(");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")) * 12 + MONTH(");
                this.formatExpr((SqlExpr)expr.parameters.get(2));
                this.buffer.append(") - MONTH(");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append("))");
                return;
            }
            if ("DAY".equals(datepart) || "DD".equals(datepart) || "D".equals(datepart)) {
                this.buffer.append("(DAYS (");
                this.formatExpr((SqlExpr)expr.parameters.get(2));
                this.buffer.append(") - DAYS (");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append("))");
                return;
            }
            if ("HOUR".equals(datepart) || "HH".equals(datepart)) {
                this.buffer.append("((DAYS (");
                this.formatExpr((SqlExpr)expr.parameters.get(2));
                this.buffer.append(") - DAYS (");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")) * 24)");
                return;
            }
            if ("MINUTE".equals(datepart) || "MI".equals(datepart) || "N".equals(datepart)) {
                this.buffer.append("((DAYS (");
                this.formatExpr((SqlExpr)expr.parameters.get(2));
                this.buffer.append(") - DAYS (");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")) * 24 * 60)");
                return;
            }
            if (!"SECOND".equals(datepart) && !"SS".equals(datepart)) {
                if (!"S".equals(datepart)) throw new FormaterException("not support datepart:" + datepart);
            }
            this.buffer.append("((DAYS (");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append(") - DAYS (");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")) * 24 * 60 * 60)");
            return;
        }
        if (methodNameI.compareTo("DAYNAME") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("DAYNAME(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("DATENAME") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("DAYNAME(");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("DAYOFMONTH") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("DAY(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("DAYOFWEEK") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("DAYOFWEEK(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("DAYOFYEAR") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("DAYOFYEAR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("GETDATE") == 0) {
            if (expr.parameters.size() != 0) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("CURRENT TIMESTAMP");
            return;
        }
        if (methodNameI.compareTo("HOUR") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("HOUR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("MINUTE") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("MINUTE(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("MONTH") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("MONTH(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("MONTHNAME") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("MONTHNAME(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("NOW") == 0) {
            if (expr.parameters.size() != 0) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("CURRENT TIMESTAMP");
            return;
        }
        if (methodNameI.compareTo("QUARTER") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("QUARTER(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("SECOND") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("SECOND(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("WEEK") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("WEEK(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("YEAR") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("YEAR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("TO_DATE") == 0) {
            this.format_TO_DATE_Invoke(expr);
            return;
        }
        if (methodNameI.compareTo("MONTHS_BETWEEN") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("((YEAR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(") - YEAR(");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")) * 12 +");
            this.buffer.append("MONTH(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(") - MONTH(");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append("))");
            return;
        }
        if (methodNameI.compareTo("ADD_MONTHS") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(" + ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(" MONTH)");
            return;
        }
        if (methodNameI.compareTo("ADD_YEARS") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(" + ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(" YEAR)");
            return;
        }
        if (methodNameI.compareTo("ADD_DAYS") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(" + ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(" DAY)");
            return;
        }
        if (methodNameI.compareTo("ADD_HOURS") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(" + ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(" HOUR)");
            return;
        }
        if (methodNameI.compareTo("ADD_MINUTES") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(" + ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(" MINUTE)");
            return;
        }
        if (methodNameI.compareTo("ADD_SECONDS") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(" + ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(" SECOND)");
            return;
        }
        if (methodNameI.compareTo("ASCII") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("ASCII(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("CHAR") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("CHAR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("CHARINDEX") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("LOCATE(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("CONCAT") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("CONCAT(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LEFT") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("LEFT(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LEN") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("LENGTH(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LENGTH") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("LENGTH(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LOWER") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("LCASE(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LCASE") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("LCASE(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LTRIM") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("LTRIM(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("REPLACE") == 0) {
            if (expr.parameters.size() != 3) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("REPLACE(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("RIGHT") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("RIGHT(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("RTRIM") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("RTRIM(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("SOUNDEX") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("SOUNDEX(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("SUBSTRING") == 0) {
            if (expr.parameters.size() != 3) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("SUBSTRING(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("TRIM") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("LTRIM(RTRIM(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append("))");
            return;
        }
        if (methodNameI.compareTo("UCASE") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("UCASE(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("UPPER") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("UCASE(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ISNULL") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("coalesce(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("NULLIF") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("NULLIF(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("TOCHAR") == 0 || methodNameI.compareTo("TO_CHAR") == 0) {
            if (expr.parameters.size() == 1) {
                if (expr.parameters.get(0) instanceof SqlNullExpr) {
                    this.buffer.append("CAST (");
                    this.formatNullExpr((SqlNullExpr)expr.parameters.get(0));
                    this.buffer.append(" AS CHAR(1))");
                    return;
                }
                if (!(expr.parameters.get(0) instanceof SqlIntExpr || expr.parameters.get(0) instanceof SqlLongExpr || expr.parameters.get(0) instanceof SqlDoubleExpr)) {
                    this.buffer.append("LTRIM(RTRIM(CHAR(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(")))");
                    return;
                }
                this.buffer.append("LTRIM(RTRIM(");
                this.buffer.append("CAST(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(" AS CHAR(50)");
                this.buffer.append(")))");
                return;
            }
            if (expr.parameters.size() == 2 && expr.parameters.get(1).toString().equalsIgnoreCase("YYYY-MM-DD HH24:MI:SS")) {
                this.buffer.append("VARCHAR_FORMAT(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", 'YYYY-MM-DD HH24:MI:SS')");
                return;
            }
            if (expr.parameters.size() == 2 && expr.parameters.get(1).toString().equalsIgnoreCase("YYYY-MM-DD")) {
                this.buffer.append("VARCHAR_FORMAT(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", 'YYYY-MM-DD HH24:MI:SS')");
                return;
            }
            if (expr.parameters.size() != 3) throw new FormaterException("ERROR");
            if (!expr.parameters.get(1).toString().equalsIgnoreCase("NUMBER")) throw new FormaterException("ERROR");
            if (expr.parameters.get(2) instanceof SqlCharExpr) {
                String style = expr.parameters.get(2).toString();
                if (style.split("D").length <= 0) throw new FormaterException("TO_CHAR()'s NUMBER style: " + expr.parameters.get(2) + " is not valid.");
                if (style.split("D").length >= 3) throw new FormaterException("TO_CHAR()'s NUMBER style: " + expr.parameters.get(2) + " is not valid.");
                char[] integerStyle = style.split("D")[0].toCharArray();
                char[] radixStyle = style.split("D")[1].toCharArray();
                int countInteger = 0;
                for (int i = 0; i < integerStyle.length; ++i) {
                    if (integerStyle[i] != '9') continue;
                    ++countInteger;
                }
                int countradix = 0;
                int i = 0;
                while (true) {
                    if (i >= radixStyle.length) {
                        this.buffer.append("LTRIM(RTRIM(CHAR(");
                        this.buffer.append("DECIMAL(");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(", ");
                        this.buffer.append(countInteger + countradix);
                        this.buffer.append(", ");
                        this.buffer.append(countradix);
                        this.buffer.append("))))");
                        return;
                    }
                    if (radixStyle[i] == '9') {
                        ++countradix;
                    }
                    ++i;
                }
            }
            if (!(expr.parameters.get(2) instanceof SqlIntExpr)) return;
            SqlIntExpr intExpr = (SqlIntExpr)expr.parameters.get(2);
            if (intExpr.value <= 0) {
                this.buffer.append("RTRIM(LTRIM(CHAR(BIGINT(DECIMAL(ROUND(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(",");
                this.formatExpr(intExpr);
                this.buffer.append("), 31, 0)))))");
                return;
            }
            this.buffer.append("CASE WHEN ((");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append("<0) AND (");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(">-1)) THEN ");
            this.buffer.append("'-' || RTRIM(LTRIM(CHAR(BIGINT(DECIMAL(ROUND(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append("), 31,");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append(")))))");
            this.buffer.append(" ELSE RTRIM(LTRIM(CHAR(BIGINT(DECIMAL(ROUND(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append("), 31,");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append("))))) END");
            this.buffer.append("||'.'||RTRIM(LTRIM(SUBSTR(CHAR(DECIMAL(ROUND(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append("), 31,");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append(")),LOCATE('.' ,CHAR(DECIMAL(ROUND(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append("), 31,");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append(")))+1)))");
            return;
        }
        if (methodNameI.compareTo("TO_DECIMAL") == 0 || methodNameI.compareTo("DECIMAL") == 0 || methodNameI.compareTo("DEC") == 0) {
            if (expr.parameters.size() != 1) {
                if (expr.parameters.size() != 3) throw new FormaterException("TO_DECIMAL's parameters num: " + expr.parameters.size());
                this.buffer.append("DECIMAL(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.buffer.append(expr.parameters.get(1));
                this.buffer.append(", ");
                this.buffer.append(expr.parameters.get(2));
                this.buffer.append(")");
                return;
            }
            if (expr.parameters.get(0) instanceof SqlNullExpr) {
                this.buffer.append("CAST (");
                this.formatNullExpr((SqlNullExpr)expr.parameters.get(0));
                this.buffer.append(" AS DECIMAL(1))");
                return;
            }
            this.buffer.append("DECIMAL(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("TO_NUMBER") == 0 || methodNameI.compareTo("DOUBLE") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("DOUBLE(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("TO_INTEGER") == 0 || methodNameI.compareTo("INT") == 0 || methodNameI.compareTo("INTEGER") == 0 || methodNameI.compareTo("TO_INT") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            if (expr.parameters.get(0) instanceof SqlNullExpr) {
                this.buffer.append("CAST (");
                this.formatNullExpr((SqlNullExpr)expr.parameters.get(0));
                this.buffer.append(" AS INT)");
                return;
            }
            this.buffer.append("FLOOR(INT(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append("))");
            return;
        }
        if (methodNameI.compareTo("TO_NVARCHAR") == 0 || methodNameI.compareTo("TONVARCHAR") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("CAST(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(" AS VARGRAPHIC(1) CCSID 1200");
                this.buffer.append(")");
                return;
            }
            if (expr.parameters.size() != 2) throw new FormaterException("Unrecognized parameters");
            this.buffer.append("CAST(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(" AS VARGRAPHIC(");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(") CCSID 1200");
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("TO_VARCHAR") == 0 || methodNameI.compareTo("TOVARCHAR") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("CAST(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(" AS VARCHAR(1) CCSID 1208");
                this.buffer.append(")");
                return;
            }
            if (expr.parameters.size() != 2) throw new FormaterException("Unrecognized parameters");
            this.buffer.append("CAST(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(" AS VARCHAR(");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(") CCSID 1208");
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("NEWID") == 0) {
            if (expr.parameters.size() != 0) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("NEWID()");
            return;
        }
        if (methodNameI.compareTo("NEWBOSID") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("Unrecognized parameters");
            this.buffer.append("NEWBOSID(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("NATIVE_TYPE") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR parameterNATIVE_TYPE");
            SqlCharExpr cexpr = (SqlCharExpr)expr.parameters.get(0);
            String type = cexpr.text;
            type = DataType.getDataType(9).nativeType(type);
            this.formatExpr(new SqlCharExpr(type));
            return;
        }
        this.formeatUnkownMethodInvokeExpr(expr);
    }

    @Override
    protected void format_TO_DATE_Invoke(SqlMethodInvokeExpr expr) throws FormaterException {
        if (expr.parameters.size() != 1) {
            throw new FormaterException("ERROR");
        }
        boolean needFormat = true;
        String format = "'YYYY-MM-DD HH24:MI:SS'";
        if (expr.parameters.get(0) instanceof SqlNullExpr) {
            this.buffer.append("CAST(");
            this.formatNullExpr((SqlNullExpr)expr.parameters.get(0));
            this.buffer.append(" AS TIMESTAMP)");
        } else {
            if (expr.parameters.get(0) instanceof SqlCharExpr) {
                SqlCharExpr dateTimeSqlExpr = (SqlCharExpr)expr.parameters.get(0);
                if (dateTimeSqlExpr.text.indexOf(".") > 0) {
                    this.buffer.append("TIMESTAMP");
                    this.buffer.append("(");
                    this.formatExpr(new SqlCharExpr(dateTimeSqlExpr.text));
                    needFormat = false;
                } else if (dateTimeSqlExpr.text.indexOf(":") < 0) {
                    this.buffer.append("TO_DATE");
                    this.buffer.append("(");
                    if (dateTimeSqlExpr.text.endsWith(" ")) {
                        this.formatExpr(new SqlCharExpr(dateTimeSqlExpr.text + "00:00:00"));
                    } else {
                        this.formatExpr(new SqlCharExpr(dateTimeSqlExpr.text + " 00:00:00"));
                    }
                } else {
                    this.buffer.append("TO_DATE");
                    this.buffer.append("(");
                    this.formatExpr(dateTimeSqlExpr);
                }
            } else {
                this.buffer.append("TO_DATE");
                this.buffer.append("(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
            }
            if (needFormat) {
                this.buffer.append(", " + format + ")");
            } else {
                this.buffer.append(")");
            }
        }
    }

    private String deepTrim(String text) {
        if (text == null) {
            return null;
        }
        String str = text.trim().replaceAll("  ", " ");
        while (!str.equals(text)) {
            text = str;
            str = text.replaceAll("  ", " ");
        }
        return str;
    }

    @Override
    protected void formatSelect(SqlSelect select) throws FormaterException {
        Map optionMap;
        boolean flag2 = false;
        if (select.into != null) {
            this.buffer.append("CREATE TABLE ");
            this.buffer.append(select.into.new_table);
            this.buffer.append(" AS (");
        }
        if (select.hierarchicalQueryClause != null) {
            this.formatHierarchicalSelect(select);
            return;
        }
        this.buffer.append("SELECT ");
        if (select.distinct == 1) {
            flag2 = this.checkHaveChineseOrderBy(select.orderBy);
            if (flag2) {
                this.buffer.append("KSQL_V2.* FROM ( SELECT DISTINCT ");
            } else {
                this.buffer.append("DISTINCT ");
            }
        } else if (select.distinct != 0) {
            throw new FormaterException("distinct option not support.");
        }
        Iterator iterator = select.selectList.iterator();
        boolean flag = false;
        boolean sysTableFlag = false;
        for (int i = 0; i < select.selectList.size(); ++i) {
            SqlIdentifierExpr tableNameExpr;
            SqlIdentifierExpr columnNameExpr;
            SqlSelectItem item;
            block91: {
                block89: {
                    block99: {
                        block98: {
                            block97: {
                                block96: {
                                    block95: {
                                        block94: {
                                            block93: {
                                                block92: {
                                                    block90: {
                                                        if (flag) {
                                                            this.buffer.append(", ");
                                                        }
                                                        item = (SqlSelectItem)select.selectList.get(i);
                                                        this.paramData.changeSelectColumn(select, item);
                                                        if (!(item.expr instanceof SqlIdentifierExpr)) break block89;
                                                        if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NAME.value) || item.alias != null) break block90;
                                                        item.alias = Token.KSQL_COL_NAME.value;
                                                        break block91;
                                                    }
                                                    if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value) || item.alias != null) break block92;
                                                    item.alias = Token.KSQL_COL_TABNAME.value;
                                                    break block91;
                                                }
                                                if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value) || item.alias != null) break block93;
                                                item.alias = Token.KSQL_COL_NULLABLE.value;
                                                break block91;
                                            }
                                            if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value) || item.alias != null) break block94;
                                            item.alias = Token.KSQL_COL_DEFAULT.value;
                                            break block91;
                                        }
                                        if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_LENGTH.value) || item.alias != null) break block95;
                                        item.alias = Token.KSQL_COL_LENGTH.value;
                                        break block91;
                                    }
                                    if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_TYPE.value) || item.alias != null) break block96;
                                    item.alias = Token.KSQL_COL_TYPE.value;
                                    break block91;
                                }
                                if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.INDNAME.value) || item.alias != null) break block97;
                                item.alias = Token.INDNAME.value;
                                break block91;
                            }
                            if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value) || item.alias != null) break block98;
                            item.alias = Token.KSQL_CONS_NAME.value;
                            break block91;
                        }
                        if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value) || item.alias != null) break block99;
                        item.alias = Token.KSQL_CONS_TABNAME.value;
                        break block91;
                    }
                    if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value) || item.alias != null) break block91;
                    item.alias = Token.KSQL_CONS_TYPE.value;
                    break block91;
                }
                if (item.expr instanceof SqlAggregateExpr) {
                    List TparamList = ((SqlAggregateExpr)item.expr).paramList;
                    for (SqlExpr param : TparamList) {
                        if (!(param instanceof SqlIdentifierExpr)) continue;
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_NAME.value)) {
                            ((SqlIdentifierExpr)param).value = "NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.TABNAME.value)) {
                            ((SqlIdentifierExpr)param).value = "NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_CREATETIME.value)) {
                            ((SqlIdentifierExpr)param).value = "CTIME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.INDNAME.value)) {
                            ((SqlIdentifierExpr)param).value = "NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value)) {
                            ((SqlIdentifierExpr)param).value = "NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value)) {
                            ((SqlIdentifierExpr)param).value = "TBNAME";
                            continue;
                        }
                        if (!((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value)) continue;
                        ((SqlIdentifierExpr)param).value = "CONSTRAINTYP";
                    }
                }
            }
            if (item.expr instanceof SqlNullExpr) {
                this.buffer.append("CASE 1 WHEN 1 THEN NULL ELSE '12345678901234' END");
                if (item.alias != null && item.alias.length() != 0) {
                    this.buffer.append(" ");
                    this.buffer.append(item.alias.toUpperCase(Locale.ENGLISH));
                }
            } else if (item.alias != null && item.alias.length() != 0) {
                if (item.expr instanceof SqlIdentifierExpr) {
                    if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NAME.value)) {
                        columnNameExpr = new SqlIdentifierExpr();
                        columnNameExpr.value = "NAME";
                        this.formatExpr(columnNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.TABNAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "NAME";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CREATETIME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "CTIME";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.INDNAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "NAME";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "NAME";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "TBNAME";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "CONSTRAINTYP";
                        this.formatExpr(tableNameExpr);
                    } else {
                        this.formatExpr(item.expr);
                    }
                } else {
                    this.formatExpr(item.expr);
                }
                this.buffer.append(" ");
                this.buffer.append(item.alias.toUpperCase(Locale.ENGLISH));
            } else if (item.expr instanceof SqlIdentifierExpr) {
                if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NAME.value)) {
                    columnNameExpr = new SqlIdentifierExpr();
                    columnNameExpr.value = "NAME";
                    this.formatExpr(columnNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.TABNAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "NAME";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CREATETIME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "CTIME";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.INDNAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "NAME";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "CONSTRAINT_NAME";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "TBNAME";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "CONSTRAINTYP";
                    this.formatExpr(tableNameExpr, false);
                } else {
                    this.formatExpr(item.expr, false);
                }
            } else {
                this.formatExpr(item.expr, false);
            }
            flag = true;
        }
        if (select.tableSource != null) {
            this.buffer.append(" FROM ");
            this.formatTableSource(select.tableSource);
            select.subQueries.addAll(select.tableSource.subQueries);
        } else {
            this.buffer.append(" FROM SYSIBM.SYSDUMMY1");
        }
        SqlTableSourceBase stable = this.getSysTable(select.tableSource);
        if (select.condition != null) {
            this.buffer.append(" WHERE ");
            if (sysTableFlag) {
                this.buffer.append("(TYPE ='T' OR TYPE ='V') AND ");
            }
            if (stable != null && this.options != null && this.options.getTableSchema() != null) {
                this.buffer.append(" TABLE_SCHEMA = '" + this.options.getTableSchema() + "' AND ");
            }
            this.formatExpr(select.condition);
            select.subQueries.addAll(select.condition.subQueries());
        } else if (sysTableFlag) {
            this.buffer.append(" WHERE (TYPE='T' OR TYPE='V')");
            if (stable != null && this.options.getTableSchema() != null) {
                this.buffer.append(" AND TABLE_SCHEMA = '" + this.options.getTableSchema() + "'");
            }
        } else if (stable != null && this.options.getTableSchema() != null) {
            this.buffer.append(" WHERE TABLE_SCHEMA = '" + this.options.getTableSchema() + "'");
        }
        if (select.groupBy.size() != 0) {
            this.buffer.append(" GROUP BY ");
            if (select.hasWithRollUp) {
                this.buffer.append("ROLLUP(");
            }
            flag = false;
            List groupBys = select.groupBy;
            for (int i = 0; i < groupBys.size(); ++i) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlExpr expr = (SqlExpr)groupBys.get(i);
                this.paramData.changeGroupBy(select, expr);
                this.formatExpr(expr);
                flag = true;
            }
            if (select.hasWithRollUp) {
                this.buffer.append(")");
            }
        }
        if (select.having != null) {
            this.buffer.append(" HAVING ");
            this.formatExpr(select.having);
        }
        if (flag2 && select.distinct == 1) {
            this.buffer.append(") KSQL_V2");
        }
        if (select.orderBy.size() != 0) {
            this.buffer.append(" ORDER BY ");
            flag = false;
            iterator = select.orderBy.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlOrderByItem orderByIterm = (SqlOrderByItem)iterator.next();
                if (orderByIterm.chineseOrderByMode == 2) {
                    this.buffer.append("ICU.SORTKEY(");
                }
                this.formatExpr(orderByIterm.expr);
                if (orderByIterm.chineseOrderByMode == 2) {
                    this.buffer.append(",'LZH_KPINYIN')");
                }
                if (orderByIterm.mode == 0) {
                    this.buffer.append(" ASC");
                } else {
                    this.buffer.append(" DESC");
                }
                flag = true;
            }
        }
        if (select.limit != null) {
            if (select.limit.value == 1) {
                this.buffer.append(" FETCH FIRST 1 ROW ONLY");
            } else {
                this.buffer.append(" FETCH FIRST ");
                this.buffer.append(select.limit.value);
                this.buffer.append(" ROWS ONLY");
            }
        }
        if ((optionMap = select.getOptionMapDirect()) != null) {
            if (optionMap.containsKey("FOR UPDATE")) {
                this.buffer.append(" FOR UPDATE");
            }
            if (optionMap.containsKey("FAST")) {
                Integer val = (Integer)optionMap.get("FAST");
                if (val == null) {
                    this.buffer.append(" OPTIMIZE FOR 1 ROW");
                } else {
                    this.buffer.append(" OPTIMIZE FOR ");
                    if (val == 1) {
                        this.buffer.append("1 ROW");
                    } else {
                        this.buffer.append(val);
                        this.buffer.append(" ROWS");
                    }
                }
            }
        }
        if (select.into != null) {
            this.buffer.append(")");
            this.buffer.append(" WITH DATA");
            this.buffer.append(";");
        }
    }

    @Override
    protected void formatIdentifierExpr(SqlExpr expr) {
        String ident = ((SqlIdentifierExpr)expr).value;
        if (ident.equalsIgnoreCase(Token.KSQL_COL_NAME.value)) {
            ident = "NAME";
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value)) {
            ident = "TBNAME";
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value)) {
            ident = "NULLS";
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value)) {
            ident = "\"DEFAULT\"";
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_TYPE.value)) {
            ident = "TYPENAME";
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_LENGTH.value) || ident.equalsIgnoreCase(Token.KSQL_COL_PRECISION.value)) {
            ident = "LENGTH";
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_SCALE.value)) {
            ident = "SCALE";
        } else if (ident.equalsIgnoreCase(Token.INDNAME.value)) {
            ident = "NAME";
        } else if (ident.equalsIgnoreCase(Token.TABNAME.value)) {
            ident = "NAME";
        } else if (ident.equalsIgnoreCase(Token.KSQL_CREATETIME.value)) {
            ident = "CTIME";
        } else if (ident.equalsIgnoreCase(Token.KSQL_CONS_NAME.value)) {
            ident = "CONSTRAINT_NAME";
        } else if (ident.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value)) {
            ident = "TBNAME";
        } else if (ident.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value)) {
            ident = "CONSTRAINTYP";
        }
        if (ident != null && ident.length() != 0 && ident.charAt(0) == '\"') {
            this.buffer.append(ident.toUpperCase(Locale.ENGLISH));
        } else {
            this.buffer.append(ident);
        }
    }

    private SqlTableSourceBase getSysTable(SqlTableSourceBase tableSource) {
        if (tableSource instanceof SqlTableSource) {
            SqlTableSource simpleTableSource = (SqlTableSource)tableSource;
            String name = simpleTableSource.name.toUpperCase(Locale.ENGLISH);
            if (name.equals(Token.USERTABLES.value) || name.equals(Token.USERCOLUMNS.value) || name.equals(Token.SYSINDEXES.value) || name.equals(Token.SYSCONSTRAINTS.value)) {
                return tableSource;
            }
            return null;
        }
        if (tableSource instanceof SqlJoinedTableSource) {
            SqlJoinedTableSource joinedTable = (SqlJoinedTableSource)tableSource;
            SqlTableSourceBase table = this.getSysTable(joinedTable.left);
            if (table != null) {
                return table;
            }
            return this.getSysTable(joinedTable.right);
        }
        return null;
    }

    @Override
    protected void formatCreateIndexStmt(SqlCreateIndexStmt stmt) throws FormaterException {
        if (stmt.isUnique) {
            this.buffer.append("CREATE UNIQUE INDEX ");
        }
        if (stmt.isCluster) {
            this.buffer.append("CREATE INDEX ");
        }
        if (!stmt.isCluster && !stmt.isUnique) {
            this.buffer.append("CREATE INDEX ");
        }
        this.buffer.append(stmt.indexName);
        this.buffer.append(" ON ");
        this.buffer.append(stmt.tableName);
        this.buffer.append(" (");
        boolean flag = false;
        Iterator iterator = stmt.itemList.iterator();
        while (iterator.hasNext()) {
            if (flag) {
                this.buffer.append(", ");
            }
            SqlOrderByItem orderByIterm = (SqlOrderByItem)iterator.next();
            if (orderByIterm.chineseOrderByMode == 2) {
                this.buffer.append("ICU.SORTKEY(");
            }
            this.formatExpr(orderByIterm.expr);
            if (orderByIterm.chineseOrderByMode == 2) {
                this.buffer.append(",'LZH_KPINYIN')");
            }
            if (orderByIterm.mode != 0) {
                this.buffer.append(" DESC");
            }
            flag = true;
        }
        this.buffer.append(")");
        if (stmt.isCluster) {
            // empty if block
        }
    }

    @Override
    protected void formatIdentityExpr(SqlExpr expr) {
    }

    @Override
    public void formatExpr(SqlExpr expr, boolean appendBrace) throws FormaterException {
        if (expr == null) {
            throw new IllegalArgumentException("expr is null");
        }
        if (expr instanceof SqlAllColumnExpr) {
            this.buffer.append("*");
        } else if (expr instanceof SqlIdentifierExpr) {
            this.formatIdentifierExpr(expr);
        } else if (expr instanceof SqlIntExpr) {
            this.buffer.append(((SqlIntExpr)expr).text);
        } else if (expr instanceof SqlLongExpr) {
            this.buffer.append(((SqlLongExpr)expr).text);
        } else if (expr instanceof SqlDoubleExpr) {
            this.buffer.append(((SqlDoubleExpr)expr).text);
        } else if (expr instanceof SqlBinaryOpExpr) {
            this.formatBinaryOpExpr((SqlBinaryOpExpr)expr, appendBrace);
        } else if (expr instanceof SqlMethodInvokeExpr) {
            this.formatMethodInvokeExpr((SqlMethodInvokeExpr)expr);
        } else if (expr instanceof SqlAggregateExpr) {
            this.formatAggregateExprExpr((SqlAggregateExpr)expr);
        } else if (expr instanceof SqlCharExpr) {
            this.formatChar((SqlCharExpr)expr);
        } else if (expr instanceof SqlNCharExpr) {
            this.formatNChar((SqlNCharExpr)expr);
        } else if (expr instanceof SqlVarRefExpr) {
            this.formatVarRef((SqlVarRefExpr)expr);
        } else if (expr instanceof SqlCaseExpr) {
            this.formatCaseExpr((SqlCaseExpr)expr);
        } else if (expr instanceof SqlInListExpr) {
            this.formatInListExpr((SqlInListExpr)expr);
        } else if (expr instanceof SqlExistsExpr) {
            this.formatExiststExpr((SqlExistsExpr)expr);
        } else if (expr instanceof SqlInSubQueryExpr) {
            this.formatInSubQueryExpr((SqlInSubQueryExpr)expr);
            expr.subQueries().addAll(((SqlInSubQueryExpr)expr).subQueries());
        } else if (expr instanceof SqlAllExpr) {
            this.formatAllExpr((SqlAllExpr)expr);
        } else if (expr instanceof SqlBetweenExpr) {
            this.formatBetweenExpr((SqlBetweenExpr)expr);
        } else if (expr instanceof SqlAnyExpr) {
            this.formatAnyExpr((SqlAnyExpr)expr);
        } else if (expr instanceof SqlSomeExpr) {
            this.formatSomeExpr((SqlSomeExpr)expr);
        } else if (expr instanceof SqlNullExpr) {
            this.formatNullExpr((SqlNullExpr)expr);
        } else if (expr instanceof SqlDateTimeExpr) {
            this.formatDateTimeExpr((SqlDateTimeExpr)expr);
        } else if (expr instanceof QueryExpr) {
            this.formatQueryExpr((QueryExpr)expr);
        } else if (expr instanceof SqlPriorIdentifierExpr) {
            this.formatPriorIdentifierExpr((SqlPriorIdentifierExpr)expr);
        } else if (expr instanceof SqlNotExpr) {
            this.formatNotExpr((SqlNotExpr)expr);
        } else if (expr.type == 28) {
            this.formatIdentityExpr(expr);
        } else {
            throw new FormaterException("not support Expr.  Type:" + expr.typename() + " , Value:" + expr.toString());
        }
    }

    @Override
    protected void formatInSubQueryExpr(SqlInSubQueryExpr expr) throws FormaterException {
        this.formatExpr(expr.expr);
        if (expr.not) {
            this.buffer.append(" NOT IN (");
        } else {
            this.buffer.append(" IN (");
        }
        this.formatSelectBase(expr.subQuery);
        expr.subQueries.addAll(expr.subQuery.subQueries);
        this.buffer.append(")");
    }

    @Override
    protected void formatInsertStmt(SqlInsertStmt stmt) throws FormaterException {
        int i;
        boolean flag;
        this.buffer.append("INSERT INTO ");
        SqlInsert insert = stmt.insert;
        String tableName = this.formatTableName(insert.tableName);
        this.buffer.append(tableName);
        if (!insert.columnList.isEmpty()) {
            this.buffer.append(" (");
            flag = false;
            boolean hasRowNum = false;
            for (i = 0; i < insert.columnList.size(); ++i) {
                Object colItem = insert.columnList.get(i);
                if (colItem instanceof SqlIdentifierExpr) {
                    SqlIdentifierExpr identExpr = (SqlIdentifierExpr)colItem;
                    if (identExpr.value.equalsIgnoreCase("KSQL_SEQ")) {
                        hasRowNum = true;
                    }
                    if (!hasRowNum) {
                        if (flag) {
                            this.buffer.append(", ");
                        }
                        this.buffer.append(identExpr.value);
                    }
                } else if (colItem instanceof String) {
                    if (flag) {
                        this.buffer.append(", ");
                    }
                    this.buffer.append((String)colItem);
                } else {
                    throw new FormaterException("unexpect expression: '" + colItem + "'");
                }
                flag = !hasRowNum || flag;
                hasRowNum = false;
            }
            this.buffer.append(")");
        }
        if (insert.valueList.size() != 0) {
            this.buffer.append(" VALUES (");
            flag = false;
            for (i = 0; i < insert.valueList.size(); ++i) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlExpr valueExpr = (SqlExpr)insert.valueList.get(i);
                this.formatExpr(valueExpr);
                flag = true;
            }
            this.buffer.append(")");
        } else {
            this.buffer.append(" ");
            this.formatSelectBase(stmt.insert.subQuery, false);
        }
    }

    @Override
    protected String constraintTable() {
        return "SYSCSTDEP";
    }

    @Override
    protected String sysSchema(String key) {
        if (key == null || key.trim().length() <= 0) {
            return "QSYS2";
        }
        if ("SYSDUMMY1".equals(key.trim())) {
            return "SYSIBM";
        }
        return "QSYS2";
    }

    @Override
    protected boolean needTemporarySchema() {
        return false;
    }

    @Override
    protected boolean procedureBodyIsSQL() {
        return true;
    }

    @Override
    protected boolean isAlterTableWithProcedure() {
        return true;
    }
}

