/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.privacy.encrypt;

import com.apusic.org.bouncycastle.jce.provider.BouncyCastleProvider;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.privacy.encrypt.AbstractEncryptor;
import com.kingdee.bos.privacy.encrypt.EncryptorType;
import com.kingdee.bos.privacy.encrypt.IEncryptor;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class SM4_CBC_128
extends AbstractEncryptor
implements IEncryptor {
    private static final String ALGM = "SM4";
    private static Provider apusicProvider = new BouncyCastleProvider();

    public SM4_CBC_128() {
    }

    public SM4_CBC_128(Context ctx, byte[] encryptKey) {
        try {
            this.secretKey = new SecretKeySpec(encryptKey, ALGM);
            this.cipher = Cipher.getInstance("SM4/CBC/PKCS5Padding", apusicProvider);
        }
        catch (Exception e) {
            throw new RuntimeException("SM4 init error", e);
        }
    }

    @Override
    public EncryptorType getType() {
        return EncryptorType.SM4_CBC_128;
    }

    @Override
    public byte[] generateKey() throws BOSException {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(ALGM, apusicProvider);
            keyGenerator.init(128);
            SecretKey secretKey = keyGenerator.generateKey();
            return secretKey.getEncoded();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }
}

