/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sql;

import com.kingdee.bos.privacy.ParamData;
import com.kingdee.bos.sql.DbType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.sql.dom.stmt.SqlCreateTableStmt;
import com.kingdee.bos.sql.formater.FormatOptions;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.bos.sql.formater.FormaterFactory;
import com.kingdee.bos.sql.formater.SQLFormater;
import com.kingdee.bos.sql.parser.Lexer;
import com.kingdee.bos.sql.parser.SqlParser;
import com.kingdee.bos.sql.shell.trace.TraceInfo;
import com.kingdee.bos.sql.util.UUTN;
import java.util.Collection;
import org.apache.log4j.Logger;

public class TransUtil {
    public static final String Dialect_Prefix = "/*dialect*/";
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.sql.TransUtil");
    private static boolean throwExWhenNameTooLong = false;
    static long transCount = 0L;

    private TransUtil() {
    }

    public static final String translate(String kSql, int targetDbType, TraceInfo traceInfo, ParamData paramData) throws SqlTranslateException {
        if ((kSql = kSql.trim()) == null || kSql.length() == 0) {
            return kSql;
        }
        if (kSql.startsWith(Dialect_Prefix)) {
            while (kSql.startsWith(Dialect_Prefix)) {
                kSql = kSql.substring(Dialect_Prefix.length());
            }
            return kSql;
        }
        Collection stmtCol = TransUtil.getStmtList(kSql);
        if (traceInfo != null) {
            String[] tempTableSpaces = traceInfo.tempTableSpaces;
            if (tempTableSpaces != null && tempTableSpaces.length > 0) {
                for (Object stmt : stmtCol) {
                    if (!(stmt instanceof SqlCreateTableStmt)) continue;
                    SqlCreateTableStmt createStmt = (SqlCreateTableStmt)stmt;
                    if (createStmt.tableSpace != null && createStmt.tableSpace.length() > 0 || !UUTN.isTempTable(createStmt.name)) continue;
                    createStmt.tableSpace = traceInfo.randomTableSpace();
                }
            }
            return TransUtil.translate(kSql, stmtCol, targetDbType, traceInfo.getFormatOptions(), paramData);
        }
        return TransUtil.translate(kSql, stmtCol, targetDbType, null, paramData);
    }

    public static String translate(String kSql, int targetDbType, FormatOptions options) throws SqlTranslateException {
        if ((kSql = kSql.trim()) == null || kSql.length() == 0) {
            return kSql;
        }
        if (kSql.startsWith(Dialect_Prefix)) {
            while (kSql.startsWith(Dialect_Prefix)) {
                kSql = kSql.substring(Dialect_Prefix.length());
            }
            return kSql;
        }
        Collection stmtCol = TransUtil.getStmtList(kSql);
        return TransUtil.format(kSql, stmtCol, targetDbType, options, null);
    }

    public static String translate(String kSql, int targetDbType, FormatOptions options, boolean throwExWhenNameTooLong) throws SqlTranslateException {
        boolean flag = TransUtil.isThrowExWhenNameTooLong();
        TransUtil.setThrowExWhenNameTooLong(throwExWhenNameTooLong);
        String ans = TransUtil.translate(kSql, targetDbType, options);
        TransUtil.setThrowExWhenNameTooLong(flag);
        return ans;
    }

    public static final String Translate(String ksql, int targetDbType) throws SqlTranslateException {
        return TransUtil.translate(ksql, targetDbType, new FormatOptions());
    }

    public static final String Translate(String ksql, int targetDbType, boolean throwExWhenNameTooLong) throws SqlTranslateException {
        boolean flag = TransUtil.isThrowExWhenNameTooLong();
        TransUtil.setThrowExWhenNameTooLong(throwExWhenNameTooLong);
        String ans = TransUtil.Translate(ksql, targetDbType);
        TransUtil.setThrowExWhenNameTooLong(flag);
        return ans;
    }

    private static Collection getStmtList(String ksql) throws ParserException {
        try {
            Lexer lexer = new Lexer(ksql);
            SqlParser parser = new SqlParser(lexer);
            parser.setThrowExWhenNameTooLong(TransUtil.isThrowExWhenNameTooLong());
            return parser.parseStmtList();
        }
        catch (ParserException ex) {
            TransUtil.logParseError(ex, ksql);
            throw new ParserException(ex, ksql);
        }
        catch (RuntimeException ex) {
            TransUtil.logParseError(ex, ksql);
            throw ex;
        }
        catch (Error e) {
            TransUtil.logParseError(e, ksql);
            throw e;
        }
    }

    private static String format(String ksql, Collection stmtCol, int targetDbType, FormatOptions options, ParamData paramData) throws SqlTranslateException {
        try {
            SQLFormater formater = FormaterFactory.getFormater(targetDbType);
            if (options != null) {
                formater.setOptions(options);
            }
            ++transCount;
            if (paramData != null) {
                formater.setParamData(paramData);
            }
            formater.format(stmtCol);
            String result = formater.getBuffer().toString();
            return result;
        }
        catch (FormaterException ex) {
            TransUtil.logFormatError(ex, ksql, targetDbType);
            throw new ParserException(ex, ksql, targetDbType);
        }
        catch (RuntimeException ex) {
            TransUtil.logFormatError(ex, ksql, targetDbType);
            throw ex;
        }
        catch (Error e) {
            TransUtil.logFormatError(e, ksql, targetDbType);
            throw e;
        }
    }

    private static void logFormatError(Throwable ex, String kSql, int targetDbType) {
        log.info((Object)("format sql error. target database is '" + DbType.getName(targetDbType) + "' detail message is :\n" + ex.getMessage() + "\nsource sql is : \n" + kSql), ex);
    }

    private static void logParseError(Throwable ex, String kSql) {
        log.info((Object)("parse error. detail message is :\n" + ex.getMessage() + "\nsource sql is : \n" + kSql), ex);
    }

    private static String translate(String ksql, Collection stmtCol, int targetDbType, FormatOptions options, ParamData paramData) throws SqlTranslateException {
        if (ksql == null || ksql.length() <= 0) {
            return "";
        }
        if (stmtCol == null || stmtCol.size() <= 0) {
            return "";
        }
        return TransUtil.format(ksql, stmtCol, targetDbType, options, paramData);
    }

    public static boolean isThrowExWhenNameTooLong() {
        return throwExWhenNameTooLong;
    }

    public static void setThrowExWhenNameTooLong(boolean throwExWhenNameTooLong) {
        TransUtil.throwExWhenNameTooLong = throwExWhenNameTooLong;
    }
}

