/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.sso.client.ltpa;

import com.kingdee.shr.sso.client.ltpa.LtpaTokenManager;
import com.kingdee.shr.sso.client.util.BASE64Util;
import com.kingdee.shr.sso.client.util.LMBCSUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;

public class LtpaToken {
    private byte[] creation;
    private Date creationDate;
    private byte[] digest;
    private byte[] expires;
    private Date expiresDate;
    private byte[] header;
    private String tokenStr;
    private byte[] rawToken;
    private byte[] user;

    public LtpaToken() {
        this.init();
    }

    public LtpaToken(String token) {
        int i;
        this.init();
        this.tokenStr = token;
        this.rawToken = BASE64Util.decodeAsBytes(token);
        for (i = 0; i < 4; ++i) {
            this.header[i] = this.rawToken[i];
        }
        for (i = 4; i < 12; ++i) {
            this.creation[i - 4] = this.rawToken[i];
        }
        for (i = 12; i < 20; ++i) {
            this.expires[i - 12] = this.rawToken[i];
        }
        String algorithm = LtpaTokenManager.getAlgorithm();
        if ("SHA-256".equalsIgnoreCase(algorithm)) {
            int i2;
            this.user = new byte[this.rawToken.length - 84];
            this.digest = new byte[64];
            for (i2 = 20; i2 < this.rawToken.length - 64; ++i2) {
                this.user[i2 - 20] = this.rawToken[i2];
            }
            for (i2 = this.rawToken.length - 64; i2 < this.rawToken.length; ++i2) {
                this.digest[i2 - (this.rawToken.length - 64)] = this.rawToken[i2];
            }
        } else {
            int i3;
            this.user = new byte[this.rawToken.length - 60];
            for (i3 = 20; i3 < this.rawToken.length - 40; ++i3) {
                this.user[i3 - 20] = this.rawToken[i3];
            }
            for (i3 = this.rawToken.length - 40; i3 < this.rawToken.length; ++i3) {
                this.digest[i3 - (this.rawToken.length - 40)] = this.rawToken[i3];
            }
        }
        this.creationDate = new Date(Long.parseLong(new String(this.creation), 16) * 1000L);
        this.expiresDate = new Date(Long.parseLong(new String(this.expires), 16) * 1000L);
    }

    public static String byte2hex(byte[] b) {
        String hs = "";
        String stmp = "";
        for (int n = 0; n < b.length; ++n) {
            stmp = Integer.toHexString(b[n] & 0xFF);
            hs = stmp.length() == 1 ? hs + "0" + stmp : hs + stmp;
        }
        return hs.toUpperCase();
    }

    public static String encodeToken(String token) {
        try {
            return URLEncoder.encode(URLEncoder.encode(URLEncoder.encode(token, "UTF-8"), "UTF-8"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("Token encode error[UnsupportedEncodingException]!");
            e.printStackTrace();
            return token;
        }
    }

    public static String decodeToken(String token) {
        if (token.indexOf("+") == -1) {
            try {
                String decodeToken1 = URLDecoder.decode(token, "UTF-8");
                if (decodeToken1.indexOf("+") == -1) {
                    String decodeToken2 = URLDecoder.decode(decodeToken1, "UTF-8");
                    if (decodeToken2.indexOf("+") == -1) {
                        return URLDecoder.decode(decodeToken2, "UTF-8");
                    }
                    return decodeToken2;
                }
                return decodeToken1;
            }
            catch (UnsupportedEncodingException e) {
                System.err.println("Token decode error[UnsupportedEncodingException]!");
                e.printStackTrace();
            }
        }
        return token;
    }

    public static void main(String[] args) {
        String prime = "dsFJfzYxQjZDMTQ4NjFCNkNBQTh1c2VyMTQ2OERGMjNDMDEwNDE5RDJDRkNCNjIyQjY1NDM5OTBCQkUyRDk3Nw==";
        LtpaToken tokne = new LtpaToken(prime);
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public MessageDigest getMessageDigest() {
        try {
            String algorithm = LtpaTokenManager.getAlgorithm();
            if ("SHA-256".equalsIgnoreCase(algorithm)) {
                return MessageDigest.getInstance("SHA-256");
            }
            return MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public Date getExpiresDate() {
        return this.expiresDate;
    }

    public void setExpiresDate(Date expiresDate) {
        this.expiresDate = expiresDate;
    }

    public String getUsername() {
        String userName = null;
        try {
            userName = new String(this.user, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            userName = new String(this.user);
        }
        return userName;
    }

    public String getUsername(String code) {
        String userName = null;
        try {
            userName = new String(this.user, code);
        }
        catch (UnsupportedEncodingException e) {
            userName = new String(this.user);
        }
        return userName;
    }

    private void init() {
        this.creation = new byte[8];
        this.digest = new byte[40];
        this.expires = new byte[8];
        this.header = new byte[4];
    }

    public boolean isValid(String secretKey) {
        boolean validDigest = false;
        boolean validDateRange = false;
        byte[] bytes = null;
        Date now = new Date();
        MessageDigest md = this.getMessageDigest();
        bytes = LMBCSUtil.concatenate(bytes, this.header);
        bytes = LMBCSUtil.concatenate(bytes, this.creation);
        bytes = LMBCSUtil.concatenate(bytes, this.expires);
        bytes = LMBCSUtil.concatenate(bytes, this.user);
        bytes = LMBCSUtil.concatenate(bytes, BASE64Util.decodeAsBytes(secretKey));
        byte[] newDigest = md.digest(bytes);
        String di = LtpaToken.byte2hex(newDigest);
        validDigest = MessageDigest.isEqual(this.digest, di.getBytes());
        System.out.println("valid message digest :" + validDigest);
        validDateRange = now.before(this.expiresDate);
        boolean result = validDigest && validDateRange;
        System.out.println("creationDate[" + this.creationDate + "]<now[" + now + "]<expiresDate[" + this.expiresDate + "],validDateRange:" + validDateRange + ",verify result:" + result);
        return result;
    }

    public String toString() {
        return LtpaToken.encodeToken(this.tokenStr);
    }

    public String toPlainString() {
        return this.tokenStr;
    }

    public byte[] getCreation() {
        return this.creation;
    }

    public void setCreation(byte[] creation) {
        this.creation = creation;
    }

    public byte[] getExpires() {
        return this.expires;
    }

    public void setExpires(byte[] expires) {
        this.expires = expires;
    }

    public byte[] getHeader() {
        return this.header;
    }

    public void setHeader(byte[] header) {
        this.header = header;
    }

    public void setDigest(byte[] digest) {
        this.digest = digest;
    }

    public byte[] getUser() {
        return this.user;
    }

    public void setUser(byte[] user) {
        this.user = user;
    }

    public String getTokenStr() {
        return LtpaToken.encodeToken(this.tokenStr);
    }
}

