/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.privacy.encrypt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.privacy.encrypt.AES_CBC_256;
import com.kingdee.bos.privacy.encrypt.EncryptorType;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AES_GCM_256
extends AES_CBC_256 {
    private static SecureRandom secureRandom = new SecureRandom();
    private static int tagLen = 16;

    public AES_GCM_256() {
    }

    public AES_GCM_256(Context ctx, byte[] encryptKey) {
        try {
            this.secretKey = new SecretKeySpec(encryptKey, "AES");
            this.cipher = Cipher.getInstance("AES/GCM/NoPadding");
        }
        catch (Exception e) {
            throw new RuntimeException("AES_GCM_256 init error", e);
        }
    }

    @Override
    protected AlgorithmParameterSpec getAlgorithmParameterSpec() {
        byte[] bytes = new byte[tagLen];
        secureRandom.nextBytes(bytes);
        return new GCMParameterSpec(128, bytes);
    }

    @Override
    public synchronized byte[] encrypt(byte[] src) throws BOSException {
        try {
            if (src == null) {
                return src;
            }
            GCMParameterSpec spec = (GCMParameterSpec)this.getAlgorithmParameterSpec();
            byte[] iv = spec.getIV();
            this.cipher.init(1, (Key)this.secretKey, spec);
            src = this.cipher.doFinal(src);
            return this.concatenate(iv, src);
        }
        catch (Exception e) {
            throw new BOSException((Object)((Object)this.getType()) + " encrypt error", (Throwable)e);
        }
    }

    @Override
    public synchronized byte[] decrypt(byte[] src) throws BOSException {
        try {
            if (src == null) {
                return src;
            }
            byte[] iv = this.subArray(src, 0, tagLen);
            GCMParameterSpec spec = new GCMParameterSpec(128, iv);
            this.cipher.init(2, (Key)this.secretKey, spec);
            src = this.subArray(src, tagLen, src.length);
            return this.cipher.doFinal(src);
        }
        catch (Exception e) {
            throw new BOSException((Object)((Object)this.getType()) + " decrypt error", (Throwable)e);
        }
    }

    @Override
    public EncryptorType getType() {
        return EncryptorType.AES_GCM_256;
    }

    private byte[] subArray(byte[] array, int beginIndex, int endIndex) {
        int length = endIndex - beginIndex;
        byte[] subarray = new byte[length];
        System.arraycopy(array, beginIndex, subarray, 0, length);
        return subarray;
    }

    private byte[] concatenate(byte[] ... arrays) {
        int length = 0;
        for (byte[] array : arrays) {
            length += array.length;
        }
        byte[] newArray = new byte[length];
        int destPos = 0;
        for (byte[] array : arrays) {
            System.arraycopy(array, 0, newArray, destPos, array.length);
            destPos += array.length;
        }
        return newArray;
    }
}

