/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sql.shell.nologging;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Properties;

public class NoLoggingConfig {
    public static final String key_enable = "enable";
    private static boolean nologging_append_enable = true;
    private static Properties properties = new Properties();

    private static void init() {
        NoLoggingConfig.initProperties();
        NoLoggingConfig.loadFromFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveToFile() {
        String propFile = NoLoggingConfig.getPropFile();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(propFile);
            String comments = "Generated by jsp, Date: " + new Date();
            properties.store(fos, comments);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String getPropFile() {
        String deploy = System.getProperty("eas.deploy");
        String propFile = deploy + "/nologgingconfig.properties";
        return propFile;
    }

    public static boolean existsPropFile() {
        String propFile = NoLoggingConfig.getPropFile();
        File f = new File(propFile);
        return f.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadFromFile() {
        Properties props = new Properties();
        File file = new File(NoLoggingConfig.getPropFile());
        boolean b = false;
        if (file.exists()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                props.load(fis);
                b = true;
            }
            catch (Throwable t) {
                t.printStackTrace();
                boolean bl = false;
                return bl;
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            properties.putAll((Map<?, ?>)props);
            String v = props.getProperty(key_enable);
            if ("false".equals(v)) {
                nologging_append_enable = false;
            } else if ("true".equals(v)) {
                nologging_append_enable = true;
            }
            return true;
        }
        return false;
    }

    private static void initProperties() {
        properties.setProperty(key_enable, nologging_append_enable ? "true" : "false");
        properties.setProperty("initialSize", "2");
        properties.setProperty("maxActive", "40");
        properties.setProperty("maxIdle", "20");
        properties.setProperty("minIdle", "5");
        properties.setProperty("maxWait", "6000");
    }

    public static boolean enableNoLoggingAppend() {
        return nologging_append_enable;
    }

    public static void setEnableNoLoggingAppend() {
        nologging_append_enable = true;
        properties.setProperty(key_enable, "true");
    }

    public static Properties getProperties() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)properties);
        return props;
    }

    public static void setProperties(Properties props) {
        properties.putAll((Map<?, ?>)props);
        String v = props.getProperty(key_enable);
        if ("false".equals(v)) {
            nologging_append_enable = false;
        } else if ("true".equals(v)) {
            nologging_append_enable = true;
        }
    }

    static {
        NoLoggingConfig.init();
    }
}

