/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class BizCheckerConfigParser {
    private static Logger logger = Logger.getLogger((String)BizCheckerConfigParser.class.getName());
    public static final String CONFIG_FILE = "/com/kingdee/eas/basedata/org/OrgBizCheckerConfig.xml";
    private static Document doc = null;

    public static String[] getCheckerItems() throws IOException, JDOMException {
        Element root;
        List items;
        if (doc == null) {
            BizCheckerConfigParser.generateDoc();
        }
        if ((items = (root = doc.getRootElement()).getChildren()) == null || items.size() == 0) {
            return new String[0];
        }
        String[] ret = new String[items.size()];
        int n = items.size();
        for (int i = 0; i < n; ++i) {
            Element item = (Element)items.get(i);
            ret[i] = item.getTextTrim();
        }
        return ret;
    }

    private static void generateDoc() throws IOException, JDOMException {
        InputStream is = null;
        try {
            is = BizCheckerConfigParser.class.getResource(CONFIG_FILE).openStream();
            SAXBuilder builder = new SAXBuilder();
            builder.setEntityResolver((EntityResolver)new NoOpEntityResolver());
            builder.setValidation(false);
            doc = builder.build(is);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception err) {
                    logger.error((Object)err);
                }
            }
        }
    }

    private static class NoOpEntityResolver
    implements EntityResolver {
        private NoOpEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            return new InputSource(new StringBufferInputStream(""));
        }
    }
}

