/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.INewOrgUnitFacade;
import com.kingdee.eas.basedata.org.NewOrgUnitFacadeFactory;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.OrgF7PromptDialog;
import com.kingdee.eas.basedata.org.client.ext.IOrgClientExt;
import com.kingdee.eas.basedata.org.client.ext.OrgClientExtHelper;
import com.kingdee.eas.basedata.org.client.f7.CtrlF7;
import com.kingdee.eas.basedata.org.client.uihelper.OrgTypeClientCenter;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class NewOrgUtils {
    public static final int TREETYPE_ORDINARY = 0;
    public static final int TREETYPE_BIZUNIT = 1;
    public static final int TREETYPE_VIRTUALUNIT = 2;
    public static final int TREETYPE_UNIONANDGROUP = 0;
    public static final int TREETYPE_UNITONLY = 1;
    public static final int TREETYPE_GROUPONLY = 2;
    public static final String NUMBER = "number";
    public static final String NAME = "name";

    public static boolean isTreeNodeDisabled(DefaultKingdeeTreeNode treeNode) {
        return OrgF7InnerUtils.isTreeNodeDisable(treeNode);
    }

    public static OrgUnitInfo getTypedUserObject(DefaultKingdeeTreeNode treeNode, OrgViewType viewType) throws Exception {
        Object obj = treeNode.getUserObject();
        if (obj == null) {
            return null;
        }
        if (obj instanceof OrgUnitInfo) {
            return (OrgUnitInfo)obj;
        }
        if (obj instanceof OrgStructureInfo) {
            BOSUuid unitID = ((OrgStructureInfo)obj).getUnit().getId();
            OrgType curOrgType = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(viewType).getOrgType();
            return NewOrgViewHelper.getOrgUnitInfo(null, unitID.toString(), curOrgType);
        }
        return null;
    }

    public static TreeModel getTreeModel(OrgViewType orgViewType, String treeID, boolean isCUFilter, boolean isCUFilterIncludeSub, boolean isContainSealUp, String rootUnitID, boolean isPermissionEnabled, HashMap filterMap, int treeType, IMetaDataPK uiPK, IMetaDataPK actionPK) throws Exception {
        return NewOrgUtils.getTreeModel(orgViewType, treeID, isCUFilter, isCUFilterIncludeSub, isContainSealUp, rootUnitID, isPermissionEnabled, filterMap, treeType, false, uiPK, actionPK);
    }

    public static TreeModel getTreeModel(OrgViewType orgViewType, String treeID, boolean isCUFilter, boolean isCUFilterIncludeSub, boolean isContainSealUp, String rootUnitID, boolean isPermissionEnabled, HashMap filterMap, int treeType, boolean isSimpleField, IMetaDataPK uiPK, IMetaDataPK actionPK) throws Exception {
        OrgF7PromptDialog f7 = null;
        OrgType curOrgType = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(orgViewType).getOrgType();
        String orgTypeStr = "";
        if (orgViewType.getValue() == 10) {
            f7 = new CtrlF7();
        } else if (orgViewType.getValue() == 8) {
            if (treeType == 0) {
                orgTypeStr = "TREETYPE_BIZUNIT";
            } else if (treeType == 1) {
                orgTypeStr = "TREETYPE_ORDINARY";
            } else if (treeType == 2) {
                orgTypeStr = "TREETYPE_VIRTUALUNIT";
            }
        } else if (treeType == 0) {
            orgTypeStr = "TREETYPE_ORDINARY";
        } else if (treeType == 1) {
            orgTypeStr = "TREETYPE_BIZUNIT";
        } else if (treeType == 2) {
            orgTypeStr = "TREETYPE_VIRTUALUNIT";
        }
        f7 = OrgTypeClientCenter.getInstance().getClientImp(curOrgType).createF7ByCondition(orgTypeStr);
        if (f7 == null) {
            return null;
        }
        f7.setUIActionPK(uiPK, actionPK);
        f7.setIsCUFilter(isCUFilter, isCUFilterIncludeSub);
        f7.setContainSealUp(isContainSealUp);
        f7.setRootUnitID(rootUnitID);
        if (!isPermissionEnabled) {
            if (filterMap != null) {
                f7.disablePerm(filterMap, true);
            } else {
                f7.disablePerm(null, false);
            }
        }
        if (orgViewType.getValue() != 8) {
            treeID = NewOrgViewHelper.convert2TreeId(orgViewType);
        } else if (treeID == null) {
            return null;
        }
        OrgTreeInfo treeInfo = new OrgTreeInfo();
        treeInfo.setId(BOSUuid.read((String)treeID));
        return f7.getTreeModel(orgViewType, treeInfo, isSimpleField);
    }

    public static TreeModel clipTreeModel(TreeModel model, String field, String value, boolean isBlured) {
        if (field == null || field.trim().length() == 0) {
            return model;
        }
        DefaultTreeModel treeModel = (DefaultTreeModel)model;
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)treeModel.getRoot();
        if (root.getUserObject() != null) {
            NewOrgUtils.disableTreeNodeByFilterCondition(root, field, value, isBlured);
            OrgF7InnerUtils.clipTreeNodeByColor(root);
        }
        return treeModel;
    }

    public static TreeModel clipAndCloneTreeModel(TreeModel model, String field, String value, boolean isBlured) {
        if (field == null || field.trim().length() == 0) {
            return model;
        }
        DefaultTreeModel treeModel = (DefaultTreeModel)NewOrgUtils.deepCloneTreeModel(model);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)treeModel.getRoot();
        if (root.getUserObject() != null) {
            NewOrgUtils.disableTreeNodeByFilterCondition(root, field, value, isBlured);
            OrgF7InnerUtils.clipTreeNodeByColor(root);
        }
        return treeModel;
    }

    private static TreeModel deepCloneTreeModel(TreeModel model) {
        if (model.getRoot() != null) {
            DefaultKingdeeTreeNode newRoot = NewOrgUtils.cloneTreeNode((DefaultKingdeeTreeNode)model.getRoot());
            return new DefaultTreeModel((TreeNode)newRoot);
        }
        return new DefaultTreeModel(null);
    }

    private static DefaultKingdeeTreeNode cloneTreeNode(DefaultKingdeeTreeNode node) {
        DefaultKingdeeTreeNode newNode = new DefaultKingdeeTreeNode(node.getUserObject());
        int n = node.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
            DefaultKingdeeTreeNode newChildNode = NewOrgUtils.cloneTreeNode(childNode);
            newNode.add((MutableTreeNode)newChildNode);
        }
        return newNode;
    }

    private static void disableTreeNodeByFilterCondition(DefaultKingdeeTreeNode root, String field, String value, boolean isBlured) {
        FullOrgUnitInfo unitInfo = null;
        DefaultKingdeeTreeNode node = null;
        Enumeration nodeEnum = root.breadthFirstEnumeration();
        while (nodeEnum.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)nodeEnum.nextElement();
            unitInfo = ((OrgStructureInfo)node.getUserObject()).getUnit();
            if (value == null || value.trim().length() == 0) continue;
            String numberOrName = null;
            if (NUMBER.equalsIgnoreCase(field)) {
                numberOrName = unitInfo.getNumber();
            } else if (NAME.equalsIgnoreCase(field)) {
                numberOrName = unitInfo.getName();
            }
            if (numberOrName == null) continue;
            if (isBlured) {
                if (numberOrName.indexOf(value) != -1) continue;
                OrgF7InnerUtils.disableTreeNode(node);
                continue;
            }
            if (numberOrName.equals(value)) continue;
            OrgF7InnerUtils.disableTreeNode(node);
        }
    }

    public static TreeModel getTreeModel(OrgViewType orgViewType, String treeID, boolean isCUFilter, boolean isCUFilterIncludeSub, String rootUnitID, boolean isPermissionEnabled, HashMap filterMap, int treeType, IMetaDataPK uiPK, IMetaDataPK actionPK) throws Exception {
        return NewOrgUtils.getTreeModel(orgViewType, treeID, isCUFilter, isCUFilterIncludeSub, false, rootUnitID, isPermissionEnabled, filterMap, 0, uiPK, actionPK);
    }

    public static TreeModel getTreeModel(OrgViewType orgViewType, IMetaDataPK uiPK, IMetaDataPK actionPK) throws Exception {
        return NewOrgUtils.getTreeModel(orgViewType, null, false, false, false, null, true, null, 0, uiPK, actionPK);
    }

    public static TreeModel getTreeModel(OrgViewType orgViewType, String treeID, IMetaDataPK uiPK, IMetaDataPK actionPK) throws Exception {
        return NewOrgUtils.getTreeModel(orgViewType, treeID, false, false, false, null, true, null, 0, uiPK, actionPK);
    }

    public static TreeModel getTreeModel(OrgViewType orgViewType, String treeID, String rootUnitID, IMetaDataPK uiPK, IMetaDataPK actionPK) throws Exception {
        return NewOrgUtils.getTreeModel(orgViewType, treeID, false, false, false, rootUnitID, true, null, 0, uiPK, actionPK);
    }

    public static TreeModel getTreeModel(OrgViewType orgViewType, String treeID, boolean isContainSealUp, String rootUnitID, IMetaDataPK uiPK, IMetaDataPK actionPK) throws Exception {
        return NewOrgUtils.getTreeModel(orgViewType, treeID, false, false, isContainSealUp, rootUnitID, true, null, 0, uiPK, actionPK);
    }

    public static TreeModel getCompanyTreeModel(String accountTableID, String periodTypeID, IMetaDataPK uiPK, IMetaDataPK actionPK) throws Exception {
        return NewOrgUtils.getCompanyTreeModel(accountTableID, periodTypeID, true, uiPK, actionPK);
    }

    public static TreeModel getCompanyTreeModel(String accountTableID, String periodTypeID, boolean isPermissionEnabled, IMetaDataPK uiPK, IMetaDataPK actionPK) throws Exception {
        IOrgClientExt iOrgClientExt = OrgClientExtHelper.getClientOrgExt();
        return iOrgClientExt.getCompanyTreeModel(accountTableID, periodTypeID, isPermissionEnabled, uiPK, actionPK);
    }

    public static TreeModel getCompanyTreeModel(String accountTableID, String periodTypeID, String rootCompanyID, boolean isPermissionEnabled, IMetaDataPK uiPK, IMetaDataPK actionPK) throws Exception {
        IOrgClientExt iOrgClientExt = OrgClientExtHelper.getClientOrgExt();
        return iOrgClientExt.getCompanyTreeModel(accountTableID, periodTypeID, rootCompanyID, isPermissionEnabled, uiPK, actionPK);
    }

    public static boolean isOrgStart(Context ctx) throws Exception {
        INewOrgUnitFacade inou = ctx == null ? NewOrgUnitFacadeFactory.getRemoteInstance() : NewOrgUnitFacadeFactory.getLocalInstance(ctx);
        return inou.isOrgStart();
    }
}

