/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.NewOrgF7FacadeFactory;
import com.kingdee.eas.basedata.org.OrgAssistInfo;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUtils;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.UnionVersionStatusEnum;
import com.kingdee.eas.basedata.org.client.BizOrgRangeF7PromptDialog;
import com.kingdee.eas.basedata.org.client.OrgRangeF7PromptDialog;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class AccreditPermF7PromptDialog
extends OrgRangeF7PromptDialog {
    private static Logger logger = Logger.getLogger(BizOrgRangeF7PromptDialog.class);
    private boolean isDisplayMaintain = true;
    private List mutiRoots = null;

    public AccreditPermF7PromptDialog(UserInfo targetUser, boolean isBatchAccredit) {
        super(targetUser);
    }

    public AccreditPermF7PromptDialog(IUIObject _uiObject, UserInfo targetUser, boolean isBatchAccredit) {
        super(_uiObject, targetUser);
        this.setMultiSelect(isBatchAccredit);
    }

    public AccreditPermF7PromptDialog(Frame _owner, UserInfo targetUser, boolean isBatchAccredit) {
        super(_owner, targetUser);
        this.setMultiSelect(isBatchAccredit);
    }

    public AccreditPermF7PromptDialog(Dialog _owner, UserInfo targetUser, boolean isBatchAccredit) {
        super(_owner, targetUser);
        this.setMultiSelect(isBatchAccredit);
    }

    private void initMutiRoots() {
        if (this.mutiRoots == null) {
            try {
                this.mutiRoots = this.buildMutiRoots();
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }

    private List buildMutiRoots() throws Exception {
        ArrayList<FullOrgUnitInfo> result = new ArrayList<FullOrgUnitInfo>();
        boolean isSuperAuAdmin = Administrator.isSuperAuAdmin((IObjectPK)new ObjectUuidPK(this.targetUser.getId()));
        if (isSuperAuAdmin) {
            FullOrgUnitInfo unitInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectStringPK("00000000-0000-0000-0000-000000000000CCE7AED4"));
            result.add(unitInfo);
            return result;
        }
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
        return NewOrgF7FacadeFactory.getRemoteInstance().getMutiRootNodes(null);
    }

    @Override
    public void show() {
        this.initMutiRoots();
        super.show();
    }

    @Override
    protected void initParam() {
        super.initParam();
        this.setTitle(this.getName("CommonF7Tile"));
        this.setShowAssistantOrg(true);
        this.setNeedAddOrgRange();
    }

    @Override
    protected void setNeedAddOrgRange() {
        this.needAddOrgRange = true;
    }

    @Override
    protected OrgViewType[] createOrgViewType() {
        OrgViewType[] retOrgViewAry = null;
        ArrayList<OrgViewType> orgViewTypeList = new ArrayList<OrgViewType>();
        orgViewTypeList.add(OrgViewType.getInstance(this.getName("All"), -1, "", ""));
        Collection col = OrgTypeInfoMgr.getInstance().getAllOrgTypeInfo();
        for (OrgTypeInfo orgTypeInfo : col) {
            if (orgTypeInfo.getOrgViewType() == null) continue;
            orgViewTypeList.add(orgTypeInfo.getOrgViewType());
        }
        retOrgViewAry = new OrgViewType[orgViewTypeList.size()];
        for (int i = 0; i < orgViewTypeList.size(); ++i) {
            retOrgViewAry[i] = (OrgViewType)((Object)orgViewTypeList.get(i));
        }
        return retOrgViewAry;
    }

    private StringBuffer appendMaintainCU(String cuID) {
        StringBuffer maintainOQL = new StringBuffer();
        if (this.isDisplayMaintain && !StringUtils.isEmpty((String)cuID)) {
            maintainOQL.append(" or (unit.maintainCU.id in (").append(cuID).append(")").append(" and tree.CU.id not in (").append(cuID).append(")").append(")");
        }
        return maintainOQL;
    }

    private TreeModel buildTreeModelOnMutiRoot(OrgViewType orgViewType) throws EASBizException, BOSException {
        DefaultKingdeeTreeNode virtualRoot = this.buildVirtualRoot(orgViewType);
        return new DefaultTreeModel((TreeNode)virtualRoot){

            @Override
            public boolean isLeaf(Object node) {
                CoreBaseInfo info = (CoreBaseInfo)((DefaultKingdeeTreeNode)node).getUserObject();
                return info != null && (Boolean)info.get("isleaf") == true;
            }
        };
    }

    private DefaultKingdeeTreeNode buildVirtualRoot(OrgViewType orgViewType) throws EASBizException, BOSException {
        if (this.mutiRoots != null && this.mutiRoots.size() > 0) {
            DefaultKingdeeTreeNode rootNode = new DefaultKingdeeTreeNode();
            int j = this.mutiRoots.size();
            for (int i = 0; i < j; ++i) {
                CoreBaseInfo userObject = this.getNodeUserObject(orgViewType, (FullOrgUnitInfo)this.mutiRoots.get(i));
                if (userObject == null) continue;
                DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)userObject);
                rootNode.add((MutableTreeNode)node);
            }
            return rootNode;
        }
        return null;
    }

    private CoreBaseInfo getNodeUserObject(OrgViewType orgViewType, FullOrgUnitInfo unitInfo) throws BOSException, EASBizException {
        if (this.isCbTypeTextEqualsALL()) {
            return (CoreBaseInfo)unitInfo.clone();
        }
        OrgType orgType = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(orgViewType).getOrgType();
        if (OrgUtils.isOrgType(unitInfo, orgType)) {
            String treeID = this.getComboTreeSelectedItem().getId().toString();
            OrgStructureInfo structureInfo = this.getStructureByUnitAndTree(treeID, unitInfo);
            return structureInfo;
        }
        return null;
    }

    private OrgStructureInfo getStructureByUnitAndTree(String treeID, FullOrgUnitInfo selectedNode) throws BOSException, EASBizException {
        IOrgStructure iStructure = OrgStructureFactory.getRemoteInstance();
        StringBuffer oql = new StringBuffer();
        oql.append("select id,longNumber,level,isLeaf,unit.name,unit.number,unit.iscu,unit.cu.id where unit.id = '").append(selectedNode.getId().toString()).append("' and tree.id = '").append(treeID).append("'");
        return iStructure.getOrgStructureInfo(oql.toString());
    }

    @Override
    protected CoreBaseInfo prepareUserObject(OrgViewType orgViewType, OrgTreeInfo orgTreeInfo) throws BOSException {
        if (orgViewType == OrgViewType.UNIONDEBT) {
            StringBuffer oql = new StringBuffer("select unit.id, unit.name, unit.longnumber, unit.level, isleaf, longnumber, unit.isunion ");
            oql.append(" where tree.id = '").append(orgTreeInfo.getId()).append("' and level = 1");
            try {
                return OrgStructureFactory.getRemoteInstance().getOrgStructureInfo(oql.toString());
            }
            catch (EASBizException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (this.mutiRoots != null && this.mutiRoots.size() == 1) {
            this.setRootUnitID(((FullOrgUnitInfo)this.mutiRoots.get(0)).getId().toString());
            return null;
        }
        return null;
    }

    @Override
    public TreeModel buildTreeModel(OrgViewType orgViewType, OrgTreeInfo orgTreeInfo, DefaultKingdeeTreeNode selectedNode) throws Exception {
        if (selectedNode == null) {
            if (this.mutiRoots != null && this.mutiRoots.size() > 1 && orgViewType != OrgViewType.UNIONDEBT) {
                return this.buildTreeModelOnMutiRoot(orgViewType);
            }
            if (this.mutiRoots != null && this.mutiRoots.size() == 1 && this.isCbTypeTextEqualsALL()) {
                selectedNode = new DefaultKingdeeTreeNode();
                selectedNode.setUserObject(this.mutiRoots.get(0));
            } else if (orgViewType == OrgViewType.UNIONDEBT) {
                if (orgTreeInfo == null) {
                    return new DefaultTreeModel((TreeNode)new DefaultKingdeeTreeNode());
                }
                String oql = "select id, unit.name, longNumber where tree.id = '" + orgTreeInfo.getId().toString() + "' and level = 1";
                OrgStructureInfo unionRoot = OrgStructureFactory.getRemoteInstance().getOrgStructureInfo(oql);
                selectedNode = new DefaultKingdeeTreeNode();
                selectedNode.setUserObject((Object)unionRoot);
            }
        }
        return super.buildTreeModel(orgViewType, orgTreeInfo, selectedNode);
    }

    @Override
    protected OrgAssistInfo buildNewOrgF7AssistInfo(OrgViewType orgViewType, OrgTreeInfo orgTreeInfo, CoreBaseInfo userObject) throws EASBizException, BOSException {
        OrgAssistInfo info = super.buildNewOrgF7AssistInfo(orgViewType, orgTreeInfo, userObject);
        info.setDisplayMaintain(this.isDisplayMaintain);
        if (this.isCbTypeTextEqualsALL()) {
            info.setAppHandleClassName("com.kingdee.eas.basedata.org.app.helper.BizOrgRangeDirectTreeNode");
            ArrayList<String> decorators = new ArrayList<String>();
            decorators.add("com.kingdee.eas.basedata.org.app.helper.UnitAssemblage");
            decorators.add("com.kingdee.eas.basedata.org.app.helper.NormalFilter4F7Decorator");
            decorators.add("com.kingdee.eas.basedata.org.app.helper.OrgRangeFilter4F7Decorator");
            info.setConstructParam(decorators);
        }
        StringBuffer extraFilters = new StringBuffer();
        extraFilters.append(" AND ").append("\"BASEUNIT\"").append(".FID IN (").append(this.appendOrgRangeSQL(this.getOrgRangeType())).append(")");
        info.setNeedAddOrgRange(false);
        info.setNeedAddUserCU(false);
        info.setNeedAddCU(false);
        info.setIgnoreUnionGroup(false);
        info.setUnioNeedOrgRange(true);
        info.setExtraFilters(extraFilters.toString());
        if (this.needAddOrgRange) {
            info.setNeedConsiderFaultTree(true);
        }
        info.setNeedConsiderFaultTree(true);
        String orgRangeSQL = "select forgid from t_pm_orgrange where fuserid = '" + this.targetUser.getId().toString() + "' and ftype = 10";
        info.setOrgRangeSQL(orgRangeSQL);
        return info;
    }

    @Override
    protected int getOrgRangeType() {
        return 1;
    }

    @Override
    protected FilterInfo buildTreeNodeFilter(Object userObject) throws BOSException {
        FilterInfo result = new FilterInfo();
        if (this.isCbTypeTextEqualsALL() && userObject != null) {
            if (userObject instanceof OrgTreeInfo) {
                result = this.getTreeNodeFilter4OrgTreeInfo((OrgTreeInfo)userObject);
            } else if (userObject instanceof FullOrgUnitInfo) {
                FullOrgUnitInfo tmp = (FullOrgUnitInfo)userObject;
                if (!tmp.isIsUnion()) {
                    result = super.buildTreeNodeFilter(userObject);
                    if (this.isChkSubSelected() && tmp.isIsCU()) {
                        result.mergeFilter(this.getTreeNodeFilter4FullOrgUnit(tmp), "OR");
                    }
                } else {
                    String[] treeID = new String[]{tmp.getString("treeId")};
                    String treeCUID = tmp.getString("treeCUID");
                    result.getFilterItems().add(new FilterItemInfo("id", (Object)this.getUnitIDFromOrgStructure(treeID, treeCUID, tmp.getString("structLongNumber"), this.isChkSubSelected()), CompareType.INCLUDE));
                }
            }
        } else if (this.getComboTypeSelectedItem() == OrgViewType.UNIONDEBT) {
            result = super.buildTreeNodeFilter(userObject);
            result.mergeFilter(this.addTreeFilter(), "AND");
        } else {
            return super.buildTreeNodeFilter(userObject);
        }
        return result;
    }

    @Override
    protected StringBuffer appendOrgRangeSQL(int orgRangeType) {
        StringBuffer temp = new StringBuffer();
        if (orgRangeType == 2) {
            temp.append("SELECT FOrgID").append(" FROM T_PM_OrgRange ").append(" WHERE FUserID = '").append(this.currentUser.getId()).append("' AND FType = ").append(20);
        } else {
            UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
            temp.append(" select baseunit.fid from T_PM_OrgRange orgRange").append(" left outer join t_org_baseunit baseunit on orgRange.forgid = baseunit.FControlUnitId").append(" where orgRange.fuserid = '").append(this.currentUser.getId()).append("' and orgRange.ftype = ");
            if (Administrator.isAdminType((UserType)userInfo.getType())) {
                temp.append(10);
            } else {
                temp.append(30);
            }
        }
        temp.append(" AND baseunit.fid  in ( ").append(" select baseunit.fid from T_PM_OrgRange orgRange").append(" left outer join t_org_baseunit baseunit on orgRange.forgid = baseunit.FId").append(" where orgRange.fuserid = '").append(this.targetUser.getId()).append("' and orgRange.ftype = ").append(10).append(" )");
        return temp;
    }

    private FilterInfo getTreeNodeFilter4OrgTreeInfo(OrgTreeInfo info) throws BOSException {
        FilterInfo filter = new FilterInfo();
        if (info != null) {
            String[] treeID = new String[]{info.getId().toString()};
            String treeCUID = info.getCU().getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.getUnitIDFromOrgStructure(treeID, treeCUID, null, this.isChkSubSelected()), CompareType.INCLUDE));
        }
        return filter;
    }

    private FilterInfo getTreeNodeFilter4FullOrgUnit(FullOrgUnitInfo info) throws BOSException {
        FilterInfo filter = new FilterInfo();
        if (info != null) {
            List orgTreeInfos = null;
            try {
                orgTreeInfos = NewOrgF7FacadeFactory.getRemoteInstance().getCUUnion(new String[]{info.getId().toString()}, this.buildNewOrgF7AssistInfo(null, null, null));
            }
            catch (EASBizException e) {
                throw new BOSException((Throwable)e);
            }
            String[] ids = null;
            if (orgTreeInfos != null && orgTreeInfos.size() > 0) {
                ids = new String[orgTreeInfos.size()];
                int j = orgTreeInfos.size();
                for (int i = 0; i < j; ++i) {
                    ids[i] = ((OrgTreeInfo)orgTreeInfos.get(i)).getId().toString();
                }
            } else {
                ids = new String[]{"nodata"};
            }
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.getUnitIDFromOrgStructure(ids, info.getId().toString(), null, true), CompareType.INCLUDE));
        }
        return filter;
    }

    private FilterInfo addTreeFilter() throws BOSException {
        OrgTreeInfo treeInfo = this.getComboTreeSelectedItem();
        FilterInfo filter = new FilterInfo();
        Set set = NewOrgF7FacadeFactory.getRemoteInstance().getUserOrgRange4Union((IObjectPK)new ObjectUuidPK(this.targetUser.getId()));
        filter.getFilterItems().add(new FilterItemInfo("tree.type", (Object)new Integer(8), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("unit.isunion", (Object)new Integer(1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("tree.status", (Object)new Integer(UnionVersionStatusEnum.START.getValue()), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("tree.status", (Object)new Integer(UnionVersionStatusEnum.ARCHIVE.getValue()), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)set, CompareType.INCLUDE));
        filter.setMaskString("#0 and #1 and (#2 or #3) and #4");
        return filter;
    }

    private OrgStructureCollection loadDataBelowTreeInfo(String[] treeIDs, String treeCUID, String longNumber, boolean includeSub) throws BOSException, EASBizException {
        StringBuffer oql = new StringBuffer();
        OrgStructureCollection coll = null;
        if (!StringUtils.isEmpty((String)treeCUID) && treeIDs != null) {
            String longNumberStr = "";
            String level = "";
            if (!StringUtils.isEmpty((String)longNumber)) {
                longNumberStr = " and (longnumber = '" + longNumber + "' or longnumber like '" + longNumber + "!%')";
                if (!includeSub) {
                    level = " and (level >= " + longNumber.split("!").length + " and level <= " + (longNumber.split("!").length + 1) + ")";
                }
            }
            oql.append("select unit.id ").append(" where unit.isunion = 1 and tree.id in (").append(this.transArr2String(treeIDs)).append(")").append(!StringUtils.isEmpty((String)longNumber) || includeSub ? "" : " and level = 1 ").append(longNumberStr).append(level).append(" and (tree.CU.id = '").append(treeCUID).append("'").append(this.appendMaintainCU("'" + treeCUID + "'")).append(") order by longnumber");
            IOrgStructure iStructure = OrgStructureFactory.getRemoteInstance();
            coll = iStructure.getOrgStructureCollection(oql.toString());
        }
        return coll;
    }

    private Set getUnitIDFromOrgStructure(String[] treeID, String treeCUID, String longNumber, boolean includeSub) throws BOSException {
        HashSet<String> result = new HashSet<String>();
        if (!StringUtils.isEmpty((String)treeCUID) && treeID != null) {
            OrgStructureCollection coll = null;
            try {
                coll = this.loadDataBelowTreeInfo(treeID, treeCUID, longNumber, includeSub);
            }
            catch (EASBizException e) {
                throw new BOSException((Throwable)e);
            }
            if (coll != null && coll.size() > 0) {
                int j = coll.size();
                for (int i = 0; i < j; ++i) {
                    result.add(coll.get(i).getUnit().getId().toString());
                }
            } else {
                result.add("nodata");
            }
        }
        return result;
    }

    @Override
    protected OrgTreeCollection fillTreeComboOnUnion() throws EASBizException, BOSException {
        OrgTreeCollection coll = new OrgTreeCollection();
        List orgTreeInfos = NewOrgF7FacadeFactory.getRemoteInstance().getUnion4AccreditPerm(this.targetUser);
        if (orgTreeInfos != null) {
            int j = orgTreeInfos.size();
            for (int i = 0; i < j; ++i) {
                coll.add((OrgTreeInfo)orgTreeInfos.get(i));
            }
        }
        return coll;
    }

    @Override
    protected FilterInfo getOtherOuterFilter() throws ParserException {
        FilterInfo filter = new FilterInfo();
        String item = "orgTypeStr";
        if (!this.isCbTypeTextEqualsALL()) {
            item = "unit.orgTypeStr";
        }
        return filter;
    }

    @Override
    protected FilterInfo getOrgRangeFilter() throws ParserException {
        StringBuffer result = new StringBuffer();
        if (!this.isCbTypeTextEqualsALL()) {
            result.append("UNIT.id in (").append(this.appendOrgRangeSQL(this.getOrgRangeType())).append(")");
        } else {
            result.append("id  in (").append(this.appendOrgRangeSQL(this.getOrgRangeType())).append(")");
        }
        return new FilterInfo(result.toString());
    }

    public boolean isDisplayMaintain() {
        return this.isDisplayMaintain;
    }

    public void setDisplayMaintain(boolean isDisplayMaintain) {
        this.isDisplayMaintain = isDisplayMaintain;
    }

    @Override
    public boolean isCbTypeTextEqualsALL() {
        return this.getComboTypeSelectedItem().getValue() == -1;
    }
}

