/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.EditorFactory;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.base.permission.client.util.UITools;
import com.kingdee.eas.basedata.org.AfterOrgMoveHandlerInfo;
import com.kingdee.eas.basedata.org.AfterOrgMoveTaskCollection;
import com.kingdee.eas.basedata.org.AfterOrgMoveTaskFactory;
import com.kingdee.eas.basedata.org.AfterOrgMoveTaskInfo;
import com.kingdee.eas.basedata.org.ExecuteStatusEnum;
import com.kingdee.eas.basedata.org.IAfterOrgMoveHandler;
import com.kingdee.eas.basedata.org.OrgMoveParam;
import com.kingdee.eas.basedata.org.client.AbstractAfterOrgMoveUI;
import com.kingdee.eas.basedata.org.client.helper.OrgMoveClientHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class AfterOrgMoveUI
extends AbstractAfterOrgMoveUI {
    private static final Logger logger = CoreUIObject.getLogger(AfterOrgMoveUI.class);
    String strResource = "com.kingdee.eas.basedata.org.client.OrgResource";
    String taskIdentityStr = null;
    String selectedOrgId = null;
    private static final String STEP = "step";
    private static final String EXECUTE = "execute";
    private static final String PARAM = "param";
    private static final String HANDLER = "handler";
    private static final String CREATE_TIME = "createTime";
    private static final String EXECUTE_TIME = "executeTime";
    private static final String TASK = "task";
    private static final String DEPENDENCE = "dependence";
    private static final String IS_SELECTED = "isSelected";
    private static final String SPLIT = ",";
    List<AfterOrgMoveHandlerInfo> afterOrgMoveHandlerInfoList = null;
    Map<String, AfterOrgMoveHandlerInfo> keyHandlerMap = null;
    SimpleDateFormat dateFormat = new SimpleDateFormat(CtrlFormatUtilities.getDateTimeFormatString());

    public void onLoad() throws Exception {
        super.onLoad();
        this.prepare();
        this.initButton();
        this.initTable();
        this.fillTable(false);
    }

    private void initButton() {
        this.setButtonDefaultStyl(this.btnSelectAll);
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.setButtonDefaultStyl(this.btnClearAll);
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        if (!this.isHistory()) {
            this.kcbDisplayExecuted.setVisible(false);
        }
    }

    @Override
    protected void kcbDisplayExecuted_stateChanged(ChangeEvent e) throws Exception {
        this.refresh(this.kcbDisplayExecuted.isSelected());
    }

    private void refresh(boolean showExecute) throws BOSException {
        this.kdTable.removeRows();
        this.fillTable(showExecute);
    }

    public boolean isHistory() {
        return StringUtils.isEmpty((String)this.taskIdentityStr);
    }

    private void prepare() {
        this.taskIdentityStr = (String)this.getUIContext().get("taskIdentityKey");
        this.selectedOrgId = (String)this.getUIContext().get("selectedOrgId");
        this.afterOrgMoveHandlerInfoList = OrgMoveClientHelper.getAfterOrgMoveHandlerInfoList();
        this.keyHandlerMap = this.getKeyHandlerMap(this.afterOrgMoveHandlerInfoList);
    }

    private void fillTable(boolean showExecuted) throws BOSException {
        AfterOrgMoveTaskCollection taskCol = OrgMoveClientHelper.getTaskList(this.taskIdentityStr, this.selectedOrgId, showExecuted);
        int size = taskCol.size();
        for (int i = 0; i < size; ++i) {
            AfterOrgMoveTaskInfo info = taskCol.get(i);
            AfterOrgMoveHandlerInfo handlerInfo = this.keyHandlerMap.get(info.getHandler());
            IAfterOrgMoveHandler handler = this.getAfterOrgMoveHandler(handlerInfo.getClassName());
            if (handler == null) continue;
            OrgMoveParam param = (OrgMoveParam)JSONObject.parseObject((String)info.getParamObj(), OrgMoveParam.class);
            handler.setOrgMoveParam(param);
            if (!handler.isNeedDisplay()) continue;
            IRow row = this.kdTable.addRow();
            row.getCell(IS_SELECTED).setValue((Object)false);
            row.getCell(STEP).setValue((Object)handlerInfo.getDescription());
            row.getCell(HANDLER).setValue((Object)handlerInfo);
            row.getCell(EXECUTE).setValue((Object)info.getExecuteStatus());
            row.getCell(PARAM).setValue((Object)param);
            row.getCell(TASK).setValue((Object)info);
            row.getCell(CREATE_TIME).setValue((Object)this.dateFormat.format(new Date(info.getCreateTime().getTime())));
            if (info.getExecuteTime() != null) {
                row.getCell(EXECUTE_TIME).setValue((Object)this.dateFormat.format(new Date(info.getExecuteTime().getTime())));
            }
            row.getCell(DEPENDENCE).setValue((Object)this.getDependence(handlerInfo));
        }
    }

    private String getDependence(AfterOrgMoveHandlerInfo handler) {
        String dependenceStr = handler.getDependence();
        if (StringUtils.isEmpty((String)dependenceStr)) {
            return "";
        }
        String[] dependenceKeys = dependenceStr.split(SPLIT);
        StringBuilder dependenceNames = new StringBuilder();
        for (String key : dependenceKeys) {
            dependenceNames.append(this.keyHandlerMap.get(key).getDescription()).append(SPLIT);
        }
        dependenceNames.deleteCharAt(dependenceNames.length() - 1);
        return dependenceNames.toString();
    }

    private Map<String, AfterOrgMoveHandlerInfo> getKeyHandlerMap(List<AfterOrgMoveHandlerInfo> afterOrgMoveHandlerInfoList) {
        HashMap<String, AfterOrgMoveHandlerInfo> keyHandlerMap = new HashMap<String, AfterOrgMoveHandlerInfo>();
        for (AfterOrgMoveHandlerInfo info : afterOrgMoveHandlerInfoList) {
            keyHandlerMap.put(info.getKey(), info);
        }
        return keyHandlerMap;
    }

    private void initTable() {
        this.kdTable.checkParsed();
        this.kdTable.getStyleAttributes().setLocked(true);
        this.kdTable.getColumn(IS_SELECTED).setEditor((ICellEditor)new EditorFactory.BooleanEditor());
        this.kdTable.getColumn(IS_SELECTED).getStyleAttributes().setLocked(false);
        this.kdTable.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                AfterOrgMoveUI.this.tableClickHandle(e);
            }
        });
        if (!this.isHistory()) {
            this.kdTable.getColumn(EXECUTE_TIME).getStyleAttributes().setHided(true);
        }
    }

    private List<IRow> getDependenceRows(IRow row) {
        ArrayList<IRow> ret = new ArrayList<IRow>();
        AfterOrgMoveHandlerInfo handler = (AfterOrgMoveHandlerInfo)row.getCell(HANDLER).getValue();
        String[] dependenceKeys = handler.getDependence().split(SPLIT);
        HashSet<String> dependenceKeySet = new HashSet<String>();
        for (String dependence : dependenceKeys) {
            dependenceKeySet.add(dependence);
        }
        AfterOrgMoveTaskInfo task = (AfterOrgMoveTaskInfo)row.getCell(TASK).getValue();
        String identity = task.getIdentity();
        int count = this.kdTable.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow tempRow = this.kdTable.getRow(i);
            AfterOrgMoveHandlerInfo tempHandler = (AfterOrgMoveHandlerInfo)tempRow.getCell(HANDLER).getValue();
            String tempKey = tempHandler.getKey();
            AfterOrgMoveTaskInfo tempTask = (AfterOrgMoveTaskInfo)tempRow.getCell(TASK).getValue();
            if (!dependenceKeySet.contains(tempKey) || !identity.equals(tempTask.getIdentity()) || !ExecuteStatusEnum.notExecuted.equals((Object)tempTask.getExecuteStatus())) continue;
            ret.add(tempRow);
        }
        return ret;
    }

    private IAfterOrgMoveHandler getAfterOrgMoveHandler(String handlerClassName) {
        try {
            Class<?> handlerClass = Class.forName(handlerClassName);
            return (IAfterOrgMoveHandler)handlerClass.newInstance();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            return null;
        }
    }

    public void tableClickHandle(KDTMouseEvent e) {
        if (e.getClickCount() != 2) {
            return;
        }
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.kdTable);
        if (row == null) {
            return;
        }
        this.executeTask(row);
    }

    private void executeTaskWithUI(IAfterOrgMoveHandler handler) throws UIException {
        String bizCoreUIClassName = handler.getUIClassName();
        HashMap<String, IAfterOrgMoveHandler> uiContext = new HashMap<String, IAfterOrgMoveHandler>();
        uiContext.put("afterOrgMoveHandlerKey", handler);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(bizCoreUIClassName, uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    private void executeTaskWithoutUI(final IAfterOrgMoveHandler handler) {
        LongTimeDialog dialog = UITools.getDialog((Component)((Object)this));
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                handler.execute();
                handler.setFinished(true);
                return null;
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        dialog.show();
    }

    private boolean isNotExecuted(AfterOrgMoveTaskInfo task) {
        return ExecuteStatusEnum.notExecuted.equals((Object)task.getExecuteStatus());
    }

    private boolean executeTask(IRow row) {
        AfterOrgMoveTaskInfo task = (AfterOrgMoveTaskInfo)row.getCell(TASK).getValue();
        if (!this.isNotExecuted(task)) {
            return true;
        }
        List<IRow> dependenceRows = this.getDependenceRows(row);
        if (dependenceRows != null && dependenceRows.size() > 0) {
            for (IRow dependenceRow : dependenceRows) {
                boolean result = this.executeTask(dependenceRow);
                if (result) continue;
                return result;
            }
        }
        row.getCell(EXECUTE).setValue((Object)EASResource.getString((String)this.strResource, (String)"EXECUTING"));
        this.kdTable.reLayoutAndPaint();
        OrgMoveParam orgMoveParam = (OrgMoveParam)row.getCell(PARAM).getValue();
        orgMoveParam.setTask(task);
        String handlerClassName = ((AfterOrgMoveHandlerInfo)row.getCell(HANDLER).getValue()).getClassName();
        try {
            IAfterOrgMoveHandler handler = this.getAfterOrgMoveHandler(handlerClassName);
            if (handler == null) {
                return true;
            }
            handler.setOrgMoveParam(orgMoveParam);
            String bizCoreUIClassName = handler.getUIClassName();
            if (bizCoreUIClassName != null) {
                this.executeTaskWithUI(handler);
            } else {
                this.executeTaskWithoutUI(handler);
            }
            if (handler.isFinished()) {
                List<String> disabledHandlerKesy = handler.getDisabledHandlerKeys();
                if (disabledHandlerKesy != null && disabledHandlerKesy.size() > 0) {
                    this.handleDisabledTaskIds(disabledHandlerKesy);
                }
                task.setExecuteStatus(ExecuteStatusEnum.executed);
                task.setExecuteTime(new Timestamp(Calendar.getInstance().getTimeInMillis()));
                SelectorItemCollection selectors = new SelectorItemCollection();
                selectors.add(new SelectorItemInfo("executeStatus"));
                selectors.add(new SelectorItemInfo(EXECUTE_TIME));
                AfterOrgMoveTaskFactory.getRemoteInstance().updatePartial(task, selectors);
                row.getCell(EXECUTE).setValue((Object)EASResource.getString((String)this.strResource, (String)"EXECUTED"));
                row.getCell(EXECUTE_TIME).setValue((Object)this.dateFormat.format(task.getExecuteTime()));
            } else {
                row.getCell(EXECUTE).setValue((Object)EASResource.getString((String)this.strResource, (String)"NOT_EXECUTED"));
            }
            return handler.isFinished();
        }
        catch (Exception e1) {
            logger.error((Object)"", (Throwable)e1);
            return false;
        }
    }

    private void handleDisabledTaskIds(List<String> disabledHandlerKeys) throws EASBizException, BOSException {
        int rowCount = this.kdTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.kdTable.getRow(i);
            AfterOrgMoveTaskInfo task = (AfterOrgMoveTaskInfo)row.getCell(TASK).getValue();
            if (!disabledHandlerKeys.contains(task.getHandler())) continue;
            row.getStyleAttributes().setHided(true);
            task.setExecuteStatus(ExecuteStatusEnum.needNotExecute);
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("executeStatus"));
            AfterOrgMoveTaskFactory.getRemoteInstance().updatePartial(task, selectors);
        }
    }

    @Override
    public void actionBtnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    @Override
    public void actionBatchExecute_actionPerformed(ActionEvent e) throws Exception {
        int rowCount = this.kdTable.getRowCount();
        boolean hasSelected = false;
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.kdTable.getRow(i);
            ICell isSelectedCell = row.getCell(IS_SELECTED);
            boolean isSelected = (Boolean)isSelectedCell.getValue();
            if (!isSelected) continue;
            hasSelected = true;
            this.executeTask(row);
        }
        if (!hasSelected) {
            MsgBox.showInfo((String)EASResource.getString((String)this.strResource, (String)"PLEASE_SELECT_TASK"));
        }
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.setAllSelect(true);
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        this.setAllSelect(false);
    }

    private void setAllSelect(boolean selected) {
        int rowCount = this.kdTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.kdTable.getRow(i).getCell(IS_SELECTED).setValue((Object)selected);
        }
    }
}

