/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.EditorFactory;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.AdminOrgRangeFilterUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.BizDataCheckInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.INewOUInnerFacade;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.NewOUInnerFacadeFactory;
import com.kingdee.eas.basedata.org.NewOrgUnitFacadeFactory;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.basedata.org.OrgAssistInfo;
import com.kingdee.eas.basedata.org.OrgMoveParam;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.AbstractBizTypeOrgMoveUI;
import com.kingdee.eas.basedata.org.client.AfterOrgMoveUI;
import com.kingdee.eas.basedata.org.client.NewOrgF7PromptDialog;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.client.NewOuF7PromptDialog;
import com.kingdee.eas.basedata.org.client.helper.OrgMoveClientHelper;
import com.kingdee.eas.basedata.org.client.uihelper.IOrgTypeClientHelper;
import com.kingdee.eas.basedata.org.client.uihelper.OrgTypeClientCenter;
import com.kingdee.eas.basedata.org.client.uihelper.OrgTypeClientDefaultImpl;
import com.kingdee.eas.basedata.org.helper.OrgHelper;
import com.kingdee.eas.basedata.org.service.OrgCommonUtils;
import com.kingdee.eas.client.startup.exception.ExceptionHandler;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class BizTypeOrgMoveUI
extends AbstractBizTypeOrgMoveUI {
    private static final Logger logger = CoreUIObject.getLogger(BizTypeOrgMoveUI.class);
    private static final String RESOURCE = "com.kingdee.eas.basedata.org.OrgDataUpdateResource";
    private static final String NEED_CHANGE_COL = "needChange";
    private static final String ORG_TYPE_COL = "orgType";
    private static final String OLD_PARENT_COL = "oldParent";
    private static final String NEW_PARENT_COL = "newParent";
    private FullOrgUnitInfo originOrg;
    private boolean isStartSHR;
    private boolean isSupportSyncFromAdmin = false;
    private OrgMoveParam data = null;
    private CtrlUnitInfo currentCtrlUnit = SysContext.getSysContext().getCurrentCtrlUnit();

    public void onLoad() throws Exception {
        super.onLoad();
        this.kdTable.checkParsed();
        this.prepareData();
        this.initPmtNewParent();
        this.initTable();
        this.fillTable();
    }

    private void initPmtNewParent() throws Exception {
        this.ptmNewParent.setSelector((KDPromptSelector)this.getShiftToF7());
        this.ptmNewParent.setEditable(false);
        this.ptmNewParent.setData(null);
    }

    private FullOrgUnitInfo getNewOUParent() {
        FullOrgUnitInfo newParent = (FullOrgUnitInfo)this.ptmNewParent.getData();
        if (newParent == null) {
            newParent = this.originOrg.getParent();
        }
        return newParent;
    }

    private void prepareData() {
        Map uiContext = this.getUIContext();
        this.originOrg = (FullOrgUnitInfo)uiContext.get("originOrg");
        this.isStartSHR = false;
        if (this.originOrg.getId().toString() != null) {
            try {
                this.isStartSHR = NewOrgUnitFacadeFactory.getRemoteInstance().getAdminOrgIsStartSHR(this.originOrg.getId().toString());
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        this.isSupportSyncFromAdmin = OrgHelper.isSupportSyncFromAdmin(null);
    }

    private void initTable() {
        this.kdTable.getColumn(NEED_CHANGE_COL).setEditor((ICellEditor)new EditorFactory.BooleanEditor());
        this.kdTable.getColumn(OLD_PARENT_COL).getStyleAttributes().setLocked(true);
        this.kdTable.getColumn(ORG_TYPE_COL).getStyleAttributes().setLocked(true);
        this.kdTable.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    IRow row;
                    OrgType orgType;
                    if (BizTypeOrgMoveUI.this.isSupportSyncFromAdmin && (orgType = (OrgType)((Object)(row = BizTypeOrgMoveUI.this.kdTable.getRow(e.getRowIndex())).getCell(BizTypeOrgMoveUI.ORG_TYPE_COL).getValue())) == OrgType.Admin) {
                        boolean needChange = (Boolean)row.getCell(BizTypeOrgMoveUI.NEED_CHANGE_COL).getValue();
                        if (needChange) {
                            AdminOrgUnitInfo adminOrgUnitInfo = (AdminOrgUnitInfo)row.getCell(BizTypeOrgMoveUI.NEW_PARENT_COL).getValue();
                            if (adminOrgUnitInfo != null) {
                                FullOrgUnitInfo org = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(adminOrgUnitInfo.getId().toString()));
                                BizTypeOrgMoveUI.this.ptmNewParent.setValue((Object)org);
                            } else {
                                BizTypeOrgMoveUI.this.ptmNewParent.setValue(null);
                            }
                        } else {
                            BizTypeOrgMoveUI.this.ptmNewParent.setValue(null);
                        }
                    }
                }
                catch (Exception e2) {
                    ExceptionHandler.handle((Throwable)e2);
                }
            }

            public void editStarting(KDTEditEvent e) {
                try {
                    ControlUtilities.checkFocusAndCommit();
                }
                catch (ParseException e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
    }

    private void fillTable() throws Exception {
        INewOrgViewFacade iNewOrgView = NewOrgViewFacadeFactory.getRemoteInstance();
        Map typeAndParentMap = iNewOrgView.getParents(this.originOrg.getId().toString());
        for (Map.Entry entry : typeAndParentMap.entrySet()) {
            Integer typeValue = (Integer)entry.getKey();
            OrgType orgType = OrgType.getEnum(typeValue);
            if (orgType == null) continue;
            IRow row = this.kdTable.addRow();
            row.getCell(NEED_CHANGE_COL).setValue((Object)Boolean.TRUE);
            row.getCell(ORG_TYPE_COL).setValue((Object)orgType);
            row.getCell(OLD_PARENT_COL).setValue(entry.getValue());
            IOrgTypeClientHelper iOrgClient = OrgTypeClientCenter.getInstance().getClientImp(orgType);
            NewOrgViewF7PromptDialog f7 = typeValue == 16 ? ((OrgTypeClientDefaultImpl)iOrgClient).createNewF7ByCondition("TREETYPE_BIZUNIT") : ((OrgTypeClientDefaultImpl)iOrgClient).createNewF7ByCondition("TREETYPE_VIRTUALUNIT");
            if (f7 != null) {
                f7.setNeedAddOrgRange(false);
            }
            ICell newParentCell = row.getCell(NEW_PARENT_COL);
            KDBizPromptBox orgPromptBox = new KDBizPromptBox();
            orgPromptBox.setDisplayFormat("$alias$");
            orgPromptBox.setEditFormat("$name$");
            orgPromptBox.setCommitFormat("$name$");
            orgPromptBox.setEditable(false);
            orgPromptBox.setSelector((KDPromptSelector)f7);
            orgPromptBox.setEnabledMultiSelection(false);
            KDTDefaultCellEditor defaultCellEditor = new KDTDefaultCellEditor((IKDEditor)orgPromptBox);
            newParentCell.setEditor((ICellEditor)defaultCellEditor);
            if (this.isStartSHR && orgType == OrgType.Admin) {
                row.getCell(NEED_CHANGE_COL).setValue((Object)Boolean.FALSE);
                row.getCell(NEED_CHANGE_COL).getStyleAttributes().setLocked(true);
                orgPromptBox.setValue(entry.getValue());
                orgPromptBox.setEnabled(false);
            }
            if (!this.isSupportSyncFromAdmin || orgType != OrgType.Admin) continue;
            this.ptmNewParent.setEnabled(false);
        }
    }

    public OrgMoveParam getData() {
        return this.data;
    }

    private void setData(OrgMoveParam data) {
        this.data = data;
    }

    private OrgMoveParam compositeParam() {
        OrgMoveParam orgMoveParam = new OrgMoveParam();
        orgMoveParam.setMovedOrgId(this.originOrg.getId().toString());
        FullOrgUnitInfo newUnitParent = this.getNewOUParent();
        if (newUnitParent != null) {
            orgMoveParam.setNewOUParentId(newUnitParent.getId().toString());
        }
        if (!this.originOrg.getCU().getId().equals((Object)newUnitParent.getCU().getId())) {
            orgMoveParam.setChangeCu(true);
        }
        orgMoveParam.setOldCuId(this.originOrg.getCU().getId().toString());
        orgMoveParam.setNewCuId(newUnitParent.getCU().getId().toString());
        int rowCount = this.kdTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.kdTable.getRow(i);
            ICell needChangeCell = row.getCell(NEED_CHANGE_COL);
            Boolean needChange = (Boolean)needChangeCell.getValue();
            ICell newParentCell = row.getCell(NEW_PARENT_COL);
            OrgUnitInfo newParent = (OrgUnitInfo)newParentCell.getValue();
            if (!needChange.booleanValue() || newParent == null) continue;
            ICell oldParentCell = row.getCell(OLD_PARENT_COL);
            FullOrgUnitInfo oldParent = (FullOrgUnitInfo)oldParentCell.getValue();
            ICell orgTypeCell = row.getCell(ORG_TYPE_COL);
            OrgType orgType = (OrgType)((Object)orgTypeCell.getValue());
            orgMoveParam.addOldAndNewParent(orgType.getValue(), oldParent.getId().toString(), newParent.getId().toString());
        }
        return orgMoveParam;
    }

    @Override
    public void actionBtnConfirm_actionPerformed(ActionEvent e) throws Exception {
        boolean shiftResult;
        if (this.ptmNewParent.isEnabled() && !(shiftResult = this.shiftOU())) {
            this.destroyWindow();
            return;
        }
        OrgMoveParam orgMoveParam = this.compositeParam();
        if (!this.checkReferenceBizDataForAdmin(orgMoveParam)) {
            return;
        }
        INewOUInnerFacade iNOUI = NewOUInnerFacadeFactory.getRemoteInstance();
        iNOUI.ouShift(orgMoveParam);
        String taskIdentity = OrgMoveClientHelper.saveAfterOrgMoveTask(orgMoveParam);
        HashMap<String, String> uiContext = new HashMap<String, String>();
        uiContext.put("taskIdentityKey", taskIdentity);
        IUIWindow afterOrgMoveUI = UIFactory.createUIFactory().create(AfterOrgMoveUI.class.getName(), uiContext);
        afterOrgMoveUI.show();
        this.setData(orgMoveParam);
        this.destroyWindow();
    }

    private boolean checkReferenceBizDataForAdmin(OrgMoveParam orgMoveParam) throws BOSException, EASBizException {
        Set<Integer> orgTypes = orgMoveParam.getOrgTypes();
        if (orgTypes.contains(0)) {
            String newParentId = orgMoveParam.getNewParentId(0);
            String parentName = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)newParentId))).getName();
            if (this.checkIsReference(newParentId) && !MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)(EASResource.getString((String)RESOURCE, (String)"ADMINPARENT") + parentName + EASResource.getString((String)RESOURCE, (String)"ADMINPARENTISREFERENCED2"))))) {
                return false;
            }
        }
        return true;
    }

    private boolean checkIsReference(String parentId) throws BOSException {
        BizDataCheckInfo[] checkInfos = FullOrgUnitFactory.getRemoteInstance().hasBizRefrenceForAdmin(parentId);
        boolean isReference = false;
        for (int i = 0; i < checkInfos.length; ++i) {
            if (checkInfos[i] == null || !checkInfos[i].isRef() || !SystemEnum.GENERALLEDGER.getAlias(this.getLocale()).equals(checkInfos[i].getBizSysName())) continue;
            isReference = true;
        }
        return isReference;
    }

    private boolean shiftOU() throws Exception {
        String strResource = "com.kingdee.eas.basedata.org.client.OUResource";
        if (!this.isSelected()) {
            MsgBox.showInfo((String)EASResource.getString((String)strResource, (String)"PLS_SELECT_NEW_PARENT"));
            SysUtil.abort();
        }
        FullOrgUnitInfo newParentUnit = this.getNewOUParent();
        this.verifyOrgNameDup(newParentUnit);
        ObjectUuidPK newParentPK = new ObjectUuidPK(newParentUnit.getId());
        if (newParentPK != null) {
            FullOrgUnitInfo parentUnit = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)newParentPK);
            if (!this.isContainSubAllOrgType(this.originOrg, parentUnit)) {
                MsgBox.showInfo((String)EASResource.getString((String)strResource, (String)"ContainSubAllOrgType"));
                SysUtil.abort();
            }
            this.originOrg.setParent(parentUnit);
        }
        INewOUInnerFacade iNOUI = NewOUInnerFacadeFactory.getRemoteInstance();
        iNOUI.ouShift((IObjectPK)new ObjectUuidPK(this.originOrg.getId()), (IObjectPK)newParentPK);
        return true;
    }

    private boolean isContainSubAllOrgType(FullOrgUnitInfo originOrg, FullOrgUnitInfo parentUnit) {
        String originOrgTypeStr = originOrg.getOrgTypeStr();
        String newParentOrgTypeStr = parentUnit.getOrgTypeStr();
        if (!StringUtils.isEmpty((String)originOrgTypeStr)) {
            String[] originOrgTypeStrAry = originOrgTypeStr.split(";");
            for (int i = 0; i < originOrgTypeStrAry.length; ++i) {
                String originOrgTypeValue = originOrgTypeStrAry[i];
                if (StringUtils.contains((String)newParentOrgTypeStr, (String)originOrgTypeValue)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isSelected() {
        FullOrgUnitInfo newParent = (FullOrgUnitInfo)this.ptmNewParent.getData();
        if (newParent != null) {
            return true;
        }
        int rowCount = this.kdTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.kdTable.getRow(i);
            ICell needChangeCell = row.getCell(NEED_CHANGE_COL);
            Boolean needChange = (Boolean)needChangeCell.getValue();
            ICell newParentCell = row.getCell(NEW_PARENT_COL);
            OrgUnitInfo newBizParent = (OrgUnitInfo)newParentCell.getValue();
            if (!needChange.booleanValue() || newBizParent == null) continue;
            return true;
        }
        return false;
    }

    private void verifyOrgNameDup(OrgUnitInfo newParentUnit) throws OUException, EASBizException, BOSException {
        StringBuffer oql = new StringBuffer();
        oql.append("where name = '").append(this.originOrg.getName()).append("'");
        if (this.originOrg.getId() != null) {
            oql.append(" and id <> '").append(this.originOrg.getId().toString()).append("'");
        }
        if (newParentUnit != null && newParentUnit.getId() != null) {
            oql.append(" and parent ='").append(newParentUnit.getId().toString()).append("'");
        }
        oql.append(" and ISUNION = 0");
        if (FullOrgUnitFactory.getRemoteInstance().exists(oql.toString())) {
            String path = "com.kingdee.eas.basedata.org.OUException";
            MsgBox.showError((String)EASResource.getString((String)path, (String)"NAME_DUP"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionBtnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.data = null;
        this.destroyWindow();
    }

    private NewOrgF7PromptDialog getShiftToF7() throws Exception {
        boolean isCUAdmin = Administrator.isCUAdmin(null, (IObjectPK)ToolUtils.getCurrentUserPK());
        NewOuF7PromptDialog f7 = new NewOuF7PromptDialog((IUIObject)this){

            @Override
            protected OrgAssistInfo buildNewOrgF7AssistInfo(OrgViewType orgViewType, OrgTreeInfo orgTreeInfo, CoreBaseInfo userObject) throws EASBizException, BOSException {
                OrgAssistInfo assistInfo = super.buildNewOrgF7AssistInfo(orgViewType, orgTreeInfo, userObject);
                StringBuffer result = new StringBuffer();
                result.append(" AND (").append("\"BASEUNIT\"").append(".FId IN (").append(this.appendOrgRangeSQL()).append("))");
                if (this.isCbTypeTextEqualsALL()) {
                    result.append(" and flongnumber <> '" + BizTypeOrgMoveUI.this.originOrg.getLongNumber() + "' and flongnumber not like '" + BizTypeOrgMoveUI.this.originOrg.getLongNumber() + "!%' ");
                } else {
                    result.append(" and STRUCTURE.flongnumber <> '" + BizTypeOrgMoveUI.this.originOrg.getLongNumber() + "' and STRUCTURE.flongnumber not like '" + BizTypeOrgMoveUI.this.originOrg.getLongNumber() + "!%' ");
                }
                assistInfo.setExtraFilters(result.toString());
                return assistInfo;
            }

            @Override
            public FilterInfo getOuterFilterInfo() {
                StringBuffer result = new StringBuffer();
                if (!this.isCbTypeTextEqualsALL()) {
                    result.append("UNIT.id in (").append(this.appendOrgRangeSQL()).append(")");
                } else {
                    result.append("id  in (").append(this.appendOrgRangeSQL()).append(")");
                }
                result.append(" and longnumber <> '" + BizTypeOrgMoveUI.this.originOrg.getLongNumber() + "' and longnumber not like '" + BizTypeOrgMoveUI.this.originOrg.getLongNumber() + "!%' ");
                try {
                    return new FilterInfo(result.toString());
                }
                catch (ParserException e) {
                    e.printStackTrace();
                    return null;
                }
            }

            protected StringBuffer appendOrgRangeSQL() {
                StringBuffer temp = new StringBuffer();
                UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
                temp.append(" select baseunit.fid from T_PM_OrgRange orgRange").append(" left outer join t_org_baseunit baseunit on orgRange.forgid = baseunit.FControlUnitId").append(" where orgRange.fuserid = '").append(userInfo.getId()).append("' and orgRange.ftype = ");
                if (!AdminOrgRangeFilterUtil.isFilterByUserAdminOrgRange(null)) {
                    temp.append(10);
                } else {
                    temp.append(20);
                }
                return temp;
            }
        };
        f7.setShowSub(true);
        f7.setNeedAddSealUp(true);
        f7.setNeedAddAssistant(true);
        if (f7 instanceof NewOuF7PromptDialog) {
            ((NewOuF7PromptDialog)f7).setNeedUnion(false);
        }
        return f7;
    }

    @Override
    protected void ptmNewParent_dataChanged(DataChangeEvent e) throws Exception {
        FullOrgUnitInfo newParentUnit = (FullOrgUnitInfo)this.ptmNewParent.getData();
        if (newParentUnit == null) {
            return;
        }
        int count = this.kdTable.getRowCount();
        Set newParentOrgTypeSet = OrgCommonUtils.getOrgTypeCol(newParentUnit);
        for (int i = 0; i < count; ++i) {
            IRow row = this.kdTable.getRow(i);
            OrgType orgType = (OrgType)((Object)row.getCell(ORG_TYPE_COL).getValue());
            if (!newParentOrgTypeSet.contains((Object)orgType) || this.isBizUnit(newParentUnit.getId().toString(), orgType)) continue;
            ICell newParentCell = row.getCell(NEW_PARENT_COL);
            if (this.isStartSHR && orgType == OrgType.Admin) continue;
            newParentCell.setValue((Object)newParentUnit);
        }
    }

    private boolean isBizUnit(String orgId, OrgType orgType) {
        if (OrgType.Admin.equals((Object)orgType) || OrgType.ControlUnit.equals((Object)orgType)) {
            return false;
        }
        try {
            String isBizUnitField = "isBizUnit";
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo(isBizUnitField));
            OrgUnitInfo orgUnit = OrgCommonUtils.getOrgUnitInfo(null, orgId, orgType, selectors);
            return orgUnit.getBoolean(isBizUnitField);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            return false;
        }
    }
}

