/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.CUBDControlCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.basedata.org.OrgBlankException;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.AbstractCUEditUI;
import com.kingdee.eas.basedata.org.client.f7.NewCtrlF7;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.basedata.org.service.CUBDControlUtils;
import com.kingdee.eas.basedata.org.util.OrgToolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Calendar;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class CUEditUI
extends AbstractCUEditUI {
    String strResource = "com.kingdee.eas.basedata.org.client.OUResource";
    KDTree treeMain = null;
    private CUBDControlCollection controlCol = null;
    private boolean hasBeenSaved = false;
    private String number = null;

    public CUEditUI() throws Exception {
        this.init();
    }

    private void init() {
        this.btnAddNew.setVisible(false);
        this.lblcName.setBoundEditor((JComponent)this.mlbName);
        this.initWorkButtons();
        this.initCtrlSuperior();
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            request.put("oprtState", (Object)this.getOprtState());
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    private void initWorkButtons() {
        this.btnFirst.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnLast.setVisible(false);
    }

    private void initCtrlSuperior() {
        NewCtrlF7 ctrlF7 = new NewCtrlF7();
        ctrlF7.setNeedAddOrgRange(true);
        this.bizPromptSuperior.setSelector((KDPromptSelector)ctrlF7);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnRemove.setVisible(false);
        this.menuItemRemove.setVisible(false);
        this.treeMain = (KDTree)this.getUIContext().get("tree");
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.loadBaseFields();
        try {
            if (this.getOprtState().equals(OprtState.ADDNEW)) {
                this.controlCol = CUBDControlUtils.loadDefaultCUBDControl(null);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        this.getInputMap(2).put(KeyStroke.getKeyStroke("F6"), "actionShowParentCU");
        this.getActionMap().put("actionShowParentCU", (Action)((Object)this.actionShowParentCU));
    }

    private void loadBaseFields() {
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            this.txtCreator.setText(this.editData.getCreator().getName());
            this.dateCreate.setValue((Object)this.editData.getCreateTime());
        } else {
            this.txtCreator.setText(SysContext.getSysContext().getCurrentUserInfo().getName());
            this.dateCreate.setValue((Object)Calendar.getInstance().getTime());
        }
        if (this.editData != null && this.editData.getParent() != null) {
            this.bizPromptSuperior.setData((Object)this.editData.getParent());
        } else {
            this.bizPromptSuperior.setData(null);
            this.bizPromptSuperior.setEnabled(false);
        }
    }

    @Override
    public void storeFields() {
        String oldNumber = null;
        String oldName = null;
        if (this.getOprtState().equals(OprtState.EDIT)) {
            if (!StringUtils.isEmpty((String)this.editData.getNumber())) {
                oldNumber = this.editData.getNumber().trim();
            }
            oldName = this.editData.getName();
        }
        super.storeFields();
        this.number = this.editData.getNumber();
        this.editData.setSyncOldValue(true);
        OrgUnitInfo orgUnitInfo = (OrgUnitInfo)this.bizPromptSuperior.getData();
        if (orgUnitInfo != null) {
            this.editData.setParent(orgUnitInfo.castToFullOrgUnitInfo());
        }
        this.editData.put("isCus", new Boolean(true));
        OrgTypeHelper orgTypeHelper = new OrgTypeHelper(this.editData.getOrgTypeStr());
        orgTypeHelper.addOrgType(OrgType.ControlUnit);
        this.editData.setOrgTypeStr(orgTypeHelper.createOrgTypeStrBySet());
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.storeCUBDControl();
        }
        if (this.getOprtState().equals(OprtState.EDIT)) {
            String newNumber = "";
            if (this.editData.getNumber() != null) {
                newNumber = this.editData.getNumber().trim();
            }
            String newName = this.editData.getName();
            if (oldNumber != null && !oldNumber.equals(newNumber) || oldName != null && !oldName.equals(newName)) {
                this.editData.put("UpdateNumberOrName", Boolean.TRUE);
            }
        }
        this.editData.setNumber(this.editData.getNumber() == null ? null : this.editData.getNumber().trim());
        this.editData.setSyncOldValue(false);
    }

    private void storeCUBDControl() {
        this.controlCol.copyNewToOld();
        this.editData.put("CUBDControl", (Object)this.controlCol);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        String invalidChar;
        int i;
        if (StringUtils.isEmpty((String)this.editData.getNumber())) {
            this.txtNumber.requestFocusInWindow();
            throw new OrgBlankException(OrgBlankException.NUMBER_CAN_NOT_BLANK);
        }
        if (StringUtils.isEmpty((String)this.editData.getName())) {
            this.mlbName.requestFocusInWindow();
            throw new OrgBlankException(OrgBlankException.NAME_CAN_NOT_BLANK);
        }
        String[] allInvalidChar = OrgToolUtils.allInvalidNumberChar(null);
        for (i = 0; i < allInvalidChar.length; ++i) {
            invalidChar = allInvalidChar[i];
            if (this.editData.getNumber().trim().indexOf(invalidChar) == -1) continue;
            this.txtNumber.requestFocus();
            throw new OrgBlankException(OrgBlankException.NUMBER_INCLUDE_FORBIDDEN_CHAR, new Object[]{invalidChar});
        }
        allInvalidChar = OrgToolUtils.allInvalidNameChar(null);
        for (i = 0; i < allInvalidChar.length; ++i) {
            invalidChar = allInvalidChar[i];
            if (this.editData.getName().trim().indexOf(invalidChar) == -1) continue;
            this.mlbName.requestFocus();
            throw new OrgBlankException(OrgBlankException.NAME_INCLUDE_FORBIDDEN_CHAR, new Object[]{invalidChar});
        }
        this.verifyOrgNameDup();
        String oql = "where name = '" + this.editData.getName() + "'";
        if (this.editData.getId() != null) {
            oql = oql + " and id <> '" + this.editData.getId().toString() + "'";
        }
        if (FullOrgUnitFactory.getRemoteInstance().exists(oql) && MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)this.strResource, (String)"ASK_NAME_DUP")) != 0) {
            throw new OUException(OUException.ASK_NAME_DUP);
        }
        OrgUnitInfo parentInfo = (OrgUnitInfo)this.bizPromptSuperior.getData();
        if (parentInfo == null) {
            if (this.editData.getId() == null) {
                throw new OUException(OUException.SUPERIOR_CU_CANT_NULL);
            }
            if (!"00000000-0000-0000-0000-000000000000CCE7AED4".equals(this.editData.getId().toString())) {
                throw new OUException(OUException.SUPERIOR_CU_CANT_NULL);
            }
        }
    }

    private void verifyOrgNameDup() throws OUException, EASBizException, BOSException {
        String oql = "where name = '" + this.editData.getName().replaceAll("'", "''") + "'";
        if (this.editData.getId() != null) {
            oql = oql + " and id <> '" + this.editData.getId().toString() + "'";
        }
        if (this.editData.getParent() != null && this.editData.getParent().getId() != null) {
            oql = oql + " and parent ='" + this.editData.getParent().getId().toString() + "'";
        }
        oql = oql + " and ISUNION = 0";
        if (FullOrgUnitFactory.getRemoteInstance().exists(oql)) {
            String path = "com.kingdee.eas.basedata.org.OUException";
            MsgBox.showError((String)EASResource.getString((String)path, (String)"NAME_DUP"));
            SysUtil.abort();
        }
    }

    protected IObjectValue createNewData() {
        FullOrgUnitInfo info = new FullOrgUnitInfo();
        if (this.getUIContext().get("ParentNode") != null) {
            info.setParent((FullOrgUnitInfo)this.getUIContext().get("ParentNode"));
        } else {
            info.setParent(null);
        }
        info.setIsCU(true);
        return info;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("parent.number"));
        sic.add(new SelectorItemInfo("parent.name"));
        sic.add(new SelectorItemInfo("parent.isOUSealUp"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.name"));
        return sic;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FullOrgUnitFactory.getRemoteInstance();
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        try {
            super.actionSubmit_actionPerformed(e);
        }
        catch (OUException ouex) {
            if (ouex.getSubCode().equals(OUException.ASK_NAME_DUP.getCode())) {
                this.mlbName.requestFocusInWindow();
                return;
            }
            throw ouex;
        }
        catch (Exception ex) {
            throw ex;
        }
        IFullOrgUnit iFull = FullOrgUnitFactory.getRemoteInstance();
        this.hasBeenSaved = true;
        String state = this.getOprtState();
        if (OprtState.ADDNEW.equals(state)) {
            FullOrgUnitInfo unitInfo = iFull.getFullOrgUnitInfo("select id where id = '" + this.idList.getLastID() + "'");
            Administrator.addcu2admin(null, (FullOrgUnitInfo)unitInfo);
            if (!Administrator.isSuperCUAdmin((IObjectPK)ToolUtils.getCurrentUserPK())) {
                String autoAddCu2Admin = ParamManager.getParamValue(null, null, (String)"AutoAddOrg");
                if ("true".equalsIgnoreCase(autoAddCu2Admin)) {
                    Administrator.addCURange(null, (FullOrgUnitInfo)unitInfo);
                } else if (MsgBox.isYes((int)MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)this.strResource, (String)"CONFIRM_ADD_CU_TO_ADMINISTRATOR")))) {
                    Administrator.addCURange(null, (FullOrgUnitInfo)unitInfo);
                } else {
                    Administrator.addcu2AuthenAdmin(null, (FullOrgUnitInfo)unitInfo);
                }
            } else {
                Administrator.addcu2AuthenAdmin(null, (FullOrgUnitInfo)unitInfo);
            }
        }
    }

    protected void showSubmitSuccess() {
        String msg = EASResource.getString((String)this.strResource, (String)"CU_NAME");
        msg = msg + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK");
        this.setMessageText(msg);
        this.setIsShowTextOnly(false);
        this.setShowMessagePolicy(0);
        this.showMessage();
    }

    public boolean destroyWindow() {
        boolean b = super.destroyWindow();
        if (this.hasBeenSaved) {
            // empty if block
        }
        return b;
    }

    @Override
    public void actionShowParentCU_actionPerformed(ActionEvent e) throws Exception {
        super.actionShowParentCU_actionPerformed(e);
        this.kDLabelContainer2.setVisible(!this.kDLabelContainer2.isVisible());
        this.bizPromptSuperior.setVisible(!this.bizPromptSuperior.isVisible());
    }
}

