/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.client.CUAdminListUI;
import com.kingdee.eas.base.permission.client.SpecialDataPermEditUI;
import com.kingdee.eas.basedata.org.AdminOrgRangeFilterUtil;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.INewOrgF7Facade;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.NewOUInnerFacadeFactory;
import com.kingdee.eas.basedata.org.NewOrgF7FacadeFactory;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.basedata.org.OrgAssistInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.AbstractCUListUI;
import com.kingdee.eas.basedata.org.client.CUEditUI;
import com.kingdee.eas.basedata.org.client.OrgSpecialTablesClientUtil;
import com.kingdee.eas.basedata.org.client.di.OrgDIUtil;
import com.kingdee.eas.basedata.org.client.tree.util.OrgTreeHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class CUListUI
extends AbstractCUListUI {
    Logger logger = Logger.getLogger((String)CUListUI.class.getName());
    private boolean initialized = false;
    private static final Color normalColor = new Color(0xF9F9F9);
    private static final Color sealedupColor = new Color(0xD9D9D2);
    private boolean isShowSealedUnit = false;
    private static final int CU_OPERATE_ADD = 1;
    private static final int CU_OPERATE_EDIT = 2;
    private static final int CU_OPERATE_SHOW_SEALUP = 5;
    private static final int CU_OPERATE_SEALUP = 6;
    private static final int CU_OPERATE_UNSEALUP = 7;
    private static final int OU_OPERATE_SHIFT = 9;
    private boolean isRedirect = false;
    private boolean isTreeValueChangedFirst = true;
    String strResource = "com.kingdee.eas.basedata.org.client.OUResource";
    QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    public CUListUI() throws Exception {
        this.tblMain.checkParsed();
        this.menuItemRefreshView.setEnabled(true);
        this.btnCU.setEnabled(true);
        this.btnCU.setIcon(EASResource.getIcon((String)"imgTbtn_conadministrator"));
        this.btnSpecialDataPerm.setEnabled(true);
        this.btnSpecialDataPerm.setIcon(EASResource.getIcon((String)"imgTbtn_dataaccredit"));
        this.btnSpecialDataPerm.setVisible(false);
        this.menuCU.setEnabled(true);
        this.menuItemCUAdmin.setEnabled(true);
        this.menuItemSpecialData.setEnabled(true);
        this.menuItemSpecialData.setVisible(false);
        OrgSpecialTablesClientUtil.setTheKDWorkButtonUsedToRebuildSpecialTables(this.btnSync);
    }

    @Override
    public boolean isPrepareInit() {
        return false;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            request.put("rootID", (Object)this.getRootID());
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
        this.initTblMain();
        this.actionMoveTree.setVisible(false);
        this.addTreeListener();
        this.btnRemove.setVisible(false);
        this.menuItemRemove.setVisible(false);
    }

    private void addTreeListener() {
        this.treeMain.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                DefaultKingdeeTreeNode tmp = (DefaultKingdeeTreeNode)event.getPath().getLastPathComponent();
                if (tmp == null) {
                    return;
                }
                try {
                    CUListUI.this.loadNode(tmp);
                }
                catch (Exception e) {
                    CUListUI.this.logger.error((Object)"error", (Throwable)e);
                }
            }
        });
    }

    private void loadNode(DefaultKingdeeTreeNode tmp) throws BOSException, EASBizException {
        FullOrgUnitInfo unitInfo;
        if (tmp != null && tmp.getUserObject() != null && (unitInfo = (FullOrgUnitInfo)tmp.getUserObject()).get("alreadyLoad") == null) {
            OrgAssistInfo assistInfo = this.buildNewOrgF7AssistInfo();
            INewOrgF7Facade facade = NewOrgF7FacadeFactory.getRemoteInstance();
            List orgCol = facade.getDirectChildren(assistInfo, (CoreBaseInfo)unitInfo);
            this.insertNodeIntoRoot(tmp, orgCol);
            unitInfo.put("alreadyLoad", true);
        }
    }

    private OrgAssistInfo buildNewOrgF7AssistInfo() {
        OrgAssistInfo assistInfo = new OrgAssistInfo();
        StringBuffer extraFilters = new StringBuffer();
        extraFilters.append(" AND ").append("\"BASEUNIT\"").append(".FIsCU = 1 ");
        assistInfo.setExtraFilters(extraFilters.toString());
        assistInfo.setInnerJoinStyle(false);
        ArrayList<String> decorators = new ArrayList<String>();
        decorators.add(null);
        decorators.add("com.kingdee.eas.basedata.org.app.helper.NormalFilter4F7Decorator");
        decorators.add("com.kingdee.eas.basedata.org.app.helper.OrgRangeFilter4F7Decorator");
        assistInfo.setConstructParam(decorators);
        if (!this.isShowSealedUnit) {
            assistInfo.setNeedAddSealUpFilter(true);
        }
        assistInfo.setNeedAddAssistantFilter(true);
        assistInfo.setInnerJoinStyle(false);
        if (AdminOrgRangeFilterUtil.isFilterByUserAdminOrgRange(null)) {
            assistInfo.setNeedAddOrgRange(true);
            assistInfo.setOrgRangeType(2);
        }
        return assistInfo;
    }

    private void insertNodeIntoRoot(DefaultKingdeeTreeNode root, List orgCol) {
        for (int i = 0; i < orgCol.size(); ++i) {
            FullOrgUnitInfo info = (FullOrgUnitInfo)orgCol.get(i);
            KDTreeNode treeNode = new KDTreeNode((Object)info);
            treeNode.setCustomIcon(EASResource.getIcon((String)"imgTree_company"));
            root.add((MutableTreeNode)treeNode);
        }
    }

    private void init() throws Exception {
        this.btnCUSealUp.setIcon(EASResource.getIcon((String)"imgTbtn_sealup"));
        this.btnCUUnSealUp.setIcon(EASResource.getIcon((String)"imgTbtn_unsealup"));
        this.btnCUSealUp.setEnabled(true);
        this.btnCUUnSealUp.setEnabled(true);
        this.menuItemCUSealUp.setEnabled(true);
        this.menuItemCUUnSealUp.setEnabled(true);
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int begin = e.getFirstRow();
                int end = e.getLastRow();
                if (CUListUI.this.isShowSealedUnit) {
                    for (int i = begin; i <= end; ++i) {
                        if (CUListUI.this.isTheCUSealedUp(i)) {
                            CUListUI.this.tblMain.getRow(i).getStyleAttributes().setBackground(sealedupColor);
                            continue;
                        }
                        CUListUI.this.tblMain.getRow(i).getStyleAttributes().setBackground(normalColor);
                    }
                }
            }
        });
        this.setButtonStatusForSelectedCU();
        this.setBtnShowSealedUnitStatus();
    }

    private void initTblMain() {
        this.tblMain.getViewManager().setFreezeView(0, 3);
    }

    private BOSUuid getRootID() {
        CtrlUnitInfo currentCUInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        BOSUuid rootID = currentCUInfo.getId();
        if ("11111111-1111-1111-1111-111111111111CCE7AED4".equalsIgnoreCase(rootID.toString())) {
            rootID = BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4");
        }
        return rootID;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        if (this.getSelectedTreeNode() != null && this.getSelectedTreeNode().getUserObject() != null) {
            FullOrgUnitInfo selectInfo = (FullOrgUnitInfo)this.getSelectedTreeNode().getUserObject();
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)selectInfo.getLongNumber(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(selectInfo.getLongNumber() + "!%"), CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("isCu", (Object)new Integer(1), CompareType.EQUALS));
            filter.setMaskString("(#0 or #1) and #2");
            if (!this.isShowSealedUnit) {
                FilterInfo filter4 = new FilterInfo();
                filter4.getFilterItems().add(new FilterItemInfo("isOUSealUp", (Object)new Integer(0), CompareType.EQUALS));
                try {
                    filter.mergeFilter(filter4, "and");
                }
                catch (BOSException e) {
                    this.logger.error((Object)"CUListUI mergeFilter filter4 error!", (Throwable)e);
                }
            }
        }
        return filter;
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        if (this.getSelectedTreeNode() != null && this.getSelectedTreeNode().getUserObject() != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = this.getDefaultFilterForQuery();
            viewInfo.getSorter().add(new SorterItemInfo("longNumber"));
            if (this.getDefaultEntityViewInfo() != null) {
                filter.mergeFilter(this.getDefaultEntityViewInfo().getFilter(), "and");
            }
            viewInfo.setFilter(filter);
            if (!this.initialized) {
                if (this.mainQuery != null && this.mainQuery.getFilter() != null) {
                    filter.mergeFilter(this.mainQuery.getFilter(), "and");
                }
                this.initialized = true;
            }
            this.mainQuery = viewInfo;
        } else {
            this.mainQuery = this.getDefaultEntityViewInfo();
        }
        this.tblMain.removeRows();
        this.isTreeValueChangedFirst = true;
        int rows = this.tblMain.getRowCount();
        if (rows != 0) {
            this.tblMain.getSelectManager().select(0, 0);
        }
        this.setButtonStatusForSelectedCU();
    }

    public void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        if (this.isTreeValueChangedFirst) {
            this.isTreeValueChangedFirst = false;
        } else {
            this.setButtonStatusForSelectedCU();
            this.onTblMainSelected();
        }
    }

    private void onTblMainSelected() {
        if (this.tblMain.getRowCount() == 0) {
            return;
        }
        KDTSelectBlock block = this.tblMain.getSelectManager().get();
        if (block != null) {
            DefaultKingdeeTreeNode node;
            String id = (String)this.tblMain.getCell(block.getBeginRow(), "id").getValue();
            String longNumber = null;
            try {
                longNumber = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(id)).getLongNumber();
            }
            catch (BOSException e) {
                this.logger.error((Object)e);
            }
            catch (EASBizException e) {
                this.logger.error((Object)e);
            }
            TreeModel treeModel = this.treeMain.getModel();
            if (treeModel != null && treeModel.getRoot() != null && (node = this.redirectFromTableToTree(id, longNumber, (DefaultKingdeeTreeNode)treeModel.getRoot())) != null) {
                this.isRedirect = true;
                this.treeMain.setSelectionNode(node);
            }
        }
    }

    private DefaultKingdeeTreeNode redirectFromTableToTree(String id, String longNumber, DefaultKingdeeTreeNode root) {
        if (root == null) {
            return null;
        }
        if (root.getUserObject() != null && root.getUserObject() instanceof FullOrgUnitInfo) {
            FullOrgUnitInfo unitInfo = (FullOrgUnitInfo)root.getUserObject();
            if (id.equals(unitInfo.getId().toString())) {
                return root;
            }
            String unitLongNumber = unitInfo.getLongNumber();
            if (!StringUtils.isEmpty((String)unitLongNumber) && longNumber.startsWith(unitLongNumber + "!") && unitInfo.get("alreadyLoad") == null) {
                try {
                    this.loadNode(root);
                }
                catch (BOSException e) {
                    this.logger.error((Object)e);
                }
                catch (EASBizException e) {
                    this.logger.error((Object)e);
                }
            }
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)root.getChildAt(i);
            DefaultKingdeeTreeNode node = this.redirectFromTableToTree(id, longNumber, childNode);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    protected void refresh(ActionEvent e) throws Exception {
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.initTree();
    }

    @Override
    public void actionRefreshView_actionPerformed(ActionEvent e) throws Exception {
        INewOrgViewFacade iView = NewOrgViewFacadeFactory.getRemoteInstance();
        iView.rebuildAllView();
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkTreeNodeSelected(e);
        FullOrgUnitInfo info = (FullOrgUnitInfo)this.getSelectedTreeNode().getUserObject();
        String id = info.getId().toString();
        if (info.isIsOUSealUp()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.strResource, (String)"CANOT_ADD_SUB"));
            SysUtil.abort();
        }
        super.actionAddNew_actionPerformed(e);
        this.orientationCurrentNode(1);
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
        FullOrgUnitInfo info = (FullOrgUnitInfo)this.getSelectedTreeNode().getUserObject();
        String unitId = info.getId().toString();
        FullOrgUnitInfo unitInfo = iFullOrgUnit.getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(unitId));
        super.actionEdit_actionPerformed(e);
        FullOrgUnitInfo newInfo = (FullOrgUnitInfo)this.getSelectedTreeNode().getUserObject();
        String newUnitId = newInfo.getId().toString();
        FullOrgUnitInfo newUnitInfo = iFullOrgUnit.getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(newUnitId));
        if (unitInfo.getParent() != null && unitInfo.getParent().getId() != null && newUnitInfo.getParent() != null && newUnitInfo.getParent().getId() != null && unitInfo.getParent().getId().toString().equals(newUnitInfo.getParent().getId().toString())) {
            this.orientationCurrentNode(2);
        } else {
            this.tblMain.refresh();
            this.initTree();
        }
    }

    public RequestContext prepareActionAddNew(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionAddNew(itemAction);
        request.put("rootID", (Object)this.getRootID());
        request.setClassName("com.kingdee.eas.basedata.org.app.CUListUIHandler");
        request.setMethodName("handleActionAddNew");
        return request;
    }

    public boolean isPrepareActionAddNew() {
        return true;
    }

    public boolean isPrepareActionEdit() {
        return true;
    }

    public boolean isPrepareActionView() {
        return true;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.actionRemove_actionPerformed(e);
    }

    public RequestContext prepareActionRemove(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionRemove(itemAction);
        request.put("rootID", (Object)this.getRootID());
        request.setClassName("com.kingdee.eas.basedata.org.app.CUListUIHandler");
        request.setMethodName("handleActionRemove");
        return request;
    }

    public boolean isPrepareActionRemove() {
        return true;
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return FullOrgUnitFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return CUEditUI.class.getName();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"tree", (Object)this.treeMain);
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    @Override
    public void actionCUSealUp_actionPerformed(ActionEvent e) throws Exception {
        super.actionCUSealUp_actionPerformed(e);
        this.checkSelected();
        String unitID = this.getSelectedKeyValue();
        if (unitID.equals(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString())) {
            throw new OUException(OUException.CANT_SEALUP_SELF);
        }
        NewOUInnerFacadeFactory.getRemoteInstance().cuSealUp(unitID);
        this.showCUSealUpSuccess();
        this.tblMain.getRow(this.tblMain.getSelectManager().get().getBeginRow()).getStyleAttributes().setBackground(sealedupColor);
        this.tblMain.getRow(this.tblMain.getSelectManager().get().getBeginRow()).getCell("isSealedUp").setValue((Object)new Boolean(true));
        this.setButtonStatusForSelectedCU();
        this.orientationCurrentNode(6);
    }

    @Override
    public void actionCUUnSealUp_actionPerformed(ActionEvent e) throws Exception {
        super.actionCUUnSealUp_actionPerformed(e);
        this.checkSelected();
        NewOUInnerFacadeFactory.getRemoteInstance().cuUnSealUp(this.getSelectedKeyValue());
        this.showCUUnSealUpSuccess();
        this.tblMain.getRow(this.tblMain.getSelectManager().get().getBeginRow()).getStyleAttributes().setBackground(normalColor);
        this.tblMain.getRow(this.tblMain.getSelectManager().get().getBeginRow()).getCell("isSealedUp").setValue((Object)new Boolean(false));
        this.setButtonStatusForSelectedCU();
        this.orientationCurrentNode(7);
    }

    private void showCUSealUpSuccess() {
        String message = EASResource.getString((String)this.strResource, (String)"SEALUP_SUCCESS");
        this.setMessageText(message);
        this.showMessage();
        MsgBox.showInfo((Component)((Object)this), (String)message);
    }

    private void showCUUnSealUpSuccess() {
        String message = EASResource.getString((String)this.strResource, (String)"UNSEALUP_SUC");
        this.setMessageText(message);
        this.showMessage();
        MsgBox.showInfo((Component)((Object)this), (String)message);
    }

    private void setButtonStatusForSelectedCU() {
        int rows = this.tblMain.getRowCount();
        if (rows != 0) {
            this.btnCUSealUp.setVisible(false);
            this.btnCUUnSealUp.setVisible(false);
            this.menuItemCUSealUp.setVisible(false);
            this.menuItemCUUnSealUp.setVisible(false);
        }
        if (this.tblMain.getSelectManager().get() != null) {
            this.btnCUSealUp.setVisible(!this.isTheSelectedCUSealedUp());
            this.btnCUUnSealUp.setVisible(!this.btnCUSealUp.isVisible());
            this.menuItemCUSealUp.setVisible(this.btnCUSealUp.isVisible());
            this.menuItemCUUnSealUp.setVisible(this.btnCUUnSealUp.isVisible());
            this.btnEdit.setVisible(this.btnCUSealUp.isVisible());
            this.menuItemEdit.setVisible(this.btnEdit.isVisible());
            this.btnEdit.setEnabled(this.btnEdit.isVisible());
            this.menuItemEdit.setEnabled(this.menuItemEdit.isVisible());
        }
    }

    private boolean isTheSelectedCUSealedUp() {
        return this.isTheCUSealedUp(this.tblMain.getSelectManager().get().getBeginRow());
    }

    private boolean isTheCUSealedUp(int rowIndex) {
        if (this.tblMain.getCell(rowIndex, "isSealedUp") != null && this.tblMain.getCell(rowIndex, "isSealedUp").getValue() != null) {
            return (Boolean)this.tblMain.getCell(rowIndex, "isSealedUp").getValue();
        }
        return false;
    }

    @Override
    public void actionImportCU_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportCU_actionPerformed(e);
        OrgDIUtil.performImportForOrgType(OrgType.ControlUnit);
        this.initTree();
    }

    @Override
    public void actionExportCU_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportCU_actionPerformed(e);
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app", "OUExportQuery");
        OrgDIUtil.performExportForOrgType((Component)((Object)this), OrgType.ControlUnit, (IMetaDataPK)mainQueryPK, this.mainQuery);
    }

    @Override
    public void actionCU_actionPerformed(ActionEvent e) throws Exception {
        super.actionCU_actionPerformed(e);
        this.checkSelected();
        String selCUID = this.getSelectedKeyValue();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ctrlUnitID", (Object)selCUID);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CUAdminListUI.class.getName(), (Map)uiContext, null, this.getOprtState());
        uiWindow.show();
    }

    @Override
    public void actionSpecialDataPerm_actionPerformed(ActionEvent e) throws Exception {
        super.actionSpecialDataPerm_actionPerformed(e);
        this.checkSelected();
        String selCUID = this.getSelectedKeyValue();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ctrlUnitID", (Object)selCUID);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SpecialDataPermEditUI.class.getName(), (Map)uiContext, null, this.getOprtState());
        uiWindow.show();
    }

    @Override
    protected void btnShowSealedUnit_mouseClicked(MouseEvent e) throws Exception {
        this.isShowSealedUnit = !this.isShowSealedUnit;
        this.setBtnShowSealedUnitStatus();
        this.orientationCurrentNode(5);
    }

    private void setBtnShowSealedUnitStatus() {
        if (!this.isShowSealedUnit) {
            this.btnShowSealedUnit.setText(EASResource.getString((String)this.strResource, (String)"ShowSealedCtrlUnit"));
            this.btnShowSealedUnit.setToolTipText(EASResource.getString((String)this.strResource, (String)"ShowSealedCtrlUnit"));
            this.btnShowSealedUnit.setIcon(EASResource.getIcon((String)"imgTbtn_dummygroup"));
        } else {
            this.btnShowSealedUnit.setText(EASResource.getString((String)this.strResource, (String)"NotShowSealedCtrlUnit"));
            this.btnShowSealedUnit.setToolTipText(EASResource.getString((String)this.strResource, (String)"NotShowSealedCtrlUnit"));
            this.btnShowSealedUnit.setIcon(EASResource.getIcon((String)"imgTbtn_offdummygroup"));
        }
    }

    public void orientationCurrentNode(int operate) throws Exception {
        int selectedRow = this.tblMain.getSelectManager().getActiveRowIndex();
        int selectedCol = this.tblMain.getSelectManager().getActiveColumnIndex();
        if (selectedRow < 0) {
            selectedRow = 0;
        }
        if (selectedCol < 0) {
            selectedCol = 0;
        }
        IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
        FullOrgUnitInfo info = (FullOrgUnitInfo)this.getSelectedTreeNode().getUserObject();
        String unitId = info.getId().toString();
        FullOrgUnitInfo unitInfo = iFullOrgUnit.getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(unitId));
        boolean isShowParentNode = this.isShowParentNode(unitInfo, operate);
        DefaultKingdeeTreeNode selectedNode = OrgTreeHelper.searchTreeNodeById((DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot(), unitId);
        if (selectedNode == null || selectedNode.isRoot()) {
            this.initTree(null, unitInfo, 0);
        } else if (!isShowParentNode) {
            this.initTree((KDTreeNode)selectedNode, unitInfo, operate);
        } else {
            String parentId = unitInfo.getParent().getId().toString();
            FullOrgUnitInfo parentUnitInfo = iFullOrgUnit.getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(parentId));
            DefaultKingdeeTreeNode parentNode = OrgTreeHelper.searchTreeNodeById((DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot(), parentId);
            this.initTree((KDTreeNode)parentNode, parentUnitInfo, operate);
            this.expandNode(parentNode, isShowParentNode);
        }
        this.tblMain.refresh();
        this.tblMain.getSelectManager().select(isShowParentNode ? 0 : selectedRow, isShowParentNode ? 0 : selectedCol);
    }

    private void expandNode(DefaultKingdeeTreeNode selectedNode, boolean isParent) {
        if (selectedNode != null) {
            this.treeMain.expandPath(new TreePath(selectedNode.getPath()));
            this.treeMain.setSelectionNode(selectedNode);
        }
    }

    protected void initTree() throws Exception {
        BOSUuid rootCUID = this.getRootID();
        ObjectUuidPK pk = new ObjectUuidPK(rootCUID);
        FullOrgUnitInfo unitInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)pk);
        this.initTree(null, unitInfo, 0);
        this.tblMain.getSelectManager().select(0, 0);
    }

    private void initTree(KDTreeNode selectedNode, FullOrgUnitInfo unitInfo, int operate) throws Exception {
        this.logger.info((Object)"CUListUI initTree begin.");
        long t1 = System.currentTimeMillis();
        INewOrgF7Facade facade = NewOrgF7FacadeFactory.getRemoteInstance();
        KDTreeNode root = selectedNode != null ? (KDTreeNode)this.treeMain.getModel().getRoot() : new KDTreeNode((Object)unitInfo);
        OrgAssistInfo assistInfo = this.getOrgAssistInfo(selectedNode, unitInfo, operate);
        if (assistInfo == null) {
            return;
        }
        List orgCol = facade.getDirectChildren(assistInfo, (CoreBaseInfo)unitInfo);
        if (selectedNode == null) {
            this.insertNodeIntoRoot((DefaultKingdeeTreeNode)root, orgCol);
        } else {
            this.insertNodeIntoRoot((DefaultKingdeeTreeNode)selectedNode, orgCol);
            if (orgCol != null && orgCol.size() > 0) {
                ((FullOrgUnitInfo)selectedNode.getUserObject()).setIsLeaf(false);
            }
            ((FullOrgUnitInfo)selectedNode.getUserObject()).put("alreadyLoad", true);
        }
        ((FullOrgUnitInfo)root.getUserObject()).put("alreadyLoad", true);
        this.treeMain.setModel((TreeModel)new DefaultTreeModel((TreeNode)root){

            @Override
            public boolean isLeaf(Object node) {
                FullOrgUnitInfo info = (FullOrgUnitInfo)((KDTreeNode)node).getUserObject();
                return info == null || info.isIsLeaf();
            }
        });
        if (root.getUserObject() == null) {
            this.treeMain.setRootVisible(false);
        } else {
            this.treeMain.setRootVisible(true);
        }
        this.treeMain.setShowsRootHandles(true);
        if (selectedNode != null) {
            this.treeMain.expandPath(new TreePath(selectedNode.getPath()));
            this.treeMain.setSelectionNode((DefaultKingdeeTreeNode)selectedNode);
        } else {
            this.treeMain.setSelectionNode((DefaultKingdeeTreeNode)root);
        }
        this.treeMain.updateUI();
        this.logger.info((Object)("CUListUI initTree end. cost: " + (System.currentTimeMillis() - t1)));
    }

    private OrgAssistInfo getOrgAssistInfo(KDTreeNode selectedNode, FullOrgUnitInfo unitInfo, int operate) throws EASBizException, BOSException {
        OrgAssistInfo assistInfo = null;
        if (operate == 2) {
            selectedNode.setText(unitInfo.getName());
            ((FullOrgUnitInfo)selectedNode.getUserObject()).setLongNumber(unitInfo.getLongNumber());
        }
        assistInfo = this.buildNewOrgF7AssistInfo();
        if (selectedNode != null) {
            selectedNode.removeAllChildren();
        }
        return assistInfo;
    }

    private boolean isShowParentNode(FullOrgUnitInfo unitInfo, int operate) throws EASBizException, BOSException {
        boolean isShowParentNode = false;
        if (operate == 1) {
            isShowParentNode = false;
        } else if (operate == 2) {
            isShowParentNode = false;
        } else if (operate == 5) {
            if (this.tblMain.getRowCount() > 0) {
                int curRow = this.tblMain.getSelectManager().getActiveRowIndex();
                if (curRow < 0) {
                    curRow = 0;
                }
                boolean isSealedUp = (Boolean)this.tblMain.getRow(curRow).getCell("isSealedUp").getValue();
                isShowParentNode = !this.isShowSealedUnit && isSealedUp;
            }
        } else if (operate == 6) {
            isShowParentNode = !this.isShowSealedUnit;
        } else if (operate == 7) {
            isShowParentNode = false;
        }
        return isShowParentNode;
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        return this.qfsi.supportExecutionWithoutFilters();
    }
}

