/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.OrgAssistInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.NewOrgF7PromptDialog;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Set;
import org.apache.log4j.Logger;

public class DefaultOrgF7PromptDialog
extends NewOrgF7PromptDialog {
    private static Logger logger = Logger.getLogger(DefaultOrgF7PromptDialog.class);

    public DefaultOrgF7PromptDialog() {
    }

    public DefaultOrgF7PromptDialog(IUIObject _uiObject) {
        super(_uiObject);
    }

    public DefaultOrgF7PromptDialog(Frame _owner) {
        super(_owner);
    }

    public DefaultOrgF7PromptDialog(Dialog _owner) {
        super(_owner);
    }

    @Override
    protected void init() {
        super.init();
        this.setContainSealUp(true);
        this.orgViewTypes = this.createOrgViewType();
        this.setTitle(this.getName("SetDefaultOrg"));
        this.setNeedAddAssistant(true);
    }

    public OrgViewType[] createOrgViewType() {
        ArrayList<OrgViewType> orgViewTypeList = new ArrayList<OrgViewType>();
        orgViewTypeList.add(OrgViewType.getInstance(this.getName("All"), -1, "", ""));
        orgViewTypeList.add(OrgTypeInfoMgr.getInstance().getOrgTypeInfo(OrgType.ControlUnit).getOrgViewType());
        Set orgTypeSet = OrgTypeInfoMgr.getInstance().getAllOrgType();
        for (OrgType orgType : orgTypeSet) {
            OrgTypeInfo orgTypeInfo;
            if (orgType.getValue() == -1) continue;
            if (orgType.getValue() == 0) continue;
            if (orgType.getValue() == 10 || !(orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(orgType)).isBasicOrgType() || orgTypeInfo.getOrgViewType() != null && orgTypeInfo.getOrgViewType().getValue() == 0) continue;
            orgViewTypeList.add(orgTypeInfo.getOrgViewType());
        }
        OrgViewType[] retOrgViewAry = new OrgViewType[orgViewTypeList.size()];
        for (int i = 0; i < orgViewTypeList.size(); ++i) {
            retOrgViewAry[i] = (OrgViewType)((Object)orgViewTypeList.get(i));
        }
        return retOrgViewAry;
    }

    @Override
    public boolean isCbTypeTextEqualsALL() {
        return this.getComboTypeSelectedItem().getValue() == -1;
    }

    @Override
    protected OrgAssistInfo buildNewOrgF7AssistInfo(OrgViewType orgViewType, OrgTreeInfo orgTreeInfo, CoreBaseInfo userObject) throws EASBizException, BOSException {
        OrgAssistInfo info = super.buildNewOrgF7AssistInfo(orgViewType, orgTreeInfo, userObject);
        info.setNeedAddAssistantFilter(true);
        info.setNeedAddOrgRange(true);
        info.setNeedConsiderFaultTree(true);
        ArrayList<String> decorators = new ArrayList<String>();
        decorators.add(null);
        decorators.add("com.kingdee.eas.basedata.org.app.helper.NormalFilter4F7Decorator");
        decorators.add("com.kingdee.eas.basedata.org.app.helper.OrgRangeFilter4F7Decorator");
        info.setConstructParam(decorators);
        return info;
    }

    @Override
    public FilterInfo getOuterFilterInfo() {
        try {
            FilterInfo orgRangeFilter = new FilterInfo(this.getOrgRangeOql());
            return orgRangeFilter;
        }
        catch (ParserException e) {
            logger.error((Object)"getOrgRangeFilter error.", (Throwable)e);
            return null;
        }
    }

    private String getOrgRangeOql() {
        StringBuffer result = new StringBuffer();
        StringBuffer temp = new StringBuffer();
        String userPK = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        temp.append("SELECT FOrgID").append(" FROM T_PM_OrgRange ").append(" WHERE FUserID = '").append(userPK).append("' AND FType = ").append(10);
        if (!this.isCbTypeTextEqualsALL()) {
            result.append("UNIT.id in (").append(temp.toString()).append(")");
        } else {
            result.append("id in (").append(temp.toString()).append(")");
        }
        return result.toString();
    }
}

