/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.message.BMCMessageFactory;
import com.kingdee.eas.base.message.BMCMessageInfo;
import com.kingdee.eas.base.message.IBMCMessage;
import com.kingdee.eas.base.message.MsgPriority;
import com.kingdee.eas.base.message.MsgStatus;
import com.kingdee.eas.base.message.MsgType;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.base.receiver.BasReceiverInfo;
import com.kingdee.eas.base.receiver.BasReleaseInfo;
import com.kingdee.eas.base.receiver.util.MessageInputUtils;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.AbstractHandSendMessageUI;
import com.kingdee.eas.basedata.org.util.OrgToolUtils;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;

public class HandSendMessageUI
extends AbstractHandSendMessageUI {
    private MessageInputUtils miu = new MessageInputUtils();
    public static final String OU_NUMBER = "ou_number";
    public static final String OU_NAME = "ou_name";
    public static final String CU_ADMINISTRATORS = "cu_administrators";
    public static final String ORG_TYPE_LIST = "org_type_list";
    private String resName = "com.kingdee.eas.base.message.client.MessageCenter";
    private BasReleaseInfo receiverInfo = null;
    BMCMessageInfo msgInfo = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUIData();
    }

    private void initUIData() {
        int i;
        this.msgTitle.setSelectedLanguage(new LanguageInfo(SysContext.getSysContext().getLocale()));
        this.msgContent.setSelectedLanguage(new LanguageInfo(SysContext.getSysContext().getLocale()));
        this.msgInfo = new BMCMessageInfo();
        this.msgInfo.setId(BOSUuid.create((BOSObjectType)this.msgInfo.getBOSType()));
        this.priorityComboBox.setSelectedItem((Object)MsgPriority.getEnum((int)20));
        String title = OrgToolUtils.getResource("res_38");
        int n = this.msgTitle.getItemCount();
        for (int i2 = 0; i2 < n; ++i2) {
            MultiLangItem mli = (MultiLangItem)this.msgTitle.getItemAt(i2);
            mli.setData((Object)title);
        }
        this.msgTitle.setSelectedLanguage(new LanguageInfo(SysContext.getSysContext().getLocale()));
        this.msgTitle.setSelectedItemData((Object)title);
        String number = (String)this.getUIContext().get(OU_NUMBER);
        String name = (String)this.getUIContext().get(OU_NAME);
        ArrayList orgTypeList = (ArrayList)this.getUIContext().get(ORG_TYPE_LIST);
        String content = OrgToolUtils.getResource("res_39") + number + OrgToolUtils.getResource("res_40") + "\"" + name + "\"";
        for (i = 0; i < orgTypeList.size(); ++i) {
            if (i == 0) {
                content = content + OrgToolUtils.getResource("res_41");
            }
            content = content + ((OrgType)((Object)orgTypeList.get(i))).toString();
            if (i == orgTypeList.size() - 1) continue;
            content = content + OrgToolUtils.getResource("res_42");
        }
        content = content + OrgToolUtils.getResource("res_43");
        int n2 = this.msgContent.getItemCount();
        for (i = 0; i < n2; ++i) {
            MultiLangItem mli = (MultiLangItem)this.msgContent.getItemAt(i);
            mli.setData((Object)content);
        }
        this.msgContent.setSelectedLanguage(new LanguageInfo(SysContext.getSysContext().getLocale()));
        this.msgContent.setSelectedItemData((Object)content);
        if (this.receiverInfo == null) {
            this.receiverInfo = new BasReleaseInfo();
        }
        this.receiversText.setEnabled(true);
        this.receiversText.setEditable(true);
        this.miu.initData(this.receiversText, this.receiverInfo);
        UserCollection userCol = (UserCollection)this.getUIContext().get(CU_ADMINISTRATORS);
        String userNames = "";
        for (int i3 = 0; i3 < userCol.size(); ++i3) {
            UserInfo userInfo = userCol.get(i3);
            BasReceiverInfo info = new BasReceiverInfo();
            info.setIsShow(true);
            info.setDesc(userInfo.getName());
            info.setType("1");
            info.setValue(userInfo.getId().toString());
            this.receiverInfo.getReceiver().add(info);
            if (i3 != 0) {
                userNames = userNames + ";";
            }
            userNames = userNames + userCol.get(i3).getName();
        }
        this.receiversText.setText(userNames);
    }

    @Override
    protected void cancel_actionPerformed(ActionEvent e) throws Exception {
        super.cancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    protected void confirm_actionPerformed(ActionEvent e) throws Exception {
        super.confirm_actionPerformed(e);
        if (this.receiverInfo == null || this.receiverInfo.getReceiver().size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)this.resName, (String)"please.select.person"));
            return;
        }
        boolean isAlert = true;
        for (int i = 0; i < this.receiverInfo.getReceiver().size(); ++i) {
            BasReceiverInfo info = this.receiverInfo.getReceiver().get(i);
            if (info.getType().toString().equals("7") || info.getType().toString().equals("6")) continue;
            isAlert = false;
            break;
        }
        if (isAlert) {
            MsgBox.showInfo((String)EASResource.getString((String)this.resName, (String)"please.select.person"));
            return;
        }
        MultiLangItem name = this.msgTitle.getItemBy(new LanguageInfo(SysContext.getSysContext().getLocale()));
        if (StringUtils.isEmpty((String)((String)name.getData()))) {
            MsgBox.showInfo((String)EASResource.getString((String)this.resName, (String)"title.requied"));
            return;
        }
        if (this.isLegal((String)name.getData())) {
            MsgBox.showInfo((String)EASResource.getString((String)this.resName, (String)"has.special.char"));
            return;
        }
        MultiLangItem content = this.msgContent.getItemBy(new LanguageInfo(SysContext.getSysContext().getLocale()));
        if (StringUtils.isEmpty((String)((String)content.getData()))) {
            MsgBox.showInfo((String)OrgToolUtils.getResource("res_44"));
            return;
        }
        try {
            this.setMsgInfo();
            this.saveMsg();
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        this.getUIWindow().close();
    }

    private void setMsgInfo() {
        UserInfo userInfo = null;
        try {
            IUser iUser = UserFactory.getRemoteInstance();
            userInfo = iUser.getUserInfo((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()));
        }
        catch (Exception e) {
            this.handleException(e);
        }
        LanguageInfo languageInfo2 = null;
        Locale locale = null;
        String name = null;
        String content = null;
        List langList = KDBizMultiLangBox.getLanguageList();
        for (LanguageInfo languageInfo2 : langList) {
            locale = languageInfo2.getLocale();
            name = (String)this.msgTitle.getItemBy(languageInfo2).getData();
            this.msgInfo.setTitle(name, locale);
            content = (String)this.msgContent.getItemBy(languageInfo2).getData();
            this.msgInfo.setBody(content, locale);
            if (userInfo == null) continue;
            this.msgInfo.setSender(userInfo.getName(locale), locale);
        }
        this.msgInfo.setPriority((MsgPriority)this.priorityComboBox.getSelectedItem());
        this.msgInfo.setNreceivers(this.receiversText.getText());
        this.msgInfo.setType(MsgType.ONLINE);
        this.msgInfo.setStatus(MsgStatus.UNREADED);
    }

    private void saveMsg() throws Exception {
        LongTimeDialog dialog = new LongTimeDialog((Dialog)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                IBMCMessage iBMCMessage = BMCMessageFactory.getRemoteInstance();
                iBMCMessage.addHandMsg(HandSendMessageUI.this.msgInfo, (IObjectCollection)HandSendMessageUI.this.receiverInfo.getReceiver());
                return "";
            }

            public void afterExec(Object result) throws Exception {
                MsgBox.showInfo((Component)((Object)HandSendMessageUI.this), (String)EASResource.getString((String)HandSendMessageUI.this.resName, (String)"send_success"));
            }
        });
        dialog.show();
    }

    private boolean isLegal(String str) {
        String regor = "^.*[|~|<|>|'|\\\\|].*$";
        Pattern p = Pattern.compile(regor);
        Matcher m = p.matcher(str);
        boolean result = m.find();
        return result;
    }

    @Override
    protected void receiverButton_actionPerformed(ActionEvent e) throws Exception {
        this.miu.showReceiverUI((Object)this);
    }
}

