/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IKDPromptIsCUSelector;
import com.kingdee.bos.ctrl.extendcontrols.IKDPromptStringSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.OrgAssistInfo;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.DataPermParam;
import com.kingdee.eas.basedata.org.client.NewOrgF7PromptDialog;
import com.kingdee.eas.basedata.org.client.OrgPermissionFilterService;
import com.kingdee.eas.basedata.org.client.PermItemFilterService;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.ArrayList;

public abstract class NewOrgViewF7PromptDialog
extends NewOrgF7PromptDialog
implements IKDPromptStringSelector,
IKDPromptIsCUSelector {
    private boolean isUseDataPermission = false;
    private String inputStr = null;
    private String permissionItem;
    protected IMetaDataPK uiPK = null;
    protected IMetaDataPK actionPK = null;
    protected DataPermParam dataPermParam = null;

    protected NewOrgViewF7PromptDialog() {
    }

    protected NewOrgViewF7PromptDialog(IUIObject _uiObject) {
        super(_uiObject);
    }

    protected NewOrgViewF7PromptDialog(Frame _owner) {
        super(_owner);
    }

    protected NewOrgViewF7PromptDialog(Dialog _owner) {
        super(_owner);
    }

    @Override
    protected OrgAssistInfo buildNewOrgF7AssistInfo(OrgViewType orgViewType, OrgTreeInfo orgTreeInfo, CoreBaseInfo userObject) throws EASBizException, BOSException {
        OrgAssistInfo assistInfo = super.buildNewOrgF7AssistInfo(orgViewType, orgTreeInfo, userObject);
        assistInfo.setStructure(true);
        assistInfo.setUiPK(this.uiPK);
        assistInfo.setActionPK(this.actionPK);
        assistInfo.setPermItem(this.permissionItem);
        assistInfo.setUseDataPermission(this.isUseDataPermission);
        assistInfo.setNeedAddOrgRange(this.needAddOrgRange);
        ArrayList<String> decorators = new ArrayList<String>();
        decorators.add(null);
        decorators.add("com.kingdee.eas.basedata.org.app.helper.NormalFilter4F7Decorator");
        if (this.isCUFilter && !this.needAddOrgRange) {
            decorators.add("com.kingdee.eas.basedata.org.app.helper.CUFilter4F7Decorator");
        } else {
            decorators.add("com.kingdee.eas.basedata.org.app.helper.PermissionFilter4F7Decorator");
        }
        decorators.add("com.kingdee.eas.basedata.org.app.helper.PermItemFilter4F7Decorator");
        assistInfo.setConstructParam(decorators);
        return assistInfo;
    }

    @Override
    protected EntityViewInfo getEntityViewExceptTreeFilter() throws BOSException {
        FilterInfo dataPermFilter;
        FilterInfo authorizedOrgFilter;
        OrgTreeInfo treeInfo;
        OrgViewType viewType;
        EntityViewInfo viewInfo = super.getEntityViewExceptTreeFilter();
        FilterInfo filter = viewInfo.getFilter();
        if (this.isCUFilter() && !this.isNeedAddOrgRange()) {
            FilterInfo cufilter = new FilterInfo();
            cufilter.getFilterItems().add(new FilterItemInfo("unit.cu.id", (Object)this.getCurrentCUID(), CompareType.EQUALS));
            if (this.isCUFilterIncludeSub()) {
                String longNumber = SysContext.getSysContext().getCurrentCtrlUnit().getLongNumber();
                cufilter.getFilterItems().add(new FilterItemInfo("unit.cu.longnumber", (Object)(longNumber + "!%"), CompareType.LIKE));
                cufilter.setMaskString("(#0 or #1)");
            }
            filter.mergeFilter(cufilter, "and");
        } else {
            viewType = this.getComboTypeSelectedItem();
            authorizedOrgFilter = OrgPermissionFilterService.getAuthorizedOrgsFilter(this, viewType, treeInfo = this.getComboTreeSelectedItem());
            if (authorizedOrgFilter != null) {
                filter.mergeFilter(authorizedOrgFilter, "and");
            }
        }
        if (!StringUtils.isEmpty((String)this.getPermissionItem()) && (authorizedOrgFilter = PermItemFilterService.getPermItemFilter(this, viewType = this.getComboTypeSelectedItem(), treeInfo = this.getComboTreeSelectedItem())) != null) {
            filter.mergeFilter(authorizedOrgFilter, "and");
        }
        if (this.dataPermParam != null && (dataPermFilter = this.getOrgIdsByDataPermFilter()) != null) {
            filter.mergeFilter(dataPermFilter, "and");
        }
        return viewInfo;
    }

    @Override
    public void createF7UI() {
        super.createF7UI();
        try {
            if (!StringUtils.isEmpty((String)this.inputStr)) {
                this.getInnerF7UI().txtFieldValue.setText(this.inputStr);
                this.getInnerF7UI().chkContainSub.setSelected(true);
                this.getInnerF7UI().btnQuickQuery_actionPerformed(null);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private FilterInfo getOrgIdsByDataPermFilter() {
        FilterInfo filter = new FilterInfo();
        String rule = null;
        try {
            rule = PermissionFactory.getRemoteInstance().getQueryPermissionSQL(this.dataPermParam.userId, this.dataPermParam.orgId, this.dataPermParam.permItem);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        OrgTreeInfo treeInfo = this.getComboTreeSelectedItem();
        filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)rule, CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)treeInfo.getId().toString(), CompareType.EQUALS));
        return filter;
    }

    public void setUIAction(IUIObject _targetUI, ItemAction _action) {
        if (_targetUI != null) {
            this.uiPK = _targetUI.getMetaDataPK();
        }
        if (_action != null) {
            this.actionPK = OrgF7InnerUtils.getActionPK(_action);
        }
    }

    public void setUIActionPK(IMetaDataPK _uiPK, IMetaDataPK _actionPK) {
        this.uiPK = _uiPK;
        this.actionPK = _actionPK;
    }

    public void setPermissionItem(String permissionItem) {
        this.permissionItem = permissionItem;
        if (!StringUtils.isEmpty((String)this.permissionItem)) {
            this.needAddOrgRange = false;
        }
    }

    protected String getPermissionItem() {
        return this.permissionItem;
    }

    public IMetaDataPK getActionPK() {
        return this.actionPK;
    }

    public IMetaDataPK getUiPK() {
        return this.uiPK;
    }

    public boolean isUseDataPermission() {
        return this.isUseDataPermission;
    }

    public void setUseDataPermission(boolean isUseDataPermission) {
        this.isUseDataPermission = isUseDataPermission;
    }

    public String getInputStrData() {
        return this.inputStr;
    }

    public void setInputStringData(String params) throws Exception {
        this.inputStr = params;
    }

    public void setDataPermission(IObjectPK orgId, IObjectPK userId, String permItemName) {
        this.dataPermParam = new DataPermParam(orgId, userId, permItemName);
    }

    public void setDataPermission(String permItemName) {
        BOSUuid orgId = SysContext.getSysContext().getCurrentOrgUnit().getId();
        BOSUuid userId = SysContext.getSysContext().getCurrentUserInfo().getId();
        this.setDataPermission((IObjectPK)new ObjectUuidPK(orgId), (IObjectPK)new ObjectUuidPK(userId), permItemName);
    }
}

