/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.bos.ui.util.UICommonUtils;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.util.UITools;
import com.kingdee.eas.base.permission.util.LowTimeHelper;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.basedata.org.AdminOrgRangeFilterUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.BizDataCheckInfo;
import com.kingdee.eas.basedata.org.BizParentAndDelegateInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.INewOUInnerFacade;
import com.kingdee.eas.basedata.org.IOrgVersionMgrFacade;
import com.kingdee.eas.basedata.org.MultiOrgSwitchUtils;
import com.kingdee.eas.basedata.org.NewOUInnerFacadeFactory;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.basedata.org.OUPartAdminInfo;
import com.kingdee.eas.basedata.org.ObjectValueForOrgUnitUtils;
import com.kingdee.eas.basedata.org.OrgBlankException;
import com.kingdee.eas.basedata.org.OrgSealUpInfo;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgVersionMgrFacadeFactory;
import com.kingdee.eas.basedata.org.OrgXMLElement;
import com.kingdee.eas.basedata.org.ToSealUpEnum;
import com.kingdee.eas.basedata.org.client.AbstractOUEditUI;
import com.kingdee.eas.basedata.org.client.OUEditUIHelper;
import com.kingdee.eas.basedata.org.client.OUEdit_AdminUI;
import com.kingdee.eas.basedata.org.client.OUViewListUI;
import com.kingdee.eas.basedata.org.client.OrgLayerListUI;
import com.kingdee.eas.basedata.org.client.OrgLogListUI;
import com.kingdee.eas.basedata.org.client.ProfitAccountRangeListUI;
import com.kingdee.eas.basedata.org.client.ext.IOrgSealUp;
import com.kingdee.eas.basedata.org.client.uihelper.IOUEditHelper;
import com.kingdee.eas.basedata.org.client.uihelper.OUEditDefault;
import com.kingdee.eas.basedata.org.client.uihelper.OUEditUICenter;
import com.kingdee.eas.basedata.org.client.uihelper.OrgEditPanelInfo;
import com.kingdee.eas.basedata.org.helper.OrgConfigHelper;
import com.kingdee.eas.basedata.org.helper.OrgHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.basedata.org.service.OrgCommonUtils;
import com.kingdee.eas.basedata.org.util.OrgToolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.mobile.SendMsgMananger;
import com.kingdee.eas.mobile.client.MobileMessageFormatManager;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.ObjectUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;
import org.jdom2.JDOMException;

public class OUEditUI
extends AbstractOUEditUI {
    private static Logger logger = Logger.getLogger((String)OUEditUI.class.getName());
    private static final String RESOURCE = "com.kingdee.eas.basedata.org.OrgDataUpdateResource";
    String strResource = "com.kingdee.eas.basedata.org.client.OUResource";
    KDTree treeMain = null;
    private boolean isShowFirst = true;
    private boolean isFirstLoad = false;
    private BizParentAndDelegateInfo PDValueInfo = null;
    private OrgTypeHelper orgTypeHelper = null;
    private boolean hasBeenSaved = false;
    private boolean hasCodeRule = false;
    protected MetaDataPK mainQueryPK;
    private boolean isFullSize = true;
    private CtrlUnitInfo currentCtrlUnit = SysContext.getSysContext().getCurrentCtrlUnit();
    private FullOrgUnitInfo oldData = null;
    private boolean curVersion = true;

    public BizParentAndDelegateInfo getPDValueInfo() {
        return this.PDValueInfo;
    }

    public void setPDValueInfo(BizParentAndDelegateInfo valueInfo) {
        this.PDValueInfo = valueInfo;
    }

    public boolean isCurVersion() {
        return this.curVersion;
    }

    public void setCurVersion(boolean curVersion) {
        this.curVersion = curVersion;
    }

    private void clearUIData() {
        try {
            if (this.kDTabbedPane1.getComponentCount() > 0) {
                this.kDTabbedPane1.removeAll();
            }
            if (this.pnlBizChk.getComponentCount() > 0) {
                this.pnlBizChk.removeAll();
            }
            this.pnlBizChk.setLayout((LayoutManager)new FlowLayout(0, 2, 2));
            this.pnlBizChk.doLayout();
            this.pnlBizChk.validate();
            this.pnlBizChk.repaint();
            OUEditUICenter.getInstance().setChkBox(false);
            this.init();
        }
        catch (Exception e) {
            logger.error((Object)"error", (Throwable)e);
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public OUEditUI() throws Exception {
        this.init();
    }

    private void dealCtxParam() {
        String OrgHistoryStr;
        String oprStr = (String)this.getUIContext().get(OprtState.class.getName());
        if (!StringUtils.isEmpty((String)oprStr)) {
            this.setOprtState(oprStr);
        }
        if ("ORGHISTORY".equals(OrgHistoryStr = (String)this.getUIContext().get(OrgHelper.class.getName()))) {
            this.setCurVersion(false);
        }
    }

    private void checkCodingRule() throws EASBizException, BOSException {
        if (OprtState.VIEW.equals(this.oprtState)) {
            return;
        }
        String orgID = this.currentCtrlUnit.getId().toString();
        FullOrgUnitInfo orgUnitInfo = new FullOrgUnitInfo();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        this.hasCodeRule = iCodingRuleManager.isExist((IObjectValue)orgUnitInfo, orgID);
        if (this.hasCodeRule) {
            this.txtNumber.setEnabled(iCodingRuleManager.isModifiable((IObjectValue)orgUnitInfo, orgID));
        }
    }

    public void onLoad() throws Exception {
        LowTimeHelper timeHelper = new LowTimeHelper();
        if (this.getUIContext().get("CURRENTCUID") != null) {
            this.currentCtrlUnit = (CtrlUnitInfo)this.getUIContext().get("CURRENTCUID");
        }
        this.dealCtxParam();
        this.removeAllPanelFromTabbed();
        timeHelper.printTime2Last("begin .... onload");
        this.checkCodingRule();
        super.onLoad();
        if (this.editData != null && this.editData.getCU() == null) {
            this.editData.setCU(this.currentCtrlUnit);
        }
        this.initOtherLayout();
        this.treeMain = (KDTree)this.getUIContext().get("tree");
        this.disableUIElementsForOnlyViewing();
        this.hideSomeButtonsWhenReadOnly();
        timeHelper.printTime2Last("set btn set false");
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            this.btnViewOrgLog.setVisible(true);
        } else {
            this.btnViewOrgLog.setVisible(false);
        }
        this.btnRemove.setVisible(false);
        this.menuItemRemove.setVisible(false);
        timeHelper.printTime2Last("begin check perm");
        if (this.needPerm()) {
            this.initPanelByPermission();
        }
        timeHelper.printTime2Last("onload over");
        this.resetUISize();
    }

    private boolean needPerm() {
        boolean oprStats = this.oprtState == OprtState.ADDNEW || this.oprtState == OprtState.EDIT;
        boolean ouAddNewPerm = !OUEditUIHelper.checkFunctionPermission("OU_AddNew", this.currentCtrlUnit.getId().toString());
        boolean ouUpdatePerm = !OUEditUIHelper.checkFunctionPermission("OU_Update", this.currentCtrlUnit.getId().toString());
        return oprStats && ouAddNewPerm && ouUpdatePerm;
    }

    public Locale getCurrentLocale() {
        return SysContext.getSysContext().getLocale();
    }

    private void disableUIElementsForOnlyViewing() {
        Object o = this.getUIContext().get("OnlyForView");
        if (o != null) {
            this.btnSubmit.setVisible(false);
            this.btnEdit.setVisible(false);
            this.btnAdminOrgType.setVisible(false);
            this.btnSealUp.setVisible(false);
            this.btnUnSealUp.setVisible(false);
        }
    }

    private void hideSomeButtonsWhenReadOnly() {
        Object o = this.getUIContext().get("ReadOnly");
        if (o != null && ((Boolean)o).booleanValue()) {
            this.btnEdit.setVisible(false);
            this.btnSubmit.setVisible(false);
            this.btnAdminOrgType.setVisible(false);
            this.btnSealUp.setVisible(false);
            this.btnUnSealUp.setVisible(false);
        }
    }

    public void onShow() {
        try {
            if (this.isShowFirst) {
                this.isShowFirst = false;
                this.resetUISize();
            }
            this.setOldData((IObjectValue)this.editData);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            request.setClassName(this.getUIHandlerClassName());
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    private void init() throws Exception {
        this.lblcName.setBoundEditor((JComponent)this.mlbName);
        this.changeDescriptionLable.setBoundEditor((JComponent)this.changeDescriptionArea1);
        this.changeDescriptionArea1.setSelectedLanguage(new LanguageInfo(SysContext.getSysContext().getLocale()));
        OUEditUICenter.getNewInstance().init(this);
        this.btnSealUp.setIcon(EASResource.getIcon((String)"imgTbtn_sealup"));
        this.btnUnSealUp.setIcon(EASResource.getIcon((String)"imgTbtn_unsealup"));
        this.btnAddNew.setVisible(false);
        this.btnViewOrgLog.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        this.btnMaintainAssistantOrg.setIcon(EASResource.getIcon((String)"imgTbtn_copycreate"));
        this.btnSetMobileMsgFormat.setIcon(EASResource.getIcon((String)"imgTbtn_format"));
        this.btnSendMsg.setIcon(EASResource.getIcon((String)"imgTbtn_send"));
        this.btnSetMobileMsgFormat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MobileMessageFormatManager.createMobileMessageFormatUI((Component)((Object)OUEditUI.this), (BOSObjectType)OUEditUI.this.editData.getBOSType());
                }
                catch (Exception e1) {
                    OUEditUI.this.handleException(e1);
                }
            }
        });
        this.btnSendMsg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (OUEditUI.this.getOprtState() == OprtState.ADDNEW) {
                        new SendMsgMananger((Component)((Object)OUEditUI.this));
                    } else {
                        new SendMsgMananger((Component)((Object)OUEditUI.this), (CoreBaseInfo)OUEditUI.this.editData);
                    }
                }
                catch (Exception e1) {
                    OUEditUI.this.handleException(e1);
                }
            }
        });
    }

    private void removeAllPanelFromTabbed() throws Exception {
        this.kDTabbedPane1.removeAll();
    }

    private boolean selectedByChk() throws Exception {
        OrgType curSelectOrgType;
        if (this.orgTypeHelper == null) {
            return false;
        }
        Set allOrgTypeSet = this.orgTypeHelper.getAllSelectOrgTypeSet();
        if (allOrgTypeSet.isEmpty()) {
            return false;
        }
        return allOrgTypeSet.size() != 1 || OrgType.ControlUnit != (curSelectOrgType = (OrgType)((Object)allOrgTypeSet.iterator().next()));
    }

    public void resetUISize() throws Exception {
        IUIWindow window = this.getUIWindow();
        if (window == null) {
            return;
        }
        if (!(window instanceof JDialog)) {
            return;
        }
        JDialog uiWindow = (JDialog)window;
        JPanel content = (JPanel)uiWindow.getContentPane();
        if (this.selectedByChk()) {
            this.kDTabbedPane1.setSize(770, 440);
            this.infoLabel.setLocation(5, 690);
            int hight = this.getY() + this.kDTabbedPane1.getY() + this.kDTabbedPane1.getHeight() + this.infoLabel.getHeight() + 4;
            content.setPreferredSize(new Dimension(content.getWidth(), hight));
            uiWindow.pack();
            UICommonUtils.centerWindow((Window)uiWindow);
        } else {
            this.kDTabbedPane1.setSize(0, 0);
            this.infoLabel.setLocation(this.pnlBizChk.getX(), this.getY() + this.pnlBizChk.getY() + this.pnlBizChk.getHeight() + 2);
            int hight = this.getY() + this.pnlBizChk.getY() + this.pnlBizChk.getHeight() + 4 + this.infoLabel.getHeight();
            content.setPreferredSize(new Dimension(content.getWidth(), hight));
            uiWindow.pack();
            uiWindow.setLocation(uiWindow.getLocation().x, uiWindow.getLocation().y + this.kDTabbedPane1.getHeight() / 2);
        }
    }

    private void setWindow(Window window, JPanel content) {
        content.setPreferredSize(new Dimension(content.getWidth(), this.getY() + this.pnlBizChk.getY() + this.pnlBizChk.getHeight() + 4));
        window.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (int)(screenSize.getWidth() - (double)content.getWidth()) / 2;
        int y = (int)(screenSize.getHeight() - (double)content.getHeight()) / 2;
        window.setLocation(x, y);
    }

    protected void showSubmitSuccess() {
    }

    private void showSealUpSuccess(String bizName, int orgTypeValue) {
        this.setMessageText("[" + bizName + "] " + EASResource.getString((String)this.strResource, (String)"SEALUP_SUCCESS"));
        this.showMessage();
    }

    private void showSealUpSuccess(String bizName, int orgTypeValue, String keyName) {
        this.setMessageText("[" + bizName + "] " + EASResource.getString((String)this.strResource, (String)keyName));
        this.showMessage();
    }

    private void showUnSealUpSuccess(String bizName, int orgTypeValue) {
        this.showSealUpSuccess(bizName, orgTypeValue, "UNSEALUP_FINISH");
    }

    public IObjectPK runSubmit() throws Exception {
        String curModiOrgId;
        String curOrgId;
        IObjectPK retPK = super.runSubmit();
        if (OprtState.EDIT.equals(this.getOprtState()) && (curOrgId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString()).equals(curModiOrgId = this.editData.getId().toString())) {
            logger.info((Object)"update org sys info!");
            MultiOrgSwitchUtils.switchOrgForUI(curOrgId);
        }
        return retPK;
    }

    private boolean checkReferenceBizDataForAdmin() throws BOSException, EASBizException {
        if (this.editData.isIsAdminOrgUnit()) {
            OUPartAdminInfo partAdmin = this.editData.getPartAdmin();
            BizParentAndDelegateInfo pdInfo = (BizParentAndDelegateInfo)this.editData.get("PDValueInfo");
            if (partAdmin != null && pdInfo != null) {
                OrgUnitInfo adminParent = pdInfo.getAdminParent();
                if (adminParent == null) {
                    return true;
                }
                String parentName = adminParent.getName();
                String parentId = adminParent.getId().toString();
                if (this.getOprtState().equals(OprtState.ADDNEW) ? this.checkIsReference(parentId) && !MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)(EASResource.getString((String)RESOURCE, (String)"ADMINPARENT") + parentName + EASResource.getString((String)RESOURCE, (String)"ADMINPARENTISREFERENCED")))) : this.getOprtState().equals(OprtState.EDIT) && this.checkIsChange(parentId) && this.checkIsReference(parentId) && !MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)(EASResource.getString((String)RESOURCE, (String)"ADMINPARENT") + parentName + EASResource.getString((String)RESOURCE, (String)"ADMINPARENTISREFERENCED3"))))) {
                    return false;
                }
            }
        }
        return true;
    }

    private boolean checkIsChange(String parentId) throws BOSException, EASBizException {
        String id = this.editData.getId().toString();
        FullOrgUnitInfo fullOrgUnitInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(id));
        boolean isAdminOrgUnit = fullOrgUnitInfo.isIsAdminOrgUnit();
        if (isAdminOrgUnit) {
            AdminOrgUnitInfo oldAdminOrg = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(id));
            String oldParentId = oldAdminOrg.getParent().getId().toString();
            return !oldParentId.equals(parentId);
        }
        return true;
    }

    private boolean checkIsReference(String parentId) throws BOSException {
        BizDataCheckInfo[] checkInfos = FullOrgUnitFactory.getRemoteInstance().hasBizRefrenceForAdmin(parentId);
        boolean isReference = false;
        for (int i = 0; i < checkInfos.length; ++i) {
            if (checkInfos[i] == null || !checkInfos[i].isRef()) continue;
            isReference = true;
        }
        return isReference;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        try {
            String number = this.txtNumber.getText();
            String name = (String)this.mlbName.getItemBy(new LanguageInfo(SysContext.getSysContext().getLocale())).getData();
            String changeDescription = (String)this.changeDescriptionArea1.getItemDataByLang(new LanguageInfo(SysContext.getSysContext().getLocale()));
            this.editData.put("changeDescription", changeDescription);
            this.editData.setCU(this.currentCtrlUnit);
            if (this.getActionFromActionEvent(e) == null && !this.checkClickTime()) {
                return;
            }
            IObjectPK pk = null;
            this.doBeforeSubmit(e);
            if (!this.checkReferenceBizDataForAdmin()) {
                return;
            }
            pk = this.runSubmit();
            this.doAfterSubmit(pk);
            String saveSucessInfo = EASResource.getString((String)this.strResource, (String)"OU_NAME");
            saveSucessInfo = saveSucessInfo + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK");
            ShowResultThread showResultThread = new ShowResultThread(saveSucessInfo);
            showResultThread.start();
            this.oldData.setNumber(number);
            this.oldData.setName(name);
        }
        catch (OUException ouex) {
            if (ouex.getSubCode().equals(OUException.ASK_NAME_DUP.getCode())) {
                this.mlbName.requestFocusInWindow();
                return;
            }
            throw ouex;
        }
        catch (Exception ex) {
            this.handleException(ex);
            return;
        }
        this.submit_afterDeal();
        this.hasBeenSaved = true;
    }

    private void submit_afterDeal() throws Exception {
        String state = this.getOprtState();
        this.oldData.setId(BOSUuid.read((String)((String)this.getUIContext().get("ID"))));
        OUEditUICenter.getInstance().submit_afterDeal(this, this.oldData, state, this.treeMain);
        this.setOldData((IObjectValue)this.editData);
    }

    private void prepareBeforeLoadFields() throws Exception {
        IUIActionPostman handle = super.prepareInit();
        RequestContext request = new RequestContext();
        request.setMethodName("_handleBeforeLoadFields");
        request.put("isCurVersion", (Object)new Boolean(this.isCurVersion()));
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            request.put("oprtState", (Object)"ADDNEW");
        } else {
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
            request.put("pk", (Object)pk);
            request.put("editData", (Object)this.editData);
        }
        if (this.editData != null) {
            Set orgTypes = OrgCommonUtils.getOrgTypeCol(this.editData);
            for (OrgType type : orgTypes) {
                OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfoByOrgType(type);
                if (orgTypeInfo == null) continue;
                String clzzName = orgTypeInfo.getUiClassName();
                if (StringUtils.isEmpty((String)clzzName)) {
                    logger.info((Object)("OrgTypeInfo is:" + orgTypeInfo));
                    continue;
                }
                request.put(type.toString(), (Object)((OUEditDefault)OUEditUICenter.getInstance(type)).getSelection4RPC());
            }
        }
        request.put("ctrlInfo", (Object)this.currentCtrlUnit);
        handle.setRequestContext((Serializable)request);
        handle.callHandler();
    }

    @Override
    public void loadFields() {
        try {
            LowTimeHelper timeHelper = new LowTimeHelper();
            this.prepareBeforeLoadFields();
            super.loadFields();
            this.loadBizSuperiorAndDelegate();
            timeHelper.printTime2Last(" begin loadBizSuperiorAndDelegate ");
            this.loadAllFields();
            timeHelper.printTime2Last(" begin loadAllFields ");
            this.disableSealUp();
            if (this.getOprtState().equals("VIEW")) {
                this.setTabsEnabled(false);
            }
            this.hideSomeButtonsWhenReadOnly2();
            this.setStatusForAssistantOrg(false);
            if (this.kDTabbedPane1.getTabCount() != 0) {
                this.kDTabbedPane1.setSelectedIndex(0);
            }
            timeHelper.printTime2Last(" load data over! ");
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void setStatusForAssistantOrg(boolean isStartFromOUEditUI) throws Exception {
        if (this.editData.isIsAssistantOrg()) {
            this.btnMaintainAssistantOrg.setEnabled(false);
            this.btnMaintainAssistantOrg.setVisible(false);
            this.setTabsEnabled(false);
            this.btnSealUp.setEnabled(false);
            this.btnUnSealUp.setEnabled(false);
            this.btnPre.setEnabled(false);
            this.btnNext.setEnabled(false);
            this.btnFirst.setEnabled(false);
            this.btnLast.setEnabled(false);
            this.btnAdminOrgType.setEnabled(false);
            this.btnSealUp.setVisible(false);
            this.btnUnSealUp.setVisible(false);
            this.btnPre.setVisible(false);
            this.btnNext.setVisible(false);
            this.btnFirst.setVisible(false);
            this.btnLast.setVisible(false);
            this.btnAdminOrgType.setVisible(false);
        } else {
            if (isStartFromOUEditUI) {
                this.setTabsEnabled(true);
            }
            if (this.editData == null || this.editData.getId() == null || !this.editData.isIsCompanyOrgUnit()) {
                this.btnMaintainAssistantOrg.setVisible(false);
                this.btnAccountingRange.setVisible(false);
            } else if ("00000000-0000-0000-0000-000000000000CCE7AED4".equals(this.editData.getId().toString())) {
                this.btnMaintainAssistantOrg.setVisible(false);
                this.btnAccountingRange.setVisible(false);
            } else if (this.editData.isIsAdminOrgUnit() || this.editData.isIsSaleOrgUnit() || this.editData.isIsPurchaseOrgUnit() || this.editData.isIsStorageOrgUnit() || this.editData.isIsCostOrgUnit() || this.editData.isIsProfitOrgUnit() || this.editData.isIsHROrgUnit() || this.editData.isIsTransportOrgUnit() || this.editData.isIsQualityOrgUnit()) {
                this.btnMaintainAssistantOrg.setVisible(false);
                this.btnAccountingRange.setVisible(false);
            }
        }
    }

    private void hideSomeButtonsWhenReadOnly2() {
        boolean visible;
        boolean bl = visible = !this.editData.isIsOUSealUp();
        if (visible) {
            try {
                BOSUuid id = this.editData.getId();
                if (id != null) {
                    FullOrgUnitInfo fullOrgUnitInfo = (FullOrgUnitInfo)this.getValue((IObjectPK)new ObjectStringPK(id.toString()));
                    visible = !fullOrgUnitInfo.isIsOUSealUp();
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        this.btnEdit.setVisible(visible);
        this.btnSubmit.setVisible(visible);
        this.btnAdminOrgType.setVisible(visible);
        this.btnSealUp.setVisible(visible);
        this.btnUnSealUp.setVisible(visible);
        this.separatorFW2.setVisible(visible);
        this.separatorFW3.setVisible(visible);
    }

    private void setTabsEnabled(boolean enabled) throws Exception {
        OUEditUICenter.getInstance().setChkEnableAllComp(enabled);
    }

    void loadAllFields() throws Exception {
        this.loadBaseFields();
        OUEditUICenter.getInstance().loadOrgFields(this);
    }

    @Override
    public void storeFields() {
        try {
            OrgUnitRelationCollection delegateCol;
            String oldNumber = null;
            String oldName = null;
            if (this.getOrgTypeHelper() != null) {
                this.editData.setOrgTypeStr(this.getOrgTypeHelper().createOrgTypeStrBySet());
                this.oldData.setOrgTypeStr(new OrgTypeHelper(this.oldData.getOrgTypeStr()).createOrgTypeStrBySet());
            }
            if (this.getOprtState().equals(OprtState.EDIT)) {
                oldNumber = this.editData.getNumber() == null ? "" : this.editData.getNumber().trim();
                oldName = this.editData.getName() == null ? "" : this.editData.getName();
            }
            super.storeFields();
            this.editData.setSyncOldValue(true);
            if (this.PDValueInfo == null) {
                this.PDValueInfo = new BizParentAndDelegateInfo();
            }
            if (this.getOprtState().equals(OprtState.ADDNEW)) {
                if (this.editData != null) {
                    if (this.getUIContext().get("ParentNode") != null) {
                        this.editData.setParent((FullOrgUnitInfo)this.getUIContext().get("ParentNode"));
                    } else {
                        this.editData.setIsCU(false);
                        this.editData.setParent(null);
                    }
                }
            } else if (this.getOprtState().equals(OprtState.EDIT)) {
                delegateCol = new OrgUnitRelationCollection();
                this.PDValueInfo.setDelegateCollection(delegateCol);
                if (!this.editData.isIsCU()) {
                    this.editData.setPartCtrl(null);
                }
                String newNumber = StringUtils.cnulls((String)this.editData.getNumber()).trim();
                String newName = this.editData.getName();
                if (!oldNumber.equals(newNumber) || !oldName.equals(newName)) {
                    this.editData.put("UpdateNumberOrName", Boolean.TRUE);
                }
                this.editData.put("OldData", this.oldData);
            }
            OUEditUICenter.getInstance().storeOrgFields();
            this.editData.put("PDValueInfo", this.PDValueInfo);
            this.editData.setNumber(StringUtils.cnulls((String)this.editData.getNumber()).trim());
            delegateCol = this.PDValueInfo.getDelegateCollection();
            delegateCol.copyNewToOld();
            this.editData.setSyncOldValue(false);
        }
        catch (Exception e) {
            logger.error((Object)"error", (Throwable)e);
            this.hasBeenSaved = true;
            SysUtil.abort();
        }
    }

    private void loadBizSuperiorAndDelegate() throws Exception {
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
            if (this.isCurVersion()) {
                INewOUInnerFacade iNOUI = NewOUInnerFacadeFactory.getRemoteInstance();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("toUnit.number"));
                sic.add(new SelectorItemInfo("toUnit.name"));
                sic.add(new SelectorItemInfo("isDefault"));
                sic.add(new SelectorItemInfo("typeRelation.toType"));
                sic.add(new SelectorItemInfo("typeRelation.fromType"));
                sic.add(new SelectorItemInfo("typeRelation.existReverseDelegate"));
                this.PDValueInfo = iNOUI.loadSuperiorAndDelegateUnits((IObjectPK)pk);
            } else {
                IOrgVersionMgrFacade iOrgVersionMgr = OrgVersionMgrFacadeFactory.getRemoteInstance();
                this.PDValueInfo = iOrgVersionMgr.loadSuperiorAndDelegateUnits(this.editData);
            }
        } else {
            this.PDValueInfo = new BizParentAndDelegateInfo();
        }
    }

    private void loadBaseFields() {
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            this.txtCreator.setText(this.editData.getCreator().getName());
            this.dateCreate.setValue((Object)this.editData.getCreateTime());
            this.orgTypeHelper = new OrgTypeHelper(this.editData.getOrgTypeStr());
        } else {
            this.txtCreator.setText(SysContext.getSysContext().getCurrentUserInfo().getName());
            this.dateCreate.setValue((Object)Calendar.getInstance().getTime());
            this.orgTypeHelper = new OrgTypeHelper();
        }
    }

    private void initOtherLayout() {
        this.pnlBizChk.setLayout((LayoutManager)new FlowLayout(0, 2, 2));
        this.pnlBizChk.doLayout();
    }

    protected IObjectValue createNewData() {
        FullOrgUnitInfo info = new FullOrgUnitInfo();
        if (this.getUIContext().get("ParentNode") != null) {
            info.setParent((FullOrgUnitInfo)this.getUIContext().get("ParentNode"));
        } else {
            info.setParent(null);
        }
        info.setCU(this.currentCtrlUnit);
        this.getNotExistNnumberByCodingRule(info);
        this.initOtherLayout();
        this.orgTypeHelper = new OrgTypeHelper();
        return info;
    }

    private void getNotExistNnumberByCodingRule(FullOrgUnitInfo info) {
        if (this.hasCodeRule) {
            String orgId = "";
            if (this.currentCtrlUnit != null) {
                orgId = this.currentCtrlUnit.getId().toString();
            }
            this.readNewNumber((IObjectValue)info, info.getNumber(), orgId);
        }
    }

    private void readNewNumber(IObjectValue caller, String number, String orgID) {
        try {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            number = iCodingRuleManager.readNumber(caller, orgID);
            String oql = "WHERE number='" + number + "'";
            if (this.getBizInterface().exists(oql)) {
                iCodingRuleManager.getNumber(caller, orgID);
                this.readNewNumber(caller, number, orgID);
            } else {
                this.prepareNumber(caller, number);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void prepareNumber(IObjectValue caller, String number) {
        caller.setString("number", number);
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        OrgStructureInfo orgStructureInfo;
        IObjectValue obj = (IObjectValue)this.getUIContext().get(OrgUnitInfo.class.getName());
        if (obj != null) {
            return obj;
        }
        obj = this.getBizInterface().getValue(pk, this.getSelectors());
        if (obj == null && this.getUIContext().get("Owner") instanceof OUViewListUI && (orgStructureInfo = OrgStructureFactory.getRemoteInstance().getOrgStructureInfo(pk)) != null) {
            ObjectStringPK objectStringPK = new ObjectStringPK(orgStructureInfo.getUnit().getId().toString());
            obj = this.getBizInterface().getValue((IObjectPK)objectStringPK, this.getSelectors());
        }
        return obj;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FullOrgUnitFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.name"));
        return sic;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        this.verifyInput2(e);
    }

    private boolean isNeedShowOrgNameDup() throws Exception {
        String value = ParamManager.getParamValue(null, null, (String)"ORG001");
        return !"false".equalsIgnoreCase(value);
    }

    private void verifyInputBaseData() throws Exception {
        String invalidChar;
        int i;
        if (StringUtils.isEmpty((String)this.editData.getNumber())) {
            this.txtNumber.requestFocusInWindow();
            throw new OrgBlankException(OrgBlankException.NUMBER_CAN_NOT_BLANK);
        }
        if (StringUtils.isEmpty((String)this.editData.getName())) {
            this.mlbName.requestFocusInWindow();
            throw new OrgBlankException(OrgBlankException.NAME_CAN_NOT_BLANK);
        }
        String[] allInvalidChar = OrgToolUtils.allInvalidNumberChar(null);
        for (i = 0; i < allInvalidChar.length; ++i) {
            invalidChar = allInvalidChar[i];
            if (this.editData.getNumber().trim().indexOf(invalidChar) == -1) continue;
            this.txtNumber.requestFocus();
            throw new OrgBlankException(OrgBlankException.NUMBER_INCLUDE_FORBIDDEN_CHAR, new Object[]{invalidChar});
        }
        allInvalidChar = OrgToolUtils.allInvalidNameChar(null);
        for (i = 0; i < allInvalidChar.length; ++i) {
            invalidChar = allInvalidChar[i];
            if (this.editData.getName().trim().indexOf(invalidChar) == -1) continue;
            this.mlbName.requestFocus();
            throw new OrgBlankException(OrgBlankException.NAME_INCLUDE_FORBIDDEN_CHAR, new Object[]{invalidChar});
        }
        this.verifyOrgNameDup();
    }

    private void verifyOrgNameDup() throws OUException, EASBizException, BOSException {
        String oql = "where name = '" + this.editData.getName().replaceAll("'", "''") + "'";
        if (this.editData.getId() != null) {
            oql = oql + " and id <> '" + this.editData.getId().toString() + "'";
        }
        if (this.editData.getParent() != null && this.editData.getParent().getId() != null) {
            oql = oql + " and parent ='" + this.editData.getParent().getId().toString() + "'";
        }
        oql = oql + " and ISUNION = 0";
        if (FullOrgUnitFactory.getRemoteInstance().exists(oql)) {
            String path = "com.kingdee.eas.basedata.org.OUException";
            MsgBox.showError((String)EASResource.getString((String)path, (String)"NAME_DUP"));
            SysUtil.abort();
        }
    }

    private void verifyInput2(ActionEvent arg0) throws Exception {
        this.verifyInputBaseData();
        OUEditUICenter.getInstance().verifyInput(this);
        if ("EDIT".equals(this.oprtState)) {
            this.delPermissonAfterDelOrg();
        }
    }

    private void delPermissonAfterDelOrg() throws Exception {
        Set delOrgTypeSet = this.getDelOrgType();
        String ouID = this.editData.getId().toString();
        UserCollection userCol = null;
        IPermission iPer = null;
        if (delOrgTypeSet != null && delOrgTypeSet.size() != 0) {
            iPer = PermissionFactory.getRemoteInstance();
            userCol = iPer.getRefUersByPermisson(delOrgTypeSet, ouID);
        }
        if (userCol != null && userCol.size() != 0) {
            StringBuffer userName = new StringBuffer();
            int size = userCol.size();
            for (int i = 0; i < size; ++i) {
                UserInfo userInfo = userCol.get(i);
                userName.append(userInfo.getNumber()).append("(").append(userInfo.getName()).append(");\n");
            }
            String msg = EASResource.getString((String)this.strResource, (String)"CONFIRM_DELETE_PERMISSION");
            if (!MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)(msg + "\n" + userName.toString())))) {
                SysUtil.abort();
            }
        }
    }

    private Set getDelOrgType() {
        HashSet delOrgType = new HashSet();
        HashSet<OrgType> oldOrgTypeSet = new HashSet<OrgType>();
        String oldOrgTypeStr = this.oldData.getOrgTypeStr();
        Set newOrgTypeSet = this.getOrgTypeHelper().getAllSelectOrgTypeSet();
        if (!StringUtils.isEmpty((String)oldOrgTypeStr)) {
            String[] oldOrgTypeStrAry = oldOrgTypeStr.split(";");
            for (int i = 0; i < oldOrgTypeStrAry.length; ++i) {
                String orgTypeValue = oldOrgTypeStrAry[i];
                if (StringUtils.isEmpty((String)orgTypeValue)) continue;
                oldOrgTypeSet.add(OrgType.getEnum(orgTypeValue));
            }
            oldOrgTypeSet.removeAll(newOrgTypeSet);
            delOrgType = oldOrgTypeSet;
        }
        return delOrgType;
    }

    @Override
    protected void kDTabbedPane1_stateChanged(ChangeEvent e) throws Exception {
        KDTabbedPane tabbedPane = (KDTabbedPane)e.getSource();
        KDPanel selectedPanel = (KDPanel)tabbedPane.getSelectedComponent();
        this.btnAccountingRange.setIcon(EASResource.getIcon((String)"imgTbtn_copycreate"));
        if (selectedPanel != null) {
            this.btnMaintainAssistantOrg.setVisible(false);
            this.btnAccountingRange.setVisible(false);
            OUEditUICenter.getInstance(selectedPanel).setTabPanelSelect();
        }
        tabbedPane.validate();
        tabbedPane.repaint();
    }

    private void disableSealUp() throws Exception {
        KDPanel selected;
        OUEditUICenter.getInstance().disableSealUp(this);
        if (this.getOprtState().equals("ADDNEW")) {
            this.btnSealUp.setEnabled(false);
            this.btnUnSealUp.setEnabled(false);
        }
        if ((selected = (KDPanel)this.kDTabbedPane1.getSelectedComponent()) == null) {
            this.btnSealUp.setEnabled(false);
            this.btnUnSealUp.setEnabled(false);
        }
    }

    @Override
    public void actionBizUnSealUp_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            return;
        }
        String unitID = this.editData.getId().toString();
        int orgTypeValue = -1;
        KDPanel selected = (KDPanel)this.kDTabbedPane1.getSelectedComponent();
        if (selected == null) {
            return;
        }
        OrgEditPanelInfo panelInfo = OUEditUICenter.getInstance().getPanelInfo(selected);
        String name = panelInfo.getPanelName();
        orgTypeValue = panelInfo.getOrgType().getValue();
        OUEditUICenter.getInstance(panelInfo.getOrgType()).checkBeforeBizUnSealUp(this);
        INewOUInnerFacade iOUI = NewOUInnerFacadeFactory.getRemoteInstance();
        iOUI.bizUnSealUp(unitID, orgTypeValue);
        OrgToolUtils.removeCache(orgTypeValue, false);
        this.showUnSealUpSuccess(name, orgTypeValue);
        OUEditUICenter.getInstance(panelInfo.getOrgType()).unSealUp(this);
        super.inOnload();
        this.hasBeenSaved = true;
    }

    private List beforeSealUp(FullOrgUnitInfo model, int orgTypeValue, String configitemName, String attributeKey) throws BOSException, EASBizException {
        ArrayList<OrgSealUpInfo> retOrgSealUpCollection = new ArrayList<OrgSealUpInfo>();
        List dealClassNamesList = null;
        OrgXMLElement xmlElement = null;
        String key = null;
        String value = null;
        boolean isThrowException = true;
        String description = "";
        StringBuffer errorMessage = null;
        try {
            dealClassNamesList = OrgConfigHelper.getXMLBizClasses(configitemName, attributeKey);
        }
        catch (JDOMException e) {
            logger.info((Object)"JDOMerror", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (IOException e) {
            logger.info((Object)"IOerror", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        for (int i = 0; i < dealClassNamesList.size(); ++i) {
            xmlElement = (OrgXMLElement)dealClassNamesList.get(i);
            key = xmlElement.getKey();
            value = xmlElement.getValue();
            isThrowException = xmlElement.isThrowException();
            description = xmlElement.getDescription();
            errorMessage = new StringBuffer();
            errorMessage.append("--org beforeSealUp error--\n").append("key=").append(key).append("\n").append("value=").append(value).append("\n").append("description=").append(description).append("\n");
            if (StringUtils.isEmpty((String)value)) continue;
            try {
                Class<?> dealClass = Class.forName(value);
                IOrgSealUp iOrgSealUp = (IOrgSealUp)dealClass.newInstance();
                OrgSealUpInfo info = iOrgSealUp.beforeSealUp(this.editData, orgTypeValue, (IUIObject)this);
                retOrgSealUpCollection.add(info);
                continue;
            }
            catch (BOSException e) {
                logger.info((Object)("OUEditUI beforeSealUp BOSException err !" + (Object)((Object)e)));
                if (!isThrowException) continue;
                throw new BOSException((Throwable)e);
            }
            catch (EASBizException e) {
                logger.info((Object)("OUEditUI beforeSealUp EASBizException err!" + (Object)((Object)e)));
                if (!isThrowException) continue;
                throw new BOSException((Throwable)e);
            }
            catch (ClassNotFoundException e) {
                logger.info((Object)("OUEditUI beforeSealUp ClassNotFoundException!" + e));
                continue;
            }
            catch (InstantiationException e) {
                logger.info((Object)("OUEditUI beforeSealUp InstantiationException!" + e));
                continue;
            }
            catch (IllegalAccessException e) {
                logger.info((Object)("OUEditUI beforeSealUp IllegalAccessException!" + e));
                continue;
            }
            catch (Exception e) {
                logger.info((Object)("OUEditUI beforeSealUp Exception !" + e));
            }
        }
        return retOrgSealUpCollection;
    }

    @Override
    public void actionBizSealUp_actionPerformed(ActionEvent e) throws Exception {
        KDPanel selectedPanel;
        OrgUnitRelationCollection orgUnitRelationClone = (OrgUnitRelationCollection)((Object)this.PDValueInfo.getDelegateCollection().clone());
        super.actionBizSealUp_actionPerformed(e);
        if (this.editData.getId() == null) {
            return;
        }
        String unitID = this.editData.getId().toString();
        int orgTypeValue = -1;
        KDPanel selected = (KDPanel)this.kDTabbedPane1.getSelectedComponent();
        if (selected == null) {
            return;
        }
        OrgEditPanelInfo panelInfo = OUEditUICenter.getInstance().getPanelInfo(selected);
        orgTypeValue = panelInfo.getOrgType().getValue();
        String name = panelInfo.getPanelName();
        List list = this.beforeSealUp(this.editData, orgTypeValue, "OrgSealUp", null);
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                OrgSealUpInfo sealUpInfo = (OrgSealUpInfo)list.get(i);
                if (!ToSealUpEnum.FAIL.equals((Object)sealUpInfo.getToSealSatus())) continue;
                logger.info((Object)"actionBizSealUp_actionPerformed CANCEL or Fail!");
                return;
            }
        }
        try {
            INewOUInnerFacade iOUI = NewOUInnerFacadeFactory.getRemoteInstance();
            iOUI.bizSealUp(unitID, orgTypeValue, list);
        }
        catch (Exception e2) {
            logger.error((Object)"error", (Throwable)e2);
            ExceptionHandler.handle((Throwable)e2);
            SysUtil.abort();
        }
        OrgToolUtils.removeCache(orgTypeValue, false);
        this.showSealUpSuccess(name, orgTypeValue);
        if (this.getUIContext().get("ID") == null) {
            this.getUIContext().put("ID", unitID);
        }
        super.inOnload();
        OUEditUICenter.getInstance(panelInfo.getOrgType()).sealUp(this);
        this.disableSealUp();
        if (orgUnitRelationClone == null || orgUnitRelationClone != null && orgUnitRelationClone.equals((Object)this.PDValueInfo.getDelegateCollection())) {
            this.hasBeenSaved = true;
        }
        if ((selectedPanel = (KDPanel)this.kDTabbedPane1.getSelectedComponent()) != null) {
            OUEditUICenter.getInstance(selectedPanel).setTabPanelSelect();
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        boolean flag_OU_Update = OUEditUIHelper.checkFunctionPermission("OU_Update");
        if (!flag_OU_Update) {
            MsgBox.showError((String)EASResource.getString((String)this.strResource, (String)"NoPermissionToUpdate"));
            return;
        }
        if (AdminOrgRangeFilterUtil.isFilterByUserAdminOrgRange(null)) {
            String orgid = this.editData.getId().toString();
            if (AdminOrgRangeFilterUtil.isTopLevelNodeInRange((DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot(), orgid)) {
                MsgBox.showInfo((Component)((Object)this), (String)OrgToolUtils.getResource("res_45"));
                SysUtil.abort();
            }
        }
        super.actionEdit_actionPerformed(e);
        this.setStatusForAssistantOrg(true);
        this.loadAllFields();
        this.disableSealUp();
        if (!OUEditUIHelper.checkFunctionPermission("OU_AddNew") && !flag_OU_Update) {
            this.initPanelByPermission();
        }
    }

    @Override
    public void actionEditAdminOrgType_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
        UIModelDialog uiWindow = (UIModelDialog)uiFactory.create(OrgLayerListUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.setResizable(true);
        uiWindow.show();
        IOUEditHelper ouEditHelper = OUEditUICenter.getInstance(OrgType.Admin);
        OUEdit_AdminUI adminUI = (OUEdit_AdminUI)ouEditHelper.getPanelInfo().getMyUI();
        adminUI.reLoadLayerType();
    }

    protected void lockUIForViewStatus() {
        this.setBasicFieldsEditable(false);
    }

    protected void unLockUI() {
        this.setBasicFieldsEditable(true);
    }

    private void setBasicFieldsEditable(boolean editable) {
        this.mlbName.setEditable(editable);
        this.txtNumber.setEditable(editable);
        this.txtSimpleName.setEditable(editable);
        this.txtCode.setEditable(editable);
        this.txtEnglishName.setEditable(editable);
        this.mlbDesription.setEditable(editable);
        this.btnSealUp.setEnabled(editable);
        this.btnUnSealUp.setEnabled(editable);
        this.btnSubmit.setEnabled(editable);
        this.btnEdit.setEnabled(!editable);
    }

    public boolean isModify() {
        if (this.hasBeenSaved) {
            return false;
        }
        try {
            ControlUtilities.checkFocusAndCommit();
        }
        catch (ParseException e) {
            this.handleControlException();
            this.abort();
        }
        if (OprtState.VIEW.equals(this.getOprtState())) {
            return false;
        }
        try {
            this.storeFields();
        }
        catch (Exception exc) {
            return false;
        }
        FullOrgUnitInfo objectValue = this.editData;
        return !ObjectValueForOrgUnitUtils.fullOrgUnitInfoEquals(this.oldData, this.editData);
    }

    private void setOldData(IObjectValue dataObject) {
        FullOrgUnitInfo objectValue = (FullOrgUnitInfo)dataObject;
        this.oldData = (FullOrgUnitInfo)objectValue.clone();
        if (this.PDValueInfo != null) {
            BizParentAndDelegateInfo newPDValueInfo = null;
            try {
                newPDValueInfo = (BizParentAndDelegateInfo)ObjectUtils.createCopy((Object)this.PDValueInfo);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            this.oldData.put("PDValueInfo", newPDValueInfo);
        } else {
            this.oldData.put("PDValueInfo", new BizParentAndDelegateInfo());
        }
    }

    private void checkTableIndex() {
        if (this.kDTabbedPane1.getTabCount() != 0) {
            this.kDTabbedPane1.setSelectedIndex(0);
        }
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        OUEditUICenter.getInstance().setChkBoxEnable(true);
        this.checkTableIndex();
        this.clearUIData();
        super.actionLast_actionPerformed(e);
        OUEditUICenter.getInstance().setChkBoxEnable(false);
        this.resetUISize();
        this.disableUIElementsForOnlyViewing();
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        OUEditUICenter.getInstance().setChkBoxEnable(true);
        this.checkTableIndex();
        this.clearUIData();
        super.actionFirst_actionPerformed(e);
        OUEditUICenter.getInstance().setChkBoxEnable(false);
        this.resetUISize();
        this.disableUIElementsForOnlyViewing();
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        OUEditUICenter.getInstance().setChkBoxEnable(true);
        this.checkTableIndex();
        this.clearUIData();
        super.actionNext_actionPerformed(e);
        OUEditUICenter.getInstance().setChkBoxEnable(false);
        this.resetUISize();
        this.disableUIElementsForOnlyViewing();
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        OUEditUICenter.getInstance().setChkBoxEnable(true);
        this.checkTableIndex();
        this.clearUIData();
        super.actionPre_actionPerformed(e);
        OUEditUICenter.getInstance().setChkBoxEnable(false);
        this.resetUISize();
        this.disableUIElementsForOnlyViewing();
    }

    @Override
    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
        if ("ADDNEW".equals(this.oprtState)) {
            this.chkMenuItemSubmitAndAddNew.setSelected(true);
            this.chkMenuItemSubmitAndPrint.setSelected(false);
        } else if ("EDIT".equals(this.oprtState)) {
            this.chkMenuItemSubmitAndAddNew.setSelected(false);
            this.chkMenuItemSubmitAndPrint.setSelected(false);
        } else if ("VIEW".equals(this.oprtState)) {
            // empty if block
        }
    }

    @Override
    public void actionViewOrgLog_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this);
        uiContext.put((Object)"current_org_id", (Object)this.editData.getId().toString());
        IUIWindow uiWindow = null;
        IUIFactory uiFactory = null;
        uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        uiWindow = uiFactory.create(OrgLogListUI.class.getName(), (Map)uiContext);
        if (uiWindow instanceof UIModelDialog) {
            UIModelDialog tmp = (UIModelDialog)uiWindow;
            tmp.setResizable(true);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int width = (int)screenSize.getWidth();
            int hidht = (int)screenSize.getHeight();
            tmp.setPreferredSize(new Dimension(width, hidht - 30));
        }
        uiWindow.show();
    }

    @Override
    public void actionAccountingRange_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this);
        if (this.editData.getPartFI() != null) {
            uiContext.put((Object)"Range_EditDataInfo", (Object)this.editData);
        }
        IUIWindow uiWindow = null;
        IUIFactory uiFactory = null;
        uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        uiWindow = uiFactory.create(ProfitAccountRangeListUI.class.getName(), (Map)uiContext);
        if (uiWindow instanceof UIModelDialog) {
            UIModelDialog tmp = (UIModelDialog)uiWindow;
            tmp.setResizable(true);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int width = (int)screenSize.getWidth() / 3;
            int hidht = (int)screenSize.getHeight() / 2;
            tmp.setPreferredSize(new Dimension(width, hidht - 30));
        }
        uiWindow.show();
    }

    @Override
    public void actionMaintainAssistantOrg_actionPerformed(ActionEvent e) throws Exception {
        if (!OUEditUICenter.getInstance(OrgType.Company).mayOperatreAssistantOrg()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.strResource, (String)"VIRTUAL_COMPANY_NOT_MAINTAIN_ASSISTANT"));
            return;
        }
        try {
            OUEditUICenter.setCanUseSecondInstance();
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"Owner", (Object)this);
            uiContext.put((Object)"mainOrg", (Object)this.editData);
            UITools.showUI((String)"com.kingdee.eas.basedata.org.client.AssistantOrgMaintainUI", (HashMap)uiContext);
        }
        finally {
            OUEditUICenter.recoverFirstInstance();
            OUEditUICenter.disableCanUseSecondInstance();
        }
    }

    private void setEnableHeadInfo(boolean enable) {
        this.txtNumber.setEnabled(enable);
        this.txtCode.setEnabled(enable);
        this.mlbName.setEnabled(enable);
        this.txtEnglishName.setEnabled(enable);
        this.txtSimpleName.setEnabled(enable);
        this.mlbDesription.setEnabled(enable);
    }

    private void initPanelByPermission() {
        if (this.oprtState == OprtState.ADDNEW) {
            this.setEnableHeadInfo(true);
        } else {
            this.setEnableHeadInfo(false);
        }
        try {
            OUEditUICenter.getInstance().initPanelByPermission(this);
        }
        catch (Exception e) {
            logger.error((Object)"error", (Throwable)e);
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public boolean isPrepareActionSubmit() {
        return true;
    }

    public RequestContext prepareActionSubmit(IItemAction itemAction) throws Exception {
        ControlUtilities.checkFocusAndCommit();
        RequestContext request = super.prepareActionSubmit(itemAction);
        request.put("editData", (Object)this.editData);
        request.put("oprtState", (Object)this.oprtState);
        return request;
    }

    public ResourceBundleHelper getResHelper() {
        return this.resHelper;
    }

    public KDPanel getPnlBizChk() {
        return this.pnlBizChk;
    }

    public OrgTypeHelper getOrgTypeHelper() {
        return this.orgTypeHelper;
    }

    public FullOrgUnitInfo getEditData() {
        return this.editData;
    }

    public KDTabbedPane getkDTabbedPanel() {
        return this.kDTabbedPane1;
    }

    public KDWorkButton getBtnUnSealUp() {
        return this.btnUnSealUp;
    }

    public KDWorkButton getBtnSealUp() {
        return this.btnSealUp;
    }

    void refreshDate() throws Exception {
        if (this.getUIContext().get("InitDataObject") != null && this.getUIContext().get("InitDataObject") instanceof IObjectValue) {
            this.setDataObject((IObjectValue)this.getUIContext().get("InitDataObject"));
        } else {
            if (this.getUIContext().get("ID") == null) {
                String s = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_IDIsNull");
                MsgBox.showError((String)s);
                SysUtil.abort();
            }
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)this.getUIContext().get("ID").toString()));
            this.setDataObject(this.getValue((IObjectPK)pk));
        }
        this.innerLoadFields();
        Object id = this.getUIContext().get("ID");
        if (id != null) {
            this.prepareData(id.toString());
        }
    }

    private void innerLoadFields() {
        this.setInnerLoadFields(true);
        this.loadFields();
    }

    class ShowResultThread
    extends Thread {
        public ShowResultThread(String resultMessage) {
            OUEditUI.this.infoLabel.setText(resultMessage);
            OUEditUI.this.infoLabel.setForeground(Color.BLUE);
        }

        @Override
        public void run() {
            for (int i = 0; i <= 2; ++i) {
                OUEditUI.this.infoLabel.setVisible(true);
                try {
                    ShowResultThread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                OUEditUI.this.infoLabel.setVisible(false);
                try {
                    ShowResultThread.sleep(500L);
                    continue;
                }
                catch (InterruptedException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

