/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.INewOUInnerFacade;
import com.kingdee.eas.basedata.org.INewOrgF7Facade;
import com.kingdee.eas.basedata.org.NewOUInnerFacadeFactory;
import com.kingdee.eas.basedata.org.NewOrgF7FacadeFactory;
import com.kingdee.eas.basedata.org.NewOrgUnitFacadeFactory;
import com.kingdee.eas.basedata.org.OrgAssistInfo;
import com.kingdee.eas.basedata.org.OrgSpecialTablesRebuildFacadeFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgTypeForEntityEnum;
import com.kingdee.eas.basedata.org.OrgVersionMgrFacadeFactory;
import com.kingdee.eas.basedata.org.OrgViewFactory;
import com.kingdee.eas.basedata.org.client.AbstractOUFullListUI;
import com.kingdee.eas.basedata.org.client.OUEditUI;
import com.kingdee.eas.basedata.org.client.OUFullVersionListUI;
import com.kingdee.eas.basedata.org.client.OUViewVersionListUI;
import com.kingdee.eas.basedata.org.client.OrgLogListUI;
import com.kingdee.eas.basedata.org.client.OrgSpecialTablesClientUtil;
import com.kingdee.eas.basedata.org.client.di.OrgDIUtil;
import com.kingdee.eas.basedata.org.client.helper.OrgUIDataUtil;
import com.kingdee.eas.basedata.org.helper.OrgTableHelper;
import com.kingdee.eas.basedata.org.util.OrgToolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.framework.query.QuickFilteringSupportManager;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFrame;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class OUFullListUI
extends AbstractOUFullListUI {
    Logger logger = Logger.getLogger((String)OUFullListUI.class.getName());
    private boolean isContainOUSealUp = false;
    private boolean isShowVirtual = false;
    String strResource = "com.kingdee.eas.basedata.org.client.OUResource";
    private OrgTypeForEntityEnum currentOrgTypeForEntity = null;
    private static final Color NORMAL_COLOR = new Color(0xF9F9F9);
    private static final Color SEALUP_COLOR = new Color(0xD9D9D2);
    private static final Color BIZUNIT_COLOR = new Color(16574898);
    private OrgUIDataUtil orgDataHelper = null;
    private boolean buildTree_doing = false;
    private int level = 2;
    private boolean initializedLevel = false;
    private static final File userLevelPropertyFile = new File(new StringBuffer().append(System.getProperty("easclient.root")).append(File.separator).append("OUFullListUserLevel.properties").toString());
    QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    public OUFullListUI() throws Exception {
        this.init();
        this.initCbxEntity();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int begin = e.getFirstRow();
                int end = e.getLastRow();
                Map isOrgEntityMap = new HashMap();
                if (!OUFullListUI.this.currentOrgTypeForEntity.equals((Object)OrgTypeForEntityEnum.NULL)) {
                    isOrgEntityMap = OUFullListUI.this.getIsOrgEntityMap(OUFullListUI.this.tblMain, begin, end);
                }
                OrgTableHelper.addTalbeOrgCol(OUFullListUI.this.tblMain);
                for (int i = begin; i <= end; ++i) {
                    String orgTypeStr = (String)OUFullListUI.this.tblMain.getRow(i).getCell("orgTypeStr").getValue();
                    IRow row = OUFullListUI.this.tblMain.getRow(i);
                    OrgTableHelper.setTableRowValue(orgTypeStr, row);
                    if (OUFullListUI.this.isTheOUSealedUp(i)) {
                        row.getStyleAttributes().setBackground(SEALUP_COLOR);
                        continue;
                    }
                    if (OUFullListUI.this.isEntityOrgUnit(i, isOrgEntityMap)) {
                        row.getStyleAttributes().setBackground(BIZUNIT_COLOR);
                        continue;
                    }
                    row.getStyleAttributes().setBackground(NORMAL_COLOR);
                }
            }
        });
    }

    private Map getIsOrgEntityMap(KDTable table, int begin, int end) {
        Map map = new HashMap();
        HashSet<String> idSet = new HashSet<String>();
        for (int i = begin; i <= end; ++i) {
            idSet.add((String)table.getRow(i).getCell("id").getValue());
        }
        try {
            map = OrgViewFactory.getRemoteInstance().getOrgsIsEntityMap(idSet, this.currentOrgTypeForEntity);
        }
        catch (Exception e) {
            this.logger.info((Object)"OrgViewFactory getOrgsIsEntityMap err!", (Throwable)e);
        }
        return map;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            request.setClassName("com.kingdee.eas.basedata.org.app.OUFullListUIHandler");
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    @Override
    public boolean isPrepareInit() {
        return false;
    }

    private void init() throws Exception {
        this.btnOrgStart.setVisible(false);
        this.btnOrgUndoStart.setVisible(false);
        this.menuItemOrgStart.setVisible(false);
        this.menuItemOrgUndoStart.setVisible(false);
        this.btnContainOUSealUp.setEnabled(true);
        this.menuItemSwitchSealUp.setEnabled(true);
        this.btnShowVirtual.setEnabled(true);
        this.menuItemShowVirtual.setEnabled(true);
        this.setBtnContainSealUpStatus();
        this.setBtnShowVirtualStatus();
        this.menuOrg.setEnabled(true);
        this.menuItemSwitchImage.setEnabled(true);
        this.menuItemSwitchSealUp.setEnabled(true);
        this.btnView.setVisible(true);
        this.btnDraw.setEnabled(true);
        this.btnDraw.setIcon(EASResource.getIcon((String)"imgTbtn_orgstruchart"));
        this.btnMoveTree.setVisible(false);
        this.menuImport.setVisible(false);
        this.menuImport.setEnabled(false);
        this.menuExport.setVisible(false);
        this.menuExport.setEnabled(false);
        this.menuItemVersioning.setEnabled(true);
        this.menuItemOUFullVersion.setEnabled(true);
        this.menuItemOUViewVersion.setEnabled(true);
        this.menuItemVersioning.setIcon(EASResource.getIcon((String)"imgTbtn_copycreate"));
        this.menuItemOUFullVersion.setIcon(EASResource.getIcon((String)"imgTbtn_historyedition"));
        this.menuItemOUViewVersion.setIcon(EASResource.getIcon((String)"imgTbtn_historyedition"));
        this.menuItemViewOrgLog.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        OrgSpecialTablesClientUtil.setTheKDWorkButtonUsedToRebuildSpecialTables(this.btnSync);
        OrgSpecialTablesClientUtil.setTheMenuItemUsedToRebuildSpecialTables(this.menuItemSync);
        this.actionAddNew.setEnabled(false);
        this.actionEdit.setEnabled(false);
        this.actionRemove.setEnabled(false);
        this.btnQuery.setEnabled(true);
        this.btnQuery.setVisible(true);
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        if (!Administrator.isSuperCUAdmin((IObjectPK)new ObjectUuidPK(userInfo.getId()))) {
            this.menuItemVersioning.setVisible(false);
        }
    }

    private void initOrgStartAndOrgUndoStart() throws Exception {
        this.btnOrgStart.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.btnOrgUndoStart.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.menuItemOrgStart.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.menuItemOrgUndoStart.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        if (Administrator.isSuperCUAdmin((IObjectPK)new ObjectUuidPK(userInfo.getId()))) {
            boolean isOrgStart = NewOrgUnitFacadeFactory.getRemoteInstance().isOrgStart();
            this.menuItemOrgStart.setVisible(!isOrgStart);
            this.menuItemOrgUndoStart.setVisible(isOrgStart);
            this.btnOrgStart.setVisible(!isOrgStart);
            this.btnOrgUndoStart.setVisible(isOrgStart);
        } else {
            this.menuItemOrgStart.setVisible(false);
            this.menuItemOrgUndoStart.setVisible(false);
            this.btnOrgStart.setVisible(false);
            this.btnOrgUndoStart.setVisible(false);
        }
    }

    private void setBtnContainSealUpStatus() {
        if (this.isContainOUSealUp) {
            this.btnContainOUSealUp.setText(EASResource.getString((String)this.strResource, (String)"SEALUP_NOTCONTAIN"));
            this.btnContainOUSealUp.setToolTipText(EASResource.getString((String)this.strResource, (String)"SEALUP_NOTCONTAIN"));
            this.btnContainOUSealUp.setIcon(EASResource.getIcon((String)"imgTbtn_deletesealup"));
            this.menuItemSwitchSealUp.setText(EASResource.getString((String)this.strResource, (String)"SEALUP_NOTCONTAIN"));
            this.menuItemSwitchSealUp.setToolTipText(EASResource.getString((String)this.strResource, (String)"SEALUP_NOTCONTAIN"));
            this.menuItemSwitchSealUp.setIcon(EASResource.getIcon((String)"imgTbtn_deletesealup"));
        } else {
            this.btnContainOUSealUp.setText(EASResource.getString((String)this.strResource, (String)"SEALUP_CONTAIN"));
            this.btnContainOUSealUp.setToolTipText(EASResource.getString((String)this.strResource, (String)"SEALUP_CONTAIN"));
            this.btnContainOUSealUp.setIcon(EASResource.getIcon((String)"imgTbtn_showsealup"));
            this.menuItemSwitchSealUp.setText(EASResource.getString((String)this.strResource, (String)"SEALUP_CONTAIN"));
            this.menuItemSwitchSealUp.setToolTipText(EASResource.getString((String)this.strResource, (String)"SEALUP_CONTAIN"));
            this.menuItemSwitchSealUp.setIcon(EASResource.getIcon((String)"imgTbtn_showsealup"));
        }
    }

    private void setBtnShowVirtualStatus() {
        if (this.isShowVirtual) {
            this.btnShowVirtual.setText(EASResource.getString((String)this.strResource, (String)"NOT_SHOW_VIRTUAL"));
            this.btnShowVirtual.setToolTipText(EASResource.getString((String)this.strResource, (String)"NOT_SHOW_VIRTUAL"));
            this.btnShowVirtual.setIcon(EASResource.getIcon((String)"imgTbtn_offdummygroup"));
            this.menuItemShowVirtual.setText(EASResource.getString((String)this.strResource, (String)"NOT_SHOW_VIRTUAL"));
            this.menuItemShowVirtual.setToolTipText(EASResource.getString((String)this.strResource, (String)"NOT_SHOW_VIRTUAL"));
            this.menuItemShowVirtual.setIcon(EASResource.getIcon((String)"imgTbtn_offdummygroup"));
        } else {
            this.btnShowVirtual.setText(EASResource.getString((String)this.strResource, (String)"SHOW_VIRTUAL"));
            this.btnShowVirtual.setToolTipText(EASResource.getString((String)this.strResource, (String)"SHOW_VIRTUAL"));
            this.btnShowVirtual.setIcon(EASResource.getIcon((String)"imgTbtn_dummygroup"));
            this.menuItemShowVirtual.setText(EASResource.getString((String)this.strResource, (String)"SHOW_VIRTUAL"));
            this.menuItemShowVirtual.setToolTipText(EASResource.getString((String)this.strResource, (String)"SHOW_VIRTUAL"));
            this.menuItemShowVirtual.setIcon(EASResource.getIcon((String)"imgTbtn_dummygroup"));
        }
    }

    private boolean isTheOUSealedUp(int rowIndex) {
        if (this.tblMain.getCell(rowIndex, "isOUSealUp") == null || this.tblMain.getCell(rowIndex, "isOUSealUp").getValue() == null) {
            return false;
        }
        return (Boolean)this.tblMain.getCell(rowIndex, "isOUSealUp").getValue();
    }

    private boolean isEntityOrgUnit(int rowIndex, Map isOrgEntityMap) {
        String id;
        Boolean isEntity;
        if (OrgTypeForEntityEnum.NULL == this.currentOrgTypeForEntity) {
            return false;
        }
        if (this.orgDataHelper == null) {
            this.orgDataHelper = new OrgUIDataUtil();
        }
        return (isEntity = (Boolean)isOrgEntityMap.get(id = StringUtils.cnulls((Object)this.tblMain.getRow(rowIndex).getCell("id").getValue()))) == null ? false : isEntity;
    }

    private void initCbxEntity() {
        this.cbxEntity.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    OUFullListUI.this.currentOrgTypeForEntity = (OrgTypeForEntityEnum)((Object)OUFullListUI.this.cbxEntity.getSelectedItem());
                    try {
                        OUFullListUI.this.initTree();
                        OUFullListUI.this.treeMain.setSelectionNode((DefaultKingdeeTreeNode)OUFullListUI.this.treeMain.getModel().getRoot());
                    }
                    catch (Exception e1) {
                        OUFullListUI.this.handleException(e1);
                    }
                }
            }
        });
        DefaultComboBoxModel<OrgTypeForEntityEnum> model = new DefaultComboBoxModel<OrgTypeForEntityEnum>();
        Iterator iter = OrgTypeForEntityEnum.iterator();
        while (iter.hasNext()) {
            OrgTypeForEntityEnum orgType = (OrgTypeForEntityEnum)((Object)iter.next());
            model.addElement(orgType);
        }
        this.cbxEntity.setModel(model);
        this.cbxEntity.setSelectedIndex(0);
        this.cbxEntity.setEditable(false);
        this.currentOrgTypeForEntity = OrgTypeForEntityEnum.NULL;
        this.cbxEntity.setMaximumRowCount(model.getSize());
    }

    public void onLoad() throws Exception {
        this.initTblMain();
        this.menuItemSync.setVisible(false);
        this.menuItemRebuildAdminCU.setVisible(true);
        this.menuItemRebuildAdminCU.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OUFullListUI.this.beforeActionPerformed(e);
                try {
                    OUFullListUI.this.menuItemRebuildAdminCU_actionPerformed(e);
                }
                catch (Exception exc) {
                    OUFullListUI.this.handUIException(exc);
                }
                finally {
                    OUFullListUI.this.afterActionPerformed(e);
                }
            }
        });
        this.loadLevel();
        super.onLoad();
        this.addTreeListener();
    }

    private void addTreeListener() {
        this.treeMain.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                DefaultKingdeeTreeNode tmp = (DefaultKingdeeTreeNode)event.getPath().getLastPathComponent();
                if (tmp == null) {
                    return;
                }
                try {
                    OUFullListUI.this.loadNode(tmp);
                }
                catch (Exception e) {
                    OUFullListUI.this.logger.error((Object)"error", (Throwable)e);
                }
            }
        });
    }

    private void loadNode(DefaultKingdeeTreeNode tmp) throws BOSException, EASBizException {
        FullOrgUnitInfo unitInfo;
        if (tmp != null && tmp.getUserObject() != null && (unitInfo = (FullOrgUnitInfo)tmp.getUserObject()).get("alreadyLoad") == null) {
            OrgAssistInfo assistInfo = this.buildNewOrgF7AssistInfo();
            INewOrgF7Facade facade = NewOrgF7FacadeFactory.getRemoteInstance();
            List orgCol = facade.getDirectChildren(assistInfo, (CoreBaseInfo)unitInfo);
            if (null == orgCol || orgCol.size() == 0) {
                tmp.setCustomIcon(UIManager.getIcon("Tree.leafIcon"));
            }
            this.insertNodeIntoRoot(tmp, orgCol);
            unitInfo.put("alreadyLoad", true);
        }
    }

    private void initTblMain() {
        this.tblMain.checkParsed();
        this.tblMain.getViewManager().setFreezeView(0, 3);
    }

    public boolean destroyWindow() {
        try {
            this.storeLevel();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        return super.destroyWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLevel() throws Exception {
        this.levelSpinner.setEditable(false);
        ((SpinnerNumberModel)this.levelSpinner.getModel()).setMaximum(new Integer(100));
        ((SpinnerNumberModel)this.levelSpinner.getModel()).setMinimum(new Integer(2));
        if (userLevelPropertyFile.exists()) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(userLevelPropertyFile);
                Properties props = new Properties();
                props.load(new FileInputStream(userLevelPropertyFile));
                String key = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
                if (props.containsKey(key)) {
                    this.level = Integer.parseInt(props.getProperty(key));
                }
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.levelSpinner.setValue((Object)new Integer(this.level));
        this.initializedLevel = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeLevel() throws Exception {
        String key;
        int oldLevel = 2;
        Properties props = new Properties();
        if (userLevelPropertyFile.exists()) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(userLevelPropertyFile);
                props.load(new FileInputStream(userLevelPropertyFile));
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if (props.containsKey(key = SysContext.getSysContext().getCurrentUserInfo().getId().toString())) {
            oldLevel = Integer.parseInt(props.getProperty(key));
        }
        if (this.level != oldLevel) {
            props.setProperty(key, this.level + "");
            try (FileOutputStream fileOutputStream = null;){
                fileOutputStream = new FileOutputStream(userLevelPropertyFile);
                props.store(fileOutputStream, "");
            }
        }
    }

    protected void initTree() throws Exception {
        this.buildTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildTree() throws EASBizException, BOSException {
        this.buildTree_doing = true;
        FullOrgUnitInfo rootInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectStringPK("00000000-0000-0000-0000-000000000000CCE7AED4"));
        KDTreeNode root = new KDTreeNode((Object)rootInfo);
        try {
            TreeSelectionListener treeLis = new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    try {
                        OUFullListUI.this.treeMain_valueChanged(e);
                    }
                    catch (Exception e1) {
                        OUFullListUI.this.logger.error((Object)"error", (Throwable)e1);
                    }
                }
            };
            this.treeMain.removeTreeSelectionListener(treeLis);
            OrgAssistInfo assistInfo = this.buildNewOrgF7AssistInfo();
            INewOrgF7Facade facade = NewOrgF7FacadeFactory.getRemoteInstance();
            List orgCol = facade.getDirectChildren(assistInfo, (CoreBaseInfo)rootInfo);
            this.insertNodeIntoRoot((DefaultKingdeeTreeNode)root, orgCol);
            ((FullOrgUnitInfo)root.getUserObject()).put("alreadyLoad", true);
            this.treeMain.setModel((TreeModel)new DefaultTreeModel((TreeNode)root){

                @Override
                public boolean isLeaf(Object node) {
                    FullOrgUnitInfo info = (FullOrgUnitInfo)((KDTreeNode)node).getUserObject();
                    return info == null || info.isIsLeaf();
                }
            });
            this.treeMain.setRootVisible(true);
            this.treeMain.setShowsRootHandles(true);
            this.setTreeExpandLevel((DefaultKingdeeTreeNode)root);
            this.treeMain.addTreeSelectionListener(treeLis);
        }
        finally {
            this.buildTree_doing = false;
        }
        this.treeMain.setSelectionNode((DefaultKingdeeTreeNode)root);
    }

    private OrgAssistInfo buildNewOrgF7AssistInfo() {
        OrgAssistInfo assistInfo = new OrgAssistInfo();
        if (!this.isContainOUSealUp) {
            assistInfo.setNeedAddSealUpFilter(true);
        }
        if (!this.isShowVirtual) {
            assistInfo.setNeedAddVirtualFilter(true);
        }
        ArrayList<String> decorators = new ArrayList<String>();
        decorators.add(null);
        decorators.add("com.kingdee.eas.basedata.org.app.helper.NormalFilter4F7Decorator");
        decorators.add("com.kingdee.eas.basedata.org.app.helper.OrgRangeFilter4F7Decorator");
        assistInfo.setConstructParam(decorators);
        StringBuffer extraFilters = new StringBuffer();
        extraFilters.append(" AND ").append("\"BASEUNIT\"").append(".FIsUnion = 0 ").append(" AND ").append("\"BASEUNIT\"").append(".FID <> '").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("'");
        assistInfo.setExtraFilters(extraFilters.toString());
        assistInfo.setInnerJoinStyle(false);
        return assistInfo;
    }

    private void insertNodeIntoRoot(DefaultKingdeeTreeNode root, List orgCol) {
        for (int i = 0; i < orgCol.size(); ++i) {
            FullOrgUnitInfo info = (FullOrgUnitInfo)orgCol.get(i);
            KDTreeNode treeNode = new KDTreeNode((Object)info);
            root.add((MutableTreeNode)treeNode);
        }
    }

    private void setTreeExpandLevel(DefaultKingdeeTreeNode root) {
        if (root != null) {
            FullOrgUnitInfo fullInfo = (FullOrgUnitInfo)root.getUserObject();
            if (fullInfo != null) {
                if (fullInfo.getLevel() <= this.level) {
                    this.treeMain.expandPath(new TreePath(root));
                    this.treeMain.setSelectionNode(root);
                } else {
                    return;
                }
            }
            for (int i = 0; i < root.getChildCount(); ++i) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
                this.setTreeExpandLevel(node);
            }
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        int countMask = 0;
        String mask = "";
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("isUnion", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.NOTEQUALS));
        mask = "#0 and #1";
        countMask = 2;
        FullOrgUnitInfo selectInfo = null;
        TreePath path = this.treeMain.getSelectionPath();
        if (path != null) {
            DefaultKingdeeTreeNode selectNode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
            selectInfo = (FullOrgUnitInfo)selectNode.getUserObject();
        }
        if (selectInfo != null && selectInfo.getLevel() < this.level) {
            fic.add(new FilterItemInfo("level", (Object)new Integer(this.level), CompareType.LESS_EQUALS));
            mask = mask + " and #" + countMask;
            ++countMask;
        }
        if (!this.isContainOUSealUp) {
            fic.add(new FilterItemInfo("isOUSealUp", (Object)new Integer(0)));
            mask = mask + " and #" + countMask;
            ++countMask;
        }
        if (!this.isShowVirtual) {
            fic.add(new FilterItemInfo("isAdminOrgUnit", (Object)new Integer(1), CompareType.EQUALS));
            fic.add(new FilterItemInfo("partAdmin.isVirtual", (Object)new Integer(0), CompareType.EQUALS));
            fic.add(new FilterItemInfo("isAdminOrgUnit", (Object)new Integer(0), CompareType.EQUALS));
            mask = mask + " and ((#" + countMask + " and #" + (countMask + 1) + ") or #" + (countMask + 2) + ")";
        }
        filter.setMaskString(mask);
        return filter;
    }

    protected void buildTreeFilter() {
        super.buildTreeFilter();
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        if (!this.buildTree_doing) {
            super.treeMain_valueChanged(e);
        }
    }

    private void onTblMainSelected() {
        KDTSelectBlock block = this.tblMain.getSelectManager().get();
        if (block != null) {
            DefaultMutableTreeNode node;
            String id = (String)this.tblMain.getCell(block.getBeginRow(), "id").getValue();
            TreeModel treeModel = this.treeMain.getModel();
            if (treeModel != null && treeModel.getRoot() != null && (node = this.redirectFromTableToTree(id, (DefaultMutableTreeNode)treeModel.getRoot())) != null) {
                this.treeMain.setSelectionPath(new TreePath(node.getPath()));
            }
        }
    }

    private DefaultMutableTreeNode redirectFromTableToTree(String id, DefaultMutableTreeNode root) {
        if (root == null) {
            return null;
        }
        if (root.getUserObject() != null && root.getUserObject() instanceof FullOrgUnitInfo && id.equals(((FullOrgUnitInfo)root.getUserObject()).getId().toString())) {
            return root;
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeNode node = this.redirectFromTableToTree(id, (DefaultMutableTreeNode)root.getChildAt(i));
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
    }

    @Override
    protected void levelSpinner_stateChanged(ChangeEvent e) throws Exception {
        if (this.initializedLevel) {
            this.level = (Integer)this.levelSpinner.getValue();
            this.initTree();
        }
    }

    @Override
    public void actionOrgStart_actionPerformed(ActionEvent e) throws Exception {
        int choise = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)this.strResource, (String)"ORGSTART_WARNING"));
        if (!MsgBox.isYes((int)choise)) {
            return;
        }
        INewOUInnerFacade iNOU = NewOUInnerFacadeFactory.getRemoteInstance();
        iNOU.startOrg();
        String message = EASResource.getString((String)this.strResource, (String)"OrgStart_Success");
        this.setMessageText(message);
        this.showMessage();
        MsgBox.showInfo((Component)((Object)this), (String)message);
        this.menuItemOrgStart.setVisible(false);
        this.menuItemOrgUndoStart.setVisible(true);
        this.btnOrgStart.setVisible(false);
        this.btnOrgUndoStart.setVisible(true);
    }

    @Override
    public void actionOrgUndoStart_actionPerformed(ActionEvent e) throws Exception {
        int choice = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)this.strResource, (String)"ORG_UNDOSTART_WARNING"));
        if (MsgBox.isYes((int)choice)) {
            NewOUInnerFacadeFactory.getRemoteInstance().undoStartOrg();
            String message = EASResource.getString((String)this.strResource, (String)"ORG_UNDOSTART_SUCCESS");
            this.setMessageText(message);
            this.showMessage();
            MsgBox.showInfo((Component)((Object)this), (String)message);
            this.menuItemOrgStart.setVisible(true);
            this.menuItemOrgUndoStart.setVisible(false);
            this.btnOrgStart.setVisible(true);
            this.btnOrgUndoStart.setVisible(false);
        }
    }

    @Override
    public void actionContainOUSealUp_actionPerformed(ActionEvent e) throws Exception {
        super.actionContainOUSealUp_actionPerformed(e);
        this.isContainOUSealUp = !this.isContainOUSealUp;
        this.initTree();
        this.setBtnContainSealUpStatus();
        this.treeMain.setSelectionNode((DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot());
    }

    @Override
    public void actionShowVirtual_actionPerformed(ActionEvent e) throws Exception {
        super.actionShowVirtual_actionPerformed(e);
        this.isShowVirtual = !this.isShowVirtual;
        this.initTree();
        this.setBtnShowVirtualStatus();
        this.treeMain.setSelectionNode((DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot());
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.initTree();
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return FullOrgUnitFactory.getRemoteInstance();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"OnlyForView", (Object)new Boolean(true));
    }

    protected String getEditUIName() {
        return OUEditUI.class.getName();
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    @Override
    public void actionCU_actionPerformed(ActionEvent e) throws Exception {
        super.actionCU_actionPerformed(e);
        OrgDIUtil.performImportForOrgType(OrgType.ControlUnit);
    }

    @Override
    public void actionOU_actionPerformed(ActionEvent e) throws Exception {
        super.actionOU_actionPerformed(e);
        OrgDIUtil.performImportForOrgType(OrgType.NONE);
    }

    @Override
    public void actionAdmin_actionPerformed(ActionEvent e) throws Exception {
        super.actionAdmin_actionPerformed(e);
        OrgDIUtil.performImportForOrgType(OrgType.Admin);
    }

    @Override
    public void actionCompany_actionPerformed(ActionEvent e) throws Exception {
        super.actionCompany_actionPerformed(e);
        OrgDIUtil.performImportForOrgType(OrgType.Company);
    }

    @Override
    public void actionUnionRange_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnionRange_actionPerformed(e);
        OrgDIUtil.performImportForKey("UnionRange");
    }

    @Override
    public void actionUnionGroup_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnionGroup_actionPerformed(e);
        OrgDIUtil.performImportForKey("UnionGroup");
    }

    @Override
    public void actionUnionCompany_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnionCompany_actionPerformed(e);
        OrgDIUtil.performImportForKey("UnionCompany");
    }

    @Override
    public void actionExportCU_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportCU_actionPerformed(e);
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app", "OUExportQuery");
        EntityViewInfo mainQuery = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("isCU", (Object)new Integer(1), CompareType.EQUALS));
        fic.add(new FilterItemInfo("id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.NOTEQUALS));
        if (!this.isContainOUSealUp) {
            fic.add(new FilterItemInfo("isOUSealUp", (Object)new Integer(0), CompareType.EQUALS));
        }
        if (!this.isShowVirtual) {
            fic.add(new FilterItemInfo("partAdmin.isVirtual", (Object)new Integer(0), CompareType.EQUALS));
        }
        mainQuery.setFilter(filter);
        OrgDIUtil.performExportForOrgType((Component)((Object)this), OrgType.ControlUnit, (IMetaDataPK)mainQueryPK, mainQuery);
    }

    @Override
    public void actionExportOU_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportOU_actionPerformed(e);
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app", "OUExportQuery");
        EntityViewInfo mainQuery = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("isCU", (Object)new Integer(0), CompareType.EQUALS));
        fic.add(new FilterItemInfo("isUnion", (Object)new Integer(0), CompareType.EQUALS));
        if (!this.isContainOUSealUp) {
            fic.add(new FilterItemInfo("isOUSealUp", (Object)new Integer(0), CompareType.EQUALS));
        }
        if (!this.isShowVirtual) {
            fic.add(new FilterItemInfo("partAdmin.isVirtual", (Object)new Integer(0), CompareType.EQUALS));
        }
        mainQuery.setFilter(filter);
        OrgDIUtil.performExportForOrgType((Component)((Object)this), OrgType.NONE, (IMetaDataPK)mainQueryPK, mainQuery);
    }

    @Override
    public void actionExportAdmin_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportAdmin_actionPerformed(e);
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app", "AdminExportQuery");
        EntityViewInfo mainQuery = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        if (!this.isContainOUSealUp) {
            fic.add(new FilterItemInfo("isOUSealUp", (Object)new Integer(0), CompareType.EQUALS));
        }
        if (!this.isShowVirtual) {
            fic.add(new FilterItemInfo("isVirtual", (Object)new Integer(0), CompareType.EQUALS));
        }
        mainQuery.setFilter(filter);
        OrgDIUtil.performExportForOrgType((Component)((Object)this), OrgType.Admin, (IMetaDataPK)mainQueryPK, mainQuery);
    }

    @Override
    public void actionExportCompany_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportCompany_actionPerformed(e);
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app", "CompanyExportQuery");
        EntityViewInfo mainQuery = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        if (!this.isContainOUSealUp) {
            fic.add(new FilterItemInfo("isOUSealUp", (Object)new Integer(0), CompareType.EQUALS));
        }
        mainQuery.setFilter(filter);
        OrgDIUtil.performExportForOrgType((Component)((Object)this), OrgType.Company, (IMetaDataPK)mainQueryPK, mainQuery);
    }

    @Override
    public void actionExportUnionRange_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportUnionRange_actionPerformed(e);
        OrgDIUtil.performExportForKey((Component)((Object)this), "UnionRange", this.mainQueryPK, this.mainQuery);
    }

    @Override
    public void actionExportUnionGroup_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportUnionGroup_actionPerformed(e);
        OrgDIUtil.performExportForKey((Component)((Object)this), "UnionGroup", this.mainQueryPK, this.mainQuery);
    }

    @Override
    public void actionExportUnionCompany_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportUnionCompany_actionPerformed(e);
        OrgDIUtil.performExportForKey((Component)((Object)this), "UnionCompany", this.mainQueryPK, this.mainQuery);
    }

    @Override
    public void actionVersioning_actionPerformed(ActionEvent e) throws Exception {
        Window win = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        LongTimeDialog ltd = null;
        ltd = win instanceof Frame ? new LongTimeDialog((Frame)win) : (win instanceof Dialog ? new LongTimeDialog((Dialog)win) : new LongTimeDialog((Frame)new JFrame()));
        ltd.setTitle(EASResource.getString((String)this.strResource, (String)"CREATING_OU_NEW_VERSION"));
        ltd.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                try {
                    OrgVersionMgrFacadeFactory.getRemoteInstance().doOrgVersioning();
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.org.OrgException", (String)"ORGVERSIONSUCCESS"));
                }
                catch (Exception e) {
                    OUFullListUI.this.logger.error((Object)"error", (Throwable)e);
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.basedata.org.OrgException", (String)"ORGVERSIONERR"));
                    SysUtil.abort();
                }
                return new Boolean(true);
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        ltd.show();
    }

    @Override
    public void actionOUFullVersion_actionPerformed(ActionEvent e) throws Exception {
        List versionNumList = OrgVersionMgrFacadeFactory.getRemoteInstance().getAllHistoryVersionNumbers();
        if (versionNumList == null || versionNumList.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.strResource, (String)"NOT_EXIST_OU_VERSION"));
            return;
        }
        Map context = this.getUIContext();
        IUIWindow uiWindow = null;
        IUIFactory uiFactory = null;
        try {
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
            uiWindow = uiFactory.create(OUFullVersionListUI.class.getName(), context);
            uiWindow.show();
        }
        catch (UIException ex1) {
            this.handleException((Exception)((Object)ex1));
        }
    }

    @Override
    public void actionOUViewVersion_actionPerformed(ActionEvent e) throws Exception {
        List versionNumList = OrgVersionMgrFacadeFactory.getRemoteInstance().getAllHistoryVersionNumbers();
        if (versionNumList == null || versionNumList.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.strResource, (String)"NOT_EXIST_BIZ_VERSION"));
            return;
        }
        Map context = this.getUIContext();
        IUIWindow uiWindow = null;
        IUIFactory uiFactory = null;
        try {
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
            uiWindow = uiFactory.create(OUViewVersionListUI.class.getName(), context);
            uiWindow.show();
        }
        catch (UIException ex1) {
            this.handleException((Exception)((Object)ex1));
        }
    }

    @Override
    public void actionSetDisplayName_actionPerformed(ActionEvent e) throws Exception {
        int choice = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)this.strResource, (String)"IS_MODIFY_BIZUNIT_DISPLAYNAME"));
        if (!MsgBox.isYes((int)choice)) {
            return;
        }
        Window win = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        LongTimeDialog ltd = null;
        ltd = win instanceof Frame ? new LongTimeDialog((Frame)win) : (win instanceof Dialog ? new LongTimeDialog((Dialog)win) : new LongTimeDialog((Frame)new JFrame()));
        ltd.setTitle(OrgToolUtils.getResource("res_46"));
        ltd.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                try {
                    OrgSpecialTablesRebuildFacadeFactory.getRemoteInstance().rebuildOrgStructureDisplayName();
                }
                catch (Exception e) {
                    OUFullListUI.this.handleException(e);
                }
                return new Boolean(true);
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        ltd.show();
    }

    @Override
    public void actionViewOrgLog_actionPerformed(ActionEvent e) throws Exception {
        Map context = this.getUIContext();
        IUIWindow uiWindow = null;
        IUIFactory uiFactory = null;
        try {
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
            uiWindow = uiFactory.create(OrgLogListUI.class.getName(), context);
            uiWindow.show();
        }
        catch (UIException ex) {
            this.handleException((Exception)((Object)ex));
        }
    }

    protected boolean isSupportDynQuery() {
        return false;
    }

    protected EntityViewInfo getInitDefaultSolution() {
        return null;
    }

    protected boolean isIncludeAllChildren() {
        return true;
    }

    protected EntityViewInfo getDefaultEntityViewInfo() {
        return super.getDefaultEntityViewInfo();
    }

    protected void menuItemRebuildAdminCU_actionPerformed(ActionEvent e) throws Exception {
        OrgSpecialTablesClientUtil.showLongTimeDialogToRebuildAdminCU();
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        this.qfsi.setMustQueryAtFirst(true);
        return this.qfsi.supportExecutionWithoutFilters();
    }

    protected QuickFilteringSupportManager createQuickFilteringSupportManager() throws Exception {
        QuickFilteringSupportItems qfsi = this.getQuickFilteringSupport();
        if (qfsi != null && this.getBizType() != null) {
            qfsi.setBosType(this.getBizType().toString());
        }
        return new QuickFilteringSupportManager((ListUI)this, qfsi, (Component)this.kDPanel1);
    }
}

