/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgVersionMgrFacade;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgVersionMgrFacadeFactory;
import com.kingdee.eas.basedata.org.VersionPK;
import com.kingdee.eas.basedata.org.client.AbstractOUFullVersionListUI;
import com.kingdee.eas.basedata.org.client.OrgVersionClientUtils;
import com.kingdee.eas.basedata.org.client.helper.OrgVersionClentHelper;
import com.kingdee.eas.basedata.org.helper.OrgTableHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class OUFullVersionListUI
extends AbstractOUFullVersionListUI {
    private String versionNumber = null;
    private List versionNumList = null;
    private List invalidDateList = null;
    private OrgUnitCollection fullVersionCol = null;
    private static final Color NORMAL_COLOR = new Color(0xF9F9F9);
    private static final Color SEALUP_COLOR = new Color(0xD9D9D2);

    public OUFullVersionListUI() throws Exception {
        this.init();
    }

    private void init() throws Exception {
        this.menuTool.setVisible(false);
        this.menuHelp.setVisible(false);
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int begin = e.getFirstRow();
                int end = e.getLastRow();
                for (int i = begin; i <= end; ++i) {
                    if (OUFullVersionListUI.this.isTheOUSealedUp(i)) {
                        OUFullVersionListUI.this.tblMain.getRow(i).getStyleAttributes().setBackground(SEALUP_COLOR);
                        continue;
                    }
                    OUFullVersionListUI.this.tblMain.getRow(i).getStyleAttributes().setBackground(NORMAL_COLOR);
                }
            }
        });
        this.btnView.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.setButtonDefaultStyl(this.btnView);
    }

    private boolean isTheOUSealedUp(int rowIndex) {
        return (Boolean)this.tblMain.getCell(rowIndex, "isOUSealUp").getValue();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initCbxMain();
        this.initTree();
        this.initTblMain();
        this.addTreeExpandListener();
    }

    private void addTreeExpandListener() {
        this.treeMain.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                DefaultKingdeeTreeNode tmp = (DefaultKingdeeTreeNode)event.getPath().getLastPathComponent();
                if (tmp == null) {
                    return;
                }
                try {
                    OUFullVersionListUI.this.loadNode(tmp);
                }
                catch (Exception e) {
                    OUFullVersionListUI.this.handleException(e);
                }
            }
        });
    }

    private void loadNode(DefaultKingdeeTreeNode tmp) throws BOSException, EASBizException {
        FullOrgUnitInfo unitInfo;
        if (tmp != null && tmp.getUserObject() != null && (unitInfo = (FullOrgUnitInfo)tmp.getUserObject()).get("alreadyLoad") == null) {
            OrgUnitCollection childNodes = this.getOrgVersionFacade().getDirectVersionOrgUnits(this.versionNumber, unitInfo.getId().toString());
            this.insertNodeIntoRoot(tmp, childNodes);
            unitInfo.put("alreadyLoad", true);
        }
    }

    private void insertNodeIntoRoot(DefaultKingdeeTreeNode root, OrgUnitCollection childNodes) {
        if (childNodes == null) {
            return;
        }
        for (int i = 0; i < childNodes.size(); ++i) {
            FullOrgUnitInfo info = (FullOrgUnitInfo)childNodes.get(i);
            KDTreeNode treeNode = new KDTreeNode((Object)info);
            treeNode.setCustomIcon(EASResource.getIcon((String)"imgTree_company"));
            root.add((MutableTreeNode)treeNode);
        }
    }

    private void initCbxMain() throws Exception {
        this.cbxMain.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    OUFullVersionListUI.this.versionNumber = (String)OUFullVersionListUI.this.versionNumList.get(OUFullVersionListUI.this.cbxMain.getSelectedIndex());
                    try {
                        OUFullVersionListUI.this.initTree();
                    }
                    catch (Exception e1) {
                        OUFullVersionListUI.this.handleException(e1);
                    }
                }
            }
        });
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        this.versionNumList = this.getOrgVersionFacade().getAllHistoryVersionNumbers();
        this.invalidDateList = this.getOrgVersionFacade().getAllHistoryInvalidDates();
        if (this.versionNumList.size() != this.invalidDateList.size()) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.basedata.org.OrgException", (String)"ORGVERSIONERR"));
            SysUtil.abort();
        }
        for (int i = 0; i < this.versionNumList.size(); ++i) {
            String dateString = OrgVersionClientUtils.getDisplayInvalidDate((Date)this.invalidDateList.get(i));
            model.addElement(dateString + "(" + this.versionNumList.get(i).toString() + ")");
        }
        this.cbxMain.setModel(model);
        if (model.getSize() > 0) {
            this.versionNumber = (String)this.versionNumList.get(0);
            this.cbxMain.setSelectedIndex(0);
        }
    }

    private IOrgVersionMgrFacade getOrgVersionFacade() throws BOSException {
        return OrgVersionMgrFacadeFactory.getRemoteInstance();
    }

    protected void initTree() throws Exception {
        if (this.versionNumber == null) {
            this.treeMain.setModel(null);
            return;
        }
        VersionPK versionPK = new VersionPK(this.versionNumber, BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4"));
        OrgUnitInfo fullVersionInfo = this.getOrgVersionFacade().getUnitVersionInfoByOrgType(versionPK, OrgType.NONE);
        KDTreeNode root = new KDTreeNode((Object)fullVersionInfo);
        root.setCustomIcon(EASResource.getIcon((String)"imgTree_company"));
        if (fullVersionInfo != null) {
            OrgUnitCollection childNodes = this.getOrgVersionFacade().getDirectVersionOrgUnits(this.versionNumber, fullVersionInfo.getId().toString());
            this.insertNodeIntoRoot((DefaultKingdeeTreeNode)root, childNodes);
            fullVersionInfo.put("alreadyLoad", true);
        }
        this.treeMain.setModel((TreeModel)new DefaultTreeModel((TreeNode)root){

            @Override
            public boolean isLeaf(Object node) {
                FullOrgUnitInfo info = (FullOrgUnitInfo)((KDTreeNode)node).getUserObject();
                return info == null || info.isIsLeaf();
            }
        });
        this.treeMain.setRootVisible(true);
        this.treeMain.setShowsRootHandles(true);
        this.treeMain.setSelectionNode((DefaultKingdeeTreeNode)root);
    }

    private void initTblMain() {
        this.tblMain.getViewManager().setFreezeView(0, 3);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getColumn(0).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(1).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(2).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(3).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(4).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(5).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(6).getStyleAttributes().setLocked(true);
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.doView();
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1) {
            if (e.getClickCount() == 2) {
                this.doView();
            }
        } else {
            super.tblMain_tableClicked(e);
        }
    }

    private void doView() {
        try {
            this.setCursor(3);
            Map context = this.getUIContext();
            context.put("Owner", this);
            String id = this.getSelectedKeyValue();
            OrgVersionClentHelper.doView(context, id, this.versionNumber, this.fullVersionCol);
        }
        catch (Exception ex1) {
            this.handleException(ex1);
        }
        finally {
            this.setCursor(0);
        }
    }

    private void setCursor(int curType) {
        Cursor cursor = Cursor.getPredefinedCursor(curType);
        SwingUtilities.getWindowAncestor((Component)((Object)this)).setCursor(cursor);
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
    }

    @Override
    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        int rows;
        if (this.versionNumber == null) {
            return;
        }
        if (this.getSelectedTreeNode() != null && this.getSelectedTreeNode().getUserObject() != null) {
            OrgUnitInfo selectInfo = (OrgUnitInfo)this.getSelectedTreeNode().getUserObject();
            if (this.fullVersionCol == null) {
                this.fullVersionCol = new OrgUnitCollection();
            }
            this.fullVersionCol.clear();
            this.fullVersionCol.add(selectInfo);
            OrgUnitCollection orgUnitCol = this.getOrgVersionFacade().getDirectVersionOrgUnits(this.versionNumber, selectInfo.getId().toString());
            this.fullVersionCol.addCollection(orgUnitCol);
        }
        this.tblMain.checkParsed();
        OrgTableHelper.addTalbeOrgCol(this.tblMain);
        this.tblMain.removeRows();
        if (this.fullVersionCol != null) {
            OrgUnitInfo fullversionInfo = null;
            IRow row = null;
            for (int i = 0; i < this.fullVersionCol.size(); ++i) {
                fullversionInfo = this.fullVersionCol.get(i);
                row = this.tblMain.addRow();
                row.getCell("id").setValue((Object)fullversionInfo.getId());
                row.getCell("number").setValue((Object)fullversionInfo.getNumber());
                row.getCell("name").setValue((Object)fullversionInfo.getName());
                row.getCell("code").setValue((Object)fullversionInfo.getCode());
                row.getCell("simpleName").setValue((Object)fullversionInfo.getSimpleName());
                row.getCell("description").setValue((Object)fullversionInfo.getDescription());
                row.getCell("isOUSealUp").setValue((Object)new Boolean(fullversionInfo.isIsOUSealUp()));
                OrgTableHelper.setTableRowValue(fullversionInfo, row);
            }
        }
        if ((rows = this.tblMain.getRowCount()) != 0) {
            this.tblMain.getSelectManager().select(0, 0);
        }
    }

    public KDTreeNode getSelectedTreeNode() {
        return (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
    }

    protected String getSelectedKeyValue() {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length > 0) {
            Object keyValue;
            int rowIndex = selectRows[0];
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell(this.getKeyFieldName());
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if ((keyValue = cell.getValue()) != null) {
                return keyValue.toString();
            }
        } else {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
        }
        return null;
    }

    protected String getKeyFieldName() {
        return "id";
    }
}

