/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.client.servicebinding.ActionProxyFactory;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.framework.cache.config.CacheConfigManager;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.MutiOrgPermParam;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.PermissionUtils;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.util.ILongTimeTask2;
import com.kingdee.eas.base.permission.client.util.LongTimeDialog2;
import com.kingdee.eas.base.permission.client.util.UITools;
import com.kingdee.eas.base.permission.client.util.UITools2;
import com.kingdee.eas.base.permission.util.LowTimeHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.AdminOrgRangeFilterUtil;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.INewOUInnerFacade;
import com.kingdee.eas.basedata.org.INewOrgF7Facade;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.NewOUInnerFacadeFactory;
import com.kingdee.eas.basedata.org.NewOrgF7FacadeFactory;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.basedata.org.OUPartAdminFactory;
import com.kingdee.eas.basedata.org.OUPartAdminInfo;
import com.kingdee.eas.basedata.org.OrgAssistInfo;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.basedata.org.OrgMoveParam;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.AbstractOUListUI;
import com.kingdee.eas.basedata.org.client.AfterOrgMoveUI;
import com.kingdee.eas.basedata.org.client.BizTypeOrgMoveUI;
import com.kingdee.eas.basedata.org.client.OUEditUI;
import com.kingdee.eas.basedata.org.client.OrgF7PromptDialog;
import com.kingdee.eas.basedata.org.client.OrgHideCheckDataFunctionUI;
import com.kingdee.eas.basedata.org.client.OrgHideFunctionUI;
import com.kingdee.eas.basedata.org.client.OrgSpecialTablesClientUtil;
import com.kingdee.eas.basedata.org.client.OrgUnitRelationAddUI;
import com.kingdee.eas.basedata.org.client.OrgUnitRelationDeleteUI;
import com.kingdee.eas.basedata.org.client.di.OrgDIUtil;
import com.kingdee.eas.basedata.org.client.f7.NewCtrlF7;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.basedata.org.client.f7.OuF7;
import com.kingdee.eas.basedata.org.client.helper.OrgMoveClientHelper;
import com.kingdee.eas.basedata.org.client.helper.OrgUIDataUtil;
import com.kingdee.eas.basedata.org.client.tree.util.OrgTreeHelper;
import com.kingdee.eas.basedata.org.client.uihelper.OrgTypeClientCenter;
import com.kingdee.eas.basedata.org.helper.BizOrgQueryParam;
import com.kingdee.eas.basedata.org.helper.OrgTableHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.basedata.org.util.OrgToolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.framework.query.QuickFilteringSupportManager;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class OUListUI
extends AbstractOUListUI {
    Logger logger = Logger.getLogger((String)OUListUI.class.getName());
    String strResource = "com.kingdee.eas.basedata.org.client.OUResource";
    private boolean isShowVirtual = false;
    private boolean isShowSealedUnit = false;
    private static final Color normalColor = new Color(0xF9F9F9);
    private static final Color sealedupColor = new Color(0xD9D9D2);
    private OrgUIDataUtil orgDataHelper = null;
    private Map menuCacheMap = new HashMap();
    private static final String ORG_TYPE_STR = "orgTypeStr";
    private static final int OU_OPERATE_ADD = 1;
    private static final int OU_OPERATE_EDIT = 2;
    private static final int OU_OPERATE_DEL = 3;
    private static final int OU_OPERATE_SHOW_VIRTUAL = 4;
    private static final int OU_OPERATE_SHOW_SEALUP = 5;
    private static final int OU_OPERATE_SEALUP = 6;
    private static final int OU_OPERATE_UNSEALUP = 7;
    private static final int OU_OPERATE_UPGRADE = 8;
    private static final int OU_OPERATE_SHIFT = 9;
    private CtrlUnitInfo currentCtrlUnit = SysContext.getSysContext().getCurrentCtrlUnit();
    private UserInfo currentUserInfo = SysContext.getSysContext().getCurrentUserInfo();
    private boolean isF7Change = false;
    private static final String SPLITER = "!";
    QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    public OUListUI() throws Exception {
        this.init();
        OrgSpecialTablesClientUtil.setTheKDWorkButtonUsedToRebuildSpecialTables(this.btnSync);
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            CtrlUnitInfo cu = this.currentCtrlUnit;
            String cuID = cu.getId().toString();
            request.put("CURRENTCUID", (Object)cuID);
            request.put("isShowVirtual", (Object)new Boolean(this.isShowVirtual));
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    @Override
    public boolean isPrepareInit() {
        return false;
    }

    public OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    protected void execQuery() {
        if (this.orgDataHelper == null) {
            this.orgDataHelper = new OrgUIDataUtil();
        }
        this.orgDataHelper.initOrgInfoCacheMap();
        super.execQuery();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.isSupportSyncFromAdmin()) {
            this.batchSyncFromAdminTree.setEnabled(true);
            this.batchSyncFromAdminTree.setVisible(true);
        } else {
            this.batchSyncFromAdminTree.setEnabled(false);
            this.batchSyncFromAdminTree.setVisible(false);
        }
        this.initTblMain();
        this.getInputMap(1).put(KeyStroke.getKeyStroke("F9"), "OrgHideFunction");
        this.getActionMap().put("OrgHideFunction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(OrgHideFunctionUI.class.getName(), OUListUI.this.getUIContext(), null, OprtState.EDIT);
                    uiWindow.show();
                }
                catch (UIException e1) {
                    OUListUI.this.handleException((Exception)((Object)e1));
                }
            }
        });
        this.getInputMap(1).put(KeyStroke.getKeyStroke("F10"), "OrgHideCheckDataFunction");
        this.getActionMap().put("OrgHideCheckDataFunction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(OrgHideCheckDataFunctionUI.class.getName(), OUListUI.this.getUIContext(), null, OprtState.EDIT);
                    uiWindow.show();
                }
                catch (UIException e1) {
                    OUListUI.this.handleException((Exception)((Object)e1));
                }
            }
        });
        if (Administrator.isCUAdmin(null, (IObjectPK)new ObjectUuidPK(this.currentUserInfo.getId()))) {
            this.btnUpgradeCU.setVisible(true);
            this.btnUpgradeCU.setEnabled(true);
        } else {
            this.btnUpgradeCU.setVisible(false);
            this.btnUpgradeCU.setEnabled(false);
        }
        this.btnRemove.setVisible(false);
        this.menuItemRemove.setVisible(false);
        NewCtrlF7 ctrlF7 = new NewCtrlF7();
        ctrlF7.setIsCUFilter(false);
        ctrlF7.setNeedAddOrgRange(true);
        ctrlF7.setContainSealUp(true);
        ctrlF7.setCumulate(false);
        ctrlF7.setPermissionItem("OU_View");
        this.f7CU.setSelector((KDPromptSelector)ctrlF7);
        NewOrgUnitFilterInfoProducer producer = new NewOrgUnitFilterInfoProducer(ctrlF7);
        this.f7CU.setFilterInfoProducer((IFilterInfoProducer)producer);
        this.isF7Change = true;
        this.f7CU.setValue((Object)this.currentCtrlUnit);
        this.addViewOrgIsLeafOrNotShortCut();
        this.addTreeListener();
        this.addFunction();
    }

    private void addFunction() {
        this.getInputMap(1).put(KeyStroke.getKeyStroke(66, 3), "biz");
        this.getActionMap().put("biz", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    boolean isCUAdmin = Administrator.isCUAdmin(null, (IObjectPK)ToolUtils.getCurrentUserPK());
                    Object f7 = new OuF7();
                    if (AdminOrgRangeFilterUtil.isFilterByUserAdminOrgRange(null)) {
                        Set orgSet = new HashSet();
                        try {
                            orgSet = AdminOrgRangeFilterUtil.getCurrentUserAdminOrgRange(null);
                        }
                        catch (Exception ex) {
                            OUListUI.this.logger.error((Object)"get admin orgrange error", (Throwable)ex);
                        }
                        HashMap map = new HashMap();
                        for (Object obj : orgSet) {
                            map.put(obj, Boolean.FALSE);
                        }
                        f7 = OrgTypeClientCenter.getInstance().getClientImp(OrgType.Admin).createF7ByCondition("");
                        OrgF7PromptDialog orgF7 = (OrgF7PromptDialog)f7;
                        if (!isCUAdmin) {
                            orgF7.setIsCUFilter(true);
                        }
                        orgF7.disablePerm(map, true);
                    } else if (isCUAdmin) {
                        f7.setShowSub(true);
                        f7.setMultiCUs(true);
                        f7.setCuIdList(PermissionUtils.getAllCU(null));
                    }
                    f7.show();
                }
                catch (Exception e1) {
                    OUListUI.this.logger.error((Object)e1);
                }
            }
        });
    }

    private void addTreeListener() {
        this.treeMain.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                DefaultKingdeeTreeNode tmp = (DefaultKingdeeTreeNode)event.getPath().getLastPathComponent();
                if (tmp == null) {
                    return;
                }
                try {
                    OUListUI.this.loadNode(tmp);
                }
                catch (Exception e) {
                    OUListUI.this.logger.error((Object)"error", (Throwable)e);
                }
            }
        });
    }

    private void loadNode(DefaultKingdeeTreeNode tmp) throws BOSException, EASBizException {
        FullOrgUnitInfo unitInfo;
        if (tmp != null && tmp.getUserObject() != null && (unitInfo = (FullOrgUnitInfo)tmp.getUserObject()).get("alreadyLoad") == null) {
            OrgAssistInfo assistInfo = this.buildNewOrgF7AssistInfo(this.currentCtrlUnit.getId().toString());
            INewOrgF7Facade facade = NewOrgF7FacadeFactory.getRemoteInstance();
            List orgCol = facade.getDirectChildren(assistInfo, (CoreBaseInfo)unitInfo);
            if (null == orgCol || orgCol.size() == 0) {
                tmp.setCustomIcon(UIManager.getIcon("Tree.leafIcon"));
            }
            this.insertNodeIntoRoot(tmp, orgCol);
            unitInfo.put("alreadyLoad", true);
        }
    }

    private void expandTreeToUnit(FullOrgUnitInfo targetUnit) throws EASBizException, BOSException {
        targetUnit = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(targetUnit.getId()));
        String longNumber = targetUnit.getLongNumber();
        List<String> superLongNumbers = this.getSuperLongNumbers(longNumber);
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot();
        ((FullOrgUnitInfo)node.getUserObject()).put("alreadyLoad", null);
        node.removeAllChildren();
        this.loadNode(node);
        int size = superLongNumbers.size();
        for (int i = 1; i < size; ++i) {
            DefaultKingdeeTreeNode tempNode = this.getChildByLongNumber(node, superLongNumbers.get(i));
            if (tempNode == null) continue;
            node = tempNode;
            FullOrgUnitInfo childOrg = (FullOrgUnitInfo)node.getUserObject();
            if (childOrg.getId().equals((Object)targetUnit.getParent().getId())) {
                childOrg.put("alreadyLoad", null);
            }
            if (Boolean.TRUE.equals(childOrg.get("alreadyLoad"))) continue;
            node.removeAllChildren();
            this.loadNode(node);
        }
        this.treeMain.setSelectionNode(node);
        this.treeMain.updateUI();
    }

    private DefaultKingdeeTreeNode getChildByLongNumber(DefaultKingdeeTreeNode parent, String longNumber) {
        int childCount = parent.getChildCount();
        for (int j = 0; j < childCount; ++j) {
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)parent.getChildAt(j);
            FullOrgUnitInfo childInfo = (FullOrgUnitInfo)child.getUserObject();
            if (!longNumber.equals(childInfo.getLongNumber())) continue;
            return child;
        }
        return null;
    }

    private List<String> getSuperLongNumbers(String longNumber) {
        String[] splits = longNumber.split(SPLITER);
        StringBuilder superLongNumber = new StringBuilder();
        ArrayList<String> ret = new ArrayList<String>();
        int length = splits.length;
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                superLongNumber.append(SPLITER);
            }
            superLongNumber.append(splits[i]);
            ret.add(superLongNumber.toString());
        }
        return ret;
    }

    private void init() {
        this.btnOUSealUp.setIcon(EASResource.getIcon((String)"imgTbtn_sealup"));
        this.btnOUUnSealUp.setIcon(EASResource.getIcon((String)"imgTbtn_unsealup"));
        this.btnOUShift.setIcon(EASResource.getIcon((String)"imgTbtn_move"));
        this.menuItemOUSealUp.setIcon(EASResource.getIcon((String)"imgTbtn_sealup"));
        this.menuItemOUUnSealUp.setIcon(EASResource.getIcon((String)"imgTbtn_unsealup"));
        this.menuItemOUShift.setIcon(EASResource.getIcon((String)"imgTbtn_move"));
        this.btnShowSealedUnit.setIcon(EASResource.getIcon((String)"imgTbtn_dummygroup"));
        KDMenuItem updateOrgRelationMenuItem = new KDMenuItem(EASResource.getString((String)this.strResource, (String)"BATCH_UPDATE_ORGRELATION"));
        updateOrgRelationMenuItem.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionUpdateOrgRelation), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        updateOrgRelationMenuItem.setText(EASResource.getString((String)this.strResource, (String)"BATCH_UPDATE_ORGRELATION"));
        updateOrgRelationMenuItem.setIcon(EASResource.getIcon((String)"imgTbtn_allotmultipopedom"));
        this.btnMaintainOrgRelation.addAssistMenuItem((JMenuItem)updateOrgRelationMenuItem);
        KDMenuItem deleteOrgRelationMenuItem = new KDMenuItem(EASResource.getString((String)this.strResource, (String)"BATCH_DELETE_ORGRELATION"));
        deleteOrgRelationMenuItem.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionDeleteOrgRelation), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        deleteOrgRelationMenuItem.setText(EASResource.getString((String)this.strResource, (String)"BATCH_DELETE_ORGRELATION"));
        deleteOrgRelationMenuItem.setIcon(EASResource.getIcon((String)"imgTbtn_deletemultipopedom"));
        this.btnMaintainOrgRelation.addAssistMenuItem((JMenuItem)deleteOrgRelationMenuItem);
        this.setBtnShowVirtualStatus();
        this.setBtnShowSealedUnitStatus();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                OrgTableHelper.addTalbeOrgCol(OUListUI.this.tblMain);
                int begin = e.getFirstRow();
                int end = e.getLastRow();
                if (OUListUI.this.orgDataHelper == null) {
                    OUListUI.this.orgDataHelper = new OrgUIDataUtil();
                }
                for (int i = begin; i <= end; ++i) {
                    String orgId = (String)OUListUI.this.tblMain.getRow(i).getCell("id").getValue();
                    String orgTypeStr = (String)OUListUI.this.tblMain.getRow(i).getCell(OUListUI.ORG_TYPE_STR).getValue();
                    IRow row = OUListUI.this.tblMain.getRow(i);
                    try {
                        if (OUListUI.this.isTheOUSealedUp(i)) {
                            row.getStyleAttributes().setBackground(sealedupColor);
                        } else {
                            row.getStyleAttributes().setBackground(normalColor);
                        }
                        OrgTableHelper.setTableRowValue(OUListUI.this.orgDataHelper, orgTypeStr, row, "id", sealedupColor);
                        if (OUListUI.this.isShowVirtual) continue;
                        BizOrgQueryParam bizVirutalOrgParam = new BizOrgQueryParam();
                        bizVirutalOrgParam.setIsVirtual("TRUE");
                        if (!OUListUI.this.orgDataHelper.isEntityOrg(orgId, OrgType.Admin, bizVirutalOrgParam)) continue;
                        OUListUI.this.logger.info((Object)(" org is virutal ,hidden. orgId is:" + orgId));
                        OUListUI.this.tblMain.getRow(i).getStyleAttributes().setHided(true);
                        continue;
                    }
                    catch (EASBizException e1) {
                        OUListUI.this.logger.error((Object)"error", (Throwable)e1);
                        continue;
                    }
                    catch (BOSException e1) {
                        OUListUI.this.logger.error((Object)"error", (Throwable)e1);
                    }
                }
            }
        });
        this.initMenuOrgTypeImport();
    }

    private void initMenuOrgTypeImport() {
        Collection orgTypeCol = OrgTypeInfoMgr.getInstance().getAllOrgTypeInfo();
        for (OrgTypeInfo orgTypeInfo : orgTypeCol) {
            OrgType curOrgType = orgTypeInfo.getOrgType();
            if (OrgType.ControlUnit == curOrgType || !orgTypeInfo.isBasicOrgType() || OrgType.NONE == orgTypeInfo.getOrgType()) continue;
            KDMenuItem curItem = this.createMenuByOrgType(curOrgType);
            this.menuImport.add((JMenuItem)curItem);
        }
        if (this.menuCacheMap.containsKey("FIAccountRange")) {
            this.menuImport.add((JMenuItem)((KDMenuItem)this.menuCacheMap.get("FIAccountRange")));
        } else {
            KDMenuItem retMenu = new KDMenuItem();
            retMenu.setName("FIAccountRange");
            retMenu.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionImportOrg), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
            retMenu.setText(EASResource.getString((String)this.strResource, (String)"FIAccountRange"));
            retMenu.setEnabled(true);
            this.actionImportOrg.setEnabled(true);
            this.menuCacheMap.put("FIAccountRange", retMenu);
            this.menuImport.add((JMenuItem)retMenu);
        }
    }

    private KDMenuItem createMenuByOrgType(OrgType orgType) {
        if (this.menuCacheMap.containsKey((Object)orgType)) {
            return (KDMenuItem)this.menuCacheMap.get((Object)orgType);
        }
        KDMenuItem retMenu = new KDMenuItem();
        retMenu.setName(orgType.getName());
        retMenu.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionImportOrg), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        retMenu.setText(orgType.getAlias());
        retMenu.putClientProperty((Object)OrgType.class.getName(), (Object)orgType);
        retMenu.setEnabled(true);
        this.actionImportOrg.setEnabled(true);
        this.menuCacheMap.put(orgType, retMenu);
        return retMenu;
    }

    private void initTblMain() {
        this.tblMain.getViewManager().setFreezeView(0, 3);
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return FullOrgUnitFactory.getRemoteInstance();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"tree", (Object)this.treeMain);
        uiContext.put((Object)"ReadOnly", (Object)new Boolean(!this.getActionFromActionEvent(e).equals(this.actionAddNew) && this.isTheSelectedOUSealedUp()));
        uiContext.put((Object)"OUListUI", (Object)Boolean.TRUE);
        uiContext.put((Object)"currentOrgUnit", this.getSelectedTreeNode().getUserObject());
        uiContext.put((Object)"CURRENTCUID", (Object)this.currentCtrlUnit);
    }

    private boolean isTheSelectedOUSealedUp() {
        KDTSelectBlock block = this.tblMain.getSelectManager().get();
        if (block != null) {
            int selectRow = this.tblMain.getSelectManager().getActiveRowIndex();
            this.logger.info((Object)(" in isTheSelectedOUSealedUp row is:" + selectRow));
            return this.isTheOUSealedUp(selectRow);
        }
        return false;
    }

    private boolean isTheOUSealedUp(int rowIndex) {
        if (this.tblMain.getCell(rowIndex, "isSealedUp") == null || this.tblMain.getCell(rowIndex, "isSealedUp").getValue() == null) {
            return false;
        }
        return (Boolean)this.tblMain.getCell(rowIndex, "isSealedUp").getValue();
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.menuItemRefreshView.setEnabled(true);
    }

    protected String getEditUIName() {
        return OUEditUI.class.getName();
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    private void setBtnShowVirtualStatus() {
        if (this.isShowVirtual) {
            this.btnShowVirtual.setText(EASResource.getString((String)this.strResource, (String)"NOT_SHOW_VIRTUAL"));
            this.btnShowVirtual.setToolTipText(EASResource.getString((String)this.strResource, (String)"NOT_SHOW_VIRTUAL"));
            this.btnShowVirtual.setIcon(EASResource.getIcon((String)"imgTbtn_offdummygroup"));
            this.menuItemShowVirtual.setText(EASResource.getString((String)this.strResource, (String)"NOT_SHOW_VIRTUAL"));
            this.menuItemShowVirtual.setToolTipText(EASResource.getString((String)this.strResource, (String)"NOT_SHOW_VIRTUAL"));
            this.menuItemShowVirtual.setIcon(EASResource.getIcon((String)"imgTbtn_offdummygroup"));
        } else {
            this.btnShowVirtual.setText(EASResource.getString((String)this.strResource, (String)"SHOW_VIRTUAL"));
            this.btnShowVirtual.setToolTipText(EASResource.getString((String)this.strResource, (String)"SHOW_VIRTUAL"));
            this.btnShowVirtual.setIcon(EASResource.getIcon((String)"imgTbtn_dummygroup"));
            this.menuItemShowVirtual.setText(EASResource.getString((String)this.strResource, (String)"SHOW_VIRTUAL"));
            this.menuItemShowVirtual.setToolTipText(EASResource.getString((String)this.strResource, (String)"SHOW_VIRTUAL"));
            this.menuItemShowVirtual.setIcon(EASResource.getIcon((String)"imgTbtn_dummygroup"));
        }
    }

    protected void initTree() throws Exception {
        ObjectUuidPK pk = new ObjectUuidPK(this.currentCtrlUnit.getId());
        FullOrgUnitInfo unitInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)pk);
        this.initTree(null, unitInfo, 0);
        this.tblMain.getSelectManager().select(0, 0);
    }

    private OrgAssistInfo buildNewOrgF7AssistInfo(String cuID) {
        OrgAssistInfo assistInfo = new OrgAssistInfo();
        if (!this.isShowSealedUnit) {
            assistInfo.setNeedAddSealUpFilter(true);
        }
        if (!this.isShowVirtual) {
            assistInfo.setNeedAddVirtualFilter(true);
        }
        if (AdminOrgRangeFilterUtil.isFilterByUserAdminOrgRange(null)) {
            assistInfo.setNeedAddOrgRange(true);
            assistInfo.setOrgRangeType(2);
        }
        StringBuffer extraFilters = new StringBuffer();
        extraFilters.append(" AND ").append("\"BASEUNIT\"").append(".FIsUnion = 0 ").append(" AND ").append("\"BASEUNIT\"").append(".FID <> '").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("'").append(" AND ").append("\"BASEUNIT\"").append(".FControlUnitID = '").append(cuID).append("'");
        try {
            String dataRuleWhere;
            IPermission iPermission = PermissionFactory.getRemoteInstance();
            ObjectUuidPK userPK = new ObjectUuidPK(this.currentUserInfo.getId());
            ObjectStringPK orgPK = new ObjectStringPK(cuID);
            String dataRuleSql = iPermission.getQueryPermissionSQL((IObjectPK)userPK, (IObjectPK)orgPK, "OU_View");
            if (!StringUtils.isEmpty((String)dataRuleSql) && dataRuleSql.indexOf("WHERE") > 0 && !StringUtils.isEmpty((String)(dataRuleWhere = dataRuleSql.substring(dataRuleSql.indexOf("WHERE") + "WHERE".length()).replace("\"T0\".", "\"BASEUNIT\".")))) {
                extraFilters.append(" AND ").append(dataRuleWhere);
            }
        }
        catch (BOSException e) {
            this.logger.error((Object)e);
        }
        catch (EASBizException e) {
            this.logger.error((Object)e);
        }
        assistInfo.setExtraFilters(extraFilters.toString());
        assistInfo.setInnerJoinStyle(false);
        ArrayList<String> decorators = new ArrayList<String>();
        decorators.add(null);
        decorators.add("com.kingdee.eas.basedata.org.app.helper.NormalFilter4F7Decorator");
        decorators.add("com.kingdee.eas.basedata.org.app.helper.OrgRangeFilter4F7Decorator");
        assistInfo.setConstructParam(decorators);
        return assistInfo;
    }

    private void insertNodeIntoRoot(DefaultKingdeeTreeNode root, List orgCol) {
        for (int i = 0; i < orgCol.size(); ++i) {
            FullOrgUnitInfo info = (FullOrgUnitInfo)orgCol.get(i);
            KDTreeNode treeNode = new KDTreeNode((Object)info);
            root.add((MutableTreeNode)treeNode);
        }
        if (orgCol.size() > 0) {
            ((FullOrgUnitInfo)root.getUserObject()).setIsLeaf(false);
            ((FullOrgUnitInfo)root.getUserObject()).put("alreadyLoad", true);
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        TreePath path = this.treeMain.getSelectionPath();
        if (path != null) {
            DefaultKingdeeTreeNode selectNode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
            if (selectNode != null && selectNode.getUserObject() != null) {
                FullOrgUnitInfo selectInfo = (FullOrgUnitInfo)selectNode.getUserObject();
                String cuID = this.currentCtrlUnit.getId().toString();
                filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)selectInfo.getLongNumber(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(selectInfo.getLongNumber() + "!%"), CompareType.LIKE));
                filter.getFilterItems().add(new FilterItemInfo("isAssistantOrg", (Object)new Integer(1), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("mainOrg.id", (Object)StringUtils.cnulls((Object)selectInfo.getId()), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)cuID, CompareType.EQUALS));
                filter.setMaskString("(#0 or #1 or #2 and #3) and #4");
                if (AdminOrgRangeFilterUtil.isFilterByUserAdminOrgRange(null)) {
                    filter.getFilterItems().add(AdminOrgRangeFilterUtil.getFilterByAdminOrgRange(null));
                    filter.setMaskString("(#0 or #1 or #2 and #3) and #4 and #5");
                }
                if (!this.isShowSealedUnit) {
                    FilterInfo filter4 = new FilterInfo();
                    filter4.getFilterItems().add(new FilterItemInfo("isOUSealUp", (Object)new Integer(0), CompareType.EQUALS));
                    try {
                        filter.mergeFilter(filter4, "and");
                    }
                    catch (BOSException e) {
                        this.logger.error((Object)"mergeFilter filter4 error!", (Throwable)e);
                    }
                }
                if (!this.isShowVirtual) {
                    FilterInfo filter5 = new FilterInfo();
                    filter5.getFilterItems().add(new FilterItemInfo("isAdminOrgUnit", (Object)new Integer(1), CompareType.EQUALS));
                    filter5.getFilterItems().add(new FilterItemInfo("partAdmin.isVirtual", (Object)new Integer(0), CompareType.EQUALS));
                    filter5.getFilterItems().add(new FilterItemInfo("isAdminOrgUnit", (Object)new Integer(0), CompareType.EQUALS));
                    String mask = "#0 and #1 or #2";
                    filter5.setMaskString(mask);
                    try {
                        filter.mergeFilter(filter5, "and");
                    }
                    catch (BOSException e11) {
                        this.logger.error((Object)"mergeFilter filter5 error!", (Throwable)e11);
                    }
                }
            } else {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)"nodata", CompareType.EQUALS));
            }
        }
        return filter;
    }

    protected FilterInfo getExportFilterForQuery() throws EASBizException, BOSException {
        FilterInfo filter = AdminOrgRangeFilterUtil.getCurrentUserExportOrgFilter(null);
        if (AdminOrgRangeFilterUtil.isFilterByUserAdminOrgRange(null)) {
            FilterInfo filter3 = new FilterInfo();
            filter3.getFilterItems().add(AdminOrgRangeFilterUtil.getFilterByAdminOrgRange(null));
            try {
                filter.mergeFilter(filter3, "and");
            }
            catch (BOSException e) {
                this.logger.error((Object)"mergeFilter filter3 error!", (Throwable)e);
            }
        }
        if (!this.isShowSealedUnit) {
            FilterInfo filter4 = new FilterInfo();
            filter4.getFilterItems().add(new FilterItemInfo("isOUSealUp", (Object)new Integer(0), CompareType.EQUALS));
            try {
                filter.mergeFilter(filter4, "and");
            }
            catch (BOSException e) {
                this.logger.error((Object)"mergeFilter filter4 error!", (Throwable)e);
            }
        }
        if (!this.isShowVirtual) {
            FilterInfo filter5 = new FilterInfo();
            filter5.getFilterItems().add(new FilterItemInfo("isAdminOrgUnit", (Object)new Integer(1), CompareType.EQUALS));
            filter5.getFilterItems().add(new FilterItemInfo("partAdmin.isVirtual", (Object)new Integer(0), CompareType.EQUALS));
            filter5.getFilterItems().add(new FilterItemInfo("isAdminOrgUnit", (Object)new Integer(0), CompareType.EQUALS));
            String mask = "#0 and #1 or #2";
            filter5.setMaskString(mask);
            try {
                filter.mergeFilter(filter5, "and");
            }
            catch (BOSException e11) {
                this.logger.error((Object)"mergeFilter filter5 error!", (Throwable)e11);
            }
        }
        return filter;
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeMain_valueChanged(e);
    }

    public void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.setVisibleStatus();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    private void setVisibleStatus() {
        if (this.tblMain.getRowCount() == 0) {
            return;
        }
        this.btnOUSealUp.setVisible(!this.isTheSelectedOUSealedUp());
        this.btnOUUnSealUp.setVisible(!this.btnOUSealUp.isVisible());
        this.menuItemOUSealUp.setVisible(this.btnOUSealUp.isVisible());
        this.menuItemOUUnSealUp.setVisible(this.btnOUUnSealUp.isVisible());
        this.btnEdit.setVisible(this.btnOUSealUp.isVisible());
        this.menuItemEdit.setVisible(this.btnEdit.isVisible());
        this.btnEdit.setEnabled(this.btnEdit.isVisible());
        this.menuItemEdit.setEnabled(this.menuItemEdit.isVisible());
    }

    protected void refresh(ActionEvent e) throws Exception {
        if (this.orgDataHelper != null) {
            this.orgDataHelper.initOrgInfoCacheMap();
        }
    }

    @Override
    public void actionRefreshView_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefreshView_actionPerformed(e);
        INewOrgViewFacade iView = NewOrgViewFacadeFactory.getRemoteInstance();
        iView.rebuildAllView();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.initTree();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.checkOURemove();
            FullOrgUnitInfo info = (FullOrgUnitInfo)this.getSelectedTreeNode().getUserObject();
            ObjectUuidPK pk = new ObjectUuidPK(info.getId());
            FullOrgUnitInfo unitInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)pk);
            super.actionRemove_actionPerformed(e);
            if (unitInfo.getParent() != null) {
                ObjectUuidPK parentPK = new ObjectUuidPK(unitInfo.getParent().getId());
                FullOrgUnitInfo parentUnit = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)parentPK);
                unitInfo.setParent(parentUnit);
                this.orientationCurrentNode(3, unitInfo);
            }
        }
        catch (Exception e1) {
            throw new Exception(e1);
        }
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    private void checkOUUpdate() {
        if (AdminOrgRangeFilterUtil.isFilterByUserAdminOrgRange(null)) {
            String orgid = this.getSelectedKeyValue();
            if (AdminOrgRangeFilterUtil.isTopLevelNodeInRange((DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot(), orgid)) {
                MsgBox.showInfo((Component)((Object)this), (String)(EASResource.getString((String)this.strResource, (String)"CANNOT_UPDATE_OU") + EASResource.getString((String)this.strResource, (String)"CANNOT_Change_Reason")));
                SysUtil.abort();
            }
        }
    }

    private void checkOUMove(FullOrgUnitInfo oriOrg) {
        if (AdminOrgRangeFilterUtil.isFilterByUserAdminOrgRange(null)) {
            String orgid = this.getSelectedKeyValue();
            if (AdminOrgRangeFilterUtil.isTopLevelNodeInRange((DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot(), orgid)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.strResource, (String)"CANNOT_Move_OU"));
                SysUtil.abort();
            }
        }
        OrgMoveClientHelper.checkBeforeOrgMove(oriOrg);
    }

    private void checkOURemove() {
        if (AdminOrgRangeFilterUtil.isFilterByUserAdminOrgRange(null)) {
            String orgid = this.getSelectedKeyValue();
            if (AdminOrgRangeFilterUtil.isTopLevelNodeInRange((DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot(), orgid)) {
                MsgBox.showInfo((Component)((Object)this), (String)(EASResource.getString((String)this.strResource, (String)"CANNOT_REMOVE_OU") + EASResource.getString((String)this.strResource, (String)"CANNOT_Change_Reason")));
                SysUtil.abort();
            }
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        LowTimeHelper timeHelper = new LowTimeHelper();
        if (!this.checkFunPermission()) {
            timeHelper.printTime2Last("check perm over!");
            MsgBox.showError((String)EASResource.getString((String)this.strResource, (String)"NoPermissionToUpdate"));
            return;
        }
        this.checkOUUpdate();
        timeHelper.printTime2Last("check checkOUUpdate over!");
        this.getUIContext().put("OPERATE", 2);
        FullOrgUnitInfo oldOrg = this.getCurParentId(this.getSelectedKeyValue());
        super.actionEdit_actionPerformed(e);
        timeHelper.printTime2Last("load org data  over!");
        timeHelper.printTime2Last("load org treeMain_valueChanged!");
        this.orientationCurrentNode(2);
        this.checkRefreshParent(oldOrg);
    }

    private FullOrgUnitInfo getCurParentId(String orgId) {
        try {
            FullOrgUnitInfo fullOrgUnitInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(orgId));
            return fullOrgUnitInfo;
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            return null;
        }
    }

    private void checkRefreshParent(FullOrgUnitInfo oldParentOrg) {
        try {
            FullOrgUnitInfo newOrg = this.getCurParentId(this.getSelectedKeyValue());
            if (oldParentOrg.getId().toString().equals(newOrg.getId().toString())) {
                this.expandTreeToUnit(newOrg);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
    }

    private boolean checkFunPermission() {
        String[] permItemNames = new String[]{"OU_Update", "OU_Com_Update", "OU_Admin_Update", "OU_Purchase_Update", "OU_Sale_Update", "OU_Storage_Update", "OU_Profit_Update", "OU_Cost_Update", "OU_HRO_Update", "OU_Transport_Update", "OU_Quality_Update"};
        boolean[] permission = this.checkFunctionPermission(permItemNames);
        String _perm = Arrays.toString(permission);
        return _perm.indexOf("true") > -1;
    }

    public RequestContext prepareActionEdit(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionEdit(itemAction);
        if (request != null) {
            BOSUuid userId = this.currentUserInfo.getId();
            BOSUuid orgId = this.currentCtrlUnit.getId();
            request.put("userId", (Object)userId);
            request.put("orgId", (Object)orgId);
        }
        return request;
    }

    public boolean isPrepareActionEdit() {
        return true;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    public boolean isPrepareActionView() {
        return true;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        FullOrgUnitInfo unitInfo;
        if (!this.checkFunPermission()) {
            MsgBox.showError((String)EASResource.getString((String)this.strResource, (String)"NoPermissionToUpdate"));
            return;
        }
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (treeNode == null) {
            throw new OUException(OUException.MUST_SELECT_NODE);
        }
        if (OrgF7InnerUtils.isTreeNodeDisable(treeNode)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.strResource, (String)"Notinclude_NODE"));
            SysUtil.abort();
        }
        if ((unitInfo = (FullOrgUnitInfo)this.getSelectedTreeNode().getUserObject()).isIsOUSealUp()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.strResource, (String)"CANOT_ADD_SUB"));
            SysUtil.abort();
        }
        this.getUIContext().put("OPERATE", 1);
        super.actionAddNew_actionPerformed(e);
        this.orientationCurrentNode(1);
    }

    public RequestContext prepareActionAddNew(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionAddNew(itemAction);
        if (request != null) {
            BOSUuid userId = this.currentUserInfo.getId();
            BOSUuid orgId = this.currentCtrlUnit.getId();
            request.put("userId", (Object)userId);
            request.put("orgId", (Object)orgId);
            String cuID = userId.toString();
            request.put("CURRENTCUID", (Object)cuID);
            request.put("isShowVirtual", (Object)new Boolean(this.isShowVirtual));
        }
        return request;
    }

    public boolean isPrepareActionAddNew() {
        return true;
    }

    @Override
    public void actionShowVirtual_actionPerformed(ActionEvent e) throws Exception {
        super.actionShowVirtual_actionPerformed(e);
        this.isShowVirtual = !this.isShowVirtual;
        this.setFetch(true);
        this.orientationCurrentNode(4);
        this.setBtnShowVirtualStatus();
    }

    @Override
    public void actionOUSealUp_actionPerformed(ActionEvent e) throws Exception {
        super.actionOUSealUp_actionPerformed(e);
        this.checkSelected();
        String unitID = this.getSelectedKeyValue();
        INewOUInnerFacade iNOUI = NewOUInnerFacadeFactory.getRemoteInstance();
        iNOUI.ouSealUp(unitID);
        this.showOUSealUpSuccess();
        int selectRow = this.tblMain.getSelectManager().getActiveRowIndex();
        this.logger.info((Object)(" in actionOUSealUp_actionPerformed row is:" + selectRow));
        this.tblMain.getRow(selectRow).getStyleAttributes().setBackground(sealedupColor);
        this.tblMain.getRow(selectRow).getCell("isSealedUp").setValue((Object)new Boolean(true));
        this.btnOUSealUp.setVisible(false);
        this.btnOUUnSealUp.setVisible(true);
        this.menuItemOUSealUp.setVisible(false);
        this.menuItemOUUnSealUp.setVisible(true);
        this.btnEdit.setVisible(false);
        this.menuItemEdit.setVisible(false);
        this.btnEdit.setEnabled(false);
        this.menuItemEdit.setEnabled(false);
        this.orientationCurrentNode(6);
    }

    @Override
    public void actionOUUnSealUp_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        NewOUInnerFacadeFactory.getRemoteInstance().ouUnSealUp(this.getSelectedKeyValue());
        this.showOUUnSealUpSuccess();
        int selectRow = this.tblMain.getSelectManager().getActiveRowIndex();
        this.logger.info((Object)(" in actionOUUnSealUp_actionPerformed row is:" + selectRow));
        this.tblMain.getRow(selectRow).getStyleAttributes().setBackground(normalColor);
        this.tblMain.getRow(selectRow).getCell("isSealedUp").setValue((Object)new Boolean(false));
        this.btnOUSealUp.setVisible(true);
        this.btnOUUnSealUp.setVisible(false);
        this.menuItemOUSealUp.setVisible(true);
        this.menuItemOUUnSealUp.setVisible(false);
        this.btnEdit.setVisible(true);
        this.menuItemEdit.setVisible(true);
        this.btnEdit.setEnabled(true);
        this.menuItemEdit.setEnabled(true);
        this.orientationCurrentNode(7);
    }

    private void showOUSealUpSuccess() {
        String message = EASResource.getString((String)this.strResource, (String)"SEALUP_SUCCESS");
        this.setMessageText(message);
        this.showMessage();
        MsgBox.showInfo((Component)((Object)this), (String)message);
    }

    private void showOUUnSealUpSuccess() {
        String message = EASResource.getString((String)this.strResource, (String)"UNSEALUP_SUC");
        this.setMessageText(message);
        this.showMessage();
        MsgBox.showInfo((Component)((Object)this), (String)message);
    }

    @Override
    public void actionOUShift_actionPerformed(ActionEvent e) throws Exception {
        if (!MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)this.strResource, (String)"COMFIRM_OU_MOVE")))) {
            return;
        }
        this.checkSelected();
        ObjectStringPK selectedOrgPk = new ObjectStringPK(this.getSelectedKeyValue());
        SelectorItemCollection orgSelectors = new SelectorItemCollection();
        orgSelectors.add(new SelectorItemInfo("*"));
        orgSelectors.add(new SelectorItemInfo("parent.*"));
        FullOrgUnitInfo movedUnitInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)selectedOrgPk, orgSelectors);
        if (movedUnitInfo.isIsCU()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.strResource, (String)"CANNOT_Move_OU"));
            return;
        }
        this.checkOUMove(movedUnitInfo);
        FullOrgUnitInfo oldParentUnitInfo = movedUnitInfo.getParent();
        UIContext uiContext = new UIContext();
        uiContext.put((Object)"originOrg", (Object)movedUnitInfo);
        uiContext.put((Object)"Owner", (Object)this);
        IUIWindow bizTypeOrgMoveUI = UITools.showUI((Object)((Object)this), (String)BizTypeOrgMoveUI.class.getName(), (UIContext)uiContext);
        BizTypeOrgMoveUI moveUI = (BizTypeOrgMoveUI)bizTypeOrgMoveUI.getUIObject();
        OrgMoveParam param = moveUI.getData();
        if (param == null) {
            return;
        }
        if (CacheConfigManager.getConfig() != null) {
            CacheServiceFactory.getInstance().discardAll();
        }
        if (param.isChangeCu()) {
            String newParentId = param.getNewOUParentId();
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("*"));
            selectors.add(new SelectorItemInfo("CU.*"));
            FullOrgUnitInfo parentUnitInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(newParentId), selectors);
            this.f7CU.setData((Object)parentUnitInfo.getCU());
        }
        if (!param.isChangeCu() && !param.getNewOUParentId().equals(oldParentUnitInfo.getId().toString())) {
            this.removeFromOldParent(oldParentUnitInfo, movedUnitInfo);
        }
        if (movedUnitInfo.getParent() != null) {
            this.expandTreeToUnit(movedUnitInfo);
        }
    }

    private void removeFromOldParent(FullOrgUnitInfo oldParentUnitInfo, FullOrgUnitInfo movedOrgUnitInfo) {
        if (oldParentUnitInfo != null && oldParentUnitInfo.getId() != null) {
            DefaultKingdeeTreeNode oldParentNode = OrgTreeHelper.searchTreeNodeById((DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot(), oldParentUnitInfo.getId().toString());
            DefaultKingdeeTreeNode movedNode = OrgTreeHelper.searchTreeNodeById((DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot(), movedOrgUnitInfo.getId().toString());
            if (oldParentNode != null) {
                int index = oldParentNode.getIndex((TreeNode)movedNode);
                if (index >= 0) {
                    this.treeMain.removeNodeFromParent((MutableTreeNode)movedNode);
                    this.treeMain.updateUI();
                }
                if (oldParentNode.getChildCount() == 0 && oldParentNode.getUserObject() instanceof FullOrgUnitInfo) {
                    ((FullOrgUnitInfo)oldParentNode.getUserObject()).setIsLeaf(true);
                }
            }
        }
    }

    @Override
    public void actionUpdateOrgRelation_actionPerformed(ActionEvent e) throws Exception {
        Map context = this.getUIContext();
        IUIWindow uiWindow = null;
        IUIFactory uiFactory = null;
        try {
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            uiWindow = uiFactory.create(OrgUnitRelationAddUI.class.getName(), context);
            if (uiWindow instanceof Dialog) {
                ((Dialog)uiWindow).setTitle(EASResource.getString((String)this.strResource, (String)"BATCH_UPDATE_ORGRELATION"));
            } else if (uiWindow instanceof Frame) {
                ((Frame)uiWindow).setTitle(EASResource.getString((String)this.strResource, (String)"BATCH_UPDATE_ORGRELATION"));
            }
            uiWindow.show();
        }
        catch (UIException ex1) {
            this.handleException((Exception)((Object)ex1));
        }
    }

    @Override
    public void actionDeleteOrgRelation_actionPerformed(ActionEvent e) throws Exception {
        Map context = this.getUIContext();
        IUIWindow uiWindow = null;
        IUIFactory uiFactory = null;
        try {
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            uiWindow = uiFactory.create(OrgUnitRelationDeleteUI.class.getName(), context);
            if (uiWindow instanceof Dialog) {
                ((Dialog)uiWindow).setTitle(EASResource.getString((String)this.strResource, (String)"BATCH_DELETE_ORGRELATION"));
            } else if (uiWindow instanceof Frame) {
                ((Frame)uiWindow).setTitle(EASResource.getString((String)this.strResource, (String)"BATCH_DELETE_ORGRELATION"));
            }
            uiWindow.show();
        }
        catch (UIException ex1) {
            this.handleException((Exception)((Object)ex1));
        }
    }

    @Override
    public void actionImportOrg_actionPerformed(ActionEvent e) throws Exception {
        Object obj = e.getSource();
        if (!(obj instanceof KDMenuItem)) {
            this.logger.info((Object)(" source item is not right. obj is:" + obj));
            return;
        }
        KDMenuItem item = (KDMenuItem)obj;
        OrgType curOrgType = (OrgType)((Object)item.getClientProperty((Object)OrgType.class.getName()));
        if (curOrgType == null) {
            this.logger.info((Object)"curOrgType is not right ! curOrgType is null,set none orgType");
            curOrgType = OrgType.NONE;
        }
        IObjectPK pk = LogUtil.beginLog(null, (String)(OrgToolUtils.getResource("res_47") + item.getText()), (BOSObjectType)new FullOrgUnitInfo().getBOSType(), null, (String)(OrgToolUtils.getResource("res_47") + item.getText()));
        if ("FIAccountRange".equals(item.getName())) {
            OrgDIUtil.performImportForFIAccountRange(EASResource.getString((String)this.strResource, (String)"FIAccountRange"));
        } else {
            OrgDIUtil.performImportForOrgType(curOrgType);
            this.initTree();
        }
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    public boolean isPrepareActionImportOU() {
        return true;
    }

    @Override
    public void actionExportOU_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportOU_actionPerformed(e);
        IObjectPK pk = LogUtil.beginLog(null, (String)OrgToolUtils.getResource("res_48"), (BOSObjectType)new FullOrgUnitInfo().getBOSType(), null, (String)OrgToolUtils.getResource("res_48"));
        MetaDataPK mainQueryPK = MetaDataPK.create((String)"com.kingdee.eas.basedata.org.app", (String)"OUExportQuery");
        String paramValue = ParamManager.getParamValue(null, null, (String)"ExportAllOrgUnitInOrgRange");
        if ("true".equals(paramValue)) {
            FilterInfo exportFilter = this.getExportFilterForQuery();
            EntityViewInfo exportEntityView = new EntityViewInfo();
            exportEntityView.setFilter(exportFilter);
            OrgDIUtil.performExportForOrgType((Component)((Object)this), OrgType.NONE, (IMetaDataPK)mainQueryPK, exportEntityView);
        } else {
            OrgDIUtil.performExportForOrgType((Component)((Object)this), OrgType.NONE, (IMetaDataPK)mainQueryPK, this.mainQuery);
        }
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    @Override
    protected void btnShowSealedUnit_mouseClicked(MouseEvent e) throws Exception {
        this.isShowSealedUnit = !this.isShowSealedUnit;
        this.setBtnShowSealedUnitStatus();
        this.orientationCurrentNode(5);
    }

    private void setBtnShowSealedUnitStatus() {
        if (!this.isShowSealedUnit) {
            this.btnShowSealedUnit.setText(EASResource.getString((String)this.strResource, (String)"ShowSealedUnit"));
            this.btnShowSealedUnit.setToolTipText(EASResource.getString((String)this.strResource, (String)"ShowSealedUnit"));
            this.btnShowSealedUnit.setIcon(EASResource.getIcon((String)"imgTbtn_dummygroup"));
        } else {
            this.btnShowSealedUnit.setText(EASResource.getString((String)this.strResource, (String)"NotShowSealedUnit"));
            this.btnShowSealedUnit.setToolTipText(EASResource.getString((String)this.strResource, (String)"NotShowSealedUnit"));
            this.btnShowSealedUnit.setIcon(EASResource.getIcon((String)"imgTbtn_offdummygroup"));
        }
    }

    private boolean checkFunctionPermission(String permItemName) {
        IPermission permission = null;
        boolean flag = false;
        try {
            ObjectUuidPK userPk = new ObjectUuidPK("id", SysContext.getSysContext().getCurrentUserInfo().getId());
            ObjectUuidPK orgPk = new ObjectUuidPK("id", SysContext.getSysContext().getCurrentCtrlUnit().getId());
            permission = PermissionFactory.getRemoteInstance();
            if (permission != null) {
                flag = permission.hasFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, permItemName);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"get permission failed!maybe the permission is not update", (Throwable)e);
        }
        return flag;
    }

    private boolean[] checkFunctionPermission(String[] permItemNames) {
        IPermission permission = null;
        boolean[] flag = null;
        try {
            ObjectUuidPK userPk = new ObjectUuidPK("id", SysContext.getSysContext().getCurrentUserInfo().getId());
            ObjectUuidPK orgPk = new ObjectUuidPK("id", SysContext.getSysContext().getCurrentCtrlUnit().getId());
            permission = PermissionFactory.getRemoteInstance();
            if (permission != null) {
                flag = permission.hasFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, permItemNames);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"get permission failed!maybe the permission is not update", (Throwable)e);
        }
        return flag;
    }

    protected boolean isSupportDynQuery() {
        return false;
    }

    protected EntityViewInfo getInitDefaultSolution() {
        return null;
    }

    protected boolean isIncludeAllChildren() {
        return true;
    }

    protected EntityViewInfo getDefaultEntityViewInfo() {
        return super.getDefaultEntityViewInfo();
    }

    private void addViewOrgIsLeafOrNotShortCut() {
        this.getInputMap(1).put(KeyStroke.getKeyStroke("ctrl shift I"), "ViewOrgIsLeafOrNotFunction");
        this.getActionMap().put("ViewOrgIsLeafOrNotFunction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.basedata.org.client.TestOrgIsLeafOrNotUI", OUListUI.this.getUIContext(), null, null);
                    uiWindow.show();
                }
                catch (Exception e1) {
                    OUListUI.this.logger.info((Object)"addViewOrgIsLeafOrNotShortCut", (Throwable)e1);
                }
            }
        });
    }

    protected void buildTreeFilter() {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (treeNode == null) {
            return;
        }
        if (this.mainQuery.getFilter() == null) {
            this.mainQuery.setFilter(new FilterInfo());
        }
        this.removeQueryFilterAndSorter(this.mainQuery);
        this.mainQuery.getFilter().remove("maskString");
        try {
            this.getEntityViewInfo(this.mainQuery);
            if (this.getDefaultEntityViewInfo() != null) {
                this.MergeCommonQuery(this.getDefaultEntityViewInfo());
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
            this.abort();
        }
    }

    @Override
    protected void f7CU_dataChanged(DataChangeEvent e) throws Exception {
        super.f7CU_dataChanged(e);
        if (this.f7CU.getData() != null && this.f7CU.getData() instanceof CtrlUnitInfo) {
            CtrlUnitInfo ctrlUnit;
            this.currentCtrlUnit = ctrlUnit = (CtrlUnitInfo)this.f7CU.getData();
        }
        if (!this.isF7Change) {
            this.initTree();
        }
        this.isF7Change = false;
    }

    @Override
    public void actionUpgradeCU_actionPerformed(ActionEvent e) throws Exception {
        if (!MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)this.strResource, (String)"Confirm_UpgradeCU")))) {
            return;
        }
        super.actionUpgradeCU_actionPerformed(e);
        this.checkSelected();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows != null && selectRows.length == 1) {
            if (this.getSelectIsCU()) {
                MsgBox.showInfo((String)EASResource.getString((String)this.strResource, (String)"ISCU_NO_UPGRADE"));
            } else {
                String unitID = this.getSelectedKeyValue();
                ObjectUuidPK pk = new ObjectUuidPK(unitID);
                FullOrgUnitInfo orgUnitInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)pk);
                if (orgUnitInfo.getParent() != null) {
                    ObjectUuidPK parentPK = new ObjectUuidPK(orgUnitInfo.getParent().getId());
                    FullOrgUnitInfo parentUnit = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)parentPK);
                    if (!parentUnit.isIsCU()) {
                        throw new OUException(OUException.CANT_UPDATE_CU, new Object[]{parentUnit.getName()});
                    }
                    orgUnitInfo.setParent(parentUnit);
                }
                IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
                iFullOrgUnit.upgradeCU(unitID);
                if (orgUnitInfo.getParent() != null) {
                    this.orientationCurrentNode(8, orgUnitInfo);
                }
                this.showUpgradeCUSuccess();
            }
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)this.strResource, (String)"SELECT_OU_UPGRADE"));
        }
    }

    private boolean getSelectIsCU() {
        String orgTypeStr;
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        boolean isCU = false;
        if (this.tblMain.getRow(rowIndex) != null && this.tblMain.getRow(rowIndex).getCell(ORG_TYPE_STR) != null && !StringUtils.isEmpty((String)(orgTypeStr = (String)this.tblMain.getRow(rowIndex).getCell(ORG_TYPE_STR).getValue())) && orgTypeStr.indexOf(OrgType.ControlUnit.getName()) > 0) {
            isCU = true;
        }
        return isCU;
    }

    private void showUpgradeCUSuccess() throws Exception {
        this.initTree();
        String message = EASResource.getString((String)this.strResource, (String)"UPGRADECU_SUCCESS");
        this.setMessageText(message);
        this.showMessage();
        MsgBox.showInfo((Component)((Object)this), (String)message);
    }

    public void orientationCurrentNode(int operate) throws Exception {
        this.orientationCurrentNode(operate, null);
    }

    public void orientationCurrentNode(int operate, FullOrgUnitInfo orgUnitInfo) throws Exception {
        int selectedRow = this.tblMain.getSelectManager().getActiveRowIndex();
        int selectedCol = this.tblMain.getSelectManager().getActiveColumnIndex();
        if (selectedRow < 0) {
            selectedRow = 0;
        }
        if (selectedCol < 0) {
            selectedCol = 0;
        }
        IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
        if (orgUnitInfo == null) {
            FullOrgUnitInfo info = (FullOrgUnitInfo)this.getSelectedTreeNode().getUserObject();
            String unitId = info.getId().toString();
            FullOrgUnitInfo unitInfo = iFullOrgUnit.getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(unitId));
            boolean isShowParentNode = this.isShowParentNode(unitInfo, operate);
            DefaultKingdeeTreeNode selectedNode = OrgTreeHelper.searchTreeNodeById((DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot(), unitId);
            if (selectedNode == null || selectedNode.isRoot()) {
                this.initTree(null, unitInfo, 0);
            } else if (!isShowParentNode) {
                this.initTree((KDTreeNode)selectedNode, unitInfo, operate);
                this.expandNode(selectedNode);
            } else {
                String parentId = unitInfo.getParent().getId().toString();
                FullOrgUnitInfo parentUnitInfo = iFullOrgUnit.getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(parentId));
                DefaultKingdeeTreeNode parentNode = OrgTreeHelper.searchTreeNodeById((DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot(), parentId);
                this.initTree((KDTreeNode)parentNode, parentUnitInfo, operate);
                this.expandNode(parentNode);
            }
            this.tblMain.refresh();
            this.tblMain.getSelectManager().select(isShowParentNode ? 0 : selectedRow, isShowParentNode ? 0 : selectedCol);
        } else {
            DefaultKingdeeTreeNode selectedNode = OrgTreeHelper.searchTreeNodeById((DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot(), orgUnitInfo.getId().toString());
            String unitId = "";
            FullOrgUnitInfo fullOrgInfo = orgUnitInfo;
            if (selectedNode.isRoot()) {
                unitId = orgUnitInfo.getId().toString();
            } else {
                unitId = orgUnitInfo.getParent().getId().toString();
                fullOrgInfo = orgUnitInfo.getParent();
            }
            DefaultKingdeeTreeNode parentNode = OrgTreeHelper.searchTreeNodeById((DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot(), unitId);
            this.initTree((KDTreeNode)parentNode, fullOrgInfo, operate);
            boolean isShowParentNode = this.isShowParentNode(fullOrgInfo, operate);
            this.expandNode(parentNode);
            this.tblMain.refresh();
            this.tblMain.getSelectManager().select(isShowParentNode ? 0 : selectedRow, isShowParentNode ? 0 : selectedCol);
        }
    }

    private boolean isOUIsVirtual(FullOrgUnitInfo unitInfo) throws EASBizException, BOSException {
        boolean isVirtual = false;
        if (unitInfo.isIsAdminOrgUnit() && unitInfo.getPartAdmin() != null && unitInfo.getPartAdmin().getId() != null) {
            ObjectUuidPK partAdminPK = new ObjectUuidPK(unitInfo.getPartAdmin().getId());
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("isVirtual"));
            OUPartAdminInfo partAdminInfo = OUPartAdminFactory.getRemoteInstance().getOUPartAdminInfo((IObjectPK)partAdminPK, sic);
            isVirtual = partAdminInfo.isIsVirtual();
        }
        return isVirtual;
    }

    private void expandNode(DefaultKingdeeTreeNode selectedNode) {
        if (selectedNode != null) {
            this.treeMain.expandPath(new TreePath(selectedNode.getPath()));
            this.treeMain.setSelectionNode(selectedNode);
        }
    }

    private boolean isShowParentNode(FullOrgUnitInfo unitInfo, int operate) throws EASBizException, BOSException {
        boolean isShowParentNode = false;
        if (operate == 1) {
            isShowParentNode = false;
        } else if (operate == 2) {
            isShowParentNode = false;
        } else if (operate == 3) {
            isShowParentNode = false;
        } else if (operate == 4) {
            boolean isVirtual = this.isOUIsVirtual(unitInfo);
            isShowParentNode = !this.isShowVirtual && isVirtual;
        } else if (operate == 5) {
            isShowParentNode = !this.isShowSealedUnit && unitInfo.isIsOUSealUp();
        } else if (operate == 6) {
            isShowParentNode = !this.isShowSealedUnit;
        } else if (operate == 7) {
            isShowParentNode = false;
        } else if (operate == 8) {
            isShowParentNode = false;
        } else if (operate == 9) {
            isShowParentNode = false;
        }
        return isShowParentNode;
    }

    private OrgAssistInfo getOrgAssistInfo(KDTreeNode selectedNode, FullOrgUnitInfo unitInfo, int operate) throws EASBizException, BOSException {
        OrgAssistInfo assistInfo = null;
        if (operate == 2) {
            selectedNode.setText(unitInfo.getName());
            ((FullOrgUnitInfo)selectedNode.getUserObject()).setLongNumber(unitInfo.getLongNumber());
        }
        assistInfo = this.buildNewOrgF7AssistInfo(unitInfo.getCU().getId().toString());
        if (selectedNode != null) {
            selectedNode.removeAllChildren();
        }
        return assistInfo;
    }

    protected void initTree(KDTreeNode selectedNode, FullOrgUnitInfo unitInfo, int operate) throws Exception {
        this.logger.info((Object)"OUListUI initTree begin.");
        long t1 = System.currentTimeMillis();
        this.initMainBizOrg();
        INewOrgF7Facade facade = NewOrgF7FacadeFactory.getRemoteInstance();
        KDTreeNode root = selectedNode != null ? (KDTreeNode)this.treeMain.getModel().getRoot() : new KDTreeNode((Object)unitInfo);
        OrgAssistInfo assistInfo = this.getOrgAssistInfo(selectedNode, unitInfo, operate);
        if (assistInfo == null) {
            return;
        }
        List orgCol = facade.getDirectChildren(assistInfo, (CoreBaseInfo)unitInfo);
        if (selectedNode == null) {
            this.insertNodeIntoRoot((DefaultKingdeeTreeNode)root, orgCol);
        } else {
            this.insertNodeIntoRoot((DefaultKingdeeTreeNode)selectedNode, orgCol);
        }
        ((FullOrgUnitInfo)root.getUserObject()).put("alreadyLoad", true);
        this.treeMain.setModel((TreeModel)new DefaultTreeModel((TreeNode)root){

            @Override
            public boolean isLeaf(Object node) {
                FullOrgUnitInfo info = (FullOrgUnitInfo)((KDTreeNode)node).getUserObject();
                return info == null || info.isIsLeaf();
            }
        });
        if (root.getUserObject() == null) {
            this.treeMain.setRootVisible(false);
        } else {
            this.treeMain.setRootVisible(true);
        }
        this.treeMain.setShowsRootHandles(true);
        this.treeMain.setSelectionNode((DefaultKingdeeTreeNode)root);
        this.treeMain.updateUI();
        this.logger.info((Object)("OUListUI initTree end. cost: " + (System.currentTimeMillis() - t1)));
    }

    private void initMainBizOrg() {
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(this.currentCtrlUnit.getId().toString());
        if (this.getMainOrgContext() != null) {
            MutiOrgPermParam mutiOrgParam = new MutiOrgPermParam();
            mutiOrgParam.setOrgType(OrgType.ControlUnit);
            mutiOrgParam.setOrgIdList(idList);
            this.getMainOrgContext().put((Object)"MUTI_ORG_INFO", (Object)mutiOrgParam);
        }
    }

    public ICoreBase getBizInterface() throws Exception {
        return FullOrgUnitFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected String[] getCountQueryFields() {
        return new String[]{"id"};
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        this.qfsi.setMustQueryAtFirst(true);
        return this.qfsi.supportExecutionWithoutFilters();
    }

    protected QuickFilteringSupportManager createQuickFilteringSupportManager() throws Exception {
        QuickFilteringSupportItems qfsi = this.getQuickFilteringSupport();
        if (qfsi != null && this.getBizType() != null) {
            qfsi.setBosType(this.getBizType().toString());
        }
        return new QuickFilteringSupportManager((ListUI)this, qfsi, (Component)this.kDPanel1);
    }

    @Override
    public void actionOrgMoveAfterTask_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, String> uiContext = new HashMap<String, String>();
        uiContext.put("selectedOrgId", this.getSelectedKeyValue());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(AfterOrgMoveUI.class.getName(), uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    @Override
    public void actionBatchSyncFromAdminTree_actionPerformed(ActionEvent e) throws Exception {
        int confirm = MsgBox.showConfirm2((Component)((Object)this), (String)"\u6279\u91cf\u4fee\u590d\u7ec4\u7ec7\u5355\u5143\u4e0a\u4e0b\u7ea7\u4e0e\u884c\u653f\u7ec4\u7ec7\u4e0a\u4e0b\u7ea7\u4fdd\u6301\u4e00\u81f4\uff0c\u7ec4\u7ec7\u5355\u5143\u5c06\u53d1\u751f\u79fb\u52a8\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u79fb\u52a8\uff1f");
        if (!MsgBox.isYes((int)confirm)) {
            return;
        }
        final LongTimeDialog2 dialog = UITools2.getDialog((Component)((Object)this), (String)"\u540c\u6b65\u7ec4\u7ec7\u5355\u5143\u67b6\u6784", (String)"\u540c\u6b65\u6210\u529f");
        final ActionEvent actionEvent = e;
        dialog.setLongTimeTask(new ILongTimeTask2(){

            public Object exec() throws Exception {
                try {
                    dialog.updateMsg("\u6b63\u5728\u6267\u884c\u7ec4\u7ec7\u5355\u5143\u67b6\u6784\u6279\u91cf\u8c03\u6574\uff0c\u53ef\u80fd\u9700\u8981\u51e0\u5206\u949f. . .");
                    FullOrgUnitFactory.getRemoteInstance().batchSyncFromAdminTree();
                    Thread.sleep(100L);
                    return true;
                }
                catch (Exception e) {
                    OUListUI.this.logger.error((Object)e);
                    return false;
                }
            }

            public void afterExec(Object result) throws Exception {
                boolean isSuccess = (Boolean)result;
                if (isSuccess) {
                    OUListUI.this.actionRefresh_actionPerformed(actionEvent);
                    dialog.updateMsg("\u7ec4\u7ec7\u5355\u5143\u67b6\u6784\u5df2\u6309\u884c\u653f\u7ec4\u7ec7\u67b6\u6784\u8c03\u6574\u5b8c\u6210\uff01");
                } else {
                    dialog.updateMsg("\u7ec4\u7ec7\u5355\u5143\u67b6\u6784\u4fee\u590d\u5931\u8d25\uff01");
                }
                dialog.setOkButton("\u786e\u5b9a", true);
            }

            public void actionOkClick() throws Exception {
            }
        });
        dialog.show();
    }

    private boolean isSupportSyncFromAdmin() {
        try {
            UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
            if (!Administrator.isSuperAdmin((IObjectPK)new ObjectStringPK(user.getId().toString()))) {
                return false;
            }
            String paravalue = ParamManager.getParamValue(null, null, (String)"OrgunitIsSameFromAdminTree");
            return "true".equals(paravalue);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            return false;
        }
    }
}

