/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.client.servicebinding.ActionProxyFactory;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IOrgRange;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeInfo;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.basedata.org.AbstractOrgStructureInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.INewOrgF7Facade;
import com.kingdee.eas.basedata.org.IOrgTree;
import com.kingdee.eas.basedata.org.NewOrgF7FacadeFactory;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgAssistInfo;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.AbstractOUViewListUI;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.client.OUEditUI;
import com.kingdee.eas.basedata.org.client.OrgF7PromptDialog;
import com.kingdee.eas.basedata.org.client.OrgSortSettingUI;
import com.kingdee.eas.basedata.org.client.helper.OrgUIDataUtil;
import com.kingdee.eas.basedata.org.client.uihelper.IOrgTypeClientHelper;
import com.kingdee.eas.basedata.org.client.uihelper.OrgTypeClientCenter;
import com.kingdee.eas.basedata.org.client.uihelper.OrgTypeClientDefaultImpl;
import com.kingdee.eas.basedata.org.helper.BizOrgQueryParam;
import com.kingdee.eas.basedata.org.helper.OrgHelper;
import com.kingdee.eas.basedata.org.helper.OrgTableHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.basedata.org.util.OrgToolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.framework.query.QuickFilteringSupportManager;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class OUViewListUI
extends AbstractOUViewListUI {
    private static final Logger logger = CoreUIObject.getLogger(OUViewListUI.class);
    private static final Color normalColor = new Color(0xF9F9F9);
    private static final Color sealedupColor = new Color(0xD9D9D2);
    private static final Color sealedupColor2 = new Color(0xEEE9E9);
    private String strRes = "com.kingdee.eas.basedata.org.client.OUResource";
    private HashMap mapSealUp = new HashMap();
    private Map allOUPartTableMap = new HashMap();
    private boolean isShowVirtual = false;
    private boolean isQueryBySortCode = false;
    private EntityViewInfo mainQueryForExport = null;
    private Map menuCacheMap = new HashMap();
    private boolean isDealTree = false;
    private int level = 2;
    private OrgUIDataUtil orgDataHelper = null;
    INewOrgF7Facade iNewOrgF7Facade = null;
    private boolean isNeedGetChild = true;
    private boolean isTreeValueChangedFirst = true;
    private boolean isRedirect = false;
    QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    public OUViewListUI() throws Exception {
        this.init();
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            request.setClassName("com.kingdee.eas.basedata.org.app.OUViewListUIHandler");
            OrgTreeInfo selectInfo = (OrgTreeInfo)this.cbxMain.getSelectedItem();
            if (selectInfo != null) {
                request.put("SELECTID", (Object)selectInfo.getId().toString());
                Boolean value = (Boolean)this.mapSealUp.get(selectInfo.getId().toString());
                boolean isContainSealUp = false;
                if (value != null) {
                    isContainSealUp = value;
                }
                request.put("isContainSealUp", (Object)new Boolean(isContainSealUp));
                request.put("isShowVirtual", (Object)new Boolean(this.isShowVirtual));
            }
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        if (this.orgDataHelper == null) {
            this.orgDataHelper = new OrgUIDataUtil();
        }
        this.orgDataHelper.initOrgInfoCacheMap();
        super.actionRefresh_actionPerformed(e);
    }

    public int getMaxReturnRowCount() {
        return Integer.MAX_VALUE;
    }

    private void init() {
        this.mapSealUp.put("00000000-0000-0000-0000-0000000000094F2827FD", new Boolean(false));
        Collection orgTypeCol = OrgTypeInfoMgr.getInstance().getAllOrgTypeInfo();
        for (OrgTypeInfo orgTypeInfo : orgTypeCol) {
            if (StringUtils.isEmpty((String)orgTypeInfo.getOrgTreeID())) continue;
            this.mapSealUp.put(orgTypeInfo.getOrgTreeID(), new Boolean(false));
        }
        this.btnShowVirtual.setVisible(false);
        this.menuItemShowVirtual.setVisible(false);
        this.btnContainSealUp.setText(EASResource.getString((String)this.strRes, (String)"SEALUP_CONTAIN"));
        this.btnContainSealUp.setToolTipText(EASResource.getString((String)this.strRes, (String)"SEALUP_CONTAIN"));
        this.btnContainSealUp.setEnabled(true);
        this.btnContainSealUp.setIcon(EASResource.getIcon((String)"imgTbtn_showsealup"));
        this.menuOrgView.setEnabled(true);
        this.menuItemSwitchSealUp.setEnabled(true);
        this.menuExport.setVisible(false);
        this.menuItemAddNew.setVisible(false);
        this.menuItemImportData.setVisible(false);
        this.kDSeparator1.setVisible(false);
        this.separatorFile1.setVisible(false);
        this.actionAddNew.setEnabled(false);
        this.actionEdit.setEnabled(false);
        this.actionRemove.setEnabled(false);
        this.btnOrgMove.setIcon(EASResource.getIcon((String)"imgTbtn_move"));
        this.menuItemOrgMove.setIcon(EASResource.getIcon((String)"imgTbtn_move"));
        this.btnOrgUnite.setIcon(EASResource.getIcon((String)"imgTbtn_unite"));
        this.btnOrgSplit.setIcon(EASResource.getIcon((String)"imgTbtn_split"));
        this.menuItemOrgUnite.setIcon(EASResource.getIcon((String)"imgTbtn_unite"));
        this.menuItemOrgSplit.setIcon(EASResource.getIcon((String)"imgTbtn_split"));
        this.btnBizMove.setIcon(EASResource.getIcon((String)"imgTbtn_move"));
        this.menuItemBizMove.setIcon(EASResource.getIcon((String)"imgTbtn_move"));
        this.initMenuOrgTypeExport();
    }

    private void initMenuOrgTypeExport() {
        this.menuExport.setVisible(true);
        Collection orgTypeCol = OrgTypeInfoMgr.getInstance().getAllOrgTypeInfo();
        for (OrgTypeInfo orgTypeInfo : orgTypeCol) {
            OrgType curOrgType = orgTypeInfo.getOrgType();
            if (OrgType.ControlUnit == curOrgType || !orgTypeInfo.isBasicOrgType() || OrgType.NONE == orgTypeInfo.getOrgType()) continue;
            KDMenuItem curItem = this.createMenuByOrgType(curOrgType);
            this.menuExport.add((JMenuItem)curItem);
        }
    }

    private KDMenuItem createMenuByOrgType(OrgType orgType) {
        if (this.menuCacheMap.containsKey((Object)orgType)) {
            return (KDMenuItem)this.menuCacheMap.get((Object)orgType);
        }
        KDMenuItem retMenu = new KDMenuItem();
        retMenu.setName(orgType.getName());
        retMenu.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionExportOrg), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        retMenu.setText(orgType.getAlias());
        retMenu.putClientProperty((Object)OrgType.class.getName(), (Object)orgType);
        retMenu.setEnabled(true);
        this.actionExportOrg.setEnabled(true);
        this.menuCacheMap.put(orgType, retMenu);
        return retMenu;
    }

    public void onLoad() throws Exception {
        this.initTblMain();
        this.initCbxMain();
        this.actionMoveTree.setVisible(false);
        super.onLoad();
        this.initLevel();
        this.addTreeListener();
        this.initBtnClearAllSort();
    }

    private void initLevel() {
        this.levelSpinner.setValue((Object)new Integer(2));
        ((SpinnerNumberModel)this.levelSpinner.getModel()).setMaximum(new Integer(100));
        ((SpinnerNumberModel)this.levelSpinner.getModel()).setMinimum(new Integer(2));
    }

    private void initBtnClearAllSort() {
        OrgTreeInfo selectTreeInfo = (OrgTreeInfo)this.cbxMain.getSelectedItem();
        if (selectTreeInfo.getId() != null && selectTreeInfo.getId().toString().equals("00000000-0000-0000-0000-0000000000024F2827FD")) {
            this.btnClearAllSort.setVisible(true);
            if (this.btnInitSorting.isVisible()) {
                this.btnClearAllSort.setVisible(false);
            }
        } else {
            this.btnClearAllSort.setVisible(false);
        }
    }

    private void addTreeListener() {
        this.treeMain.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                DefaultKingdeeTreeNode tmp = (DefaultKingdeeTreeNode)event.getPath().getLastPathComponent();
                if (tmp == null) {
                    return;
                }
                try {
                    OUViewListUI.this.loadNode(tmp);
                }
                catch (Exception e) {
                    logger.error((Object)"error", (Throwable)e);
                }
            }
        });
    }

    private void loadNode(DefaultKingdeeTreeNode tmp) throws EASBizException, BOSException {
        OrgStructureInfo unitInfo;
        if (tmp != null && tmp.getUserObject() != null && (unitInfo = (OrgStructureInfo)tmp.getUserObject()).get("alreadyLoad") == null && this.isNeedGetChild) {
            OrgAssistInfo assistInfo = this.buildNewOrgF7AssistInfo();
            INewOrgF7Facade facade = NewOrgF7FacadeFactory.getRemoteInstance();
            List orgCol = facade.getDirectChildren(assistInfo, unitInfo);
            if (null == orgCol || orgCol.size() == 0) {
                tmp.setCustomIcon(UIManager.getIcon("Tree.leafIcon"));
            }
            this.insertNodeIntoRoot(tmp, orgCol);
            unitInfo.put("alreadyLoad", true);
        }
    }

    private void insertNodeIntoRoot(DefaultKingdeeTreeNode root, List orgCol) {
        for (int i = 0; i < orgCol.size(); ++i) {
            OrgStructureInfo info = (OrgStructureInfo)orgCol.get(i);
            KDTreeNode treeNode = new KDTreeNode((Object)info);
            root.add((MutableTreeNode)treeNode);
        }
    }

    private void initTblMain() {
        this.tblMain.checkParsed();
        this.tblMain.getViewManager().setFreezeView(0, 3);
    }

    private void initCbxMain() throws BOSException {
        DefaultComboBoxModel<OrgTreeInfo> model = new DefaultComboBoxModel<OrgTreeInfo>();
        IOrgTree iTree = OrgTreeFactory.getRemoteInstance();
        OrgTreeCollection treeColSource = iTree.getOrgTreeCollection("select id,name,type where type != 8 order by id");
        OrgTreeCollection treeCol = OrgHelper.filterTreeCol(treeColSource);
        if (treeCol != null && treeCol.size() > 0) {
            for (int i = 0; i < treeCol.size(); ++i) {
                OrgTreeInfo treeInfo = treeCol.get(i);
                model.addElement(treeInfo);
            }
        }
        this.cbxMain.setModel(model);
        this.cbxMain.setSelectedIndex(1);
        this.cbxMain.setEditable(false);
        this.cbxMain.setMaximumRowCount(model.getSize());
        this.setBtnShowSealUpStatus();
        this.setBtnShowVirtualStatus();
        this.setExportMenuItemStatus();
        this.setBtnOrgMoveStatus();
        this.setBtnOrgUniteAndSplitStatus();
        this.setBtnSortStatus();
    }

    protected void initTree() throws Exception {
        this.buildTree();
    }

    @Override
    protected void levelSpinner_stateChanged(ChangeEvent e) throws Exception {
        int newLevel = (Integer)this.levelSpinner.getValue();
        if (newLevel == this.level) {
            return;
        }
        this.level = newLevel;
        this.isDealTree = true;
        try {
            this.setTreeExpandLevel((DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot());
        }
        finally {
            this.isDealTree = false;
        }
        this.isNeedGetChild = true;
        this.treeMain.setSelectionNode((DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot());
        this.treeMain_valueChanged(null);
    }

    protected void cbxMain_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() == 1) {
            this.initTree();
            this.setBtnShowSealUpStatus();
            this.setBtnShowVirtualStatus();
            this.setExportMenuItemStatus();
            this.setBtnOrgMoveStatus();
            this.setBtnOrgUniteAndSplitStatus();
            this.setBtnSortStatus();
            this.initBtnClearAllSort();
        }
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        if (this.orgDataHelper == null) {
            this.orgDataHelper = new OrgUIDataUtil();
        }
        OrgTreeInfo selectInfo = (OrgTreeInfo)this.cbxMain.getSelectedItem();
        OrgType orgType = null;
        boolean isReponTree = false;
        if (!"00000000-0000-0000-0000-0000000000094F2827FD".equals(selectInfo.getId().toString())) {
            orgType = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(selectInfo.getId().toString()).getOrgType();
        } else {
            isReponTree = true;
        }
        OrgTableHelper.addTalbeOrgCol(this.tblMain);
        for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
            String orgId = (String)this.tblMain.getRow(i).getCell("unit.id").getValue();
            String orgTypeStr = (String)this.tblMain.getRow(i).getCell("orgTypeStr").getValue();
            IRow row = this.tblMain.getRow(i);
            Boolean sealUpBoolean = (Boolean)this.mapSealUp.get(selectInfo.getId().toString());
            try {
                if (isReponTree) {
                    this.dealRowByOrgType(orgId, OrgType.Company, i, sealUpBoolean);
                    this.dealRowByOrgType(orgId, OrgType.ProfitCenter, i, sealUpBoolean);
                    this.dealRowByOrgType(orgId, OrgType.CostCenter, i, sealUpBoolean);
                } else {
                    this.dealRowByOrgType(orgId, orgType, i, sealUpBoolean);
                }
            }
            catch (EASBizException e1) {
                logger.error((Object)"error", (Throwable)e1);
            }
            catch (BOSException e1) {
                logger.error((Object)"error", (Throwable)e1);
            }
            OrgTableHelper.setTableRowValue(this.orgDataHelper, orgTypeStr, row, "unit.id", sealedupColor);
            if (this.isShowVirtual || OrgType.Admin != orgType) continue;
            BizOrgQueryParam bizVirutalOrgParam = new BizOrgQueryParam();
            bizVirutalOrgParam.setIsVirtual("TRUE");
            try {
                if (!this.orgDataHelper.isEntityOrg(orgId, OrgType.Admin, bizVirutalOrgParam)) continue;
                logger.info((Object)(" org is virutal ,hidden. orgId is:" + orgId));
                this.tblMain.getRow(i).getStyleAttributes().setHided(true);
                continue;
            }
            catch (EASBizException e1) {
                logger.error((Object)"error", (Throwable)e1);
                continue;
            }
            catch (BOSException e1) {
                logger.error((Object)"error", (Throwable)e1);
            }
        }
    }

    private boolean isContainSealUp(String treeID) {
        if (StringUtils.isEmpty((String)treeID)) {
            return false;
        }
        Boolean value = (Boolean)this.mapSealUp.get(treeID);
        if (value != null) {
            return value;
        }
        return false;
    }

    private void buildTree() throws EASBizException, BOSException {
        OrgTreeInfo selectInfo = (OrgTreeInfo)this.cbxMain.getSelectedItem();
        if (selectInfo == null) {
            this.treeMain.setModel(null);
            this.mainQuery = null;
            return;
        }
        KDTreeNode root = null;
        OrgAssistInfo assistInfo = this.buildNewOrgF7AssistInfo();
        INewOrgF7Facade facade = NewOrgF7FacadeFactory.getRemoteInstance();
        List orgCol = facade.getDirectChildren(assistInfo, null);
        if (orgCol == null || orgCol.size() <= 0) {
            this.treeMain.setModel(null);
            this.mainQuery = null;
            return;
        }
        root = new KDTreeNode(orgCol.get(0));
        orgCol.remove(0);
        this.insertNodeIntoRoot((DefaultKingdeeTreeNode)root, orgCol);
        ((OrgStructureInfo)root.getUserObject()).put("alreadyLoad", true);
        this.treeMain.setModel((TreeModel)new DefaultTreeModel((TreeNode)root){

            @Override
            public boolean isLeaf(Object node) {
                OrgStructureInfo info = (OrgStructureInfo)((KDTreeNode)node).getUserObject();
                return info == null || info.isIsLeaf();
            }
        });
        this.treeMain.setRootVisible(true);
        this.treeMain.setShowsRootHandles(true);
        this.treeMain.setSelectionNode((DefaultKingdeeTreeNode)root);
    }

    private OrgAssistInfo buildNewOrgF7AssistInfo() throws BOSException {
        OrgAssistInfo assistInfo = new OrgAssistInfo();
        OrgTreeInfo selectInfo = (OrgTreeInfo)this.cbxMain.getSelectedItem();
        if (selectInfo == null) {
            throw new BOSException("selected item is null.");
        }
        String treeID = selectInfo.getId().toString();
        if (treeID.equals("00000000-0000-0000-0000-0000000000034F2827FD") && this.isViewAdminOrgShowByRange()) {
            assistInfo.setOrgRangeType(2);
            assistInfo.setNeedAddOrgRange(true);
        }
        if (!this.isContainSealUp(treeID)) {
            assistInfo.setNeedAddSealUpFilter(true);
        }
        if (treeID.equals("00000000-0000-0000-0000-0000000000034F2827FD") && !this.isShowVirtual) {
            assistInfo.setNeedAddVirtualFilter(true);
        }
        assistInfo.setNeedAddAssistantFilter(true);
        assistInfo.setOrgViewType(OrgTypeInfoMgr.getInstance().getOrgTypeInfo(treeID).getOrgViewType());
        assistInfo.setTreeID(treeID);
        assistInfo.setStructure(true);
        ArrayList<String> decorators = new ArrayList<String>();
        decorators.add("com.kingdee.eas.basedata.org.app.helper.StructTreeNode4OUViewAssemblage");
        decorators.add("com.kingdee.eas.basedata.org.app.helper.NormalFilter4F7Decorator");
        decorators.add("com.kingdee.eas.basedata.org.app.helper.OrgRangeFilter4F7Decorator");
        assistInfo.setConstructParam(decorators);
        assistInfo.setIsNeedBySortCode(this.isQueryBySortCode);
        return assistInfo;
    }

    private void dealRowByOrgType(String orgId, OrgType orgType, int rowInt, boolean showSealUpOrg) throws EASBizException, BOSException {
        if (this.orgDataHelper.isSealUpOrg(orgId, orgType)) {
            if (!showSealUpOrg) {
                logger.debug((Object)(" org is sealup ,hidden. orgId is:" + orgId));
                this.tblMain.getRow(rowInt).getStyleAttributes().setHided(true);
            } else {
                this.tblMain.getRow(rowInt).getStyleAttributes().setBackground(sealedupColor2);
                this.tblMain.getRow(rowInt).getStyleAttributes().setHided(false);
            }
        }
    }

    private void setTreeExpandLevel(DefaultKingdeeTreeNode root) throws EASBizException, BOSException {
        if (root != null) {
            OrgStructureInfo structInfo = (OrgStructureInfo)root.getUserObject();
            if (structInfo != null) {
                if (structInfo.getLevel() <= this.level) {
                    if (structInfo.getLevel() == this.level) {
                        this.isNeedGetChild = false;
                    }
                } else {
                    this.treeMain.collapsePath(this.treeMain.getSelectionPath());
                    return;
                }
                this.treeMain.expandPath(new TreePath(root));
                this.treeMain.setSelectionNode(root);
                this.isNeedGetChild = true;
            }
            for (int i = 0; i < root.getChildCount(); ++i) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
                this.setTreeExpandLevel(node);
            }
        }
    }

    private void setBtnShowSealUpStatus() {
        String selectedID = ((OrgTreeInfo)this.cbxMain.getSelectedItem()).getId().toString();
        this.btnContainSealUp.setEnabled(true);
        this.menuItemSwitchSealUp.setEnabled(true);
        boolean isShowSealUp = (Boolean)this.mapSealUp.get(selectedID);
        if (isShowSealUp) {
            this.btnContainSealUp.setText(EASResource.getString((String)this.strRes, (String)"SEALUP_NOTCONTAIN"));
            this.btnContainSealUp.setToolTipText(EASResource.getString((String)this.strRes, (String)"SEALUP_NOTCONTAIN"));
            this.btnContainSealUp.setIcon(EASResource.getIcon((String)"imgTbtn_deletesealup"));
            this.menuItemSwitchSealUp.setText(EASResource.getString((String)this.strRes, (String)"SEALUP_NOTCONTAIN"));
            this.menuItemSwitchSealUp.setToolTipText(EASResource.getString((String)this.strRes, (String)"SEALUP_NOTCONTAIN"));
            this.menuItemSwitchSealUp.setIcon(EASResource.getIcon((String)"imgTbtn_deletesealup"));
        } else {
            this.btnContainSealUp.setText(EASResource.getString((String)this.strRes, (String)"SEALUP_CONTAIN"));
            this.btnContainSealUp.setToolTipText(EASResource.getString((String)this.strRes, (String)"SEALUP_CONTAIN"));
            this.btnContainSealUp.setIcon(EASResource.getIcon((String)"imgTbtn_showsealup"));
            this.menuItemSwitchSealUp.setText(EASResource.getString((String)this.strRes, (String)"SEALUP_CONTAIN"));
            this.menuItemSwitchSealUp.setToolTipText(EASResource.getString((String)this.strRes, (String)"SEALUP_CONTAIN"));
            this.menuItemSwitchSealUp.setIcon(EASResource.getIcon((String)"imgTbtn_showsealup"));
        }
    }

    private void setBtnShowVirtualStatus() {
        OrgTreeInfo selectInfo = (OrgTreeInfo)this.cbxMain.getSelectedItem();
        if (selectInfo != null && "00000000-0000-0000-0000-0000000000034F2827FD".equals(selectInfo.getId().toString())) {
            this.btnShowVirtual.setVisible(true);
            this.menuItemShowVirtual.setVisible(true);
            if (!this.isShowVirtual) {
                this.btnShowVirtual.setText(EASResource.getString((String)this.strRes, (String)"SHOW_VIRTUAL"));
                this.btnShowVirtual.setToolTipText(EASResource.getString((String)this.strRes, (String)"SHOW_VIRTUAL"));
                this.btnShowVirtual.setIcon(EASResource.getIcon((String)"imgTbtn_dummygroup"));
                this.menuItemShowVirtual.setText(EASResource.getString((String)this.strRes, (String)"SHOW_VIRTUAL"));
                this.menuItemShowVirtual.setToolTipText(EASResource.getString((String)this.strRes, (String)"SHOW_VIRTUAL"));
                this.menuItemShowVirtual.setIcon(EASResource.getIcon((String)"imgTbtn_dummygroup"));
            } else {
                this.btnShowVirtual.setText(EASResource.getString((String)this.strRes, (String)"NOT_SHOW_VIRTUAL"));
                this.btnShowVirtual.setToolTipText(EASResource.getString((String)this.strRes, (String)"NOT_SHOW_VIRTUAL"));
                this.btnShowVirtual.setIcon(EASResource.getIcon((String)"imgTbtn_offdummygroup"));
                this.menuItemShowVirtual.setText(EASResource.getString((String)this.strRes, (String)"NOT_SHOW_VIRTUAL"));
                this.menuItemShowVirtual.setToolTipText(EASResource.getString((String)this.strRes, (String)"NOT_SHOW_VIRTUAL"));
                this.menuItemShowVirtual.setIcon(EASResource.getIcon((String)"imgTbtn_offdummygroup"));
            }
        } else {
            this.btnShowVirtual.setVisible(false);
            this.menuItemShowVirtual.setVisible(false);
        }
    }

    private void setMenuVisible(boolean value) {
        Collection col = this.menuCacheMap.values();
        for (KDMenuItem item : col) {
            item.setVisible(value);
        }
    }

    private void setExportMenuItemStatus() {
        OrgTreeInfo selectInfo = (OrgTreeInfo)this.cbxMain.getSelectedItem();
        if (selectInfo == null || selectInfo.getId() == null) {
            return;
        }
        this.menuExport.setVisible(false);
        this.kDSeparator1.setVisible(false);
        this.setMenuVisible(false);
        Collection orgTypeCol = OrgTypeInfoMgr.getInstance().getAllOrgTypeInfo();
        for (OrgTypeInfo curOrgTypeInfo : orgTypeCol) {
            KDMenuItem item = (KDMenuItem)this.menuCacheMap.get((Object)curOrgTypeInfo.getOrgType());
            if (item == null) {
                logger.info((Object)(" orgType 's export menu is null, orgType is:" + curOrgTypeInfo.getOrgType().getName()));
                continue;
            }
            item.setVisible(true);
            if (selectInfo.getId().toString().equals(curOrgTypeInfo.getOrgTreeID())) {
                this.menuExport.setVisible(true);
                item.setVisible(true);
                this.kDSeparator1.setVisible(true);
                continue;
            }
            item.setVisible(false);
        }
    }

    private void setBtnOrgMoveStatus() {
        OrgTreeInfo selectInfo = (OrgTreeInfo)this.cbxMain.getSelectedItem();
        if (selectInfo != null) {
            String treeID = selectInfo.getId().toString();
            if ("00000000-0000-0000-0000-0000000000014F2827FD".equals(treeID) || "00000000-0000-0000-0000-0000000000094F2827FD".equals(treeID)) {
                this.btnOrgMove.setVisible(false);
                this.menuItemOrgMove.setVisible(false);
            } else {
                this.btnOrgMove.setVisible(true);
                this.menuItemOrgMove.setVisible(true);
            }
        }
    }

    private void setBtnOrgUniteAndSplitStatus() {
        OrgTreeInfo selectInfo = (OrgTreeInfo)this.cbxMain.getSelectedItem();
        if (selectInfo != null) {
            this.btnOrgUnite.setVisible(false);
            this.btnOrgSplit.setVisible(false);
            this.menuItemOrgUnite.setVisible(false);
            this.menuItemOrgSplit.setVisible(false);
            this.btnBizMove.setVisible(false);
            this.menuItemBizMove.setVisible(false);
        }
    }

    private void setBtnSortStatus() throws BOSException {
        OrgTreeInfo selectInfo = (OrgTreeInfo)this.cbxMain.getSelectedItem();
        if (selectInfo != null && "00000000-0000-0000-0000-0000000000034F2827FD".equals(selectInfo.getId().toString())) {
            boolean hasInit = OrgStructureFactory.getRemoteInstance().hasInitSortCode();
            if (hasInit) {
                this.btnInitSorting.setVisible(false);
                this.btnSortSetting.setVisible(true);
                this.btnQueryBySortCode.setVisible(true);
                if (!this.isQueryBySortCode) {
                    this.btnQueryBySortCode.setText(OrgToolUtils.getResource("res_49"));
                    this.btnQueryBySortCode.setToolTipText(OrgToolUtils.getResource("res_49"));
                } else {
                    this.btnQueryBySortCode.setText(OrgToolUtils.getResource("res_50"));
                    this.btnQueryBySortCode.setToolTipText(OrgToolUtils.getResource("res_50"));
                }
            } else {
                this.btnInitSorting.setVisible(true);
                this.btnSortSetting.setVisible(false);
                this.btnQueryBySortCode.setVisible(false);
            }
        } else {
            this.btnInitSorting.setVisible(false);
            this.btnSortSetting.setVisible(false);
            this.btnQueryBySortCode.setVisible(false);
        }
        this.initBtnClearAllSort();
    }

    public void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    private DefaultKingdeeTreeNode redirectFromTableToTree(String id, DefaultKingdeeTreeNode root) {
        if (root == null) {
            return null;
        }
        if (root.getUserObject() != null && root.getUserObject() instanceof OrgStructureInfo && id.equals(((OrgStructureInfo)root.getUserObject()).getUnit().getId().toString())) {
            return root;
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = this.redirectFromTableToTree(id, (DefaultKingdeeTreeNode)root.getChildAt(i));
            if (node == null) continue;
            return node;
        }
        return null;
    }

    protected void buildTreeFilter() {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        OrgTreeInfo selectInfo = (OrgTreeInfo)this.cbxMain.getSelectedItem();
        boolean isContainSealUp = false;
        Boolean value = (Boolean)this.mapSealUp.get(selectInfo.getId().toString());
        OrgViewType orgViewType = selectInfo.getType();
        String currentOrgTypeTableName = "";
        if (value != null) {
            isContainSealUp = value;
        }
        if (this.mainQuery.getFilter() == null) {
            this.mainQuery.setFilter(new FilterInfo());
        }
        FilterItemCollection col = this.removeQueryFilterAndSorter(this.mainQuery);
        if (treeNode == null) {
            String type = selectInfo.getType().getName();
            FilterItemInfo treeFilterItem = new FilterItemInfo("unit.orgTypeStr", (Object)type, CompareType.LIKE);
            FilterInfo treeFilter = new FilterInfo();
            treeFilter.getFilterItems().add(treeFilterItem);
            try {
                if (!isContainSealUp && !orgViewType.equals((Object)OrgViewType.CTRLUNIT)) {
                    currentOrgTypeTableName = this.getCurOrgTypeOUPartTableName(orgViewType);
                    String sql = "select funitid from " + currentOrgTypeTableName + " where FIsSealUp = 1";
                    treeFilter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)sql, CompareType.NOTINNER));
                }
                this.mainQuery.getFilter().mergeFilter(treeFilter, "and");
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            return;
        }
        this.mainQuery.getFilter().remove("maskString");
        if (treeNode.getUserObject() instanceof OrgStructureInfo) {
            col.add(new FilterItemInfo(this.getLongNumberFieldName(), (Object)((OrgStructureInfo)treeNode.getUserObject()).getLongNumber()));
            col.add(new FilterItemInfo(this.getLongNumberFieldName(), (Object)(((OrgStructureInfo)treeNode.getUserObject()).getLongNumber() + "!%"), CompareType.LIKE));
            if (!this.isIncludeAllChildren()) {
                col.add(new FilterItemInfo("level", (Object)new Integer(((TreeBaseInfo)treeNode.getUserObject()).getLevel() - 1)));
                this.mainQuery.getFilter().setMaskString("#0 or (#1 and #2)");
            } else {
                this.mainQuery.getFilter().setMaskString("#0 or #1");
            }
        } else if (!this.isIncludeAllChildren()) {
            col.add(new FilterItemInfo("level", (Object)new Integer(1)));
        }
        try {
            this.getEntityViewInfo(this.mainQuery);
            if (this.getDefaultEntityViewInfo() != null) {
                this.MergeCommonQuery(this.getDefaultEntityViewInfo());
            }
            if (!isContainSealUp && !orgViewType.equals((Object)OrgViewType.CTRLUNIT)) {
                FilterInfo filter1 = new FilterInfo();
                currentOrgTypeTableName = this.getCurOrgTypeOUPartTableName(orgViewType);
                String sql = "select funitid from " + currentOrgTypeTableName + " where FIsSealUp = 1";
                filter1.getFilterItems().add(new FilterItemInfo("unit.id", (Object)sql, CompareType.NOTINNER));
                this.mainQuery.getFilter().mergeFilter(filter1, "and");
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
            this.abort();
        }
        if (this.getCurrentOrder() != null) {
            this.mainQuery.getSorter().add(this.getCurrentOrder());
        } else {
            String longNumberFieldName = this.getLongNumberFieldName();
            boolean found = false;
            for (int i = 0; i < this.mainQuery.getSorter().size(); ++i) {
                SorterItemInfo sorterItem = this.mainQuery.getSorter().get(i);
                if (!sorterItem.getPropertyName().equalsIgnoreCase(longNumberFieldName)) continue;
                found = true;
            }
            if (!found) {
                this.mainQuery.getSorter().add(new SorterItemInfo(longNumberFieldName));
            }
        }
    }

    private String getCurOrgTypeOUPartTableName(OrgViewType orgViewType) throws Exception {
        String tableName = "";
        if (this.allOUPartTableMap.get((Object)orgViewType) != null) {
            tableName = (String)this.allOUPartTableMap.get((Object)orgViewType);
        } else {
            if (this.iNewOrgF7Facade == null) {
                this.iNewOrgF7Facade = NewOrgF7FacadeFactory.getRemoteInstance();
            }
            tableName = this.iNewOrgF7Facade.getTableNameByOrgTypeView(orgViewType);
            this.allOUPartTableMap.put(orgViewType, tableName);
        }
        return tableName;
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        if (this.isDealTree && !this.treeMain.getModel().isLeaf(this.treeMain.getModel().getRoot())) {
            return;
        }
        if (this.mainQuery == null) {
            this.mainQuery = new EntityViewInfo();
        }
        super.treeMain_valueChanged(e);
        this.syncMainQueryForExport();
    }

    private void syncMainQueryForExport() throws Exception {
        TreePath path = this.treeMain.getSelectionPath();
        if (path != null) {
            DefaultKingdeeTreeNode selectNode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
            if (selectNode != null) {
                if (selectNode.getUserObject() instanceof OrgStructureInfo) {
                    OrgStructureInfo selectInfo = (OrgStructureInfo)selectNode.getUserObject();
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    OrgTreeInfo treeInfo = (OrgTreeInfo)this.cbxMain.getSelectedItem();
                    if (treeInfo != null) {
                        String treeId = treeInfo.getId().toString();
                        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)selectInfo.getLongNumber(), CompareType.EQUALS));
                        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(selectInfo.getLongNumber() + "!%"), CompareType.LIKE));
                        if (!((Boolean)this.mapSealUp.get(treeId)).booleanValue()) {
                            filter.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)new Integer(0), CompareType.EQUALS));
                            filter.setMaskString("(#0 or #1) and #2");
                        } else {
                            filter.setMaskString("#0 or #1");
                        }
                        if (!this.isShowVirtual && "00000000-0000-0000-0000-0000000000034F2827FD".equals(treeInfo.getId().toString())) {
                            FilterInfo filter2 = new FilterInfo();
                            filter2.getFilterItems().add(new FilterItemInfo("isVirtual", (Object)new Integer(0), CompareType.EQUALS));
                            if (this.isViewAdminOrgShowByRange()) {
                                Set unitId = this.getOrgRangeSetOrgID();
                                filter2.getFilterItems().add(new FilterItemInfo("id", (Object)unitId, CompareType.INCLUDE));
                            }
                            filter.mergeFilter(filter2, "and");
                        }
                        if (selectInfo.getLevel() < this.level) {
                            FilterInfo filter3 = new FilterInfo();
                            filter3.getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(this.level), CompareType.LESS_EQUALS));
                            filter.mergeFilter(filter3, "and");
                        }
                    }
                    view.setFilter(filter);
                    if (!this.isQueryBySortCode) {
                        view.getSorter().add(new SorterItemInfo("longNumber"));
                    } else {
                        view.getSorter().add(new SorterItemInfo("sortCode"));
                    }
                    this.mainQueryForExport = view;
                } else {
                    this.mainQueryForExport = null;
                }
            }
        } else {
            this.mainQueryForExport = null;
        }
    }

    protected void refresh(ActionEvent e) throws Exception {
        this.initTree();
        this.treeMain_valueChanged(null);
    }

    @Override
    public void actionContainSealUp_actionPerformed(ActionEvent e) throws Exception {
        super.actionContainSealUp_actionPerformed(e);
        String selected = ((OrgTreeInfo)this.cbxMain.getSelectedItem()).getId().toString();
        Boolean oldValue = (Boolean)this.mapSealUp.get(selected);
        Boolean newValue = new Boolean(oldValue == false);
        this.mapSealUp.put(selected, newValue);
        this.setBtnShowSealUpStatus();
        this.initTree();
    }

    @Override
    public void actionShowVirtual_actionPerformed(ActionEvent e) throws Exception {
        super.actionShowVirtual_actionPerformed(e);
        this.isShowVirtual = !this.isShowVirtual;
        this.setBtnShowVirtualStatus();
        this.initTree();
    }

    @Override
    public void actionOrgMove_actionPerformed(ActionEvent e) throws Exception {
        OrgUnitInfo unitInfo;
        OrgTreeInfo selectInfo = (OrgTreeInfo)this.cbxMain.getSelectedItem();
        if (selectInfo == null) {
            return;
        }
        KDTSelectBlock block = this.tblMain.getSelectManager().get();
        if (block == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.strRes, (String)"PLEASE_SELECT_MOVED_UNIT"));
            return;
        }
        String id = (String)this.tblMain.getCell(block.getBeginRow(), "unit.id").getValue();
        if ("00000000-0000-0000-0000-000000000000CCE7AED4".equals(id)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.strRes, (String)"CANNOT_MOVE_ROOT_UNIT"));
            return;
        }
        String treeID = selectInfo.getId().toString();
        OrgType curOrgType = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(treeID).getOrgType();
        IOrgTypeClientHelper iOrgClient = OrgTypeClientCenter.getInstance().getClientImp(curOrgType);
        NewOrgViewF7PromptDialog f7 = "00000000-0000-0000-0000-0000000000104F2827FD".equalsIgnoreCase(treeID) ? ((OrgTypeClientDefaultImpl)iOrgClient).createNewF7ByCondition("TREETYPE_BIZUNIT") : ((OrgTypeClientDefaultImpl)iOrgClient).createNewF7ByCondition("TREETYPE_VIRTUALUNIT");
        f7.setNeedAddOrgRange(false);
        f7.show();
        if (!f7.isCanceled() && (unitInfo = (OrgUnitInfo)f7.getData()) != null) {
            String parentId = unitInfo.getId().toString();
            OrgType orgType = NewOrgViewHelper.getOrgTypeFromOrgTreeID(treeID);
            NewOrgViewFacadeFactory.getRemoteInstance().updateBizParent(orgType, id, parentId);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.strRes, (String)"ORG_UNIT_MOVE_SUCCESS"));
            this.initTree();
        }
    }

    @Override
    public void actionBizMove_actionPerformed(ActionEvent e) throws Exception {
        OrgUnitInfo unitInfo;
        int relV = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)this.strRes, (String)"CONFIRM_BIZ_MOVE"));
        if (MsgBox.isCancel((int)relV)) {
            return;
        }
        OrgTreeInfo selectInfo = (OrgTreeInfo)this.cbxMain.getSelectedItem();
        if (selectInfo == null) {
            return;
        }
        KDTSelectBlock block = this.tblMain.getSelectManager().get();
        if (block == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.strRes, (String)"PLEASE_SELECT_MOVED_UNIT"));
            return;
        }
        String id = (String)this.tblMain.getCell(block.getBeginRow(), "unit.id").getValue();
        if ("00000000-0000-0000-0000-000000000000CCE7AED4".equals(id)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.strRes, (String)"CANNOT_MOVE_ROOT_UNIT"));
            return;
        }
        String treeID = selectInfo.getId().toString();
        OrgType curOrgType = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(treeID).getOrgType();
        IOrgTypeClientHelper iOrgClient = OrgTypeClientCenter.getInstance().getClientImp(curOrgType);
        NewOrgViewF7PromptDialog f7 = ((OrgTypeClientDefaultImpl)iOrgClient).createNewF7ByCondition("TREETYPE_VIRTUALUNIT");
        f7.setNeedAddOrgRange(false);
        f7.show();
        if (!f7.isCanceled() && (unitInfo = (OrgUnitInfo)f7.getData()) != null) {
            String parentId = unitInfo.getId().toString();
            OrgType orgType = NewOrgViewHelper.getOrgTypeFromOrgTreeID(treeID);
            NewOrgViewFacadeFactory.getRemoteInstance().updateBizParent(orgType, id, parentId);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.strRes, (String)"BIZ_MOVE_SUCCESS"));
            this.initTree();
        }
    }

    @Override
    public void actionOrgUnite_actionPerformed(ActionEvent e) throws Exception {
        OrgUnitInfo unitInfo;
        int relV = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)this.strRes, (String)"CONFIRM_ORG_UNITE"));
        if (MsgBox.isCancel((int)relV)) {
            return;
        }
        OrgTreeInfo selectInfo = (OrgTreeInfo)this.cbxMain.getSelectedItem();
        if (selectInfo == null) {
            return;
        }
        KDTSelectBlock block = this.tblMain.getSelectManager().get();
        if (block == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.strRes, (String)"PLEASE_SELECT_UNITED_UNIT"));
            return;
        }
        String id = (String)this.tblMain.getCell(block.getBeginRow(), "unit.id").getValue();
        if ("00000000-0000-0000-0000-000000000000CCE7AED4".equals(id)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.strRes, (String)"CANNOT_UNITE_ROOT_UNIT"));
            return;
        }
        OrgF7PromptDialog f7 = null;
        String treeID = selectInfo.getId().toString();
        OrgType curOrgType = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(treeID).getOrgType();
        f7 = OrgTypeClientCenter.getInstance().getClientImp(curOrgType).createF7ByCondition("TREETYPE_VIRTUALUNIT");
        f7.disablePerm(null, false);
        f7.show();
        if (!f7.isCanceled() && (unitInfo = (OrgUnitInfo)f7.getData()) != null) {
            String targetId = unitInfo.getId().toString();
            OrgType orgType = NewOrgViewHelper.getOrgTypeFromOrgTreeID(treeID);
            NewOrgViewFacadeFactory.getRemoteInstance().bizOrgUnite(orgType, id, targetId);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.strRes, (String)"ORG_UNIT_UNITE_SUCCESS"));
            this.initTree();
        }
    }

    @Override
    public void actionOrgSplit_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionSortSetting_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode selectNode;
        OrgTreeInfo selectTreeInfo = (OrgTreeInfo)this.cbxMain.getSelectedItem();
        if (selectTreeInfo == null) {
            return;
        }
        String treeId = selectTreeInfo.getId().toString();
        TreePath path = this.treeMain.getSelectionPath();
        if (path != null && (selectNode = (DefaultKingdeeTreeNode)path.getLastPathComponent()) != null) {
            OrgStructureInfo selectInfo = (OrgStructureInfo)selectNode.getUserObject();
            String longNumber = selectInfo.getLongNumber();
            int levelValue = selectInfo.getLevel();
            int sortLevel = 0;
            if (selectInfo.getSortCode() != null) {
                sortLevel = selectInfo.getSortCode().split("!").length;
            } else {
                String oql = "select sortcode where id = '" + selectInfo.getId().toString() + "'";
                OrgStructureInfo structInfoNew = OrgStructureFactory.getRemoteInstance().getOrgStructureInfo(oql);
                String sortCode = structInfoNew.getSortCode();
                if (sortCode != null && !sortCode.equals("")) {
                    sortLevel = sortCode.split("!").length;
                }
            }
            if (levelValue != sortLevel) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OUResource", (String)"Set_Parent_SortCode"));
                return;
            }
            Map context = this.getUIContext();
            context.put("org_tree_id", treeId);
            context.put("longnumber", longNumber);
            context.put("level", new Integer(levelValue + 1));
            IUIWindow uiWindow = null;
            IUIFactory uiFactory = null;
            try {
                uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                uiWindow = uiFactory.create(OrgSortSettingUI.class.getName(), context);
                uiWindow.show();
            }
            catch (UIException ex1) {
                this.handleException((Exception)((Object)ex1));
            }
            if (((OrgSortSettingUI)uiWindow.getUIObject()).isUpdate) {
                this.initTree();
            }
        }
    }

    @Override
    public void actionInitSorting_actionPerformed(ActionEvent e) throws Exception {
        Window win = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        LongTimeDialog ltd = null;
        ltd = win instanceof Frame ? new LongTimeDialog((Frame)win) : (win instanceof Dialog ? new LongTimeDialog((Dialog)win) : new LongTimeDialog((Frame)new JFrame()));
        ltd.setTitle(OrgToolUtils.getResource("res_51"));
        ltd.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                try {
                    OrgStructureFactory.getRemoteInstance().initSortCode();
                }
                catch (Exception e) {
                    OUViewListUI.this.handleException(e);
                }
                return new Boolean(true);
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        ltd.show();
        this.setBtnSortStatus();
    }

    @Override
    public void actionQueryBySortCode_actionPerformed(ActionEvent e) throws Exception {
        this.isQueryBySortCode = !this.isQueryBySortCode;
        this.setBtnSortStatus();
        this.initTree();
    }

    @Override
    public void actionExportOrg_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportOrg_actionPerformed(e);
        Object obj = e.getSource();
        if (!(obj instanceof KDMenuItem)) {
            logger.info((Object)(" source item is not right. obj is:" + obj));
            return;
        }
        KDMenuItem item = (KDMenuItem)obj;
        OrgType curOrgType = (OrgType)((Object)item.getClientProperty((Object)OrgType.class.getName()));
        if (curOrgType == null) {
            logger.info((Object)"curOrgType is not right ! curOrgType is null");
        }
        OrgTypeClientCenter.getInstance().getClientImp(curOrgType).exportData(e, this.mainQueryForExport);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FullOrgUnitFactory.getRemoteInstance();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"OnlyForView", (Object)new Boolean(true));
    }

    protected String getEditUIName() {
        return OUEditUI.class.getName();
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        try {
            OrgTreeInfo treeInfo = (OrgTreeInfo)this.cbxMain.getSelectedItem();
            filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)treeInfo.getId().toString(), CompareType.EQUALS));
            AbstractOrgStructureInfo selectInfo = null;
            TreePath path = this.treeMain.getSelectionPath();
            if (path != null) {
                DefaultKingdeeTreeNode selectNode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
                selectInfo = (OrgStructureInfo)selectNode.getUserObject();
            }
            if (selectInfo != null && selectInfo.getLevel() < this.level) {
                filter.getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(this.level), CompareType.LESS_EQUALS));
            }
        }
        catch (Exception e) {
            logger.error((Object)"error", (Throwable)e);
        }
        return filter;
    }

    protected List getOrgRangeCollectionOrgID() throws BOSException, EASBizException {
        ArrayList<BOSUuid> orgIds = new ArrayList<BOSUuid>();
        IOrgRange iOrgRange = OrgRangeFactory.getRemoteInstance();
        ObjectUuidPK userPk = new ObjectUuidPK("id", SysContext.getSysContext().getCurrentUserInfo().getId());
        OrgRangeCollection orgRangeCol = iOrgRange.findFullOrgCol((IObjectPK)userPk, OrgRangeType.ADMIN_ORG_TYPE);
        for (int i = 0; i < orgRangeCol.size(); ++i) {
            OrgRangeInfo orgRangeInfo = orgRangeCol.get(i);
            orgIds.add(orgRangeInfo.getOrg().getId());
        }
        return orgIds;
    }

    protected void filterTree(DefaultKingdeeTreeNode root, List orgIds) {
        OrgStructureInfo rootOrgSInfo = (OrgStructureInfo)root.getUserObject();
        BOSUuid rootUnitId = rootOrgSInfo.getUnit().getId();
        boolean flagColor = false;
        for (int j = 0; j < orgIds.size(); ++j) {
            if (!rootUnitId.equals((Object)((BOSUuid)orgIds.get(j)))) continue;
            root.setTextColor(Color.black);
            flagColor = true;
            break;
        }
        if (!flagColor) {
            root.setTextColor(Color.gray);
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode dkTreeNode = (DefaultKingdeeTreeNode)root.getChildAt(i);
            this.filterTree(dkTreeNode, orgIds);
        }
    }

    protected Set getOrgRangeSetOrgID() throws BOSException, EASBizException {
        HashSet<String> orgIds = new HashSet<String>();
        IOrgRange iOrgRange = OrgRangeFactory.getRemoteInstance();
        ObjectUuidPK userPk = new ObjectUuidPK("id", SysContext.getSysContext().getCurrentUserInfo().getId());
        OrgRangeCollection orgRangeCol = iOrgRange.findFullOrgCol((IObjectPK)userPk, OrgRangeType.ADMIN_ORG_TYPE);
        for (int i = 0; i < orgRangeCol.size(); ++i) {
            OrgRangeInfo orgRangeInfo = orgRangeCol.get(i);
            orgIds.add(orgRangeInfo.getOrg().getId().toString());
        }
        return orgIds;
    }

    private boolean isViewAdminOrgShowByRange() {
        ObjectUuidPK userPk = new ObjectUuidPK("id", SysContext.getSysContext().getCurrentUserInfo().getId());
        try {
            if (Administrator.isCUAdmin(null, (IObjectPK)userPk)) {
                return false;
            }
            ObjectUuidPK pk = new ObjectUuidPK(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
            String paramValue = ParamManager.getParamValue(null, (IObjectPK)pk, (String)"ViewAdminOrgShowByRange");
            return Boolean.valueOf(paramValue);
        }
        catch (Exception e) {
            logger.error((Object)"ViewAdminOrgShowByRange", (Throwable)e);
            return false;
        }
    }

    public static void clipTreeNodeByColor(DefaultKingdeeTreeNode root) {
        DefaultKingdeeTreeNode node = null;
        if (root.getChildCount() > 0) {
            for (int i = root.getChildCount() - 1; i >= 0; --i) {
                node = (DefaultKingdeeTreeNode)root.getChildAt(i);
                OUViewListUI.clipTreeNodeByColor(node);
                if (node.getChildCount() != 0 || !node.getTextColor().equals(Color.gray)) continue;
                root.remove((MutableTreeNode)node);
            }
        }
    }

    protected boolean isSupportDynQuery() {
        return false;
    }

    protected EntityViewInfo getInitDefaultSolution() {
        return null;
    }

    protected boolean isIncludeAllChildren() {
        return true;
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        this.qfsi.setMustQueryAtFirst(true);
        return this.qfsi.supportExecutionWithoutFilters();
    }

    protected QuickFilteringSupportManager createQuickFilteringSupportManager() throws Exception {
        QuickFilteringSupportItems qfsi = this.getQuickFilteringSupport();
        if (qfsi != null && this.getBizType() != null) {
            qfsi.setBosType(this.getBizType().toString());
        }
        return new QuickFilteringSupportManager((ListUI)this, qfsi, (Component)this.kDPanel1);
    }

    @Override
    public void actionClearAllSortCode_actionPerformed(ActionEvent e) throws Exception {
        OrgStructureInfo selectNode = (OrgStructureInfo)((KDTreeNode)this.treeMain.getSelectionModel().getSelectionPath().getLastPathComponent()).getUserObject();
        if (selectNode == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.basedata.org.OrgException", (String)"MUST_Select_Node"));
        }
        try {
            OrgStructureFactory.getRemoteInstance().clearAllSortCode(selectNode);
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OUResource", (String)"Clear_SortCode_Success"));
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OUResource", (String)"Clear_SortCode_Fail"));
        }
        this.setBtnSortStatus();
    }

    protected String getKeyFieldName() {
        return "unit.id";
    }
}

