/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.IOrgTree;
import com.kingdee.eas.basedata.org.IOrgVersionMgrFacade;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgVersionMgrFacadeFactory;
import com.kingdee.eas.basedata.org.client.AbstractOUViewVersionListUI;
import com.kingdee.eas.basedata.org.client.OrgVersionClientUtils;
import com.kingdee.eas.basedata.org.client.OrgVersionF7PromptDialog;
import com.kingdee.eas.basedata.org.client.helper.OrgVersionClentHelper;
import com.kingdee.eas.basedata.org.client.uihelper.OrgTypeClientCenter;
import com.kingdee.eas.basedata.org.helper.OrgHelper;
import com.kingdee.eas.basedata.org.helper.OrgTableHelper;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;

public class OUViewVersionListUI
extends AbstractOUViewVersionListUI {
    private String versionNumber = null;
    private List versionNumList = null;
    private List invalidDateList = null;
    private OrgType currentOrgType = null;
    OrgUnitCollection versionCol = null;

    public OUViewVersionListUI() throws Exception {
        this.init();
    }

    private void init() throws Exception {
        this.menuTool.setVisible(false);
        this.menuHelp.setVisible(false);
        this.btnAdminF7.setEnabled(true);
        this.btnCompanyF7.setEnabled(true);
        this.btnView.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.setButtonDefaultStyl(this.btnView);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.initOUView();
        this.initVersionCombox();
        this.initTblMain();
        this.buildTree();
    }

    private void initTblMain() {
        this.tblMain.getViewManager().setFreezeView(0, 3);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getColumn(0).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(1).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(2).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(3).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(4).getStyleAttributes().setLocked(true);
        this.tblMain.checkParsed();
    }

    private void initOUView() throws BOSException {
        int i;
        this.cbxMain.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    try {
                        OUViewVersionListUI.this.buildTree();
                    }
                    catch (Exception e1) {
                        OUViewVersionListUI.this.handleException(e1);
                    }
                }
            }
        });
        DefaultComboBoxModel<OrgTreeInfo> model = new DefaultComboBoxModel<OrgTreeInfo>();
        IOrgTree iTree = OrgTreeFactory.getRemoteInstance();
        OrgTreeCollection treeColSource = iTree.getOrgTreeCollection("select * where type != 8");
        OrgTreeCollection treeCol = OrgHelper.filterTreeCol(treeColSource);
        Object[] objs = treeCol.toArray();
        OrgTreeInfo[] treeInfos = new OrgTreeInfo[objs.length];
        for (i = 0; i < objs.length; ++i) {
            treeInfos[i] = (OrgTreeInfo)objs[i];
        }
        for (i = 0; i < treeInfos.length - 1; ++i) {
            for (int j = i + 1; j < treeInfos.length; ++j) {
                if (treeInfos[i].getId().toString().compareTo(treeInfos[j].getId().toString()) <= 0) continue;
                OrgTreeInfo temp = treeInfos[i];
                treeInfos[i] = treeInfos[j];
                treeInfos[j] = temp;
            }
        }
        for (i = 0; i < treeInfos.length; ++i) {
            if ("00000000-0000-0000-0000-0000000000094F2827FD".equals(treeInfos[i].getId().toString())) continue;
            model.addElement(treeInfos[i]);
        }
        this.cbxMain.setModel(model);
        if (model.getSize() > 0) {
            this.cbxMain.setSelectedIndex(0);
            OrgTreeInfo treeInfo = (OrgTreeInfo)this.cbxMain.getSelectedItem();
            this.currentOrgType = OrgVersionClientUtils.getOrgTypeFromTreeId(treeInfo.getId().toString());
        }
    }

    private void initVersionCombox() throws Exception {
        this.cbxVersion.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    try {
                        OUViewVersionListUI.this.buildTree();
                    }
                    catch (Exception e1) {
                        OUViewVersionListUI.this.handleException(e1);
                    }
                }
            }
        });
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        IOrgVersionMgrFacade orgVersionMgr = OrgVersionMgrFacadeFactory.getRemoteInstance();
        this.versionNumList = orgVersionMgr.getAllHistoryVersionNumbers();
        this.invalidDateList = orgVersionMgr.getAllHistoryInvalidDates();
        if (this.versionNumList.size() != this.invalidDateList.size()) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.basedata.org.OrgException", (String)"ORGVERSIONERR"));
            SysUtil.abort();
        }
        for (int i = 0; i < this.versionNumList.size(); ++i) {
            String dateString = OrgVersionClientUtils.getDisplayInvalidDate((Date)this.invalidDateList.get(i));
            model.addElement(dateString + "(" + this.versionNumList.get(i).toString() + ")");
        }
        this.cbxVersion.setModel(model);
        if (model.getSize() > 0) {
            this.versionNumber = (String)this.versionNumList.get(0);
            this.cbxVersion.setSelectedIndex(0);
        }
    }

    private void buildTree() throws Exception {
        this.versionNumber = (String)this.versionNumList.get(this.cbxVersion.getSelectedIndex());
        if (this.versionNumber == null) {
            this.treeMain.setModel(null);
            return;
        }
        OrgTreeInfo selectInfo = (OrgTreeInfo)this.cbxMain.getSelectedItem();
        if (selectInfo == null) {
            this.currentOrgType = null;
            this.treeMain.setModel(null);
            return;
        }
        this.currentOrgType = OrgVersionClientUtils.getOrgTypeFromTreeId(selectInfo.getId().toString());
        OrgUnitInfo versionInfo = OrgVersionClientUtils.getOrgUnitVersionInfo(this.currentOrgType, this.versionNumber, BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4"));
        if (versionInfo == null) {
            this.treeMain.setModel(null);
            return;
        }
        this.versionCol = OrgVersionClientUtils.getObjectVersionCollection(this.currentOrgType, this.versionNumber, versionInfo.getLongNumber());
        OrgVersionClientUtils.buildTree((JTree)this.treeMain, versionInfo, this.versionCol);
        this.treeMain.setSelectionNode((DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot());
    }

    @Override
    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        int rows;
        OrgUnitCollection versionCol = null;
        if (this.getSelectedTreeNode() != null && this.getSelectedTreeNode().getUserObject() != null) {
            OrgUnitInfo selectInfo = (OrgUnitInfo)this.getSelectedTreeNode().getUserObject();
            versionCol = OrgVersionClientUtils.getObjectVersionCollection(this.currentOrgType, this.versionNumber, selectInfo.getLongNumber());
        }
        this.tblMain.removeRows();
        this.tblMain.checkParsed();
        OrgTableHelper.addTalbeOrgCol(this.tblMain);
        if (versionCol != null) {
            OrgUnitInfo versionInfo = null;
            IRow row = null;
            for (int i = 0; i < versionCol.size(); ++i) {
                versionInfo = versionCol.get(i);
                row = this.tblMain.addRow();
                row.getCell("id").setValue((Object)versionInfo.getId());
                row.getCell("number").setValue((Object)versionInfo.getNumber());
                row.getCell("name").setValue((Object)versionInfo.getName());
                row.getCell("simpleName").setValue((Object)versionInfo.getSimpleName());
                row.getCell("description").setValue((Object)versionInfo.getDescription());
                OrgTableHelper.setTableRowValue(versionInfo, row);
            }
        }
        if ((rows = this.tblMain.getRowCount()) != 0) {
            this.tblMain.getSelectManager().select(0, 0);
        }
    }

    public KDTreeNode getSelectedTreeNode() {
        return (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.doView();
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1) {
            if (e.getClickCount() == 2) {
                this.doView();
            }
        } else {
            super.tblMain_tableClicked(e);
        }
    }

    private void doView() throws Exception {
        try {
            this.setCursor(3);
            Map context = this.getUIContext();
            context.put("Owner", this);
            String id = this.getSelectedKeyValue();
            if (id == null) {
                return;
            }
            OrgVersionClentHelper.doView(context, id, this.versionNumber);
        }
        catch (UIException ex1) {
            this.handleException((Exception)((Object)ex1));
        }
        finally {
            this.setCursor(0);
        }
    }

    private void setCursor(int curType) {
        Cursor cursor = Cursor.getPredefinedCursor(curType);
        SwingUtilities.getWindowAncestor((Component)((Object)this)).setCursor(cursor);
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
    }

    protected String getSelectedKeyValue() {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length > 0) {
            Object keyValue;
            int rowIndex = selectRows[0];
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell(this.getKeyFieldName());
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if ((keyValue = cell.getValue()) != null) {
                return keyValue.toString();
            }
        } else {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
        }
        return null;
    }

    protected String getKeyFieldName() {
        return "id";
    }

    @Override
    public void actionAdminF7_actionPerformed(ActionEvent e) throws Exception {
        OrgVersionF7PromptDialog adminVersionF7 = OrgTypeClientCenter.getInstance().getClientImp(OrgType.Admin).createHisF7ByCondition("", this.versionNumber);
        adminVersionF7.show();
    }

    @Override
    public void actionCompanyF7_actionPerformed(ActionEvent e) throws Exception {
        OrgVersionF7PromptDialog fiVersionF7 = OrgTypeClientCenter.getInstance().getClientImp(OrgType.Company).createHisF7ByCondition("", this.versionNumber);
        fiVersionF7.show();
    }
}

