/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgInnerFacade;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.IOrgTree;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgException;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.basedata.org.OrgInnerFacadeFactory;
import com.kingdee.eas.basedata.org.OrgSelect;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewFactory;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.OrgUnitTreePromptBox;
import com.kingdee.eas.basedata.org.client.tree.DefaultLNOrgTreeNodeCtrl;
import com.kingdee.eas.basedata.org.client.tree.IOrgTreeBuilder;
import com.kingdee.eas.basedata.org.client.tree.OrgTreeBuilderFactory;
import com.kingdee.eas.basedata.org.client.tree.OrgUnitNodeInfo;
import com.kingdee.eas.basedata.org.helper.OrgHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import javax.swing.JTree;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;

public class OrgClientUtils {
    private static final String INNER_FLAG = "$ResponseNode$";

    public static OrgUnitInfo[] showOrgUnitTree(OrgType[] orgTypes, boolean isMultiSelect) throws BOSException, EASBizException {
        return OrgClientUtils.showOrgUnitTree(null, orgTypes, isMultiSelect);
    }

    public static OrgUnitInfo[] showOrgUnitTree(IUIObject owner, OrgType[] orgTypes, boolean isMultiSelect, boolean isOrgChanged) throws BOSException, EASBizException {
        return OrgClientUtils.showOrgUnitFilterTree(owner, orgTypes, isMultiSelect, isOrgChanged);
    }

    private static OrgUnitInfo[] showOrgUnitFilterTree(IUIObject owner, OrgType[] orgTypes, boolean isMultiSelect, boolean isOrgChanged) {
        OrgUnitInfo[] infos = null;
        OrgUnitTreePromptBox boxCompany1 = new OrgUnitTreePromptBox(owner, orgTypes, null, null, isMultiSelect, false, false, isOrgChanged);
        boxCompany1.show();
        Object[] objArray = (Object[])boxCompany1.getData();
        if (objArray == null) {
            return new OrgUnitInfo[0];
        }
        infos = new OrgUnitInfo[objArray.length];
        for (int i = 0; i < objArray.length; ++i) {
            infos[i] = (OrgUnitInfo)objArray[i];
        }
        return infos;
    }

    public static OrgUnitInfo[] showOrgUnitTree(IUIObject owner, OrgType[] orgTypes, boolean isMultiSelect) throws BOSException, EASBizException {
        return OrgClientUtils.showOrgUnitTree(owner, orgTypes, null, null, isMultiSelect);
    }

    public static OrgUnitInfo[] showOrgUnitTree(IUIObject owner, OrgType[] orgTypes, OrgTreeInfo[] treeInfos, OrgSelect orgSelect, boolean isMultiSelect) throws BOSException, EASBizException {
        return OrgClientUtils.showOrgUnitTree(owner, orgTypes, treeInfos, orgSelect, isMultiSelect, false);
    }

    public static OrgUnitInfo[] showOrgUnitTree(IUIObject owner, OrgType[] orgTypes, OrgTreeInfo[] treeInfos, OrgSelect orgSelect, boolean isMultiSelect, boolean isCheckChildren) throws BOSException, EASBizException {
        OrgUnitInfo[] infos = null;
        OrgUnitTreePromptBox boxCompany1 = new OrgUnitTreePromptBox(owner, orgTypes, treeInfos, orgSelect, isMultiSelect, isCheckChildren);
        boxCompany1.show();
        Object[] objArray = (Object[])boxCompany1.getData();
        if (objArray == null) {
            return new OrgUnitInfo[0];
        }
        infos = new OrgUnitInfo[objArray.length];
        for (int i = 0; i < objArray.length; ++i) {
            infos[i] = (OrgUnitInfo)objArray[i];
        }
        return infos;
    }

    public static IOrgTreeBuilder cteateOrgTree(KDTree treeOrg, OrgType orgType, int initialLevel, int expandLevel, boolean isGroup) throws Exception {
        IOrgStructure iOrgStruc = null;
        iOrgStruc = OrgStructureFactory.getRemoteInstance();
        IOrgTree iOrgTree = OrgTreeFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(orgType.getValue())));
        filterInfo.getFilterItems().add(new FilterItemInfo("basic", (Object)new Integer(1)));
        view.setFilter(filterInfo);
        OrgTreeCollection orgInfosSource = iOrgTree.getOrgTreeCollection(view);
        if (orgInfosSource.size() == 0) {
            return null;
        }
        OrgTreeCollection orgInfos = OrgHelper.filterTreeCol(orgInfosSource);
        OrgTreeInfo treeInfo = orgInfos.get(0);
        DefaultLNOrgTreeNodeCtrl nodeCtrls = new DefaultLNOrgTreeNodeCtrl(iOrgStruc, treeInfo);
        IOrgTreeBuilder treeBuilder = OrgTreeBuilderFactory.createTreeBuilder(nodeCtrls, initialLevel, expandLevel, isGroup);
        treeBuilder.buildTree((JTree)treeOrg);
        return treeBuilder;
    }

    public static void setOrgPrompt(IUIObject obj, KDBizPromptBox promptBox, OrgType[] orgType, boolean isMultiSelect) {
        OrgClientUtils.setPromptBoxProp(promptBox, isMultiSelect);
        OrgUnitTreePromptBox boxCompany1 = new OrgUnitTreePromptBox(obj, orgType, isMultiSelect);
        promptBox.setSelector((KDPromptSelector)boxCompany1);
    }

    public static void setOrgPrompt(IUIObject obj, KDBizPromptBox promptBox, OrgType[] orgType, boolean isMultiSelect, boolean isOrgChanged) {
        OrgClientUtils.setPromptBoxProp(promptBox, isMultiSelect);
        OrgUnitTreePromptBox boxCompany1 = new OrgUnitTreePromptBox(obj, orgType, null, null, isMultiSelect, false, false, isOrgChanged);
        promptBox.setSelector((KDPromptSelector)boxCompany1);
    }

    public static void setOrgPrompt(IUIObject owner, KDBizPromptBox promptBox, OrgType[] orgType, OrgTreeInfo[] treeInfo, boolean isMultiSelect) {
        OrgClientUtils.setPromptBoxProp(promptBox, isMultiSelect);
        OrgUnitTreePromptBox boxCompany1 = new OrgUnitTreePromptBox(owner, orgType, treeInfo, isMultiSelect);
        promptBox.setSelector((KDPromptSelector)boxCompany1);
    }

    public static void setOrgPrompt(IUIObject owner, KDBizPromptBox promptBox, OrgType[] orgType, OrgTreeInfo[] treeInfo, boolean isMultiSelect, boolean isOrgChanged) {
        OrgClientUtils.setPromptBoxProp(promptBox, isMultiSelect);
        OrgUnitTreePromptBox boxCompany1 = new OrgUnitTreePromptBox(owner, orgType, treeInfo, null, isMultiSelect, false, false, isOrgChanged);
        promptBox.setSelector((KDPromptSelector)boxCompany1);
    }

    public static void setOrgPrompt(KDBizPromptBox promptBox, OrgType[] orgType, OrgTreeInfo[] treeInfo, boolean isMultiSelect) {
        OrgClientUtils.setPromptBoxProp(promptBox, isMultiSelect);
        OrgUnitTreePromptBox boxCompany1 = new OrgUnitTreePromptBox(orgType, treeInfo, isMultiSelect);
        promptBox.setSelector((KDPromptSelector)boxCompany1);
    }

    public static void setOrgPrompt(KDBizPromptBox promptBox, OrgType[] orgType, boolean isMultiSelect) {
        OrgClientUtils.setOrgPrompt(null, promptBox, orgType, isMultiSelect);
    }

    public static void setOrgPrompt(IUIObject obj, KDBizPromptBox promptBox, OrgType[] orgType, OrgTreeInfo[] treeInfos, OrgSelect orgSelect, boolean isMultiSelect) {
        OrgClientUtils.setPromptBoxProp(promptBox, isMultiSelect);
        OrgUnitTreePromptBox boxCompany1 = new OrgUnitTreePromptBox(obj, orgType, treeInfos, orgSelect, isMultiSelect);
        promptBox.setSelector((KDPromptSelector)boxCompany1);
    }

    public static void setOrgPrompt(IUIObject obj, KDBizPromptBox promptBox, OrgType[] orgType, OrgTreeInfo[] treeInfos, OrgSelect orgSelect, boolean isMultiSelect, boolean isOrgChanged) {
        OrgClientUtils.setPromptBoxProp(promptBox, isMultiSelect);
        OrgUnitTreePromptBox boxCompany1 = new OrgUnitTreePromptBox(obj, orgType, treeInfos, orgSelect, isMultiSelect, false, false, isOrgChanged);
        promptBox.setSelector((KDPromptSelector)boxCompany1);
    }

    public static void setOrgListPrompt(IUIObject obj, KDBizPromptBox promptBox, OrgType[] orgType, boolean isMultiSelect) {
        OrgClientUtils.setPromptBoxProp(promptBox, isMultiSelect);
        OrgUnitTreePromptBox boxCompany1 = new OrgUnitTreePromptBox(obj, orgType, isMultiSelect, true);
        promptBox.setSelector((KDPromptSelector)boxCompany1);
    }

    private static void setPromptBoxProp(KDBizPromptBox promptBox, boolean isMultiSelect) {
        promptBox.setEditFormat("$number$");
        promptBox.setDisplayFormat("$name$");
        promptBox.setEnabledMultiSelection(isMultiSelect);
    }

    public static void setOrgListPrompt(KDBizPromptBox promptBox, OrgType[] orgType, boolean isMultiSelect) {
        OrgClientUtils.setOrgListPrompt(null, promptBox, orgType, isMultiSelect);
    }

    public static OrgUnitInfo getPromptValue(KDBizPromptBox promptBox) {
        if (promptBox.getData() != null) {
            OrgUnitInfo obj = (OrgUnitInfo)promptBox.getData();
            return obj;
        }
        return null;
    }

    public static void setPromptValue(KDBizPromptBox promptBox, OrgUnitInfo unitInfo) {
        promptBox.setData((Object)unitInfo);
    }

    public static DefaultKingdeeTreeNode getAdminTree(OrgUnitInfo unitInfo) throws BOSException, EASBizException {
        if (unitInfo == null) {
            return null;
        }
        DefaultKingdeeTreeNode treeNode = OrgClientUtils.getRootTreeNode(OrgType.Admin, unitInfo, null, false);
        return treeNode;
    }

    public static DefaultKingdeeTreeNode getCompanyTree(OrgUnitInfo unitInfo) throws BOSException, EASBizException {
        if (unitInfo == null) {
            return null;
        }
        DefaultKingdeeTreeNode treeNode = OrgClientUtils.getRootTreeNode(OrgType.Company, unitInfo, null, false);
        return treeNode;
    }

    public static DefaultKingdeeTreeNode getUnionDebtTree(OrgUnitInfo unitInfo, OrgTreeInfo treeInfo, boolean isOneGrade) throws EASBizException, BOSException {
        String rootID = null;
        if (unitInfo != null) {
            rootID = unitInfo.getId().toString();
        }
        ObjectUuidPK ctrlUnitPK = new ObjectUuidPK(rootID);
        UserInfo user = (UserInfo)SysContext.getSysContext().getCurrentUser();
        ObjectUuidPK userPK = new ObjectUuidPK(user.getId());
        TreeModel treeModel = OrgF7InnerUtils.buildTreeModel((IObjectPK)ctrlUnitPK, (IObjectPK)userPK, OrgViewType.UNIONDEBT, treeInfo.getId().toString(), rootID, null, (ItemAction)null, false);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)treeModel.getRoot();
        return root;
    }

    public static OrgUnitInfo getOrgUnitFromTreeNode(DefaultKingdeeTreeNode node) {
        if (node == null) {
            return null;
        }
        if (node.getUserObject() instanceof OrgStructureInfo) {
            FullOrgUnitInfo org = ((OrgStructureInfo)node.getUserObject()).getUnit();
            try {
                if (org.isIsUnion()) {
                    return org;
                }
                if (org.isIsCompanyOrgUnit()) {
                    return NewOrgViewHelper.getOrgUnitInfo(null, org.getId().toString(), OrgType.Company);
                }
                if (org.isIsProfitOrgUnit()) {
                    return NewOrgViewHelper.getOrgUnitInfo(null, org.getId().toString(), OrgType.ProfitCenter);
                }
                return null;
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        } else {
            return null;
        }
        return null;
    }

    public static OrgStructureInfo getOrgStructureFromTreeNode(DefaultKingdeeTreeNode node) {
        if (node.getUserObject() instanceof OrgUnitNodeInfo) {
            OrgUnitNodeInfo info = (OrgUnitNodeInfo)node.getUserObject();
            return info.getStructureInfo();
        }
        return null;
    }

    private static DefaultKingdeeTreeNode makeNode(OrgUnitInfo info) {
        DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)(info.getNumber() + "(" + info.getName() + ")"));
        node.setUserObject((Object)info);
        return node;
    }

    private static void setNodeIcon(DefaultKingdeeTreeNode node, OrgType type) {
        switch (type.getValue()) {
            case 0: {
                node.setCustomIcon(EASResource.getIcon((String)"imgTree_adminorg"));
                break;
            }
            case 1: {
                node.setCustomIcon(EASResource.getIcon((String)"imgTree_company"));
                break;
            }
            case 2: {
                node.setCustomIcon(EASResource.getIcon((String)"imgTree_saleorg"));
                break;
            }
            case 3: {
                node.setCustomIcon(EASResource.getIcon((String)"imgTree_purchaseorg"));
                break;
            }
            case 4: {
                node.setCustomIcon(EASResource.getIcon((String)"imgTree_storageorg"));
                break;
            }
            case 5: {
                node.setCustomIcon(EASResource.getIcon((String)"imgTree_costcenter"));
                break;
            }
            case 6: {
                node.setCustomIcon(EASResource.getIcon((String)"imgTree_profitcenter"));
            }
        }
    }

    public static DefaultKingdeeTreeNode getOrgViewTreeNode(OrgViewType orgViewType) throws EASBizException, BOSException {
        DefaultKingdeeTreeNode root;
        OrgUnitCollection units = OrgViewFactory.getRemoteInstance().getOrgViewTree(orgViewType);
        if (units.size() == 0) {
            return null;
        }
        DefaultKingdeeTreeNode curNode = root = OrgClientUtils.makeNode(units.get(0));
        DefaultKingdeeTreeNode parent = null;
        int curLevel = OrgClientUtils.getLevel(curNode);
        for (int i = 1; i < units.size(); ++i) {
            parent = curLevel == (Integer)units.get(i).get("level") ? (DefaultKingdeeTreeNode)curNode.getParent() : (curLevel < (Integer)units.get(i).get("level") ? curNode : OrgClientUtils.getParent(curNode, curLevel - (Integer)units.get(i).get("level")));
            curNode = OrgClientUtils.makeNode(units.get(i));
            parent.add((MutableTreeNode)curNode);
            curLevel = (Integer)units.get(i).get("level");
        }
        return root;
    }

    private static DefaultKingdeeTreeNode getRootTreeNode(OrgType orgType, OrgUnitInfo unitInfo, OrgTreeInfo treeInfo, boolean isOneGrade) throws EASBizException, BOSException {
        DefaultKingdeeTreeNode root;
        IOrgInnerFacade inner = OrgInnerFacadeFactory.getRemoteInstance();
        IOrgStructure iStruc = OrgStructureFactory.getRemoteInstance();
        if (orgType.equals((Object)OrgType.Admin) || orgType.equals((Object)OrgType.Company)) {
            IOrgTree iOrgTree = OrgTreeFactory.getRemoteInstance();
            String treeId = OrgTypeInfoMgr.getInstance().getOrgTypeInfoByOrgType(orgType).getOrgTreeID();
            treeInfo = iOrgTree.getOrgTreeInfo((IObjectPK)new ObjectStringPK(treeId));
        }
        OrgStructureCollection col = null;
        if (isOneGrade) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)treeInfo.getId()));
            filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)unitInfo.getId()));
            view.setFilter(filter);
            view.getSelector().add(new SelectorItemInfo(""));
            view.getSelector().add(new SelectorItemInfo("unit"));
            view.getSelector().add(new SelectorItemInfo("unit.isGrouping"));
            OrgStructureCollection strucInfos = iStruc.getOrgStructureCollection(view);
            if (strucInfos.size() != 0) {
                EntityViewInfo view1 = new EntityViewInfo();
                FilterInfo filter1 = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)strucInfos.get(0).getId()));
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)strucInfos.get(0).getId()));
                filter.setMaskString("#0 or #1");
                view1.setFilter(filter1);
                view1.getSelector().add(new SelectorItemInfo("*"));
                view1.getSelector().add(new SelectorItemInfo("unit"));
                view1.getSorter().add(new SorterItemInfo("longNumber"));
                col = iStruc.getOrgStructureCollection(view1);
            }
        } else {
            col = inner.getChildren(treeInfo, unitInfo);
        }
        if (col == null || col.get(0) == null) {
            return null;
        }
        DefaultKingdeeTreeNode curNode = root = OrgClientUtils._makeNode(col.get(0));
        DefaultKingdeeTreeNode parent = null;
        int curLevel = OrgClientUtils.getLevel(curNode);
        for (int i = 1; i < col.size(); ++i) {
            parent = curLevel == col.get(i).getLevel() ? (DefaultKingdeeTreeNode)curNode.getParent() : (curLevel < col.get(i).getLevel() ? curNode : OrgClientUtils.getParent(curNode, curLevel - col.get(i).getLevel()));
            curNode = OrgClientUtils._makeNode(col.get(i));
            parent.add((MutableTreeNode)curNode);
            curLevel = col.get(i).getLevel();
        }
        return root;
    }

    private static int getLevel(DefaultKingdeeTreeNode node) {
        return (Integer)((OrgUnitInfo)node.getUserObject()).get("level");
    }

    private static DefaultKingdeeTreeNode getParent(DefaultKingdeeTreeNode node, int levelInteval) {
        DefaultKingdeeTreeNode parent = null;
        if (levelInteval == 0) {
            return (DefaultKingdeeTreeNode)node.getParent();
        }
        parent = (DefaultKingdeeTreeNode)node.getParent();
        return OrgClientUtils.getParent(parent, levelInteval - 1);
    }

    private static DefaultKingdeeTreeNode _makeNode(OrgStructureInfo info) {
        KDTreeNode node = new KDTreeNode((Object)info.getUnit());
        info.put(INNER_FLAG, node);
        info.getUnit().put("level", new Integer(info.getLevel()));
        return node;
    }

    public static void checkChangedParent(String oldLongNumber, KDBizPromptBox prompt) throws OrgException {
        if (oldLongNumber == null) {
            return;
        }
        String newLongNumber = "";
        OrgUnitInfo info = OrgClientUtils.getPromptValue(prompt);
        if (info != null) {
            newLongNumber = (String)info.get("LongNumber");
        }
        if (newLongNumber == null) {
            newLongNumber = "";
        }
        if (newLongNumber.indexOf(oldLongNumber) == 0) {
            throw new OrgException(OrgException.PARENTNODE_CANNOT_BE_CHILD);
        }
    }
}

