/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IKDPromptIsCUSelector;
import com.kingdee.bos.ctrl.extendcontrols.IKDPromptStringSelector;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.util.IObjectCol2List;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.INewOUInnerFacade;
import com.kingdee.eas.basedata.org.NewOUInnerFacadeFactory;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.DataPermParam;
import com.kingdee.eas.basedata.org.client.ORGF7TreeModelListener;
import com.kingdee.eas.basedata.org.client.ORGF7TreeNodeCheckBoxChangeListener;
import com.kingdee.eas.basedata.org.client.OrgF7UI2;
import com.kingdee.eas.basedata.org.client.ext.IOrgClientExt;
import com.kingdee.eas.basedata.org.client.ext.OrgClientExtHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.basedata.org.stepadd.StepAddParamInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.util.ToolUtils;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.IKDPromptSelector2;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public abstract class OrgF7PromptDialog
implements IKDPromptSelector2,
IKDPromptStringSelector,
IKDPromptIsCUSelector {
    protected static final String OrgF7_Resource_NAME = "com.kingdee.eas.basedata.org.client.OrgF7Resource";
    private static Logger logger = Logger.getLogger(OrgF7PromptDialog.class);
    static final String NOTITLE = "no title";
    protected Window owner = null;
    protected IUIObject uiOwner = null;
    protected OrgF7UI2 f7ui = null;
    protected OrgViewType[] orgViewTypes = null;
    protected String treeID = null;
    protected OrgTreeInfo selectedTree = null;
    protected HashMap displayOrgIds = null;
    protected Set checkedOrgIds = null;
    protected Set unchangeableOrgIds = null;
    protected String title = "no title";
    protected String rootUnitID = null;
    protected boolean isMultiRootUnits = false;
    protected List rootUnitIDList = null;
    protected IMetaDataPK uiPK = null;
    protected IMetaDataPK actionPK = null;
    protected ItemAction action = null;
    protected IObjectPK ctrlUnitPK = null;
    protected IObjectPK userPK = null;
    protected boolean multiSelect = false;
    protected boolean nonSelect = false;
    protected boolean usePerm = true;
    protected boolean useFilter = true;
    protected boolean isCUFilter = false;
    protected boolean isCUFilterIncludeSub = false;
    protected boolean invalidEnable = false;
    protected boolean isShowSub = false;
    protected boolean isContainSealUp = false;
    protected boolean isShowVirtual = false;
    protected boolean showAssistantOrg = false;
    protected boolean isShowAssistantOrgInUnion = false;
    protected boolean isCheckedAssistantOrgChkBox = false;
    private boolean isCumulate = false;
    protected boolean isUserDataPermission = false;
    protected String inputStr = null;
    protected HashMap allDisplayOrgIds = null;
    private DataPermParam dataPermParam = null;
    private int level = 0;
    private boolean isRevised = false;
    private EntityViewInfo viewForF7;
    private ORGF7TreeModelListener treeModelListener = null;
    protected boolean isSynCheck = false;
    private boolean cascadingSelectioin = false;
    private ORGF7TreeNodeCheckBoxChangeListener nodeChkChgListener = null;
    private String injectedCUID = null;
    private boolean useInputedHashMap = false;
    private boolean showChkShowAll = false;
    private String[] rootUnitIds = null;
    protected boolean isShowContainSealUp = false;
    private boolean displayAssistantOrgTree = false;
    private String _accountSchemaID = null;
    private DefaultKingdeeTreeNode virtualRoot = null;

    protected OrgF7PromptDialog() {
        this((Frame)null);
    }

    protected OrgF7PromptDialog(IUIObject _uiObject) {
        this.uiOwner = _uiObject;
        this.init();
    }

    protected OrgF7PromptDialog(Frame _owner) {
        this.owner = _owner;
        this.init();
    }

    protected OrgF7PromptDialog(Dialog _owner) {
        this.owner = _owner;
        this.init();
    }

    protected void init() {
    }

    protected void checkSelect(DefaultKingdeeTreeNode node) throws Exception {
    }

    protected void clipTreeModel(TreeModel model) {
    }

    protected void clipTreeModelByNumber(TreeModel model, OrgTreeInfo orgTreeInfo) {
        Object fieldObj = orgTreeInfo.get("filter_field");
        Object valueObj = orgTreeInfo.get("filter_value");
        Object isBluredObj = orgTreeInfo.get("filter_isBlured");
        if (fieldObj != null && isBluredObj != null && valueObj != null) {
            int field = (Integer)fieldObj;
            String value = valueObj.toString();
            boolean blured = (Boolean)isBluredObj;
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)model.getRoot();
            this.disableNodeByFilter(root, field, value, blured);
            OrgF7InnerUtils.clipTreeNodeByColor(root);
        }
    }

    protected void clipTreeModelByNumber2(TreeModel model, OrgTreeInfo orgTreeInfo) {
        Object fieldObj = orgTreeInfo.get("filter_field");
        Object valueObj = orgTreeInfo.get("filter_value");
        Object isBluredObj = orgTreeInfo.get("filter_isBlured");
        if (fieldObj != null && isBluredObj != null && valueObj != null) {
            int field = (Integer)fieldObj;
            String value = valueObj.toString();
            boolean blured = (Boolean)isBluredObj;
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)model.getRoot();
            this.disableNodeByFilter(root, field, value, blured);
        }
    }

    private void disableNodeByFilter(DefaultKingdeeTreeNode root, int field, String value, boolean blured) {
        if (root == null) {
            return;
        }
        FullOrgUnitInfo unitInfo = null;
        DefaultKingdeeTreeNode node = null;
        Enumeration nodeEnum = root.breadthFirstEnumeration();
        while (nodeEnum.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)nodeEnum.nextElement();
            Object obj = node.getUserObject();
            if (obj == null || !(obj instanceof OrgStructureInfo)) continue;
            unitInfo = ((OrgStructureInfo)obj).getUnit();
            String numberOrName = "";
            if (field == 1) {
                numberOrName = unitInfo.getNumber();
            } else if (field == 2) {
                numberOrName = unitInfo.getName();
            } else if (field == 5) {
                numberOrName = unitInfo.getCode();
            } else if (field == 6) {
                numberOrName = unitInfo.getSimpleName();
            } else if (field == 7) {
                numberOrName = unitInfo.getDescription();
            } else if (field == 4) {
                IOrgClientExt iOrgClientExt;
                try {
                    iOrgClientExt = OrgClientExtHelper.getClientOrgExt();
                }
                catch (EASBizException e) {
                    logger.error((Object)"error", (Throwable)e);
                    throw new IllegalArgumentException("get OrgClientExtHelper.getClientOrgExt() error!");
                }
                catch (BOSException e) {
                    logger.error((Object)"error", (Throwable)e);
                    throw new IllegalArgumentException("get OrgClientExtHelper.getClientOrgExt() error!");
                }
                numberOrName = iOrgClientExt.getLayerTypeInfoId(unitInfo);
            }
            if (StringUtils.isEmpty((String)numberOrName)) {
                OrgF7InnerUtils.disableTreeNode(node);
                continue;
            }
            if (blured) {
                if (numberOrName.indexOf(value) != -1) continue;
                OrgF7InnerUtils.disableTreeNode(node);
                continue;
            }
            if (numberOrName.equalsIgnoreCase(value)) continue;
            OrgF7InnerUtils.disableTreeNode(node);
        }
    }

    protected void checkTreeModel(TreeModel model) {
        if (this.checkedOrgIds == null || !this.multiSelect) {
            return;
        }
        this.checkTreeNode((DefaultKingdeeTreeNode)model.getRoot());
    }

    private void checkTreeNode(DefaultKingdeeTreeNode root) {
        OrgUnitInfo unitInfo = OrgF7InnerUtils.getUserObject(root);
        if (unitInfo != null) {
            String unitID = unitInfo.getId().toString();
            if (this.checkedOrgIds.contains(unitID) && OrgF7InnerUtils.isUserObjectEnable(root)) {
                root.setChecked(true);
            }
            if (this.unchangeableOrgIds != null && this.unchangeableOrgIds.contains(unitID)) {
                root.setCheckBoxEnabled(false);
            }
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            this.checkTreeNode(node);
        }
    }

    protected void prepareDisplayOrgIDs(OrgViewType orgViewType, OrgTreeInfo orgTreeInfo) throws Exception {
        if (this.usePerm) {
            if (this.ctrlUnitPK == null) {
                this.ctrlUnitPK = new ObjectUuidPK(this.getCurrentCUID());
            }
            if (this.userPK == null) {
                this.userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
            }
            ObjectUuidPK treePK = null;
            treePK = orgViewType.getValue() == 8 ? new ObjectUuidPK(orgTreeInfo.getId()) : new ObjectUuidPK(NewOrgViewHelper.convert2TreeId(orgViewType));
            this.displayOrgIds = this.isCUFilter ? OrgF7InnerUtils.getAuthorizedOrgViewIDs(this.ctrlUnitPK, this.isCUFilterIncludeSub, this.userPK, orgViewType, (IObjectPK)treePK, this.uiPK, this.actionPK) : OrgF7InnerUtils.getAuthorizedOrgViewIDs(this.userPK, orgViewType, (IObjectPK)treePK, this.uiPK, this.actionPK);
        } else if (this.isCUFilter) {
            String cuID = this.getCurrentCUID();
            FullOrgUnitCollection unitCol = null;
            if (this.isCUFilterIncludeSub) {
                INewOUInnerFacade iNOUI = NewOUInnerFacadeFactory.getRemoteInstance();
                unitCol = iNOUI.getTypedOrgsInSubCU(cuID, orgViewType.getValue(), orgTreeInfo.getId().toString());
            } else {
                OrgType curOrgType = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(orgViewType).getOrgType();
                String orgTypeField = " and orgTypeStr like  '%;" + curOrgType.getName() + ";%'";
                IFullOrgUnit iFull = FullOrgUnitFactory.getRemoteInstance();
                unitCol = iFull.getFullOrgUnitCollection("select id where CU.id = '" + cuID + "'" + orgTypeField);
            }
            if (this.useFilter && this.displayOrgIds != null) {
                HashMap newDisplayOrgIds = new HashMap();
                int n = unitCol.size();
                for (int i = 0; i < n; ++i) {
                    String key = unitCol.get(i).getId().toString();
                    if (!this.displayOrgIds.containsKey(key)) continue;
                    Object value = this.displayOrgIds.get(key);
                    newDisplayOrgIds.put(key, value);
                }
                this.displayOrgIds = newDisplayOrgIds;
            } else {
                HashMap<String, Boolean> ouOrgIds = new HashMap<String, Boolean>();
                int n = unitCol.size();
                for (int i = 0; i < n; ++i) {
                    FullOrgUnitInfo info = unitCol.get(i);
                    ouOrgIds.put(info.getId().toString(), Boolean.FALSE);
                }
                this.displayOrgIds = ouOrgIds;
                this.useFilter = true;
            }
        } else {
            if (!this.useInputedHashMap) {
                this.useFilter = false;
            }
            this.displayOrgIds = this.allDisplayOrgIds;
        }
        if (this.rootUnitID == null || this.rootUnitID.equals("11111111-1111-1111-1111-111111111111CCE7AED4")) {
            this.rootUnitID = "00000000-0000-0000-0000-000000000000CCE7AED4";
        }
    }

    protected void prepareDisplayOrgIDs() throws Exception {
        OrgViewType orgViewType = this.orgViewTypes[0];
        String orgTreeID = NewOrgViewHelper.convert2TreeId(orgViewType);
        if (orgViewType.getValue() == 10) {
            this.usePerm = false;
            this.useFilter = false;
        }
        if (this.usePerm) {
            if (this.ctrlUnitPK == null) {
                this.ctrlUnitPK = new ObjectUuidPK(this.getCurrentCUID());
            }
            if (this.userPK == null) {
                this.userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
            }
            ObjectUuidPK treePK = null;
            treePK = orgViewType.getValue() == 8 ? new ObjectUuidPK(orgTreeID) : new ObjectUuidPK(NewOrgViewHelper.convert2TreeId(orgViewType));
            this.displayOrgIds = this.isCUFilter ? OrgF7InnerUtils.getAuthorizedOrgViewIDs(this.ctrlUnitPK, this.isCUFilterIncludeSub, this.userPK, orgViewType, (IObjectPK)treePK, this.uiPK, this.actionPK) : OrgF7InnerUtils.getAuthorizedOrgViewIDs(this.userPK, orgViewType, (IObjectPK)treePK, this.uiPK, this.actionPK);
        } else if (this.isCUFilter) {
            String cuID = this.getCurrentCUID();
            FullOrgUnitCollection unitCol = null;
            if (this.isCUFilterIncludeSub) {
                INewOUInnerFacade NOUI = NewOUInnerFacadeFactory.getRemoteInstance();
                unitCol = NOUI.getTypedOrgsInSubCU(cuID, orgViewType.getValue(), orgTreeID);
            } else {
                OrgType curOrgType = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(orgViewType).getOrgType();
                String orgTypeField = " and orgTypeStr like  %;" + curOrgType.getName() + ";%";
                IFullOrgUnit iFull = FullOrgUnitFactory.getRemoteInstance();
                unitCol = iFull.getFullOrgUnitCollection("select id where CU.id = '" + cuID + "'" + orgTypeField);
            }
            if (this.useFilter && this.displayOrgIds != null) {
                HashMap newDisplayOrgIds = new HashMap();
                int n = unitCol.size();
                for (int i = 0; i < n; ++i) {
                    String key = unitCol.get(i).getId().toString();
                    if (!this.displayOrgIds.containsKey(key)) continue;
                    Object value = this.displayOrgIds.get(key);
                    newDisplayOrgIds.put(key, value);
                }
                this.displayOrgIds = newDisplayOrgIds;
            } else {
                HashMap<String, Boolean> ouOrgIds = new HashMap<String, Boolean>();
                int n = unitCol.size();
                for (int i = 0; i < n; ++i) {
                    FullOrgUnitInfo info = unitCol.get(i);
                    ouOrgIds.put(info.getId().toString(), Boolean.FALSE);
                }
                this.displayOrgIds = ouOrgIds;
                this.useFilter = true;
            }
        }
        if (this.rootUnitID == null || this.rootUnitID.equals("11111111-1111-1111-1111-111111111111CCE7AED4")) {
            this.rootUnitID = "00000000-0000-0000-0000-000000000000CCE7AED4";
        }
    }

    protected void prepareDisplayOrgIDs4DataPermission(OrgViewType orgViewType) throws Exception {
        List list = OrgF7InnerUtils.executeQueryForAsstAcct(null, orgViewType);
        this.intersectIdCollection(list);
    }

    private void intersectIdCollection(Collection coll) {
        if (coll == null) {
            return;
        }
        if (this.useFilter && this.displayOrgIds != null) {
            HashMap newDisplayOrgIds = new HashMap();
            for (String key : coll) {
                if (!this.displayOrgIds.containsKey(key)) continue;
                Object value = this.displayOrgIds.get(key);
                newDisplayOrgIds.put(key, value);
            }
            this.displayOrgIds = newDisplayOrgIds;
        } else {
            this.displayOrgIds = new HashMap();
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                this.displayOrgIds.put(iter.next(), Boolean.FALSE);
            }
            this.useFilter = true;
        }
    }

    public TreeModel getTreeModel(OrgViewType orgViewType, OrgTreeInfo orgTreeInfo) throws Exception {
        return this.getTreeModel(orgViewType, orgTreeInfo, this.isSimpleField());
    }

    public TreeModel getTreeModel(OrgViewType orgViewType, OrgTreeInfo orgTreeInfo, boolean isSimpleField) throws Exception {
        return this.buildTreeModel(orgViewType, orgTreeInfo, StepAddParamInfo.rootAllInstance, isSimpleField);
    }

    protected TreeModel buildTreeModel(OrgViewType orgViewType, OrgTreeInfo orgTreeInfo) throws Exception {
        return this.buildTreeModel(orgViewType, orgTreeInfo, StepAddParamInfo.rootAllInstance);
    }

    public TreeModel buildTreeModel(OrgViewType orgViewType, OrgTreeInfo orgTreeInfo, StepAddParamInfo stepAddParamInfo, boolean isSimpleField) throws Exception {
        if (this.isMultiRootUnits()) {
            return this.buildTreeModelForMultiRootUnits(orgViewType, orgTreeInfo);
        }
        this.prepareDisplayOrgIDs(orgViewType, orgTreeInfo);
        if (this.isUserDataPermission) {
            this.prepareDisplayOrgIDs4DataPermission(orgViewType);
        }
        this.clipDisplayOrgIdsByDataPerm();
        TreeModel treeModel = null;
        if (this.displayOrgIds != null && !this.displayOrgIds.isEmpty()) {
            stepAddParamInfo = StepAddParamInfo.rootAllInstance;
        }
        if ((treeModel = OrgF7InnerUtils.buildTreeModel(orgTreeInfo.getId().toString(), this.rootUnitID, this.displayOrgIds, this.useFilter, this.invalidEnable, this.isContainSealUp, this.isShowVirtual, this.level, this.isRevised, this.isShowAssistantOrgInUnion, isSimpleField, stepAddParamInfo)).getRoot() != null && ((DefaultKingdeeTreeNode)treeModel.getRoot()).getUserObject() != null) {
            OrgF7PromptDialog.checkNodeValid((DefaultKingdeeTreeNode)treeModel.getRoot());
        }
        if (stepAddParamInfo.isLoadAdd()) {
            this.clipTreeModel(treeModel);
        }
        this.clipTreeModelByNumber(treeModel, orgTreeInfo);
        this.handleOnlyADisabledRootOnTree(treeModel);
        this.callTreeModelListener(treeModel);
        this.setEntityViewInfoForCommitingInF7(treeModel);
        this.handleAssistantOrgs(treeModel);
        this.checkTreeModel(treeModel);
        NewOrgViewHelper.reBuildBySortCode(treeModel, orgTreeInfo);
        return treeModel;
    }

    public TreeModel buildTreeModel(OrgViewType orgViewType, OrgTreeInfo orgTreeInfo, StepAddParamInfo stepAddParamInfo) throws Exception {
        return this.buildTreeModel(orgViewType, orgTreeInfo, stepAddParamInfo, this.isSimpleField());
    }

    private void clipDisplayOrgIdsByDataPerm() {
        if (this.dataPermParam == null) {
            return;
        }
        String rule = null;
        try {
            rule = PermissionFactory.getRemoteInstance().getQueryPermissionSQL(this.dataPermParam.userId, this.dataPermParam.orgId, this.dataPermParam.permItem);
            String sql = "select id where id in (" + rule + ")";
            FullOrgUnitCollection orgList = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitCollection(sql);
            this.intersectIdCollection(ToolUtils.transCol2ListByPeroperty((AbstractObjectCollection)orgList, (IObjectCol2List)new IObjectCol2List(){

                public String getList(Object obj) {
                    return ((FullOrgUnitInfo)obj).getId().toString();
                }
            }));
        }
        catch (Exception e) {
            logger.error((Object)"error", (Throwable)e);
            ExceptionHandler.handle((Throwable)e);
        }
    }

    protected TreeModel buildTreeModelForMultiRootUnits(OrgViewType orgViewType, OrgTreeInfo orgTreeInfo) throws Exception {
        if (this.rootUnitIds != null && this.rootUnitIds.length != 0) {
            this.prepareDisplayOrgIDs(orgViewType, orgTreeInfo);
            if (this.isUserDataPermission) {
                this.prepareDisplayOrgIDs4DataPermission(orgViewType);
            }
            this.clipDisplayOrgIdsByDataPerm();
            TreeModel[] treeModels = new TreeModel[this.rootUnitIds.length];
            for (int i = 0; i < this.rootUnitIds.length; ++i) {
                TreeModel treeModel = OrgF7InnerUtils.buildTreeModel(orgTreeInfo.getId().toString(), this.rootUnitID, this.displayOrgIds, this.useFilter, this.invalidEnable, this.isContainSealUp, this.isShowVirtual, this.level, this.isRevised, this.isShowAssistantOrgInUnion);
                if (treeModel.getRoot() != null && ((DefaultKingdeeTreeNode)treeModel.getRoot()).getUserObject() != null) {
                    OrgF7PromptDialog.checkNodeValid((DefaultKingdeeTreeNode)treeModel.getRoot());
                }
                this.clipTreeModel(treeModel);
                this.clipTreeModelByNumber(treeModel, orgTreeInfo);
                this.handleOnlyADisabledRootOnTree(treeModel);
                this.callTreeModelListener(treeModel);
                this.checkTreeModel(treeModel);
                NewOrgViewHelper.reBuildBySortCode(treeModel, orgTreeInfo);
                treeModels[i] = treeModel;
            }
            DefaultKingdeeTreeNode rootNode = new DefaultKingdeeTreeNode();
            for (int i = 0; i < treeModels.length; ++i) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)treeModels[i].getRoot();
                rootNode.add((MutableTreeNode)node);
            }
            DefaultTreeModel model = new DefaultTreeModel((TreeNode)rootNode);
            this.handleAssistantOrgs(model);
            return model;
        }
        return new DefaultTreeModel(null);
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public boolean isRevised() {
        return this.isRevised;
    }

    public void setRevised(boolean isRevised) {
        this.isRevised = isRevised;
    }

    protected TreeModel buildTreeModelByLevel(OrgViewType orgViewType, OrgTreeInfo orgTreeInfo) throws Exception {
        this.prepareDisplayOrgIDs(orgViewType, orgTreeInfo);
        TreeModel treeModel = null;
        treeModel = OrgF7InnerUtils.buildTreeModel(orgTreeInfo.getId().toString(), this.rootUnitID, this.displayOrgIds, this.useFilter, this.invalidEnable, this.isContainSealUp, this.isShowVirtual, this.level, this.isRevised, this.isShowAssistantOrgInUnion);
        if (treeModel.getRoot() != null && ((DefaultKingdeeTreeNode)treeModel.getRoot()).getUserObject() != null) {
            this.checkTreeModel(treeModel);
            OrgF7PromptDialog.checkNodeValid((DefaultKingdeeTreeNode)treeModel.getRoot());
        }
        this.clipTreeModel(treeModel);
        this.clipTreeModelByNumber(treeModel, orgTreeInfo);
        this.handleOnlyADisabledRootOnTree(treeModel);
        this.callTreeModelListener(treeModel);
        this.setEntityViewInfoForCommitingInF7(treeModel);
        NewOrgViewHelper.reBuildBySortCode(treeModel, orgTreeInfo);
        this.setFolderImage((DefaultKingdeeTreeNode)treeModel.getRoot());
        return treeModel;
    }

    protected TreeModel buildTreeModelByLevel2(OrgViewType orgViewType, OrgTreeInfo orgTreeInfo) throws Exception {
        this.prepareDisplayOrgIDs(orgViewType, orgTreeInfo);
        TreeModel treeModel = null;
        treeModel = OrgF7InnerUtils.buildTreeModel2(orgTreeInfo.getId().toString(), this.rootUnitID, this.displayOrgIds, this.useFilter, this.invalidEnable, this.isContainSealUp, this.isShowVirtual, this.level, this.isRevised, false);
        if (treeModel.getRoot() != null && ((DefaultKingdeeTreeNode)treeModel.getRoot()).getUserObject() != null) {
            this.checkTreeModel(treeModel);
            OrgF7PromptDialog.checkNodeValid((DefaultKingdeeTreeNode)treeModel.getRoot());
        }
        this.clipTreeModel(treeModel);
        this.clipTreeModelByNumber2(treeModel, orgTreeInfo);
        this.handleOnlyADisabledRootOnTree2(treeModel);
        this.callTreeModelListener(treeModel);
        this.setEntityViewInfoForCommitingInF7(treeModel);
        NewOrgViewHelper.reBuildBySortCode(treeModel, orgTreeInfo);
        this.setFolderImage((DefaultKingdeeTreeNode)treeModel.getRoot());
        return treeModel;
    }

    private void setFolderImage(DefaultKingdeeTreeNode root) {
        if (root != null && root.getUserObject() != null) {
            int n = root.getChildCount();
            for (int i = 0; i < n; ++i) {
                this.setFolderImage((DefaultKingdeeTreeNode)root.getChildAt(i));
            }
            OrgStructureInfo structInfo = (OrgStructureInfo)root.getUserObject();
            if (!structInfo.isIsLeaf()) {
                root.setCustomIcon(EASResource.getIcon((String)"imgTree_folder_close"));
            }
        }
    }

    public EntityViewInfo getEntityViewInfoForCommitingInF7() throws Exception {
        return this.viewForF7;
    }

    private void setEntityViewInfoForCommitingInF7(TreeModel treeModel) {
        ArrayList al = new ArrayList();
        DefaultKingdeeTreeNode rootNode = (DefaultKingdeeTreeNode)treeModel.getRoot();
        if (rootNode != null) {
            Enumeration enu = rootNode.breadthFirstEnumeration();
            DefaultKingdeeTreeNode nd = null;
            OrgStructureInfo osi = null;
            int num = 0;
            HashSet<String> hs = new HashSet<String>();
            while (enu.hasMoreElements()) {
                nd = (DefaultKingdeeTreeNode)enu.nextElement();
                if (nd.getUserObject() == null) {
                    EntityViewInfo eviNoData = new EntityViewInfo();
                    FilterInfo fiNoData = new FilterInfo();
                    eviNoData.setFilter(fiNoData);
                    fiNoData.getFilterItems().add(new FilterItemInfo("id", (Object)"*"));
                    this.viewForF7 = eviNoData;
                    return;
                }
                if (OrgF7InnerUtils.isTreeNodeDisable(nd)) continue;
                osi = (OrgStructureInfo)nd.getUserObject();
                hs.add(osi.getUnit().getId().toString().trim());
                if (++num == 50) {
                    al.add(hs);
                    num = 0;
                    hs = new HashSet();
                    continue;
                }
                if (enu.hasMoreElements()) continue;
                al.add(hs);
            }
        }
        FilterInfo fi = new FilterInfo();
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(fi);
        FilterItemCollection fic = fi.getFilterItems();
        if (al.size() != 0) {
            StringBuffer msk = new StringBuffer("#0");
            fic.add(new FilterItemInfo("id", (Object)((HashSet)al.get(0)), CompareType.INCLUDE));
            int n = al.size();
            for (int i = 1; i < n; ++i) {
                fic.add(new FilterItemInfo("id", (Object)((HashSet)al.get(i)), CompareType.INCLUDE));
                msk.append(" or #" + i);
            }
            fi.setMaskString(msk.toString());
        } else {
            fic.add(new FilterItemInfo("id", (Object)"*"));
        }
        this.viewForF7 = evi;
    }

    public void addORGF7TreeModelListener(ORGF7TreeModelListener listener) {
        this.treeModelListener = listener;
    }

    public void removeORGF7TreeModelListener() {
        this.treeModelListener = null;
    }

    private void callTreeModelListener(TreeModel model) {
        if (this.treeModelListener != null) {
            this.treeModelListener.afterTreeModelBuilded(model);
        }
    }

    private void handleOnlyADisabledRootOnTree(TreeModel treeModel) {
        Object obj = treeModel.getRoot();
        if (obj != null) {
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)obj;
            OrgF7InnerUtils.clipTreeNodeByColor(root);
            if (root.getChildCount() == 0 && OrgF7InnerUtils.isTreeNodeDisable(root)) {
                root.setUserObject(null);
            }
        }
    }

    private void handleOnlyADisabledRootOnTree2(TreeModel treeModel) {
        DefaultKingdeeTreeNode root;
        Object obj = treeModel.getRoot();
        if (obj != null && (root = (DefaultKingdeeTreeNode)obj).getChildCount() == 0 && OrgF7InnerUtils.isTreeNodeDisable(root)) {
            root.setUserObject(null);
        }
    }

    public static final void checkNodeValid(DefaultKingdeeTreeNode root) {
        if (root != null) {
            OrgStructureInfo structInfo = (OrgStructureInfo)root.getUserObject();
            if (!structInfo.isIsValid()) {
                root.setTextColor(Color.lightGray);
                root.setCheckBoxEnabled(false);
                root.setCheckBoxVisible(false);
            }
            for (int i = 0; i < root.getChildCount(); ++i) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
                OrgF7PromptDialog.checkNodeValid(node);
            }
        }
    }

    protected void buildTypeCombox(KDComboBox cbOrgType) throws Exception {
        cbOrgType.removeAllItems();
        for (int i = 0; i < this.orgViewTypes.length; ++i) {
            cbOrgType.addItem((Object)this.orgViewTypes[i]);
        }
    }

    protected void buildTreeCombox(KDComboBox cbOrgTree) throws Exception {
        cbOrgTree.setVisible(false);
    }

    protected abstract OrgUnitInfo[] getTypedInfos(ArrayList var1);

    public void show() {
        try {
            if (this.uiOwner != null) {
                this.owner = ComponentUtil.getOwnerWindow((Component)((Component)this.uiOwner));
            }
            if (this.owner == null) {
                this.owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            }
            UIContext uiContext = new UIContext((Object)this.owner);
            uiContext.put((Object)"OrgF7Proxy", (Object)this);
            if (this.f7ui == null) {
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(OrgF7UI2.class.getName(), (Map)uiContext);
                this.f7ui = (OrgF7UI2)uiWindow.getUIObject();
                if (uiWindow instanceof Dialog) {
                    ((Dialog)uiWindow).setTitle(this.title);
                } else if (uiWindow instanceof Frame) {
                    ((Frame)uiWindow).setTitle(this.title);
                }
                if (this.showChkShowAll) {
                    this.f7ui.displayChkShowAll();
                }
            }
            if (this.inputStr != null && !"".equals(this.inputStr)) {
                this.f7ui.txtFieldValue.setText(this.inputStr);
                this.f7ui.btnSearch_actionPerformed(null);
            }
            this.f7ui.getUIWindow().show();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public boolean isCanceled() {
        if (this.f7ui == null) {
            return false;
        }
        return this.f7ui.isCancel();
    }

    public Object getData() {
        if (this.f7ui == null) {
            logger.info((Object)"OrgF7PromptDialog getData() f7 is null");
            return null;
        }
        ArrayList returnValue = this.f7ui.getReturnValue();
        if (returnValue == null || returnValue.size() == 0) {
            return null;
        }
        logger.info((Object)("OrgF7PromptDialog before getTypedInfos returnValue not null" + returnValue));
        OrgUnitInfo[] values = this.getTypedInfos(returnValue);
        if (values == null || values.length == 0) {
            return null;
        }
        if (this.isMultiSelect()) {
            logger.info((Object)"OrgF7PromptDialog return values MultiSelect");
            return values;
        }
        logger.info((Object)("OrgF7PromptDialog return values[0] ,singleSelect" + values[0]));
        return values[0];
    }

    public void setInputData(HashMap params) throws Exception {
    }

    public void setSynCheck(boolean isSynCheck) {
        this.cascadingSelectioin = false;
        this.nodeChkChgListener = null;
        this.isSynCheck = isSynCheck;
    }

    public boolean isSynCheck() {
        return this.isSynCheck;
    }

    public void setCascadingSelection(boolean cascadingSelection) {
        this.isSynCheck = false;
        this.nodeChkChgListener = null;
        this.cascadingSelectioin = cascadingSelection;
    }

    public boolean isCascadingSelection() {
        return this.cascadingSelectioin;
    }

    public void addORGF7TreeNodeCheckBoxChangeListener(ORGF7TreeNodeCheckBoxChangeListener listener) {
        this.isSynCheck = false;
        this.cascadingSelectioin = false;
        this.nodeChkChgListener = listener;
    }

    public ORGF7TreeNodeCheckBoxChangeListener getORGF7TreeNodeCheckBoxChangeListener() {
        return this.nodeChkChgListener;
    }

    public void removeORGF7TreeNodeCheckBoxChangeListener() {
        this.nodeChkChgListener = null;
    }

    public void refresh() {
        this.f7ui = null;
    }

    public void setSelectedTree(OrgTreeInfo treeInfo) {
        this.selectedTree = treeInfo;
    }

    public OrgTreeInfo getSelectedTree() {
        return this.selectedTree;
    }

    public void setTreeID(String treeID) {
        this.treeID = treeID;
    }

    public String getTreeID() {
        return this.treeID;
    }

    public void setTitle(String _title) {
        this.title = _title;
    }

    public String getTtile() {
        return this.title;
    }

    public void setIsCUFilter(boolean isCUFilter) {
        this.setIsCUFilter(isCUFilter, false);
    }

    public void setIsCUFilter(boolean isCUFilter, boolean isIncludeSub) {
        this.isCUFilter = isCUFilter;
        this.isCUFilterIncludeSub = isCUFilter ? isIncludeSub : false;
    }

    public boolean isCUFilter() {
        return this.isCUFilter;
    }

    public boolean isMultiSelect() {
        return this.multiSelect;
    }

    public void setMultiSelect(boolean multiSelect) {
        this.multiSelect = multiSelect;
    }

    public boolean isNonSelect() {
        return this.nonSelect;
    }

    public void setNonSelect(boolean nonSelect) {
        this.nonSelect = nonSelect;
    }

    public String getRootUnitID() {
        return this.rootUnitID;
    }

    public void setRootUnitID(String rootUnitID) {
        this.rootUnitID = rootUnitID;
    }

    public void setCuID(String cuID) {
        this.setRootUnitID(cuID);
    }

    public void setCurrentCUID(String cuID) {
        this.injectedCUID = cuID;
        this.refresh();
    }

    public String getCurrentCUID() {
        String cuID = null;
        cuID = this.injectedCUID != null && this.injectedCUID.trim().length() != 0 ? this.injectedCUID : SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        return cuID;
    }

    public boolean getIsShowSub() {
        return this.isShowSub;
    }

    public void setIsShowSub(boolean isShowSub) {
        this.isShowSub = isShowSub;
    }

    public boolean isContainSealUp() {
        return this.isContainSealUp;
    }

    public void setContainSealUp(boolean isContainSealUp) {
        this.isContainSealUp = isContainSealUp;
    }

    public boolean isShowVirtual() {
        return this.isShowVirtual;
    }

    public void setShowVirtual(boolean isShowVirtual) {
        this.isShowVirtual = isShowVirtual;
    }

    public boolean isShowAssistantOrgInUnion() {
        return this.isShowAssistantOrgInUnion;
    }

    public void setShowAssistantOrgInUnion(boolean isShowAssistantOrgInUnion) {
        this.isShowAssistantOrgInUnion = isShowAssistantOrgInUnion;
    }

    public void disablePerm(HashMap _map, boolean _useFilter) {
        this.usePerm = false;
        this.displayOrgIds = _map;
        this.allDisplayOrgIds = _map;
        this.useFilter = _useFilter;
        if (this.useFilter) {
            this.useInputedHashMap = true;
        }
    }

    public void disablePerm(HashMap _map) {
        this.disablePerm(_map, true);
    }

    public void disablePerm() {
        this.disablePerm(null, false);
    }

    public void setUIAction(IUIObject _targetUI, ItemAction _action) {
        if (_targetUI != null) {
            this.uiPK = _targetUI.getMetaDataPK();
        }
        if (_action != null) {
            this.actionPK = OrgF7InnerUtils.getActionPK(_action);
        }
    }

    public void setUIActionPK(IMetaDataPK _uiPK, IMetaDataPK _actionPK) {
        this.uiPK = _uiPK;
        this.actionPK = _actionPK;
    }

    public void setCheckedOrgIDs(Set checkedOrgIds) {
        this.checkedOrgIds = checkedOrgIds;
    }

    public void setUnChangeableOrgIDs(Set unchangeableOrgIds) {
        this.unchangeableOrgIds = unchangeableOrgIds;
    }

    public void setInvalidUnitEnable(boolean enable) {
        this.invalidEnable = enable;
    }

    public void showCheckBoxOfShowingAllOUs() {
        this.showChkShowAll = true;
    }

    public boolean isMultiRootUnits() {
        return this.isMultiRootUnits;
    }

    public void setMultiRootUnits(boolean isMultiRootUnits) {
        this.isMultiRootUnits = isMultiRootUnits;
    }

    public List getRootUnitIDList() {
        return this.rootUnitIDList;
    }

    public void setRootUnitIDList(List rootUnitIDList) throws Exception {
        if (rootUnitIDList == null || rootUnitIDList.size() == 0) {
            throw new IllegalArgumentException("id list can't be empty!");
        }
        this.rootUnitIDList = rootUnitIDList;
        try {
            this.rootUnitIds = this.getRootUnitIdsInDifferentTrees(rootUnitIDList);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private String[] getRootUnitIdsInDifferentTrees(List idList) throws Exception {
        int i;
        String[] ids = new String[idList.size()];
        Iterator iter = idList.iterator();
        int index = 0;
        while (iter.hasNext()) {
            ids[index++] = (String)iter.next();
        }
        StringBuffer oql = new StringBuffer("select id, longNumber where id in (");
        for (int i2 = 0; i2 < ids.length; ++i2) {
            if (i2 < ids.length - 1) {
                oql.append("'").append(ids[i2]).append("' , ");
                continue;
            }
            oql.append("'").append(ids[i2]).append("') order by longNumber");
        }
        IFullOrgUnit iFull = FullOrgUnitFactory.getRemoteInstance();
        FullOrgUnitCollection col = iFull.getFullOrgUnitCollection(oql.toString());
        Object[] infos = col.toArray();
        block2: for (i = 0; i < infos.length; ++i) {
            String longNumber = ((FullOrgUnitInfo)infos[i]).getLongNumber();
            for (int j = 0; j < i; ++j) {
                if (!longNumber.startsWith(((FullOrgUnitInfo)infos[j]).getLongNumber() + "!")) continue;
                col.remove((FullOrgUnitInfo)infos[i]);
                continue block2;
            }
        }
        infos = col.toArray();
        ids = new String[infos.length];
        for (i = 0; i < infos.length; ++i) {
            ids[i] = ((FullOrgUnitInfo)infos[i]).getId().toString();
        }
        return ids;
    }

    public void setIsShowContainSealUp(boolean isShowContainSealUp) {
        this.isShowContainSealUp = isShowContainSealUp;
    }

    public boolean isShowContainSealUp() {
        return this.isShowContainSealUp;
    }

    public void setPermissionItem(String permissionItem) {
        OrgType orgType = NewOrgViewHelper.convert(this.orgViewTypes[0]);
        ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId(orgType));
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        FullOrgUnitCollection unitCol = null;
        try {
            unitCol = PermissionFactory.getRemoteInstance().getAuthorizedOrg((IObjectPK)userPK, orgType, (IObjectPK)treePK, permissionItem);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            return;
        }
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        int size = unitCol.size();
        for (int i = 0; i < size; ++i) {
            result.put(unitCol.get(i).getId().toString(), Boolean.FALSE);
        }
        this.disablePerm(result, true);
    }

    public void setDataPermission(IObjectPK orgId, IObjectPK userId, String permItemName) {
        this.dataPermParam = new DataPermParam(orgId, userId, permItemName);
    }

    public void setDataPermission(String permItemName) {
        BOSUuid orgId = SysContext.getSysContext().getCurrentOrgUnit().getId();
        BOSUuid userId = SysContext.getSysContext().getCurrentUserInfo().getId();
        this.setDataPermission((IObjectPK)new ObjectUuidPK(orgId), (IObjectPK)new ObjectUuidPK(userId), permItemName);
    }

    public IObjectPK getUserPK() {
        return this.userPK;
    }

    public void setUserPK(IObjectPK userPK) {
        this.userPK = userPK;
    }

    public boolean isCheckedAssistantOrgChkBox() {
        return this.isCheckedAssistantOrgChkBox;
    }

    public void setCheckedAssistantOrgChkBox(boolean isCheckedAssistantOrgChkBox) {
        this.isCheckedAssistantOrgChkBox = isCheckedAssistantOrgChkBox;
    }

    public boolean isCumulate() {
        return this.isCumulate;
    }

    public void setCumulate(boolean isCumulate) {
        this.isCumulate = isCumulate;
    }

    public boolean isDisplayAssistantOrgTree() {
        return this.displayAssistantOrgTree;
    }

    public void setDisplayAssistantOrgTree(boolean displayAssistantOrgTree) {
        this.displayAssistantOrgTree = displayAssistantOrgTree;
    }

    public boolean isShowAssistantOrg() {
        return this.showAssistantOrg;
    }

    public void setShowAssistantOrg(boolean showAssistantOrg) {
        this.showAssistantOrg = showAssistantOrg;
    }

    protected void handleAssistantOrgs(TreeModel model) throws Exception {
        this.clipTreeModelByAssistantOrgs(model);
    }

    protected void clipTreeModelByAssistantOrgs(TreeModel model) throws Exception {
        if (this.displayAssistantOrgTree) {
            this.addAssistantOrgs(model);
            DefaultTreeModel treeModel = (DefaultTreeModel)model;
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)treeModel.getRoot();
            treeModel.setRoot((TreeNode)root);
        }
    }

    private void disableMainOrgUnitNode(DefaultKingdeeTreeNode root) {
        OrgStructureInfo structInfo;
        int n = root.getChildCount();
        for (int i = 0; i < n; ++i) {
            this.disableMainOrgUnitNode((DefaultKingdeeTreeNode)root.getChildAt(i));
        }
        Object obj = root.getUserObject();
        if (obj != null && !(structInfo = (OrgStructureInfo)obj).getUnit().isIsAssistantOrg()) {
            OrgF7InnerUtils.disableTreeNode(root);
        }
    }

    public void setAccountSchemaID(String accountSchemaID) {
        this._accountSchemaID = accountSchemaID;
    }

    protected void addAssistantOrgs(TreeModel model) throws Exception {
        this.addAssistantOrgs(model, this.isContainSealUp);
    }

    protected void addAssistantOrgs(TreeModel model, boolean isContainSealUp) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isAssistantOrg", (Object)new Integer(1)));
        IFullOrgUnit iFull = FullOrgUnitFactory.getRemoteInstance();
        FullOrgUnitCollection assistantOrgCol = null;
        if (!isContainSealUp) {
            filterInfo.getFilterItems().add(new FilterItemInfo("isOUSealUp", (Object)new Integer(0), CompareType.EQUALS));
        }
        ArrayList orgIDList = null;
        if (this._accountSchemaID != null) {
            orgIDList = iFull.getOrgIDbyAccountSchemeID(this._accountSchemaID);
            HashSet idSet = new HashSet(orgIDList);
            filterInfo.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        }
        viewInfo.setFilter(filterInfo);
        assistantOrgCol = iFull.getFullOrgUnitCollection(viewInfo);
        HashMap<String, ArrayList> mainAndAssistantMap = new HashMap<String, ArrayList>();
        for (int i = 0; i < assistantOrgCol.size(); ++i) {
            ArrayList list;
            FullOrgUnitInfo assistantOrgInfo = assistantOrgCol.get(i);
            String mainOrgId = assistantOrgInfo.getMainOrg().getId().toString();
            if (mainAndAssistantMap.containsKey(mainOrgId)) {
                list = (ArrayList)mainAndAssistantMap.get(mainOrgId);
                list.add(assistantOrgInfo);
                continue;
            }
            list = new ArrayList();
            list.add(assistantOrgInfo);
            mainAndAssistantMap.put(mainOrgId, list);
        }
        DefaultTreeModel treeModel = (DefaultTreeModel)model;
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)treeModel.getRoot();
        this.virtualRoot = null;
        this.addAssistantOrg(null, root, mainAndAssistantMap);
        ArrayList list = (ArrayList)mainAndAssistantMap.get(SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
        if (root.getChildCount() <= 0 && root.getUserObject() == null && list != null && !list.isEmpty()) {
            this.virtualRoot = new DefaultKingdeeTreeNode();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                FullOrgUnitInfo tmpFullOrgUnitInfo = (FullOrgUnitInfo)list.get(i);
                tmpFullOrgUnitInfo.put("treeType", new Integer(this.orgViewTypes[0].getValue()));
                OrgStructureInfo assistantStructInfo = new OrgStructureInfo();
                assistantStructInfo.setUnit(tmpFullOrgUnitInfo);
                DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)assistantStructInfo);
                this.virtualRoot.add((MutableTreeNode)node);
            }
        }
        if (this.virtualRoot != null) {
            treeModel.setRoot((TreeNode)this.virtualRoot);
        } else {
            treeModel.setRoot((TreeNode)root);
        }
    }

    private void addAssistantOrg(DefaultKingdeeTreeNode parent, DefaultKingdeeTreeNode node, HashMap mainAndAssistantMap) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.addAssistantOrg(node, (DefaultKingdeeTreeNode)node.getChildAt(i), mainAndAssistantMap);
        }
        OrgStructureInfo structInfo = (OrgStructureInfo)node.getUserObject();
        if (structInfo == null) {
            return;
        }
        boolean hasAssistant = false;
        FullOrgUnitInfo unitInfo = structInfo.getUnit();
        ArrayList list = (ArrayList)mainAndAssistantMap.get(unitInfo.getId().toString());
        if (list != null) {
            if (parent != null) {
                Integer treeType = (Integer)((OrgStructureInfo)node.getUserObject()).getUnit().get("treeType");
                for (FullOrgUnitInfo assistantOrgInfo : list) {
                    assistantOrgInfo.put("treeType", treeType);
                    OrgStructureInfo assistantStructInfo = new OrgStructureInfo();
                    assistantStructInfo.setUnit(assistantOrgInfo);
                    node.setText(assistantOrgInfo.getName());
                    node.setUserObject((Object)assistantStructInfo);
                    hasAssistant = true;
                }
            } else {
                this.virtualRoot = new DefaultKingdeeTreeNode();
                this.virtualRoot.add((MutableTreeNode)node);
                Integer treeType = (Integer)((OrgStructureInfo)node.getUserObject()).getUnit().get("treeType");
                for (FullOrgUnitInfo assistantOrgInfo : list) {
                    assistantOrgInfo.put("treeType", treeType);
                    OrgStructureInfo assistantStructInfo = new OrgStructureInfo();
                    assistantStructInfo.setUnit(assistantOrgInfo);
                    DefaultKingdeeTreeNode child = new DefaultKingdeeTreeNode((Object)assistantStructInfo);
                    this.virtualRoot.add((MutableTreeNode)child);
                    hasAssistant = true;
                }
            }
            if (this._accountSchemaID == null || hasAssistant) {
                // empty if block
            }
        }
    }

    public boolean isSimpleField() {
        return false;
    }

    public void setInputStringData(String arg0) throws Exception {
        this.inputStr = arg0;
    }
}

