/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.TreeExpansionAdapter;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeEvent;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgTree;
import com.kingdee.eas.basedata.org.IOrgUnitLayerType;
import com.kingdee.eas.basedata.org.ImportCompayFieldsEnum;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitLayerTypeCollection;
import com.kingdee.eas.basedata.org.OrgUnitLayerTypeFactory;
import com.kingdee.eas.basedata.org.OrgUnitLayerTypeInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.AbstractOrgF7UI2;
import com.kingdee.eas.basedata.org.client.OrgF7PromptDialog;
import com.kingdee.eas.basedata.org.client.OrgF7SelectException;
import com.kingdee.eas.basedata.org.client.ext.OrgClientExtHelper;
import com.kingdee.eas.basedata.org.client.helper.OuF7SetCacheHelper;
import com.kingdee.eas.basedata.org.client.tree.step.KDTreeOrgExt;
import com.kingdee.eas.basedata.org.client.tree.step.imp.StepAddAllTreeDataImp;
import com.kingdee.eas.basedata.org.client.tree.stepadd.StepAddEvent;
import com.kingdee.eas.basedata.org.client.uihelper.OrgTypeClientCenter;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.basedata.org.service.OrgCommonUtils;
import com.kingdee.eas.basedata.org.stepadd.StepAddParamInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.apache.log4j.Logger;

public class OrgF7UI2
extends AbstractOrgF7UI2 {
    private static Logger logger = Logger.getLogger(OrgF7UI2.class);
    public static final String FILTER_FIELD = "filter_field";
    public static final String FILTER_VALUE = "filter_value";
    public static final String FILTER_ISBLURED = "filter_isBlured";
    private OrgF7PromptDialog dialog;
    private boolean isCancel = true;
    private boolean typeOpenEvent;
    private boolean treeOpenEvent;
    private Set returnValue = null;
    private boolean loadAllData = false;
    private boolean loaded = false;
    private int level = 2;
    OrgViewType oldOrgType = null;
    private OuF7SetCacheHelper setCacheHelper = new OuF7SetCacheHelper();
    private boolean isInOnload = false;
    private boolean isSearched = false;

    public OrgF7UI2() throws Exception {
        DefaultTreeSelectionModel sm = new DefaultTreeSelectionModel();
        sm.setSelectionMode(2);
        this.tOrgTree.setSelectionModel((TreeSelectionModel)sm);
        this.tOrgTree.addTreeExpansionListener((TreeExpansionListener)new TreeExpansionAdapter(){

            public void treeCollapsed(TreeExpansionEvent event) {
                if (event.getPath().getLastPathComponent().equals(OrgF7UI2.this.tOrgTree.getModel().getRoot())) {
                    // empty if block
                }
            }
        });
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnAllSel.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnAllClr.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnSearch.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
        this.checkBlured.setSelected(true);
        this.comboField.addItem((Object)ImportCompayFieldsEnum.NUMBER);
        this.comboField.addItem((Object)ImportCompayFieldsEnum.NAME);
        this.comboField.addItem((Object)ImportCompayFieldsEnum.UNITTYPE);
        this.comboField.addItem((Object)ImportCompayFieldsEnum.CODE);
        this.comboField.addItem((Object)ImportCompayFieldsEnum.SIMPLENAME);
        this.comboField.addItem((Object)ImportCompayFieldsEnum.DESRIPTION);
        this.comboField.setSelectedIndex(0);
        this.chkIncludeChildren.setSelected(true);
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    OrgF7UI2.this.btnSearch_actionPerformed(null);
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Component)((Object)OrgF7UI2.this), (Throwable)ex);
                }
            }
        });
        this.initChkShowAll();
        this.levelSpinner.setVisible(false);
        this.kDLabel1.setVisible(false);
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        return super.prepareInit();
    }

    private void initChkShowAll() {
        this.chkShowAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    OrgF7UI2.this.btnRefresh_actionPerformed(null);
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Component)((Object)OrgF7UI2.this), (Throwable)ex);
                }
            }
        });
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tOrgTree.setModel((TreeModel)new DefaultTreeModel(null));
        this.dialog = (OrgF7PromptDialog)this.getUIContext().get("OrgF7Proxy");
        this.tOrgTree.setShowCheckBox(false);
        if (this.dialog.isMultiSelect()) {
            this.tOrgTree.setShowCheckBox(true);
            this.btnAllSel.setVisible(true);
            this.btnAllClr.setVisible(true);
            this.chkIncludeChildren.setVisible(true);
            if (this.dialog.isCascadingSelection()) {
                this.tOrgTree.addTreeNodeStateChangeListener(new TreeNodeStateChangeListener(){

                    public void nodeStateChange(TreeNodeStateChangeEvent event) {
                        OrgF7UI2.this.doTreeNodeStateChange(event);
                    }
                });
            } else if (this.dialog.getORGF7TreeNodeCheckBoxChangeListener() != null) {
                this.tOrgTree.addTreeNodeStateChangeListener(new TreeNodeStateChangeListener(){

                    public void nodeStateChange(TreeNodeStateChangeEvent event) {
                        OrgF7UI2.this.dialog.getORGF7TreeNodeCheckBoxChangeListener().onTreeNodeCheckBoxChange(OrgF7UI2.this.tOrgTree, (DefaultKingdeeTreeNode)event.getNode());
                    }
                });
            } else {
                this.tOrgTree.setSyncChecked(this.dialog.isSynCheck());
            }
        }
        this.typeOpenEvent = false;
        this.dialog.buildTypeCombox(this.cbOrgType);
        this.typeOpenEvent = true;
        this.cbOrgTree.setEditable(false);
        this.cbOrgType.setEditable(false);
        if ((OrgViewType)((Object)this.cbOrgType.getSelectedItem()) == OrgViewType.UNIONDEBT) {
            this.cbOrgType.setVisible(false);
        }
        this.chkContainSealUp.setVisible(this.dialog.isShowContainSealUp());
        this.chkShowVirtual.setVisible(false);
        this.levelSpinner.setValue((Object)new Integer(2));
        ((SpinnerNumberModel)this.levelSpinner.getModel()).setMinimum(new Integer(0));
        ((SpinnerNumberModel)this.levelSpinner.getModel()).setMaximum(new Integer(100));
        if (!this.chkContainSealUp.isVisible()) {
            this.chkIncludeChildren.setBounds(new Rectangle(120, 496, 107, 19));
        }
    }

    private void loadNode(DefaultKingdeeTreeNode tmp, int level) throws Exception {
        if (this.loadAllData) {
            return;
        }
        OrgStructureInfo orgInfo = (OrgStructureInfo)tmp.getUserObject();
        if (orgInfo == null) {
            return;
        }
        StepAddEvent event = new StepAddEvent();
        event.setCurLongNumber(orgInfo.getLongNumber());
        event.setCurNode(tmp);
        event.setCurLevel(level);
        event.setIDataProvider(new StepAddAllTreeDataImp());
        event.setFetchTwoLayerData(true);
        OrgTreeInfo orgTreeInfo = (OrgTreeInfo)this.cbOrgTree.getSelectedItem();
        OrgViewType orgViewType = (OrgViewType)((Object)this.cbOrgType.getSelectedItem());
        event.setParam("orgViewType", (Object)orgViewType);
        event.setParam("orgTreeInfo", orgTreeInfo);
        event.setParam("dialog", this.dialog);
        KDTreeOrgExt sourceTreeExt = new KDTreeOrgExt(this.tOrgTree);
        logger.info((Object)"begin load stepAddData");
        sourceTreeExt.stepAddData(event);
    }

    private void onload_stepAddTreeData() {
        this.tOrgTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (e.getClickCount() != 1) {
                        return;
                    }
                    DefaultKingdeeTreeNode tmp = (DefaultKingdeeTreeNode)OrgF7UI2.this.tOrgTree.getLastSelectedPathComponent();
                    if (tmp == null) {
                        logger.info((Object)"not mouse double click event, return");
                        return;
                    }
                    OrgStructureInfo orgInfo = (OrgStructureInfo)tmp.getUserObject();
                    OrgF7UI2.this.loadNode(tmp, StepAddEvent.getLongNumberLevel(orgInfo.getLongNumber()));
                }
                catch (Exception e1) {
                    logger.info((Object)"error", (Throwable)e1);
                }
            }
        });
        this.tOrgTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                DefaultKingdeeTreeNode tmp = (DefaultKingdeeTreeNode)event.getPath().getLastPathComponent();
                if (tmp == null) {
                    logger.info((Object)"not mouse double click event, return");
                    return;
                }
                OrgStructureInfo orgInfo = (OrgStructureInfo)tmp.getUserObject();
                try {
                    OrgF7UI2.this.loadNode(tmp, StepAddEvent.getLongNumberLevel(orgInfo.getLongNumber()));
                }
                catch (Exception e) {
                    logger.error((Object)"error", (Throwable)e);
                }
            }
        });
    }

    private void doTreeNodeStateChange(TreeNodeStateChangeEvent event) {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)event.getNode();
        boolean selected = node.isChecked();
        this.selectAllChildrenOfTheSelectedNode(node, selected);
        this.tOrgTree.repaint();
    }

    private void selectAllChildrenOfTheSelectedNode(DefaultKingdeeTreeNode node, boolean selected) {
        DefaultKingdeeTreeNode subNode = null;
        int n = node.getChildCount();
        for (int i = 0; i < n; ++i) {
            subNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
            if (this.canTheNodeBeSelected(subNode)) {
                subNode.setChecked(selected);
            }
            this.selectAllChildrenOfTheSelectedNode(subNode, selected);
        }
    }

    private boolean canTheNodeBeSelected(DefaultKingdeeTreeNode node) {
        return node.isCheckBoxVisible() && node.isCheckBoxEnabled();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.cbOrgType.setSelectedItem(null);
        if (this.cbOrgType.getItemCount() > 0) {
            this.cbOrgType.setSelectedIndex(0);
        }
    }

    public void doLayout() {
        super.doLayout();
        this.tOrgTree.requestFocusInWindow();
        if (this.tOrgTree.getModel() != null && this.tOrgTree.getModel().getRoot() != null) {
            this.tOrgTree.setSelectionNode((DefaultKingdeeTreeNode)this.tOrgTree.getModel().getRoot());
        }
    }

    @Override
    protected void cbOrgType_itemStateChanged(ItemEvent e) throws Exception {
        if (!this.typeOpenEvent) {
            return;
        }
        super.cbOrgType_itemStateChanged(e);
        if (e.getStateChange() != 1) {
            return;
        }
        this.oldOrgType = (OrgViewType)((Object)this.cbOrgType.getSelectedItem());
        if (this.dialog != null && this.dialog.isCumulate()) {
            Set valueSet = this.setCacheHelper.getSetByF7Type(this.oldOrgType);
            valueSet.clear();
            this.saveReturnValues(valueSet);
            this.oldOrgType = (OrgViewType)((Object)this.cbOrgType.getSelectedItem());
            this.isSearched = false;
        }
        this.setChkShowVirtualStatus();
        this.setChkShowAssistantOrgStatus();
        this.treeOpenEvent = false;
        this.fillOrgTreeComboBox();
        this.treeOpenEvent = true;
        this.dialog.buildTreeCombox(this.cbOrgTree);
        this.cbOrgTree.setSelectedItem(null);
        if (this.cbOrgTree.getItemCount() > 0) {
            this.cbOrgTree.setSelectedIndex(0);
        }
        if (this.dialog.getTtile().equals("no title")) {
            if (this.uiWindow instanceof Dialog) {
                ((Dialog)this.uiWindow).setTitle(this.cbOrgType.getSelectedItem().toString());
            } else if (this.uiWindow instanceof Frame) {
                ((Frame)this.uiWindow).setTitle(this.cbOrgType.getSelectedItem().toString());
            }
        }
    }

    private void saveReturnValues(Set returnSet) throws Exception {
        try {
            if (this.dialog.isMultiSelect()) {
                DefaultKingdeeTreeNode root;
                if (this.tOrgTree.getModel() != null && (root = (DefaultKingdeeTreeNode)this.tOrgTree.getModel().getRoot()) != null) {
                    this.traceNode(root, returnSet);
                }
            } else {
                if (this.tOrgTree == null) {
                    return;
                }
                TreePath path = this.tOrgTree.getSelectionPath();
                if (path != null) {
                    DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
                    if (OrgF7InnerUtils.isTreeNodeDisable(node)) {
                        throw OrgF7SelectException.SelectValidOrg;
                    }
                    if (node.getUserObject() != null && node.getUserObject() instanceof OrgStructureInfo) {
                        this.dialog.checkSelect(node);
                        returnSet.add(((OrgStructureInfo)node.getUserObject()).getUnit());
                    }
                }
            }
        }
        catch (OrgF7SelectException f7e) {
            logger.info((Object)"OrgF7UI2 select Date is null");
        }
    }

    private void traceNode(DefaultKingdeeTreeNode root, Set list) throws Exception {
        Enumeration enumOrg = root.breadthFirstEnumeration();
        while (enumOrg.hasMoreElements()) {
            DefaultKingdeeTreeNode objNode = (DefaultKingdeeTreeNode)enumOrg.nextElement();
            Object obj = objNode.getUserObject();
            if (!(obj instanceof OrgStructureInfo) || !objNode.isChecked()) continue;
            this.dialog.checkSelect(objNode);
            list.add(((OrgStructureInfo)objNode.getUserObject()).getUnit());
        }
    }

    private void setChkShowVirtualStatus() {
        OrgViewType orgViewType = (OrgViewType)((Object)this.cbOrgType.getSelectedItem());
        if (orgViewType == null) {
            return;
        }
        if (0 == orgViewType.getValue()) {
            this.chkShowVirtual.setVisible(true);
            this.comboField.removeItem((Object)ImportCompayFieldsEnum.UNITTYPE);
            this.comboField.addItem((Object)ImportCompayFieldsEnum.UNITTYPE);
        } else {
            this.chkShowVirtual.setVisible(false);
            this.comboField.removeItem((Object)ImportCompayFieldsEnum.UNITTYPE);
        }
    }

    private void setChkShowAssistantOrgStatus() {
        OrgViewType orgViewType = (OrgViewType)((Object)this.cbOrgType.getSelectedItem());
        if (orgViewType == null) {
            return;
        }
        if (this.dialog.isShowAssistantOrg() && (1 == orgViewType.getValue() || 8 == orgViewType.getValue())) {
            this.chkShowAssistantOrg.setVisible(true);
            this.chkShowAssistantOrg.setSelected(this.dialog.isCheckedAssistantOrgChkBox());
        } else {
            this.chkShowAssistantOrg.setVisible(false);
            this.chkShowAssistantOrg.setSelected(false);
        }
    }

    @Override
    protected void cbOrgTree_itemStateChanged(ItemEvent e) throws Exception {
        OrgTypeInfo curOrgTypeInfo;
        if (!this.treeOpenEvent) {
            return;
        }
        super.cbOrgTree_itemStateChanged(e);
        if (e != null && e.getStateChange() != 1) {
            return;
        }
        if (this.cbOrgTree.getSelectedItem() == null || this.cbOrgTree.getSelectedItem().equals("")) {
            return;
        }
        OrgTreeInfo orgTreeInfo = (OrgTreeInfo)this.cbOrgTree.getSelectedItem();
        OrgViewType orgViewType = (OrgViewType)((Object)this.cbOrgType.getSelectedItem());
        if (this.dialog.isCumulate()) {
            Set returnAllOrgIDs = this.getAllCheckedOrgSet(true);
            if (this.isInOnload && this.dialog.checkedOrgIds != null) {
                returnAllOrgIDs.addAll(this.dialog.checkedOrgIds);
            }
            if (returnAllOrgIDs.size() > 0) {
                this.dialog.setCheckedOrgIDs(returnAllOrgIDs);
            }
        }
        this.dialog.setSelectedTree(orgTreeInfo);
        String value = this.txtFieldValue.getText() == null || this.txtFieldValue.getText().trim().length() == 0 ? null : this.txtFieldValue.getText().trim();
        int field = ((ImportCompayFieldsEnum)((Object)this.comboField.getSelectedItem())).getValue();
        boolean isBlured = this.checkBlured.isSelected();
        orgTreeInfo.put(FILTER_FIELD, new Integer(field));
        if (value != null) {
            orgTreeInfo.put(FILTER_VALUE, value);
        } else {
            orgTreeInfo.remove(FILTER_VALUE);
        }
        orgTreeInfo.put(FILTER_ISBLURED, new Boolean(isBlured));
        TreeModel treeModel = null;
        treeModel = this.dialog.buildTreeModel(orgViewType, orgTreeInfo, StepAddParamInfo.rootAllInstance, true);
        this.loadAllData = true;
        this.tOrgTree.setModel(treeModel);
        if (treeModel.getRoot() == null || ((DefaultKingdeeTreeNode)treeModel.getRoot()).getUserObject() == null) {
            this.tOrgTree.setRootVisible(false);
        } else {
            this.tOrgTree.setRootVisible(true);
        }
        this.tOrgTree.setShowsRootHandles(true);
        this.kDLabel1.setVisible(false);
        this.levelSpinner.setVisible(false);
        if (treeModel.getRoot() != null && ((DefaultKingdeeTreeNode)treeModel.getRoot()).getUserObject() instanceof OrgStructureInfo && orgViewType != null && (curOrgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(orgViewType)) != null && curOrgTypeInfo.isBasicOrgType()) {
            this.kDLabel1.setVisible(true);
            this.levelSpinner.setVisible(true);
        }
    }

    private void fillOrgTreeComboBox() throws Exception {
        IOrgTree iOrgTree = OrgTreeFactory.getRemoteInstance();
        OrgTreeCollection treeCol = new OrgTreeCollection();
        OrgViewType orgViewType = (OrgViewType)((Object)this.cbOrgType.getSelectedItem());
        if (orgViewType == null) {
            return;
        }
        OrgType curOrgType = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(OrgViewType.getEnum(orgViewType.getValue())).getOrgType();
        if (!OrgCommonUtils.isBasicOrgType(curOrgType)) {
            boolean isVersion = false;
            Object proxy = this.getUIContext().get("OrgF7Proxy");
            treeCol = OrgClientExtHelper.getClientOrgExt().getOrgTreeCol(proxy);
        } else {
            OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(orgViewType);
            treeCol.add(iOrgTree.getOrgTreeInfo((IObjectPK)new ObjectUuidPK(orgTypeInfo.getOrgTreeID())));
        }
        this.cbOrgTree.removeAllItems();
        for (int i = 0; i < treeCol.size(); ++i) {
            if (this.dialog.treeID != null) {
                if (!treeCol.get(i).getId().toString().equals(this.dialog.treeID)) continue;
                this.cbOrgTree.addItem((Object)treeCol.get(i));
                break;
            }
            this.cbOrgTree.addItem((Object)treeCol.get(i));
        }
    }

    private void traceNode(DefaultKingdeeTreeNode root, ArrayList list) throws Exception {
        if (root.getUserObject() instanceof OrgStructureInfo && root.isChecked()) {
            this.dialog.checkSelect(root);
            list.add(((OrgStructureInfo)root.getUserObject()).getUnit());
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            this.traceNode(node, list);
        }
    }

    public void displayChkShowAll() {
        this.chkShowAll.setVisible(true);
        this.chkShowAll.setSelected(!this.dialog.isCUFilter());
    }

    public void displayChkShowAssistantOrg() {
    }

    public ArrayList getReturnValue() {
        if (this.returnValue == null) {
            return null;
        }
        return new ArrayList(this.returnValue);
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.isCancel = true;
        this.getUIWindow().close();
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        super.btnOk_actionPerformed(e);
        if (this.returnValue == null) {
            this.returnValue = new HashSet();
        } else {
            this.returnValue.clear();
        }
        this.saveReturnValues(this.returnValue);
        if (this.dialog != null && this.dialog.isCumulate()) {
            Set allCheckedOrgs = this.getAllCheckedOrgSet(false);
            if (!this.isSearched) {
                Set currentTypeOrgs = this.setCacheHelper.getSetByF7Type(this.oldOrgType);
                allCheckedOrgs.removeAll(currentTypeOrgs);
            }
            this.returnValue.addAll(allCheckedOrgs);
        }
        this.isSearched = false;
        try {
            if (this.returnValue.size() == 0 && !this.dialog.isNonSelect()) {
                throw OrgF7SelectException.SelectOne;
            }
            this.isCancel = false;
            this.getUIWindow().close();
        }
        catch (OrgF7SelectException f7e) {
            MsgBox.showInfo((Component)((Object)this), (String)f7e.getMsg());
        }
    }

    private Set getAllCheckedOrgSet(boolean isOrgIDs) {
        HashSet<String> retSet = new HashSet<String>();
        List orgType4F7List = OrgViewType.getEnumList();
        for (int i = 0; i < orgType4F7List.size(); ++i) {
            OrgViewType curOrgType4F7 = (OrgViewType)((Object)orgType4F7List.get(i));
            Set curSet = this.setCacheHelper.getSetByF7Type(curOrgType4F7);
            if (curSet.size() <= 0) continue;
            if (isOrgIDs) {
                Iterator it = curSet.iterator();
                while (it.hasNext()) {
                    retSet.add(((FullOrgUnitInfo)it.next()).getId().toString());
                }
                continue;
            }
            retSet.addAll(curSet);
        }
        return retSet;
    }

    @Override
    protected void btnRefresh_actionPerformed(ActionEvent e) throws Exception {
        if (this.chkShowAll.isVisible()) {
            this.dialog.setIsCUFilter(!this.chkShowAll.isSelected());
        }
        if (this.cbOrgType.getItemCount() > 0) {
            this.cbOrgType.setSelectedIndex(0);
        }
        this.chkShowAssistantOrg_itemStateChanged(null);
        this.tOrgTree.requestFocusInWindow();
    }

    @Override
    protected void chkContainSealUp_itemStateChanged(ItemEvent e) throws Exception {
        super.chkContainSealUp_itemStateChanged(e);
        if (this.chkContainSealUp.isSelected()) {
            this.dialog.setContainSealUp(true);
        } else {
            this.dialog.setContainSealUp(false);
        }
        this.cbOrgTree_itemStateChanged(null);
    }

    @Override
    protected void chkShowVirtual_itemStateChanged(ItemEvent e) throws Exception {
        super.chkShowVirtual_itemStateChanged(e);
        if (this.chkShowVirtual.isSelected()) {
            this.dialog.setShowVirtual(true);
        } else {
            this.dialog.setShowVirtual(false);
        }
        this.cbOrgTree_itemStateChanged(null);
    }

    @Override
    protected void chkShowAssistantOrg_itemStateChanged(ItemEvent e) throws Exception {
        super.chkShowAssistantOrg_itemStateChanged(e);
        OrgViewType orgViewType = (OrgViewType)((Object)this.cbOrgType.getSelectedItem());
        if (8 == orgViewType.getValue()) {
            if (this.chkShowAssistantOrg.isSelected()) {
                this.dialog.setShowAssistantOrgInUnion(true);
            } else {
                this.dialog.setShowAssistantOrgInUnion(false);
            }
        } else if (this.chkShowAssistantOrg.isSelected()) {
            this.dialog.setDisplayAssistantOrgTree(true);
        } else {
            this.dialog.setDisplayAssistantOrgTree(false);
        }
        this.cbOrgTree_itemStateChanged(null);
    }

    @Override
    protected void btnAllSel_actionPerformed(ActionEvent e) throws Exception {
        this.doAllSelAndAllClr(true);
    }

    @Override
    protected void btnAllClr_actionPerformed(ActionEvent e) throws Exception {
        this.doAllSelAndAllClr(false);
    }

    private void doAllSelAndAllClr(boolean selected) throws Exception {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.tOrgTree.getModel().getRoot();
        if (this.tOrgTree.getSelectionPath() != null) {
            root = (DefaultKingdeeTreeNode)this.tOrgTree.getSelectionPath().getLastPathComponent();
        }
        if (root == null) {
            return;
        }
        this.loadNode(root, -1);
        if (this.chkIncludeChildren.isSelected()) {
            Enumeration nodeEnum = root.breadthFirstEnumeration();
            DefaultKingdeeTreeNode node = null;
            while (nodeEnum.hasMoreElements()) {
                node = (DefaultKingdeeTreeNode)nodeEnum.nextElement();
                if (!this.canTheNodeBeSelected(node)) continue;
                node.setChecked(selected);
            }
        } else {
            root.setChecked(selected);
            if (root.getParent() != null) {
                DefaultKingdeeTreeNode node = null;
                for (int i = 0; i < root.getParent().getChildCount(); ++i) {
                    node = (DefaultKingdeeTreeNode)root.getParent().getChildAt(i);
                    if (!this.canTheNodeBeSelected(node)) continue;
                    node.setChecked(selected);
                }
            }
        }
        this.tOrgTree.repaint();
    }

    @Override
    protected void tOrgTree_focusGained(FocusEvent e) throws Exception {
    }

    @Override
    protected void tOrgTree_mouseClicked(MouseEvent e) throws Exception {
        super.tOrgTree_mouseClicked(e);
        TreePath path = this.tOrgTree.getClosestPath(e.getX(), e.getY());
        if (path == null) {
            return;
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        if (node == null) {
            return;
        }
        if (this.dialog.isMultiSelect()) {
            return;
        }
        if (e.getClickCount() == 2) {
            this.btnOk_actionPerformed(null);
        }
    }

    @Override
    protected void comboField_itemStateChanged(ItemEvent e) throws Exception {
        int field = ((ImportCompayFieldsEnum)((Object)this.comboField.getSelectedItem())).getValue();
        if (field == 4) {
            this.txtFieldValue.setVisible(false);
            this.cbUnitLayerType.setVisible(true);
            this.checkBlured.setSelected(false);
            this.checkBlured.setEnabled(false);
            this.loadLayerType();
        } else {
            this.cbUnitLayerType.setVisible(false);
            this.txtFieldValue.setText("");
            this.txtFieldValue.setVisible(true);
            this.checkBlured.setEnabled(true);
            this.checkBlured.setSelected(true);
        }
    }

    @Override
    protected void cbUnitLayerType_itemStateChanged(ItemEvent e) throws Exception {
        OrgUnitLayerTypeInfo typeInfo = (OrgUnitLayerTypeInfo)this.cbUnitLayerType.getSelectedItem();
        if (typeInfo != null && typeInfo.getId() != null) {
            this.txtFieldValue.setText(typeInfo.getId().toString());
        } else {
            this.txtFieldValue.setText("");
        }
    }

    private void loadLayerType() throws BOSException {
        if (!this.loaded) {
            this.cbUnitLayerType.removeAllItems();
            DefaultComboBoxModel<OrgUnitLayerTypeInfo> model = new DefaultComboBoxModel<OrgUnitLayerTypeInfo>();
            model.addElement(null);
            IOrgUnitLayerType iLayerType = OrgUnitLayerTypeFactory.getRemoteInstance();
            OrgUnitLayerTypeCollection col = iLayerType.getOrgUnitLayerTypeCollection();
            for (int i = 0; i < col.size(); ++i) {
                model.addElement(col.get(i));
            }
            this.cbUnitLayerType.setModel(model);
            this.cbUnitLayerType.setSelectedIndex(-1);
            this.loaded = true;
        }
    }

    @Override
    protected void levelSpinner_stateChanged(ChangeEvent e) throws Exception {
        this.level = (Integer)this.levelSpinner.getValue();
        TreePath path = this.tOrgTree.getSelectionPath();
        if (path != null) {
            DefaultKingdeeTreeNode selectNode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
            if (selectNode.getUserObject() != null && selectNode.getUserObject() instanceof OrgStructureInfo) {
                this.level += ((OrgStructureInfo)selectNode.getUserObject()).getLevel();
                this.setTreeExpandLevel(selectNode);
                this.tOrgTree.setSelectionNode(selectNode);
            }
        } else {
            this.setTreeExpandLevel((DefaultKingdeeTreeNode)this.tOrgTree.getModel().getRoot());
            this.tOrgTree.setSelectionNode((DefaultKingdeeTreeNode)this.tOrgTree.getModel().getRoot());
        }
    }

    private void setTreeExpandLevel(DefaultKingdeeTreeNode root) {
        if (root != null && root.getUserObject() instanceof OrgStructureInfo) {
            OrgStructureInfo structureInfo = (OrgStructureInfo)root.getUserObject();
            if (structureInfo != null) {
                if (structureInfo.getLevel() <= this.level) {
                    this.tOrgTree.expandPath(new TreePath(root));
                    this.tOrgTree.setSelectionNode(root);
                } else {
                    this.tOrgTree.collapsePath(this.tOrgTree.getSelectionPath());
                }
            }
            for (int i = 0; i < root.getChildCount(); ++i) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
                this.setTreeExpandLevel(node);
            }
        }
    }

    protected void btnSearch_actionPerformed(ActionEvent e) throws Exception {
        String value;
        this.oldOrgType = (OrgViewType)((Object)this.cbOrgType.getSelectedItem());
        if (this.dialog != null && this.dialog.isCumulate()) {
            Set valueSet = this.setCacheHelper.getSetByF7Type(this.oldOrgType);
            this.saveReturnValues(valueSet);
        }
        this.cbOrgTree_itemStateChanged(null);
        this.isSearched = true;
        String string = value = this.txtFieldValue.getText() == null || this.txtFieldValue.getText().trim().length() == 0 ? null : this.txtFieldValue.getText().trim();
        if (this.tOrgTree.getModel() != null && this.tOrgTree.getModel().getRoot() != null && this.tOrgTree.getModel().getRoot() instanceof DefaultKingdeeTreeNode && value != null) {
            DefaultKingdeeTreeNode rootNode = (DefaultKingdeeTreeNode)this.tOrgTree.getModel().getRoot();
            while (rootNode.getChildCount() > 0) {
                rootNode = (DefaultKingdeeTreeNode)rootNode.getChildAt(0);
            }
            if (rootNode.getParent() != null) {
                this.tOrgTree.expandAllNodes(true, rootNode.getParent());
            }
        }
    }

    class MyTreeSelectionListener
    implements TreeSelectionListener {
        MyTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            OrgF7PromptDialog unionF7 = OrgTypeClientCenter.getInstance().getClientImp(OrgType.UnionDebt).createF7ByCondition("TREETYPE_ORDINARY");
            boolean isUnionF7 = false;
            if (unionF7 != null) {
                isUnionF7 = unionF7.getClass().getName().equals(OrgF7UI2.this.dialog.getClass().getName());
            }
            if (!((OrgF7UI2)OrgF7UI2.this).dialog.isSynCheck && !isUnionF7) {
                return;
            }
            if (e.getNewLeadSelectionPath() != null) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)e.getNewLeadSelectionPath().getLastPathComponent();
                OrgStructureInfo structInfo = (OrgStructureInfo)node.getUserObject();
                if (structInfo == null) {
                    return;
                }
                if (structInfo.getUnit().isIsUnion()) {
                    this.checkChildren(node);
                }
            }
        }

        private void checkChildren(DefaultKingdeeTreeNode node) {
            node.setChecked(true);
            int n = node.getChildCount();
            for (int i = 0; i < n; ++i) {
                this.checkChildren((DefaultKingdeeTreeNode)node.getChildAt(i));
            }
        }
    }
}

