/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.param.client.ParamDeleteUI;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.AdminOrgRangeFilterUtil;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.INewOUInnerFacade;
import com.kingdee.eas.basedata.org.IOrgSwitchFacade;
import com.kingdee.eas.basedata.org.NewOUInnerFacadeFactory;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgSpecialTablesRebuildFacadeFactory;
import com.kingdee.eas.basedata.org.OrgSwitchFacadeFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.AbstractOrgHideFunctionUI;
import com.kingdee.eas.basedata.org.client.NewOuF7PromptDialog;
import com.kingdee.eas.basedata.org.client.OrgSpecialTablesClientUtil;
import com.kingdee.eas.basedata.org.client.f7.NewAdminF7;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.basedata.org.util.OrgToolUtils;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.util.client.BigMsgBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JFrame;
import org.apache.log4j.Logger;

public class OrgHideFunctionUI
extends AbstractOrgHideFunctionUI {
    private static final Logger logger = CoreUIObject.getLogger(OrgHideFunctionUI.class);
    String strResource = "com.kingdee.eas.basedata.org.client.OUResource";

    public void onLoad() throws Exception {
        super.onLoad();
        this.orgAudit.setEnabled(true);
        this.restoreData.setEnabled(true);
        this.restoreOrgDisplayName.setEnabled(true);
        this.checkData.setEnabled(true);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    @Override
    public void actionBatchOUSealUp_actionPerformed(ActionEvent e) throws Exception {
        OrgUnitInfo unitInfo;
        boolean isCUAdmin = Administrator.isCUAdmin(null, (IObjectPK)ToolUtils.getCurrentUserPK());
        if (!isCUAdmin) {
            String message = EASResource.getString((String)this.strResource, (String)"NOPERM_BATCH_SEALUP");
            MsgBox.showInfo((Component)((Object)this), (String)message);
            return;
        }
        NewOuF7PromptDialog f7 = new NewOuF7PromptDialog((IUIObject)this);
        if (AdminOrgRangeFilterUtil.isFilterByUserAdminOrgRange(null)) {
            NewAdminF7 adminF7 = new NewAdminF7();
            adminF7.setNeedAddOrgRange(false);
            String rangeSQL = PermissionRangeHelper.getUserOrgIdRangeSQL(null, (IObjectPK)ToolUtils.getCurrentUserPK(), (OrgRangeType)OrgRangeType.ADMIN_ORG_TYPE);
            StringBuffer treeFilter = new StringBuffer();
            treeFilter.append("\"BASEUNIT\"").append(".FID IN (").append(rangeSQL).append(")");
            adminF7.setExtraTreeFilters(treeFilter.toString());
            StringBuffer outerFilter = new StringBuffer();
            outerFilter.append("unit.id in (").append(rangeSQL).append(")");
            adminF7.setOuterFilterInfo(new FilterInfo(outerFilter.toString()));
            f7 = adminF7;
        } else {
            NewOuF7PromptDialog ouF7 = new NewOuF7PromptDialog();
            ouF7.setShowSub(true);
            ouF7.setRootUnitID("00000000-0000-0000-0000-000000000000CCE7AED4");
            f7 = ouF7;
        }
        f7.show();
        if (!f7.isCanceled() && (unitInfo = (OrgUnitInfo)f7.getData()) != null) {
            if (!MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)this.strResource, (String)"CONFIRM_SEALUP")))) {
                return;
            }
            if (!(f7.f7ui.cbOrgType.getSelectedItem() instanceof OrgViewType)) {
                logger.error((Object)("seal ou fail,unitInfo.number=" + unitInfo.getNumber()));
                return;
            }
            OrgViewType orgType = (OrgViewType)((Object)f7.f7ui.cbOrgType.getSelectedItem());
            int orgTypeValue = orgType.getValue();
            INewOUInnerFacade iNOUI = NewOUInnerFacadeFactory.getRemoteInstance();
            if (orgTypeValue == -1) {
                if (unitInfo.isIsCU()) {
                    iNOUI.batchCUSealUp((IObjectValue)unitInfo);
                } else {
                    iNOUI.batchOUSealUp((IObjectValue)unitInfo);
                }
            } else if (orgTypeValue == 10) {
                iNOUI.batchCUSealUp((IObjectValue)unitInfo);
            } else {
                iNOUI.batchBizSealUp((IObjectValue)unitInfo, orgTypeValue);
            }
            OrgToolUtils.removeCache(orgTypeValue, true);
            this.showOUSealUpSuccess();
        }
    }

    private void showOUSealUpSuccess() {
        String message = EASResource.getString((String)this.strResource, (String)"SEALUP_SUCCESS");
        this.setMessageText(message);
        this.showMessage();
    }

    @Override
    public void actionBatchRemove_actionPerformed(ActionEvent e) throws Exception {
        OrgUnitInfo unitInfo;
        boolean isCUAdmin = Administrator.isCUAdmin(null, (IObjectPK)ToolUtils.getCurrentUserPK());
        if (!isCUAdmin) {
            String message = EASResource.getString((String)this.strResource, (String)"NOPERM_BATCH_REMOVE");
            MsgBox.showInfo((Component)((Object)this), (String)message);
            return;
        }
        NewOuF7PromptDialog f7 = new NewOuF7PromptDialog((IUIObject)this);
        if (AdminOrgRangeFilterUtil.isFilterByUserAdminOrgRange(null)) {
            NewAdminF7 adminF7 = new NewAdminF7();
            adminF7.setNeedAddOrgRange(false);
            String rangeSQL = PermissionRangeHelper.getUserOrgIdRangeSQL(null, (IObjectPK)ToolUtils.getCurrentUserPK(), (OrgRangeType)OrgRangeType.ADMIN_ORG_TYPE);
            StringBuffer treeFilter = new StringBuffer();
            treeFilter.append("\"BASEUNIT\"").append(".FID IN (").append(rangeSQL).append(")");
            adminF7.setExtraTreeFilters(treeFilter.toString());
            StringBuffer outerFilter = new StringBuffer();
            outerFilter.append("unit.id in (").append(rangeSQL).append(")");
            adminF7.setOuterFilterInfo(new FilterInfo(outerFilter.toString()));
            f7 = adminF7;
        } else {
            NewOuF7PromptDialog ouF7 = new NewOuF7PromptDialog();
            ouF7.setShowSub(true);
            ouF7.setRootUnitID("00000000-0000-0000-0000-000000000000CCE7AED4");
            f7 = ouF7;
        }
        f7.show();
        if (!f7.isCanceled() && (unitInfo = (OrgUnitInfo)f7.getData()) != null) {
            if (!MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)this.strResource, (String)"CONFIRM_REMOVE")))) {
                return;
            }
            if (!(f7.f7ui.cbOrgType.getSelectedItem() instanceof OrgViewType)) {
                logger.error((Object)("seal ou fail,unitInfo.number=" + unitInfo.getNumber()));
                return;
            }
            OrgViewType orgType = (OrgViewType)((Object)f7.f7ui.cbOrgType.getSelectedItem());
            int orgTypeValue = orgType.getValue();
            IFullOrgUnit iFull = FullOrgUnitFactory.getRemoteInstance();
            if (orgTypeValue == -1 || orgTypeValue == 10) {
                iFull.batchDelete((IObjectValue)unitInfo);
            } else {
                iFull.batchDelBizOrg((IObjectValue)unitInfo, orgTypeValue);
            }
            this.showOUBatchMoveSuccess();
        }
    }

    private void showOUBatchMoveSuccess() {
        String message = EASResource.getString((String)this.strResource, (String)"BATCH_REMOVE_SUCCESS");
        this.setMessageText(message);
        this.showMessage();
    }

    @Override
    public void actionOrgAudit_actionPerformed(ActionEvent e) throws Exception {
        OrgSpecialTablesClientUtil.showALongTimeDialogUsedToRebuildAllSpecialTables(true);
    }

    @Override
    public void actionRestoreData_actionPerformed(ActionEvent e) throws Exception {
        try {
            IOrgSwitchFacade iOrgSwitch = OrgSwitchFacadeFactory.getRemoteInstance();
            iOrgSwitch.initOrgData();
            String message = EASResource.getString((String)this.strResource, (String)"INITORGDATEOVER");
            MsgBox.showInfo((String)message);
        }
        catch (Exception e1) {
            logger.error((Object)"init org error!", (Throwable)e1);
            this.handleException(e1);
        }
    }

    @Override
    public void actionRestoreOrgDisplayName_actionPerformed(ActionEvent e) throws Exception {
        Window win = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        LongTimeDialog ltd = null;
        ltd = win instanceof Frame ? new LongTimeDialog((Frame)win) : (win instanceof Dialog ? new LongTimeDialog((Dialog)win) : new LongTimeDialog((Frame)new JFrame()));
        ltd.setTitle(OrgToolUtils.getResource("res_46"));
        ltd.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                try {
                    OrgSpecialTablesRebuildFacadeFactory.getRemoteInstance().rebuildOrgStructureDisplayName();
                }
                catch (Exception e) {
                    OrgHideFunctionUI.this.handleException(e);
                }
                return new Boolean(true);
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        ltd.show();
    }

    @Override
    public void actionCheckData_actionPerformed(ActionEvent e) throws Exception {
        try {
            BigMsgBox.showInfo((StringBuffer)this.checkData());
        }
        catch (BOSException e1) {
            logger.error((Object)"error", (Throwable)e1);
            ExceptionHandler.handle((Throwable)e1);
        }
    }

    private StringBuffer checkData() throws BOSException {
        StringBuffer retStr = new StringBuffer("");
        IFullOrgUnit iFull = FullOrgUnitFactory.getRemoteInstance();
        FullOrgUnitCollection fullCol = iFull.getFullOrgUnitCollection(" select id,number,name,longnumber,orgTypeStr ");
        for (int i = 0; i < fullCol.size(); ++i) {
            FullOrgUnitInfo fullInfo = fullCol.get(i);
            logger.info((Object)("deal this org:" + i + " number:" + fullInfo.getNumber()));
            OrgTypeHelper orgTypeHelper = new OrgTypeHelper(fullInfo.getOrgTypeStr());
            List orgTypeList = OrgType.getEnumList();
            for (OrgType curOrgType : orgTypeList) {
                if (!orgTypeHelper.isOrgType(curOrgType)) continue;
                try {
                    NewOrgViewHelper.getOrgUnitInfo(null, fullInfo.getId().toString(), curOrgType);
                }
                catch (Exception e) {
                    logger.error((Object)" org data error!", (Throwable)e);
                    retStr.append("\nOrgId:").append(fullInfo.getId().toString());
                    retStr.append("  OrgNumber:").append(fullInfo.getNumber());
                    retStr.append("  OrgName:").append(fullInfo.getName());
                    retStr.append("  OrgLongNumber:").append(fullInfo.getLongNumber());
                    retStr.append("  OrgTye:").append(curOrgType.getName());
                }
            }
        }
        if (retStr.length() == 0) {
            return new StringBuffer(EASResource.getString((String)this.strResource, (String)"DATAISOK"));
        }
        return retStr;
    }

    @Override
    public void actionDelParamValue_actionPerformed(ActionEvent e) throws Exception {
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ParamDeleteUI.class.getName(), this.getUIContext(), null, OprtState.EDIT);
            uiWindow.show();
        }
        catch (UIException e1) {
            this.handleException((Exception)((Object)e1));
        }
    }
}

