/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.AbstractOrgInputListUI;
import com.kingdee.eas.basedata.org.client.OrgInnerUtils;
import com.kingdee.eas.basedata.org.client.tree.OrgUnitNodeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;

public class OrgInputListUI
extends AbstractOrgInputListUI {
    private KDTree tree = null;
    private OrgUnitInfo parentInfo = null;
    private OrgTreeInfo treeInfo = null;
    private boolean isUnionDebt = false;

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.btnQuery.setVisible(false);
        this.getTransParam();
        this.btnAddNew.setText(null);
        this.btnAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnLocate.setText(null);
        this.btnLocate.setIcon(EASResource.getIcon((String)"imgTbtn_speedgoto"));
        this.tblMain.getSelectManager().setSelectMode(10);
        this.firstRefreshTable();
    }

    void firstRefreshTable() {
        EntityViewInfo view = new EntityViewInfo();
        if (this.isUnionDebt) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("isOnlyUnion", (Object)new Integer(1), CompareType.NOTEQUALS));
            view.setFilter(filterInfo);
        }
        this.mainQuery = view;
        this.tblMain.removeRows();
    }

    void getTransParam() {
        Map map = this.getUIContext();
        this.tree = (KDTree)map.get("tree");
        this.parentInfo = (OrgUnitInfo)map.get("isSelectNode");
        this.treeInfo = (OrgTreeInfo)map.get("treeInfo");
        this.isUnionDebt = (Boolean)map.get("isUnionDebt");
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.getSelectData();
    }

    void getSelectData() throws Exception {
        if (this.tblMain.getSelectManager().getBlocks().size() == 0) {
            return;
        }
        for (KDTSelectBlock block : this.tblMain.getSelectManager().getBlocks()) {
            for (int i = block.getTop(); i <= block.getBottom(); ++i) {
                if (this.isUnionDebt) {
                    this.referNewRecord(this.tblMain.getRow(i).getCell("id").getValue().toString());
                    continue;
                }
                this.insertNewRecord(this.tblMain.getRow(i).getCell("id").getValue().toString());
            }
        }
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OrgResource.MESSAGE_INPUT_ORG_SUCCESS"));
        this.tree.getParent().setFocusable(true);
        this.getUIWindow().close();
    }

    void referNewRecord(String strId) throws BOSException, UuidException, EASBizException, BOSException {
    }

    void insertNewRecord(String strId) throws Exception {
    }

    void refreshTree(IObjectPK pk) throws Exception {
        IOrgStructure iOrgStruc = OrgStructureFactory.getRemoteInstance();
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("*"));
        sc.add(new SelectorItemInfo("unit.*"));
        OrgStructureInfo strucInfo = (OrgStructureInfo)iOrgStruc.getValue(pk, sc);
        OrgUnitNodeInfo nodeInfo = new OrgUnitNodeInfo(strucInfo);
        OrgInnerUtils.refreshTreeNode(nodeInfo, this.tree, false);
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }

    protected ICoreBase getBizInterface() throws BOSException {
        return null;
    }

    protected String getEditUIName() {
        return "";
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.getSelectData();
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        CommonQueryDialog commonQueryDialog = new CommonQueryDialog();
        commonQueryDialog.setOwner((Component)((Object)this));
        commonQueryDialog.setParentUIClassName(((Object)((Object)this)).getClass().getName());
        commonQueryDialog.setQueryObjectPK(this.mainQueryPK);
        commonQueryDialog.setShowFilter(true);
        commonQueryDialog.setShowSorter(false);
        commonQueryDialog.setShowToolbar(true);
        if (commonQueryDialog.show()) {
            EntityViewInfo view = commonQueryDialog.getEntityViewInfoResult();
            int counts = view.getFilter().getFilterItems().size();
            if (this.isUnionDebt) {
                view.getFilter().getFilterItems().add(new FilterItemInfo("isOnlyUnion", (Object)new Integer(1), CompareType.NOTEQUALS));
                if (counts == 0) {
                    view.getFilter().setMaskString("#0");
                } else {
                    view.getFilter().setMaskString("(" + view.getFilter().getMaskString() + ") and #" + counts);
                }
            }
            this.mainQuery = view;
            this.tblMain.removeRows();
        } else {
            SysUtil.abort();
        }
    }
}

