/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminAffiliationTypeFactory;
import com.kingdee.eas.basedata.org.AdminAffiliationTypeInfo;
import com.kingdee.eas.basedata.org.IOrgUnitLayer;
import com.kingdee.eas.basedata.org.IOrgUnitLayerType;
import com.kingdee.eas.basedata.org.OrgBlankException;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgTypeLayerException;
import com.kingdee.eas.basedata.org.OrgUnitLayerCollection;
import com.kingdee.eas.basedata.org.OrgUnitLayerFactory;
import com.kingdee.eas.basedata.org.OrgUnitLayerInfo;
import com.kingdee.eas.basedata.org.OrgUnitLayerTypeFactory;
import com.kingdee.eas.basedata.org.OrgUnitLayerTypeInfo;
import com.kingdee.eas.basedata.org.client.AbstractOrgLayerEditUI;
import com.kingdee.eas.basedata.org.client.uihelper.UIHelper;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class OrgLayerEditUI
extends AbstractOrgLayerEditUI {
    private static int selectIndex = -1;
    private KDTable selectTable = null;
    private String isModify;
    private ArrayList deleteList = null;

    public OrgLayerEditUI() throws Exception {
        this.btnRemove.setVisible(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kDTable1.checkParsed();
        this.selectTable = (KDTable)this.getUIContext().get("table");
        this.setDataObject((IObjectValue)this.editData);
        this.setModifyData();
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.lockUIForViewStatus();
            this.btnAddNew.setEnabled(false);
            this.btnDelete.setEnabled(false);
        } else {
            this.unLockUI();
        }
        this.btnAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        KDTextField txtFEditor = new KDTextField();
        txtFEditor.setMaxLength(80);
        this.kDTable1.getColumn("colName").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtFEditor));
        KDTextArea txtAEditor = new KDTextArea();
        txtAEditor.setMaxLength(255);
        this.kDTable1.getColumn("colMemo").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextArea)txtAEditor));
        this.initAdminAffilitionType();
        this.loadFields();
    }

    private void initAdminAffilitionType() {
        this.kDComboBoxAdminAffi.removeAllItems();
        try {
            CoreBaseCollection adminAffiliationTypeCollection = AdminAffiliationTypeFactory.getRemoteInstance().getCollection("SELECT name ORDER BY number");
            UIHelper.initComboBoxModel(this.kDComboBoxAdminAffi, adminAffiliationTypeCollection.iterator());
            this.kDComboBoxAdminAffi.setSelectedIndex(-1);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("layers.id"));
        sic.add(new SelectorItemInfo("layers.name"));
        sic.add(new SelectorItemInfo("layers.description"));
        return sic;
    }

    void clearData() {
        this.txtDescription.setSelectedItem(null);
        this.txtName.setSelectedItem(null);
        this.kDTable1.removeRows();
        this.setOprtState(OprtState.ADDNEW);
    }

    void setModifyData() throws Exception {
        this.kDTable1.removeRows();
        if (this.getOprtState().equals(OprtState.EDIT) || this.getOprtState().equals(OprtState.VIEW)) {
            OrgUnitLayerCollection layerInfos = this.editData.getLayers();
            for (int i = 0; i < layerInfos.size(); ++i) {
                IRow row = this.kDTable1.addRow();
                row.getCell("colID").setValue((Object)layerInfos.get(i).getId());
                row.getCell("colName").setValue((Object)layerInfos.get(i).getName());
                row.getCell("colMemo").setValue((Object)layerInfos.get(i).getDescription());
            }
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.unLockUI();
        this.txtName.setEditable(true);
        this.txtDescription.setEditable(true);
        this.btnAddNew.setEnabled(true);
        this.btnDelete.setEnabled(true);
        this.kDTable1.setEditable(true);
        if (this.editData != null && this.editData.getAdminAffiliationType() != null) {
            this.kDComboBoxAdminAffi.setSelectedItem((Object)this.editData.getAdminAffiliationType());
            this.kDComboBoxAdminAffi.setEnabled(false);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.beforeStoreFields(e);
        this.storeFields();
        if (this.editData == null) {
            return;
        }
        this.verifyInput();
        IOrgUnitLayerType iOrgUnitLayerType = OrgUnitLayerTypeFactory.getRemoteInstance();
        if (this.getOprtState().equals(OprtState.EDIT) || this.getOprtState().equals(OprtState.VIEW)) {
            iOrgUnitLayerType.update((IObjectPK)new ObjectUuidPK(this.editData.getId()), (CoreBaseInfo)this.editData);
            IOrgUnitLayer iLayer = OrgUnitLayerFactory.getRemoteInstance();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("layerType.id", (Object)this.editData.getId()));
            view.setFilter(filter);
            OrgUnitLayerCollection infos = iLayer.getOrgUnitLayerCollection(view);
            int counts = this.editData.getLayers().size();
            this.editData.getLayers().clear();
            this.editData.getLayers().addCollection(infos);
            this.setModifyData();
        } else {
            IObjectPK pk = iOrgUnitLayerType.addnew((CoreBaseInfo)this.editData);
            this.editData.setId(BOSUuid.read((String)pk.toString()));
            this.setOprtState(OprtState.EDIT);
        }
        this.selectTable.removeRows();
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.setModifyData();
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this.setModifyData();
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.setModifyData();
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.setModifyData();
    }

    @Override
    protected void btnDelete_actionPerformed(ActionEvent e) throws Exception {
        int selectRow = KDTableUtil.getSelectedRow((KDTable)this.kDTable1);
        if (selectRow != -1) {
            this.kDTable1.removeRow(selectRow);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.editData != null && this.editData.getAdminAffiliationType() != null) {
            this.kDComboBoxAdminAffi.setSelectedItem((Object)this.editData.getAdminAffiliationType());
            this.kDComboBoxAdminAffi.setEnabled(false);
        }
    }

    @Override
    public void storeFields() {
        if (this.editData == null) {
            this.editData = new OrgUnitLayerTypeInfo();
        }
        this.setDataObject((IObjectValue)this.editData);
        super.storeFields();
        this.editData.setOrgType(OrgType.Admin);
        this.editData.setAdminAffiliationType((AdminAffiliationTypeInfo)this.kDComboBoxAdminAffi.getSelectedItem());
        if (!StringUtils.isEmpty((String)this.editData.getName())) {
            this.editData.setNumber(this.editData.getName());
        }
        this.storeDataLayers();
    }

    private void storeDataLayers() {
        IRow row = null;
        OrgUnitLayerInfo info = null;
        OrgUnitLayerCollection layerInfos = new OrgUnitLayerCollection();
        for (int i = 0; i < this.kDTable1.getRowCount(); ++i) {
            row = this.kDTable1.getRow(i);
            info = new OrgUnitLayerInfo();
            if (this.kDTable1.getRow(i).getCell("colID").getValue() != null && this.kDTable1.getRow(i).getCell("colID").getValue().toString().length() != 0) {
                info.setId(BOSUuid.read((String)this.kDTable1.getRow(i).getCell("colID").getValue().toString()));
            } else {
                info.setId(null);
            }
            if (row.getCell("colName").getValue() != null) {
                info.setName(row.getCell("colName").getValue().toString());
            }
            if (row.getCell("colMemo").getValue() != null) {
                info.setDescription(row.getCell("colMemo").getValue().toString());
            } else {
                info.setDescription("");
            }
            layerInfos.add(info);
        }
        this.editData.getLayers().clear();
        this.editData.getLayers().addCollection(layerInfos);
    }

    void verifyInput() throws Exception {
        if (StringUtils.isEmpty((String)this.editData.getName())) {
            throw new OrgBlankException(OrgBlankException.NAME_CAN_NOT_BLANK);
        }
        this.checkDetailIsNull();
        this.checkDetailRupName();
    }

    void checkDetailIsNull() throws OrgBlankException {
        int row = this.editData.getLayers().size();
        if (row == 0) {
            return;
        }
        for (int i = 0; i < row; ++i) {
            if (this.editData.getLayers().get(i).getName() != null && this.editData.getLayers().get(i).getName().toString().trim().length() != 0) continue;
            throw new OrgBlankException(OrgBlankException.NAME_CAN_NOT_BLANK);
        }
    }

    void checkDetailRupName() throws OrgTypeLayerException {
        int rows = this.editData.getLayers().size();
        if (rows == 0) {
            return;
        }
        Object curRow = null;
        Object secRow = null;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < rows; ++j) {
                if (i == j || this.editData.getLayers().get(i).getName() == null || this.editData.getLayers().get(j).getName() == null || !this.editData.getLayers().get(i).getName().equals(this.editData.getLayers().get(j).getName())) continue;
                throw new OrgTypeLayerException(OrgTypeLayerException.NAME_CAN_NOT_RUP);
            }
        }
    }

    protected IObjectValue createNewData() {
        return new OrgUnitLayerTypeInfo();
    }

    protected ICoreBase getBizInterface() throws BOSException {
        return OrgUnitLayerTypeFactory.getRemoteInstance();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.kDTable1.addRow();
    }

    public boolean checkBeforeWindowClosing() {
        return true;
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.btnAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.txtDescription.setAutoscrolls(true);
        this.lblGrade.setIcon(EASResource.getIcon((String)"imgLableword_btn"));
        this.btnNew.setVisible(false);
    }
}

