/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.basedata.org.NewOrgF7FacadeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.OrgF7Helper;
import com.kingdee.eas.basedata.org.util.OrgF7FilterUtil;
import com.kingdee.eas.common.EASBizException;
import org.apache.log4j.Logger;

public class OrgPermissionFilterService {
    private static Logger logger = Logger.getLogger((String)OrgPermissionFilterService.class.getName());

    public static FilterInfo getAuthorizedOrgsFilter(NewOrgViewF7PromptDialog dialog, OrgViewType viewType, OrgTreeInfo treeInfo) throws BOSException {
        assert (viewType != null);
        if (dialog.isCUFilter() || dialog.isNeedAddOrgRange()) {
            try {
                AbstractOrgViewType orgViewType = null;
                orgViewType = viewType == OrgViewType.UNIONDEBT ? new UnionOrgViewType(dialog, viewType, treeInfo.getId().toString()) : (viewType == OrgViewType.RESPONSECENTER ? new ResponsecenterOrgViewType(dialog, viewType, treeInfo.getId().toString()) : new OtherOrgViewType(dialog, viewType, treeInfo.getId().toString()));
                return ((AbstractOrgViewType)orgViewType).getOrgPermissionFilter();
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        return null;
    }

    private static class OtherOrgViewType
    extends AbstractOrgViewType {
        private OtherOrgViewType(NewOrgViewF7PromptDialog dialog, OrgViewType viewType, String treeID) {
            super(dialog, viewType, treeID);
        }

        @Override
        protected FilterInfo buildAdminFilter() throws BOSException, EASBizException {
            FilterInfo filter = null;
            if (this.isCUFilter) {
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("unit.cu.id", (Object)this.cuID, CompareType.EQUALS));
                if (this.isCUFilterIncludeSub) {
                    filter.getFilterItems().add(new FilterItemInfo("unit.cu.longNumber", (Object)(OrgF7FilterUtil.getCULongNumber(null, this.cuID) + "!%"), CompareType.LIKE));
                    filter.setMaskString("(#0 or #1)");
                }
            } else if (this.isNeedAddOrgRange) {
                return OrgF7Helper.getFilterByOrgRange("unit.cu.id", this.userPK.toString(), 10);
            }
            return filter;
        }

        @Override
        protected FilterInfo buildOrgRangeFilter() throws BOSException, EASBizException {
            FilterInfo filter = null;
            if (this.isCUFilter) {
                String paramSQL = OrgF7FilterUtil.buildParamSQL(this.userPK, this.cuID, this.viewType, true, this.isCUFilterIncludeSub);
                try {
                    filter = new FilterInfo("unit.id in (" + paramSQL + ")");
                }
                catch (ParserException e) {
                    logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                }
            } else if (this.isNeedAddOrgRange) {
                return OrgF7Helper.getFilterByOrgRange("unit.id", this.userPK.toString(), OrgF7Helper.getOrgRangeType(this.viewType));
            }
            return filter;
        }

        @Override
        protected FilterInfo buildPermItemFilter() throws BOSException, EASBizException {
            FilterInfo filter = null;
            String paramSQL = null;
            if (this.isCUFilter) {
                paramSQL = NewOrgF7FacadeFactory.getRemoteInstance().getPermSQLByUIPKAndActionPK(this.userPK, this.cuID, this.uiPK, this.actionPK, this.viewType, true, this.isCUFilterIncludeSub);
            } else if (this.isNeedAddOrgRange) {
                paramSQL = NewOrgF7FacadeFactory.getRemoteInstance().getPermSQLByUIPKAndActionPK(this.userPK, null, this.uiPK, this.actionPK, this.viewType, false, false);
            }
            try {
                filter = new FilterInfo("unit.id in (" + paramSQL + ")");
            }
            catch (ParserException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            return filter;
        }
    }

    private static class ResponsecenterOrgViewType
    extends AbstractOrgViewType {
        private ResponsecenterOrgViewType(NewOrgViewF7PromptDialog dialog, OrgViewType viewType, String treeID) {
            super(dialog, viewType, treeID);
        }

        @Override
        protected FilterInfo buildAdminFilter() throws BOSException, EASBizException {
            return null;
        }

        @Override
        protected FilterInfo buildOrgRangeFilter() throws BOSException, EASBizException {
            return null;
        }

        @Override
        protected FilterInfo buildPermItemFilter() throws BOSException, EASBizException {
            return null;
        }
    }

    private static class UnionOrgViewType
    extends AbstractOrgViewType {
        private UnionOrgViewType(NewOrgViewF7PromptDialog dialog, OrgViewType viewType, String treeID) {
            super(dialog, viewType, treeID);
        }

        @Override
        protected FilterInfo getOrgPermissionFilter() throws BOSException, EASBizException {
            FilterInfo filter = super.getOrgPermissionFilter();
            if (filter == null) {
                filter = new FilterInfo();
            }
            filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)this.treeID, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("unit.isunion", (Object)0, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("unit.partFI.isSealUp", (Object)0, CompareType.EQUALS));
            filter.setMaskString("#0 or (#1 and #2 and #3)");
            return filter;
        }

        @Override
        protected FilterInfo buildAdminFilter() throws BOSException, EASBizException {
            FilterInfo filter = new FilterInfo();
            if (this.isCUFilter) {
                filter.getFilterItems().add(new FilterItemInfo("unit.cu.id", (Object)this.cuID, CompareType.EQUALS));
            } else if (this.isNeedAddOrgRange) {
                return OrgF7Helper.getFilterByOrgRange("unit.cu.id", this.userPK.toString(), 10);
            }
            return filter;
        }

        @Override
        protected FilterInfo buildOrgRangeFilter() throws BOSException, EASBizException {
            FilterInfo filter = null;
            if (this.isCUFilter) {
                String paramSQL = OrgF7FilterUtil.buildParamSQL(this.userPK, this.cuID, this.viewType, true, false);
                try {
                    filter = new FilterInfo("unit.id in (" + paramSQL + ")");
                }
                catch (ParserException e) {
                    logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                }
            } else if (this.isNeedAddOrgRange) {
                return OrgF7Helper.getFilterByOrgRange("unit.id", this.userPK.toString(), OrgF7Helper.getOrgRangeType(this.viewType));
            }
            return filter;
        }

        @Override
        protected FilterInfo buildPermItemFilter() throws BOSException, EASBizException {
            FilterInfo filter = null;
            String paramSQL = null;
            if (this.isCUFilter) {
                paramSQL = NewOrgF7FacadeFactory.getRemoteInstance().getPermSQLByUIPKAndActionPK(this.userPK, this.cuID, this.uiPK, this.actionPK, this.viewType, true, false);
            } else if (this.isNeedAddOrgRange) {
                paramSQL = NewOrgF7FacadeFactory.getRemoteInstance().getPermSQLByUIPKAndActionPK(this.userPK, null, this.uiPK, this.actionPK, this.viewType, false, false);
            }
            try {
                filter = new FilterInfo("unit.id in (" + paramSQL + ")");
            }
            catch (ParserException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            return filter;
        }
    }

    private static abstract class AbstractOrgViewType {
        protected NewOrgViewF7PromptDialog dialog;
        protected OrgViewType viewType;
        protected String treeID;
        protected String cuID;
        protected IObjectPK userPK;
        protected IMetaDataPK uiPK;
        protected IMetaDataPK actionPK;
        protected boolean isCUFilterIncludeSub;
        protected boolean isCUFilter;
        protected boolean isNeedAddOrgRange;

        private AbstractOrgViewType(NewOrgViewF7PromptDialog dialog, OrgViewType viewType, String treeID) {
            this.dialog = dialog;
            this.viewType = viewType;
            this.treeID = treeID;
            this.initParam();
        }

        private void initParam() {
            this.cuID = this.dialog.getCurrentCUID();
            this.userPK = this.dialog.getUserPK();
            this.uiPK = this.dialog.getUiPK();
            this.actionPK = this.dialog.getActionPK();
            this.isCUFilterIncludeSub = this.dialog.isCUFilterIncludeSub();
            this.isCUFilter = this.dialog.isCUFilter();
            this.isNeedAddOrgRange = this.dialog.isNeedAddOrgRange();
        }

        protected FilterInfo getOrgPermissionFilter() throws BOSException, EASBizException {
            FilterInfo filter = null;
            filter = OrgF7Helper.isAdminType(this.userPK) ? this.buildAdminFilter() : (this.uiPK == null || this.actionPK == null ? this.buildOrgRangeFilter() : this.buildPermItemFilter());
            return filter;
        }

        protected abstract FilterInfo buildPermItemFilter() throws BOSException, EASBizException;

        protected abstract FilterInfo buildOrgRangeFilter() throws BOSException, EASBizException;

        protected abstract FilterInfo buildAdminFilter() throws BOSException, EASBizException;
    }
}

