/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OUPartCoreBaseInfo;
import com.kingdee.eas.basedata.org.OrgAssistInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUtils;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.NewOrgF7PromptDialog;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class OrgRangeF7PromptDialog
extends NewOrgF7PromptDialog {
    private static Logger logger = Logger.getLogger(OrgRangeF7PromptDialog.class);
    protected UserInfo targetUser = null;
    protected UserInfo currentUser = SysContext.getSysContext().getCurrentUserInfo();
    protected boolean needAddOrgRange = true;
    protected boolean needAddUserCU = true;

    public OrgRangeF7PromptDialog(UserInfo targetUser) {
        this.targetUser = targetUser;
        this.initParam();
    }

    public OrgRangeF7PromptDialog(IUIObject _uiObject, UserInfo targetUser) {
        this(targetUser);
        this.uiOwner = _uiObject;
    }

    public OrgRangeF7PromptDialog(Frame _owner, UserInfo targetUser) {
        this(targetUser);
        this.owner = _owner;
    }

    public OrgRangeF7PromptDialog(Dialog _owner, UserInfo targetUser) {
        this(targetUser);
        this.owner = _owner;
    }

    protected void initParam() {
        super.init();
        this.setContainSealUp(true);
        this.setCumulate(true);
        this.setMultiSelect(true);
        this.orgViewTypes = this.createOrgViewType();
        this.setNeedAddOrgRange();
    }

    protected void setNeedAddOrgRange() {
        if (this.currentUser != null && Administrator.isSuperAdmin((IObjectPK)new ObjectUuidPK(this.currentUser.getId()))) {
            this.needAddOrgRange = false;
        }
    }

    protected abstract OrgViewType[] createOrgViewType();

    protected StringBuffer transArr2String(String[] treeIDs) {
        StringBuffer result = new StringBuffer();
        if (treeIDs != null) {
            int j = treeIDs.length;
            for (int i = 0; i < j; ++i) {
                result.append("'").append(treeIDs[i]).append("'");
                if (i == j - 1) continue;
                result.append(",");
            }
        }
        return result;
    }

    @Override
    protected OrgAssistInfo buildNewOrgF7AssistInfo(OrgViewType orgViewType, OrgTreeInfo orgTreeInfo, CoreBaseInfo userObject) throws EASBizException, BOSException {
        OrgAssistInfo info = super.buildNewOrgF7AssistInfo(orgViewType, orgTreeInfo, userObject);
        info.setNeedAddOrgRange(this.needAddOrgRange);
        info.setOrgRangeType(this.getOrgRangeType());
        info.setNeedAddUserCU(this.needAddUserCU);
        ArrayList<String> decorators = new ArrayList<String>();
        decorators.add(null);
        decorators.add("com.kingdee.eas.basedata.org.app.helper.NormalFilter4F7Decorator");
        decorators.add("com.kingdee.eas.basedata.org.app.helper.OrgRangeFilter4F7Decorator");
        info.setConstructParam(decorators);
        return info;
    }

    @Override
    protected SorterItemCollection getTableSorter() {
        if (this.isCbTypeTextEqualsALL()) {
            SorterItemCollection coll = new SorterItemCollection();
            coll.add(new SorterItemInfo("isunion"));
            coll.add(new SorterItemInfo("longnumber"));
            return coll;
        }
        return super.getTableSorter();
    }

    @Override
    protected Collection beforeFillDataToSelectTable(Collection selectedOrgs) throws BOSException {
        ArrayList<FullOrgUnitInfo> result = new ArrayList<FullOrgUnitInfo>();
        if (!this.isCbTypeTextEqualsALL()) {
            OrgViewType viewType = this.getComboTypeSelectedItem();
            OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(viewType);
            OrgType orgType = orgTypeInfo.getOrgType();
            if (selectedOrgs != null) {
                HashMap<String, FullOrgUnitInfo> validIds = new HashMap<String, FullOrgUnitInfo>();
                for (FullOrgUnitInfo info : selectedOrgs) {
                    if (!OrgUtils.isOrgType(info, orgType)) continue;
                    result.add(info);
                    validIds.put(info.getId().toString(), info);
                }
                if (!this.isChkSubSelected() && viewType != OrgViewType.UNIONDEBT && viewType != OrgViewType.CTRLUNIT && validIds.size() > 0) {
                    EntityViewInfo viewInfo = this.buildView4IsSealUp(validIds);
                    IObjectCollection coll = DynamicObjectFactory.getRemoteInstance().getCollection(orgTypeInfo.getPartBosType(), viewInfo);
                    if (coll != null) {
                        for (int i = 0; i < coll.size(); ++i) {
                            OUPartCoreBaseInfo oupartInfo = (OUPartCoreBaseInfo)coll.getObject(i);
                            result.remove(validIds.get(oupartInfo.getUnit().getId().toString()));
                        }
                    }
                }
            }
        } else {
            result.addAll(selectedOrgs);
        }
        return result;
    }

    private EntityViewInfo buildView4IsSealUp(Map validIds) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("unit.id"));
        HashSet tmp = new HashSet();
        tmp.addAll(validIds.keySet());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("unit.id", tmp, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("issealup", (Object)new Integer(1), CompareType.EQUALS));
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    @Override
    protected boolean isTreeComboxVisible() {
        return this.getComboTypeSelectedItem() == OrgViewType.UNIONDEBT;
    }

    @Override
    public FilterInfo getOuterFilterInfo() {
        FilterInfo filter = new FilterInfo();
        try {
            FilterInfo otherOuterFilter;
            if (this.needAddOrgRange) {
                filter.mergeFilter(this.getOrgRangeFilter(), "AND");
            }
            if ((otherOuterFilter = this.getOtherOuterFilter()) != null) {
                filter.mergeFilter(otherOuterFilter, "AND");
            }
        }
        catch (ParserException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return filter;
    }

    protected FilterInfo getOtherOuterFilter() throws ParserException {
        StringBuffer result = new StringBuffer();
        if (!this.needAddOrgRange && !this.isCbTypeTextEqualsALL() && this.needAddUserCU) {
            result.append("UNIT.CU.id in (").append(this.appendOrgRangeSQL(1)).append(")");
        }
        if (!StringUtils.isEmpty((String)result.toString())) {
            return new FilterInfo(result.toString());
        }
        return new FilterInfo();
    }

    protected FilterInfo getOrgRangeFilter() throws ParserException {
        StringBuffer result = new StringBuffer();
        if (!this.isCbTypeTextEqualsALL()) {
            result.append("UNIT.id in (").append(this.appendOrgRangeSQL(this.getOrgRangeType())).append(")");
        } else {
            result.append("id in (").append(this.appendOrgRangeSQL(this.getOrgRangeType())).append(")");
        }
        return new FilterInfo(result.toString());
    }

    protected StringBuffer appendOrgRangeSQL(int orgRangeType) {
        StringBuffer temp = new StringBuffer();
        if (orgRangeType == 2) {
            temp.append("SELECT FOrgID").append(" FROM T_PM_OrgRange ").append(" WHERE FUserID = '").append(this.currentUser.getId()).append("' AND FType = ").append(20);
        } else {
            temp.append(this.getOrgRangeSQL(orgRangeType, this.currentUser)).append(" union ").append(" select baseunit.fid from T_PM_OrgRange orgRange").append(" left outer join t_org_baseunit baseunit on orgRange.forgid = baseunit.fcontrolunitid").append(" where orgRange.fuserid = '").append(this.currentUser.getId()).append("' and orgRange.ftype = 30");
        }
        return temp;
    }

    protected StringBuffer getOrgRangeSQL(int orgRangeType, UserInfo userInfo) {
        StringBuffer temp = new StringBuffer();
        temp.append("SELECT FOrgID").append(" FROM T_PM_OrgRange ").append(" WHERE FUserID = '").append(userInfo.getId()).append("' AND FType = ").append(10);
        return temp;
    }

    public UserInfo getTargetUser() {
        return this.targetUser;
    }

    protected abstract int getOrgRangeType();
}

